/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.FrmPadrao;
import jalis.comum.padroes.JanelaListener;
import jalis.servidor.Cliente;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class FrmCadPadraoNovo
extends FrmPadrao {
    protected JButton botaoSalvar;
    protected JButton botaoEditar;
    protected JButton botaoNovo;
    protected JButton botaoExcluir;
    protected JButton botaoCancelar;
    protected JButton botaoFechar;
    private int status;
    private long moduloAcesso = 0L;
    private long moduloInsere = 0L;
    private long moduloEdita = 0L;
    private long moduloApaga = 0L;
    protected JPanel painelTopo;
    private JPanel painelTopoCentro;
    private JLabel labelFormulario;
    private JLabel labelDescricao;
    private ImageIcon icone;
    private JLabel labelIcone;
    private JLabel labelFoto;
    private JLabel labelCabecalho = new JLabel(){

        @Override
        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
        }
    };
    private Image imagemFoto = null;
    private JPanel painelFormulario = new JPanel(new BorderLayout());
    private JPanel painelCabecalho = new JPanel(new GridBagLayout());
    private JPanel painelInferior = new JPanel(new GridBagLayout());
    protected JPanel painelBotoes = new JPanel(new BorderLayout());
    private JPanel painelBotoesEsquerda = new JPanel(new FlowLayout(0));
    private JPanel painelBotoesDireita = new JPanel(new FlowLayout(2));
    private JPanel painelLegenda = new JPanel(new FlowLayout(0, 0, 0){

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.layoutSize(target, true);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            Dimension minimum = this.layoutSize(target, false);
            minimum.width -= this.getHgap() + 1;
            return minimum;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension layoutSize(Container target, boolean preferred) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                Insets insets = target.getInsets();
                int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
                int maxWidth = target.getParent().getWidth() - horizontalInsetsAndGap;
                Dimension dim = new Dimension(0, 0);
                int rowWidth = 0;
                int rowHeight = 0;
                for (int i = 0; i < target.getComponentCount(); ++i) {
                    Dimension d;
                    Component m = target.getComponent(i);
                    if (!m.isVisible()) continue;
                    Dimension dimension = d = preferred ? m.getPreferredSize() : m.getMinimumSize();
                    if (rowWidth + d.width > maxWidth) {
                        this.addRow(dim, rowWidth, rowHeight);
                        rowWidth = 0;
                        rowHeight = 0;
                    }
                    if (rowWidth != 0) {
                        rowWidth += hgap;
                    }
                    rowWidth += d.width;
                    rowHeight = Math.max(rowHeight, d.height);
                }
                this.addRow(dim, rowWidth, rowHeight);
                dim.width += horizontalInsetsAndGap;
                dim.height += insets.top + insets.bottom + vgap * 2;
                return dim;
            }
        }

        private void addRow(Dimension dim, int rowWidth, int rowHeight) {
            dim.width = Math.max(dim.width, rowWidth);
            if (dim.height > 0) {
                dim.height += this.getVgap();
            }
            dim.height += rowHeight;
        }
    });
    protected JPanel painelCentral;
    private boolean cancelado = ParametrosGerais.getCodigoCliente() > 90000L;
    protected boolean flagDialogAberto = false;

    public void setFlagDialogAberto(boolean isAberto) {
        this.flagDialogAberto = isAberto;
        this.desabilitaMenus();
    }

    public void desabilitaMenus() {
    }

    public void addJanelaListener(JanelaListener l) {
        this.listenerList.add(JanelaListener.class, l);
    }

    public void removeJanelaListener(JanelaListener l) {
        this.listenerList.remove(JanelaListener.class, l);
    }

    public void setLabelFormulario(String newLabelFormulario) {
        this.labelFormulario.setText(newLabelFormulario);
    }

    public void setLabelDescricao(String newLabelDescricao) {
        this.labelDescricao.setText(newLabelDescricao);
    }

    public void setModuloAcesso(long modulo) {
        this.moduloAcesso = modulo;
        this.botaoFechar.setVisible(this.moduloAcesso == 0L || Acesso.getAcesso(this.moduloAcesso));
    }

    public void setModuloInsere(long modulo) {
        this.moduloInsere = modulo;
        this.botaoNovo.setVisible(this.moduloInsere == 0L || Acesso.getAcesso(this.moduloInsere));
        this.botaoSalvar.setVisible((this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita)) && !this.cancelado);
        this.botaoCancelar.setVisible(this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita));
        this.ocultarBotoesParaIntegracao();
        this.botaoNovo.setVisible(Cliente.getInstancia() != null && Cliente.getInstancia().getSocketEstacao().getSituacaoBloqueio() && this.botaoNovo.isVisible());
    }

    public void setModuloApaga(long modulo) {
        this.moduloApaga = modulo;
        this.botaoExcluir.setVisible(this.moduloApaga == 0L || Acesso.getAcesso(this.moduloApaga));
        this.ocultarBotoesParaIntegracao();
    }

    public void setModuloEdita(long modulo) {
        this.moduloEdita = modulo;
        this.botaoEditar.setVisible(this.moduloEdita == 0L || Acesso.getAcesso(this.moduloEdita));
        this.botaoSalvar.setVisible((this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita)) && !this.cancelado);
        this.botaoCancelar.setVisible(this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita));
    }

    public static long getModuloAcesso() {
        return -1L;
    }

    public void defineAcessos() {
    }

    public void setIcone(ImageIcon newIconePath) {
        if (newIconePath != null) {
            this.icone = newIconePath;
            this.labelIcone.setIcon(this.icone);
            this.labelIcone.revalidate();
        }
    }

    public void setFoto(ImageIcon image) {
        this.imagemFoto = image != null ? new ImageIcon(image.getImage().getScaledInstance(90, 80, 4)).getImage() : null;
        this.painelTopo.repaint();
    }

    public FrmCadPadraoNovo() {
        this.labelIcone = new JLabel("");
        this.labelIcone.setPreferredSize(new Dimension(90, 80));
        this.labelIcone.setHorizontalAlignment(0);
        this.labelFoto = new JLabel("");
        this.labelFoto.setPreferredSize(new Dimension(90, 80));
        this.labelFoto.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.painelCentral = new JPanel(null);
        this.painelTopo = new JPanel(new BorderLayout()){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                if (FrmCadPadraoNovo.this.imagemFoto != null) {
                    g.drawImage(FrmCadPadraoNovo.this.imagemFoto, this.getWidth() - FrmCadPadraoNovo.this.imagemFoto.getWidth(null), 0, null);
                }
            }
        };
        this.painelTopoCentro = new JPanel(new BorderLayout());
        this.painelTopoCentro.setOpaque(false);
        this.painelTopo.add((Component)this.painelTopoCentro, "Center");
        this.painelTopo.add((Component)this.labelIcone, "West");
        this.painelTopoCentro.add((Component)this.painelFormulario, "Center");
        this.painelTopoCentro.add((Component)this.painelCabecalho, "South");
        this.painelTopo.setBackground(Color.WHITE);
        this.painelTopo.setPreferredSize(new Dimension(100, 80));
        this.painelTopo.setFocusable(false);
        this.add((Component)this.painelTopo, "North");
        this.painelCentral.setFocusable(false);
        this.add((Component)this.painelCentral, "Center");
        this.add((Component)this.painelInferior, "South");
        this.painelCentral.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.montaPainelFormulario();
        this.montaPainelCabecalho();
        this.montaBotoes();
        this.setStatus(1);
        ScreenUtil.requisitarFoco(this);
    }

    private void montaPainelFormulario() {
        this.painelFormulario.setOpaque(false);
        this.labelFormulario = new JLabel("Descri\u00e7\u00e3o do formul\u00e1rio");
        this.labelDescricao = new JLabel("Descricao da a\u00e7\u00e3o da tela");
        this.labelDescricao.setFont(new Font("Dialog", 1, 10));
        this.labelFormulario.setFont(new Font("Dialog", 1, 20));
        JPanel panelAux = new JPanel();
        panelAux.setPreferredSize(new Dimension(10, 20));
        panelAux.setMinimumSize(new Dimension(10, 20));
        panelAux.setOpaque(false);
        this.painelFormulario.add((Component)panelAux, "North");
        this.painelFormulario.add((Component)this.labelFormulario, "Center");
        this.painelFormulario.add((Component)this.labelDescricao, "South");
    }

    private void montaPainelCabecalho() {
        this.painelCabecalho.setOpaque(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        c.fill = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.painelCabecalho.add((Component)this.labelCabecalho, c);
        this.labelCabecalho.setOpaque(false);
        this.labelCabecalho.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.5f));
        this.labelCabecalho.setHorizontalAlignment(4);
        Dimension d = new Dimension(0, 20);
        this.labelCabecalho.setPreferredSize(d);
        this.labelCabecalho.setMinimumSize(d);
    }

    private void montaBotoes() {
        this.painelInferior.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.painelInferior.add((Component)this.painelLegenda, c);
        ++c.gridy;
        this.painelInferior.add((Component)this.painelBotoes, c);
        this.painelBotoes.setFocusable(false);
        this.painelBotoesDireita.setFocusable(false);
        this.painelBotoesEsquerda.setFocusable(false);
        this.painelBotoes.add((Component)this.painelBotoesEsquerda, "West");
        this.painelBotoes.add((Component)this.painelBotoesDireita, "East");
        this.botaoNovo = new JButton("Novo");
        this.botaoNovo.setMnemonic('N');
        this.botaoEditar = new JButton("Editar");
        this.botaoEditar.setMnemonic('d');
        this.botaoSalvar = new JButton("Salvar");
        this.botaoSalvar.setMnemonic('S');
        this.botaoCancelar = new JButton("Cancelar");
        this.botaoCancelar.setMnemonic('C');
        this.botaoExcluir = new JButton("Excluir");
        this.botaoExcluir.setMnemonic('E');
        this.botaoFechar = new JButton("Fechar");
        this.botaoFechar.setMnemonic('F');
        this.painelBotoesDireita.add(this.botaoNovo);
        this.painelBotoesDireita.add(this.botaoEditar);
        this.painelBotoesDireita.add(this.botaoSalvar);
        this.painelBotoesDireita.add(this.botaoCancelar);
        this.painelBotoesDireita.add(this.botaoExcluir);
        this.painelBotoesDireita.add(this.botaoFechar);
        this.botaoNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.novo();
                }
            }
        });
        this.botaoEditar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.editar();
                }
            }
        });
        this.botaoSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.salvar();
                }
            }
        });
        this.botaoCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.cancelar();
                }
            }
        });
        this.botaoExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.excluir();
                }
            }
        });
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadraoNovo.this.flagDialogAberto) {
                    FrmCadPadraoNovo.this.fechar();
                    FrmCadPadraoNovo.this.fireFechouJanela();
                }
            }
        });
    }

    public void setStatus(int newStatus) {
        if (this.status != newStatus) {
            this.status = newStatus;
        }
        this.habilitaBotoes();
        if (this.status == 1 && this.botaoNovo.isEnabled()) {
            this.botaoNovo.grabFocus();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void habilitaBotoes() {
        this.botaoNovo.setEnabled(this.status == 1);
        this.botaoNovo.setFocusable(this.status == 1);
        this.botaoEditar.setEnabled(this.status == 1);
        this.botaoEditar.setFocusable(this.status == 1);
        this.botaoFechar.setEnabled(this.status == 1);
        this.botaoFechar.setFocusable(this.status == 1);
        this.botaoExcluir.setEnabled(this.status == 1);
        this.botaoExcluir.setFocusable(this.status == 1);
        this.botaoSalvar.setEnabled(this.status == 2 || this.status == 3);
        this.botaoSalvar.setFocusable(this.status == 2 || this.status == 3);
        this.botaoCancelar.setEnabled(this.status == 2 || this.status == 3 || this.status == 5);
        this.botaoCancelar.setFocusable(this.status == 2 || this.status == 3 || this.status == 5);
    }

    public abstract void novo();

    public abstract void salvar();

    public abstract void cancelar();

    public abstract void excluir();

    public abstract void editar();

    public abstract void fechar();

    public abstract boolean validaCampos();

    protected void fireFechouJanela() {
        JanelaListener[] ouvintes = (JanelaListener[])this.listenerList.getListeners(JanelaListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].fechouJanela();
        }
    }

    public abstract String getRetornoParaPesquisa();

    public abstract String getCampoRetornoParaPesquisa();

    public void ocultarBotoesParaIntegracao() {
        boolean integrando = ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W");
        this.botaoNovo.setVisible(this.botaoNovo.isVisible() && !integrando);
        this.botaoExcluir.setVisible(this.botaoExcluir.isVisible() && !integrando);
    }

    public void adicionaBotaoEsquerda(JButton botao) {
        this.painelBotoesEsquerda.add(botao);
    }

    public void removeBotaoEsquerda(JButton botao) {
        this.painelBotoesEsquerda.remove(botao);
    }

    public void adicionaBotaoDireita(JButton botao) {
        this.painelBotoesDireita.add(botao);
    }

    public void removeBotaoDireita(JButton botao) {
        this.painelBotoesDireita.remove(botao);
    }

    public void montaPanelLegenda(Color[] cores, String[] descricoes) {
        if (cores == null || descricoes == null || cores.length != descricoes.length) {
            return;
        }
        for (int i = 0; i < cores.length; ++i) {
            JPanel panelCor = new JPanel();
            panelCor.setPreferredSize(new Dimension(10, 10));
            panelCor.setMinimumSize(new Dimension(10, 10));
            panelCor.setBackground(cores[i]);
            panelCor.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            JLabel labelLegenda = new JLabel(descricoes[i]);
            Font font = new Font(labelLegenda.getFont().getName(), 0, 10);
            labelLegenda.setFont(font);
            JPanel panelAux = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridheight = 1;
            c.gridwidth = 1;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(0, 2, 0, 0);
            c.weightx = 0.0;
            c.weighty = 0.0;
            panelAux.add((Component)panelCor, c);
            ++c.gridx;
            c.insets = new Insets(0, 2, 0, 8);
            panelAux.add((Component)labelLegenda, c);
            this.painelLegenda.add(panelAux);
        }
    }

    public void setMensagemCabecalho(String mensagem) {
        if (Funcoes.textoVazio(mensagem)) {
            Dimension d = new Dimension(0, 20);
            this.labelCabecalho.setPreferredSize(d);
            this.labelCabecalho.setMinimumSize(d);
        } else {
            this.labelCabecalho.setText(mensagem);
            FontMetrics met = this.labelCabecalho.getFontMetrics(this.labelCabecalho.getFont());
            int width = met.stringWidth(mensagem);
            Dimension d = new Dimension(width + 10, 20);
            this.labelCabecalho.setPreferredSize(d);
            this.labelCabecalho.setMinimumSize(d);
        }
        this.labelCabecalho.repaint();
    }
}

