/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.FrmCadPadrao;
import jalis.model.AbstractThreadBean;
import jalis.service.AbstractThreadService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;

public abstract class FrmCadPadraoBean
extends FrmCadPadrao {
    protected AbstractThreadService service = null;
    protected AbstractThreadBean beanDelete = null;

    public FrmCadPadraoBean() {
        this.painelCentral.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
    }

    @Override
    public void cancelar() {
        if (Funcoes.mensagem(this, "As informa\u00e7\u00f5es adicionadas ser\u00e3o perdidas.", 4) == 0) {
            this.limparCampos();
            this.setStatus(1);
            this.controlaCampos();
        }
    }

    @Override
    public void editar() {
        this.limparCampos();
        AbstractThreadBean bean = this.pesquisar();
        if (bean != null) {
            this.setStatus(3);
            this.controlaCampos();
            this.preencherCampos(bean);
            this.painelCentral.grabFocus();
        }
    }

    @Override
    public void excluir() {
        this.beanDelete = this.pesquisar();
        if (this.beanDelete != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrmCadPadraoBean.this.preencherCampos(FrmCadPadraoBean.this.beanDelete);
                    if (Funcoes.mensagem(FrmCadPadraoBean.this, "Deseja excluir o registro selecionado?", 4) == 0) {
                        try {
                            FrmCadPadraoBean.this.service.gravaAutoCopiaSemCommit(FrmCadPadraoBean.this.beanDelete, 2, Variaveis.filialPadrao, FrmCadPadraoBean.this.getCopiaFiliais());
                            Conexao.arquivaSQL();
                        }
                        catch (Exception e) {
                            ErrorLogger.mostraMensagem(FrmCadPadraoBean.this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace(), "FrmCadPadraoBean:59");
                        }
                    }
                    FrmCadPadraoBean.this.limparCampos();
                    FrmCadPadraoBean.this.beanDelete = null;
                }
            });
        }
    }

    @Override
    public void fechar() {
        if (this.getStatus() == 1 || Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            this.setVisible(false);
        }
    }

    @Override
    public void novo() {
        this.limparCampos();
        this.setStatus(2);
        this.controlaCampos();
        this.painelCentral.grabFocus();
    }

    @Override
    public void salvar() {
        this.salvar(true);
    }

    public void salvar(boolean limparCampos) {
        AbstractThreadBean bean;
        if (this.validaCampos() && (bean = this.getBeanPreenchido()) != null) {
            try {
                this.service.gravaAutoCopiaSemCommit(bean, this.getStatus() == 2 ? 0 : 1, Variaveis.filialPadrao, this.getCopiaFiliais());
                Conexao.arquivaSQL();
                if (limparCampos) {
                    this.limparCampos();
                    this.setStatus(1);
                    this.controlaCampos();
                }
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this.getTopLevelAncestor(), e.getMessage(), e.getStackTrace());
            }
        }
    }

    protected abstract void controlaCampos();

    protected abstract void limparCampos();

    protected abstract AbstractThreadBean pesquisar();

    protected abstract AbstractThreadBean getBeanPreenchido();

    protected abstract void preencherCampos(AbstractThreadBean var1);

    protected abstract String getCopiaFiliais();
}

