/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.padroes.FrmPadrao;
import jalis.comum.padroes.JanelaListener;
import jalis.servidor.Cliente;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public abstract class FrmCadPadrao
extends FrmPadrao {
    protected JButton botaoSalvar;
    protected JButton botaoEditar;
    protected JButton botaoNovo;
    protected JButton botaoExcluir;
    protected JButton botaoCancelar;
    protected JButton botaoFechar;
    private int status;
    private long moduloAcesso = 0L;
    private long moduloInsere = 0L;
    private long moduloEdita = 0L;
    private long moduloApaga = 0L;
    protected JPanel painelTopo;
    private JPanel painelTopoCentro;
    private JLabel labelFormulario;
    private JLabel labelDescricao;
    private ImageIcon icone;
    private JLabel labelIcone;
    private JLabel labelFoto;
    protected JPanel painelBotoes;
    protected JPanel painelCentral;
    private boolean cancelado = ParametrosGerais.getCodigoCliente() > 90000L;
    protected boolean flagDialogAberto = false;

    public void setFlagDialogAberto(boolean isAberto) {
        this.flagDialogAberto = isAberto;
        this.desabilitaMenus();
    }

    public void desabilitaMenus() {
    }

    public void addJanelaListener(JanelaListener l) {
        this.listenerList.add(JanelaListener.class, l);
    }

    public void removeJanelaListener(JanelaListener l) {
        this.listenerList.remove(JanelaListener.class, l);
    }

    public void setLabelFormulario(String newLabelFormulario) {
        this.labelFormulario.setText(newLabelFormulario);
    }

    public void setLabelDescricao(String newLabelDescricao) {
        this.labelDescricao.setText(newLabelDescricao);
    }

    public void setModuloAcesso(long modulo) {
        this.moduloAcesso = modulo;
        this.botaoFechar.setVisible(this.moduloAcesso == 0L || Acesso.getAcesso(this.moduloAcesso));
    }

    public void setModuloInsere(long modulo) {
        this.moduloInsere = modulo;
        this.botaoNovo.setVisible(this.moduloInsere == 0L || Acesso.getAcesso(this.moduloInsere));
        this.botaoSalvar.setVisible((this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita)) && !this.cancelado);
        this.botaoCancelar.setVisible(this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita));
        this.ocultarBotoesParaIntegracao();
        this.botaoNovo.setVisible(Cliente.getInstancia() != null && Cliente.getInstancia().getSocketEstacao().getSituacaoBloqueio() && this.botaoNovo.isVisible());
    }

    public void setModuloApaga(long modulo) {
        this.moduloApaga = modulo;
        this.botaoExcluir.setVisible(this.moduloApaga == 0L || Acesso.getAcesso(this.moduloApaga));
        this.ocultarBotoesParaIntegracao();
    }

    public void setModuloEdita(long modulo) {
        this.moduloEdita = modulo;
        this.botaoEditar.setVisible(this.moduloEdita == 0L || Acesso.getAcesso(this.moduloEdita));
        this.botaoSalvar.setVisible((this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita)) && !this.cancelado);
        this.botaoCancelar.setVisible(this.moduloInsere == 0L || this.moduloEdita == 0L || Acesso.getAcesso(this.moduloInsere) || Acesso.getAcesso(this.moduloEdita));
    }

    public static long getModuloAcesso() {
        return -1L;
    }

    public void defineAcessos() {
    }

    public void setIcone(ImageIcon newIconePath) {
        if (newIconePath != null) {
            this.icone = newIconePath;
            this.labelIcone.setIcon(this.icone);
            this.labelIcone.revalidate();
        }
    }

    public void setFoto(ImageIcon image) {
        this.labelFoto.setBackground(Color.blue);
        if (image != null) {
            this.labelFoto.setIcon(new ImageIcon(image.getImage().getScaledInstance(90, 80, 4)));
        } else {
            this.labelFoto.setIcon(null);
        }
        this.labelFoto.revalidate();
        this.painelTopo.revalidate();
        this.painelTopo.repaint();
    }

    public FrmCadPadrao() {
        this.labelFormulario = new JLabel("Descri\u00e7\u00e3o do formul\u00e1rio");
        this.labelDescricao = new JLabel("Descricao da a\u00e7\u00e3o da tela");
        this.labelIcone = new JLabel("");
        this.labelIcone.setPreferredSize(new Dimension(90, 80));
        this.labelIcone.setHorizontalAlignment(0);
        this.labelFoto = new JLabel("");
        this.labelFoto.setPreferredSize(new Dimension(90, 80));
        this.labelFoto.setHorizontalAlignment(0);
        this.setLayout(new BorderLayout());
        this.painelBotoes = new JPanel(new FlowLayout(2));
        this.painelCentral = new JPanel(null);
        this.painelTopo = new JPanel(new BorderLayout());
        this.painelTopoCentro = new JPanel(new BorderLayout());
        this.painelTopo.add((Component)this.painelTopoCentro, "Center");
        this.painelTopo.add((Component)this.labelIcone, "West");
        if (this.labelFoto != null) {
            this.painelTopo.add((Component)this.labelFoto, "East");
        }
        JPanel p = ComponenteFactory.novoJPanelBorderLayout(new EmptyBorder(20, 0, 3, 5), (Component)this.labelFormulario, null, null, null, null);
        p.setBackground(Color.WHITE);
        this.painelTopoCentro.add((Component)p, "North");
        p = ComponenteFactory.novoJPanelBorderLayout(null, this.labelDescricao, null, null, null);
        p.setBackground(Color.WHITE);
        this.painelTopoCentro.add((Component)p, "Center");
        this.painelTopo.setBackground(Color.WHITE);
        this.painelTopo.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, new Color(255, 170, 0)));
        this.painelTopoCentro.setBackground(Color.BLUE);
        this.painelTopo.setPreferredSize(new Dimension(100, 80));
        this.labelDescricao.setFont(new Font("Arial", 0, 10));
        this.labelFormulario.setFont(new Font("Arial", 1, 22));
        this.painelTopo.setFocusable(false);
        this.add((Component)this.painelTopo, "North");
        this.painelCentral.setFocusable(false);
        this.painelCentral.setBorder(ScreenUtil.criarBordaVazia());
        this.add((Component)this.painelCentral, "Center");
        this.painelBotoes.setFocusable(false);
        this.add((Component)this.painelBotoes, "South");
        this.botaoNovo = new JButton("Novo");
        this.botaoNovo.setMnemonic('N');
        this.botaoEditar = new JButton("Editar");
        this.botaoEditar.setMnemonic('d');
        this.botaoSalvar = new JButton("Salvar");
        this.botaoSalvar.setMnemonic('S');
        this.botaoCancelar = new JButton("Cancelar");
        this.botaoCancelar.setMnemonic('C');
        this.botaoExcluir = new JButton("Excluir");
        this.botaoExcluir.setMnemonic('E');
        this.botaoFechar = new JButton("Fechar");
        this.botaoFechar.setMnemonic('F');
        this.painelBotoes.add(this.botaoNovo);
        this.painelBotoes.add(this.botaoEditar);
        this.painelBotoes.add(this.botaoSalvar);
        this.painelBotoes.add(this.botaoCancelar);
        this.painelBotoes.add(this.botaoExcluir);
        this.painelBotoes.add(this.botaoFechar);
        this.botaoNovo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.novo();
                }
            }
        });
        this.botaoEditar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.editar();
                }
            }
        });
        this.botaoSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.salvar();
                }
            }
        });
        this.botaoCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.cancelar();
                }
            }
        });
        this.botaoExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.excluir();
                }
            }
        });
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!FrmCadPadrao.this.flagDialogAberto) {
                    FrmCadPadrao.this.fechar();
                    FrmCadPadrao.this.fireFechouJanela();
                }
            }
        });
        this.setStatus(1);
        ScreenUtil.requisitarFoco(this);
    }

    public void setStatus(int newStatus) {
        if (this.status != newStatus) {
            this.status = newStatus;
        }
        this.habilitaBotoes();
        if (this.status == 1 && this.botaoNovo.isEnabled()) {
            this.botaoNovo.grabFocus();
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void habilitaBotoes() {
        this.botaoNovo.setEnabled(this.status == 1);
        this.botaoNovo.setFocusable(this.status == 1);
        this.botaoEditar.setEnabled(this.status == 1);
        this.botaoEditar.setFocusable(this.status == 1);
        this.botaoFechar.setEnabled(this.status == 1);
        this.botaoFechar.setFocusable(this.status == 1);
        this.botaoExcluir.setEnabled(this.status == 1);
        this.botaoExcluir.setFocusable(this.status == 1);
        this.botaoSalvar.setEnabled(this.status == 2 || this.status == 3);
        this.botaoSalvar.setFocusable(this.status == 2 || this.status == 3);
        this.botaoCancelar.setEnabled(this.status == 2 || this.status == 3 || this.status == 5);
        this.botaoCancelar.setFocusable(this.status == 2 || this.status == 3 || this.status == 5);
    }

    public abstract void novo();

    public abstract void salvar();

    public abstract void cancelar();

    public abstract void excluir();

    public abstract void editar();

    public abstract void fechar();

    public abstract boolean validaCampos();

    protected void fireFechouJanela() {
        JanelaListener[] ouvintes = (JanelaListener[])this.listenerList.getListeners(JanelaListener.class);
        for (int i = 0; i < ouvintes.length; ++i) {
            ouvintes[i].fechouJanela();
        }
    }

    public abstract String getRetornoParaPesquisa();

    public abstract String getCampoRetornoParaPesquisa();

    public void ocultarBotoesParaIntegracao() {
        boolean integrando = ParametrosGerais.getTipoIntegracao().equals("F") || ParametrosGerais.getTipoIntegracao().equals("W");
        this.botaoNovo.setVisible(this.botaoNovo.isVisible() && !integrando);
        this.botaoExcluir.setVisible(this.botaoExcluir.isVisible() && !integrando);
    }
}

