/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.padroes;

import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public abstract class AbstractDialogoOKCancelar
extends JDialog
implements ActionListener {
    private JPanel panelCentral;
    private JPanel panelBotoesEsquerda = null;
    private JPanel panelBotoesDireita = null;
    protected JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    protected JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    protected boolean ok = false;
    private boolean cancelado = false;
    private boolean usuarioPodeCancelar = true;

    public AbstractDialogoOKCancelar(Frame pai, String titulo) {
        super(pai, titulo, true);
        this.iniciar();
    }

    public boolean getCancelado() {
        return this.cancelado;
    }

    public AbstractDialogoOKCancelar(Dialog pai, String titulo) {
        super(pai, titulo, true);
        this.iniciar();
    }

    public boolean getOK() {
        return this.ok;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonOK || o == this.buttonCancelar) {
            boolean bl = this.ok = o == this.buttonOK;
            if (!this.ok && this.usuarioPodeCancelar) {
                this.cancelado = true;
                this.acaoCancelar();
                this.dispose();
            } else if (this.ok && this.acaoOk()) {
                this.dispose();
            }
        }
    }

    protected boolean acaoOk() {
        return true;
    }

    protected void acaoCancelar() {
        this.cancelado = true;
    }

    protected JPanel getPanelCentral() {
        return this.panelCentral;
    }

    protected JButton getBotaoOK() {
        return this.buttonOK;
    }

    protected JButton getBotaoCancelar() {
        return this.buttonCancelar;
    }

    protected JPanel getPanelBotoesEsquerda() {
        return this.panelBotoesEsquerda;
    }

    protected JPanel getPanelBotoesDireita() {
        return this.panelBotoesDireita;
    }

    private void iniciar() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        JPanel panelTemporario = new JPanel(new BorderLayout());
        panelTemporario.setBorder(ScreenUtil.criarBordaVazia());
        this.getContentPane().add((Component)panelTemporario, "Center");
        JPanel panelBotoesAux = new JPanel(new BorderLayout());
        panelTemporario.add((Component)panelBotoesAux, "South");
        this.panelBotoesEsquerda = ComponenteFactory.novoJPanelFlowLayout(0, new Component[0]);
        panelBotoesAux.add((Component)this.panelBotoesEsquerda, "West");
        this.panelBotoesDireita = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonOK, this.buttonCancelar);
        panelBotoesAux.add((Component)this.panelBotoesDireita, "East");
        this.panelCentral = new JPanel();
        panelTemporario.add(this.panelCentral);
        Funcoes.montaEnter((JComponent)this.getContentPane());
        this.setDefaultCloseOperation(0);
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(27, 0, true), "escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialogoOKCancelar.this.buttonCancelar.doClick();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (AbstractDialogoOKCancelar.this.usuarioPodeCancelar) {
                    AbstractDialogoOKCancelar.this.dispose();
                }
            }
        });
    }

    public boolean isUsuarioPodeCancelar() {
        return this.usuarioPodeCancelar;
    }

    public void setUsuarioPodeCancelar(boolean usuarioPodeCancelar) {
        this.usuarioPodeCancelar = usuarioPodeCancelar;
    }
}

