/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao.util;

import jalis.comum.Conexao;
import jalis.comum.informacao.InfoRequisicaoTermoConsentimento;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.resultados.DialogoVisualizarResultadoPdf;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTable;

public class ButtonVisualizarPDF
extends DefaultCellEditor {
    private JButton button;
    private ModeloGridTable modelo;
    private InfoRequisicaoTermoConsentimento pai;
    private String codigoFilial;
    private String codigo;
    private boolean buscaPorPaciente;
    int linha = -1;

    public ButtonVisualizarPDF(ModeloGridTable modelo, InfoRequisicaoTermoConsentimento pai, String codigoFilial, String codigo, boolean buscaPorPaciente) {
        super(new JCheckBox());
        this.modelo = modelo;
        this.pai = pai;
        this.codigoFilial = codigoFilial;
        this.codigo = codigo;
        this.buscaPorPaciente = buscaPorPaciente;
        this.button = new JButton();
        this.button.setOpaque(true);
        Funcoes.imagemPesquisa(this.button);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonVisualizarPDF.this.fireEditingStopped();
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.linha = row;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.linha > -1) {
            try {
                String layoutRelatorio = this.getLayoutRelatorio();
                if (StringUtil.isEmpty(layoutRelatorio)) {
                    Funcoes.mensagem(Laboratorio.getInstancia(), "Layout do PDF n\u00e3o localizado", 1);
                } else {
                    DialogoVisualizarResultadoPdf pdf = DialogoVisualizarResultadoPdf.novaInstancia(this.pai, true);
                    pdf.setTitle("Termo de Consentimento");
                    Statement st = Conexao.getStatement();
                    pdf.setPDf(layoutRelatorio);
                    pdf.setVisible(true);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel carregar o layout do pdf", e.getStackTrace());
            }
        }
        return null;
    }

    private String getLayoutRelatorio() throws SQLException {
        int quantidade = -1;
        String layout = "";
        StringBuilder builder = new StringBuilder();
        builder.append("select rtc_copiaimpressa from requisicaotermoconsentimento ");
        builder.append(this.buscaPorPaciente ? " where pac_codigo = " : " where req_codigo = ");
        builder.append(this.codigo);
        builder.append(" order by rtc_datahoraimpressao desc");
        ResultSet rs = Conexao.executeQuery(Conexao.getStatement(), builder.toString());
        while (rs.next()) {
            if (++quantidade != this.linha) continue;
            layout = rs.getString("rtc_copiaimpressa");
            return layout;
        }
        return "";
    }

    @Override
    public boolean stopCellEditing() {
        this.linha = -1;
        return super.stopCellEditing();
    }

    @Override
    protected void fireEditingStopped() {
        super.fireEditingStopped();
    }

    public void setCodigoFilial(String codigoFilial) {
        this.codigoFilial = codigoFilial;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setLinha(int linha) {
        this.linha = linha;
    }
}

