/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.informacao.InfoRequisicao;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RequisicoesAnteriores
extends JDialog
implements ActionListener {
    private final int COLUNA_EXAMES = 3;
    private JButton buttonVisualizar = ComponenteFactory.novoJButton("Visualizar", 'V', this, null, null);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this, null, null);
    private ModeloGridTable modeloRequisicoes = new ModeloGridTable(new String[]{"Filial", "C\u00f3digo", "Data"});
    private ModeloGridTable modeloExames = new ModeloGridTable(new String[]{"C\u00f3digo", "Mat.", "Exame"});
    private JTable tableRequisicoes = new JTable(this.modeloRequisicoes);
    private JScrollPane scrollRequisicoes = new JScrollPane(this.tableRequisicoes);
    private JTable tableExames = new JTable(this.modeloExames);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private boolean ok = false;
    private String codigoFilial;

    public RequisicoesAnteriores(JDialog owner, String filial) {
        super((Dialog)owner, "Anteriores");
        this.setModal(true);
        this.setSize(new Dimension(520, 350));
        this.setLocationRelativeTo(owner);
        ((JPanel)this.getContentPane()).setBorder(ScreenUtil.criarBordaVazia());
        this.codigoFilial = filial;
        this.modeloRequisicoes.setColumnSize(new int[]{0, 65, 75}, this.tableRequisicoes);
        this.modeloExames.setColumnSize(new int[]{70, 50, 0}, this.tableExames);
        this.tableRequisicoes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RequisicoesAnteriores.this.modeloRequisicoes.getValueAt(RequisicoesAnteriores.this.tableRequisicoes.getSelectedRow(), 3) != null) {
                    Registro[] registros;
                    RequisicoesAnteriores.this.modeloExames.clear();
                    for (Registro r : registros = (Registro[])RequisicoesAnteriores.this.modeloRequisicoes.getValueAt(RequisicoesAnteriores.this.tableRequisicoes.getSelectedRow(), 3)) {
                        RequisicoesAnteriores.this.modeloExames.addLine(new String[]{r.getString("exa_codigo"), r.getString("mco_abreviatura"), r.getString("exa_descricao")});
                    }
                }
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        this.add((Component)this.scrollRequisicoes, c);
        c.gridx = 1;
        c.weighty = 1.0;
        this.add((Component)this.scrollExames, c);
        c.gridy = 1;
        c.gridwidth = 2;
        c.fill = 2;
        c.weighty = 0.0;
        JPanel p = new JPanel(new FlowLayout(2));
        p.add(this.buttonVisualizar);
        p.add(this.buttonCancelar);
        this.add((Component)p, c);
    }

    public boolean getOK() {
        return this.ok;
    }

    public String getRequisicao() {
        if (this.tableRequisicoes.getSelectedRow() > -1) {
            return this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 1).toString();
        }
        return "";
    }

    public String getFilial() {
        if (this.tableRequisicoes.getSelectedRow() > -1) {
            return this.modeloRequisicoes.getValueAt(this.tableRequisicoes.getSelectedRow(), 0).toString();
        }
        return "";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.ok = e.getSource() == this.buttonVisualizar;
        this.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCodigoPesquisa(String paciente, String requisicao) {
        if (Funcoes.textoVazio(paciente)) {
            return;
        }
        boolean requisicoesAnteriores = Acesso.getAcesso(InfoRequisicao.ACESSO_REQUISICOES_ANTERIORES_FILIAIS);
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select fil_codigo, req_codigo, req_data from requisicao where ");
        if (requisicoesAnteriores) {
            String filiais = StringUtil.getValor(ParametrosGerais.getCopiaPaciente(), "filiais");
            buf.append(" fil_codigo in (").append(filiais).append(") ");
        } else {
            buf.append("fil_codigo = ").append(this.codigoFilial);
        }
        buf.append(" and pac_codigo = ").append(paciente);
        buf.append(" and coalesce(req_excluida, false) = false ");
        buf.append(" order by req_codigo ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                if (rs.getString("req_codigo").equalsIgnoreCase(requisicao)) continue;
                this.modeloRequisicoes.addLine(new Object[]{rs.getString("fil_codigo"), rs.getString("req_codigo"), Funcoes.formataData("dd/MM/yyyy", rs.getDate("req_data")), this.pegaExamesRequisicao(st2, rs.getString("req_codigo"))});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "RequisicoesAnteriores (1992)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
    }

    private Registro[] pegaExamesRequisicao(Statement st, String requisicao) throws Exception {
        StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, a.mco_codigo, c.mco_abreviatura ");
        buf.append("from examerequisicao a ");
        buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
        buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
        buf.append("where a.fil_codigo = ").append(this.codigoFilial);
        buf.append(" and a.req_codigo = ").append(requisicao);
        buf.append(" and a.exr_excluido = false ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        return Registro.getRegistros(rs);
    }
}

