/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.sql.Statement;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

class Observacao
extends JDialog {
    private JTextArea textObs = new JTextArea();
    private JScrollPane scrollObs = new JScrollPane(this.textObs);
    private JTextArea textRecoleta = new JTextArea();
    private JScrollPane scrollRecoleta = new JScrollPane(this.textRecoleta);
    private JLabel labelRecoletaMotivo = new JLabel();
    private JPanel painel = new JPanel();
    private JLabel motivo = new JLabel("Motivo:");
    private JLabel justificativa = new JLabel("Justificativa:");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JButton buttonSalvar = new JButton("Salvar");
    private JButton buttonFechar = new JButton("Fechar");
    private String requisicao = "";
    private String exame = "";
    private String material = "";
    private boolean isOK = false;
    private String codigoFilial;
    private boolean naoVisualizarMotivoRecoleta = false;
    private JTabbedPane tabbed = new JTabbedPane();

    public Observacao(Dialog owner, String filial, boolean naoVisualizarMotivoRecoleta, String motivoRecoletaCombo) {
        super(owner);
        this.setSize(new Dimension(owner.getWidth(), 250));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setResizable(false);
        this.codigoFilial = filial;
        this.naoVisualizarMotivoRecoleta = naoVisualizarMotivoRecoleta;
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbed, "West");
        this.add((Component)this.panelBotoes, "South");
        this.panelBotoes.add(this.buttonSalvar);
        this.panelBotoes.add(this.buttonFechar);
        this.scrollObs.setPreferredSize(new Dimension(owner.getWidth() - 10, 22));
        this.tabbed.add((Component)this.scrollObs, "Observa\u00e7\u00f5es");
        this.painel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridy = 0;
        this.motivo.setPreferredSize(new Dimension(45, 22));
        this.painel.add((Component)this.motivo, c);
        c.fill = 2;
        this.painel.add((Component)this.labelRecoletaMotivo, c);
        ++c.gridy;
        c.gridwidth = 2;
        this.justificativa.setPreferredSize(new Dimension(330, 22));
        this.painel.add((Component)this.justificativa, c);
        c.gridwidth = 3;
        c.gridy = 2;
        c.fill = 1;
        c.weighty = 1.0;
        this.scrollRecoleta.setPreferredSize(new Dimension(owner.getWidth() - 10, 22));
        this.painel.add((Component)this.scrollRecoleta, c);
        if (!Acesso.getAcesso(Long.parseLong("0000200010"))) {
            if (motivoRecoletaCombo != null || !Funcoes.textoVazio(motivoRecoletaCombo)) {
                this.tabbed.add((Component)this.painel, "Recoleta");
            } else {
                this.tabbed.add((Component)this.scrollRecoleta, "Recoleta");
            }
        }
        this.buttonSalvar.setMnemonic('S');
        this.buttonFechar.setMnemonic('F');
        this.textObs.setWrapStyleWord(true);
        this.textObs.setLineWrap(true);
        this.textRecoleta.setWrapStyleWord(true);
        this.textRecoleta.setLineWrap(true);
        this.textRecoleta.setEditable(false);
        UIManager.put("ComboBox.disabledBackground", 3);
        UIManager.put("ComboBox.disabledForeground", Color.black);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Observacao.this.setVisible(false);
            }
        });
        this.buttonSalvar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Statement st = Conexao.getStatement();
                    StringBuffer buf = new StringBuffer("update examerequisicao set exr_obs = '");
                    buf.append(StringUtil.textoDB(StringUtil.trataCaracteresEspeciais(Observacao.this.textObs.getText())));
                    buf.append("' where fil_codigo = ");
                    buf.append(Observacao.this.codigoFilial);
                    buf.append(" and req_codigo = ");
                    buf.append(Observacao.this.requisicao);
                    buf.append(" and exa_codigo = '");
                    buf.append(StringUtil.textoDB(Observacao.this.exame));
                    buf.append("' and mco_codigo = ");
                    buf.append(Observacao.this.material);
                    Conexao.execute(Observacao.this.codigoFilial, st, buf.toString());
                    Conexao.arquivaSQL();
                    Observacao.this.isOK = true;
                }
                catch (SQLException ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(Observacao.this, ex.getMessage(), ex.getStackTrace(), "InfoRequisicao");
                }
                Observacao.this.setVisible(false);
            }
        });
        this.buttonSalvar.setVisible(Acesso.getAcesso(Long.parseLong("0000200001")));
    }

    public void setExame(String requisicao, String exame, String descricao, String material) {
        this.requisicao = requisicao;
        this.exame = exame;
        this.material = material;
        if (this.naoVisualizarMotivoRecoleta) {
            this.setTitle("Observa\u00e7\u00e3o: [" + exame + "] " + descricao);
        } else {
            this.setTitle("Observa\u00e7\u00e3o/Recoleta: [" + exame + "] " + descricao);
        }
    }

    public void setObs(String obs) {
        this.textObs.setText(obs);
    }

    public void setMotivoRecoleta(String motivo) {
        this.textRecoleta.setText(motivo);
    }

    public void setMotivoRecoletaCombo(String motivoRecoletaCombo) {
        this.labelRecoletaMotivo.setText(motivoRecoletaCombo);
    }

    public boolean isOK() {
        return this.isOK;
    }

    public String getObs() {
        return this.textObs.getText();
    }
}

