/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Conexao;
import jalis.comum.informacao.TiposBaseWeb;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.List;
import java.sql.ResultSet;
import java.sql.Statement;

public class InfoVisualizacaoWeb
extends AbstractDialogoOKCancelar {
    private List lista = new List();

    public static InfoVisualizacaoWeb novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new InfoVisualizacaoWeb((Frame)pai);
        }
        return new InfoVisualizacaoWeb((Dialog)pai);
    }

    public InfoVisualizacaoWeb(Dialog pai) {
        super(pai, "Visualiza\u00e7\u00e3o Web");
        this.montaTela();
    }

    public InfoVisualizacaoWeb(Frame pai) {
        super(pai, "Visualiza\u00e7\u00e3o Web");
        this.montaTela();
    }

    private void montaTela() {
        this.getBotaoOK().setVisible(false);
        this.getBotaoCancelar().setText("Fechar");
        this.getBotaoCancelar().setMnemonic('F');
        this.setSize(new Dimension(300, 380));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setLayout(new BorderLayout());
        this.add(this.getPanelCentral().add(this.lista), "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    public boolean carregarDados(String codigoFilial, String codigoRequisicao) {
        boolean possuiAcesso = false;
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select rvi_datahora, rvi_tipoacesso");
            buf.append(" from requisicaovisualizada where fil_codigo = ").append(codigoFilial);
            buf.append(" and req_codigo = ").append(codigoRequisicao);
            buf.append(" order by rvi_datahora");
            Statement st = Conexao.getStatement();
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            FilialVOAux filial = new FilialService().buscaFilial(codigoFilial);
            this.lista.removeAll();
            this.lista.setFont(this.getFont());
            while (rs.next()) {
                possuiAcesso = true;
                StringBuilder b = new StringBuilder();
                b.append(Funcoes.formataData("dd/MM/yyyy HH:mm", rs.getTimestamp("rvi_datahora")));
                b.append(" por ");
                String tipoAcesso = this.getTipoAcesso(TiposBaseWeb.getTipo(rs.getInt("rvi_tipoacesso")), filial);
                b.append(tipoAcesso);
                this.lista.add(b.toString());
            }
            this.lista.getParent().setFont(new Font(this.lista.getParent().getFont().getName(), 1, this.lista.getParent().getFont().getSize()));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "InfoVisualizacaoWeb");
        }
        return possuiAcesso;
    }

    private String getTipoAcesso(TiposBaseWeb tiposBaseWeb, FilialVOAux filial) throws Exception {
        String tipoAcesso = "";
        switch (tiposBaseWeb) {
            case PACIENTE: {
                tipoAcesso = filial.getTipoBase().equals("A") ? "Empresa" : "Paciente";
                break;
            }
            case MEDICO: {
                tipoAcesso = filial.getTipoBase().equals("A") ? "Coletador" : "M\u00e9dico";
                break;
            }
            default: {
                tipoAcesso = tiposBaseWeb.getDescricao();
            }
        }
        return tipoAcesso;
    }
}

