/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;

public class InfoSenhaWeb
extends AbstractDialogoOKCancelar {
    private JTextPane textSenha = new JTextPane();
    private JTextArea textProibidoWeb = new JTextArea();
    private JButton botaoEnviarEmail = new JButton("Enviar E-mail");
    private JButton botaoEnviarSMS = new JButton("Enviar SMS");
    private JButton botaoEnviarWhatsapp = new JButton("Enviar WhatsApp");
    private boolean enviarEmail = false;
    private boolean enviarSMS = false;
    private boolean enviarWhatsapp = false;
    private String titulo;

    public static InfoSenhaWeb novaInstancia(Object pai, String titulo, String mensagem, String mensagemProibidoWeb) {
        if (pai instanceof Frame) {
            return new InfoSenhaWeb((Frame)pai, titulo, mensagem, mensagemProibidoWeb);
        }
        return new InfoSenhaWeb((Dialog)pai, titulo, mensagem, mensagemProibidoWeb);
    }

    public InfoSenhaWeb(Dialog pai, String titulo, String mensagem, String mensagemProibidoWeb) {
        super(pai, "Senha Web");
        this.titulo = titulo;
        this.montaTela(mensagem, mensagemProibidoWeb);
    }

    public InfoSenhaWeb(Frame pai, String titulo, String mensagem, String mensagemProibidoWeb) {
        super(pai, "Senha Web");
        this.titulo = titulo;
        this.montaTela(mensagem, mensagemProibidoWeb);
    }

    private void montaTela(String mensagem, String mensagemProibidoWeb) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new TitledBorder(this.titulo));
        ScreenUtil.setBorda(new Component[]{this.textSenha}, new TitledBorder(""));
        this.textSenha.setEditable(false);
        panel.add(this.textSenha);
        StringBuilder str = new StringBuilder(mensagem);
        str.append("\n ");
        JLabel label = new JLabel(mensagemProibidoWeb);
        label.setForeground(Color.red);
        panel.add(this.textSenha);
        this.textSenha.setText(str.toString());
        label.setAlignmentY(-7.0f);
        this.textSenha.insertComponent(label);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add(this.getPanelCentral().add(panel), "Center");
        this.getBotaoOK().setVisible(false);
        this.setSize(new Dimension(600, 180));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.getBotaoCancelar().setText("Fechar");
        this.getBotaoCancelar().setMnemonic('F');
        JPanel panel2 = new JPanel(new BorderLayout());
        this.textProibidoWeb.setEditable(false);
        this.textProibidoWeb.setText(mensagemProibidoWeb);
        this.getPanelBotoesDireita().setLayout(new FlowLayout(2));
        this.getPanelBotoesDireita().setPreferredSize(new Dimension(200, 35));
        panel2.add((Component)this.getPanelBotoesDireita(), "Center");
        panel.add(this.getPanelCentral().add(panel2), "South");
        ScreenUtil.centralizar(this);
        this.montaListener();
        this.repaint();
    }

    private void montaListener() {
        this.botaoEnviarEmail.addActionListener(action -> {
            this.enviarEmail = true;
            this.dispose();
        });
        this.botaoEnviarSMS.addActionListener(action -> {
            this.enviarSMS = true;
            this.dispose();
        });
        this.botaoEnviarWhatsapp.addActionListener(action -> {
            this.enviarWhatsapp = true;
            this.dispose();
        });
    }

    public void enviarEmail(boolean visualizar) {
        if (visualizar) {
            this.getPanelBotoesDireita().add(this.botaoEnviarEmail);
        }
    }

    public void enviarSMS(boolean visualizar) {
        if (visualizar) {
            this.getPanelBotoesDireita().add(this.botaoEnviarSMS);
        }
    }

    public void enviarWhatsapp(boolean visualizar) {
        if (visualizar) {
            this.getPanelBotoesDireita().add(this.botaoEnviarWhatsapp);
        }
    }

    public void adicionarBotaoFechar() {
        this.getPanelBotoesDireita().add(this.getBotaoCancelar());
    }

    public boolean isEnviarEmail() {
        return this.enviarEmail;
    }

    public void setEnviarEmail(boolean enviarEmail) {
        this.enviarEmail = enviarEmail;
    }

    public boolean isEnviarSMS() {
        return this.enviarSMS;
    }

    public void setEnviarSMS(boolean enviarSMS) {
        this.enviarSMS = enviarSMS;
    }

    public boolean isEnviarWhatsapp() {
        return this.enviarWhatsapp;
    }

    public void setEnviarWhatsapp(boolean enviarWhatsapp) {
        this.enviarWhatsapp = enviarWhatsapp;
    }
}

