/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Conexao;
import jalis.comum.informacao.util.ButtonVisualizarPDF;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.estoque.util.ButtonRenderer;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class InfoRequisicaoTermoConsentimento
extends AbstractDialogoOKCancelar {
    private static int COLUNA_PDF;
    private ModeloGridTable modeloTermo;
    private JTable tableTermo = null;
    private JScrollPane scrollTermo = null;
    ButtonVisualizarPDF buttonEditor = null;
    private JButton buttonTC = ComponenteFactory.novoJButton(new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }, new Dimension(20, 20), new Dimension(20, 20), true);
    private boolean ok = false;
    private String codigoFilial;
    private boolean buscaPorPaciente;

    public InfoRequisicaoTermoConsentimento(JDialog owner, String filial, String codigoRequisicao, boolean buscaPorPaciente) {
        super((Dialog)owner, "Termo de consentimento");
        this.buscaPorPaciente = buscaPorPaciente;
        this.montaTela(filial, codigoRequisicao);
    }

    public InfoRequisicaoTermoConsentimento(JFrame owner, String filial, String codigoRequisicao, boolean buscaPorPaciente) {
        super((Frame)owner, "Termo de consentimento");
        this.buscaPorPaciente = buscaPorPaciente;
        this.montaTela(filial, codigoRequisicao);
    }

    private void montaTela(final String filial, final String codigo) {
        int[] nArray;
        this.getBotaoOK().setVisible(false);
        this.setSize(this.buscaPorPaciente ? new Dimension(720, 400) : new Dimension(520, 400));
        COLUNA_PDF = this.buscaPorPaciente ? 5 : 3;
        this.modeloTermo = this.buscaPorPaciente ? new ModeloGridTable(new String[]{"Data/hora Impress\u00e3o", "Usu\u00e1rio", "Filial", "C\u00f3digo", "Modelo", "TC"}) : new ModeloGridTable(new String[]{"Data/hora Impress\u00e3o", "Usu\u00e1rio", "Modelo", "TC"});
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setIconImage(ImagemUtils.carregaImagemJalis("icone64x64.png").getImage());
        this.getBotaoCancelar().setText("Fechar");
        this.getBotaoCancelar().setMnemonic('F');
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        this.buttonEditor = new ButtonVisualizarPDF(this.modeloTermo, this, filial, codigo, this.buscaPorPaciente);
        this.tableTermo = new JTable(this.modeloTermo){

            @Override
            public Class<?> getColumnClass(int column) {
                if (column == COLUNA_PDF) {
                    return Set.class;
                }
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == COLUNA_PDF;
            }
        };
        this.tableTermo.getTableHeader().addMouseListener(this.modeloTermo);
        this.tableTermo.setDefaultRenderer(Set.class, buttonRenderer);
        this.tableTermo.setDefaultEditor(Set.class, this.buttonEditor);
        this.tableTermo.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (InfoRequisicaoTermoConsentimento.this.tableTermo.getSelectedRow() > -1) {
                    InfoRequisicaoTermoConsentimento.this.buttonEditor.setCodigoFilial(InfoRequisicaoTermoConsentimento.this.buscaPorPaciente ? (String)InfoRequisicaoTermoConsentimento.this.modeloTermo.getValueAt(InfoRequisicaoTermoConsentimento.this.tableTermo.getSelectedRow(), 2) : filial);
                    InfoRequisicaoTermoConsentimento.this.buttonEditor.setCodigo(codigo);
                }
            }
        });
        if (this.buscaPorPaciente) {
            int[] nArray2 = new int[6];
            nArray2[0] = 140;
            nArray2[1] = 120;
            nArray2[2] = 50;
            nArray2[3] = 50;
            nArray2[4] = 300;
            nArray = nArray2;
            nArray2[5] = 0;
        } else {
            int[] nArray3 = new int[4];
            nArray3[0] = 140;
            nArray3[1] = 120;
            nArray3[2] = 200;
            nArray = nArray3;
            nArray3[3] = 0;
        }
        this.modeloTermo.setColumnSize(nArray, this.tableTermo);
        Statement st = Conexao.getStatement();
        try {
            Registro[] registros;
            for (Registro reg : registros = this.carregaTermo(st, codigo, filial)) {
                if (!this.buscaPorPaciente) {
                    this.modeloTermo.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", reg.getDate("rtc_datahoraimpressao")), reg.getString("usr_codigo"), reg.getString("mtc_descricao"), ""});
                    continue;
                }
                this.modeloTermo.addLine(new Object[]{Funcoes.formataData("dd/MM/yyyy HH:mm", reg.getDate("rtc_datahoraimpressao")), reg.getString("usr_codigo"), reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("mtc_descricao"), ""});
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "InfoRequisicaoTermoConsentimento (45)");
        }
        this.scrollTermo = new JScrollPane(this.tableTermo);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(this.scrollTermo);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add(this.getPanelCentral().add(panel), "Center");
        this.add((Component)this.getPanelBotoesDireita(), "South");
    }

    private Registro[] carregaTermo(Statement st, String requisicao, String codigoFilial) throws Exception {
        StringBuilder buf = new StringBuilder();
        if (!this.buscaPorPaciente) {
            buf.append("select r.rtc_codigo, r.rtc_datahoraimpressao, r.usr_codigo, t.mtc_descricao ");
        } else {
            buf.append("select r.rtc_datahoraimpressao, r.usr_codigo, t.mtc_descricao, r.fil_codigo, r.req_codigo ");
        }
        buf.append(" from requisicaotermoconsentimento r ");
        buf.append("  left join termoconsentimento t on t.fil_codigo = r.fil_codigo and t.mtc_codigo = r.mtc_codigo ");
        if (!this.buscaPorPaciente) {
            buf.append(" where r.fil_codigo = ").append(codigoFilial);
            buf.append(" and r.req_codigo = ").append(requisicao);
        } else {
            buf.append(" where r.pac_codigo = ").append(requisicao);
        }
        buf.append(" order by r.rtc_datahoraimpressao desc");
        ResultSet rs = Conexao.executeQuery(st, buf);
        return Registro.getRegistros(rs);
    }
}

