/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Variaveis;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.comum.informacao.InfoExame;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ExameUtil;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class InfoPrincipios
extends JDialog
implements ActionListener,
DisposeListener {
    ModeloInfoPrincipios modelo = new ModeloInfoPrincipios();
    JTextPane textMensagem = new JTextPane();
    JTable tabela = new JTable(this.modelo);
    JScrollPane scrollTabela = new JScrollPane(this.tabela);
    JScrollPane scrollMensagem = new JScrollPane(this.textMensagem);
    JPanel panelArea = new JPanel(new BorderLayout());
    JPanel panelBotoes = new JPanel(new BorderLayout());
    JPanel panelBotoesEsq = new JPanel(new FlowLayout(0));
    JPanel panelBotoesDir = new JPanel(new FlowLayout(2));
    JButton buttonInfoExa = new JButton("Info. Exame");
    JButton buttonFechar = new JButton("Fechar");
    DadosExames dadosExame;

    public static InfoPrincipios novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new InfoPrincipios((Frame)pai, "Dados cl\u00ednicos", true);
        }
        if (pai instanceof Dialog) {
            return new InfoPrincipios((Dialog)pai, "Dados cl\u00ednicos", true);
        }
        return null;
    }

    public InfoPrincipios(Frame pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        if (pai instanceof Laboratorio) {
            ((Laboratorio)pai).addDisposeListener(this);
        }
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    public InfoPrincipios(Dialog pai, String titulo, boolean modal) {
        super(pai, titulo, modal);
        this.iniciar();
        ScreenUtil.centralizar(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        InfoExame infExa;
        Object o = e.getSource();
        if (o == this.buttonFechar) {
            this.dispose();
        } else if (o == this.buttonInfoExa && (infExa = InfoExame.novaInstancia(this)) != null) {
            infExa.setExame(this.dadosExame);
            infExa.setVisible(true);
        }
    }

    public void setDadosPrincipio(List<Registro> reg) {
        try {
            if (null != reg && reg.size() > 0) {
                Registro r = reg.get(0);
                this.dadosExame = ExameUtil.getDadosExame(Variaveis.filialPadrao, r.getString("exa_codigo"), new DadosMaterial(r.getInt("mco_codigo"), "", false, false));
                this.modelo.setRegistros(reg);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
    }

    private void iniciar() {
        this.setSize(new Dimension(600, 500));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.panelArea, "Center");
        this.getContentPane().add((Component)this.panelBotoes, "South");
        this.panelArea.add((Component)this.scrollTabela, "North");
        this.panelArea.add((Component)this.scrollMensagem, "Center");
        this.panelBotoes.setPreferredSize(new Dimension(10, 30));
        this.panelBotoes.add((Component)this.panelBotoesEsq, "West");
        this.panelBotoes.add((Component)this.panelBotoesDir, "East");
        this.panelBotoesEsq.setPreferredSize(new Dimension(120, 10));
        this.panelBotoesEsq.add(this.buttonInfoExa);
        this.panelBotoesDir.setPreferredSize(new Dimension(100, 10));
        this.panelBotoesDir.add(this.buttonFechar);
        this.textMensagem.setContentType("text/html");
        this.textMensagem.setEditable(false);
        this.scrollTabela.setPreferredSize(new Dimension(10, 150));
        this.tabela.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                InfoPrincipios.this.textMensagem.setText(InfoPrincipios.this.modelo.getTexto(InfoPrincipios.this.tabela.getSelectedRow()));
            }
        });
        this.buttonFechar.addActionListener(this);
        this.buttonInfoExa.addActionListener(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (InfoPrincipios.this.tabela.getRowCount() > 0) {
                    InfoPrincipios.this.tabela.setRowSelectionInterval(0, 0);
                }
            }
        });
    }

    private class ModeloInfoPrincipios
    extends AbstractTableModel {
        private String[] cols = new String[]{"Princ\u00edpio", "Medicamento"};
        private String[][] dados = new String[0][];

        private ModeloInfoPrincipios() {
        }

        public void setRegistros(List<Registro> reg) {
            if (reg != null) {
                ArrayList<String[]> a = new ArrayList<String[]>();
                for (Registro r : reg) {
                    a.add(new String[]{r.getString("prc_descricao"), r.getString("mto_descricao"), this.montaTexto(r)});
                }
                this.dados = (String[][])a.toArray((T[])new String[a.size()][]);
                this.fireTableDataChanged();
            }
        }

        public String getTexto(int linha) {
            if (linha >= 0 && linha < this.dados.length && this.dados[linha].length == 3) {
                return this.dados[linha][2];
            }
            return "";
        }

        private String montaTexto(Registro reg) {
            StringBuilder bui = new StringBuilder("<html><body>");
            try {
                bui.append("<b>Princ\u00edpio:</b> ");
                String tmp = reg.getString("prc_descricao");
                bui.append(tmp == null || tmp.trim().length() == 0 ? "" : tmp);
                bui.append("<br><b>Medicamento:</b> ");
                tmp = reg.getString("mto_descricao");
                bui.append(tmp == null || tmp.trim().length() == 0 ? "" : tmp);
                if (reg.getBoolean("exp_diminuif")) {
                    bui.append("<br>Diminui\u00e7\u00e3o Fisiol\u00f3gica");
                }
                if (reg.getBoolean("exp_diminuia")) {
                    bui.append("<br>Diminui\u00e7\u00e3o Anal\u00edtica");
                }
                if (reg.getBoolean("exp_aumentof")) {
                    bui.append("<br>Aumento Filiol\u00f3gico");
                }
                if (reg.getBoolean("exp_aumentoa")) {
                    bui.append("<br>Aumento Anal\u00edtico");
                }
                bui.append("<p><b>Intera\u00e7\u00f5es Medicamentosas:</b><br>");
                tmp = reg.getString("mto_interacao");
                bui.append(tmp == null || tmp.trim().length() == 0 ? "" : tmp);
                bui.append("<p><b>Indica\u00e7\u00e3o:</b><br>");
                tmp = reg.getString("mto_indicacao");
                bui.append(tmp == null || tmp.trim().length() == 0 ? "" : tmp);
                bui.append("<p><b>Observa\u00e7\u00e3o Cl\u00ednica:</b><br>");
                tmp = reg.getString("exp_mensagem");
                if (tmp != null && tmp.trim().length() > 0) {
                    bui.append(tmp);
                } else {
                    tmp = reg.getString("prc_mensagem");
                    if (tmp != null && tmp.trim().length() > 0) {
                        bui.append(tmp);
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(InfoPrincipios.this, e.getMessage(), e.getStackTrace());
            }
            return bui.append("</body></html>").toString();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.dados[rowIndex][columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.dados.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.cols[columnIndex];
        }
    }
}

