/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.componente.ComponenteDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.digitacao.evento.DigitacaoListener;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class InfoPerguntaExame
extends JDialog
implements DisposeListener {
    protected JPanel pBotoes = new JPanel(new FlowLayout(2));
    protected JButton btnFechar = new JButton("Fechar");
    protected Digitacao digitacao = new Digitacao();
    protected boolean salvarPressionado = false;
    protected boolean visualizar = false;
    protected String xmlPergunta = "";
    protected String digitado = "";

    public InfoPerguntaExame(Frame owner, boolean visualizar, String titulo) {
        super(owner, titulo);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        this.visualizar = visualizar;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public InfoPerguntaExame(Dialog owner, boolean visualizar, String titulo) {
        super(owner, titulo);
        this.visualizar = visualizar;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void setInstrucoes(String instrucoes, HashMap<String, Object> dados) {
        this.digitacao.carregarCampos(new Resultado(instrucoes, dados).getResultado());
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        if (!this.visualizar) {
            this.digitacao.setFocoPrimeiroCampo();
        }
    }

    public void setPerguntas(String perguntas, HashMap<String, Object> dados) {
        this.digitacao.exibirBotaoFechar(false);
        this.digitacao.carregarCampos(perguntas, dados, null, null, null, null, !this.visualizar, 1, null, null);
        if (this.visualizar && !Funcoes.textoVazio(this.contemResposta(this.digitacao.getResultadoDigitacao()))) {
            this.digitacao.carregarCampos(this.xmlPergunta, dados, null, null, null, null, !this.visualizar, 1, null, null);
            this.digitacao.exibirCheckBoxImprimir(false);
        }
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setLocationRelativeTo(this.getParent());
        if (!this.visualizar) {
            this.digitacao.setFocoPrimeiroCampo();
        }
    }

    private String contemResposta(Resultado resultado) {
        if (resultado != null) {
            for (Component d : resultado.getComponentes()) {
                if (!(d instanceof ComponenteDigitacao) || !((ComponenteDigitacao)((Object)d)).vazio()) continue;
                d.setVisible(false);
                this.xmlPergunta = resultado.getResultado();
            }
        }
        return this.xmlPergunta;
    }

    public void jbInit() throws Exception {
        this.setModal(true);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(0);
        ScreenUtil.centralizar(this);
        this.getContentPane().add((Component)this.pBotoes, "South");
        this.getContentPane().add((Component)this.digitacao, "Center");
        if (!this.visualizar) {
            this.digitacao.exibirCheckBoxImprimir(false);
            this.digitacao.exibirBotaoFechar(true);
            this.digitacao.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0, true), "enter");
            this.digitacao.getActionMap().put("enter", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component owner = FocusManager.getCurrentManager().getFocusOwner();
                    if (owner instanceof JButton) {
                        ((JButton)owner).doClick();
                    } else {
                        InfoPerguntaExame.this.digitacao.setFocoProximo();
                    }
                }
            });
        }
        this.pBotoes.add(this.btnFechar);
        Funcoes.montaEnter((JComponent)this.pBotoes);
        this.btnFechar.setMnemonic('F');
        this.pBotoes.setVisible(this.visualizar);
        this.btnFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPerguntaExame.this.salvarPressionado = false;
                InfoPerguntaExame.this.setVisible(false);
            }
        });
        this.digitacao.addDigitacaoListener(new DigitacaoListener(){

            @Override
            public void acaoSalvar(DigitacaoEvento e) {
                InfoPerguntaExame.this.salvarPressionado = true;
                if (InfoPerguntaExame.this.digitacao != null) {
                    InfoPerguntaExame.this.digitado = InfoPerguntaExame.this.digitacao.getResultado();
                    if (!InfoPerguntaExame.this.digitacao.resultadoCompleto(false)) {
                        InfoPerguntaExame.this.salvarPressionado = false;
                        Funcoes.mensagem(InfoPerguntaExame.this, "Valor do campo " + InfoPerguntaExame.this.digitacao.getResultadoDigitacao().getNomeCampoSemResultado() + " n\u00e3o informado.", 2);
                        return;
                    }
                }
                if (InfoPerguntaExame.this.digitacao != null) {
                    InfoPerguntaExame.this.digitacao = null;
                }
                InfoPerguntaExame.this.setVisible(false);
            }

            @Override
            public void acaoSalvarParcial(DigitacaoEvento e) {
            }

            @Override
            public void acaoImprimir(DigitacaoEvento e) {
            }

            @Override
            public void acaoFechar(DigitacaoEvento digitacaoEvento) {
                InfoPerguntaExame.this.salvarPressionado = false;
                InfoPerguntaExame.this.setVisible(false);
            }

            @Override
            @Deprecated
            public void acaoRemover(DigitacaoEvento e) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (InfoPerguntaExame.this.digitacao != null) {
                    InfoPerguntaExame.this.digitacao.setFocoPrimeiroCampo();
                }
            }
        });
    }

    public boolean getSalvarPressionado() {
        return this.salvarPressionado;
    }

    public void setExame(String codigo, String descricao) {
        this.setTitle(this.getTitle() + " - [" + codigo + "] " + descricao);
    }

    public String getPergunta() {
        return this.digitado;
    }

    public boolean isResultadoCompleto() {
        if (this.digitacao == null) {
            return true;
        }
        return this.digitacao.resultadoCompleto(false);
    }
}

