/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Digitacao;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.digitacao.componente.TextoDigitacao;
import jalis.laboratorio.digitacao.evento.DigitacaoAdapter;
import jalis.laboratorio.digitacao.evento.DigitacaoEvento;
import jalis.laboratorio.impressao.Documento;
import jalis.laboratorio.impressao.Impressao;
import jalis.model.vo.triagem.RecipienteColetaVO;
import jalis.model.vo.triagem.RecipienteTriagemVO;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class InfoExame
extends JDialog
implements DisposeListener,
ActionListener,
KeyListener {
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JButton buttonImprimirInstrucoes = ComponenteFactory.novoJButton("Imprimir instru\u00e7\u00f5es", this);
    private String instrucoesColeta = "";
    private JButton botaoFechar = new JButton("Fechar");
    private JLabel labelBloqueado = new JLabel("");
    private JButton buttonModelo = ComponenteFactory.novoJButton("Modelo", 'M', this);
    private JPopupMenu menuModelo = new JPopupMenu();
    private JPanel panelBotaoA = ComponenteFactory.novoJPanelFlowLayout(0, this.labelBloqueado);
    private JPanel panelBotaoB = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonImprimirInstrucoes, this.buttonModelo, this.botaoFechar);
    private JPanel panelBotao = ComponenteFactory.novoJPanelBorderLayout(null, null, null, this.panelBotaoB, this.panelBotaoA);
    private TTextField textFilial = new TTextField(5, 1);
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial", 'f', null, null, this);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JLabel label1 = new JLabel("Exame");
    private JLabel label2 = new JLabel("Prazo");
    private JLabel label3 = new JLabel("M\u00e9todo");
    private JLabel label4 = new JLabel("A.M.B.");
    private JLabel label5 = new JLabel("C.B.H.P.M.");
    private JLabel label6 = new JLabel("Setor");
    private JLabel labelMaterial = new JLabel("Material");
    private TTextField txtCodigo = new TTextField(5);
    private JButton buttonBuscaExame = ComponenteFactory.novoJButton((ActionListener)this, null, new Dimension(20, 20), true, true);
    private JLabel labelDescricao = new JLabel();
    private JLabel labelPrazo = new JLabel();
    private JLabel labelAMB = new JLabel();
    private JLabel labelCBHPM = new JLabel();
    private JLabel labelSetor = new JLabel();
    private JLabel labelMetodo = new JLabel();
    private JLabel labelVMaterial = new JLabel();
    private TitledBorder borda = new TitledBorder("");
    private JTabbedPane aba = new JTabbedPane();
    private JTextArea coleta = new JTextArea();
    private JTextArea preparo = new JTextArea();
    private JTextArea prepAmostra = new JTextArea();
    private JTextArea inadequada = new JTextArea();
    private JTextArea diagnostico = new JTextArea();
    private JTextArea interferencia = new JTextArea();
    private JTextArea referencia = new JTextArea();
    private JTextArea procedimento = new JTextArea();
    private JTextArea mensagem = new JTextArea();
    private JPanel recipiente = new JPanel();
    private JPanel panelColeta = new JPanel();
    private JPanel panelTriagem = new JPanel();
    private JScrollPane scrollColeta = new JScrollPane(this.coleta);
    private JScrollPane scrollPreparo = new JScrollPane(this.preparo);
    private JScrollPane scrollPrepAmostra = new JScrollPane(this.prepAmostra);
    private JScrollPane scrollInadequada = new JScrollPane(this.inadequada);
    private JScrollPane scrollDiagnostico = new JScrollPane(this.diagnostico);
    private JScrollPane scrollInterferencia = new JScrollPane(this.interferencia);
    private JScrollPane scrollReferencia = new JScrollPane(this.referencia);
    private JScrollPane scrollProcedimento = new JScrollPane(this.procedimento);
    private JScrollPane scrollMensagem = new JScrollPane(this.mensagem);
    private JPanel panelConservacao = new JPanel(new BorderLayout());
    private JTextArea conservacao = new JTextArea();
    private JScrollPane scrollConservacao = new JScrollPane(this.conservacao);
    private JPanel panelConservacaoTop = new JPanel(null);
    private JLabel labelDia = new JLabel("Dias:");
    private JLabel labelTemperatura = new JLabel("Temperatura:");
    private JLabel labelConservacao = new JLabel("Conserva\u00e7\u00e3o");
    private JLabel labelVDia = new JLabel();
    private JLabel labelVTemperaturaInicial = new JLabel();
    private JLabel labelCentigrado1 = new JLabel("C a ");
    private JLabel labelVTemperaturaFinal = new JLabel();
    private JLabel labelCentigrado2 = new JLabel("C");
    private JTable tableRecipCol;
    private JTable tableRecipTri;
    private ModeloGridTable modeloRecipCol = new ModeloGridTable(new String[]{"C\u00f3digo", "Recipiente", "Qtde", "Volume", "Uni", "Int."});
    private ModeloGridTable modeloRecipTri = new ModeloGridTable(new String[]{"C\u00f3digo", "Recipiente", "Qtde", "Volume", "Uni", "Int."});
    public static final String CHAVE_INPUTMAP = "TELA_INFORMACAO_EXAME";

    public static InfoExame novaInstancia(Object owner) {
        if (owner instanceof JDialog) {
            return new InfoExame((JDialog)owner);
        }
        if (owner instanceof JFrame) {
            return new InfoExame((JFrame)owner);
        }
        return null;
    }

    public InfoExame(JDialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "InfoExame");
        }
        ScreenUtil.requisitarFoco(this.textFilial.isVisible() ? this.textFilial : this.txtCodigo);
    }

    public InfoExame(JFrame owner) {
        super(owner);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "InfoExame");
        }
        ScreenUtil.requisitarFoco(this.textFilial.isVisible() ? this.textFilial : this.txtCodigo);
    }

    public void jbInit() throws Exception {
        this.setTitle("Informa\u00e7\u00f5es de exame");
        this.setLayout(this.grid);
        this.setSize(new Dimension(640, 425));
        ScreenUtil.centralizar(this);
        this.setModal(true);
        this.setResizable(false);
        ((JPanel)this.getContentPane()).setBorder(ScreenUtil.criarBordaVazia());
        this.buttonModelo.setVisible(Acesso.getAcesso(Long.parseLong("0000100010")));
        this.buttonImprimirInstrucoes.setVisible(false);
        this.labelBloqueado.setForeground(Color.RED);
        this.txtCodigo.addKeyListener(this);
        this.textFilial.addKeyListener(this);
        this.tableRecipCol = new JTable(){

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }
        };
        this.tableRecipTri = new JTable(){

            public Class getColumnClass(int col) {
                return this.getValueAt(0, col).getClass();
            }
        };
        this.tableRecipCol.setToolTipText("<html>Recipientes a serem utilizados para a cria\u00e7\u00e3o de etiquetas de coleta<br>A coluna Int. indica que o recipiente vai ser enviado ao interfaceamento</html>");
        this.tableRecipTri.setToolTipText("<html>Recipientes a serem utilizados para a cria\u00e7\u00e3o de etiquetas de triagem<br>A coluna Int. indica que o recipiente vai ser enviado ao interfaceamento</html>");
        this.tableRecipCol.setModel(this.modeloRecipCol);
        this.tableRecipTri.setModel(this.modeloRecipTri);
        this.botaoFechar.setMnemonic('F');
        if (Acesso.getAcesso(Long.parseLong("0000100001"))) {
            this.aba.add((Component)this.scrollColeta, "Coleta");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100002"))) {
            this.aba.add((Component)this.scrollPreparo, "Preparo");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100003"))) {
            this.aba.add((Component)this.scrollPrepAmostra, "Prep. Amostra");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100004"))) {
            this.aba.add((Component)this.scrollInadequada, "Inadequada");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100005"))) {
            this.aba.add((Component)this.scrollDiagnostico, "Diagn\u00f3stico");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100006"))) {
            this.aba.add((Component)this.scrollInterferencia, "Interfer\u00eancia");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100007"))) {
            this.aba.add((Component)this.scrollReferencia, "Refer\u00eancia");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100008"))) {
            this.aba.add((Component)this.scrollProcedimento, "Procedimento");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100009"))) {
            this.aba.add((Component)this.panelConservacao, "Conserva\u00e7\u00e3o");
        }
        if (Acesso.getAcesso(Long.parseLong("0000100011"))) {
            this.aba.add((Component)this.scrollMensagem, "Mensagem");
        }
        this.txtCodigo.setUpperCase(true);
        this.txtCodigo.setEditable(true);
        this.txtCodigo.setToolTipText("F2 - Pesquisar exame");
        this.coleta.setEditable(false);
        this.preparo.setEditable(false);
        this.prepAmostra.setEditable(false);
        this.inadequada.setEditable(false);
        this.diagnostico.setEditable(false);
        this.interferencia.setEditable(false);
        this.referencia.setEditable(false);
        this.procedimento.setEditable(false);
        this.conservacao.setEditable(false);
        this.mensagem.setEditable(false);
        this.coleta.setLineWrap(true);
        this.preparo.setLineWrap(true);
        this.prepAmostra.setLineWrap(true);
        this.inadequada.setLineWrap(true);
        this.diagnostico.setLineWrap(true);
        this.interferencia.setLineWrap(true);
        this.referencia.setLineWrap(true);
        this.procedimento.setLineWrap(true);
        this.conservacao.setLineWrap(true);
        this.mensagem.setLineWrap(true);
        this.coleta.setWrapStyleWord(true);
        this.preparo.setWrapStyleWord(true);
        this.prepAmostra.setWrapStyleWord(true);
        this.inadequada.setWrapStyleWord(true);
        this.diagnostico.setWrapStyleWord(true);
        this.interferencia.setWrapStyleWord(true);
        this.referencia.setWrapStyleWord(true);
        this.procedimento.setWrapStyleWord(true);
        this.conservacao.setWrapStyleWord(true);
        this.mensagem.setWrapStyleWord(true);
        ScreenUtil.setBorda(new Component[]{this.labelDescricao, this.labelPrazo, this.labelAMB, this.labelCBHPM, this.labelMetodo, this.labelVDia, this.labelVTemperaturaInicial, this.labelVTemperaturaFinal, this.labelSetor, this.labelVMaterial}, this.borda);
        boolean integrar = !ParametrosGerais.getTipoIntegracao().equals("N");
        JPanel panelCodigo = new JPanel(new GridBagLayout());
        Funcoes.montaEnter((JComponent)panelCodigo);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        if (integrar) {
            panelCodigo.add((Component)this.labelFilial, c);
            c.gridx = 2;
        }
        panelCodigo.add((Component)this.label1, c);
        c.gridy = 1;
        c.gridx = 0;
        this.txtCodigo.setPreferredSize(new Dimension(60, 20));
        this.txtCodigo.setMinimumSize(new Dimension(60, 20));
        this.textFilial.setPreferredSize(new Dimension(60, 20));
        this.textFilial.setMinimumSize(new Dimension(60, 20));
        this.buttonFilial.setPreferredSize(new Dimension(20, 20));
        this.buttonFilial.setMinimumSize(new Dimension(20, 20));
        this.buttonFilial.setMaximumSize(new Dimension(20, 20));
        this.labelDescricao.setPreferredSize(new Dimension(20, 20));
        if (integrar) {
            panelCodigo.add((Component)this.textFilial, c);
            ++c.gridx;
            panelCodigo.add((Component)this.buttonFilial, c);
            ++c.gridx;
        }
        panelCodigo.add((Component)this.txtCodigo, c);
        ++c.gridx;
        this.buttonBuscaExame.setPreferredSize(new Dimension(20, 20));
        this.buttonBuscaExame.setMinimumSize(new Dimension(20, 20));
        this.buttonBuscaExame.setMaximumSize(new Dimension(20, 20));
        panelCodigo.add((Component)this.buttonBuscaExame, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        panelCodigo.add((Component)this.labelDescricao, c);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.fill = 2;
        this.add((Component)panelCodigo, this.constraints);
        JPanel panelPrazo = new JPanel(new GridBagLayout());
        this.constraints.gridwidth = 1;
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.constraints.gridwidth = 2;
        this.add((Component)panelPrazo, this.constraints);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelPrazo.add((Component)this.labelMaterial, c);
        ++c.gridx;
        panelPrazo.add((Component)this.label2, c);
        ++c.gridx;
        panelPrazo.add((Component)this.label3, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 1.0;
        c.insets = new Insets(0, 2, 0, 0);
        c.fill = 2;
        this.labelVMaterial.setPreferredSize(new Dimension(200, 20));
        this.labelVMaterial.setMinimumSize(new Dimension(200, 20));
        panelPrazo.add((Component)this.labelVMaterial, c);
        ++c.gridx;
        this.labelPrazo.setPreferredSize(new Dimension(200, 20));
        this.labelPrazo.setMinimumSize(new Dimension(200, 20));
        panelPrazo.add((Component)this.labelPrazo, c);
        ++c.gridx;
        this.labelMetodo.setPreferredSize(new Dimension(200, 20));
        this.labelMetodo.setMinimumSize(new Dimension(200, 20));
        panelPrazo.add((Component)this.labelMetodo, c);
        JPanel panelAMB = new JPanel(new GridBagLayout());
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.add((Component)panelAMB, this.constraints);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        c.weightx = 0.0;
        c.weighty = 0.0;
        panelAMB.add((Component)this.label4, c);
        c.gridx = 1;
        panelAMB.add((Component)this.label5, c);
        c.gridx = 2;
        panelAMB.add((Component)this.label6, c);
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 0;
        c.weightx = 0.0;
        this.labelAMB.setPreferredSize(new Dimension(100, 20));
        this.labelAMB.setMinimumSize(new Dimension(100, 20));
        panelAMB.add((Component)this.labelAMB, c);
        c.gridx = 1;
        this.labelCBHPM.setPreferredSize(new Dimension(100, 20));
        this.labelCBHPM.setMinimumSize(new Dimension(100, 20));
        panelAMB.add((Component)this.labelCBHPM, c);
        c.gridx = 2;
        this.labelSetor.setPreferredSize(new Dimension(100, 20));
        this.labelSetor.setMinimumSize(new Dimension(100, 20));
        c.fill = 2;
        c.weightx = 1.0;
        panelAMB.add((Component)this.labelSetor, c);
        this.constraints.gridx = 0;
        this.constraints.gridy = 4;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.grid.setConstraints(this.aba, this.constraints);
        this.add(this.aba);
        this.constraints.gridx = 0;
        this.constraints.gridy = 5;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.grid.setConstraints(this.panelBotao, this.constraints);
        this.add(this.panelBotao);
        this.panelColeta.setLayout(new BorderLayout());
        this.panelColeta.add((Component)new JScrollPane(this.tableRecipCol), "Center");
        this.tableRecipTri.setPreferredScrollableViewportSize(new Dimension(20, 35));
        this.panelTriagem.setLayout(new BorderLayout());
        this.panelTriagem.add((Component)new JScrollPane(this.tableRecipTri), "Center");
        this.recipiente.setLayout(new BorderLayout());
        this.panelColeta.setBorder(new TitledBorder("Coleta"));
        this.recipiente.add((Component)this.panelColeta, "Center");
        this.panelTriagem.setBorder(new TitledBorder("Triagem"));
        this.recipiente.add((Component)this.panelTriagem, "South");
        this.aba.add((Component)this.recipiente, "Recipiente");
        this.panelConservacao.add((Component)this.scrollConservacao, "Center");
        this.panelConservacao.add((Component)this.panelConservacaoTop, "North");
        this.panelConservacaoTop.setPreferredSize(new Dimension(100, 43));
        this.panelConservacaoTop.add(this.labelDia);
        this.panelConservacaoTop.add(this.labelTemperatura);
        this.panelConservacaoTop.add(this.labelConservacao);
        this.panelConservacaoTop.add(this.labelVDia);
        this.panelConservacaoTop.add(this.labelVTemperaturaInicial);
        this.panelConservacaoTop.add(this.labelVTemperaturaFinal);
        this.panelConservacaoTop.add(this.labelCentigrado1);
        this.panelConservacaoTop.add(this.labelCentigrado2);
        this.labelDia.setBounds(new Rectangle(5, 8, 69, 14));
        this.labelVDia.setBounds(new Rectangle(65, 6, 69, 20));
        this.labelTemperatura.setBounds(new Rectangle(180, 8, 89, 14));
        this.labelVTemperaturaInicial.setBounds(new Rectangle(270, 6, 40, 20));
        this.labelCentigrado1.setBounds(new Rectangle(312, 6, 26, 20));
        this.labelVTemperaturaFinal.setBounds(new Rectangle(340, 6, 40, 20));
        this.labelCentigrado2.setBounds(new Rectangle(382, 6, 16, 20));
        this.labelConservacao.setBounds(new Rectangle(5, 27, 100, 14));
        this.modeloRecipTri.setColumnSize(new int[]{70, 0, 80, 80, 40, 40}, this.tableRecipTri);
        this.modeloRecipCol.setColumnSize(new int[]{70, 0, 80, 80, 40, 40}, this.tableRecipCol);
        this.botaoFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoExame.this.setVisible(false);
            }
        });
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getOppositeComponent() instanceof JButton)) {
                    InfoExame.this.buscaDadosFilial();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (Funcoes.textoVazio(InfoExame.this.textFilial.getText()) && InfoExame.this.textFilial.isVisible()) {
                    InfoExame.this.setFilial(Variaveis.filialPadrao);
                }
            }
        });
    }

    public void setExame(DadosExames exame) {
        this.setExame(exame, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExame(DadosExames exame, DadosMaterial material, DadosConvenios convenio) {
        if (exame instanceof DadosExames) {
            Statement st;
            block9: {
                this.txtCodigo.setText(exame.getCodigo());
                this.labelDescricao.setText(exame.getDescricao());
                this.labelPrazo.setText(exame.getPrazo());
                this.labelVMaterial.setText(exame.getMaterialColetadoExame());
                this.labelMetodo.setText(exame.getDescMetodo());
                this.labelAMB.setText(exame.getAMB());
                this.labelCBHPM.setText(exame.getCBHPM());
                this.labelSetor.setText(exame.getDescricaoSetor());
                this.coleta.setText(exame.getColeta());
                this.preparo.setText(exame.getPreparo());
                this.prepAmostra.setText(exame.getPrepAmostra());
                this.inadequada.setText(exame.getInadequada());
                this.referencia.setText(exame.getReferencia());
                this.procedimento.setText(exame.getProcedimento());
                this.conservacao.setText(exame.getConservacao());
                this.mensagem.setText(exame.getMensagem());
                this.labelVDia.setText(exame.getDiasConservacao());
                this.labelVTemperaturaInicial.setText(exame.getTemperaturaConservacaoInicial());
                this.labelVTemperaturaFinal.setText(exame.getTemperaturaConservacaoFinal());
                this.carregarRecipientes(exame);
                ScreenUtil.posicionaTextoTopo(this.coleta);
                ScreenUtil.posicionaTextoTopo(this.preparo);
                ScreenUtil.posicionaTextoTopo(this.prepAmostra);
                ScreenUtil.posicionaTextoTopo(this.inadequada);
                ScreenUtil.posicionaTextoTopo(this.referencia);
                ScreenUtil.posicionaTextoTopo(this.procedimento);
                ScreenUtil.posicionaTextoTopo(this.conservacao);
                ScreenUtil.posicionaTextoTopo(this.mensagem);
                this.instrucoesColeta = exame.getInstrucoesColeta();
                this.buttonImprimirInstrucoes.setVisible(!Funcoes.textoVazio(this.instrucoesColeta));
                this.labelBloqueado.setText(exame.getProibido() ? "Exame n\u00e3o permitido para cadastro" : "");
                st = Conexao.getStatement();
                try {
                    StringBuilder buf = new StringBuilder("select exa_diagnostico, exa_interferencia");
                    buf.append(" from exames ");
                    buf.append(" where fil_codigo = ");
                    buf.append(this.getCodigoFilial());
                    buf.append(" and exa_codigo = '");
                    buf.append(exame.getCodigo());
                    buf.append("'");
                    ResultSet rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.diagnostico.setText(rs.getString("exa_diagnostico"));
                        this.interferencia.setText(rs.getString("exa_interferencia"));
                    }
                    if (convenio == null || material == null) break block9;
                    buf.delete(0, buf.length());
                    if (ParametrosGerais.getPrecoMetodologia()) {
                        buf.append(" select COALESCE(NULLIF(dtm.dtm_codamb, ''), dtp.dtp_codamb) as dtp_codamb ");
                        buf.append("   from tabelaprecoexames tpe ");
                        buf.append("   left join detalhetabelaprecometodologia dtm on tpe.fil_codigo = dtm.fil_codigo and tpe.tpe_codigo = dtm.tpe_codigo and dtm.exa_codigo = '").append(exame.getCodigo()).append("' and dtm.mco_codigo = ").append(material.getCodigo()).append(" and dtm.met_codigo = ").append(exame.getCodMetodo());
                        buf.append("   left join detalhetabelapreco dtp on tpe.fil_codigo = dtp.fil_codigo and tpe.tpe_codigo = dtp.tpe_codigo and dtp.exa_codigo = '").append(exame.getCodigo()).append("' and dtp.mco_codigo = ").append(material.getCodigo());
                        buf.append("  where tpe.fil_codigo = ").append(this.getCodigoFilial());
                        buf.append("    and tpe.tpe_codigo = ").append(convenio.getTabela());
                    } else {
                        buf.append(" select dtp_codamb ");
                        buf.append("   from detalhetabelapreco ");
                        buf.append("  where fil_codigo = ").append(this.getCodigoFilial());
                        buf.append("    and exa_codigo = '").append(exame.getCodigo()).append("' ");
                        buf.append("    and mco_codigo = ").append(material.getCodigo());
                        buf.append("    and tpe_codigo = ").append(convenio.getTabela());
                    }
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        this.labelAMB.setText(rs.getString("dtp_codamb"));
                    }
                    buf.delete(0, buf.length());
                    buf.append("select a.prz_codigo, b.prz_descricao from examematconvenioprazo a ");
                    buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
                    buf.append("where a.fil_codigo = ").append(this.getCodigoFilial());
                    buf.append(" and a.exa_codigo = '").append(exame.getCodigo());
                    buf.append("' and a.mco_codigo = ").append(material.getCodigo());
                    buf.append(" and a.con_codigo = ");
                    buf.append(convenio.getCodigo());
                    rs = Conexao.executeQuery(st, buf);
                    if (!rs.next()) break block9;
                    this.labelPrazo.setText(rs.getString("prz_descricao"));
                }
                catch (SQLException ex) {
                    try {
                        ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoExame");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
    }

    private void carregarRecipientes(DadosExames exame) {
        List<RecipienteColetaVO> lista = null;
        try {
            lista = ExameUtil.getRecipientesColeta(this.getCodigoFilial(), exame.getCodigo(), exame.getCodigoMaterialColetado());
            this.modeloRecipCol.clear();
            for (RecipienteColetaVO recipienteColetaVO : lista) {
                this.modeloRecipCol.addLine(new Object[]{String.valueOf(recipienteColetaVO.getRecipiente().getCodigo()), recipienteColetaVO.getRecipiente().getDescricao(), String.valueOf(recipienteColetaVO.getQuantidade()), recipienteColetaVO.getVolume(), recipienteColetaVO.getUnidade(), recipienteColetaVO.getRco_interface()});
            }
            List<RecipienteTriagemVO> listaTriagem = null;
            listaTriagem = ExameUtil.getRecipientesTriagem(this.getCodigoFilial(), exame.getCodigo(), exame.getCodigoMaterialColetado());
            this.modeloRecipTri.clear();
            for (RecipienteTriagemVO recipienteTriagemVO : listaTriagem) {
                this.modeloRecipTri.addLine(new Object[]{String.valueOf(recipienteTriagemVO.getRecipiente().getCodigo()), recipienteTriagemVO.getRecipiente().getDescricao(), String.valueOf(recipienteTriagemVO.getQuantidade()), recipienteTriagemVO.getVolume(), recipienteTriagemVO.getUnidade(), recipienteTriagemVO.getRco_interface()});
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "InfoExame");
        }
    }

    private String getCodigoFilial() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            return Variaveis.filialPadrao;
        }
        return this.textFilial.getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void mostraModeloPadrao() {
        Statement st;
        String modelo;
        block8: {
            if (Funcoes.textoVazio(this.txtCodigo.getText())) {
                return;
            }
            modelo = "";
            st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select distinct d.elm_formato from examematcoleta c ");
                buf.append("left join examelayout a on c.fil_codigo = a.fil_codigo and c.exa_codigo = a.exa_codigo and c.mco_codigo = a.mco_codigo and a.ela_padrao = true ");
                buf.append("left join examelayoutmetodo d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and a.lay_codigo = d.lay_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("and a.ela_idadeini = d.ela_idadeini and a.ela_idadefim = d.ela_idadefim and a.ela_idadeinitipo = d.ela_idadeinitipo and a.ela_idadefimtipo = d.ela_idadefimtipo ");
                buf.append("and d.met_codigo = d.met_codigo ");
                buf.append("where c.fil_codigo = ").append(this.getCodigoFilial());
                buf.append("and c.exa_codigo = '").append(this.txtCodigo.getTextDB()).append("' ");
                buf.append("and c.emc_default = true ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block8;
                modelo = rs.getString("elm_formato");
            }
            catch (SQLException sqlex) {
                ErrorLogger.mostraMensagem(this, sqlex.getMessage(), sqlex.getStackTrace(), "InfoExame (476)");
                Conexao.fecharStatement(st);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoExame (478)");
                {
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
        if (!Funcoes.textoVazio(modelo)) {
            final JDialog dialogo = new JDialog(this, "Pre-visualiza\u00e7\u00e3o de digita\u00e7\u00e3o do exame", true);
            final Digitacao dig = new Digitacao();
            HashMap<Integer, String> resAnte = new HashMap<Integer, String>();
            resAnte.put(1, "<campo1>10,50</campo1><dataResultado>10/08/2006</dataResultado><horaResultado>15:35</horaResultado>");
            resAnte.put(2, "<campo1>5,00</campo1><dataResultado>06/07/2006</dataResultado><horaResultado>09:23</horaResultado>");
            resAnte.put(3, "<campo1>8,45</campo1><dataResultado>25/06/2006</dataResultado><horaResultado>16:00</horaResultado>");
            resAnte.put(4, "<campo1>6,75</campo1><dataResultado>18/06/2006</dataResultado><horaResultado>10:50</horaResultado>");
            dig.carregarCampos(modelo, null, null, null, null, resAnte, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1);
            dig.setFocoPrimeiroCampo();
            dig.exibirBotaoFechar(true);
            dig.exibirBotaoSalvar(false);
            dig.exibirBotaoSalvarParcial(false);
            dig.exibirCheckBoxImprimir(false);
            dig.addDigitacaoListener(new DigitacaoAdapter(){

                @Override
                public void acaoFechar(DigitacaoEvento e) {
                    dialogo.dispose();
                }
            });
            ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(10, 0, false), "ENTER", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Component owner = FocusManager.getCurrentManager().getFocusOwner();
                    if (owner instanceof JButton) {
                        ((JButton)owner).doClick();
                    } else if (!(owner instanceof TextoDigitacao)) {
                        dig.setFocoProximo();
                    }
                }
            });
            ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(27, 0, true), "ESCAPE", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dialogo.dispose();
                }
            });
            ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(38, 0, true), "UP", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dig.setFocoAnterior();
                }
            });
            ScreenUtil.addActionMap(dig, KeyStroke.getKeyStroke(40, 0, true), "DOWN", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    dig.setFocoProximo();
                }
            });
            dialogo.getContentPane().setLayout(new BorderLayout());
            dialogo.getContentPane().add((Component)dig, "Center");
            dialogo.pack();
            dialogo.setSize(dialogo.getPreferredSize());
            ScreenUtil.centralizar(dialogo);
            dialogo.setVisible(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonModelo) {
            this.mostraModeloPadrao();
        } else if (e.getSource() == this.buttonBuscaExame) {
            this.buscaExame();
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonImprimirInstrucoes) {
            this.imprimirInstrucoes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imprimirInstrucoes() {
        Statement st;
        block6: {
            if (Funcoes.textoVazio(this.instrucoesColeta)) {
                return;
            }
            st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.delete(0, buf.length());
                buf.append("select lay_geral from layout where fil_codigo = ");
                buf.append(this.getCodigoFilial());
                buf.append(" and lay_codigo = ");
                buf.append(ParametrosGerais.getLayCodigo());
                ResultSet rsLayout = Conexao.executeQuery(st, buf.toString());
                if (rsLayout.next() && !Funcoes.textoVazio(rsLayout.getString("lay_geral"))) {
                    String layout = rsLayout.getString("lay_geral");
                    Impressao impressao = new Impressao(ParametrosLocais.getParametro("impressoraInstrucaoColeta"));
                    Documento doc = new Documento();
                    doc.setSempreReposicionarEntrePaginas(true);
                    doc.setCabecalhoRodape(layout);
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("dataAtual", new Date());
                    map.put("versaoLayout", !StringUtil.getValor(this.instrucoesColeta, "versaoExame").isEmpty() ? StringUtil.getValor(this.instrucoesColeta, "versaoExame") : "1");
                    doc.addResultados(null, new String[]{new Resultado(this.instrucoesColeta, map).getResultado()});
                    impressao.imprimir(doc);
                    impressao = null;
                    break block6;
                }
                Funcoes.mensagem(null, "Modelo n\u00e3o localizado ou n\u00e3o definido", 1);
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "InfoExame: 646");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    private void buscaDadosFilial() {
        if (!Funcoes.textoVazio(this.textFilial.getText())) {
            String descricao = "N\u00e3o cadastrado";
            try {
                descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", this.textFilial.getText(), "filiais_postocoleta", true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoExame (574)");
            }
            if (descricao.equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "Filial n\u00e3o localizada", 1);
                ScreenUtil.requisitarFoco(this.textFilial);
            }
        } else {
            ScreenUtil.requisitarFoco(this.txtCodigo);
        }
    }

    public void setFilial(String filial) {
        if (!Funcoes.textoVazio(filial)) {
            this.textFilial.setText(filial);
        }
    }

    private void buscaExame() {
        try {
            Hashtable resultado = Pesquisas.exameAMB(this.getParent(), this.getCodigoFilial(), false, true);
            if (resultado != null) {
                this.txtCodigo.setText(resultado.get("exa_codigo").toString());
                int codMaterial = Integer.parseInt(resultado.get("mco_codigo").toString());
                DadosMaterial mat = ExameUtil.getDadosMaterial(this.getCodigoFilial(), codMaterial);
                DadosExames exm = ExameUtil.getDadosExame(this.getCodigoFilial(), this.txtCodigo.getText(), mat);
                this.setExame(exm);
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoExame (581)");
        }
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(this, false);
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaExameInformado() {
        try {
            if (!Funcoes.textoVazio(this.txtCodigo.getText())) {
                Integer codMaterial = ExameUtil.getMaterialPadrao(this.getCodigoFilial(), this.txtCodigo.getText());
                DadosMaterial mat = ExameUtil.getDadosMaterial(this.getCodigoFilial(), codMaterial);
                DadosExames exm = ExameUtil.getDadosExame(this.getCodigoFilial(), this.txtCodigo.getText(), mat);
                this.setExame(exm);
            }
        }
        catch (Exception e) {
            this.limparCampos();
            Funcoes.mensagem(this, "N\u00e3o foi poss\u00edvel encontrar o exame.\nVerifique as configura\u00e7\u00f5es e tente novamente", 2);
        }
    }

    private void limparCampos() {
        this.labelDescricao.setText("");
        this.labelPrazo.setText("");
        this.labelVMaterial.setText("");
        this.labelMetodo.setText("");
        this.labelAMB.setText("");
        this.labelCBHPM.setText("");
        this.labelSetor.setText("");
        this.coleta.setText("");
        this.preparo.setText("");
        this.prepAmostra.setText("");
        this.inadequada.setText("");
        this.referencia.setText("");
        this.procedimento.setText("");
        this.conservacao.setText("");
        this.mensagem.setText("");
        this.labelVDia.setText("");
        this.labelVTemperaturaInicial.setText("");
        this.labelVTemperaturaFinal.setText("");
        this.labelBloqueado.setText("");
        this.diagnostico.setText("");
        this.interferencia.setText("");
        this.labelPrazo.setText("");
        this.labelAMB.setText("");
        this.modeloRecipTri.clear();
        this.modeloRecipCol.clear();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            if (this.txtCodigo.hasFocus()) {
                this.buscaExame();
            } else if (this.textFilial.hasFocus()) {
                this.buscaFilial();
            }
        } else if (e.getKeyCode() == 10 && this.txtCodigo.hasFocus()) {
            this.buscaExameInformado();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10 && this.txtCodigo.hasFocus()) {
            e.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }
}

