/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.ParametrosGerais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class InfoConvenio
extends JDialog
implements DisposeListener,
ActionListener,
KeyListener {
    public static final String SIM = "Sim";
    public static final String NAO = "N\u00e3o";
    GridBagLayout grid = new GridBagLayout();
    GridBagConstraints constraints = new GridBagConstraints();
    private TitledBorder borda = new TitledBorder("");
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonBusca = ComponenteFactory.novoJButton((ActionListener)this, null, new Dimension(20, 20), true, true);
    private JButton buttonFilial = ComponenteFactory.novoJButton((ActionListener)this, null, new Dimension(20, 20), true, true);
    private TTextField textFilial = new TTextField(5, 1);
    private TTextField textCodigo = new TTextField(5, 1);
    private JTextArea textNorma = new JTextArea();
    private JTextArea textObservacao = new JTextArea(new TTextAreaDocument(2000));
    private JScrollPane scrollNorma = new JScrollPane(this.textNorma);
    private JScrollPane scrollObservacao = new JScrollPane(this.textObservacao);
    private JTabbedPane aba = new JTabbedPane();
    private JLabel labelFilial = ComponenteFactory.novoJLabel("Filial", 'f', null, null, this);
    private JLabel labelExigeMatricula = new JLabel("Matr\u00edcula obrigat\u00f3ria:");
    private JLabel labelDescExigeMatricula = new JLabel();
    private JLabel labelExigeValidadeGuia = new JLabel("Validade da guia:");
    private JLabel labelDescExigeValidadeGuia = new JLabel();
    private JLabel labelExigeGuia = new JLabel("Nr. de guia obrigat\u00f3rio:");
    private JLabel labelDescExigeGuia = new JLabel();
    private JLabel labelExigeValidadeCarteira = new JLabel("Validade da carteira:");
    private JLabel labelDescExigeValidadeCarteira = new JLabel();
    private JLabel labelExigePlano = new JLabel("Plano obrigat\u00f3rio:");
    private JLabel labelDescExigePlano = new JLabel();
    private JLabel labelExigeUnidadeSaude = new JLabel("Unidade de sa\u00fade:");
    private JLabel labelDescExigeUnidadeSaude = new JLabel();
    private JLabel labelConvenioProibido = new JLabel("Conv\u00eanio proibido:");
    private JLabel labelDescConvenioProibido = new JLabel();
    private JLabel labelConvenioApoio = new JLabel("Considerar como conv\u00eanio apoio:");
    private JLabel labelDescConvenioApoio = new JLabel();
    private JLabel labelCodigo = new JLabel("C\u00f3digo");
    private JLabel labelDescConvenio = new JLabel();
    private JLabel labelRazao = new JLabel("Raz\u00e3o:");
    private JLabel labelDescRazao = new JLabel();
    private JLabel labelDescFantazia = new JLabel();
    private JLabel labelCNPJ = new JLabel("CNPJ");
    private JLabel labelDescCNPJ = new JLabel();
    private JLabel labelCidade = new JLabel(" Cidade:");
    private JLabel labelDescCidade = new JLabel();
    private JLabel labelEndereco = new JLabel("Endere\u00e7o:");
    private JLabel labelDescEndereco = new JLabel();
    private JLabel labelFone = new JLabel("Fone:");
    private JLabel labelDescFone = new JLabel();
    private JLabel labelContato = new JLabel("Contato:");
    private JLabel labelDescContato = new JLabel();
    private JLabel labelModelo = new JLabel("Modelo:");
    private JLabel labelDescModelo = new JLabel();
    private JLabel labelCodigoModelo = new JLabel();
    private JLabel labelValidade = new JLabel("Validade:");
    private JLabel labelDescValidade = new JLabel();
    private JLabel labelDescExigencias = new JLabel();
    private JLabel labelExamesPermitidos = new JLabel("Nr. Ex. permitidos:");
    private JLabel labelDescPermitidos = new JLabel();
    private JLabel labelTabela = new JLabel("Tabela:");
    private JLabel labelDescTabela = new JLabel();
    private JLabel labelCodigoTabela = new JLabel();
    private JLabel labelTipoCalculo = new JLabel("Tipo c\u00e1lculo do CH:");
    private JLabel labelDescTipoCalculo = new JLabel();
    private JLabel labelValorCH = new JLabel("Valor CH:");
    private JLabel labelDescValorCH = new JLabel();
    private JLabel labelPercPagBalcao = new JLabel("% balc\u00e3o:");
    private JLabel labelDescPercPagBalcao = new JLabel();
    private JLabel labelHospital = new JLabel("Integra\u00e7\u00e3o Hosp.:");
    private JLabel labelDescHospital = new JLabel();
    private JLabel labelFatEletronico = new JLabel("Fat. Eletr\u00f4nico:");
    private JLabel labelDescFatEletronico = new JLabel();
    JPanel panelCodigo = new JPanel(new GridBagLayout());
    private JPanel panelBotaoB = ComponenteFactory.novoJPanelFlowLayout(2, this.buttonFechar);
    private JPanel panelBotao = ComponenteFactory.novoJPanelBorderLayout(null, null, null, null, this.panelBotaoB);
    public static final String CHAVE_INPUTMAP = "TELA_INFORMACAO_CONVENIO";

    public InfoConvenio(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public static InfoConvenio novaInstancia(Object owner) {
        if (owner instanceof JDialog) {
            return new InfoConvenio((JDialog)owner);
        }
        return null;
    }

    public InfoConvenio(JFrame owner) {
        super(owner);
        if (owner instanceof Laboratorio) {
            ((Laboratorio)owner).addDisposeListener(this);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        ScreenUtil.requisitarFoco(this.textFilial.isVisible() ? this.textFilial : this.textCodigo);
    }

    public static long getModuloAcesso() {
        return Long.parseLong("0000300000");
    }

    public void jbInit() throws Exception {
        this.setTitle("Informa\u00e7\u00f5es de Conv\u00eanios");
        this.setLayout(this.grid);
        this.setSize(new Dimension(675, 465));
        ScreenUtil.centralizar(this);
        this.setModal(true);
        this.setResizable(false);
        ((JPanel)this.getContentPane()).setBorder(ScreenUtil.criarBordaVazia());
        this.montaTela();
    }

    private void buscaConvenio() {
        Hashtable resultado = Pesquisas.convenio(this, this.getCodigoFilial(), false, false);
        if (resultado != null) {
            this.textCodigo.setText(resultado.get("con_codigo").toString());
            int codigoConvenio = Integer.parseInt(resultado.get("con_codigo").toString());
            try {
                DadosConvenios conv = ConvenioUtil.getDadosConvenios(Variaveis.filialPadrao, codigoConvenio);
                this.setDados(conv, this.getCodigoFilial());
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(this, false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaDadosFilial() {
        if (!Funcoes.textoVazio(this.textFilial.getText())) {
            String descricao = "N\u00e3o cadastrado";
            try {
                descricao = DBUtil.getDescricao("fil_codigo", "fil_descricao", this.textFilial.getText(), "filiais_postocoleta", true);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoConvenio (574)");
            }
            if (descricao.equals("N\u00e3o cadastrado")) {
                Funcoes.mensagem(this, "Filial n\u00e3o localizada", 1);
                ScreenUtil.requisitarFoco(this.textFilial);
            }
        } else {
            ScreenUtil.requisitarFoco(this.textCodigo);
        }
    }

    public void buscaModelo(int codigoModelo, String filial) {
        if (codigoModelo > -1) {
            try {
                StringBuilder buf = new StringBuilder("fil_codigo = ");
                buf.append(filial);
                buf.append(" and lay_codigo = ");
                buf.append(codigoModelo);
                this.labelDescModelo.setText(DBUtil.getDescricao("select lay_descricao from layout", buf.toString(), "lay_descricao"));
                this.labelCodigoModelo.setText(String.valueOf(codigoModelo));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    private String getCodigoFilial() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            return Variaveis.filialPadrao;
        }
        return this.textFilial.getText();
    }

    public void buscaTabela(int codigoTabela, String filial) {
        if (codigoTabela > -1) {
            try {
                StringBuilder buf = new StringBuilder("fil_codigo = ");
                buf.append(filial);
                buf.append(" and tpe_codigo = ");
                buf.append(codigoTabela);
                this.labelDescTabela.setText(DBUtil.getDescricao("select tpe_descricao from tabelaprecoexames", buf.toString(), "tpe_descricao"));
                this.labelCodigoTabela.setText(String.valueOf(codigoTabela));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
            }
        }
    }

    public void setDados(DadosConvenios dados, String filial) {
        if (dados == null || Funcoes.textoVazio(filial)) {
            return;
        }
        this.limpaCampos();
        this.labelDescConvenio.setText(dados.getFantasia());
        this.labelDescRazao.setText(dados.getRazaoSocial());
        this.labelDescCNPJ.setText(dados.getCnpj());
        this.labelDescCidade.setText(dados.getCidade());
        this.labelDescFone.setText(dados.getTelefone());
        this.labelDescContato.setText(dados.getContato());
        this.labelDescValidade.setText(String.valueOf(dados.getDiasValidadeGuia()) + " dia(s)");
        this.labelDescPermitidos.setText(String.valueOf(dados.getExamesPorGuia()));
        this.labelDescTipoCalculo.setText(dados.getTipoCalculo().equalsIgnoreCase("M") ? "Multiplicar" : "Dividir");
        this.labelDescPercPagBalcao.setText(String.valueOf(dados.getPercentualBalcao()));
        this.labelDescValorCH.setText(String.valueOf(dados.getCH()));
        this.labelDescExigeGuia.setText(dados.getExigeCodigoGuia() ? SIM : NAO);
        this.labelDescExigeMatricula.setText(dados.getExigeMatricula() ? SIM : NAO);
        this.labelDescConvenioProibido.setText(dados.getProibido() ? "Conv\u00eanio n\u00e3o permitido para cadastro" : "");
        this.labelDescExigePlano.setText(dados.isObrigaNomePlano() ? SIM : NAO);
        this.labelDescExigeUnidadeSaude.setText(dados.isObrigaUnidadeSaude() ? SIM : NAO);
        this.labelDescExigeValidadeCarteira.setText(dados.isObrigaValidadeCarteira() ? SIM : NAO);
        this.labelDescExigeValidadeGuia.setText(dados.getValidadeGuia() ? SIM : NAO);
        this.textObservacao.setText(dados.getObservacao());
        this.textNorma.setText(dados.getNorma());
        this.labelDescEndereco.setText(Funcoes.textoVazio(dados.getNumeroEndereco()) ? dados.getEndereco() : dados.getTipoLogradouroEndereco() + " " + dados.getEndereco() + ", " + dados.getNumeroEndereco());
        this.labelDescConvenioApoio.setText(dados.getApoio() ? SIM : NAO);
        this.labelDescHospital.setText(!Funcoes.textoVazio(dados.getHospital()) ? SIM : NAO);
        this.labelDescFatEletronico.setText(!Funcoes.textoVazio(dados.getFatEletronico()) ? SIM : NAO);
        this.buscaModelo(dados.getCodigoLayout(), filial);
        this.buscaTabela(dados.getTabela(), filial);
    }

    public void limpaCampos() {
        this.labelDescConvenio.setText("");
        this.labelDescRazao.setText("");
        this.labelDescCNPJ.setText("");
        this.labelDescCidade.setText("");
        this.labelDescFone.setText("");
        this.labelDescContato.setText("");
        this.labelDescValidade.setText("");
        this.labelDescPermitidos.setText("");
        this.labelDescTipoCalculo.setText("");
        this.labelDescPercPagBalcao.setText("");
        this.labelDescValorCH.setText("");
        this.labelDescExigeGuia.setText("");
        this.labelDescExigeMatricula.setText("");
        this.labelDescConvenioProibido.setText("");
        this.labelDescExigePlano.setText("");
        this.labelDescExigeUnidadeSaude.setText("");
        this.labelDescExigeValidadeCarteira.setText("");
        this.labelDescExigeValidadeGuia.setText("");
        this.labelDescEndereco.setText("");
        this.labelDescConvenioApoio.setText("");
        this.labelDescHospital.setText("");
        this.labelDescFatEletronico.setText("");
        this.textObservacao.setText("");
        this.textNorma.setText("");
    }

    public void setFilial(String filial) {
        if (!Funcoes.textoVazio(filial)) {
            this.textFilial.setText(filial);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 113) {
            if (this.textCodigo.hasFocus()) {
                this.buscaConvenio();
            } else if (this.textFilial.hasFocus()) {
                this.buscaFilial();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonFechar) {
            this.setVisible(false);
        } else if (e.getSource() == this.buttonBusca) {
            this.buscaConvenio();
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        }
    }

    public void montaTela() {
        this.textCodigo.setToolTipText("F2 - Pesquisar conv\u00eanio");
        this.labelDescValidade.setToolTipText("Dias a serem considerados no c\u00e1lculo do prazo de validade da guia");
        this.textCodigo.addKeyListener(this);
        this.textFilial.addKeyListener(this);
        Funcoes.montaEnter((JComponent)this.panelCodigo);
        this.textFilial.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && !(e.getOppositeComponent() instanceof JButton)) {
                    InfoConvenio.this.buscaDadosFilial();
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (Funcoes.textoVazio(InfoConvenio.this.textFilial.getText()) && InfoConvenio.this.textFilial.isVisible()) {
                    InfoConvenio.this.setFilial(Variaveis.filialPadrao);
                }
            }
        });
        this.buttonFechar.addActionListener(this);
        this.buttonFechar.setMnemonic('F');
        this.textCodigo.setEditable(false);
        this.textNorma.setEditable(false);
        this.textObservacao.setEditable(false);
        this.textNorma.setWrapStyleWord(true);
        this.textNorma.setLineWrap(true);
        this.textFilial.setPreferredSize(new Dimension(60, 20));
        this.textFilial.setMinimumSize(new Dimension(60, 20));
        this.textCodigo.setPreferredSize(new Dimension(60, 20));
        this.textCodigo.setMinimumSize(new Dimension(60, 20));
        this.labelDescCNPJ.setPreferredSize(new Dimension(20, 20));
        this.labelDescCNPJ.setMinimumSize(new Dimension(20, 20));
        this.labelDescConvenio.setPreferredSize(new Dimension(20, 20));
        this.labelDescConvenio.setMinimumSize(new Dimension(20, 20));
        this.labelDescRazao.setPreferredSize(new Dimension(20, 20));
        this.labelDescRazao.setMinimumSize(new Dimension(20, 20));
        this.labelDescFantazia.setPreferredSize(new Dimension(20, 20));
        this.labelDescFantazia.setMinimumSize(new Dimension(20, 20));
        this.labelDescEndereco.setPreferredSize(new Dimension(20, 20));
        this.labelDescEndereco.setMinimumSize(new Dimension(20, 20));
        this.labelDescCidade.setPreferredSize(new Dimension(20, 20));
        this.labelDescCidade.setMinimumSize(new Dimension(20, 20));
        this.labelDescFone.setPreferredSize(new Dimension(20, 20));
        this.labelDescFone.setMinimumSize(new Dimension(20, 20));
        this.labelDescContato.setPreferredSize(new Dimension(20, 20));
        this.labelDescContato.setMinimumSize(new Dimension(20, 20));
        this.labelDescModelo.setPreferredSize(new Dimension(20, 20));
        this.labelDescModelo.setMinimumSize(new Dimension(20, 20));
        this.labelDescConvenioProibido.setForeground(Color.red);
        this.scrollNorma.setBounds(new Rectangle(124, 20, 400, 145));
        ScreenUtil.setBorda(new Component[]{this.labelDescConvenio, this.labelDescRazao, this.labelDescFantazia, this.labelDescEndereco, this.labelDescCidade, this.labelDescFone, this.labelDescContato, this.labelDescModelo, this.labelDescCNPJ, this.labelDescTabela, this.labelCodigoTabela, this.labelCodigoModelo}, this.borda);
        boolean integrar = !ParametrosGerais.getTipoIntegracao().equals("N");
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 17;
        if (integrar) {
            this.panelCodigo.add((Component)this.labelFilial, c);
            c.gridx = 2;
        }
        this.panelCodigo.add((Component)this.labelCodigo, c);
        c.gridx += 3;
        this.panelCodigo.add((Component)this.labelCNPJ, c);
        c.gridx = 0;
        c.gridy = 1;
        if (integrar) {
            this.textFilial.setPreferredSize(new Dimension(65, 20));
            this.textFilial.setMinimumSize(new Dimension(65, 20));
            this.panelCodigo.add((Component)this.textFilial, c);
            ++c.gridx;
            this.panelCodigo.add((Component)this.buttonFilial, c);
            ++c.gridx;
        }
        this.textCodigo.setPreferredSize(new Dimension(65, 20));
        this.textCodigo.setMinimumSize(new Dimension(65, 20));
        this.panelCodigo.add((Component)this.textCodigo, c);
        ++c.gridx;
        this.buttonBusca.setPreferredSize(new Dimension(20, 20));
        this.buttonBusca.setMinimumSize(new Dimension(20, 20));
        this.buttonBusca.setMaximumSize(new Dimension(20, 20));
        this.panelCodigo.add((Component)this.buttonBusca, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        this.panelCodigo.add((Component)this.labelDescConvenio, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.labelDescCNPJ.setPreferredSize(new Dimension(200, 20));
        this.labelDescCNPJ.setMinimumSize(new Dimension(200, 20));
        this.panelCodigo.add((Component)this.labelDescCNPJ, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelCodigo.add((Component)this.labelRazao, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 2;
        c.gridwidth = integrar ? 5 : 3;
        this.labelDescRazao.setPreferredSize(new Dimension(100, 20));
        this.panelCodigo.add((Component)this.labelDescRazao, c);
        c.gridx = 0;
        ++c.gridy;
        this.panelCodigo.add((Component)this.labelEndereco, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = integrar ? 4 : 2;
        this.labelDescEndereco.setPreferredSize(new Dimension(80, 20));
        this.panelCodigo.add((Component)this.labelDescEndereco, c);
        c.gridx = c.gridx + (integrar ? 4 : 2);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        this.labelDescCidade.setPreferredSize(new Dimension(150, 20));
        JPanel p = ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.labelCidade, this.labelDescCidade);
        this.panelCodigo.add((Component)p, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        this.panelCodigo.add((Component)this.labelContato, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = integrar ? 4 : 2;
        this.labelDescEndereco.setPreferredSize(new Dimension(80, 20));
        this.panelCodigo.add((Component)this.labelDescContato, c);
        c.gridx = c.gridx + (integrar ? 4 : 2);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        this.labelDescFone.setPreferredSize(new Dimension(150, 20));
        p = ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.labelFone, this.labelDescFone);
        this.panelCodigo.add((Component)p, c);
        c.gridx = 0;
        ++c.gridy;
        c.fill = 0;
        c.weightx = 0.0;
        c.anchor = 17;
        this.panelCodigo.add((Component)this.labelModelo, c);
        ++c.gridx;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = integrar ? 4 : 2;
        this.labelCodigoModelo.setPreferredSize(new Dimension(40, 20));
        this.labelDescModelo.setPreferredSize(new Dimension(250, 20));
        p = ComponenteFactory.novoJPanelFlowLayout(0, 0, 0, this.labelDescModelo);
        this.panelCodigo.add((Component)p, c);
        c.gridx = c.gridx + (integrar ? 4 : 2);
        c.gridwidth = 1;
        c.fill = 0;
        c.anchor = 13;
        c.weightx = 0.0;
        this.labelCodigoTabela.setPreferredSize(new Dimension(40, 20));
        this.labelDescTabela.setPreferredSize(new Dimension(150, 20));
        p = ComponenteFactory.novoJPanelFlowLayout(2, 0, 0, this.labelTabela, this.labelDescTabela);
        this.panelCodigo.add((Component)p, c);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.gridwidth = 2;
        this.constraints.fill = 2;
        this.add((Component)this.panelCodigo, this.constraints);
        JPanel panelExigencias = new JPanel(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        this.constraints.gridx = 0;
        this.constraints.gridy = 7;
        Insets ioriginal = this.constraints.insets;
        this.constraints.insets = new Insets(2, ioriginal.left, 2, ioriginal.right);
        this.add((Component)panelExigencias, this.constraints);
        panelExigencias.setBorder(new CompoundBorder(new TitledBorder(""), BorderFactory.createEmptyBorder(5, 2, 5, 2)));
        cons.gridy = 0;
        cons.gridx = 0;
        cons.anchor = 17;
        this.labelExigeValidadeGuia.setPreferredSize(new Dimension(110, 15));
        panelExigencias.add((Component)this.labelExigeValidadeGuia, cons);
        ++cons.gridx;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 0, 2);
        this.labelDescExigeValidadeGuia.setPreferredSize(new Dimension(70, 15));
        panelExigencias.add((Component)this.labelDescExigeValidadeGuia, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.weightx = 0.0;
        this.labelExigePlano.setPreferredSize(new Dimension(112, 15));
        panelExigencias.add((Component)this.labelExigePlano, cons);
        cons.gridy = 1;
        ++cons.gridx;
        this.labelDescExigePlano.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescExigePlano, cons);
        cons.gridy = 0;
        ++cons.gridx;
        panelExigencias.add((Component)this.labelExigeUnidadeSaude, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.labelDescExigeUnidadeSaude.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescExigeUnidadeSaude, cons);
        cons.gridy = 1;
        cons.gridx = 2;
        panelExigencias.add((Component)this.labelExigeValidadeCarteira, cons);
        ++cons.gridx;
        this.labelDescExigeValidadeCarteira.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescExigeValidadeCarteira, cons);
        cons.gridy = 0;
        ++cons.gridx;
        panelExigencias.add((Component)this.labelExigeGuia, cons);
        ++cons.gridx;
        this.labelDescExigeGuia.setPreferredSize(new Dimension(80, 15));
        panelExigencias.add((Component)this.labelDescExigeGuia, cons);
        cons.gridy = 1;
        cons.gridx = 4;
        panelExigencias.add((Component)this.labelExigeMatricula, cons);
        cons.gridx = 5;
        cons.weightx = 1.0;
        cons.anchor = 17;
        this.labelDescExigeMatricula.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescExigeMatricula, cons);
        cons.gridy = 2;
        cons.gridx = 0;
        cons.weightx = 0.0;
        this.labelFatEletronico.setPreferredSize(new Dimension(100, 15));
        panelExigencias.add((Component)this.labelFatEletronico, cons);
        cons.gridx = 1;
        this.labelDescFatEletronico.setPreferredSize(new Dimension(60, 15));
        this.labelDescFatEletronico.setMinimumSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescFatEletronico, cons);
        ++cons.gridx;
        this.labelHospital.setPreferredSize(new Dimension(120, 15));
        panelExigencias.add((Component)this.labelHospital, cons);
        ++cons.gridx;
        this.labelDescHospital.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescHospital, cons);
        ++cons.gridx;
        this.labelValorCH.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelValorCH, cons);
        ++cons.gridx;
        this.labelDescValorCH.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescValorCH, cons);
        ++cons.gridy;
        cons.gridx = 0;
        this.labelValidade.setPreferredSize(new Dimension(100, 15));
        panelExigencias.add((Component)this.labelValidade, cons);
        cons.gridy = 3;
        cons.gridx = 1;
        this.labelDescValidade.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescValidade, cons);
        ++cons.gridx;
        this.labelPercPagBalcao.setPreferredSize(new Dimension(119, 15));
        panelExigencias.add((Component)this.labelPercPagBalcao, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.labelDescPercPagBalcao.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescPercPagBalcao, cons);
        ++cons.gridx;
        cons.weightx = 0.0;
        panelExigencias.add((Component)this.labelTipoCalculo, cons);
        ++cons.gridx;
        cons.weightx = 1.0;
        this.labelDescTipoCalculo.setPreferredSize(new Dimension(70, 15));
        panelExigencias.add((Component)this.labelDescTipoCalculo, cons);
        ++cons.gridy;
        cons.gridx = 0;
        panelExigencias.add((Component)this.labelExamesPermitidos, cons);
        ++cons.gridx;
        this.labelDescPermitidos.setPreferredSize(new Dimension(60, 15));
        panelExigencias.add((Component)this.labelDescPermitidos, cons);
        this.constraints.gridx = 0;
        this.constraints.gridy = 8;
        this.aba.setPreferredSize(new Dimension(0, 160));
        this.aba.setMinimumSize(new Dimension(0, 160));
        this.aba.add((Component)this.scrollNorma, "Normas");
        this.aba.add((Component)this.scrollObservacao, "Observa\u00e7\u00e3o");
        this.aba.setMnemonicAt(0, 78);
        this.aba.setMnemonicAt(1, 79);
        this.add((Component)this.aba, this.constraints);
        ScreenUtil.addActionMap(this.aba, KeyStroke.getKeyStroke(78, 8), "ALT_N", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoConvenio.this.aba.setSelectedIndex(0);
            }
        });
        ScreenUtil.addActionMap(this.aba, KeyStroke.getKeyStroke(79, 8), "ALT_O", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoConvenio.this.aba.setSelectedIndex(1);
            }
        });
        JPanel panelProibido = new JPanel(new BorderLayout());
        panelProibido.add((Component)this.labelDescConvenioProibido, "West");
        JPanel panelBotaoA = new JPanel(new BorderLayout());
        panelBotaoA.add((Component)this.panelBotao, "East");
        panelBotaoA.add((Component)panelProibido, "Center");
        this.constraints.gridx = 0;
        this.constraints.gridy = 10;
        this.constraints.fill = 2;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.grid.setConstraints(panelBotaoA, this.constraints);
        this.add(panelBotaoA);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

