/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Acesso;
import jalis.comum.Tipos;
import jalis.comum.informacao.InfoExames;
import jalis.util.ScreenUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class ExamesRender
extends DefaultTableCellRenderer {
    private boolean acessoPreparoEspecial = Acesso.getAcesso(Long.parseLong("0000200013"));
    private final int COLUNA_SITUACAO = 4;
    private final int COLUNA_INFO = 5;
    private Font fontePadrao = this.getFont();

    ExamesRender() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setText(value != null ? value.toString() : "");
        InfoExames info = null;
        if (table.getModel().getColumnCount() >= 5 && table.getModel().getValueAt(row, 5) != null && table.getModel().getValueAt(row, 5) instanceof InfoExames) {
            info = (InfoExames)table.getModel().getValueAt(row, 5);
        }
        if (column == 4) {
            this.setText(Tipos.tipoSituacaoExame(value.toString()));
        }
        if (info != null && info.isPreparoEspecial() && this.acessoPreparoEspecial) {
            Font f = this.getFont();
            f = new Font(f.getFontName(), 1, f.getSize());
            this.setFont(f);
            this.setToolTipText("<html>" + table.getToolTipText() + "<br>Exame com preparo especial, pressione Ctrl+H para visualizar</html>");
        } else {
            this.setFont(this.fontePadrao);
            this.setToolTipText("");
        }
        String situacao = table.getValueAt(row, 4).toString();
        Color corBack = Tipos.getCorSituacaoExame(situacao)[0];
        Color corFore = Tipos.getCorSituacaoExame(situacao)[1];
        if (situacao.trim().equals("")) {
            corBack = isSelected ? table.getSelectionBackground() : table.getBackground();
        } else if (isSelected) {
            corBack = ScreenUtil.escurecerCor(corBack, 20);
        }
        this.setBackground(corBack);
        this.setForeground(corFore);
        return this;
    }
}

