/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.informacao;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.resultados.DialogoResultadosAnteriores;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;

class ExamesAnteriores
extends JDialog {
    private JTable tabela = new JTable();
    private JScrollPane scroll = new JScrollPane(this.tabela);
    private ModeloGridTable modelo = null;
    private JButton buttonFechar = new JButton("Fechar");
    private JButton buttonMostrarDetalhe = new JButton("Detalhar resultados");
    private JPanel panelBotao = new JPanel();
    private JPanel panelBotaoB = new JPanel(new FlowLayout(2));
    private JFreeChart chart;
    private ChartPanel panelChart;
    private String codigoFilial;
    private JTextField textFilial = new TTextField(8, 1);
    private String codigoRequisicoes;
    private String codigoPacientes;
    private String nomePacientes;

    private String getCodigoFilial() {
        String tmp;
        if ((ParametrosGerais.getMostrarFilialDigitacao() || !ParametrosGerais.getTipoIntegracao().equals("N")) && (tmp = this.textFilial.getText().trim()).matches("\\-?\\d+")) {
            return tmp;
        }
        return Variaveis.filialPadrao;
    }

    public void setRequisicao(String paciente, String nomePaciente, String requisicaoAtual) {
        this.codigoRequisicoes = requisicaoAtual;
        this.codigoPacientes = paciente;
        this.nomePacientes = nomePaciente;
    }

    private void visualizarResultadosAnteriores() {
        DialogoResultadosAnteriores dialogo = DialogoResultadosAnteriores.novaInstancia(this);
        if (dialogo != null && dialogo.setPaciente(this, this.getCodigoFilial(), this.codigoPacientes, this.nomePacientes, this.codigoRequisicoes)) {
            dialogo.setVisible(true);
        }
    }

    public ExamesAnteriores(Dialog owner, String filial) {
        super(owner, true);
        this.codigoFilial = filial;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace(), "InfoRequisicao");
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(500, 430));
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.buttonMostrarDetalhe.setVisible(Acesso.getAcesso(Long.parseLong("0000200007")));
        this.add((Component)this.panelBotao, "South");
        this.add((Component)this.scroll, "North");
        Border border = this.scroll.getBorder();
        this.scroll.setBorder(new CompoundBorder(ScreenUtil.criarBordaVazia(), border));
        this.panelBotaoB.setPreferredSize(new Dimension(480, 30));
        this.panelBotaoB.add(this.buttonMostrarDetalhe);
        this.panelBotao.add(this.panelBotaoB);
        this.scroll.setPreferredSize(new Dimension(200, 200));
        this.modelo = ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente() ? new ModeloGridTable(new String[]{"Data", "Hora", "Filial", "Requisi\u00e7\u00e3o", "Resultado"}) : new ModeloGridTable(new String[]{"Data", "Hora", "Requisi\u00e7\u00e3o", "Resultado"});
        this.tabela.setModel(this.modelo);
        this.buttonFechar.setMnemonic('F');
        this.buttonMostrarDetalhe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExamesAnteriores.this.visualizarResultadosAnteriores();
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExamesAnteriores.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (ExamesAnteriores.this.tabela.getRowCount() > 0) {
                    ExamesAnteriores.this.tabela.grabFocus();
                } else {
                    ExamesAnteriores.this.buttonFechar.grabFocus();
                }
            }
        });
    }

    public void setPaciente(int paciente, String exame, int material) {
        this.modelo.clear();
        Object[] filiais = new String[]{this.codigoFilial};
        if (ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente()) {
            String[] stringArray;
            if (!Funcoes.textoVazio(ParametrosGerais.getCopiaPaciente())) {
                stringArray = StringUtil.getValor(ParametrosGerais.getCopiaPaciente(), "filiais").split(",");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.codigoFilial;
            }
            filiais = stringArray;
            if (filiais == null || filiais.length == 0 || ArraysUtil.indice(filiais, this.codigoFilial) < 0) {
                filiais = new String[]{this.codigoFilial};
            }
        }
        Statement st = Conexao.getStatement();
        StringBuffer buf = new StringBuffer("select  a.fil_codigo, a.exc_data, a.exc_hora, a.req_codigo, a.exc_resultado, b.pac_nome, c.req_excluida ");
        buf.append("from examescontrole a ");
        buf.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
        buf.append("left join requisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
        buf.append("where a.fil_codigo in (");
        for (int i = 0; i < filiais.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append((String)filiais[i]);
        }
        buf.append(") and a.pac_codigo = ");
        buf.append(String.valueOf(paciente));
        buf.append(" and a.exa_codigo = '");
        buf.append(StringUtil.textoDB(exame));
        buf.append("' and mco_codigo = ");
        buf.append(String.valueOf(material));
        buf.append(" order by a.exc_data desc, a.exc_hora desc");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            TimeSeries serie = new TimeSeries("Data", Minute.class);
            String nomePaciente = "";
            while (rs.next()) {
                if (rs.getBoolean("req_excluida")) continue;
                nomePaciente = rs.getString("pac_nome");
                String resultado = this.pegaResultado(rs.getString("exc_resultado"));
                if (Funcoes.isNumeric(resultado)) {
                    serie.addOrUpdate((RegularTimePeriod)new Minute(Funcoes.timestampToDate(Funcoes.formataData("yyyy/MM/dd", rs.getDate("exc_data")) + " " + Funcoes.formataHora(rs.getTime("exc_hora"), true))), Double.parseDouble(Funcoes.limpaDecimal(resultado)));
                }
                if (ParametrosGerais.isPesquisarAnterioresAutocopiaPaciente()) {
                    this.modelo.addLine(new String[]{Funcoes.formataData(rs.getDate("exc_data")), Funcoes.formataHora(rs.getTime("exc_hora"), false), rs.getString("fil_codigo"), rs.getString("req_codigo"), resultado});
                    continue;
                }
                this.modelo.addLine(new String[]{Funcoes.formataData(rs.getDate("exc_data")), Funcoes.formataHora(rs.getTime("exc_hora"), false), rs.getString("req_codigo"), resultado});
            }
            rs.close();
            st.close();
            TimeSeriesCollection dataset = new TimeSeriesCollection(serie);
            this.chart = ChartFactory.createTimeSeriesChart((String)"", (String)"", (String)"", (XYDataset)dataset, (boolean)false, (boolean)true, (boolean)false);
            XYPlot plot = this.chart.getXYPlot();
            XYItemRenderer r = plot.getRenderer();
            if (r instanceof XYLineAndShapeRenderer) {
                XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
                renderer.setDefaultShapesVisible(true);
            }
            DateAxis axis = (DateAxis)plot.getDomainAxis();
            axis.setDateFormatOverride((DateFormat)new SimpleDateFormat("dd/MMM/yyyy"));
            NumberAxis axisN = (NumberAxis)plot.getRangeAxis();
            axisN.setNumberFormatOverride((NumberFormat)new DecimalFormat("#######0.##"));
            this.panelChart = new ChartPanel(this.chart);
            this.add((Component)this.panelChart, "Center");
            this.setTitle(nomePaciente);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "InfoRequisicao");
        }
    }

    private String pegaResultado(String resultado) {
        StringBuffer xml = new StringBuffer(resultado);
        int start = xml.indexOf("<dataResultado>");
        int end = xml.indexOf("</dataResultado>");
        xml.delete(start, end + "</dataResultado>".length());
        start = xml.indexOf(">");
        end = xml.indexOf("</");
        if (start > -1 && end > -1) {
            return xml.substring(start + 1, end);
        }
        return "";
    }
}

