/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.detalhes;

import jalis.comum.detalhes.Detalhes;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class DetalhesRequisicaoFatura
extends Detalhes
implements ActionListener {
    private Registro requisicao = null;

    public DetalhesRequisicaoFatura(int situacao) {
        super(situacao, 11);
    }

    public void setRequisicao(Registro r) {
        if (r != null) {
            this.requisicao = r;
        }
        this.atualizarDados();
    }

    @Override
    public void montaExpandido() {
        this.setPreferredSize(new Dimension(10, 50));
        super.montaExpandido();
    }

    @Override
    public void montaReduzido() {
        this.setPreferredSize(new Dimension(10, 21));
        super.montaReduzido();
    }

    public void atualizar() {
        this.atualizarDados();
    }

    @Override
    protected void atualizarDados() {
        if (this.requisicao == null || this.getSituacao() == 2) {
            this.limpaDados();
        } else {
            StringBuilder buf = new StringBuilder("<html>");
            buf.append("<table width=\"100%\" cellspacing=2 cellpadding=0>");
            buf.append("<font size=20>");
            buf.append("<tr>");
            buf.append("<td nowrap><b>M\u00e9dico:</b></td><td width=230>").append(this.requisicao.getString("med_nome")).append("</td>");
            buf.append("<td nowrap><b>Dt. Requisi\u00e7\u00e3o:</b></td><td nowrap width=80>").append(this.dataFormatada(this.requisicao, "req_data")).append("</td>");
            buf.append("<td nowrap><b>Situa\u00e7\u00e3o:</b></td><td nowrap>").append(this.requisicao.getString("sit_descricao")).append("</td>");
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td nowrap><b>Usu\u00e1rio:</b></td><td>").append(this.requisicao.getString("usr_codigo")).append("</td>");
            buf.append("<td nowrap><b>Data Fatura:</b></td><td nowrap>").append(this.dataFormatada(this.requisicao, "req_dtfatura")).append("</td>");
            buf.append("<td nowrap><b>Deve Guia:</b></td><td nowrap>").append(this.requisicao.getBoolean("req_deveguia") ? "<font color='red'>Sim</font>" : "N\u00e3o").append("</td>");
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td nowrap><b>Titular:</b></td><td>").append(this.requisicao.getString("req_titular")).append("</td>");
            String data = "";
            try {
                data = Funcoes.formataData(this.requisicao.getDate("req_dataguia"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            buf.append("<td nowrap><b>Data Guia:</b></td><td nowrap>").append(data).append("</td>");
            String validade = "";
            try {
                validade = Funcoes.formataData(this.requisicao.getDate("req_validadeguia"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            buf.append("<td nowrap><b>Validade Guia:</b></td><td nowrap>").append(validade).append("</td></b>");
            buf.append("</tr>");
            buf.append("<tr>");
            if (Funcoes.textoVazio(this.requisicao.getString("conveniorepasse"))) {
                buf.append("<td nowrap><b>Repasse:</b></td><td>");
            } else {
                buf.append("<td nowrap><b>Repasse:</b></td><td>").append(this.requisicao.getString("conveniorepasse") + " (" + this.requisicao.getInt("codigorepasse") + ")").append("</td>");
            }
            buf.append("<td nowrap><b>Guia Principal:</b></td><td nowrap>").append(this.requisicao.getString("req_guiaprincipal")).append("</td>");
            buf.append("</tr>");
            buf.append("<tr>");
            buf.append("<td nowrap><b>Unid. Sa\u00fade:</b></td><td width=230>").append(this.getDescricaoUnidadeSaude()).append("</td>");
            buf.append("<td nowrap><b>Multiguia(s):</b></td><td colspan=3>").append(this.getMultiguias()).append("</td>");
            buf.append("</tr>");
            buf.append("</table></font></html>");
            this.setDetalhes(buf.toString());
        }
    }

    private String getDescricaoUnidadeSaude() {
        String unidadeSaude = this.requisicao.getString("uns_descricao");
        if (!Funcoes.textoVazio(unidadeSaude) && unidadeSaude.trim().length() > 30) {
            unidadeSaude = unidadeSaude.substring(0, 27) + "...";
        }
        return unidadeSaude;
    }

    private String dataFormatada(Registro r, String campo) {
        try {
            return Funcoes.formataData(r.getDate(campo));
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getMultiguias() {
        Integer[] guias = null;
        try {
            guias = RecepcaoUtil.verificaMultiGuias(this.requisicao.getString("fil_codigo"), this.requisicao.getString("req_codigo"), false);
            if (guias != null && guias.length > 5) {
                this.setPreferredSize(new Dimension(10, 65));
            }
            this.repaint();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (guias == null || guias.length == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < guias.length; ++i) {
            Integer guia = guias[i];
            if (guia == null) continue;
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(guia);
        }
        return buf.toString();
    }

    public Dimension getLabelDimension() {
        return this.getLabelPreferredSize();
    }
}

