/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.detalhes;

import jalis.comum.detalhes.Detalhes;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.awt.Dimension;
import java.awt.event.ActionListener;

public class DetalhesRequisicao
extends Detalhes
implements ActionListener {
    private Registro requisicao = null;

    public DetalhesRequisicao(int situacao) {
        super(situacao);
    }

    public void setRequisicao(Registro r) {
        if (r != null) {
            this.requisicao = r;
        }
        this.atualizarDados();
    }

    @Override
    public void montaExpandido() {
        this.setPreferredSize(new Dimension(10, 60));
        super.montaExpandido();
    }

    @Override
    public void montaReduzido() {
        this.setPreferredSize(new Dimension(10, 21));
        super.montaReduzido();
    }

    @Override
    protected void atualizarDados() {
        if (this.requisicao == null || this.getSituacao() == 2) {
            this.limpaDados();
        } else {
            StringBuilder buf = new StringBuilder("<html>");
            buf.append("<font size=2>");
            buf.append("<table width='600'>");
            buf.append("<tr><td>M&eacute;dico:</td><td width='65%'>").append(this.requisicao.getString("med_nome")).append("</td>");
            buf.append("<td>Data requisi&ccedil;&atilde;o:</td><td>").append(this.dataFormatada(this.requisicao, "req_data")).append("</td></tr>");
            buf.append("<tr><td>Situa&ccedil;&atilde;o:</td><td>").append(this.requisicao.getString("sit_descricao")).append("</td>");
            buf.append("<td>Data fatura:</td><td>").append(this.dataFormatada(this.requisicao, "req_data")).append("</td></tr>");
            buf.append("<tr><td>Usu&aacute;rio:</td><td>").append(this.requisicao.getString("usr_codigo")).append("</td>");
            buf.append("<td>Deve guia:</td><td>").append(this.requisicao.getBoolean("req_deveguia") ? "<font color='red'>Sim</font>" : "N&atilde;o").append("</td></tr>");
            buf.append("<tr><td>Titular:</td><td colspan='3'>").append(this.requisicao.getString("req_titular")).append("</td></tr>");
            buf.append("</table></font></html>");
            this.setDetalhes(buf.toString());
        }
    }

    private String dataFormatada(Registro r, String campo) {
        try {
            return Funcoes.formataData(r.getDate(campo));
        }
        catch (Exception e) {
            return "";
        }
    }
}

