/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.detalhes;

import jalis.comum.ConstantesGerais;
import jalis.comum.detalhes.DetalhesExpandidoListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class Detalhes
extends JPanel
implements ActionListener {
    public static final int EXPANDIDO = 1;
    public static final int REDUZIDO = 2;
    private int situacao = 2;
    private int posicao = 11;
    private JLabel labelDetalhes = new JLabel();
    private JButton buttonExpandir = new JButton("+");
    private ArrayList<DetalhesExpandidoListener> listener = new ArrayList();

    public Detalhes(int situacao) {
        this.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        this.labelDetalhes.setFont(new Font(this.labelDetalhes.getFont().getName(), 0, 10));
        this.buttonExpandir.addActionListener(this);
        this.setSituacao(situacao);
        this.montar();
    }

    public Detalhes(int situacao, int posicaoBotaoExpandir) {
        this.setBackground(ConstantesGerais.COR_FUNDO_CREME);
        this.labelDetalhes.setFont(new Font(this.labelDetalhes.getFont().getName(), 0, 10));
        this.buttonExpandir.addActionListener(this);
        this.setSituacao(situacao);
        this.setPosicaoBotaoExpandir(this.posicao);
        this.montar();
    }

    public int getSituacao() {
        return this.situacao;
    }

    public void setSituacao(int situacao) {
        this.situacao = situacao;
    }

    protected abstract void atualizarDados();

    protected void setDetalhes(String detalhes) {
        this.labelDetalhes.setText(detalhes);
    }

    protected void setPosicaoBotaoExpandir(int posicao) {
        if (posicao == 15 || posicao == 11) {
            this.posicao = posicao;
        }
    }

    protected String getDetalhes() {
        return this.labelDetalhes.getText();
    }

    public void limpaDados() {
        this.labelDetalhes.setText("<html><font size=2><table><tr><b>Detalhes</b></tr></table></font></html>");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonExpandir) {
            this.expandir();
        }
    }

    private void montar() {
        this.buttonExpandir.setPreferredSize(new Dimension(20, 20));
        this.buttonExpandir.setMaximumSize(new Dimension(20, 20));
        this.buttonExpandir.setMinimumSize(new Dimension(20, 20));
        this.labelDetalhes.setHorizontalAlignment(2);
        this.labelDetalhes.setVerticalAlignment(1);
        this.buttonExpandir.setMargin(new Insets(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = this.posicao;
        c.weighty = 0.0;
        this.add((Component)this.buttonExpandir, c);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)this.labelDetalhes, c);
        this.limpaDados();
        if (this.situacao == 2) {
            this.montaReduzido();
        } else {
            this.montaExpandido();
        }
    }

    private void expandir() {
        if (this.situacao == 2) {
            this.situacao = 1;
            this.montaExpandido();
        } else {
            this.situacao = 2;
            this.montaReduzido();
        }
        this.fireDetalhesExpandido();
        this.atualizarDados();
    }

    public void montaExpandido() {
        this.buttonExpandir.setText("-");
        this.atualizarDados();
    }

    public void montaReduzido() {
        this.buttonExpandir.setText("+");
        this.atualizarDados();
    }

    public void addDetalhesExpandidoListener(DetalhesExpandidoListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void fireDetalhesExpandido() {
        for (DetalhesExpandidoListener l : this.listener) {
            l.situacaoAlterada(this.situacao);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.buttonExpandir.setEnabled(enabled);
    }

    public void setBotaoExpandirVisible(boolean visible) {
        this.buttonExpandir.setVisible(false);
    }

    public boolean isBotaoExpandirVisible() {
        return this.buttonExpandir.isVisible();
    }

    @Override
    public boolean isEnabled() {
        return this.buttonExpandir.isEnabled();
    }

    @Override
    public Font getFont() {
        if (this.labelDetalhes == null) {
            return null;
        }
        return this.labelDetalhes.getFont();
    }

    @Override
    public void setFont(Font fonte) {
        if (this.labelDetalhes != null) {
            this.labelDetalhes.setFont(fonte);
        }
    }

    public Dimension getLabelPreferredSize() {
        return this.labelDetalhes.getPreferredSize();
    }
}

