/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.dados.faturamento;

import jalis.comum.ParametrosGerais;
import jalis.comum.dados.faturamento.DadosExamePaiAgrupamento;
import jalis.comum.dados.faturamento.DadosMaterialFaturamento;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;

public class DadosExameFaturamento
implements Comparable {
    private String codigoExame;
    private Integer codigoMaterial;
    private String codigoAutorizacao;
    private Date dataAutorizacao;
    private Date validadeAutorizacao;
    private String nomeExame;
    private BigDecimal valorTotalExame;
    private BigDecimal valorExame;
    private BigDecimal valorCHExame;
    private BigDecimal valorCH;
    private BigDecimal valorMaterial;
    private Date dataExame;
    private String codigoUsuarioExame;
    private String descricaoMaterial;
    private String abreviaturaMaterial;
    private String codigoAMB;
    private String codigoCBHPM;
    private BigDecimal valorBalcao;
    private String motivoPrazo;
    private DadosExamePaiAgrupamento examePai;
    private String situacaoExame;
    private String codigoGuia;
    private Date validadeGuia;
    private Date dataGuia;
    private boolean deveGuia;
    private String codigoMetodologia;
    private BigDecimal custoCBHPM;
    private BigDecimal ucoCBHPM;
    private String porteCBHPM;
    private BigDecimal valorPorteCBHPM;
    private Integer notaIPERGS = null;
    private boolean exameExpandido = false;
    private boolean faturar = true;
    private boolean marcadoNaoFaturar = true;
    private boolean isConvenioRepasse = false;
    private String tipoCalculo;
    private BigDecimal valorCHExameRepasse;
    private BigDecimal valorCHRepasse;
    private BigDecimal custoCBHPMRepasse;
    private BigDecimal ucoCBHPMRepasse;
    private String porteCBHPMRepasse;
    private BigDecimal valorPorteCBHPMRepasse;
    private String codigoUsuarioNaoFaturar;
    private Integer ordemAdicao = 0;
    private Integer ordemExame = 0;
    private Integer codigoSetor = null;
    private Integer paginaExame = 0;
    private Date dataColeta = null;
    private Date dataConferencia = null;
    private boolean isProibido = false;
    private String tipoBPA = null;
    private boolean isFaturado = false;
    private boolean isDadosAlterados = false;
    private boolean isExamePaiAgrupamentoRequisicao = false;
    private String tipoAlimentos;
    private int casasDecimais = ParametrosGerais.getCasasPrecoExame();
    private RoundingMode tipoArredondamento = ParametrosGerais.getArredondamentoPrecoExame();
    private ArrayList<DadosMaterialFaturamento> material;

    public boolean isExamePaiAgrupamentoRequisicao() {
        return this.isExamePaiAgrupamentoRequisicao;
    }

    public boolean isDadosAlterados() {
        return this.isDadosAlterados;
    }

    public void setDadosAlterados(boolean isDadosAlterados) {
        this.isDadosAlterados = isDadosAlterados;
    }

    public boolean isValorAlterado(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return false;
        }
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.toString().equals(obj2.toString());
        }
        return false;
    }

    public void setDadosAlterados(boolean isDadosAlterados, boolean forcarTroca) {
        this.isDadosAlterados = forcarTroca ? isDadosAlterados : this.isDadosAlterados || isDadosAlterados;
    }

    public void setDataAutorizacao(Date dataAutorizacao) {
        this.dataAutorizacao = dataAutorizacao;
    }

    public Date getDataAutorizacao() {
        return this.dataAutorizacao;
    }

    public void setValidadeAutorizacao(Date validadeAutorizacao) {
        this.validadeAutorizacao = validadeAutorizacao;
    }

    public Date getValidadeAutorizacao() {
        return this.validadeAutorizacao;
    }

    public void setOrdemExame(int ordemExame) {
        this.ordemExame = ordemExame;
    }

    public Integer getOrdemExame() {
        return this.ordemExame;
    }

    public void setOrdemAdicao(int ordemAdicao) {
        this.ordemAdicao = ordemAdicao;
    }

    public Integer getOrdemAdicao() {
        return this.ordemAdicao;
    }

    public void setPaginaExame(int paginaExame) {
        this.paginaExame = paginaExame;
    }

    public Integer getPaginaExame() {
        return this.paginaExame;
    }

    public void setCodigoSetor(int codigoSetor) {
        this.codigoSetor = codigoSetor;
    }

    public Integer getCodigoSetor() {
        return this.codigoSetor;
    }

    public void setFaturado(boolean isFaturado) {
        this.isFaturado = isFaturado;
    }

    public boolean getFaturado() {
        return this.isFaturado;
    }

    public boolean isProibido() {
        return this.isProibido;
    }

    public void setProibido(boolean isProibido) {
        this.isProibido = isProibido;
    }

    public String getTipoBPA() {
        return this.tipoBPA;
    }

    public void setTipoBPA(String tipoBPA) {
        this.tipoBPA = tipoBPA;
    }

    public String getCodigoUsuarioNaoFaturar() {
        return this.codigoUsuarioNaoFaturar;
    }

    public void setCodigoUsuarioNaoFaturar(String codigoUsuarioNaoFaturar) {
        this.codigoUsuarioNaoFaturar = codigoUsuarioNaoFaturar;
    }

    public Date getValidadeGuia() {
        return this.validadeGuia;
    }

    public Date getDataGuia() {
        return this.dataGuia;
    }

    public boolean getDeveGuia() {
        return this.deveGuia;
    }

    public BigDecimal getValorCHExameRepasse() {
        return this.valorCHExameRepasse;
    }

    public BigDecimal getValorCHRepasse() {
        return this.valorCHRepasse;
    }

    public BigDecimal getCustoCBHPMRepasse() {
        return this.custoCBHPMRepasse;
    }

    public BigDecimal getUcoCBHPMRepasse() {
        return this.ucoCBHPMRepasse;
    }

    public String getPorteCBHPMRepasse() {
        return this.porteCBHPMRepasse;
    }

    public BigDecimal getValorPorteCBHPMRepasse() {
        return this.valorPorteCBHPMRepasse;
    }

    public DadosExameFaturamento(String codigo) {
        this.codigoExame = codigo;
    }

    public void setDeveGuia(boolean deveGuia) {
        this.deveGuia = deveGuia;
    }

    public void setValidadeGuia(Date validadeGuia) {
        this.validadeGuia = validadeGuia;
    }

    public void setDataGuia(Date dataGuia) {
        this.dataGuia = dataGuia;
    }

    public void setCodigoGuia(String codigo) {
        this.codigoGuia = codigo;
    }

    public void setCodigoExame(String codigo) {
        this.codigoExame = codigo;
    }

    public void setCodigoMaterial(Integer codigo) {
        this.codigoMaterial = codigo;
    }

    public void setCodigoAutorizacao(String codigo) {
        this.codigoAutorizacao = codigo;
    }

    public void setNomeExame(String nome) {
        this.nomeExame = nome;
    }

    public Date getDataColeta() {
        return this.dataColeta;
    }

    public void setDataColeta(Date dataColeta) {
        this.dataColeta = dataColeta;
    }

    public Date getDataConferencia() {
        return this.dataConferencia;
    }

    public void setDataConferencia(Date dataConferencia) {
        this.dataConferencia = dataConferencia;
    }

    public void setValorExame(BigDecimal valor) {
        valor = valor.setScale(this.casasDecimais, this.tipoArredondamento);
        this.setDadosAlterados(this.isValorAlterado(this.valorExame, valor), false);
        this.valorExame = valor;
    }

    public void setValorTotalExame(BigDecimal valorTotal) {
        this.valorTotalExame = valorTotal.setScale(this.casasDecimais, this.tipoArredondamento);
    }

    public void setValorCHExame(BigDecimal valor) {
        this.setDadosAlterados(this.isValorAlterado(this.valorCHExame, valor), false);
        this.valorCHExame = valor;
    }

    public void setValorCH(BigDecimal valor) {
        this.setDadosAlterados(this.isValorAlterado(this.valorCH, valor), false);
        this.valorCH = valor;
    }

    public void setValorMaterial(BigDecimal valor) {
        valor = valor != null ? valor.setScale(2, ParametrosGerais.getArredondamentoPrecoExame()) : new BigDecimal(0);
        this.setDadosAlterados(this.isValorAlterado(this.valorMaterial, valor), false);
        this.valorMaterial = valor;
    }

    public void setDataExame(Date data) {
        this.dataExame = data;
    }

    public Integer getNotaIPERGS() {
        return this.notaIPERGS;
    }

    public void setNotaIPERGS(Integer notaIPERGS) {
        this.setDadosAlterados(this.isValorAlterado(this.notaIPERGS, notaIPERGS), false);
        this.notaIPERGS = notaIPERGS;
    }

    public void setCodigoUsuarioExame(String usuario) {
        this.codigoUsuarioExame = usuario;
    }

    public void setDescricaoMaterial(String descricao) {
        this.descricaoMaterial = descricao;
    }

    public void setAbreviaturaMaterial(String abreviatura) {
        this.abreviaturaMaterial = abreviatura;
    }

    public void setCodigoAMB(String codigo) {
        this.codigoAMB = codigo;
    }

    public void setCodigoCBHPM(String codigo) {
        this.codigoCBHPM = codigo;
    }

    public void setExameExpandido(boolean b) {
        this.exameExpandido = b;
    }

    public void setFaturar(boolean b) {
        this.faturar = b;
    }

    public void setMarcadoNaoFaturar(boolean marcadoNaoFaturar) {
        this.marcadoNaoFaturar = marcadoNaoFaturar;
    }

    public void setValorBalcao(BigDecimal valor) {
        this.setDadosAlterados(this.isValorAlterado(this.valorBalcao, valor), false);
        this.valorBalcao = valor;
    }

    public void setConvenioRepasse(boolean isConvenioRepasse) {
        this.isConvenioRepasse = isConvenioRepasse;
    }

    public void setMotivoPrazo(String motivo) {
        this.motivoPrazo = motivo;
    }

    public void setTipoCalculo(String tipoCalculo) {
        this.tipoCalculo = tipoCalculo;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public String getCodigoGuia() {
        return this.codigoGuia;
    }

    public Integer getCodigoMaterial() {
        return this.codigoMaterial;
    }

    public String getCodigoAutorizacao() {
        return this.codigoAutorizacao;
    }

    public String getNomeExame() {
        return this.nomeExame;
    }

    public BigDecimal getValorExame() {
        return this.valorExame;
    }

    public BigDecimal getValorTotalExame() {
        return this.valorTotalExame;
    }

    public BigDecimal getValorCHExame() {
        return this.valorCHExame;
    }

    public BigDecimal getValorCH() {
        return this.valorCH;
    }

    public BigDecimal getValorMaterial() {
        return this.valorMaterial;
    }

    public Date getDataExame() {
        return this.dataExame;
    }

    public String getCodigoUsuarioExame() {
        return this.codigoUsuarioExame;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public String getAbreviaturaMaterial() {
        return this.abreviaturaMaterial;
    }

    public String getCodigoAMB() {
        return this.codigoAMB;
    }

    public String getCodigoCBHPM() {
        return this.codigoCBHPM;
    }

    public boolean getExameExpandido() {
        return this.exameExpandido;
    }

    public boolean getFaturar() {
        return this.faturar;
    }

    public boolean isMarcadoNaoFaturar() {
        return this.marcadoNaoFaturar;
    }

    public BigDecimal getValorBalcao() {
        return this.valorBalcao;
    }

    public void adicionaMaterial(DadosMaterialFaturamento material) {
        if (this.material == null) {
            this.material = new ArrayList();
        }
        this.material.add(material);
    }

    public int getMateriaisCount() {
        if (this.material != null) {
            return this.material.size();
        }
        return 0;
    }

    public DadosMaterialFaturamento getMaterial(int pos) {
        if (this.material != null) {
            return this.material.get(pos);
        }
        return null;
    }

    public void setExamePai(DadosExamePaiAgrupamento examePai, boolean isExamePaiAgrupamentoRequisicao) {
        if (examePai != null) {
            this.examePai = examePai;
        }
        this.isExamePaiAgrupamentoRequisicao = isExamePaiAgrupamentoRequisicao;
    }

    public DadosExamePaiAgrupamento getExamePai() {
        return this.examePai;
    }

    public String getMotivoPrazo() {
        return this.motivoPrazo;
    }

    public BigDecimal getCustoCBHPM() {
        return this.custoCBHPM;
    }

    public void setCustoCBHPM(BigDecimal custoCBHPM) {
        this.custoCBHPM = custoCBHPM;
    }

    public String getPorteCBHPM() {
        return this.porteCBHPM;
    }

    public void setPorteCBHPM(String porteCBHPM) {
        this.porteCBHPM = porteCBHPM;
    }

    public BigDecimal getUcoCBHPM() {
        return this.ucoCBHPM;
    }

    public void setUcoCBHPM(BigDecimal ucoCBHPM) {
        this.ucoCBHPM = ucoCBHPM;
    }

    public BigDecimal getValorPorteCBHPM() {
        return this.valorPorteCBHPM;
    }

    public void setValorPorteCBHPM(BigDecimal valorPorteCBHPM) {
        this.valorPorteCBHPM = valorPorteCBHPM;
    }

    public String getSituacaoExame() {
        return this.situacaoExame;
    }

    public void setSituacaoExame(String situacaoExame) {
        this.situacaoExame = situacaoExame;
    }

    public boolean isConvenioRepasse() {
        return this.isConvenioRepasse;
    }

    public String getTipoCalculo() {
        return this.tipoCalculo;
    }

    public void setValorCHExameRepasse(BigDecimal valorCHExameRepasse) {
        this.valorCHExameRepasse = valorCHExameRepasse;
    }

    public void setValorCHRepasse(BigDecimal valorCHRepasse) {
        this.valorCHRepasse = valorCHRepasse;
    }

    public void setCustoCBHPMRepasse(BigDecimal custoCBHPMRepasse) {
        this.custoCBHPMRepasse = custoCBHPMRepasse;
    }

    public void setUcoCBHPMRepasse(BigDecimal ucoCBHPMRepasse) {
        this.ucoCBHPMRepasse = ucoCBHPMRepasse;
    }

    public void setPorteCBHPMRepasse(String porteCBHPMRepasse) {
        this.porteCBHPMRepasse = porteCBHPMRepasse;
    }

    public void setValorPorteCBHPMRepasse(BigDecimal valorPorteCBHPMRepasse) {
        this.valorPorteCBHPMRepasse = valorPorteCBHPMRepasse;
    }

    public void setCodigoMetodologia(String codigoMetodologia) {
        this.codigoMetodologia = codigoMetodologia;
    }

    public String getCodigoMetodologia() {
        return this.codigoMetodologia;
    }

    public String getTipoAlimentos() {
        return this.tipoAlimentos;
    }

    public void setTipoAlimentos(String tipoAlimentos) {
        this.tipoAlimentos = tipoAlimentos;
    }

    public int getCasasDecimais() {
        return this.casasDecimais;
    }

    public void setCasasDecimais(int casasDecimais) {
        this.casasDecimais = casasDecimais;
    }

    public RoundingMode getTipoArredondamento() {
        return this.tipoArredondamento;
    }

    public void setTipoArredondamento(RoundingMode tipoArredondamento) {
        this.tipoArredondamento = tipoArredondamento;
    }

    public int compareTo(Object o) {
        if (!(o instanceof DadosExameFaturamento)) {
            return 0;
        }
        int ordem = 0;
        if (ParametrosGerais.getOrdemComprovante().equals("A")) {
            ordem += this.getOrdemAdicao().compareTo(((DadosExameFaturamento)o).getOrdemAdicao());
        } else {
            if (ParametrosGerais.getOrdenarSetor()) {
                ordem += this.getCodigoSetor().compareTo(((DadosExameFaturamento)o).getCodigoSetor());
            }
            if (ordem == 0) {
                if (ParametrosGerais.getOrdemComprovante().equals("C")) {
                    ordem += this.getCodigoExame().compareTo(((DadosExameFaturamento)o).getCodigoExame());
                } else if (ParametrosGerais.getOrdemComprovante().equals("P") && (ordem += this.getPaginaExame().compareTo(((DadosExameFaturamento)o).getPaginaExame())) == 0) {
                    ordem += this.getOrdemExame().compareTo(((DadosExameFaturamento)o).getOrdemExame());
                }
            }
        }
        if (ordem == 0) {
            ordem += this.getCodigoExame().compareTo(((DadosExameFaturamento)o).getCodigoExame());
        }
        if (ordem == 0) {
            ordem += this.getCodigoMaterial().compareTo(((DadosExameFaturamento)o).getCodigoMaterial());
        }
        return ordem;
    }

    public DadosExameFaturamento clone() {
        DadosExameFaturamento clone = new DadosExameFaturamento(this.codigoExame);
        clone.setOrdemExame(this.ordemExame);
        clone.setPaginaExame(this.paginaExame);
        if (this.codigoSetor != null) {
            clone.setCodigoSetor(this.codigoSetor);
        }
        clone.setFaturado(this.isFaturado);
        clone.setProibido(this.isProibido);
        clone.setCodigoUsuarioNaoFaturar(this.codigoUsuarioNaoFaturar);
        clone.setDeveGuia(this.deveGuia);
        clone.setValidadeGuia(this.validadeGuia);
        clone.setDataGuia(this.dataGuia);
        clone.setCodigoGuia(this.codigoGuia);
        clone.setCodigoMaterial(this.codigoMaterial);
        clone.setCodigoAutorizacao(this.codigoAutorizacao);
        clone.setNomeExame(this.nomeExame);
        clone.setValorExame(this.valorExame);
        clone.setValorTotalExame(this.valorTotalExame);
        clone.setValorCHExame(this.valorCHExame);
        clone.setValorCH(this.valorCH);
        clone.setValorMaterial(this.valorMaterial);
        clone.setDataExame(this.dataExame);
        clone.setNotaIPERGS(this.notaIPERGS);
        clone.setCodigoUsuarioExame(this.codigoUsuarioExame);
        clone.setDescricaoMaterial(this.descricaoMaterial);
        clone.setAbreviaturaMaterial(this.abreviaturaMaterial);
        clone.setCodigoAMB(this.codigoAMB);
        clone.setCodigoCBHPM(this.codigoCBHPM);
        clone.setExameExpandido(this.exameExpandido);
        clone.setFaturar(this.faturar);
        clone.setValorBalcao(this.valorBalcao);
        clone.setConvenioRepasse(this.isConvenioRepasse);
        clone.setMotivoPrazo(this.motivoPrazo);
        clone.setTipoCalculo(this.tipoCalculo);
        clone.setCustoCBHPM(this.custoCBHPM);
        clone.setPorteCBHPM(this.porteCBHPM);
        clone.setUcoCBHPM(this.ucoCBHPM);
        clone.setValorPorteCBHPM(this.valorPorteCBHPM);
        clone.setSituacaoExame(this.situacaoExame);
        clone.setValorCHExameRepasse(this.valorCHExameRepasse);
        clone.setValorCHRepasse(this.valorCHRepasse);
        clone.setCustoCBHPMRepasse(this.custoCBHPMRepasse);
        clone.setUcoCBHPMRepasse(this.ucoCBHPMRepasse);
        clone.setPorteCBHPMRepasse(this.porteCBHPMRepasse);
        clone.setValorPorteCBHPMRepasse(this.valorPorteCBHPMRepasse);
        clone.setDataAutorizacao(this.dataAutorizacao);
        clone.setValidadeAutorizacao(this.validadeAutorizacao);
        clone.setCodigoMetodologia(this.codigoMetodologia);
        clone.setTipoBPA(this.tipoBPA);
        clone.setCasasDecimais(this.casasDecimais);
        clone.setTipoAlimentos(this.tipoAlimentos);
        for (int i = 0; i < this.getMateriaisCount(); ++i) {
            clone.adicionaMaterial(this.getMaterial(i));
        }
        clone.setExamePai(this.examePai, this.isExamePaiAgrupamentoRequisicao);
        return clone;
    }
}

