/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.camera;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamException;
import com.github.sarxos.webcam.WebcamPanel;
import com.github.sarxos.webcam.WebcamResolution;
import jalis.comum.ParametrosLocais;
import jalis.comum.camera.FotoCapturada;
import jalis.comum.camera.FotoSelecionada;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class VisualizarVideo
extends JDialog
implements FotoSelecionada,
ActionListener {
    private static final String DISPOSITIVO_OCUPADO = "Cannot execute task";
    private JButton buttonCapturar = new JButton("Capturar");
    private JButton buttonFechar = new JButton("Fechar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private WebcamPanel player = null;
    private Webcam camera = null;
    private ImageIcon imageIcon;
    private boolean isOK = false;

    public VisualizarVideo(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public VisualizarVideo(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.setSize(300, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.buttonCapturar.setMnemonic('t');
        this.buttonFechar.setMnemonic('F');
        this.panelBotoes.add(this.buttonCapturar);
        this.panelBotoes.add(this.buttonFechar);
        this.conectaCamera();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (VisualizarVideo.this.player != null) {
                    VisualizarVideo.this.player = null;
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (VisualizarVideo.this.player != null) {
                    VisualizarVideo.this.player = null;
                }
            }
        });
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizarVideo.this.isOK = false;
                if (VisualizarVideo.this.player != null) {
                    VisualizarVideo.this.player.stop();
                }
                if (VisualizarVideo.this.player != null) {
                    VisualizarVideo.this.camera.close();
                }
                VisualizarVideo.this.setVisible(false);
            }
        });
        this.buttonCapturar.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonCapturar) {
            this.buttonCapturar.setVisible(false);
            FotoCapturada p = new FotoCapturada();
            p.addFotoSelecionadaListener(this);
            p.setImage(this.capture());
            this.remove((Component)this.player);
            if (this.player != null) {
                this.player.stop();
            }
            this.camera.close();
            this.isOK = true;
            if (this.player != null) {
                this.player = null;
            }
            this.add((Component)p, "Center");
            p.repaint();
            this.repaint();
        }
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    private void conectaCamera() {
        String nomeCamera = ParametrosLocais.getParametro("cameraCaptura");
        if (nomeCamera.equals("Sem c\u00e2mera")) {
            Funcoes.mensagem(this, "Nenhuma cam\u00eara configurada. Verifique a configura\u00e7\u00e3o da esta\u00e7\u00e3o.", 1);
            return;
        }
        List webcams = Webcam.getWebcams();
        for (Webcam webcam : webcams) {
            if (!webcam.getName().equalsIgnoreCase(nomeCamera)) continue;
            this.camera = webcam;
        }
        if (this.camera == null) {
            Funcoes.mensagem(this, "Cam\u00eara \"" + nomeCamera + "\" n\u00e3o localizada, Verifique a configura\u00e7\u00e3o da esta\u00e7\u00e3o.", 1);
            return;
        }
        try {
            Dimension size = WebcamResolution.QVGA.getSize();
            this.camera.setViewSize(size);
            Webcam.setAutoOpenMode((boolean)true);
            try {
                this.player = new WebcamPanel(this.camera, size, true);
            }
            catch (Exception e) {
                this.player = new WebcamPanel(this.camera, true);
            }
            this.player.setFillArea(true);
            this.add((Component)this.player, "Center");
        }
        catch (WebcamException ex) {
            if (ex.getMessage().equalsIgnoreCase(DISPOSITIVO_OCUPADO)) {
                Funcoes.mensagem(this, "Cam\u00eara \"" + nomeCamera + "\" est\u00e1 ocupada ou em uso por outra aplica\u00e7\u00e3o!", 1);
            }
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public Image capture() {
        Image img = null;
        if (this.camera != null) {
            BufferedImage bi = this.camera.getImage();
            img = bi.getScaledInstance(bi.getWidth(), bi.getHeight(), 4);
        }
        return img;
    }

    @Override
    public void fotoSelecionada(int x, int y) {
        BufferedImage i = null;
        try {
            int pos_X = this.getBounds().x + x + 6;
            int pos_Y = this.getBounds().y + y + 25;
            i = new Robot().createScreenCapture(new Rectangle(pos_X, pos_Y, 129, 148));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.imageIcon = new ImageIcon(i);
        this.setVisible(false);
    }

    public boolean isOk() {
        return this.isOK;
    }
}

