/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.camera;

import jalis.comum.camera.FotoCapturada;
import jalis.comum.camera.FotoSelecionada;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class VisualizarFoto
extends JDialog
implements FotoSelecionada {
    private JButton buttonCapturar = new JButton("Capturar");
    private JButton buttonFechar = new JButton("Fechar");
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private ImageIcon imageIcon;
    private boolean ok = false;

    public VisualizarFoto(Frame owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public VisualizarFoto(Dialog owner) {
        super(owner);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
    }

    public static VisualizarFoto novaInstancia(Object pai) {
        if (pai instanceof Frame) {
            return new VisualizarFoto((Frame)pai);
        }
        return new VisualizarFoto((Dialog)pai);
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelBotoes, "South");
        this.setSize(300, 300);
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
        this.setModal(true);
        this.buttonCapturar.setMnemonic('t');
        this.buttonFechar.setMnemonic('F');
        this.panelBotoes.add(this.buttonCapturar);
        this.panelBotoes.add(this.buttonFechar);
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VisualizarFoto.this.setVisible(false);
            }
        });
    }

    public void setFoto(Image foto) {
        if (foto != null) {
            FotoCapturada p = new FotoCapturada();
            p.addFotoSelecionadaListener(this);
            p.setImage(foto);
            this.add((Component)p, "Center");
            p.repaint();
            this.repaint();
        }
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    @Override
    public void fotoSelecionada(int x, int y) {
        BufferedImage i = null;
        try {
            int pos_X = this.getBounds().x + x + 6;
            int pos_Y = this.getBounds().y + y + 25;
            i = new Robot().createScreenCapture(new Rectangle(pos_X, pos_Y, 129, 148));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.imageIcon = new ImageIcon(i);
        this.setVisible(false);
        this.ok = true;
    }

    public boolean isOK() {
        return this.ok;
    }
}

