/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum.camera;

import jalis.comum.camera.FotoSelecionada;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RescaleOp;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class FotoCapturada
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final int DIFERENCA_X = 65;
    private static final int DIFERENCA_Y = 75;
    private static final int WIDTH = 130;
    private static final int HEIGHT = 150;
    private Image image;
    private int x = 0;
    private int y = 0;
    private int xSelecao = 0;
    private int ySelecao = 0;
    private BufferedImage bufferedImageDark;
    private BufferedImage bufferedImage;
    private int width = 290;
    private int height = 236;
    private boolean clicked = false;
    private ArrayList<FotoSelecionada> listener = new ArrayList();

    public FotoCapturada() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setImage(Image i) {
        this.image = i.getScaledInstance(this.width, this.height, 4);
        this.bufferedImageDark = this.convertImageToBuffered(this.image, this.width, this.height);
        this.bufferedImage = this.bufferedImageDark.getSubimage(0, 0, this.width, this.height);
        float scaleFactor = 0.5f;
        RescaleOp op = new RescaleOp(scaleFactor, 0.0f, null);
        this.bufferedImageDark = op.filter(this.bufferedImageDark, null);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.red);
        g2.drawImage(this.bufferedImageDark, 0, 0, this.width, this.height, null);
        int x = this.x - 65;
        int y = this.y - 75;
        if (x < 0) {
            x = 0;
        }
        if (x > this.getWidth() - 130 - 2) {
            x = this.getWidth() - 130 - 2;
        }
        if (this.bufferedImage.getWidth() < x + 130) {
            x -= x + 130 - this.bufferedImage.getWidth();
        }
        if (y < 0) {
            y = 0;
        }
        if (y > this.getHeight() - 150 - 2) {
            y = this.getHeight() - 150 - 2;
        }
        if (this.bufferedImage.getHeight() < y + 150) {
            y -= y + 150 - this.bufferedImage.getHeight();
        }
        g2.drawImage(this.bufferedImage.getSubimage(x, y, 130, 150), x, y, 130, 150, null);
        if (!this.clicked) {
            g2.drawRect(x, y, 130, 150);
        }
        this.xSelecao = x - 4;
        this.ySelecao = y + 4;
        this.xSelecao = this.xSelecao < 0 ? 0 : this.xSelecao;
        this.ySelecao = this.ySelecao < 0 ? 0 : this.ySelecao;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.clicked = true;
        this.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (FotoSelecionada f : FotoCapturada.this.listener) {
                    f.fotoSelecionada(FotoCapturada.this.xSelecao, FotoCapturada.this.ySelecao);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FotoCapturada.this.clicked = false;
                        FotoCapturada.this.repaint();
                    }
                });
            }
        });
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.setCursor(new Cursor(12));
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.x = e.getX();
        this.y = e.getY();
        this.repaint();
    }

    public void addFotoSelecionadaListener(FotoSelecionada l) {
        if (l != null) {
            this.listener.add(l);
        }
    }

    public void removeFotoSelecionadaListener(FotoSelecionada l) {
        if (l != null) {
            this.listener.remove(l);
        }
    }

    public BufferedImage convertImageToBuffered(Image image, int width, int height) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int transparency = 1;
        GraphicsDevice gs = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gs.getDefaultConfiguration();
        bimage = gc.createCompatibleImage(width, height, transparency);
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(width, height, type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return bimage;
    }
}

