/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.laboratorio.DisposeListener;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.TTextField;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TelaLocalizar
extends JDialog
implements DisposeListener {
    private ArrayList<String> campos = new ArrayList();
    private GridBagLayout grid = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JButton buttonLocalizar = new JButton("Localizar");
    private JButton buttonFechar = new JButton("Fechar");
    private JLabel labelCampo = new JLabel("Campo a ser pesquisado");
    private JLabel labelTexto = new JLabel("Procurar por");
    private JComboBox comboCampo = new JComboBox();
    private TTextField txtTexto = new TTextField();
    private JPanel panelCentro = new JPanel(this.grid);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private boolean ok = false;

    public TelaLocalizar(Frame owner) {
        super(owner, "Localizar");
        try {
            if (owner instanceof Laboratorio) {
                ((Laboratorio)owner).addDisposeListener(this);
            }
            this.jbInit(owner);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    public TelaLocalizar(Dialog owner) {
        super(owner, "Localizar");
        try {
            this.jbInit(owner);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(owner, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void jbInit(Component owner) throws Exception {
        this.setLayout(new BorderLayout());
        this.setSize(new Dimension(300, 140));
        this.setLocationRelativeTo(owner);
        this.setModal(true);
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        Funcoes.montaEnter((JComponent)this.panelCentro);
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 18;
        this.grid.setConstraints(this.labelCampo, this.constraints);
        this.panelCentro.add(this.labelCampo);
        this.constraints.gridx = 0;
        this.constraints.gridy = 2;
        this.grid.setConstraints(this.labelTexto, this.constraints);
        this.panelCentro.add(this.labelTexto);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.comboCampo.setMinimumSize(new Dimension(50, 20));
        this.comboCampo.setPreferredSize(new Dimension(50, 20));
        this.grid.setConstraints(this.comboCampo, this.constraints);
        this.panelCentro.add(this.comboCampo);
        this.constraints.gridx = 0;
        this.constraints.gridy = 3;
        this.txtTexto.setMinimumSize(new Dimension(50, 20));
        this.txtTexto.setPreferredSize(new Dimension(50, 20));
        this.grid.setConstraints(this.txtTexto, this.constraints);
        this.panelCentro.add(this.txtTexto);
        this.panelBotoes.add(this.buttonLocalizar);
        this.panelBotoes.add(this.buttonFechar);
        this.labelCampo.setLabelFor(this.comboCampo);
        this.labelTexto.setLabelFor(this.txtTexto);
        this.labelCampo.setDisplayedMnemonic('C');
        this.labelTexto.setDisplayedMnemonic('T');
        this.buttonFechar.setMnemonic('F');
        this.buttonLocalizar.setMnemonic('L');
        this.buttonFechar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaLocalizar.this.setVisible(false);
            }
        });
        this.buttonLocalizar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaLocalizar.this.ok = true;
                TelaLocalizar.this.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                TelaLocalizar.this.comboCampo.removeAllItems();
                for (int i = 0; i < TelaLocalizar.this.campos.size(); ++i) {
                    TelaLocalizar.this.comboCampo.addItem(TelaLocalizar.this.campos.get(i));
                }
                TelaLocalizar.this.txtTexto.requestFocus();
            }
        });
    }

    public void adicionaCampo(String nomeCampo) {
        this.campos.add(nomeCampo);
    }

    public void adicionaCampo(String ... nomeCampos) {
        for (int i = 0; i < nomeCampos.length; ++i) {
            this.campos.add(nomeCampos[i]);
        }
    }

    public int getPosicaoCampo() {
        return this.comboCampo.getSelectedIndex();
    }

    public String getCampo(int campo) {
        return this.campos.get(campo);
    }

    public boolean isOK() {
        return this.ok;
    }

    public String getTexto() {
        return this.txtTexto.getText();
    }

    public TTextField getCampoTexto() {
        return this.txtTexto;
    }
}

