/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.model.bean.cadastro.MotivoAlteracaoBean;
import jalis.service.cadastro.MotivoAlteracaoService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SolicitarMotivoAlteracao
extends AbstractDialogoOKCancelar {
    JComboBox comboMotivos = new JComboBox();
    JTextArea textMotivo = new JTextArea(new TTextAreaDocument(500));

    public static SolicitarMotivoAlteracao novaInstancia(Object owner) {
        if (owner instanceof Dialog) {
            return new SolicitarMotivoAlteracao((Dialog)owner, "Motivo de altera\u00e7\u00e3o");
        }
        if (owner instanceof Frame) {
            return new SolicitarMotivoAlteracao((Frame)owner, "Motivo de altera\u00e7\u00e3o");
        }
        return null;
    }

    public SolicitarMotivoAlteracao(Dialog owner, String titulo) {
        super(owner, titulo);
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    public SolicitarMotivoAlteracao(Frame owner, String titulo) {
        super(owner, titulo);
        this.iniciar();
        this.setLocationRelativeTo(owner);
    }

    private void iniciar() {
        this.setUsuarioPodeCancelar(false);
        this.getBotaoCancelar().setVisible(false);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (SolicitarMotivoAlteracao.this.exigeDescricaoMotivo()) {
                    Funcoes.mensagem(SolicitarMotivoAlteracao.this, "O motivo informado exige justificativa para altera\u00e7\u00e3o.", 1);
                    ScreenUtil.requisitarFoco(SolicitarMotivoAlteracao.this.textMotivo);
                } else {
                    SolicitarMotivoAlteracao.this.setVisible(false);
                }
            }
        });
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panel.add((Component)ComponenteFactory.novoJLabel("Motivo", 'M', null, this.comboMotivos), c);
        c.gridy = 2;
        panel.add((Component)ComponenteFactory.novoJLabel("Justificativa", 'D', null, this.textMotivo), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.gridy = 1;
        this.comboMotivos.setPreferredSize(new Dimension(20, 22));
        panel.add((Component)this.comboMotivos, c);
        c.gridy = 3;
        c.fill = 1;
        c.weighty = 1.0;
        panel.add((Component)new JScrollPane(this.textMotivo), c);
        this.setSize(new Dimension(300, 200));
        try {
            MotivoAlteracaoService service = new MotivoAlteracaoService();
            Set motivos = service.load(" where fil_codigo = " + Variaveis.filialPadrao);
            ArrayList listaMotivos = new ArrayList(motivos);
            Collections.sort(listaMotivos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof MotivoAlteracaoBean && o2 instanceof MotivoAlteracaoBean) {
                        return o1.toString().compareTo(o2.toString());
                    }
                    return 0;
                }
            });
            for (MotivoAlteracaoBean motivo : listaMotivos) {
                this.comboMotivos.addItem(motivo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace());
        }
        this.comboMotivos.setEnabled(this.comboMotivos.getItemCount() > 0);
        if (this.comboMotivos.isEnabled()) {
            ScreenUtil.requisitarFoco(this.comboMotivos);
        } else {
            ScreenUtil.requisitarFoco(this.textMotivo);
        }
    }

    @Override
    public boolean acaoOk() {
        if (this.exigeDescricaoMotivo()) {
            Funcoes.mensagem(this, "O motivo informado exige justificativa para altera\u00e7\u00e3o.", 1);
            ScreenUtil.requisitarFoco(this.textMotivo);
            return false;
        }
        return true;
    }

    private boolean exigeDescricaoMotivo() {
        MotivoAlteracaoBean motivo = null;
        return this.comboMotivos.getSelectedItem() != null && (motivo = (MotivoAlteracaoBean)this.comboMotivos.getSelectedItem()).getExigirMotivo() != false && Funcoes.textoVazio(this.textMotivo.getText());
    }

    public int getCodigoMotivo() {
        if (this.comboMotivos.getSelectedItem() != null) {
            return ((MotivoAlteracaoBean)this.comboMotivos.getSelectedItem()).getCodigo();
        }
        return -1;
    }

    public MotivoAlteracaoBean getMotivoAlteracao() {
        if (this.comboMotivos.getSelectedItem() != null) {
            MotivoAlteracaoBean motivo = (MotivoAlteracaoBean)this.comboMotivos.getSelectedItem();
            motivo.setDescricao(this.textMotivo.getText());
            return motivo;
        }
        return null;
    }

    public String getDescricaoMotivo() {
        return this.textMotivo.getText();
    }

    public void setDescricaoMotivo(String motivo) {
        this.textMotivo.setText(motivo);
    }
}

