/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.ObjetoMensagem;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ScreenUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import sun.swing.SwingUtilities2;

class RenderMensagens
extends JLabel
implements ListCellRenderer {
    private static final String TIPO_USO_DISCO = "D";
    private static final String TIPO_NOVA_VERSAO = "A";
    private static final String TIPO_BACKUP = "B";
    private static final Color FUCSIA = new Color(202, 44, 146);
    private static final Color LARANJA = new Color(252, 113, 20);
    private static final Color AZUL = new Color(27, 153, 161);

    RenderMensagens() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ObjetoMensagem)) {
            this.setText("");
            return this;
        }
        Font novaFonte = this.getFont().deriveFont(0);
        this.setFont(novaFonte);
        ObjetoMensagem obj = (ObjetoMensagem)value;
        String titulo = obj.getTitulo();
        int listWidth = list.getWidth() - 50;
        if (SwingUtilities.computeStringWidth(SwingUtilities2.getFontMetrics((JComponent)this, novaFonte), titulo) > listWidth) {
            titulo = SwingUtilities2.clipStringIfNecessary(this, SwingUtilities2.getFontMetrics((JComponent)this, novaFonte), titulo, listWidth);
        }
        this.setBorder(BorderFactory.createEmptyBorder(7, 5, 7, 5));
        this.setIconTextGap(10);
        if (obj.isConfirmarLeitura()) {
            this.setIcon(ImagemUtils.carregaImagemJalis("cartaresposta.png"));
        } else {
            this.setIcon(ImagemUtils.carregaImagemJalis("carta.png"));
        }
        this.setText("<html>De: " + obj.getUsuarioOrigem() + " em " + Funcoes.formataData("dd/MM/yyyy HH:mm", obj.getData()) + "<br>" + titulo + "</html>");
        this.setOpaque(isSelected);
        if (obj.getTipo().equals(TIPO_BACKUP)) {
            this.setForeground(FUCSIA);
        } else if (obj.getTipo().equals(TIPO_NOVA_VERSAO)) {
            this.setForeground(LARANJA);
        } else if (obj.getTipo().equals(TIPO_USO_DISCO)) {
            this.setForeground(AZUL);
        } else {
            this.setForeground(list.getForeground());
        }
        if (isSelected) {
            this.setBackground(list.getSelectionBackground());
            this.setForeground(list.getSelectionForeground());
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
        }
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(ScreenUtil.clarearCor(Color.GRAY, 50));
        g2.setStroke(new BasicStroke(0.5f));
        g2.drawLine(22, this.getHeight() - 1, this.getWidth() - 15, this.getHeight() - 1);
    }
}

