/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Acesso;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.Variaveis;
import jalis.comum.informacao.InfoRequisicao;
import jalis.comum.pesquisa.FrmPesquisa;
import jalis.comum.pesquisa.InfoListener;
import jalis.comum.pesquisa.SelecaoPesquisaAvancada;
import jalis.laboratorio.GlassPaneMensagem;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.cadastro.Ala;
import jalis.laboratorio.cadastro.Bairro;
import jalis.laboratorio.cadastro.CadastroProdutos;
import jalis.laboratorio.cadastro.CategoriaProduto;
import jalis.laboratorio.cadastro.Cid10;
import jalis.laboratorio.cadastro.Cidade;
import jalis.laboratorio.cadastro.Coleta;
import jalis.laboratorio.cadastro.Convenio;
import jalis.laboratorio.cadastro.Destino;
import jalis.laboratorio.cadastro.Especialidade;
import jalis.laboratorio.cadastro.Especie;
import jalis.laboratorio.cadastro.Exame;
import jalis.laboratorio.cadastro.Feriado;
import jalis.laboratorio.cadastro.Filial;
import jalis.laboratorio.cadastro.Grupo;
import jalis.laboratorio.cadastro.Historico;
import jalis.laboratorio.cadastro.Interface;
import jalis.laboratorio.cadastro.LabExterno;
import jalis.laboratorio.cadastro.Material;
import jalis.laboratorio.cadastro.MaterialColeta;
import jalis.laboratorio.cadastro.Medicamento;
import jalis.laboratorio.cadastro.Medico;
import jalis.laboratorio.cadastro.Metodologia;
import jalis.laboratorio.cadastro.PrazoEntrega;
import jalis.laboratorio.cadastro.Principios;
import jalis.laboratorio.cadastro.Prioridade;
import jalis.laboratorio.cadastro.Recipiente;
import jalis.laboratorio.cadastro.Setor;
import jalis.laboratorio.cadastro.Situacao;
import jalis.laboratorio.cadastro.TabelaPreco;
import jalis.laboratorio.cadastro.TermoConsentimento;
import jalis.laboratorio.cadastro.TipoMaterial;
import jalis.laboratorio.cadastro.UnidadeMedida;
import jalis.laboratorio.cadastro.UnidadeSaude;
import jalis.laboratorio.cadastro.agrupamento.AgrupaFaturamento;
import jalis.laboratorio.cadastro.agrupamento.AgrupaRequisicao;
import jalis.laboratorio.cadastro.agrupamento.AgrupaSituacao;
import jalis.laboratorio.cadastro.layout.Layout;
import jalis.laboratorio.configuracao.TipoUsuario;
import jalis.laboratorio.configuracao.Usuario;
import jalis.laboratorio.financeiro.contas.Agencia;
import jalis.laboratorio.financeiro.contas.Banco;
import jalis.laboratorio.financeiro.contas.Conta;
import jalis.laboratorio.financeiro.contas.HistoricoPadrao;
import jalis.laboratorio.financeiro.lancamentos.Baixa;
import jalis.laboratorio.financeiro.lancamentos.ReceberPagar;
import jalis.laboratorio.financeiro.lancamentos.cadastro.PlanoContas;
import jalis.laboratorio.recepcao.Orcamento;
import jalis.laboratorio.recepcao.Paciente;
import jalis.laboratorio.recepcao.Requisicao;
import jalis.service.cadastro.ConvenioService;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;

public class Pesquisas {
    public static final String MANTER_PESQUISA = "Pesquisa.manterPesquisa";
    private static Hashtable<String, ArrayList<SelecaoPesquisaAvancada>> pesquisaAnterior = new Hashtable();

    private static ArrayList<SelecaoPesquisaAvancada> validaPesquisaAnterior(String pesquisa) {
        if (pesquisaAnterior.containsKey(pesquisa) && StringUtil.getBoolean(ParametrosUsuarios.getValor(MANTER_PESQUISA), "manterPesquisa")) {
            return !pesquisaAnterior.get(pesquisa).isEmpty() ? pesquisaAnterior.get(pesquisa) : null;
        }
        return null;
    }

    private static void gravaPesquisaAnterior(String pesquisa, ArrayList<SelecaoPesquisaAvancada> pesquisaUtilizada) {
        if (pesquisaUtilizada != null && StringUtil.getBoolean(ParametrosUsuarios.getValor(MANTER_PESQUISA), "manterPesquisa")) {
            pesquisaAnterior.put(pesquisa, pesquisaUtilizada);
        }
    }

    public static Hashtable baixaAutorizacaoDebito(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando baixas");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Baixa.getModuloAcesso(), "Baixas");
            }
            StringBuilder where = new StringBuilder();
            where.append(" select distinct bxa.bxa_codigo, ");
            where.append("        bxa.bxa_datahora, ");
            where.append("        bxa.bxa_quantidadetitulos, ");
            where.append("        bxa.bxa_valortotal ");
            where.append("   from baixa bxa ");
            where.append("   left join baixalanctocaixa blc on (bxa.fil_codigo = blc.fil_codigo and bxa.bxa_codigo = blc.bxa_codigo) ");
            where.append("   left join lanctocaixa lcx on (blc.fil_codigo = lcx.fil_codigo and blc.lcx_codigo = lcx.lcx_codigo and blc.est_codigo = lcx.est_codigo) ");
            p.setSql(where.toString());
            p.removerCampos();
            p.adicionaCampo("bxa.bxa_codigo", "C\u00f3digo", 1, "", 2);
            p.adicionaCampo("bxa_datahora", "Data", 4, "", 3);
            p.adicionaCampo("bxa_quantidadetitulos", "Qtde T\u00edtulos", 1, "", 3);
            p.adicionaCampo("bxa_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("C\u00f3digo", 2);
            p.setOrdem("C\u00f3digo");
            p.setFiltro("lcx.lcx_situacao <> 'C' and lcx.lcx_tipopagamento = upper('Z') and bxa.fil_codigo = " + Variaveis.filialPadrao);
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("baixa"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("baixa", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable categoriaDeProduto(Object pai, boolean mostrarCadastro) {
        return Pesquisas.categoriaDeProduto(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable categoriaDeProduto(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando Categoria de Produtos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(CategoriaProduto.getModuloAcesso(), "Cadastro de Categoria de Produtos");
            }
            p.setSql("select cpl_codigo, cpl_descricao from  categoriaprodutoalimentos");
            p.removerCampos();
            p.adicionaCampo("cpl_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cpl_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("fil_codigo = " + (Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial));
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("categoriaprodutoalimentos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("categoriaprodutoalimentos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable produto(Object pai, boolean mostrarCadastro) {
        return Pesquisas.produto(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable produto(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando de Produtos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(CadastroProdutos.getModuloAcesso(), "Cadastro de Produtos");
            }
            p.setSql("select pal_codigo, pal_descricao, cpl.cpl_descricao, cpl.cpl_codigo from  produtoalimentos pal left join categoriaprodutoalimentos cpl on pal.fil_codigo = cpl.fil_codigo and pal.cpl_codigo = cpl.cpl_codigo");
            p.removerCampos();
            p.adicionaCampo("pal_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("pal_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("cpl.cpl_descricao", "Categoria", 0, "", 2);
            p.adicionaCampo("cpl.cpl_codigo", "C\u00f3digo Categoria", 1, "", 3, 3, true, true);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("pal.fil_codigo = " + (Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial));
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("produtoalimentos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("produtoalimentos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable cidade(Object pai, boolean mostrarCadastro) {
        return Pesquisas.cidade(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable cidade(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando cidades");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Cidade.getModuloAcesso(), "Cadastro de cidades");
            }
            p.setSql("select cid_codigo, cid_nome, cid_uf, cid_codigoibge from cidades");
            p.removerCampos();
            p.adicionaCampo("cid_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cid_nome", "Nome", 0, "", 2);
            p.adicionaCampo("cid_uf", "Estado", 0, "", 3);
            p.adicionaCampo("cid_codigoibge", "C\u00f3digo IBGE", 1, "", 3);
            p.setFiltroInicial("Nome", 2);
            p.setFiltro("fil_codigo = " + (Funcoes.textoVazio(filial) ? Variaveis.filialPadrao : filial));
            p.setOrdem("Nome");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("cidade"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("cidade", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tituloAvisoCobranca(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos em Aviso de Cobran\u00e7a");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social as razao_social");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,rpg.rpg_datahora as rpg_datahora ");
            buf.append("       ,rpg_valor as rpg_valor ");
            buf.append("       ,rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("rpg.rpg_datahora", "Dt. Cadastro", 2, "", 3);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("Raz\u00e3o Social", 2);
            p.setOrdem("Raz\u00e3o Social");
            p.setFiltro("rpg.fil_codigo = " + Variaveis.filialPadrao + " and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo and rpg.rpg_situacao = upper('" + "V" + "') ");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("titulos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("titulos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable solicitacaoTubos(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando Solicita\u00e7\u00f5es de Tubos");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select sso.sso_codigo, sso.sso_datahora, sso.usr_codigo, sso.set_codigo, set.set_descricao ");
            buf.append("   from solicitarsoroteca sso ");
            buf.append("   join setores set on sso.fil_codigo = set.fil_codigo and sso.set_codigo = set.set_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("sso.sso_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("sso.sso_datahora", "Data/Hora.", 4, "", 0);
            p.adicionaCampo("sso.usr_codigo", "Usu\u00e1rio", 0, "", 3);
            p.adicionaCampo("sso.set_codigo", "C\u00f3d. Setor", 1, "", 3);
            p.adicionaCampo("set.set_descricao", "Desc. Setor", 0, "", 0);
            p.setOrdem("C\u00f3digo");
            p.setFiltro(" sso.sso_datahoracancelamento IS NULL and sso.sso_datahoraentrega IS NULL ");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable titulo(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(ReceberPagar.getModuloAcesso(), "Cadastro de T\u00edtulos");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social as razao_social");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_datahora as rpg_datahora ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,CASE WHEN cad.rpg_situacao = UPPER('").append("A").append("') then 'Aberto'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("C").append("') then 'Cancelado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("P").append("') then 'Pr\u00e9via (nota fiscal)'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("N").append("') then 'Renegociado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("G").append("') then 'Agrupado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("E").append("') then 'Estornado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("L").append("') then 'Parcelado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("Q").append("') then 'Quitado'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("V").append("') then 'Aviso Cobran\u00e7a'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("T").append("') then 'Cart\u00f3rio'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("S").append("') then 'Protesto'");
            buf.append("       \t\t\t WHEN cad.rpg_situacao = UPPER('").append("F").append("') then 'Pr\u00e9via (fatura)'");
            buf.append("       \t\t\t ELSE '' END AS baixaSituacao");
            buf.append("       ,cad.bxa_datahora ");
            buf.append("       ,rpg_valor as rpg_valor ");
            buf.append("       ,rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("               ,bx.bxa_codigo ");
            buf.append("               ,rpg.rpg_situacao ");
            buf.append("               ,bx.bxa_datahora ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join baixareceberpagar b on (rpg.fil_codigo = b.fil_codigo and rpg.rpg_codigo = b.rpg_codigo) ");
            buf.append("           left join baixa bx on (b.fil_codigo = bx.fil_codigo and b.bxa_codigo = bx.bxa_codigo and rpg_situacao != 'A') ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            p.setSqlTitulos(buf.toString());
            p.removerCampos();
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_datahora", "Dt. Cadastro", 4, "", 3);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("cad.rpg_situacao", "Situa\u00e7\u00e3o", 0, "", 2, 1, true, false);
            p.adicionaCampo("cad.bxa_datahora", "Dt. Pagamento", 4, "", 3, 1, true, false);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("Raz\u00e3o Social", 2);
            p.setOrdem("Raz\u00e3o Social");
            StringBuilder bufWhere = new StringBuilder("rpg.fil_codigo = " + Variaveis.filialPadrao + " and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo ");
            bufWhere.append("and rpg.rpg_situacao NOT IN (upper('X'), upper('R'), upper('N')) ");
            p.setFiltro(bufWhere.toString());
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("titulos"));
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("titulos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tituloAgrupador(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos Agrupadores");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social as razao_social");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,rpg.rpg_valor as rpg_valor ");
            buf.append("       ,rpg.rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            buf.append("       ,receberpagarrp rrp ");
            buf.append("       ,receberpagar rpg2 ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("Raz\u00e3o Social", 2);
            p.setOrdem("Raz\u00e3o Social");
            String filtro = "rpg.fil_codigo = " + Variaveis.filialPadrao + " and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo ";
            filtro = filtro + " and rpg.fil_codigo = rrp.fil_kodigo and rpg.rpg_codigo = rrp.rpg_kodigo ";
            filtro = filtro + " and rrp.fil_codigo = rpg2.fil_codigo and rrp.rpg_codigo = rpg2.rpg_codigo and rpg2.rpg_situacao = upper('G') ";
            filtro = filtro + " and rpg.rpg_situacao NOT IN (upper('R'), upper('N')) ";
            p.setFiltro(filtro);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("tituloAgrupador"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("tituloAgrupador", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tituloParcelado(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos Parcelados");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select distinct rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social as razao_social");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,rpg.rpg_valor as rpg_valor ");
            buf.append("       ,rpg.rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            buf.append("       ,receberpagarrp rrp ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.setExecutarAoAbrir(false);
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("Raz\u00e3o Social", 2);
            p.setOrdem("Raz\u00e3o Social");
            String filtro = "rpg.fil_codigo = " + Variaveis.filialPadrao + " and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo ";
            filtro = filtro + " and rpg.rpg_situacao = upper('L') ";
            p.setFiltro(filtro);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("tituloParcelado"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("tituloParcelado", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable titulo(Object pai, String tipoReceberPagar, String tipoCadastro, String codigoCadastro, String situacaoReceberPagar, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(ReceberPagar.getModuloAcesso(), "Cadastro de T\u00edtulos");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social as razao_social ");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,rpg.rpg_datahora as rpg_datahora ");
            buf.append("       ,rpg_valor as rpg_valor ");
            buf.append("       ,rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("rpg.rpg_datahora", "Dt. Cadastro", 2, "", 3);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("N\u00famero Doc.", 2);
            p.setOrdem("N\u00famero Doc.");
            StringBuilder bufWhere = new StringBuilder();
            bufWhere.append(" rpg.fil_codigo = ").append(Variaveis.filialPadrao).append(" and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo and rpg.rpg_situacao = upper('X') ");
            bufWhere.append(" and rpg.rpg_tipocadastro = upper('").append(tipoCadastro).append("') and cad.cod_pessoa = ").append(codigoCadastro);
            bufWhere.append(" and rpg.rpg_tipo = upper('").append(tipoReceberPagar).append("') and rpg.rpg_situacao = upper('").append(situacaoReceberPagar).append("') ");
            p.setFiltro(bufWhere.toString());
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("titulos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("titulos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable titulosAbertos(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando T\u00edtulos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(ReceberPagar.getModuloAcesso(), "Cadastro de T\u00edtulos");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select rpg.rpg_codigo as rpg_codigo ");
            buf.append("       ,cad.razao_social ");
            buf.append("       ,rpg.rpg_numerodocumento as rpg_numerodocumento ");
            buf.append("       ,rpg.rpg_vencimento as rpg_vencimento ");
            buf.append("       ,rpg.rpg_datahora as rpg_datahora ");
            buf.append("       ,rpg.rpg_datahora as rpg_datahora ");
            buf.append("       ,rpg.rpg_valor as rpg_valor ");
            buf.append("       ,rpg.rpg_valortotal as rpg_valortotal ");
            buf.append("   from receberpagar rpg ");
            buf.append("       ,(select case when rpg.rpg_tipocadastro = upper('").append("P").append("') then pac.pac_nome ");
            buf.append("                     when rpg.rpg_tipocadastro = upper('").append("O").append("') then con.con_fantasia  ");
            buf.append("                     else ent.ent_fantasia end as razao_social ");
            buf.append("               ,case when upper(rpg.rpg_tipocadastro) = upper('").append("P").append("') then pac.pac_codigo ");
            buf.append("                     when upper(rpg.rpg_tipocadastro) = upper('").append("O").append("') then con.con_codigo ");
            buf.append("                     else ent.ent_codigo end as cod_pessoa ");
            buf.append("               ,rpg.rpg_codigo ");
            buf.append("               ,rpg.fil_codigo ");
            buf.append("           from receberpagar rpg ");
            buf.append("           left join entidade ent on rpg.fil_codigo = ent.fil_codigo and rpg.ent_codigo = ent.ent_codigo ");
            buf.append("           left join paciente pac on rpg.fil_codigo = pac.fil_codigo and rpg.pac_codigo = pac.pac_codigo ");
            buf.append("           left join convenios con on rpg.fil_codigo = con.fil_codigo and rpg.con_codigo = con.con_codigo) cad ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("rpg.rpg_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cad.razao_social", "Raz\u00e3o Social", 0, "", 2);
            p.adicionaCampo("rpg.rpg_numerodocumento", "N\u00famero Doc.", 0, "", 2);
            p.adicionaCampo("rpg.rpg_vencimento", "Vencimento", 2, "", 3);
            p.adicionaCampo("rpg.rpg_datahora", "Dt. Cadastro", 4, "", 3);
            p.adicionaCampo("rpg.rpg_valor", "Valor", 1, "", 3);
            p.adicionaCampo("rpg.rpg_valortotal", "Valor Total", 1, "", 3);
            p.setFiltroInicial("N\u00famero Doc.", 2);
            p.setOrdem("C\u00f3digo");
            p.setExecutarAoAbrir(false);
            p.setFiltro("rpg.fil_codigo = " + Variaveis.filialPadrao + " and rpg.fil_codigo = cad.fil_codigo and rpg.rpg_codigo = cad.rpg_codigo and rpg.rpg_situacao = upper('" + "A" + "') ");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("titulosAbertos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("titulosAbertos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable filial(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando filiais/postos de coleta");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Filial.getModuloAcesso(), "Cadastro de filiais/postos de coleta");
            }
            StringBuilder buf = new StringBuilder("select a.fil_codigo, a.fil_descricao, b.cid_nome, b.cid_codigo, bai.bai_codigo from filiais_postocoleta a ");
            buf.append(" left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo");
            buf.append(" left join bairro bai on a.fil_codigo = bai.fil_codigo and a.bai_codigo = bai.bai_codigo");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.fil_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("fil_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("cid_nome", "Cidade", 0, "", 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("filial"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("filial", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable bairro(Object pai, boolean mostrarCadastro) {
        return Pesquisas.bairro(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable bairro(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando bairros");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Bairro.getModuloAcesso(), "Cadastro de bairros");
            }
            p.setSql("select bai_codigo, bai_descricao from bairro");
            p.removerCampos();
            p.adicionaCampo("bai_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("bai_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + filial);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("bairro"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("bairro", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable labexterno(Object pai, boolean mostrarCadastro) {
        return Pesquisas.labexterno(pai, mostrarCadastro, false);
    }

    public static Hashtable labexterno(Object pai, boolean mostrarCadastro, boolean mostrarInativos) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando laborat\u00f3rios externos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(LabExterno.getModuloAcesso(), "Cadastro de laborat\u00f3rios externos");
            }
            p.setSql("select lae_codigo, lae_descricao , lae_inativo from labexterno");
            p.removerCampos();
            p.adicionaCampo("lae_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("lae_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            if (mostrarInativos) {
                p.adicionaCampo("lae_inativo", "Inativo", 5, "", 3);
            }
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            if (mostrarInativos) {
                p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            } else {
                p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and (lae_inativo is null or not lae_inativo) ");
            }
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("labexterno"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("labexterno", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable ala(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando alas");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Ala.getModuloAcesso(), "Cadastro de alas");
            }
            p.setSql("select ala_codigo, ala_descricao from alahospital");
            p.removerCampos();
            p.adicionaCampo("ala_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("ala_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("ala"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("ala", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable grupo(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando grupos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Grupo.getModuloAcesso(), "Cadastro de grupos");
            }
            p.setSql("select grp_codigo, grp_descricao from grupo");
            p.removerCampos();
            p.adicionaCampo("grp_codigo", "C\u00f3digo", 0, "", 3);
            p.adicionaCampo("grp_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("grupo"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("grupo", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialColeta(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais coletados");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(MaterialColeta.getModuloAcesso(), "Cadastro de materiais coletados");
            }
            p.setSql("select mco_codigo, mco_descricao from materialcoleta");
            p.removerCampos();
            p.adicionaCampo("mco_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mco_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("materialColeta"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("materialColeta", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable metodologia(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando metodologia");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Metodologia.getModuloAcesso(), "Cadastro de metodologia");
            }
            p.setSql("select met_codigo, met_descricao from metodologia");
            p.removerCampos();
            p.adicionaCampo("met_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("met_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("metodologia"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("metodologia", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable principios(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando princ\u00edpios");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Principios.getModuloAcesso(), "Cadastro de princ\u00edpios");
            }
            p.setSql("select prc_codigo, prc_descricao from principios");
            p.removerCampos();
            p.adicionaCampo("prc_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("prc_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("principios"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("principios", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable nacionalidades(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando nacionalidades");
        if (p != null) {
            p.setSql("select nli_codigo, nli_descricao from nacionalidade");
            p.removerCampos();
            p.adicionaCampo("nli_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("nli_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("C\u00f3digo");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("nacionalidade"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("nacionalidade", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable etnias(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando etnias ind\u00edgenas");
        if (p != null) {
            p.setSql("select ein_codigo, ein_descricao from etniaindigena");
            p.removerCampos();
            p.adicionaCampo("ein_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ein_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("C\u00f3digo");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("etniaindigena"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("etniaindigena", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable prioridade(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando prioridades");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Prioridade.getModuloAcesso(), "Cadastro de prioridade");
            }
            p.setSql("select pri_codigo, pri_descricao, pri_impressora from prioridade");
            p.removerCampos();
            p.adicionaCampo("pri_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("pri_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("pri_impressora", "Impressora", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("prioridade"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("prioridade", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable recipiente(Object pai, String tipo, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando recipientes");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Recipiente.getModuloAcesso(), "Cadastro de recipientes");
            }
            p.setSql("select rec_codigo, rec_descricao from recipientes");
            p.removerCampos();
            p.adicionaCampo("rec_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("rec_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            if (tipo != null && !Funcoes.textoVazio(tipo)) {
                p.addFiltro(" and upper(rec_tipo) = upper('" + tipo + "')");
            }
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("recipiente"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("recipiente", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable situacao(Object pai, boolean mostrarCadastro, boolean mostrarInativos) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando situa\u00e7\u00f5es");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Situacao.getModuloAcesso(), "Cadastro de situa\u00e7\u00f5es");
            }
            p.setSql("select sit_codigo, sit_descricao, (case when coalesce(sit_inativo, false) = true then upper('Sim') else '' end) as sit_inativo from situacao ");
            p.removerCampos();
            p.adicionaCampo("sit_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("sit_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            if (mostrarInativos) {
                p.adicionaCampo("sit_inativo", "Inativo", 0, "", 3, 3);
            }
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            String filtro = "fil_codigo = " + Variaveis.filialPadrao;
            if (!mostrarInativos) {
                filtro = filtro + " and sit_inativo = false ";
            }
            p.setFiltro(filtro);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("situacao"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("situacao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tabelaPreco(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando tabelas de pre\u00e7o");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(TabelaPreco.getModuloAcesso(), "Cadastro de tabela de pre\u00e7os");
            }
            p.setSql("select tpe_codigo, tpe_descricao from tabelaprecoexames");
            p.removerCampos();
            p.adicionaCampo("tpe_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("tpe_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("tabelaPreco"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("tabelaPreco", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tipoMaterial(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando tipos de material");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(TipoMaterial.getModuloAcesso(), "Cadastro de tipos de material");
            }
            p.setSql("select tpm_codigo, tpm_descricao from tipomaterial");
            p.removerCampos();
            p.adicionaCampo("tpm_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("tpm_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("tipoMaterial"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("tipoMaterial", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable unidadeMedida(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando unidades de medida");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(UnidadeMedida.getModuloAcesso(), "Cadastro de unidades de medida");
            }
            p.setSql("select unm_codigo, unm_descricao from unidademedida");
            p.removerCampos();
            p.adicionaCampo("unm_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("unm_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("unidadeMedida"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("unidadeMedida", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable especialidade(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando especialidades");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Especialidade.getModuloAcesso(), "Cadastro de especialidades");
            }
            p.setSql("select esp_codigo, esp_descricao from especialidades");
            p.removerCampos();
            p.adicionaCampo("esp_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("esp_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("especialidade"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("especialidade", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable historico(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando hist\u00f3ricos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Historico.getModuloAcesso(), "Cadastro de hist\u00f3ricos");
            }
            p.setSql("select his_codigo, his_mnemonico, strip_tags(his_descricao) as his_descricao from historicos");
            p.removerCampos();
            p.adicionaCampo("his_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("his_mnemonico", "Mnem\u00f4nico", 0, "", 2, 2);
            p.adicionaCampo("his_descricao", "Descri\u00e7\u00e3o", 0, "", 2, 2, true, true);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setRemoverTagsHTML(true);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("historico"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("historico", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable medicamentos(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando medicamentos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Medicamento.getModuloAcesso(), "Cadastro de medicamentos");
            }
            p.setSql("select mto_codigo, mto_descricao from medicamentos");
            p.removerCampos();
            p.adicionaCampo("mto_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mto_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("medicamentos"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("medicamentos", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable prazoEntrega(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando prazo de entrega");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(PrazoEntrega.getModuloAcesso(), "Cadastro de prazos de entrega");
            }
            p.setSql("select prz_codigo, prz_descricao from prazoentrega");
            p.removerCampos();
            p.adicionaCampo("prz_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("prz_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("prazoEntrega"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("prazoEntrega", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable coleta(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando coletas");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Coleta.getModuloAcesso(), "Cadastro de coletas");
            }
            p.setSql("select col_codigo, col_descricao from coletas");
            p.removerCampos();
            p.adicionaCampo("col_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("col_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("coleta"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("coleta", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable destino(Object pai, boolean mostrarCadastro) {
        String tituloPesquisa = null;
        tituloPesquisa = Variaveis.tipoFilialPadrao.equals("A") ? "Pesquisando modalidades" : "Pesquisando destinos";
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, tituloPesquisa);
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Destino.getModuloAcesso(), "Cadastro de destinos");
            }
            p.setSql("select des_codigo, des_descricao from destino");
            p.removerCampos();
            p.adicionaCampo("des_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("des_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("destino"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("destino", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable unidadeSaude(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando unidades de sa\u00fade");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(UnidadeSaude.getModuloAcesso(), "Cadastro de Unidades de sa\u00fade");
            }
            p.setSql("select uns_codigo, uns_descricao from unidadesaude");
            p.removerCampos();
            p.adicionaCampo("uns_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("uns_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("unidadesaude"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("coleta", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable unidadeSaude(Object pai, String codigoFilial, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando unidades de sa\u00fade");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(UnidadeSaude.getModuloAcesso(), "Cadastro de Unidades de sa\u00fade");
            }
            p.setSql("select uns_codigo, uns_descricao from unidadesaude");
            p.removerCampos();
            p.adicionaCampo("uns_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("uns_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("unidadesaude"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("coleta", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable feriado(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando feriados");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Feriado.getModuloAcesso(), "Cadastro de feriados");
            }
            p.setSql("select fer_dia, fer_motivo, fer_fixo, fer_dia from feriados");
            p.removerCampos();
            p.adicionaCampo("fer_dia", "Dia", 2, "##/##/####", 3);
            p.adicionaCampo("to_char(fer_dia,'dd/mm')", "Dia/M\u00eas", 10, "##/##", 3, 2, false, false);
            p.adicionaCampo("fer_motivo", "Motivo", 0, "", 2);
            p.adicionaCampo("fer_fixo", "Fixo", 5, "", 3);
            p.setFiltroInicial("Dia", 2);
            p.setOrdem("Dia");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("feriado"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("feriado", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable setor(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando setores");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Setor.getModuloAcesso(), "Cadastro de setores");
            }
            p.setSql("select set_codigo, set_descricao, set_sigla from setores");
            p.removerCampos();
            p.adicionaCampo("set_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("set_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("set_sigla", "Sigla", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("setor"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("setor", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable interfaces(Object pai, boolean mostrarCadastro) {
        return Pesquisas.interfaces(pai, mostrarCadastro, false);
    }

    public static Hashtable interfaces(Object pai, boolean mostrarCadastro, boolean mostrarInativos) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando interfaces");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Interface.getModuloAcesso(), "Cadastro de interfaces");
            }
            p.setSql("select int_codigo, int_descricao, int_inativo from interface");
            p.removerCampos();
            p.adicionaCampo("int_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("int_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            if (mostrarInativos) {
                p.adicionaCampo("int_inativo", "Inativo", 5, "", 3);
            }
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            if (mostrarInativos) {
                p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            } else {
                p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and (int_inativo is null or not int_inativo) ");
            }
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("interfaces"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("interfaces", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable usuario(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando usu\u00e1rios");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Usuario.getModuloAcesso(), "Cadastro de usu\u00e1rios");
            }
            p.setSql("select usr_codigo, usr_nome from usuario where not usr_inativo");
            p.removerCampos();
            p.adicionaCampo("usr_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("usr_nome", "Usu\u00e1rio", 0, "", 2);
            p.setFiltroInicial("Usu\u00e1rio", 2);
            p.setOrdem("Usu\u00e1rio");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("usuario"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("usuario", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable usuarioTipo(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando usu\u00e1rios");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Usuario.getModuloAcesso(), "Cadastro de usu\u00e1rios");
            }
            StringBuilder b = new StringBuilder("select a.usr_codigo, a.usr_nome, b.tpu_descricao, (case when a.usr_inativo = true then upper('Sim') else '' end) as usuarioinativo from usuario a ");
            b.append(" left join tipousuario b on a.tpu_codigo = b.tpu_codigo ");
            p.setSql(b.toString());
            p.removerCampos();
            p.adicionaCampo("usr_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("usr_nome", "Usu\u00e1rio", 0, "", 2);
            p.adicionaCampo("tpu_descricao", "Tipo", 0, "", 2);
            p.adicionaCampo("usuarioinativo", "Inativo", 0, "", 3, 3);
            p.setFiltroInicial("Usu\u00e1rio", 2);
            p.setOrdem("Usu\u00e1rio");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("usuarioTipo"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("usuarioTipo", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialAtivo(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de materiais");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select mat.mat_codigo    as mat_codigo, ");
            buf.append("        mat.mat_descricao as mat_descricao, ");
            buf.append("        tpm.tpm_descricao as tpm_descricao, ");
            buf.append(" \t\t\t\tmat.unm_codigo as unm_codigo ");
            buf.append("   from material mat ");
            buf.append("   left join tipomaterial tpm on (mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo) ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("mat_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("tpm_descricao", "Tipo", 0, "", 2);
            p.adicionaCampo("unm_codigo", "Unid. medida", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("mat.fil_codigo = " + Variaveis.filialPadrao + " and not mat_inativo ");
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("material"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("material", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialTodos(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de materiais");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select mat.mat_codigo    as mat_codigo, ");
            buf.append("        mat.mat_descricao as mat_descricao, ");
            buf.append("        tpm.tpm_descricao as tpm_descricao ");
            buf.append("   from material mat ");
            buf.append("   left join tipomaterial tpm on (mat.fil_codigo = tpm.fil_codigo and mat.tpm_codigo = tpm.tpm_codigo) ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("mat_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("tpm_descricao", "Tipo", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("mat.fil_codigo = " + Variaveis.filialPadrao);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("material"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("material", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialEnviado(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais enviados");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select men.men_codigo as men_codigo ");
            buf.append("       ,men.men_datahora as men_datahora ");
            buf.append("       ,men.usr_codigo as usr_codigo ");
            buf.append("       ,men.cel_codorigem as celo_codigo ");
            buf.append("       ,celo.cel_descricao as celo_descricao ");
            buf.append("       ,men.cel_coddestino as celd_codigo ");
            buf.append("       ,celd.cel_descricao as celd_descricao ");
            buf.append("       ,men.con_codigo as con_codigo ");
            buf.append("       ,con.con_fantasia as con_fantasia ");
            buf.append("       ,men.pac_codigo as pac_codigo ");
            buf.append("       ,pac.pac_nome as pac_nome ");
            buf.append("   from materialenviado men ");
            buf.append("   join celulaestoque celo on men.fil_codigo = celo.fil_codigo and men.cel_codorigem = celo.cel_codigo ");
            buf.append("   join celulaestoque celd on men.fil_codigo = celd.fil_codigo and men.cel_coddestino = celd.cel_codigo ");
            buf.append("   join convenios     con  on men.fil_codigo = con.fil_codigo  and men.con_codigo = con.con_codigo ");
            buf.append("   left join paciente pac  on men.fil_codigo = pac.fil_codigo  and men.pac_codigo = pac.pac_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("men_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("men_datahora", "Data/Hora", 4, "", 0);
            p.adicionaCampo("usr_codigo", "Usu\u00e1rio", 0, "", 3);
            p.adicionaCampo("celo_codigo", "C\u00e9l. Origem", 0, "", 3);
            p.adicionaCampo("celo_descricao", "Desc. C\u00e9l. Origem", 0, "", 0);
            p.adicionaCampo("celd_codigo", "C\u00e9l. Destino", 0, "", 3);
            p.adicionaCampo("celd_descricao", "Desc. C\u00e9l. Destino", 0, "", 0);
            p.adicionaCampo("con_codigo", "C\u00f3d. Conv\u00eanio", 0, "", 3);
            p.adicionaCampo("con_fantasia", "Fantasia Conv\u00eanio", 0, "", 0);
            p.adicionaCampo("pac_codigo", "C\u00f3d. Paciente", 0, "", 3);
            p.adicionaCampo("pac_nome", "Nome Paciente", 0, "", 0);
            p.setFiltroInicial("C\u00f3digo", 3);
            p.setFiltro(" men.fil_codigo = " + Variaveis.filialPadrao);
            p.setOrdem("Data/Hora");
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialAtivoComFichaTecnica(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de materiais");
            }
            p.setSql("select mat_codigo, mat_descricao from material");
            p.removerCampos();
            p.adicionaCampo("mat_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and mat_fichatecnica and not mat_inativo ");
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("material"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("material", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable materialTodosComFichaTecnica(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando materiais");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Material.getModuloAcesso(), "Cadastro de materiais");
            }
            p.setSql("select mat_codigo, mat_descricao from material");
            p.removerCampos();
            p.adicionaCampo("mat_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("mat_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and mat_fichatecnica = true ");
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("material"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("material", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable layout(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando modelos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Layout.getModuloAcesso(), "Cadastro de modelos");
            }
            p.setSql("select a.lay_codigo, a.lay_descricao, (case when a.lay_codigo = b.lay_codigo then upper('Sim') else '' end) as layoutpadrao from layout a left join parametros b on a.lay_codigo = b.lay_codigo ");
            p.removerCampos();
            p.adicionaCampo("a.lay_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("a.lay_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("a.layoutpadrao", "MP", 0, "", 2, 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("a.fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("layout"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("layout", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    private static boolean isAlimentos() {
        return Variaveis.tipoFilialPadrao.equals("A");
    }

    public static Hashtable medico(Object pai, boolean mostrarCadastro) {
        String descricao = Pesquisas.isAlimentos() ? "coletadores" : "m\u00e9dicos";
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando " + descricao);
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Medico.getModuloAcesso(), "Cadastro de " + descricao);
            }
            p.setSql("select med_conselho, med_crm, med_uf, med_nome, med_cpf from medico");
            p.removerCampos();
            p.adicionaCampo("med_conselho", "Conselho", 0, "", 2);
            p.adicionaCampo("med_crm", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("med_uf", "UF", 0, "", 2);
            p.adicionaCampo("med_nome", "Nome", 0, "", 2);
            p.adicionaCampo("med_cpf", "CPF", 0, "", 3);
            p.setFiltroInicial("Nome", 2);
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setOrdem("Nome");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("medico"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("medico", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable medico(Object pai, String codigoFilial, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando m\u00e9dicos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Medico.getModuloAcesso(), "Cadastro de m\u00e9dicos");
            }
            p.setSql("select med_conselho, med_crm, med_uf, med_nome from medico");
            p.removerCampos();
            p.adicionaCampo("med_conselho", "Conselho", 0, "", 2);
            p.adicionaCampo("med_crm", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("med_uf", "UF", 0, "", 2);
            p.adicionaCampo("med_nome", "Nome", 0, "", 2);
            p.setFiltroInicial("Nome", 2);
            p.setFiltro("fil_codigo = " + codigoFilial);
            p.setOrdem("Nome");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("medico"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("medico", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable convenio(Object pai, String filialPadrao, boolean mostrarCadastro, boolean mostrarProibido) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando conv\u00eanios");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Convenio.getModuloAcesso(), "Cadastro de conv\u00eanios");
            }
            StringBuilder b = new StringBuilder("select a.con_codigo, a.con_fantasia, a.con_cnpjcpf, b.cid_nome, a.con_fone, a.con_fax, a.con_razao, a.con_email1, a.con_exigirtoken, a.con_mascaratoken from convenios a ");
            b.append("left join cidades b on a.fil_codigo = b.fil_codigo and a.cid_codigo = b.cid_codigo ");
            p.setSql(b.toString());
            p.removerCampos();
            p.adicionaCampo("con_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("con_fantasia", "Fantasia", 0, "", 2);
            p.adicionaCampo("con_cnpjcpf", "CNPJ", 0, "##.###.###/####-##", 3);
            p.adicionaCampo("cid_nome", "Cidade", 0, "", 2);
            p.adicionaCampo("con_fone", "Fone", 0, "", 2);
            p.adicionaCampo("con_fax", "Fax", 0, "", 2);
            p.adicionaCampo("con_razao", "Raz\u00e3o social", 0, "", 2);
            p.adicionaCampo("con_email1", "e-mail", 0, "", 2);
            p.adicionaCampo("con_exigirtoken", "Pedir Token", 5, "", 2);
            p.adicionaCampo("con_mascaratoken", "Mascara Token", 0, "", 2);
            p.setFiltroInicial("Fantasia", 2);
            p.setFiltro("a.fil_codigo = " + filialPadrao);
            if (!mostrarProibido) {
                p.addFiltro(" and (a.con_proibido = false or a.con_proibido is null)");
            }
            p.setOrdem("Fantasia");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("convenio"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("convenio", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable convenio(Object pai, boolean mostrarCadastro, boolean mostrarProibido) {
        return Pesquisas.convenio(pai, Variaveis.filialPadrao, mostrarCadastro, mostrarProibido);
    }

    public static Hashtable exame(Object pai, boolean mostrarCadastro, boolean ocultarProibido) {
        return Pesquisas.exame(pai, mostrarCadastro, ocultarProibido, null);
    }

    public static Hashtable exame(Object pai, boolean mostrarCadastro, boolean ocultarProibido, String codigoFilial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de exames");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, a.exa_descricao, a.exa_sinonimo, c.set_descricao from exames a ");
            buf.append("left join examesetor b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("left join setores c on b.fil_codigo = c.fil_codigo and b.set_codigo = c.set_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("exa_sinonimo", "Sin\u00f4nimo", 0, "", 2);
            p.adicionaCampo("set_descricao", "Setor", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            if (Funcoes.textoVazio(codigoFilial) || !Funcoes.isNumeric(codigoFilial)) {
                buf.append(Variaveis.filialPadrao);
            } else {
                buf.append(codigoFilial);
            }
            buf.append(" and b.ese_default = true");
            if (ocultarProibido) {
                buf.append(" and a.exa_proibido <> true");
            }
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("exame"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("exame", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable exameAMB(Object pai, boolean mostrarCadastro, boolean ocultarProibido) {
        return Pesquisas.exameAMB(pai, Variaveis.filialPadrao, mostrarCadastro, ocultarProibido);
    }

    public static Hashtable exameAMB(Object pai, String filial, boolean mostrarCadastro, boolean ocultarProibido) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de exames");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, ");
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                buf.append("b.exa_soa, b.exa_coa, ");
            } else {
                buf.append("a.emc_codigoamb, a.emc_codigocbhpm, ");
            }
            buf.append("b.exa_sinonimo, a.mco_codigo from examematcoleta a ");
            buf.append("left join exames b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo=c.mco_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                p.adicionaCampo("exa_soa", "SOA", 0, "", 2);
                p.adicionaCampo("exa_coa", "COA", 0, "", 2);
            } else {
                p.adicionaCampo("emc_codigoamb", "AMB", 0, "##.##.###-#", 2);
                p.adicionaCampo("emc_codigocbhpm", "CBHPM", 0, "#.##.##.##-#", 2);
            }
            p.adicionaCampo("exa_sinonimo", "Sin\u00f4nimo", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Material", 1, "", 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(filial);
            if (ocultarProibido) {
                buf.append(" and b.exa_proibido <> true and a.emc_proibido <> true ");
            }
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("exameamb"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("exameamb", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable exameAMBSemProibidosConvenio(Object pai, String filial, String codigoConvenio, boolean mostrarCadastro, boolean ocultarProibido) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de exames");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, ");
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                buf.append("b.exa_soa, b.exa_coa, ");
            } else {
                buf.append("a.emc_codigoamb, a.emc_codigocbhpm, ");
            }
            buf.append("b.exa_sinonimo, a.mco_codigo from examematcoleta a ");
            buf.append("left join exames b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo=c.mco_codigo ");
            buf.append(" left join examesmatconvenio eco on a.fil_codigo = eco.fil_codigo and a.exa_codigo = eco.exa_codigo and a.mco_codigo = eco.mco_codigo and eco.con_codigo = ").append(codigoConvenio);
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                p.adicionaCampo("exa_soa", "SOA", 0, "", 2);
                p.adicionaCampo("exa_coa", "COA", 0, "", 2);
            } else {
                p.adicionaCampo("emc_codigoamb", "AMB", 0, "##.##.###-#", 2);
                p.adicionaCampo("emc_codigocbhpm", "CBHPM", 0, "#.##.##.##-#", 2);
            }
            p.adicionaCampo("exa_sinonimo", "Sin\u00f4nimo", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Material", 1, "", 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(filial);
            if (ocultarProibido) {
                buf.append(" and b.exa_proibido = false  and a.emc_proibido = false");
            }
            buf.append(" and COALESCE(eco.eco_tipo, '') <> '").append("P").append("' ");
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("exameamb"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("exameamb", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable exameAMBSetor(Object pai, boolean mostrarCadastro, boolean ocultarProibido) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Exame.getModuloAcesso(), "Cadastro de exames");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, ");
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                buf.append("b.exa_soa, b.exa_coa, ");
            } else {
                buf.append("a.emc_codigoamb, a.emc_codigocbhpm, ");
            }
            buf.append(" b.exa_sinonimo, e.set_descricao, a.mco_codigo, b.exa_proibido, a.emc_proibido from examematcoleta a ");
            buf.append("left join exames b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo=c.mco_codigo ");
            buf.append("left join examesetor d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo and d.ese_default = true ");
            buf.append("left join setores e on d.fil_codigo = e.fil_codigo and d.set_codigo = e.set_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                p.adicionaCampo("exa_soa", "SOA", 0, "", 2);
                p.adicionaCampo("exa_coa", "COA", 0, "", 2);
            } else {
                p.adicionaCampo("emc_codigoamb", "AMB", 0, "##.##.###-#", 2);
                p.adicionaCampo("emc_codigocbhpm", "CBHPM", 0, "#.##.##.##-#", 2);
            }
            p.adicionaCampo("exa_sinonimo", "Sin\u00f4nimo", 0, "", 2);
            p.adicionaCampo("set_descricao", "Setor", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Material", 1, "", 3);
            p.adicionaCampo("exa_proibido", "Bloqueado", 5, "", 3);
            p.adicionaCampo("emc_proibido", "Proibido", 5, "", 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            if (ocultarProibido) {
                buf.append(" and a.exa_proibido <> true");
            }
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("exameambsetor"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("exameambsetor", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable tipoUsuario(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando tipos de usu\u00e1rio");
        if (p != null) {
            String whereConst = "where tpu_inativo <> true";
            p.setSql("select tpu_codigo, tpu_descricao, tpu_inativo from tipousuario " + (mostrarCadastro ? whereConst : ""));
            p.removerCampos();
            p.adicionaCampo("tpu_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("tpu_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            if (mostrarCadastro) {
                p.setTelaCadastro(TipoUsuario.getModuloAcesso(), "Cadastro de tipos de usu\u00e1rio");
            } else {
                p.adicionaCampo("tpu_inativo", "Inativo", 0, "", 3, 3);
            }
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("tipousuario"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("tipousuario", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable paciente(Object pai, String filial, boolean mostrarCadastro, boolean mostrarCamposRecepcao, boolean acessoLabApoio, boolean ocultaNomePessoa) {
        String sujeito = "pacientes";
        if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
            sujeito = "clientes";
        } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
            sujeito = "animais";
        }
        ConvenioService convenioService = new ConvenioService();
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando " + sujeito);
        List<String> campos = Arrays.asList("pac_nome", "pac_rg", "pac_nomesocial");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Paciente.getModuloAcesso(), "Cadastro de " + sujeito, filial);
            }
            p.removerCampos();
            p.adicionaCampo("pac_codigo", "C\u00f3digo", 1, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                int campoPesquisa = ocultaNomePessoa ? 3 : 2;
                p.adicionaCampo("pac_nome", "pac_nomesocial", "Nome", 8, "", 2, campoPesquisa, true, false);
                p.adicionaCampo("pac_nomesocial", "Nome Social", 0, "", 2, 1, true, false);
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.pac_codigo ");
                if (ocultaNomePessoa) {
                    buf.append("       ,'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome ");
                    buf.append("       ,'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nomesocial ");
                } else {
                    buf.append("       ,a.pac_nome ");
                    buf.append("       ,a.pac_nomesocial ");
                }
                buf.append("       ,a.pac_cpf ");
                buf.append("       ,a.pac_rg ");
                buf.append("       ,a.pac_datanasc ");
                buf.append("       ,b.con_fantasia ");
                buf.append("       ,a.pac_celular ");
                buf.append("       ,a.pac_email ");
                if (mostrarCamposRecepcao && ParametrosLocais.getParametro("visualizarProntuarioPesquisaPacienteRequisicao") != null && Integer.parseInt(ParametrosLocais.getParametro("visualizarProntuarioPesquisaPacienteRequisicao")) == 1) {
                    buf.append("     ,a.pac_prontuario ");
                }
                buf.append("   from paciente a ");
                buf.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                p.setSql(buf.toString());
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_rg", "RG", 6, "", 3);
                p.adicionaCampo("pac_datanasc", "Nascimento", 2, "", 3);
                p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
                p.adicionaCampo("pac_celular", "Celular", 0, ParametrosGerais.getMascaraFone(), 2);
                p.adicionaCampo("pac_email", "E-mail", 0, "", 2);
                if (ParametrosGerais.getBuscaPorNomeRG()) {
                    p.adicionaCampo(campos, "Nome/RG", 9, "", 2, 0, false, true);
                }
                if (mostrarCamposRecepcao) {
                    if (ParametrosLocais.getParametro("visualizarProntuarioPesquisaPacienteRequisicao") != null && Integer.parseInt(ParametrosLocais.getParametro("visualizarProntuarioPesquisaPacienteRequisicao")) == 1) {
                        p.adicionaCampo("pac_prontuario", "Prontu\u00e1rio", 0, "", 2);
                    }
                    p.setFiltroInicial("Nome", Pesquisas.validaCampoPesquisaPaciente("Nome"));
                    p.setOrdem("Nome");
                    if (Pesquisas.parametroPesquisarPacientePeloCodigo()) {
                        p.setFiltroInicial("C\u00f3digo", Pesquisas.validaCampoPesquisaPaciente("C\u00f3digo"));
                        p.setOrdem("C\u00f3digo");
                    }
                    if (ParametrosLocais.getParametro("pesquisarPacienteRequisicao") != null) {
                        p.setFiltroInicial(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"), Pesquisas.validaCampoPesquisaPaciente(ParametrosLocais.getParametro("pesquisarPacienteRequisicao")));
                        p.setOrdem(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"));
                    }
                } else if (!ocultaNomePessoa) {
                    p.setFiltroInicial("Nome", 2);
                    p.setOrdem("Nome");
                }
            } else {
                if (ocultaNomePessoa) {
                    p.adicionaCampo("pac_nome", "Nome", 0, "", 2, 3);
                } else {
                    p.adicionaCampo("pac_nome", "Nome", 0, "", 2, 2, true, false);
                }
                if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                    StringBuffer sql = new StringBuffer();
                    sql.append(" select a.pac_codigo ");
                    if (ocultaNomePessoa) {
                        sql.append("       ,'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome ");
                    } else {
                        sql.append("       ,a.pac_nome ");
                    }
                    sql.append("       ,a.pac_cpf ");
                    sql.append("       ,a.pac_rg ");
                    sql.append("       ,a.pac_proprietario ");
                    sql.append("  from paciente a ");
                    sql.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                    p.setSql(sql.toString());
                    p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                    p.adicionaCampo("pac_rg", "RG", 6, "", 3);
                    p.adicionaCampo("pac_proprietario", "Propriet\u00e1rio", 0, "", 2);
                    p.setFiltroInicial("Nome", 2);
                    p.setOrdem("Nome");
                    if (ParametrosLocais.getParametro("pesquisarPacienteRequisicao") != null) {
                        p.setFiltroInicial(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"), Pesquisas.validaCampoPesquisaPaciente(ParametrosLocais.getParametro("pesquisarPacienteRequisicao")));
                        p.setOrdem(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"));
                    }
                } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                    StringBuffer sql = new StringBuffer();
                    sql.append(" select a.pac_codigo ");
                    if (ocultaNomePessoa) {
                        sql.append("       ,'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome ");
                    } else {
                        sql.append("       ,a.pac_nome ");
                    }
                    sql.append("       ,a.pac_razaosocial ");
                    sql.append("       ,a.pac_cnpj ");
                    sql.append("       ,a.pac_cpf ");
                    sql.append("       ,a.pac_rg ");
                    sql.append("       ,a.pac_sif ");
                    sql.append("       ,a.pac_celular ");
                    sql.append("       ,a.pac_email ");
                    sql.append("   from paciente a");
                    sql.append("   left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
                    p.setSql(sql.toString());
                    p.adicionaCampo("pac_razaosocial", "Raz\u00e3o Social", 0, "", 2);
                    p.adicionaCampo("pac_cnpj", "CNPJ", 0, "##.###.###/####-##", 3);
                    p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                    p.adicionaCampo("pac_rg", "RG", 6, "", 3);
                    p.adicionaCampo("pac_sif", "SIF", 0, "", 2);
                    p.adicionaCampo("pac_celular", "Celular", 0, ParametrosGerais.getMascaraFone(), 2);
                    p.adicionaCampo("pac_email", "E-mail", 0, "", 2);
                    p.setFiltroInicial("Nome", 2);
                    p.setOrdem("Nome");
                    if (ParametrosLocais.getParametro("pesquisarPacienteRequisicao") != null) {
                        p.setFiltroInicial(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"), Pesquisas.validaCampoPesquisaPaciente(ParametrosLocais.getParametro("pesquisarPacienteRequisicao")));
                        p.setOrdem(ParametrosLocais.getParametro("pesquisarPacienteRequisicao"));
                    }
                }
            }
            StringBuffer filtro = new StringBuffer();
            filtro.append("a.fil_codigo = " + filial);
            if (acessoLabApoio && convenioService.getPossuiCampoPermitirPesquisaApoio()) {
                filtro.append("  and (COALESCE(b.con_permitirpesquisaapoio, false) OR NOT COALESCE(b.con_apoiado, false)) ");
            } else if (acessoLabApoio) {
                filtro.append(" and COALESCE(b.con_apoiado, false) = false ");
            }
            p.setFiltro(filtro.toString());
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("paciente"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("paciente", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    private static boolean parametroPesquisarPacientePeloCodigo() {
        return ParametrosLocais.getParametro("pesquisarPacienteCodigoRequisicao") != null && ParametrosLocais.getParametro("pesquisarPacienteCodigoRequisicao").equals("1");
    }

    public static Hashtable requisicao(Object pai, String filial, boolean mostrarCadastro, boolean acessoLabApoio, boolean ocultaNomePessoa) {
        return Pesquisas.requisicao(pai, filial, mostrarCadastro, false, acessoLabApoio, ocultaNomePessoa, false);
    }

    public static Hashtable requisicao(Object pai, String filial, boolean mostrarCadastro, boolean acessoLabApoio, boolean ocultaNomePessoa, boolean ocultaDataHora) {
        return Pesquisas.requisicao(pai, filial, mostrarCadastro, false, acessoLabApoio, ocultaNomePessoa, ocultaDataHora);
    }

    public static Hashtable requisicao(Object pai, String filial, boolean mostrarCadastro, boolean ignorarFilial, boolean acessoLabApoio, boolean ocultaNomePessoa, boolean ocultaDataHora) {
        return Pesquisas.requisicao(pai, filial, mostrarCadastro, ignorarFilial, null, null, null, acessoLabApoio, ocultaNomePessoa, ocultaDataHora, false);
    }

    public static Hashtable requisicao(Object pai, String filial, boolean mostrarCadastro, boolean ignorarFilial, String codigoPaciente, String codigoRequisicaoRemover, boolean acessoLabApoio, boolean ocultaNomePessoa) {
        return Pesquisas.requisicao(pai, filial, mostrarCadastro, ignorarFilial, codigoPaciente, codigoRequisicaoRemover, null, acessoLabApoio, ocultaNomePessoa, false, false);
    }

    public static Hashtable requisicao(final Object pai, final String filial, boolean mostrarCadastro, boolean ignorarFilial, String codigoPaciente, String codigoRequisicaoRemover, String codigoConvenio, boolean acessoLabApoio, boolean ocultaNomePessoa, boolean ocultaDataHora, boolean ocultaConvenio) {
        final FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando por requisi\u00e7\u00f5es");
        ConvenioService convenioService = new ConvenioService();
        if (p != null) {
            p.setRequisicao(true);
            if (mostrarCadastro) {
                p.setTelaCadastro(Requisicao.getModuloAcesso(), "Cadastro de requisi\u00e7\u00f5es");
            }
            StringBuilder sql = new StringBuilder("select distinct ");
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                if (ignorarFilial) {
                    sql.append("a.fil_codigo, a.req_codigo, ");
                    if (ocultaNomePessoa) {
                        sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome, ");
                        sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida").append("' as pac_nomesocial,  ");
                    } else {
                        sql.append("b.pac_nome, ");
                        sql.append("b.pac_nomesocial, ");
                    }
                } else {
                    sql.append("a.req_codigo, ");
                    if (ocultaNomePessoa) {
                        sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome, ");
                        sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida").append("' as pac_nomesocial,  ");
                    } else {
                        sql.append("b.pac_nome, ");
                        sql.append("b.pac_nomesocial, ");
                    }
                }
            } else if (ignorarFilial) {
                sql.append("a.fil_codigo, a.req_codigo, ");
                if (ocultaNomePessoa) {
                    sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome, ");
                } else {
                    sql.append("b.pac_nome, ");
                }
            } else {
                sql.append("a.req_codigo, ");
                if (ocultaNomePessoa) {
                    sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida").append("' as pac_nome,  ");
                } else {
                    sql.append("b.pac_nome, ");
                }
            }
            if (!ocultaDataHora) {
                sql.append("a.req_data, ");
            }
            sql.append(" a.req_guia, c.med_nome, ");
            if (!ocultaConvenio) {
                sql.append("d.con_fantasia, ");
            } else {
                sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida' as con_fantasia, ");
            }
            sql.append("a.req_matricula, a.des_codigo, ");
            sql.append("pegadescricaoexamerequisicao(a.fil_codigo, a.req_codigo), pegacodigoexamerequisicao(a.fil_codigo, a.req_codigo) ");
            if (ParametrosGerais.getPesquisaCopia()) {
                sql.append(", a.req_codcopia ");
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                sql.append(", a.req_prontuario ");
                sql.append(", a.req_prescricao ");
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                sql.append(", b.pac_cpf, b.pac_datanasc ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                sql.append(", b.pac_cpf, b.pac_proprietario ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                if (!ocultaNomePessoa) {
                    sql.append(", b.pac_razaosocial, b.pac_cnpj, b.pac_sif,");
                } else {
                    sql.append(", 'Visualiza\u00e7\u00e3o n\u00e3o permitida', b.pac_cnpj, b.pac_sif,");
                }
                if (!ocultaConvenio) {
                    sql.append(" d.con_razao, ");
                } else {
                    sql.append("'Visualiza\u00e7\u00e3o n\u00e3o permitida',");
                }
                sql.append(" a.req_datarecebimentoproduto, a.req_descricaoproduto, a.req_numeroregistroproduto, a.req_numeroloteproduto,  ");
                sql.append("a.req_marcaproduto, a.req_lacreproduto, a.req_lacreprodutocontra, a.req_lacreprodutocontraempresa, a.req_doctoreferenciaproduto, ");
                sql.append("a.req_nrsolicitacaoproduto, e.pco_nome, ent.ent_fantasia, a.req_anoprpproduto, a.req_cicloprpproduto, a.req_amostraprpproduto, a.req_areaproduto ");
            }
            sql.append("from requisicao a ");
            sql.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            if (convenioService.getPossuiCampoPermitirPesquisaApoio()) {
                sql.append("left join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
            }
            sql.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf=c.med_uf ");
            sql.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            sql.append("left join pacientescontatos e on a.fil_codigo = e.fil_codigo and a.pac_codigo = e.pac_codigo and a.pco_codigo = e.pco_codigo ");
            sql.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
            sql.append("left join examerequisicao exm on a.fil_codigo = exm.fil_codigo and a.req_codigo = exm.req_codigo ");
            sql.append("left join exames exame on exm.fil_codigo = exame.fil_codigo and exm.exa_codigo = exame.exa_codigo ");
            p.setSql(sql.toString());
            p.removerCampos();
            if (ignorarFilial) {
                p.adicionaCampo("a.fil_codigo", "Fil.", 1, "", 3);
            }
            p.adicionaCampo("a.req_codigo", "C\u00f3digo", 1, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                if (ocultaNomePessoa) {
                    p.adicionaCampo("pac_nome", "pac_nomesocial", "Paciente", 8, "", 2, 3, true, false);
                    p.adicionaCampo("pac_nomesocial", "Nome Social", 0, "", 2, 1, true, false);
                } else {
                    p.adicionaCampo("pac_nome", "pac_nomesocial", "Paciente", 8, "", 2, 2, true, false);
                    p.adicionaCampo("pac_nomesocial", "Nome Social", 0, "", 2, 1, true, false);
                }
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_nome", "Animal", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                if (ocultaNomePessoa) {
                    p.adicionaCampo("pac_nome", "Cliente", 0, "", 2, 3);
                } else {
                    p.adicionaCampo("pac_nome", "Cliente", 0, "", 2);
                }
            }
            if (!ocultaDataHora) {
                p.adicionaCampo("a.req_data", "Data", 2, "##/##/####", 3);
            }
            p.adicionaCampo("req_guia", "Guia", 0, "", 3);
            p.adicionaCampo("med_nome", "M\u00e9dico", 0, "", 2);
            if (ocultaConvenio) {
                p.adicionaCampo("d.con_fantasia", "Conv\u00eanio", 0, "", 2, 3);
            } else {
                p.adicionaCampo("d.con_fantasia", "Conv\u00eanio", 0, "", 2);
            }
            p.adicionaCampo("req_matricula", "Matr\u00edcula", 0, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("a.des_codigo", "Modal.", 0, "", 2);
            } else {
                p.adicionaCampo("a.des_codigo", "Destino", 0, "", 2);
            }
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o Exames", 0, "", 2, 1);
            p.adicionaCampo("exm.exa_codigo", "Exames", 0, "", 3, 1);
            if (ParametrosGerais.getPesquisaCopia()) {
                p.adicionaCampo("req_codcopia", "C\u00f3pia", 1, "", 3);
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                p.adicionaCampo("req_prontuario", "Prontu\u00e1rio", 0, "", 2);
                p.adicionaCampo("req_prescricao", "Prescri\u00e7\u00e3o", 0, "", 2);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_datanasc", "Nascimento", 2, "", 3);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_proprietario", "Propriet\u00e1rio", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("pac_razaosocial", "Raz\u00e3o Social", 0, "", 2);
                p.adicionaCampo("pac_cnpj", "CNPJ", 0, "##.###.###/####-##", 3);
                p.adicionaCampo("pac_sif", "SIF", 0, "", 2);
                p.adicionaCampo("con_razao", "Raz\u00e3o conv\u00eanio", 0, "", 2);
                p.adicionaCampo("req_datarecebimentoproduto", "Data receb.", 2, "", 3, 2);
                p.adicionaCampo("req_descricaoproduto", "Produto", 0, "", 2, 1);
                p.adicionaCampo("req_numeroregistroproduto", "Registro", 0, "", 3, 1);
                p.adicionaCampo("req_numeroloteproduto", "Lote", 0, "", 3, 1);
                p.adicionaCampo("req_marcaproduto", "Marca", 0, "", 2, 1);
                p.adicionaCampo("req_lacreproduto", "Lacre", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontra", "Lacre CP", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontraempresa", "Lacre Empresa", 0, "", 3, 1);
                p.adicionaCampo("req_doctoreferenciaproduto", "Documento Refer\u00eancia", 0, "", 3, 1);
                p.adicionaCampo("req_nrsolicitacaoproduto", "Nr. Solicita\u00e7\u00e3o", 0, "", 3, 1);
                p.adicionaCampo("pco_nome", "Resp.", 0, "", 2, 1);
                p.adicionaCampo("ent_fantasia", "Respons\u00e1vel", 0, "", 2, 1);
                p.adicionaCampo("req_anoprpproduto", "Ano", 1, "", 3, 1);
                p.adicionaCampo("req_cicloprpproduto", "Ciclo", 0, "", 3, 1);
                p.adicionaCampo("req_amostraprpproduto", "Amostra", 0, "", 3, 1);
                p.adicionaCampo("req_areaproduto", "\u00c1rea", 0, "", 3, 1);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                if (!ocultaNomePessoa) {
                    p.setFiltroInicial("Paciente", 2);
                } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                    if (!ocultaNomePessoa) {
                        p.setFiltroInicial("Animal", 2);
                    } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && !ocultaNomePessoa) {
                        p.setFiltroInicial("Cliente", 2);
                    }
                }
            }
            StringBuilder where = new StringBuilder();
            if (ignorarFilial) {
                where.append(" a.req_excluida = false ");
            } else {
                where.append("a.fil_codigo = " + filial + " and a.req_excluida = false ");
            }
            if (codigoPaciente != null && !Funcoes.textoVazio(codigoPaciente)) {
                where.append(" and b.pac_codigo = ").append(codigoPaciente);
            }
            if (codigoRequisicaoRemover != null && !Funcoes.textoVazio(codigoRequisicaoRemover)) {
                where.append(" and a.req_codigo <> ").append(codigoRequisicaoRemover);
            }
            if (codigoConvenio != null && !Funcoes.textoVazio(codigoConvenio)) {
                where.append(" and d.con_codigo = ").append(codigoConvenio);
            }
            if (acessoLabApoio && convenioService.getPossuiCampoPermitirPesquisaApoio()) {
                where.append(" and (COALESCE(con.con_permitirpesquisaapoio, false) OR NOT COALESCE(d.con_apoiado, false)) ");
            } else if (acessoLabApoio) {
                where.append(" and COALESCE(d.con_apoiado, false) = false ");
            }
            p.setFiltro(where.toString());
            if (!ocultaNomePessoa) {
                p.setOrdem("Paciente");
            } else {
                p.setOrdem("C\u00f3digo");
            }
            p.setExecutarAoAbrir(false);
            p.addInfoListener(new InfoListener(){

                @Override
                public void chamadaInfo(int requisicao) {
                    if (pai instanceof Laboratorio) {
                        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)pai).getRootPane().getGlassPane();
                        InfoRequisicao info = new InfoRequisicao((Dialog)p, glassPaneMensagem);
                        info.setRequisicao(filial, requisicao);
                        info.setVisible(true);
                        ((Laboratorio)pai).getRootPane().setGlassPane(glassPaneMensagem);
                    }
                }
            });
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("requisicao"));
            p.setVisible(true);
            p.removeAllInfoListener();
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("requisicao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable requisicao(final Object pai, final String filial, boolean mostrarCadastro, boolean ignorarFilial, String codigoPaciente, String codigoRequisicaoRemover, String codigoConvenio, boolean acessoLabApoio, boolean ocultaNomePessoa, String condicaoAdicional) {
        final FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando por requisi\u00e7\u00f5es");
        ConvenioService convenioService = new ConvenioService();
        if (p != null) {
            p.setRequisicao(true);
            if (mostrarCadastro) {
                p.setTelaCadastro(Requisicao.getModuloAcesso(), "Cadastro de requisi\u00e7\u00f5es");
            }
            StringBuilder sql = new StringBuilder("select distinct ");
            if (ignorarFilial && ocultaNomePessoa) {
                sql.append("a.fil_codigo, a.req_codigo, 'Visualiza\u00e7\u00e3o n\u00e3o permitida' as pac_nome, ");
            } else if (ocultaNomePessoa) {
                sql.append("a.req_codigo, 'Visualiza\u00e7\u00e3o n\u00e3o permitida' as  pac_nome, ");
            } else if (ignorarFilial) {
                sql.append("a.fil_codigo, a.req_codigo, b.pac_nome, ");
            } else {
                sql.append("a.req_codigo, b.pac_nome, ");
            }
            if (!Acesso.getAcesso(Requisicao.ACESSO_OCULTAR_DATA_HORA)) {
                sql.append("a.req_data, ");
            }
            sql.append(" a.req_guia, c.med_nome, d.con_fantasia, a.req_matricula, a.des_codigo, ");
            sql.append("pegadescricaoexamerequisicao(a.fil_codigo, a.req_codigo), pegacodigoexamerequisicao(a.fil_codigo, a.req_codigo) ");
            if (ParametrosGerais.getPesquisaCopia()) {
                sql.append(", a.req_codcopia ");
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                sql.append(", a.req_prontuario ");
                sql.append(", a.req_prescricao ");
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                sql.append(", b.pac_cpf, b.pac_datanasc ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                sql.append(", b.pac_cpf, b.pac_proprietario ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                sql.append(", b.pac_razaosocial, b.pac_cnpj, b.pac_sif, d.con_razao, a.req_datarecebimentoproduto, a.req_descricaoproduto, a.req_numeroregistroproduto, a.req_numeroloteproduto,  ");
                sql.append("a.req_marcaproduto, a.req_lacreproduto, a.req_lacreprodutocontra, a.req_lacreprodutocontraempresa, a.req_doctoreferenciaproduto, ");
                sql.append("a.req_nrsolicitacaoproduto, e.pco_nome, ent.ent_fantasia, a.req_anoprpproduto, a.req_cicloprpproduto, a.req_amostraprpproduto, a.req_areaproduto ");
            }
            sql.append("from requisicao a ");
            sql.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            if (convenioService.getPossuiCampoPermitirPesquisaApoio()) {
                sql.append("left join convenios con on b.fil_codigo = con.fil_codigo and b.con_codigo = con.con_codigo ");
            }
            sql.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf=c.med_uf ");
            sql.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            sql.append("left join pacientescontatos e on a.fil_codigo = e.fil_codigo and a.pac_codigo = e.pac_codigo and a.pco_codigo = e.pco_codigo ");
            sql.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
            sql.append("left join examerequisicao exm on a.fil_codigo = exm.fil_codigo and a.req_codigo = exm.req_codigo ");
            sql.append("left join exames exame on exm.fil_codigo = exame.fil_codigo and exm.exa_codigo = exame.exa_codigo ");
            p.setSql(sql.toString());
            p.removerCampos();
            if (ignorarFilial) {
                p.adicionaCampo("a.fil_codigo", "Fil.", 1, "", 3);
            }
            p.adicionaCampo("a.req_codigo", "C\u00f3digo", 1, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                if (ocultaNomePessoa) {
                    p.adicionaCampo("pac_nome", "Paciente", 0, "", 2, 3);
                } else {
                    p.adicionaCampo("pac_nome", "Paciente", 0, "", 2);
                }
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_nome", "Animal", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                if (ocultaNomePessoa) {
                    p.adicionaCampo("pac_nome", "Cliente", 0, "", 2, 3);
                } else {
                    p.adicionaCampo("pac_nome", "Cliente", 0, "", 2);
                }
            }
            if (!Acesso.getAcesso(Requisicao.ACESSO_OCULTAR_DATA_HORA)) {
                p.adicionaCampo("a.req_data", "Data", 2, "##/##/####", 3);
            }
            p.adicionaCampo("req_guia", "Guia", 0, "", 3);
            p.adicionaCampo("med_nome", "M\u00e9dico", 0, "", 2);
            p.adicionaCampo("d.con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("req_matricula", "Matr\u00edcula", 0, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("a.des_codigo", "Modal.", 0, "", 2);
            } else {
                p.adicionaCampo("a.des_codigo", "Destino", 0, "", 2);
            }
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o Exames", 0, "", 2, 1);
            p.adicionaCampo("exm.exa_codigo", "Exames", 0, "", 3, 1);
            if (ParametrosGerais.getPesquisaCopia()) {
                p.adicionaCampo("req_codcopia", "C\u00f3pia", 1, "", 3);
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                p.adicionaCampo("req_prontuario", "Prontu\u00e1rio", 0, "", 2);
                p.adicionaCampo("req_prescricao", "Prescri\u00e7\u00e3o", 0, "", 2);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_datanasc", "Nascimento", 2, "", 3);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_proprietario", "Proprietario", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("pac_razaosocial", "Raz\u00e3o Social", 0, "", 2);
                p.adicionaCampo("pac_cnpj", "CNPJ", 0, "##.###.###/####-##", 3);
                p.adicionaCampo("pac_sif", "SIF", 0, "", 2);
                p.adicionaCampo("con_razao", "Raz\u00e3o conv\u00eanio", 0, "", 2);
                p.adicionaCampo("req_datarecebimentoproduto", "Data receb.", 2, "", 3, 2);
                p.adicionaCampo("req_descricaoproduto", "Produto", 0, "", 2, 1);
                p.adicionaCampo("req_numeroregistroproduto", "Registro", 0, "", 3, 1);
                p.adicionaCampo("req_numeroloteproduto", "Lote", 0, "", 3, 1);
                p.adicionaCampo("req_marcaproduto", "Marca", 0, "", 2, 1);
                p.adicionaCampo("req_lacreproduto", "Lacre", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontra", "Lacre CP", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontraempresa", "Lacre Empresa", 0, "", 3, 1);
                p.adicionaCampo("req_doctoreferenciaproduto", "Documento Refer\u00eancia", 0, "", 3, 1);
                p.adicionaCampo("req_nrsolicitacaoproduto", "Nr. Solicita\u00e7\u00e3o", 0, "", 3, 1);
                p.adicionaCampo("pco_nome", "Resp.", 0, "", 2, 1);
                p.adicionaCampo("ent_fantasia", "Respons\u00e1vel", 0, "", 2, 1);
                p.adicionaCampo("req_anoprpproduto", "Ano", 1, "", 3, 1);
                p.adicionaCampo("req_cicloprpproduto", "Ciclo", 0, "", 3, 1);
                p.adicionaCampo("req_amostraprpproduto", "Amostra", 0, "", 3, 1);
                p.adicionaCampo("req_areaproduto", "\u00c1rea", 0, "", 3, 1);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                if (!ocultaNomePessoa) {
                    p.setFiltroInicial("Paciente", 2);
                } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                    if (!ocultaNomePessoa) {
                        p.setFiltroInicial("Animal", 2);
                    } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A") && !ocultaNomePessoa) {
                        p.setFiltroInicial("Cliente", 2);
                    }
                }
            }
            StringBuilder where = new StringBuilder();
            if (ignorarFilial) {
                where.append(" a.req_excluida = false ");
            } else {
                where.append("a.fil_codigo = " + filial + " and a.req_excluida = false ");
            }
            if (codigoPaciente != null && !Funcoes.textoVazio(codigoPaciente)) {
                where.append(" and b.pac_codigo = ").append(codigoPaciente);
            }
            if (codigoRequisicaoRemover != null && !Funcoes.textoVazio(codigoRequisicaoRemover)) {
                where.append(" and a.req_codigo <> ").append(codigoRequisicaoRemover);
            }
            if (codigoConvenio != null && !Funcoes.textoVazio(codigoConvenio)) {
                where.append(" and d.con_codigo = ").append(codigoConvenio);
            }
            if (acessoLabApoio && convenioService.getPossuiCampoPermitirPesquisaApoio()) {
                where.append(" and (COALESCE(con.con_permitirpesquisaapoio, false) OR NOT COALESCE(d.con_apoiado, false)) ");
            } else if (acessoLabApoio) {
                where.append(" and COALESCE(d.con_apoiado, false) = false ");
            }
            where.append(" ");
            where.append(condicaoAdicional).append(" ");
            p.setFiltro(where.toString());
            if (!ocultaNomePessoa) {
                p.setOrdem("Paciente");
            } else {
                p.setOrdem("C\u00f3digo");
            }
            p.setExecutarAoAbrir(false);
            p.addInfoListener(new InfoListener(){

                @Override
                public void chamadaInfo(int requisicao) {
                    if (pai instanceof Laboratorio) {
                        GlassPaneMensagem glassPaneMensagem = (GlassPaneMensagem)((Laboratorio)pai).getRootPane().getGlassPane();
                        InfoRequisicao info = new InfoRequisicao((Dialog)p, glassPaneMensagem);
                        info.setRequisicao(filial, requisicao);
                        info.setVisible(true);
                        ((Laboratorio)pai).getRootPane().setGlassPane(glassPaneMensagem);
                    }
                }
            });
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("requisicao"));
            p.setVisible(true);
            p.removeAllInfoListener();
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("requisicao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable requisicaoSemFilial(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando por requisi\u00e7\u00f5es");
        if (p != null) {
            StringBuilder sql = new StringBuilder("select distinct a.fil_codigo, a.req_codigo, b.pac_nome, ");
            if (!Acesso.getAcesso(Requisicao.ACESSO_OCULTAR_DATA_HORA)) {
                sql.append(" a.req_data, ");
            }
            sql.append(" a.req_guia, c.med_nome, d.con_fantasia, a.req_matricula, a.des_codigo, ");
            sql.append("pegadescricaoexamerequisicao(a.fil_codigo, a.req_codigo), pegacodigoexamerequisicao(a.fil_codigo, a.req_codigo) ");
            if (ParametrosGerais.getPesquisaCopia()) {
                sql.append(", a.req_codcopia ");
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                sql.append(", a.req_prontuario ");
                sql.append(", a.req_prescricao ");
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                sql.append(", b.pac_cpf, b.pac_datanasc ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                sql.append(", b.pac_cpf, b.pac_proprietario ");
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                sql.append(", b.pac_razaosocial, b.pac_cnpj, b.pac_sif, d.con_razao, a.req_datarecebimentoproduto, a.req_descricaoproduto, a.req_numeroregistroproduto, a.req_numeroloteproduto,  ");
                sql.append("a.req_marcaproduto, a.req_lacreproduto, a.req_lacreprodutocontra, a.req_lacreprodutocontraempresa, a.req_doctoreferenciaproduto, ");
                sql.append("a.req_nrsolicitacaoproduto, e.pco_nome, ent.ent_fantasia, a.req_anoprpproduto, a.req_cicloprpproduto, a.req_amostraprpproduto, a.req_areaproduto ");
            }
            sql.append("from requisicao a ");
            sql.append("left join paciente b on a.fil_codigo = b.fil_codigo and a.pac_codigo = b.pac_codigo ");
            sql.append("left join medico c on a.fil_codigo = c.fil_codigo and a.med_conselho = c.med_conselho and a.med_crm = c.med_crm and a.med_uf=c.med_uf ");
            sql.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            sql.append("left join pacientescontatos e on a.fil_codigo = e.fil_codigo and a.pac_codigo = e.pac_codigo and a.pco_codigo = e.pco_codigo ");
            sql.append("left join entidade ent on a.fil_codigo = ent.fil_codigo and a.ent_codigo = ent.ent_codigo ");
            sql.append("left join examerequisicao exm on a.fil_codigo = exm.fil_codigo and a.req_codigo = exm.req_codigo ");
            sql.append("left join exames exame on exm.fil_codigo = exame.fil_codigo and exm.exa_codigo = exame.exa_codigo ");
            p.setSql(sql.toString());
            p.removerCampos();
            p.adicionaCampo("a.fil_codigo", "Filial", 1, "", 3);
            p.adicionaCampo("a.req_codigo", "C\u00f3digo", 1, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                p.adicionaCampo("pac_nome", "Paciente", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_nome", "Animal", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("pac_nome", "Cliente", 0, "", 2);
            }
            if (!Acesso.getAcesso(Requisicao.ACESSO_OCULTAR_DATA_HORA)) {
                p.adicionaCampo("req_data", "Data", 2, "##/##/####", 3);
            }
            p.adicionaCampo("req_guia", "Guia", 0, "", 3);
            p.adicionaCampo("med_nome", "M\u00e9dico", 0, "", 2);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("req_matricula", "Matr\u00edcula", 0, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("a.des_codigo", "Modal.", 0, "", 2);
            } else {
                p.adicionaCampo("a.des_codigo", "Destino", 0, "", 2);
            }
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o Exames", 0, "", 2, 1);
            p.adicionaCampo("exm.exa_codigo", "Exames", 0, "", 3, 1);
            if (ParametrosGerais.getPesquisaCopia()) {
                p.adicionaCampo("req_codcopia", "C\u00f3pia", 1, "", 3);
            }
            if (Variaveis.tipoFilialPadrao.equals("C") && ParametrosLocais.getParametro("mostrarHospital") != null && ParametrosLocais.getParametro("mostrarHospital").equals("1")) {
                p.adicionaCampo("req_prontuario", "Prontu\u00e1rio", 0, "", 2);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_datanasc", "Nascimento", 2, "", 3);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.adicionaCampo("pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("pac_proprietario", "Proprietario", 0, "", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("pac_razaosocial", "Raz\u00e3o Social", 0, "", 2);
                p.adicionaCampo("pac_cnpj", "CNPJ", 0, "##.###.###/####-##", 3);
                p.adicionaCampo("pac_sif", "SIF", 0, "", 2);
                p.adicionaCampo("con_razao", "Raz\u00e3o conv\u00eanio", 0, "", 2);
                p.adicionaCampo("req_datarecebimentoproduto", "Data receb.", 2, "", 3, 2);
                p.adicionaCampo("req_descricaoproduto", "Produto", 0, "", 2, 1);
                p.adicionaCampo("req_numeroregistroproduto", "Registro", 0, "", 3, 1);
                p.adicionaCampo("req_numeroloteproduto", "Lote", 0, "", 3, 1);
                p.adicionaCampo("req_marcaproduto", "Marca", 0, "", 2, 1);
                p.adicionaCampo("req_lacreproduto", "Lacre", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontra", "Lacre CP", 0, "", 3, 1);
                p.adicionaCampo("req_lacreprodutocontraempresa", "Lacre Empresa", 0, "", 3, 1);
                p.adicionaCampo("req_doctoreferenciaproduto", "Documento Refer\u00eancia", 0, "", 3, 1);
                p.adicionaCampo("req_nrsolicitacaoproduto", "Nr. Solicita\u00e7\u00e3o", 0, "", 3, 1);
                p.adicionaCampo("pco_nome", "Resp.", 0, "", 2, 1);
                p.adicionaCampo("ent_fantasia", "Respons\u00e1vel", 0, "", 2, 1);
                p.adicionaCampo("req_anoprpproduto", "Ano", 1, "", 3, 1);
                p.adicionaCampo("req_cicloprpproduto", "Ciclo", 0, "", 3, 1);
                p.adicionaCampo("req_amostraprpproduto", "Amostra", 0, "", 3, 1);
                p.adicionaCampo("req_areaproduto", "\u00c1rea", 0, "", 3, 1);
            }
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("C")) {
                p.setFiltroInicial("Paciente", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("V")) {
                p.setFiltroInicial("Animal", 2);
            } else if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.setFiltroInicial("Cliente", 2);
            }
            p.setFiltro(" a.req_excluida = false ");
            p.setOrdem("Paciente");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("requisicao"));
            p.setVisible(true);
            p.removeAllInfoListener();
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("requisicao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable requisicaoSoroteca(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando por requisi\u00e7\u00f5es na soroteca");
        if (p != null) {
            StringBuilder sql = new StringBuilder("select distinct req.fil_codigo, req.req_codigo, pac.pac_nome, ");
            sql.append(" req.req_guia, med.med_nome, con.con_fantasia, req.req_matricula, ");
            sql.append(" pegadescricaoexamerequisicao(req.fil_codigo, req.req_codigo), pegacodigoexamerequisicao(req.fil_codigo, req.req_codigo) ");
            sql.append("   from examerequisicaorecipiente a ");
            sql.append("   join examerequisicaosoroteca eso on a.fil_codigo = eso.fil_kodigo and a.exa_codigo = eso.exa_codigo and a.req_codigo = eso.req_codigo and a.rec_codigo = eso.rec_codigo and eso.usr_coddescarte IS NULL ");
            sql.append("   join exames                  exa on a.fil_codigo = exa.fil_codigo and a.exa_codigo = exa.exa_codigo ");
            sql.append("   join examerequisicao \t\t\t\texr on a.fil_codigo = exr.fil_codigo and a.req_codigo = exr.req_codigo and a.exa_codigo = exr.exa_codigo and a.mco_codigo = exr.mco_codigo and exr.exr_excluido = false ");
            sql.append("   join requisicao      \t\t\t\treq on exr.fil_codigo = req.fil_codigo and exr.req_codigo = req.req_codigo and req.req_excluida = false ");
            sql.append("   join paciente        \t\t\t\tpac on req.fil_codigo = pac.fil_codigo and req.pac_codigo = pac.pac_codigo ");
            sql.append("   join medico          \t\t\t\tmed on req.fil_codigo = med.fil_codigo and req.med_conselho = med.med_conselho and req.med_crm = med.med_crm and req.med_uf = med.med_uf ");
            sql.append("   join convenios       \t\t\t\tcon on req.fil_codigo = con.fil_codigo and req.con_codigo = con.con_codigo ");
            p.setSql(sql.toString());
            p.removerCampos();
            p.adicionaCampo("a.fil_codigo", "Filial", 1, "", 3);
            p.adicionaCampo("a.req_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("pac_nome", "Paciente", 0, "", 2);
            p.adicionaCampo("req_guia", "Guia", 0, "", 3);
            p.adicionaCampo("med_nome", "M\u00e9dico", 0, "", 2);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("req_matricula", "Matr\u00edcula", 0, "", 3);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o Exames", 0, "", 2, 1);
            p.adicionaCampo("exm.exa_codigo", "Exames", 0, "", 3, 1);
            p.setFiltroInicial("Paciente", 2);
            p.setOrdem("Paciente");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            p.removeAllInfoListener();
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable banco(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando bancos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Banco.getModuloAcesso(), "Cadastro de bancos");
            }
            p.setSql("select bac_codigo, bac_descricao from banco");
            p.removerCampos();
            p.adicionaCampo("bac_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("bac_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("banco"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("banco", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable agencia(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando ag\u00eancias");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Agencia.getModuloAcesso(), "Cadastro de ag\u00eancias");
            }
            StringBuilder buf = new StringBuilder("select a.age_codigo, b.bac_codigo, a.age_descricao, b.bac_descricao from agencia a ");
            buf.append("left join banco b on a.fil_codigo = b.fil_codigo and a.bac_codigo = b.bac_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("age_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("bac_codigo", "Banco", 1, "", 3);
            p.adicionaCampo("age_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("bac_descricao", "Descri\u00e7\u00e3o Banco", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("a.fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("agencia"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("agencia", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable historicoPadrao(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando hist\u00f3ricos padr\u00f5es");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(HistoricoPadrao.getModuloAcesso(), "Cadastro de hist\u00f3rios padr\u00f5es");
            }
            p.setSql("select hpa_codigo, hpa_descricao, hpa_permitedescrever from historicopadrao");
            p.removerCampos();
            p.adicionaCampo("hpa_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("hpa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("hpa_permitedescrever", "Permite Descrever", 5, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("historicopadrao"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("historicopadrao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable contaCorrente(Object pai, String tipo, boolean ocultarInativas, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando contas");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Conta.getModuloAcesso(), "Cadastro de contas");
            }
            p.setSql("select cco_reduzido, cco_conta, cco_titular from contacorrente");
            p.removerCampos();
            p.adicionaCampo("cco_reduzido", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("cco_conta", "Conta", 0, "", 2);
            p.adicionaCampo("cco_titular", "Titular", 0, "", 2);
            p.setFiltroInicial("Conta", 2);
            p.setOrdem("Conta");
            StringBuilder bui = new StringBuilder();
            bui.append("fil_codigo = ").append(Variaveis.filialPadrao);
            if (ocultarInativas) {
                bui.append(" and cco_inativa = false ");
            }
            p.setFiltro(bui.toString());
            if (!Funcoes.textoVazio(tipo)) {
                p.addFiltro(" and upper(cco_tipo) = upper('" + tipo + "')");
            }
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("contacorrente"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("contacorrente", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable planoContas(Object pai, String tipo, boolean mostrarCadastro) {
        return Pesquisas.planoContas(pai, tipo, 0, mostrarCadastro);
    }

    public static Hashtable planoContas(Object pai, String tipo, int nivel, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando plano de contas");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(PlanoContas.getModuloAcesso(), "Cadastro de plano de contas");
            }
            p.setSql("select plc_reduzido, plc_conta, plc_descricao from planoconta");
            p.removerCampos();
            p.adicionaCampo("plc_reduzido", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("plc_conta", "Conta", 0, "", 0);
            p.adicionaCampo("plc_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Conta");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            if (!Funcoes.textoVazio(tipo)) {
                p.addFiltro(" and upper(plc_tipo) = upper('" + tipo + "')");
            }
            p.addFiltro(" and plc_nivel >= " + nivel);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("planocontas"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("planocontas", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable agrupaFaturamento(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando agrupamento");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(AgrupaFaturamento.getModuloAcesso(), "Agrupamento Exames/Faturamento");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, ");
            buf.append(" d.con_fantasia, a.mco_codigo, a.con_codigo ");
            buf.append("from agrupaexameconvenio a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Exame", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Mat", 1, "", 3);
            p.adicionaCampo("a.con_codigo", "C\u00f3d.Conv", 1, "", 3);
            p.setFiltroInicial("Exame", 2);
            p.setOrdem("Exame");
            p.setFiltro("a.fil_codigo = " + Variaveis.filialPadrao);
            p.addFiltro(" and a.aec_tipo = 'F'");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("agrupafaturamento"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("agrupafaturamento", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable agrupaRequisicao(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando agrupamento");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(AgrupaRequisicao.getModuloAcesso(), "Agrupamento Exame/Requisi\u00e7\u00e3o");
            }
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, ");
            buf.append(" d.con_fantasia, a.mco_codigo, a.con_codigo ");
            buf.append("from agrupaexameconvenio a ");
            buf.append("left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo = c.mco_codigo ");
            buf.append("left join convenios d on a.fil_codigo = d.fil_codigo and a.con_codigo = d.con_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Exame", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Mat", 1, "", 3);
            p.adicionaCampo("a.con_codigo", "C\u00f3d.Conv", 1, "", 3);
            p.setFiltroInicial("Exame", 2);
            p.setOrdem("Exame");
            p.setFiltro("a.fil_codigo = " + Variaveis.filialPadrao);
            p.addFiltro(" and a.aec_tipo = 'R'");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("agruparequisicao"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("agruparequisicao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable agrupaSituacao(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando agrupamento");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(AgrupaSituacao.getModuloAcesso(), "Agrupamento Exames/Situa\u00e7\u00e3o");
            }
            StringBuilder buf = new StringBuilder("select ");
            buf.append(" d.sit_descricao, e.con_fantasia, a.sit_codigo, a.con_codigo ");
            buf.append("from agrupasituacao a ");
            buf.append("left join situacao d on a.fil_codigo = d.fil_codigo and a.sit_codigo = d.sit_codigo ");
            buf.append("left join convenios e on a.fil_codigo = e.fil_codigo and a.con_codigo = e.con_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("sit_descricao", "Situa\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("a.sit_codigo", "C\u00f3d.Sit", 1, "", 3);
            p.adicionaCampo("a.con_codigo", "C\u00f3d.Conv", 1, "", 3);
            p.setFiltroInicial("Situa\u00e7\u00e3o", 2);
            p.setOrdem("Situa\u00e7\u00e3o");
            p.setFiltro("a.fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("agrupasituacao"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("agrupasituacao", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static void ordemExamePagina(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando ordem de impress\u00e3o");
        if (p != null) {
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, a.emc_pagina, a.emc_ordem ");
            buf.append("from examematcoleta a ");
            buf.append("left join exames b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo=c.mco_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            p.adicionaCampo("emc_pagina", "P\u00e1gina", 1, "", 3);
            p.adicionaCampo("emc_ordem", "Ordem", 1, "", 3);
            p.setFiltroInicial("P\u00e1gina", 3);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            p.setOrdem("P\u00e1gina");
            p.setFiltro(buf.toString());
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("ordemexamepagina"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("ordemexamepagina", p.getPesquisaAvancadaArquivada());
            }
        }
    }

    public static void ordemExameSetor(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames");
        if (p != null) {
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, c.mco_descricao, a.emc_pagina, ");
            buf.append(" a.emc_ordem, e.set_descricao from examematcoleta a ");
            buf.append("left join exames b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo ");
            buf.append("left join materialcoleta c on a.fil_codigo = c.fil_codigo and a.mco_codigo=c.mco_codigo ");
            buf.append("left join examesetor d on a.fil_codigo = d.fil_codigo and a.exa_codigo = d.exa_codigo ");
            buf.append("left join setores e on d.fil_codigo = e.fil_codigo and d.set_codigo = e.set_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mco_descricao", "Material", 0, "", 2);
            p.adicionaCampo("emc_pagina", "P\u00e1gina", 1, "", 3);
            p.adicionaCampo("emc_ordem", "Ordem", 1, "", 3);
            p.adicionaCampo("set_descricao", "Setor", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and d.ese_default = true");
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("ordemexamesetor"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("ordemexamesetor", p.getPesquisaAvancadaArquivada());
            }
        }
    }

    public static Hashtable fatura(Object pai) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando faturas");
        if (p != null) {
            StringBuilder buf = new StringBuilder("select distinct a.fat_codigo, b.con_fantasia, a.fat_dtemis, a.fat_dtvenc, a.fat_qtdeexames, ");
            buf.append("a.fat_totalexames, a.fat_totalmateriais, a.usr_codigo from fatura a ");
            buf.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("left join faturarequisicao c on a.fil_codigo = c.fil_codigo and a.fat_codigo = c.fat_codigo ");
            buf.append("left join requisicao d on c.fil_kodigo = d.fil_codigo and c.req_codigo = d.req_codigo ");
            buf.append("left join paciente e on d.fil_codigo = e.fil_codigo and d.pac_codigo = e.pac_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.fat_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("con_fantasia", "Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("fat_dtemis", "Emiss\u00e3o", 2, "", 3);
            p.adicionaCampo("fat_dtvenc", "Vencimento", 2, "", 3);
            p.adicionaCampo("fat_qtdeexames", "Qtde.Exames", 1, "", 3);
            p.adicionaCampo("fat_totalexames", "Total Exames", 1, "", 3);
            p.adicionaCampo("fat_totalmateriais", "Total Materiais", 1, "", 3);
            p.adicionaCampo("e.pac_nome", "Paciente", 0, "", 2, 1, false, false);
            p.adicionaCampo("a.usr_codigo", "Usu\u00e1rio", 0, "", 2);
            p.setFiltroInicial("Emiss\u00e3o", 3);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.fat_datacancelamento is null ");
            buf.append(" and d.req_excluida = false ");
            p.setFiltro(buf.toString());
            p.setExecutarAoAbrir(false);
            p.setOrdem("Emiss\u00e3o");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("fatura"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("fatura", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable termoConsentimento(Object pai, boolean mostrarCadastro) {
        return Pesquisas.termoConsentimento(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable termoConsentimento(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando termo de consentimento");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(TermoConsentimento.getModuloAcesso(), "Cadastro de Termo de Consentimento");
            }
            p.setSql("select mtc_codigo, mtc_descricao, mtc_inativo from termoconsentimento");
            p.removerCampos();
            p.adicionaCampo("mtc_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("mtc_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("mtc_inativo", "Inativo", 5, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("C\u00f3digo");
            p.setFiltro("fil_codigo = " + filial);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("termoConsentimento"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("termoConsentimento", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable pesquisaLayoutTermoConsentimento(Object pai, boolean mostrarCadastro) {
        return Pesquisas.pesquisaLayoutTermoConsentimento(pai, mostrarCadastro, Variaveis.filialPadrao);
    }

    public static Hashtable pesquisaLayoutTermoConsentimento(Object pai, boolean mostrarCadastro, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando termo de consentimento");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(TermoConsentimento.getModuloAcesso(), "Cadastro de Termo de Consentimento");
            }
            StringBuilder buf = new StringBuilder("SELECT a.mtc_codigo, a.mtc_descricao, b.lay_codigo, b.lay_descricao");
            buf.append(" FROM termoconsentimento a ");
            buf.append(" LEFT JOIN modelotermoconsentimento c ON a.mtc_codigo = c.mtc_codigo and a.fil_codigo = c.fil_codigo ");
            buf.append(" LEFT JOIN layout b ON c.lay_codigo = b.lay_codigo AND a.fil_codigo = b.fil_codigo ");
            buf.append(" WHERE a.mtc_inativo = false ");
            buf.append(" AND a.fil_codigo = ").append(filial);
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.mtc_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("a.mtc_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("b.lay_codigo", "Cod. Modelo", 0, "", 2);
            p.adicionaCampo("b.lay_descricao", "Modelo", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("C\u00f3digo");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("termoConsentimento"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("termoConsentimento", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable loteapoio(Object pai, boolean executarAoAbrir) {
        return Pesquisas.loteapoio(pai, executarAoAbrir, null);
    }

    public static Hashtable loteapoio(Object pai, boolean executarAoAbrir, String codigoApoiado) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando lotes de apoio");
        if (p != null) {
            StringBuilder bui = new StringBuilder("select a.lot_codigo, ");
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                bui.append("c.pac_codigo, c.pac_nome, ");
            } else {
                bui.append("b.con_codigo, b.con_fantasia, ");
            }
            bui.append("a.lot_datahora, a.lot_datahoratriagem ");
            bui.append("from loteapoio a ");
            bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            bui.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            p.setSql(bui.toString());
            p.setExecutarAoAbrir(executarAoAbrir);
            p.removerCampos();
            p.adicionaCampo("a.lot_codigo", "Lote", 1, "", 3);
            if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                p.adicionaCampo("a.pac_codigo", "C\u00f3d. Cliente", 1, "", 3);
                p.adicionaCampo("b.pac_nome", "Nome Cliente", 0, "", 2);
            } else {
                p.adicionaCampo("a.con_codigo", "C\u00f3d. Conv\u00eanio", 1, "", 3);
                p.adicionaCampo("b.con_fantasia", "Nome Conv\u00eanio", 0, "", 2);
            }
            p.adicionaCampo("a.lot_datahora", "Data/Hora", 4, "", 2);
            p.adicionaCampo("a.lot_datahoratriagem", "Data/Hora Recebimento", 4, "", 2);
            p.setFiltroInicial("Conv\u00eanio", 2);
            bui.delete(0, bui.length());
            bui.append("a.fil_codigo = ");
            bui.append(Variaveis.filialPadrao);
            if (!Funcoes.textoVazio(codigoApoiado)) {
                if (Variaveis.tipoFilialPadrao.equalsIgnoreCase("A")) {
                    bui.append(" and a.pac_codigo = ").append(codigoApoiado);
                } else {
                    bui.append(" and a.con_codigo = ").append(codigoApoiado);
                }
            }
            p.setFiltro(bui.toString());
            p.setOrdem("Data/Hora");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("loteapoio"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("loteapoio", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable loteFilial(Object pai, boolean executarAoAbrir) {
        return Pesquisas.loteFilial(pai, executarAoAbrir, null);
    }

    public static Hashtable loteFilial(Object pai, boolean executarAoAbrir, String codigo) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando lotes de filiais");
        if (p != null) {
            StringBuilder bui = new StringBuilder();
            bui.append("select a.fil_codigo, a.lfi_codigo, a.lfi_datahora, b.est_descricao ");
            bui.append("from lotefilial a ");
            bui.append(" left join estacoes b on a.est_codigo = b.est_codigo ");
            p.setSql(bui.toString());
            p.setExecutarAoAbrir(executarAoAbrir);
            p.removerCampos();
            p.adicionaCampo("a.fil_codigo", "Fil.", 1, "", 3);
            p.adicionaCampo("a.lfi_codigo", "Lote", 1, "", 3);
            p.adicionaCampo("a.lfi_datahora", "Data/Hora", 4, "", 3);
            p.adicionaCampo("b.est_descricao", "Esta\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Lote", 3);
            bui.delete(0, bui.length());
            if (!Funcoes.textoVazio(codigo)) {
                bui.append("lfi_codigo = ").append(codigo);
            }
            p.setFiltro(bui.toString());
            p.setOrdem("Fil.");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("lotefilial"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("lotefilial", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable loteApoioAlimentos(Object pai, boolean executarAoAbrir, String codigoApoiado) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando lotes de apoio");
        if (p != null) {
            StringBuilder bui = new StringBuilder("select a.lot_codigo, ");
            bui.append("b.con_codigo, b.con_fantasia, ");
            bui.append("a.lot_datahora ");
            bui.append("from loteapoio a ");
            bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            bui.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
            p.setSql(bui.toString());
            p.setExecutarAoAbrir(executarAoAbrir);
            p.removerCampos();
            p.adicionaCampo("a.lot_codigo", "Lote", 1, "", 3);
            p.adicionaCampo("a.con_codigo", "C\u00f3d. Conv\u00eanio", 1, "", 3);
            p.adicionaCampo("b.con_fantasia", "Nome Conv\u00eanio", 0, "", 2);
            p.adicionaCampo("a.lot_datahora", "Data/Hora", 4, "", 2);
            p.setFiltroInicial("Conv?nio", 2);
            bui.delete(0, bui.length());
            bui.append("a.fil_codigo = ");
            bui.append(Variaveis.filialPadrao);
            if (!Funcoes.textoVazio(codigoApoiado)) {
                bui.append(" and a.con_codigo = ").append(codigoApoiado);
            }
            p.setFiltro(bui.toString());
            p.setOrdem("Data/Hora");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("loteapoio"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("loteapoio", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable exameExternoJalis(Object pai, String codigoLabExterno) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando exames Jalis");
        if (p != null) {
            StringBuilder buf = new StringBuilder("select a.exa_codigo, b.exa_descricao, a.emc_descricaomaterial, b.exa_sinonimo, a.mco_codigo from examematcoletajalis a ");
            buf.append("left join examesjalis b on a.fil_codigo=b.fil_codigo and a.exa_codigo=b.exa_codigo and a.lae_codigo=b.lae_codigo ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("a.exa_codigo", "C\u00f3digo", 0, "", 2);
            p.adicionaCampo("exa_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("emc_descricaomaterial", "Material", 0, "", 2);
            p.adicionaCampo("exa_sinonimo", "Sin\u00f4nimo", 0, "", 2);
            p.adicionaCampo("a.mco_codigo", "C\u00f3d.Material", 1, "", 3);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            buf.delete(0, buf.length());
            buf.append("a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.lae_codigo = ").append(codigoLabExterno);
            p.setFiltro(buf.toString());
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("exameexternojalis"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("exameexternojalis", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable cid10(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando CID-10");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Cid10.getModuloAcesso(), "Cadastro de CID-10");
            }
            p.setSql("select c10_codigo, c10_descricao from cid10");
            p.removerCampos();
            p.adicionaCampo("c10_codigo", "C\u00f3digo", 0, "", 0);
            p.adicionaCampo("c10_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("C\u00f3digo");
            p.setExecutarAoAbrir(false);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("cid10"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("cid10", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable loteExterno(Object pai, String codigoLaboratorio) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando lote externo");
        if (p != null) {
            StringBuilder sql = new StringBuilder();
            sql.append("select distinct a.lex_codigo, a.lex_datahora, b.lae_descricao, a.usr_codcriacao, a.fil_codigo ");
            sql.append("  from loteexterno a ");
            sql.append("       join loteexternorequisicao c on a.fil_codigo = c.fil_codigo and a.lae_codigo = c.lae_codigo and a.lex_codigo = c.lex_codigo ");
            sql.append("  left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo ");
            sql.append("where a.lae_codigo = " + codigoLaboratorio);
            sql.append("  and a.fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append("  and a.lex_dataestorno is null ");
            p.setSql(sql.toString());
            p.removerCampos();
            p.adicionaCampo("lex_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("lex_datahora", "Data/Hora", 4, "", 3);
            p.adicionaCampo("lae_descricao", "Laborat\u00f3rio", 0, "", 2);
            p.adicionaCampo("usr_codcriacao", "Usu\u00e1rio", 0, "", 2);
            p.setFiltroInicial("Laborat\u00f3rio", 2);
            p.setOrdem("Laborat\u00f3rio");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("loteexterno"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("loteexterno", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable especie(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando especie");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Especie.getModuloAcesso(), "Cadastro de especie");
            }
            p.setSql("select epc_codigo, epc_descricao from especie");
            p.removerCampos();
            p.adicionaCampo("epc_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("epc_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("especie"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("especie", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable raca(Object pai, String especie, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando ra\u00e7a");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Especie.getModuloAcesso(), "Cadastro de ra\u00e7a");
            }
            p.setSql("select rac_codigo, rac_descricao from raca");
            p.removerCampos();
            p.adicionaCampo("rac_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("rac_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro("fil_codigo = " + Variaveis.filialPadrao + " and epc_codigo = " + especie);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("raca"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("raca", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    private static int validaCampoPesquisaPaciente(String defineCampoPesquisa) {
        String camposSejaIgual = "C\u00f3digo, Nascimento, RG, CPF, CNPJ";
        if (camposSejaIgual.toString().contains(defineCampoPesquisa)) {
            return 3;
        }
        return 2;
    }

    public static Hashtable responsavelPaciente(Object pai, String filial, String paciente, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando respons\u00e1vel");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Paciente.getModuloAcesso(), "Cadastro de cliente");
            }
            p.setSql("select a.ent_codigo, b.ent_fantasia, b.ent_fone, b.ent_celular, b.ent_cargo, case when upper(b.ent_tipo) = upper('I') then 'Fiscal' else 'Respons\u00e1vel' end as tipoCadastro, b.ent_tipo from pacienteentidade a left join entidade b on a.fil_codigo = b.fil_codigo and a.ent_codigo = b.ent_codigo ");
            p.removerCampos();
            p.adicionaCampo("a.ent_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("ent_fantasia", "Nome", 0, "", 2);
            p.adicionaCampo("ent_fone", "Fone", 0, "", 2);
            p.adicionaCampo("ent_celular", "Celular", 0, "", 2);
            p.adicionaCampo("ent_cargo", "Cargo", 0, "", 2);
            p.adicionaCampo("tipoCadastro", "Tipo", 0, "", 3, 1);
            p.adicionaCampo("ent_tipo", "ipo", 0, "", 3, 3);
            p.setFiltroInicial("Nome", 2);
            p.setOrdem("Nome");
            p.setFiltro("a.pen_responsavel = true and a.fil_codigo = " + filial + " and a.pac_codigo = " + paciente + " and upper(a.pen_tipo) = upper('" + "O" + "')");
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("responsavelpaciente"));
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("responsavelpaciente", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable pagador(Object pai, String filial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando pagador");
        if (p != null) {
            p.setSql(" select a.nomePagador as nomePagador        ,a.cpfPagador as cpfPagador        ,a.nomePaciente as nomePaciente    from (select distinct COALESCE(pac_nomepagador, pac_nome) as nomePagador                         ,COALESCE(pac_cpfpagador, pac_cpf) as cpfPagador                         ,pac_nome as nomePaciente            from paciente           where fil_codigo = " + filial + "            and NOT (NULLIF(pac_nomepagador, '') IS NULL AND NULLIF(pac_nome, '') IS NULL)             and NOT (NULLIF(pac_cpfpagador, '') IS NULL AND NULLIF(pac_cpf, '') IS NULL)) a ");
            p.removerCampos();
            p.adicionaCampo("nomePagador", "Pagador", 0, "", 2);
            p.adicionaCampo("cpfPagador", "CPF", 0, "", 3);
            p.adicionaCampo("nomePaciente", "Paciente", 0, "", 2);
            p.setFiltroInicial("Pagador", 2);
            p.setOrdem("Pagador");
            p.setFiltro(" LENGTH(TRIM(nomePagador)) > 0 ");
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable orcamento(Object pai, boolean mostrarCadastro) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando or\u00e7amentos");
        if (p != null) {
            if (mostrarCadastro) {
                p.setTelaCadastro(Orcamento.getModuloAcesso(), "Or\u00e7amentos");
            }
            StringBuilder buf = new StringBuilder();
            buf.append(" select o.orc_codigo ");
            buf.append("       ,o.orc_datahora ");
            buf.append("       ,o.orc_solicitante ");
            if (Variaveis.tipoFilialPadrao.equals("C")) {
                buf.append("       ,p.pac_cpf");
                buf.append("       ,p.pac_datanasc");
                buf.append("       ,m.med_nome");
            }
            buf.append("       ,o.usr_codigo ");
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                buf.append("       ,pegacodigoexameorcamento(o.fil_codigo, o.orc_codigo) ");
                buf.append("       ,pegadescricaoexameorcamento(o.fil_codigo, o.orc_codigo) ");
            }
            buf.append("   from orcamento o");
            buf.append("   left join medico m");
            buf.append("   on");
            buf.append("   o.fil_codigo = m.fil_codigo");
            buf.append("   and o.med_conselho = m.med_conselho");
            buf.append("   and o.med_crm = m.med_crm");
            buf.append("   and o.med_uf = m.med_uf");
            buf.append("   left join paciente p");
            buf.append("   on");
            buf.append("   o.fil_codigo = p.fil_codigo");
            buf.append("   and o.pac_codigo = p.pac_codigo");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("o.orc_codigo", "C\u00f3digo", 1, "", 3);
            p.adicionaCampo("o.orc_datahora", "Data/Hora", 4, "", 3);
            p.adicionaCampo("o.orc_solicitante", Variaveis.tipoFilialPadrao.equals("V") ? "Animal" : "Solicitante", 0, "", 2);
            if (Variaveis.tipoFilialPadrao.equals("C")) {
                p.adicionaCampo("p.pac_cpf", "CPF", 0, "###.###.###-##", 3);
                p.adicionaCampo("p.pac_datanasc", "Nascimento", 2, "", 3);
                p.adicionaCampo("m.med_nome", "M\u00e9dico", 0, "", 2);
            }
            p.adicionaCampo("o.usr_codigo", "Usu\u00e1rio", 0, "", 2);
            if (Variaveis.tipoFilialPadrao.equals("A")) {
                p.adicionaCampo("pegacodigoexameorcamento(o.fil_codigo, o.orc_codigo)", "C\u00f3digo Exames", 0, "", 2);
                p.adicionaCampo("pegadescricaoexameorcamento(o.fil_codigo, o.orc_codigo)", "Descri\u00e7\u00e3o Exames", 0, "", 2);
                p.setFiltroInicial("Solicitante", 2);
            } else {
                p.setFiltroInicial("C\u00f3digo", 3);
            }
            p.setOrdem("C\u00f3digo");
            p.setFiltro(" o.fil_codigo = " + Variaveis.filialPadrao);
            p.setPesquisaAvancadaArquivada(Pesquisas.validaPesquisaAnterior("orcamento"));
            p.setExecutarAoAbrir(false);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                Pesquisas.gravaPesquisaAnterior("orcamento", p.getPesquisaAvancadaArquivada());
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }

    public static Hashtable metodologiasExameMaterial(Object pai, String codigoExame, Integer codigoMaterial) {
        FrmPesquisa p = FrmPesquisa.novaInstancia(pai, "Pesquisando metodologias do exame");
        if (p != null) {
            StringBuilder buf = new StringBuilder();
            buf.append(" select lay.lay_codigo ");
            buf.append("       ,lay.lay_descricao ");
            buf.append("       ,met.met_codigo ");
            buf.append("       ,met.met_descricao ");
            buf.append("       ,ela.ela_idadeini ");
            buf.append("       ,ela.ela_idadeinitipo ");
            buf.append("       ,ela.ela_idadefim ");
            buf.append("       ,ela.ela_idadefimtipo ");
            buf.append("   from examelayoutmetodo ela ");
            buf.append("   join metodologia met on ela.fil_codigo = met.fil_codigo and ela.met_codigo = met.met_codigo ");
            buf.append("   join layout lay on ela.fil_codigo = lay.fil_codigo and ela.lay_codigo = lay.lay_codigo  ");
            p.setSql(buf.toString());
            p.removerCampos();
            p.adicionaCampo("lay_codigo", "Layout", 1, "", 3);
            p.adicionaCampo("lay_descricao", "Descri\u00e7\u00e3o Layout", 0, "", 2);
            p.adicionaCampo("met_codigo", "Metodologia", 1, "", 3);
            p.adicionaCampo("met_descricao", "Descri\u00e7\u00e3o", 0, "", 2);
            p.adicionaCampo("ela_idadeini", "Idade Inicial", 1, "", 0);
            p.adicionaCampo("ela_idadefim", "Idade Final", 1, "", 1);
            p.setFiltroInicial("Descri\u00e7\u00e3o", 2);
            p.setOrdem("Descri\u00e7\u00e3o");
            p.setFiltro(" ela.fil_codigo = " + Variaveis.filialPadrao + " and ela.exa_codigo = upper('" + codigoExame + "') and ela.mco_codigo = " + codigoMaterial);
            p.setVisible(true);
            if (p.selecionouRegistro()) {
                return p.getRegistroSelecionado();
            }
        }
        return null;
    }
}

