/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Acesso;
import jalis.comum.AgendarCompromisso;
import jalis.comum.ButtonToolBar;
import jalis.comum.Conexao;
import jalis.comum.JLabelDataAgenda;
import jalis.comum.ObjetoMensagem;
import jalis.comum.PanelAgenda;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosUsuarios;
import jalis.comum.RenderMensagens;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.MenuSistema;
import jalis.mensagens.IAvisaMensagens;
import jalis.mensagens.LerMensagem;
import jalis.mensagens.NovaMensagem;
import jalis.mensagens.VerificaMensagens;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ListenerMostraCalendario;
import jalis.util.MostraCalendario;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.menu.ItemMenu;
import jalis.util.menu.LabExternoConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.codec.binary.Base64;

public class PanelUsuario
extends JPanel
implements ActionListener,
IAvisaMensagens {
    private String usuario;
    private String ultimaData = "";
    private String ultimaHora = "";
    private String nomeUsuario = "";
    private ImageIcon fotoUsuario;
    JPanel painelTopo;
    JPanel painelTopoCentro;
    JPanel panelCentro = new JPanel(new BorderLayout());
    JToolBar toolBar = new JToolBar();
    JPopupMenu popMenu = new JPopupMenu();
    JMenuItem itemRemover = new JMenuItem("Ocultar barra de atalhos");
    JPopupMenu popMenuRemoveBotao = new JPopupMenu();
    JMenuItem itemRemoverBotao = new JMenuItem("Remover bot\u00e3o");
    JPanel panelInfo = new JPanel(new GridBagLayout());
    JPanel panelMensagens = new JPanel(new GridBagLayout());
    PanelAgenda panelAgenda = new PanelAgenda(Laboratorio.getThreadCompromisso());
    JLabelDataAgenda labelData = new JLabelDataAgenda(new Date());
    DefaultListModel modelMensagens = new DefaultListModel();
    JList listMensagens = new JList(this.modelMensagens);
    RenderMensagens renderMensagens = new RenderMensagens();
    TitledBorder bordaMensagens = new TitledBorder("Mensagens");
    JLabel labelMensagens = new JLabel("N\u00e3o h\u00e1 novas mensagens");
    JScrollPane scrollMensagens = new JScrollPane(this.listMensagens);
    JButton buttonLer = ComponenteFactory.novoJButton("Ler", 'L', this, null, null, false);
    JButton buttonNova = ComponenteFactory.novoJButton("Nova", 'N', this, null, null, true);
    JButton buttonExcluir = ComponenteFactory.novoJButton("Excluir", 'E', this, null, null, false);
    JLabel labelAtualizar = new JLabel(ImagemUtils.carregaImagemJalis("refresh.png"));
    JCheckBox checkNaoMostrar = ComponenteFactory.novoJCheckBox("Ocultar enviadas por mim", 'm', this);

    public PanelUsuario(String usuario, VerificaMensagens verifica) {
        try {
            this.usuario = usuario;
            this.jbInit();
            this.checkToolBar();
            if (verifica != null) {
                verifica.removeAllAvisaMensagem();
                verifica.addAvisaMensagem(this);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "PanelUsuario");
        }
    }

    public void jbInit() throws Exception {
        Statement st;
        ResultSet rs;
        this.setName("PanelUsuario");
        this.setLayout(new BorderLayout());
        this.listMensagens.setCellRenderer(this.renderMensagens);
        this.add((Component)this.panelCentro, "Center");
        if (ParametrosGerais.getCodigoCliente() == 0L) {
            final JPanel p = new JPanel(null);
            final JLabel l = new JLabel("Banco de dados de instala\u00e7\u00e3o - Lode - We Love Code");
            l.setForeground(Color.WHITE);
            p.setBackground(Color.RED);
            p.setForeground(Color.WHITE);
            p.setPreferredSize(new Dimension(100, 20));
            l.setBounds(10, 3, 320, 15);
            p.add(l);
            this.add((Component)p, "South");
            new Thread(){

                @Override
                public void run() {
                    int x = p.getWidth();
                    while (true) {
                        l.setBounds(x--, 3, 320, 15);
                        try {
                            1.sleep(10L);
                            l.revalidate();
                            l.repaint();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (x > -320) continue;
                        x = p.getWidth();
                    }
                }
            }.start();
        }
        if ((rs = Conexao.executeQuery(st = Conexao.getStatement(), "select usr_lastdtlogin, usr_lasttimelogin, usr_nome, usr_foto from usuario where upper(usr_codigo)=upper('" + StringUtil.textoDB(this.usuario) + "')")) != null && rs.next()) {
            this.ultimaData = Funcoes.formataData(rs.getDate("usr_lastdtlogin"));
            this.ultimaHora = Funcoes.formataHora(rs.getTime("usr_lasttimelogin"), false);
            this.nomeUsuario = rs.getString("usr_nome");
            if (rs.getString("usr_foto") != null && !Funcoes.textoVazio(rs.getString("usr_foto"))) {
                if (this.fotoUsuario != null) {
                    this.fotoUsuario = null;
                }
                String foto64 = rs.getString("usr_foto");
                try {
                    this.fotoUsuario = new ImageIcon(new Base64().decode(foto64));
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "PanelUsuario");
                }
            } else {
                this.fotoUsuario = null;
            }
        }
        if (rs != null) {
            rs.close();
        }
        st.close();
        Funcoes.criaBarraDescricao(this, this.nomeUsuario, "\u00daltimo acesso em " + this.ultimaData + " \u00e0s " + this.ultimaHora, "configuracoes/cad_usuario.jpg");
        this.panelCentro.add((Component)this.toolBar, "First");
        this.panelCentro.add((Component)this.panelInfo, "Center");
        this.toolBar.setName("toolBar");
        this.toolBar.setPreferredSize(new Dimension(100, 80));
        this.toolBar.setBackground(Color.WHITE);
        this.toolBar.setFloatable(false);
        this.popMenu.add(this.itemRemover);
        this.toolBar.setComponentPopupMenu(this.popMenu);
        this.itemRemover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelUsuario.this.toolBar.setVisible(false);
                ParametrosUsuarios.setValor("toolBar", PanelUsuario.this.getToolBarConfig());
            }
        });
        this.montaPanelInfo();
        this.buscaMensagens();
    }

    private void montaPanelInfo() {
        this.panelMensagens.setName("panelMensagens");
        this.panelMensagens.setBorder(this.bordaMensagens);
        this.panelMensagens.setPreferredSize(new Dimension(190, 100));
        this.panelMensagens.setMaximumSize(new Dimension(190, 100));
        this.panelMensagens.setMinimumSize(new Dimension(300, 100));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        final JScrollPane scroll = new JScrollPane(this.panelAgenda);
        JPanel panelTemp = new JPanel(new BorderLayout());
        JButton buttonNovoCompromisso = ComponenteFactory.novoJButton("Novo", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AgendarCompromisso agendar = AgendarCompromisso.novaInstancia(Laboratorio.getInstancia(), true, PanelUsuario.this.panelAgenda.getCompromissos(), null, true);
                if (agendar != null) {
                    agendar.setVisible(true);
                    if (agendar.getOK()) {
                        PanelUsuario.this.atualizarCompromissos(agendar.getDataNovoCompromisso());
                    }
                }
            }
        });
        buttonNovoCompromisso.setName("buttonNovoCompromisso");
        buttonNovoCompromisso.setFocusable(false);
        this.labelData.setCursor(Cursor.getPredefinedCursor(12));
        this.labelData.setName("labelData");
        this.labelData.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JPopupMenu menu = new JPopupMenu();
                String data = ((JLabel)e.getSource()).getText();
                MostraCalendario calendario = new MostraCalendario(null, Funcoes.verificaData(data) ? data : Funcoes.formataData(new Date()), menu);
                calendario.setName("calendario");
                calendario.addListener(new ListenerMostraCalendario(){

                    @Override
                    public void dataSelecionada(Date data) {
                        if (data != null) {
                            PanelUsuario.this.labelData.setData(data);
                            PanelUsuario.this.panelAgenda.atualizarCompromissos(data);
                            PanelUsuario.this.panelAgenda.posicionarHoraAtual(scroll);
                        }
                    }
                });
                menu.add(calendario);
                calendario.setDate(Funcoes.verificaData(data) ? data : Funcoes.formataData(new Date()));
                menu.show(((JLabel)e.getSource()).getParent(), e.getX(), e.getY());
            }
        });
        panelTemp.add((Component)ComponenteFactory.novoJPanelFlowLayout(1, this.labelData), "North");
        panelTemp.add((Component)scroll, "Center");
        panelTemp.add((Component)ComponenteFactory.novoJPanelFlowLayout(2, buttonNovoCompromisso), "South");
        panelTemp.setBorder(new TitledBorder("Compromissos"));
        this.panelInfo.add((Component)panelTemp, c);
        c.gridx = 1;
        this.panelInfo.add((Component)this.panelMensagens, c);
        this.montaPanelMensagens();
        this.panelAgenda.posicionarHoraAtual(scroll);
        String p = ParametrosUsuarios.getValor("mensagens");
        this.checkNaoMostrar.setFocusable(false);
        this.checkNaoMostrar.setSelected(!Funcoes.textoVazio(StringUtil.getValor(p, "ocultarMinhasMensagens")) && StringUtil.getValor(p, "ocultarMinhasMensagens").equals("1"));
    }

    public void atualizarCompromissos(final Date novoCompromisso) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelUsuario.this.panelAgenda.atualizarCompromissos(novoCompromisso);
            }
        });
    }

    private void montaPanelMensagens() {
        this.listMensagens.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PanelUsuario.this.buttonExcluir.setEnabled(PanelUsuario.this.listMensagens.getSelectedIndex() > -1);
                PanelUsuario.this.buttonLer.setEnabled(PanelUsuario.this.listMensagens.getSelectedIndex() > -1);
            }
        });
        this.listMensagens.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PanelUsuario.this.listMensagens.getSelectedIndex() > -1) {
                    PanelUsuario.this.lerMensagem();
                }
            }
        });
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(3, 0, 3, 2);
        this.labelMensagens.setHorizontalAlignment(0);
        this.panelMensagens.add((Component)this.labelMensagens, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 0);
        this.panelMensagens.add((Component)this.scrollMensagens, c);
        c.weighty = 0.0;
        c.fill = 2;
        ++c.gridy;
        JPanel p = new JPanel(new FlowLayout(2, 5, 3));
        p.add(this.buttonLer);
        p.add(this.buttonNova);
        p.add(this.labelAtualizar);
        this.buttonLer.setFocusable(false);
        this.buttonNova.setFocusable(false);
        JPanel p2 = ComponenteFactory.novoJPanelBorderLayout(p, null, null, null, ComponenteFactory.novoJPanelFlowLayout(3, this.checkNaoMostrar));
        this.panelMensagens.add((Component)p2, c);
        this.labelAtualizar.setCursor(Cursor.getPredefinedCursor(12));
        this.labelAtualizar.setToolTipText("Atualizar as mensagens recebidas");
        this.labelAtualizar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PanelUsuario.this.buscaMensagens();
            }
        });
    }

    public String getToolBarConfig() {
        Component[] comp;
        StringBuilder buf = new StringBuilder("<toolbar>");
        buf.append("<visible>");
        buf.append(this.toolBar.isVisible() ? "true" : "false");
        buf.append("</visible>");
        buf.append("<botoes>");
        for (Component c : comp = this.toolBar.getComponents()) {
            if (!(c instanceof ButtonToolBar)) continue;
            ButtonToolBar bb = (ButtonToolBar)c;
            buf.append("<botao>");
            buf.append("<acesso>").append(bb.getAcesso()).append("</acesso>");
            if (bb.getConstraints() != null) {
                buf.append("<constraint>").append("<tipo>").append(bb.getConstraints().getClass().getName()).append("</tipo>").append("<codigo>").append(((LabExternoConstraints)bb.getConstraints()).getCodigo()).append("</codigo>").append("<protocolo>").append(((LabExternoConstraints)bb.getConstraints()).getProtocolo().getCodigo()).append("</protocolo>").append("</constraint>");
            }
            buf.append("</botao>");
        }
        buf.append("</botoes><\toolbar>");
        return buf.toString();
    }

    public void adicionarToolButton(final ItemMenu item) {
        if (!this.toolBar.isVisible()) {
            this.toolBar.setVisible(true);
        }
        if (!Acesso.getAcesso(item.getCodigoAcesso())) {
            return;
        }
        Component[] comp = this.toolBar.getComponents();
        for (int i = 0; i < comp.length; ++i) {
            Component c = comp[i];
            if (!(c instanceof ButtonToolBar) || ((ButtonToolBar)c).getAcesso() != item.getCodigoAcesso()) continue;
            if (item.getConstraint(LabExternoConstraints.class) != null) {
                if (!(((ButtonToolBar)c).getConstraints() instanceof LabExternoConstraints) || ((LabExternoConstraints)((ButtonToolBar)c).getConstraints()).getCodigo() != item.getConstraint(LabExternoConstraints.class).getCodigo() || !((LabExternoConstraints)((ButtonToolBar)c).getConstraints()).getProtocolo().getCodigo().equals(item.getConstraint(LabExternoConstraints.class).getProtocolo().getCodigo())) continue;
                return;
            }
            return;
        }
        final ButtonToolBar button = new ButtonToolBar();
        if (item.getConstraint(LabExternoConstraints.class) != null) {
            button.setConstraints(item.getConstraint(LabExternoConstraints.class));
        }
        button.setName(String.valueOf(item.getCodigoAcesso()));
        button.setHorizontalTextPosition(11);
        button.setIcon(item.getImagem());
        button.setPreferredSize(new Dimension(75, 75));
        button.setBackground(this.toolBar.getBackground());
        button.setToolTipText(item.getTexto());
        button.setAcesso(item.getCodigoAcesso());
        button.setComponentPopupMenu(new JPopupMenu());
        button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                button.getCursor();
                button.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                button.getCursor();
                button.setCursor(Cursor.getDefaultCursor());
            }
        });
        JMenuItem pop = new JMenuItem("Remover bot\u00e3o");
        pop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelUsuario.this.toolBar.remove(button);
                ParametrosUsuarios.setValor("toolBar", PanelUsuario.this.getToolBarConfig());
                PanelUsuario.this.toolBar.revalidate();
                PanelUsuario.this.toolBar.repaint();
            }
        });
        button.getComponentPopupMenu().add(pop);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuSistema.executarMenu(item, false);
            }
        });
        this.toolBar.add(button);
        ParametrosUsuarios.setValor("toolBar", this.getToolBarConfig());
    }

    private void checkToolBar() {
        String[] itens;
        String parametro = ParametrosUsuarios.getValor("toolBar");
        boolean visible = StringUtil.getValor(parametro, "visible") != null && StringUtil.getValor(parametro, "visible").equalsIgnoreCase("true");
        this.toolBar.setVisible(visible);
        for (String s : itens = StringUtil.getValores(parametro, "botao")) {
            ItemMenu item = null;
            if (s.indexOf("<acesso>") > -1) {
                String constraint = StringUtil.getValor(s, "constraint");
                String protocolo = null;
                String codigo = null;
                if (constraint != null && !Funcoes.textoVazio(constraint)) {
                    codigo = StringUtil.getValor(constraint, "codigo");
                }
                if (constraint != null && !Funcoes.textoVazio(constraint)) {
                    protocolo = StringUtil.getValor(constraint, "protocolo");
                }
                item = protocolo != null && !Funcoes.textoVazio(protocolo) ? MenuSistema.getItemMenu(Long.parseLong(StringUtil.getValor(s, "acesso")), protocolo, codigo) : MenuSistema.getItemMenu(Long.parseLong(StringUtil.getValor(s, "acesso")));
            } else {
                item = MenuSistema.getItemMenu(Long.parseLong(s));
            }
            if (item == null) continue;
            this.adicionarToolButton(item);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonNova) {
            this.novaMensagem();
        } else if (e.getSource() == this.buttonLer) {
            this.lerMensagem();
        } else if (e.getSource() == this.buttonExcluir) {
            this.excluirMensagem();
        } else if (e.getSource() == this.checkNaoMostrar) {
            this.gravarNaoMostrar();
            this.buscaMensagens();
        }
    }

    private void gravarNaoMostrar() {
        ParametrosUsuarios.setValor("mensagens", "<ocultarMinhasMensagens>" + (this.checkNaoMostrar.isSelected() ? "1" : "0") + "</ocultarMinhasMensagens>");
    }

    private void novaMensagem() {
        NovaMensagem nova = new NovaMensagem((JFrame)this.getTopLevelAncestor());
        nova.setVisible(true);
    }

    private void excluirMensagem() {
        if (this.listMensagens.getSelectedIndex() > -1 && Funcoes.mensagem(this, "Deseja excluir o registro selecionado?", 4) == 0) {
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("delete from usuariomensagem where usr_coddestino = '");
            buf.append(Variaveis.login);
            buf.append("' and ume_codigo = ");
            ObjetoMensagem obj = (ObjetoMensagem)this.listMensagens.getSelectedValue();
            buf.append(obj.getCodigo());
            try {
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
                this.buscaMensagens();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelUsuario (343)");
            }
        }
    }

    private void lerMensagem() {
        if (this.listMensagens.getSelectedIndex() > -1) {
            LerMensagem ler = new LerMensagem((JFrame)this.getTopLevelAncestor());
            ler.setCodigoMensagem(((ObjetoMensagem)this.listMensagens.getSelectedValue()).getCodigo());
            ler.setVisible(true);
            this.buscaMensagens();
        }
    }

    @Override
    public void novaMensagemRecebida() {
        this.buscaMensagens();
    }

    private void buscaMensagens() {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select usr_codorigem, ume_assunto, ume_datahora, ume_codigo, ume_confirmarleitura, ume_tipo ");
        buf.append("from usuariomensagem where usr_coddestino = '");
        buf.append(Variaveis.login);
        buf.append("' and (ume_situacao is null or ume_situacao = '')");
        if (this.checkNaoMostrar.isSelected()) {
            buf.append(" and usr_coddestino <> usr_codorigem ");
        }
        buf.append(" order by ume_datahora desc limit 100 ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            int posicaoAtual = this.listMensagens.getSelectedIndex();
            this.modelMensagens.clear();
            while (rs.next()) {
                this.modelMensagens.addElement(new ObjetoMensagem(rs.getInt("ume_codigo"), rs.getString("usr_codorigem"), rs.getString("ume_assunto"), rs.getTimestamp("ume_datahora"), rs.getBoolean("ume_confirmarleitura"), rs.getString("ume_tipo")));
            }
            if (this.modelMensagens.size() > 0) {
                this.bordaMensagens.setTitle("Novas mensagens (" + this.modelMensagens.getSize() + ")");
            } else {
                this.bordaMensagens.setTitle("Novas mensagens");
            }
            this.panelMensagens.revalidate();
            this.panelMensagens.repaint();
            if (posicaoAtual > -1 && this.modelMensagens.getSize() > posicaoAtual) {
                this.listMensagens.setSelectedIndex(posicaoAtual);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelUsuario (318)");
        }
    }
}

