/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.AgendarCompromisso;
import jalis.comum.Compromisso;
import jalis.comum.Conexao;
import jalis.comum.ConstantesGerais;
import jalis.comum.PopupCompromisso;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.ThreadCompromisso;
import jalis.mensagens.IAvisaMensagens;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import sun.swing.SwingUtilities2;

class PanelAgenda
extends JPanel
implements ActionListener,
IAvisaMensagens {
    private final Color COR_CREME = ScreenUtil.clarearCor(ConstantesGerais.COR_FUNDO_CREME, 50);
    private final int TAMANHO_POR_HORA = 60;
    private final int TAMANHO_POR_MINUTO = 1;
    private final int[] HORAS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private PopupCompromisso menu = new PopupCompromisso();
    private JMenuItem itemAlterar = ComponenteFactory.novoJMenuItem(this.menu, "Alterar", (ActionListener)this);
    private JMenuItem itemRemover = ComponenteFactory.novoJMenuItem(this.menu, "Remover", (ActionListener)this);
    private JMenuItem itemEncerrar = ComponenteFactory.novoJMenuItem(this.menu, "Encerrar", (ActionListener)this);
    private JMenuItem itemVisualizar = ComponenteFactory.novoJMenuItem(this.menu, "Visualizar", (ActionListener)this);
    private ArrayList<Compromisso> compromissos = new ArrayList();

    public PanelAgenda(ThreadCompromisso thread) {
        this.setPreferredSize(new Dimension(100, this.HORAS.length * 60 + 10));
        this.itemAlterar.setVisible(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                Point p = e.getPoint();
                Rectangle[] itens = PanelAgenda.this.getRetangulos(PanelAgenda.this.compromissos);
                if (itens != null) {
                    int indice = -1;
                    indice = ScreenUtil.indiceRetanguloContemPonto(itens, p);
                    if (indice > -1) {
                        Compromisso compromisso = (Compromisso)PanelAgenda.this.compromissos.get(indice);
                        PanelAgenda.this.setCursor(Cursor.getPredefinedCursor(12));
                    } else if (PanelAgenda.this.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                        PanelAgenda.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int indice;
                Point p = e.getPoint();
                Rectangle[] itens = PanelAgenda.this.getRetangulos(PanelAgenda.this.compromissos);
                if (itens != null && (indice = ScreenUtil.indiceRetanguloContemPonto(itens, p)) > -1) {
                    String usuarioCriador;
                    Compromisso comp = (Compromisso)PanelAgenda.this.compromissos.get(indice);
                    PanelAgenda.this.menu.setCompromisso(comp);
                    PanelAgenda.this.itemAlterar.setVisible(comp.getEncerramento() == null);
                    PanelAgenda.this.itemVisualizar.setVisible(false);
                    PanelAgenda.this.itemRemover.setVisible(true);
                    String string = usuarioCriador = Funcoes.textoVazio(String.valueOf(comp.getCodigoPai())) || comp.getCodigoPai() <= 0 ? comp.getUsuario() : PanelAgenda.this.buscarCriador(comp.getCodigoPai());
                    if (usuarioCriador != null && !usuarioCriador.equals(Variaveis.login)) {
                        PanelAgenda.this.itemAlterar.setVisible(false);
                        PanelAgenda.this.itemRemover.setVisible(false);
                        PanelAgenda.this.itemVisualizar.setVisible(true);
                    }
                    PanelAgenda.this.itemEncerrar.setVisible(comp.getEncerramento() == null);
                    PanelAgenda.this.menu.show(PanelAgenda.this, e.getX(), e.getY());
                }
            }
        });
        if (thread != null) {
            thread.removeAllAvisaMensagem();
            thread.addAvisaMensagem(this);
        }
        this.atualizarCompromissos(new Date());
    }

    private String buscarCriador(int codigoPai) {
        StringBuilder buf = new StringBuilder();
        buf.append("select usr_codigo from usuariocompromisso");
        buf.append(" where uco_codigo = '");
        buf.append(codigoPai);
        buf.append("'");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("usr_codigo");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarCompromissos(Date data) {
        StringBuilder buf = new StringBuilder();
        buf.append("select uco_codigo, uco_datahora, uco_duracao, uco_titulo, uco_tempolembrete, uco_lembrado, uco_encerramento, uco_assunto, usr_codigo, uco_codigopai from usuariocompromisso ");
        buf.append(" where usr_codigo = '").append(StringUtil.textoDB(Variaveis.login)).append("' ");
        buf.append(" and cast(uco_datahora as date) = '").append(Funcoes.formataData("MM/dd/yyyy", data == null ? new Date() : data)).append("' ");
        buf.append(" order by uco_datahora ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            Laboratorio.getInstancia();
            Laboratorio.getThreadCompromisso().limparHorarioLembrete();
            this.compromissos.clear();
            while (rs.next()) {
                Compromisso compromisso = new Compromisso();
                compromisso.setCodigo(rs.getInt("uco_codigo"));
                compromisso.setDataHora(rs.getTimestamp("uco_datahora"));
                compromisso.setDuracao(rs.getInt("uco_duracao"));
                compromisso.setTitulo(rs.getString("uco_titulo"));
                compromisso.setAssunto(rs.getString("uco_assunto"));
                compromisso.setTempoLembrete(rs.getInt("uco_tempolembrete"));
                compromisso.setLembrado(rs.getBoolean("uco_lembrado"));
                compromisso.setUsuario(rs.getString("usr_codigo"));
                compromisso.setCodigoPai(rs.getInt("uco_codigopai"));
                if (rs.getTimestamp("uco_encerramento") != null) {
                    compromisso.setEncerramento(rs.getTimestamp("uco_encerramento"));
                }
                this.compromissos.add(compromisso);
                if (compromisso.isLembrado() || compromisso.getEncerramento() != null) continue;
                Calendar c = Calendar.getInstance();
                c.setTime(compromisso.getDataHora());
                c.add(12, compromisso.getTempoLembrete() * -1);
                Laboratorio.getInstancia();
                Laboratorio.getThreadCompromisso().adicionaHorarioLembrete(c.getTime(), compromisso.getTitulo(), compromisso.getCodigo());
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelUsuario: 652");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(this.COR_CREME);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        for (int hora : this.HORAS) {
            g2.setColor(Color.BLACK);
            Font f = this.getFont().deriveFont(0, 9.0f);
            g2.setFont(f);
            int posX = 2;
            int posY = this.calculaPosicaoHora(hora);
            g2.setColor(ScreenUtil.clarearCor(Color.BLACK, 200));
            g2.drawLine(0, posY - 10, this.getWidth(), posY - 10);
            g2.setColor(Color.BLACK);
            g2.drawString(Funcoes.formataDecimal("00", hora) + ":00", posX, posY);
            int posicaoX = 35;
            Date dataCompromisso = null;
            int duracao = 0;
            int quantidade = 0;
            int contadorAnterior = 0;
            ArrayList<Compromisso> compromissos = new ArrayList<Compromisso>(this.compromissos);
            for (Compromisso c : compromissos) {
                if (dataCompromisso != null && (Funcoes.retornaHora(c.getDataHora()) != Funcoes.retornaHora(dataCompromisso) || Funcoes.retornaMinutos(c.getDataHora()) != Funcoes.retornaMinutos(dataCompromisso))) {
                    contadorAnterior = 0;
                }
                contadorAnterior = quantidade = this.compromissosPorPeriodo(c, contadorAnterior);
                if (dataCompromisso != null) {
                    posicaoX = this.calculaPosicaoX(posicaoX, duracao, dataCompromisso, c);
                }
                this.desenhaCompromisso(g2, c, posicaoX, quantidade);
                posicaoX += 2 + (this.getWidth() - 40) / quantidade;
                dataCompromisso = c.getDataHora();
                duracao = c.getDuracao();
            }
        }
    }

    private int compromissosPorPeriodo(Compromisso c, int contadorAnterior) {
        int contador = 1;
        int horaAtual = Funcoes.retornaHora(c.getDataHora());
        int minutoAtual = Funcoes.retornaMinutos(c.getDataHora());
        ArrayList<Compromisso> compromissos = new ArrayList<Compromisso>(this.compromissos);
        for (Compromisso comp : compromissos) {
            int horaCompromisso = Funcoes.retornaHora(comp.getDataHora());
            int minutoCompromisso = Funcoes.retornaMinutos(comp.getDataHora());
            if (c.getCodigo() == comp.getCodigo() || horaCompromisso != horaAtual || minutoAtual != minutoCompromisso && (minutoAtual >= comp.getDuracao() || minutoCompromisso >= c.getDuracao())) continue;
            ++contador;
        }
        return contadorAnterior > 0 && contador != contadorAnterior ? contadorAnterior : contador;
    }

    private int calculaPosicaoX(int posicaoX, int duracaoAnterior, Date dataAnterior, Compromisso c) {
        int duracaoAtual = c.getDuracao();
        Date dataAtual = c.getDataHora();
        int minutoAtual = Funcoes.retornaMinutos(dataAtual);
        int horaAtual = Funcoes.retornaHora(dataAtual);
        int minutoAnterior = Funcoes.retornaMinutos(dataAnterior);
        int horaAnterior = Funcoes.retornaHora(dataAnterior);
        int diferencaAtual = duracaoAtual + minutoAtual;
        int diferencaAnterior = duracaoAnterior + minutoAnterior;
        if (horaAtual == horaAnterior && (minutoAtual == minutoAnterior || duracaoAnterior > minutoAtual)) {
            return posicaoX;
        }
        return 35;
    }

    private Rectangle[] getRetangulos(ArrayList<Compromisso> compromissos) {
        ArrayList<Rectangle> recs = new ArrayList<Rectangle>();
        for (Compromisso c : compromissos) {
            recs.add(c.getRetanguloPosicao());
        }
        return recs.toArray(new Rectangle[recs.size()]);
    }

    private void desenhaCompromisso(Graphics2D graphic, Compromisso compromisso, int posX, int quantidade) {
        Calendar c = Calendar.getInstance();
        c.setTime(compromisso.getDataHora());
        int hora = c.get(11);
        int minuto = c.get(12);
        int posY = this.calculaPosicaoHora(hora) + minuto * 1 - 10;
        int alturaCompromisso = compromisso.getDuracao() * 1;
        int larguraCompromisso = (this.getWidth() - 40) / quantidade;
        compromisso.setRetanguloPosicao(new Rectangle(posX, posY, larguraCompromisso, alturaCompromisso));
        Color corFundo = Color.BLUE;
        if (compromisso.getEncerramento() != null) {
            corFundo = Color.GRAY;
        } else if (compromisso.getDataHora().compareTo(new Date()) < 0) {
            corFundo = Color.RED;
        }
        graphic.setColor(corFundo);
        graphic.drawRoundRect(posX, posY, larguraCompromisso, alturaCompromisso, 2, 2);
        graphic.setColor(ScreenUtil.clarearCor(corFundo, 100));
        graphic.fillRoundRect(posX, posY, larguraCompromisso, alturaCompromisso, 2, 2);
        graphic.setColor(Color.WHITE);
        graphic.setFont(this.getFont().deriveFont(0, 9.0f));
        String titulo = Funcoes.formataDecimal("00", minuto) + ":" + compromisso.getTitulo();
        if (SwingUtilities.computeStringWidth(SwingUtilities2.getFontMetrics((JComponent)this, graphic.getFont()), titulo) > larguraCompromisso) {
            titulo = SwingUtilities2.clipStringIfNecessary(this, SwingUtilities2.getFontMetrics((JComponent)this, graphic.getFont()), titulo, larguraCompromisso);
        }
        graphic.drawString(titulo, posX, posY + 8);
    }

    private int calculaPosicaoHora(int hora) {
        return 10 + 60 * hora;
    }

    public void adicionaCompromisso(Compromisso compromisso) {
        this.compromissos.add(compromisso);
    }

    public void posicionarHoraAtual(JScrollPane scroll) {
        Calendar c = Calendar.getInstance();
        int hora = c.get(11);
        int posicao = this.calculaPosicaoHora(hora);
        this.scrollRectToVisible(new Rectangle(0, posicao - 30, 60, posicao));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.itemEncerrar) {
            this.encerrarCompromisso(this.menu.getCompromisso());
        } else if (e.getSource() == this.itemRemover) {
            this.excluirCompromisso(this.menu.getCompromisso());
        } else if (e.getSource() == this.itemAlterar) {
            this.alterarCompromisso(this.menu.getCompromisso(), true);
        }
        if (e.getSource() == this.itemVisualizar) {
            this.alterarCompromisso(this.menu.getCompromisso(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encerrarCompromisso(final Compromisso compromisso) {
        if (compromisso == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("update usuariocompromisso set uco_encerramento = current_timestamp ");
        buf.append(" where uco_codigo = ").append(compromisso.getCodigo());
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf);
            Conexao.arquivaSQL();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelAgenda.this.atualizarCompromissos(compromisso.getDataHora());
                    PanelAgenda.this.revalidate();
                    PanelAgenda.this.repaint();
                }
            });
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelUsuario: 843");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excluirCompromisso(final Compromisso compromisso) {
        if (compromisso == null) {
            return;
        }
        if (Funcoes.mensagem(this.getTopLevelAncestor(), "Deseja excluir o registro selecionado?", 4) == 1) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("delete from usuariocompromisso ");
        buf.append(" where uco_codigo = ").append(compromisso.getCodigo());
        buf.append(" or uco_codigopai = ").append(compromisso.getCodigo());
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf);
            Conexao.arquivaSQL();
            if (compromisso.getCodigoPai() == 0) {
                buf = new StringBuilder();
                buf.append("delete from usuariocompromisso ");
                buf.append(" where uco_codigopai = ");
                buf.append(compromisso.getCodigo());
                Conexao.execute(Variaveis.filialPadrao, st, buf);
                Conexao.arquivaSQL();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelAgenda.this.atualizarCompromissos(compromisso.getDataHora());
                    PanelAgenda.this.revalidate();
                    PanelAgenda.this.repaint();
                }
            });
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelUsuario: 867");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private void alterarCompromisso(final Compromisso compromisso, boolean editar) {
        if (compromisso == null) {
            return;
        }
        AgendarCompromisso agendar = AgendarCompromisso.novaInstancia(Laboratorio.getInstancia(), editar, this.compromissos, compromisso, false);
        if (agendar != null) {
            agendar.setCompromisso(compromisso);
            agendar.setVisible(true);
            if (agendar.getOK()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PanelAgenda.this.atualizarCompromissos(compromisso.getDataHora());
                        PanelAgenda.this.revalidate();
                        PanelAgenda.this.repaint();
                    }
                });
            }
        }
    }

    public List<Compromisso> getCompromissos() {
        return this.compromissos;
    }

    private void buscaCompromisso() {
        try {
            this.atualizarCompromissos(new Date());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelUsuario (318)");
        }
    }

    @Override
    public void novaMensagemRecebida() {
        this.buscaCompromisso();
    }
}

