/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.Laboratorio;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConexaoWeb {
    private String comandoErro = "";
    private boolean isConnected = false;
    private static boolean isExecutandoTransacao = false;
    private static boolean tentouConectar = false;
    private Connection connection;
    public static final String IP = "pgadmin.resultadosonline.com.br";

    private boolean conectar() {
        try {
            String path = "jdbc:postgresql://pgadmin.resultadosonline.com.br/rol_1";
            this.connection = DriverManager.getConnection(path, "rol_1", "td934m");
            this.connection.setAutoCommit(false);
            this.connection.setTransactionIsolation(2);
            this.isConnected = true;
        }
        catch (SQLException sqlex) {
            this.isConnected = false;
            this.comandoErro = sqlex.toString();
            this.enviarEmailException(this.comandoErro, sqlex);
        }
        return this.isConnected;
    }

    public ConexaoWeb() {
        this.conectar();
    }

    public String getUltimoErro() {
        return this.comandoErro;
    }

    public boolean getConnected() {
        return this.isConnected;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                this.isConnected = false;
                return true;
            }
            catch (SQLException ex) {
                this.comandoErro = ex.toString();
                this.enviarEmailException(this.comandoErro, ex);
                return false;
            }
        }
        return true;
    }

    public Statement getStatement() {
        try {
            return this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            this.comandoErro = ex.toString();
            this.enviarEmailException(this.comandoErro, ex);
            return null;
        }
    }

    public void arquivaSQL() throws SQLException {
        this.connection.commit();
        isExecutandoTransacao = false;
    }

    public void anulaSQL() throws SQLException {
        this.connection.rollback();
        isExecutandoTransacao = false;
    }

    public void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                this.comandoErro = ex.toString();
                this.enviarEmailException(this.comandoErro, ex);
            }
        }
    }

    public ResultSet executeQuery(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        try {
            res = st.executeQuery(sql);
            if (!isExecutandoTransacao) {
                st.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            this.comandoErro = sql;
            this.enviarEmailException(sql, e);
            return this.iniciarProcessoReconexaoQuery(e, res, st, sql, null);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public boolean execute(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        boolean res = false;
        try {
            res = st.execute(sql);
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            this.comandoErro = sql;
            this.enviarEmailException(sql, e);
            this.iniciarProcessoReconexaoUpdate(e, st, sql);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    private int iniciarProcessoReconexaoUpdate(SQLException e, Statement st, String sql) throws SQLException {
        if (!tentouConectar && e.getMessage().contains("E/S") || !tentouConectar && e.getMessage().contains("I/O")) {
            this.fecharStatement(st);
            tentouConectar = true;
            this.connection = null;
            this.isConnected = false;
            if (!Funcoes.textoVazio(sql)) {
                return this.executeUpdate(this.getStatementTratandoShutdown(), sql);
            }
        } else if (e.getMessage().contains("E/S") || e.getMessage().contains("I/O")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.", 2);
            System.exit(0);
        } else {
            this.enviarEmailException(sql, e);
            throw e;
        }
        tentouConectar = false;
        return 0;
    }

    public int executeUpdate(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        int res = 0;
        try {
            res = st.executeUpdate(sql);
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            this.comandoErro = sql;
            this.enviarEmailException(sql, e);
            return this.iniciarProcessoReconexaoUpdate(e, st, sql);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    private void enviarEmailException(String sql, SQLException e) {
        StringBuilder msg = new StringBuilder();
        msg.append("\n").append(e.toString()).append("\n");
        msg.append(sql);
        ErrorLogger.enviaEmailErro(msg.toString(), "<logconexaoweb>");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ResultSet iniciarProcessoReconexaoQuery(SQLException e, ResultSet res, Statement st, String sql, PreparedStatement pst) throws SQLException {
        if (!tentouConectar && e.getMessage().contains("E/S") || !tentouConectar && e.getMessage().contains("I/O")) {
            this.fecharStatement(st);
            tentouConectar = true;
            this.connection = null;
            this.isConnected = false;
            if (!Funcoes.textoVazio(sql)) {
                return this.executeQuery(this.getStatementTratandoShutdown(), sql);
            }
            return pst.executeQuery();
        }
        if (!e.getMessage().contains("E/S") && !e.getMessage().contains("I/O")) {
            this.enviarEmailException(sql, e);
            throw e;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.", 2);
        System.exit(0);
        tentouConectar = false;
        return null;
    }

    public Statement getStatementTratandoShutdown() {
        try {
            if (this.connection == null) {
                this.conectar();
            }
            return this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            this.comandoErro = ex.toString();
            this.enviarEmailException(this.comandoErro, ex);
            return null;
        }
    }
}

