/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class ConexaoTemporaria {
    private static String ultimoErro = "";
    private static boolean isConnected = false;
    private static String ultimoComando = "";
    private static Connection connection;
    private static boolean isExecutandoTransacao;
    private static boolean isExecutarRollbackQuery;
    private static boolean tentouConectar;
    private static boolean isExecutarSleepAposSavepoint;
    private static int tempoSleepAposSavepoint;
    private static boolean isUtilizarSavepoints;
    private static final int VERSAO_MINIMA_POSTGRESQL_APPLICATION_NAME = 90000;

    private ConexaoTemporaria() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Connection getInstancia() {
        Connection c = null;
        if (connection != null) {
            c = connection;
        }
        try {
            c = DriverManager.getConnection(Variaveis.caminhoBanco + "?autoReconnect=true", "thread", "murphy123");
            c.setAutoCommit(false);
            c.setTransactionIsolation(2);
            isConnected = true;
            Statement st = c.createStatement();
            Savepoint savepoint = null;
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try (ResultSet rsVersao = null;){
                rsVersao = st.executeQuery(" SELECT setting as versao FROM pg_settings WHERE name = 'server_version_num' ");
                if (rsVersao.next() && rsVersao.getInt("versao") >= 90000) {
                    st.execute(" SET application_name TO 'Jalis " + ConstantesGerais.NRVERSAO + " (TEMP.) " + ConexaoTemporaria.pegaOrigem() + "'");
                    st.getConnection().commit();
                }
            }
            catch (Exception e) {
                if (isUtilizarSavepoints) {
                    st.getConnection().rollback(savepoint);
                }
            }
            finally {
                ConexaoTemporaria.fecharStatement(st);
            }
        }
        catch (SQLException sqlex) {
            isConnected = false;
            ultimoErro = sqlex.toString();
        }
        return c;
    }

    public static String getUltimoErro() {
        return ultimoErro;
    }

    public static boolean getConnected() {
        return isConnected;
    }

    public static Connection getConnection() {
        return ConexaoTemporaria.getInstancia();
    }

    public static boolean shutdown() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                return true;
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public static Statement getStatement() {
        try {
            if (connection == null) {
                connection = ConexaoTemporaria.getInstancia();
            }
            return connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static void arquivaSQL() throws SQLException {
        if (connection == null) {
            connection = ConexaoTemporaria.getInstancia();
        }
        connection.commit();
        isExecutandoTransacao = false;
    }

    public static void anulaSQL() throws SQLException {
        if (connection == null) {
            connection = ConexaoTemporaria.getInstancia();
        }
        connection.rollback();
        isExecutandoTransacao = false;
    }

    public static void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        ConexaoTemporaria.setUltimoComando(sql.toString());
        return ConexaoTemporaria.executeQuery(st, sql.toString());
    }

    public static ResultSet executeQuery(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ConexaoTemporaria.setUltimoComando(sql);
            res = st.executeQuery(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isExecutandoTransacao && isExecutarRollbackQuery) {
                st.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            return ConexaoTemporaria.iniciarProcessoReconexaoQuery(e, savepoint, res, st, sql, null);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static ResultSet executeQueryPerfomance(Statement st, String sql) throws SQLException {
        return st.executeQuery(sql);
    }

    public static boolean execute(Statement st, StringBuilder sql) throws SQLException {
        return ConexaoTemporaria.execute(Variaveis.filialPadrao, st, sql.toString(), false);
    }

    public static boolean execute(Statement st, String sql) throws SQLException {
        return ConexaoTemporaria.execute(Variaveis.filialPadrao, st, sql, false);
    }

    public static boolean execute(String filial, Statement st, StringBuilder sql) throws SQLException {
        return ConexaoTemporaria.execute(filial, st, sql.toString(), false);
    }

    public static boolean execute(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        boolean res = false;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            ConexaoTemporaria.setUltimoComando(sql);
            res = st.execute(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            ConexaoTemporaria.iniciarProcessoReconexaoUpdate(filial, savepoint, e, st, sql, ignorarIntegracao);
        }
        tentouConectar = false;
        if (res && !ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        return ConexaoTemporaria.executeUpdate(Variaveis.filialPadrao, st, sql.toString(), false);
    }

    public static int executeUpdate(String filial, Statement st, StringBuilder sql) throws SQLException {
        return ConexaoTemporaria.executeUpdate(filial, st, sql.toString(), false);
    }

    public static int executeUpdate(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        int res = 0;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ConexaoTemporaria.setUltimoComando(sql);
            res = st.executeUpdate(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            return ConexaoTemporaria.iniciarProcessoReconexaoUpdate(filial, savepoint, e, st, sql, ignorarIntegracao);
        }
        tentouConectar = false;
        if (res > 0 && !ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        try {
            if (connection == null) {
                connection = ConexaoTemporaria.getInstancia();
            }
            ConexaoTemporaria.setUltimoComando(sql);
            return connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static boolean conectado() {
        return isConnected;
    }

    public static final String getUltimoComando() {
        return ultimoComando;
    }

    private static void setUltimoComando(String ultimoComando) {
        ConexaoTemporaria.ultimoComando = ultimoComando;
    }

    private static ResultSet iniciarProcessoReconexaoQuery(SQLException e, Savepoint savepoint, ResultSet res, Statement st, String sql, PreparedStatement pst) throws SQLException {
        if (st != null && savepoint != null) {
            st.getConnection().rollback(savepoint);
        } else if (pst != null && savepoint != null) {
            pst.getConnection().rollback(savepoint);
        } else {
            throw e;
        }
        if (!tentouConectar && e.getMessage().contains("E/S")) {
            ConexaoTemporaria.fecharStatement(st);
            tentouConectar = true;
            connection = null;
            isConnected = false;
            if (!Funcoes.textoVazio(sql)) {
                return ConexaoTemporaria.executeQuery(ConexaoTemporaria.getStatement(), sql);
            }
            return pst.executeQuery();
        }
        if (!e.getMessage().contains("E/S")) {
            throw e;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.\nReinicie o computador e abra o Jalis novamente.", 2);
        System.exit(0);
        tentouConectar = false;
        return null;
    }

    private static int iniciarProcessoReconexaoUpdate(String filial, Savepoint savepoint, SQLException e, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        if (st == null || savepoint == null) {
            throw e;
        }
        st.getConnection().rollback(savepoint);
        if (!tentouConectar && e.getMessage().contains("E/S")) {
            ConexaoTemporaria.fecharStatement(st);
            tentouConectar = true;
            connection = null;
            isConnected = false;
            if (!Funcoes.textoVazio(sql)) {
                return ConexaoTemporaria.executeUpdate(filial, ConexaoTemporaria.getStatement(), sql, ignorarIntegracao);
            }
        } else if (e.getMessage().contains("E/S")) {
            if (savepoint != null) {
                st.getConnection().rollback(savepoint);
            }
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.\nReinicie o computador e abra o Jalis novamente por favor.", 2);
            System.exit(0);
        }
        tentouConectar = false;
        return 0;
    }

    private static String pegaOrigem() {
        Exception e = new Exception();
        String retorno = "";
        for (StackTraceElement s : e.getStackTrace()) {
            if (s.getClassName().toLowerCase().indexOf("conexaotemporaria") >= 0) continue;
            retorno = s.getClassName() + "." + s.getMethodName();
            break;
        }
        return retorno.trim().length() > 17 ? retorno.substring(17) : retorno;
    }

    public static synchronized ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = pst.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res = pst.executeQuery();
            try {
                if (isUtilizarSavepoints) {
                    pst.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isExecutandoTransacao && isExecutarRollbackQuery) {
                pst.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            return ConexaoTemporaria.iniciarProcessoReconexaoQuery(e, savepoint, res, null, null, pst);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static void fecharResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    static {
        isExecutandoTransacao = false;
        isExecutarRollbackQuery = false;
        tentouConectar = false;
        isExecutarSleepAposSavepoint = false;
        tempoSleepAposSavepoint = 100;
        isUtilizarSavepoints = false;
    }
}

