/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class ConexaoIntegracaoOffline {
    private static String ultimoErro = "";
    private static boolean isConnected = false;
    private Connection connection = null;
    private String filial = "";
    private boolean isExecutandoTransacao = false;
    private static boolean isExecutarRollbackQuery = false;
    private static boolean isExecutarSleepAposSavepoint = false;
    private static int tempoSleepAposSavepoint = 100;
    private static boolean isUtilizarSavepoints = false;
    private static final int VERSAO_MINIMA_POSTGRESQL_APPLICATION_NAME = 90000;

    public ConexaoIntegracaoOffline(String filial) {
        this.filial = filial;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Connection getInstancia() {
        Connection c = null;
        try {
            c = DriverManager.getConnection(Variaveis.caminhoBanco, "thread", "murphy123");
            c.setAutoCommit(false);
            c.setTransactionIsolation(2);
            isConnected = true;
            Statement st = c.createStatement();
            Savepoint savepoint = null;
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try {
                ResultSet rsVersao = st.executeQuery(" SELECT setting as versao FROM pg_settings WHERE name = 'server_version_num' ");
                if (rsVersao.next() && rsVersao.getInt("versao") >= 90000) {
                    st.execute(" SET application_name TO 'Jalis " + ConstantesGerais.NRVERSAO + " (INT. OFF. - Filial:" + this.filial + ")' ");
                    st.getConnection().commit();
                }
            }
            catch (Exception e) {
                if (isUtilizarSavepoints) {
                    st.getConnection().rollback(savepoint);
                }
            }
            finally {
                ConexaoIntegracaoOffline.fecharStatement(st);
            }
        }
        catch (SQLException sqlex) {
            isConnected = false;
            ultimoErro = sqlex.toString();
        }
        return c;
    }

    public String getUltimoErro() {
        return ultimoErro;
    }

    public boolean getConnected() {
        return isConnected;
    }

    public Connection getConnection() {
        return this.getInstancia();
    }

    public boolean shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                return true;
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public Statement getStatement() {
        try {
            if (this.connection == null) {
                this.connection = this.getInstancia();
            }
            return this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public void arquivaSQL(Statement st) throws SQLException {
        if (st != null && st.getConnection() != null) {
            st.getConnection().commit();
        }
        this.isExecutandoTransacao = false;
    }

    public void anulaSQL(Statement st) throws SQLException {
        if (st != null && st.getConnection() != null) {
            st.getConnection().rollback();
        }
        this.isExecutandoTransacao = false;
    }

    public static void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.getConnection().rollback();
                st.close();
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        return this.executeQuery(st, sql.toString());
    }

    public synchronized ResultSet executeQuery(Statement st, String sql) throws SQLException {
        ResultSet res = null;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            res = st.executeQuery(sql);
            if (isUtilizarSavepoints) {
                st.getConnection().releaseSavepoint(savepoint);
            }
            if (!this.isExecutandoTransacao && isExecutarRollbackQuery) {
                st.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            if (isUtilizarSavepoints) {
                st.getConnection().rollback(savepoint);
            }
            throw e;
        }
        return res;
    }

    public int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        return this.executeUpdate(Variaveis.filialPadrao, st, sql.toString(), false);
    }

    public int executeUpdate(String filial, Statement st, StringBuilder sql) throws SQLException {
        return this.executeUpdate(filial, st, sql.toString(), false);
    }

    public synchronized int executeUpdate(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        int res = 0;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            res = st.executeUpdate(sql);
            if (isUtilizarSavepoints) {
                st.getConnection().releaseSavepoint(savepoint);
            }
            this.isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            if (isUtilizarSavepoints) {
                st.getConnection().rollback(savepoint);
            }
            throw e;
        }
        return res;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            if (this.connection == null) {
                this.connection = this.getInstancia();
            }
            return this.connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static boolean conectado() {
        return isConnected;
    }
}

