/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Variaveis;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.util.DBUtil;
import jalis.util.StringUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConexaoIntegracao {
    private String ultimoErro;
    private boolean isConnected;
    private Connection connection;

    public ConexaoIntegracao(String ip, boolean mostrarErrosConsole) {
        block2: {
            this.ultimoErro = "";
            this.isConnected = false;
            try {
                this.connection = DriverManager.getConnection("jdbc:postgresql://" + ip + "/jalis", "thread", "murphy123");
                this.connection.setAutoCommit(false);
                this.connection.setTransactionIsolation(2);
                this.isConnected = true;
            }
            catch (SQLException sqlex) {
                this.isConnected = false;
                this.ultimoErro = sqlex.toString();
                if (!mostrarErrosConsole) break block2;
                sqlex.printStackTrace();
            }
        }
    }

    public String getUltimoErro() {
        return this.ultimoErro;
    }

    public boolean getConnected() {
        return this.isConnected;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
                return true;
            }
            catch (SQLException ex) {
                this.ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public Statement getStatement() {
        try {
            return this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            this.ultimoErro = ex.toString();
            return null;
        }
    }

    public void arquivaSQL() throws SQLException {
        this.connection.commit();
    }

    public void anulaSQL() throws SQLException {
        this.connection.rollback();
    }

    public void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                this.ultimoErro = ex.toString();
            }
        }
    }

    public ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        return this.executeQuery(st, sql.toString());
    }

    public ResultSet executeQuery(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = st.executeQuery(sql);
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = pst.executeQuery();
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public boolean execute(Statement st, StringBuilder sql) throws SQLException {
        return this.execute(st, sql.toString());
    }

    public boolean execute(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        boolean res = st.execute(sql);
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        return this.executeUpdate(st, sql.toString());
    }

    public int executeUpdate(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        int res = st.executeUpdate(sql);
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            return this.connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            this.ultimoErro = ex.toString();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFilialParaIntegrar(Statement st, String filial) throws SQLException {
        if (st == null || filial.trim().length() == 0) {
            return false;
        }
        StringBuilder buf = new StringBuilder("select fil_integrar from filiais_postocoleta where fil_codigo = ");
        buf.append(filial);
        boolean result = false;
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            result = rs.next() && rs.getBoolean("fil_integrar");
        }
        return result;
    }

    private void insereComandoLog(Statement st, String filial, String sql) throws Exception {
        String sequencia = DBUtil.getSequencia(st, "logoffline", filial);
        sql = StringUtil.limpaCdata(sql);
        StringBuilder buf = new StringBuilder("insert into logoffline(fil_codigo, fil_coddestino, off_operacao, off_codigo) values (");
        buf.append(Variaveis.filialPadrao).append(", ");
        buf.append(filial).append(", ");
        buf.append(StringUtil.textoDBEscape(sql)).append(", ");
        buf.append(sequencia).append(") ");
        st.execute(buf.toString());
    }
}

