/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class ConexaoEmail {
    private static String ultimoErro = "";
    private static boolean isConnected = false;
    private static String ultimoComando = "";
    private static Connection connection;
    private static boolean isExecutandoTransacao;
    private static boolean isExecutarRollbackQuery;
    private static boolean isExecutarSleepAposSavepoint;
    private static int tempoSleepAposSavepoint;
    private static boolean isUtilizarSavepoints;
    private static final int VERSAO_MINIMA_POSTGRESQL_APPLICATION_NAME = 90000;

    private ConexaoEmail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized Connection getInstancia() {
        Connection c = null;
        if (connection != null) {
            c = connection;
        }
        try {
            c = DriverManager.getConnection(Variaveis.caminhoBanco, "thread", "murphy123");
            c.setAutoCommit(false);
            c.setTransactionIsolation(2);
            isConnected = true;
            Statement st = c.createStatement();
            Savepoint savepoint = null;
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            try (ResultSet rsVersao = null;){
                rsVersao = st.executeQuery(" SELECT setting as versao FROM pg_settings WHERE name = 'server_version_num' ");
                if (rsVersao.next() && rsVersao.getInt("versao") >= 90000) {
                    st.execute(" SET application_name TO 'Jalis " + ConstantesGerais.NRVERSAO + " (E-MAIL)' ");
                    st.getConnection().commit();
                }
            }
            catch (Exception e) {
                if (isUtilizarSavepoints) {
                    st.getConnection().rollback(savepoint);
                }
            }
            finally {
                ConexaoEmail.fecharStatement(st);
            }
        }
        catch (SQLException sqlex) {
            isConnected = false;
            ultimoErro = sqlex.toString();
        }
        return c;
    }

    public static String getUltimoErro() {
        return ultimoErro;
    }

    public static boolean getConnected() {
        return isConnected;
    }

    public static Connection getConnection() {
        return ConexaoEmail.getInstancia();
    }

    public static boolean shutdown() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                return true;
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
                return false;
            }
        }
        return true;
    }

    public static Statement getStatement() {
        try {
            if (connection == null) {
                connection = ConexaoEmail.getInstancia();
            }
            return connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static void arquivaSQL() throws SQLException {
        if (connection == null) {
            connection = ConexaoEmail.getInstancia();
        }
        connection.commit();
        isExecutandoTransacao = false;
    }

    public static void anulaSQL() throws SQLException {
        if (connection == null) {
            connection = ConexaoEmail.getInstancia();
        }
        connection.rollback();
        isExecutandoTransacao = false;
    }

    public static void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                ultimoErro = ex.toString();
            }
        }
    }

    public static ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        ConexaoEmail.setUltimoComando(sql.toString());
        return ConexaoEmail.executeQuery(st, sql.toString());
    }

    public static synchronized ResultSet executeQuery(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            ConexaoEmail.setUltimoComando(sql);
            res = st.executeQuery(sql);
            if (isUtilizarSavepoints) {
                st.getConnection().releaseSavepoint(savepoint);
            }
            if (!isExecutandoTransacao && isExecutarRollbackQuery) {
                st.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            if (isUtilizarSavepoints) {
                st.getConnection().rollback(savepoint);
            }
            throw e;
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static boolean execute(Statement st, StringBuilder sql) throws SQLException {
        return ConexaoEmail.execute(Variaveis.filialPadrao, st, sql.toString(), false);
    }

    public static boolean execute(Statement st, String sql) throws SQLException {
        return ConexaoEmail.execute(Variaveis.filialPadrao, st, sql, false);
    }

    public static boolean execute(String filial, Statement st, StringBuilder sql) throws SQLException {
        return ConexaoEmail.execute(filial, st, sql.toString(), false);
    }

    public static synchronized boolean execute(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        boolean res = false;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            ConexaoEmail.setUltimoComando(sql);
            res = st.execute(sql);
            if (isUtilizarSavepoints) {
                st.getConnection().releaseSavepoint(savepoint);
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            if (isUtilizarSavepoints) {
                st.getConnection().rollback(savepoint);
            }
            throw e;
        }
        if (res && !ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        return ConexaoEmail.executeUpdate(Variaveis.filialPadrao, st, sql.toString(), false);
    }

    public static int executeUpdate(String filial, Statement st, StringBuilder sql) throws SQLException {
        return ConexaoEmail.executeUpdate(filial, st, sql.toString(), false);
    }

    public static synchronized int executeUpdate(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        int res = 0;
        Savepoint savepoint = null;
        if (isUtilizarSavepoints) {
            savepoint = st.getConnection().setSavepoint();
            try {
                if (isExecutarSleepAposSavepoint) {
                    Thread.sleep(tempoSleepAposSavepoint);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            ConexaoEmail.setUltimoComando(sql);
            res = st.executeUpdate(sql);
            if (isUtilizarSavepoints) {
                st.getConnection().releaseSavepoint(savepoint);
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            if (isUtilizarSavepoints) {
                st.getConnection().rollback(savepoint);
            }
            throw e;
        }
        if (res > 0 && !ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        try {
            if (connection == null) {
                connection = ConexaoEmail.getInstancia();
            }
            ConexaoEmail.setUltimoComando(sql);
            return connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            ultimoErro = ex.toString();
            return null;
        }
    }

    public static boolean conectado() {
        return isConnected;
    }

    public static final String getUltimoComando() {
        return ultimoComando;
    }

    private static void setUltimoComando(String ultimoComando) {
        ConexaoEmail.ultimoComando = ultimoComando;
    }

    static {
        isExecutandoTransacao = false;
        isExecutarRollbackQuery = false;
        isExecutarSleepAposSavepoint = false;
        tempoSleepAposSavepoint = 100;
        isUtilizarSavepoints = false;
    }
}

