/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.ConstantesGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.ControlaTempoInativo;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public class Conexao {
    public static final String PASSWORD = "murphy123";
    public static final String USER = "thread";
    private static boolean isConnected = false;
    private static Connection connection;
    private static final boolean OFF_LINE = false;
    private static String comandoErro;
    public static boolean sessaoConexao;
    private static Map<String, HashMap<Object, Object>> hashMapSessao;
    private static boolean isExecutandoTransacao;
    private static boolean isExecutarRollbackQuery;
    private static boolean tentouConectar;
    private static boolean isExecutarSleepAposSavepoint;
    private static int tempoSleepAposSavepoint;
    private static boolean isUtilizarSavepoints;
    private static final int VERSAO_MINIMA_POSTGRESQL_APPLICATION_NAME = 90000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void conectar() {
        block20: {
            try {
                connection = DriverManager.getConnection(Variaveis.caminhoBanco + "?autoReconnect=true", USER, PASSWORD);
                connection.setAutoCommit(false);
                connection.setTransactionIsolation(2);
                isConnected = true;
                Statement st = connection.createStatement();
                Savepoint savepoint = null;
                if (isUtilizarSavepoints) {
                    savepoint = st.getConnection().setSavepoint();
                    try {
                        if (isExecutarSleepAposSavepoint) {
                            Thread.sleep(tempoSleepAposSavepoint);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try (ResultSet rsVersao = null;){
                    rsVersao = st.executeQuery("SELECT setting as versao FROM pg_settings WHERE name = 'server_version_num' ");
                    if (rsVersao.next() && rsVersao.getInt("versao") >= 90000) {
                        st.execute(" SET application_name TO 'Jalis " + ConstantesGerais.NRVERSAO + "'");
                        st.getConnection().commit();
                    }
                }
                catch (Exception e) {
                    block21: {
                        try {
                            if (!isUtilizarSavepoints) break block21;
                            st.getConnection().rollback(savepoint);
                        }
                        catch (Throwable throwable) {
                            Conexao.fecharStatement(st);
                            throw throwable;
                        }
                    }
                    Conexao.fecharStatement(st);
                    break block20;
                }
                Conexao.fecharStatement(st);
            }
            catch (SQLException sqlex) {
                String erro = sqlex.getSQLState();
                if (erro.equals("3D000")) {
                    Conexao.setComandoErro("\nBanco de dados n\u00e3o localizado no IP " + Variaveis.ipBanco + ".");
                } else if (erro.equals("08001")) {
                    Conexao.setComandoErro("\nN\u00e2o foi poss\u00edvel conectar no IP " + Variaveis.ipBanco + ".");
                } else {
                    Conexao.enviarEmailException("", sqlex);
                    Conexao.setComandoErro(sqlex.toString());
                }
                isConnected = false;
            }
        }
    }

    private Conexao() {
    }

    public static boolean getConnected() {
        return isConnected;
    }

    public static Connection getConnection() {
        return connection;
    }

    public static boolean shutdown() {
        if (connection != null) {
            try {
                connection.close();
                connection = null;
                return true;
            }
            catch (SQLException ex) {
                Conexao.setComandoErro(ex.toString());
                return false;
            }
        }
        return true;
    }

    public static Statement getStatement() {
        try {
            if (connection == null) {
                Conexao.conectar();
            }
            return connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            try {
                if (connection != null && connection.isClosed()) {
                    Conexao.conectar();
                }
                if (connection != null && !connection.isClosed()) {
                    return connection.createStatement(1004, 1007);
                }
            }
            catch (SQLException e) {
                Conexao.setComandoErro(ex.toString());
            }
            Conexao.setComandoErro(ex.toString());
            return null;
        }
    }

    public static Statement getStatementTratandoShutdown() {
        try {
            if (connection == null) {
                Conexao.conectar();
            }
            return connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            Conexao.setComandoErro(ex.toString());
            return null;
        }
    }

    public static void arquivaSQL() throws SQLException {
        connection.commit();
        isExecutandoTransacao = false;
    }

    public static void anulaSQL() throws SQLException {
        if (connection != null && !connection.isClosed()) {
            connection.rollback();
        }
        isExecutandoTransacao = false;
    }

    public static void fecharStatement(Statement ... st) {
        if (st != null) {
            try {
                for (Statement s : st) {
                    if (s == null) continue;
                    s.close();
                }
            }
            catch (SQLException ex) {
                Conexao.setComandoErro(ex.toString());
            }
        }
    }

    public static void fecharStatement(PreparedStatement ... st) {
        if (st != null) {
            try {
                for (PreparedStatement s : st) {
                    s.close();
                }
            }
            catch (SQLException ex) {
                Conexao.setComandoErro(ex.toString());
            }
        }
    }

    public static synchronized ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        return Conexao.executeQuery(st, sql.toString());
    }

    public static synchronized ResultSet executeQuery(Statement st, String sql) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res = st.executeQuery(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isExecutandoTransacao && isExecutarRollbackQuery) {
                st.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            Conexao.setComandoErro(sql);
            return Conexao.iniciarProcessoReconexaoQuery(e, savepoint, res, st, sql, null);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static ResultSet executeQueryPerformance(Statement st, StringBuilder sql) throws SQLException {
        st.setPoolable(true);
        return st.executeQuery(sql.toString());
    }

    public static ResultSet executeQueryPerformance(Statement st, String sql) throws SQLException {
        st.setPoolable(true);
        return st.executeQuery(sql);
    }

    public static synchronized ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        ResultSet res = null;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = pst.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res = pst.executeQuery();
            try {
                if (isUtilizarSavepoints) {
                    pst.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!isExecutandoTransacao && isExecutarRollbackQuery) {
                pst.getConnection().rollback();
            }
        }
        catch (SQLException e) {
            Conexao.setComandoErro(pst.toString());
            return Conexao.iniciarProcessoReconexaoQuery(e, savepoint, res, null, null, pst);
        }
        tentouConectar = false;
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static ResultSet executeQueryPerformance(PreparedStatement pst) throws SQLException {
        pst.setPoolable(true);
        return pst.executeQuery();
    }

    @Deprecated
    public static synchronized boolean execute(Statement st, StringBuilder sql) throws SQLException {
        return Conexao.execute(st, sql.toString());
    }

    public static synchronized boolean execute(String filial, Statement st, StringBuilder sql) throws SQLException {
        return Conexao.execute(filial, st, sql.toString(), false);
    }

    @Deprecated
    public static synchronized boolean execute(Statement st, String sql) throws SQLException {
        return Conexao.execute(Variaveis.filialPadrao, st, sql, false);
    }

    public static synchronized boolean execute(String filial, Statement st, String sql) throws SQLException {
        return Conexao.execute(filial, st, sql, false);
    }

    @Deprecated
    public static synchronized boolean execute(Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        return Conexao.execute(Variaveis.filialPadrao, st, sql, ignorarIntegracao);
    }

    public static synchronized boolean execute(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        boolean res = false;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res = st.execute(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            Conexao.setComandoErro(sql);
            Conexao.iniciarProcessoReconexaoUpdate(filial, savepoint, e, st, sql, ignorarIntegracao);
        }
        tentouConectar = false;
        if (!ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static boolean executePerformance(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean retorno = st.execute(sql);
        if (!ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean updateVerificandoAlteracao(String filial, String tabela, String where, Statement stPrincipal, String sqlCompleto, String[] excecoes) throws SQLException {
        Registro regAux = null;
        StringBuilder buf = new StringBuilder();
        buf.append(" select * ");
        buf.append("   from ").append(tabela);
        buf.append(where);
        try (ResultSet rsAux = null;){
            rsAux = stPrincipal.executeQuery(buf.toString());
            if (rsAux.next()) {
                regAux = new Registro(rsAux);
            }
        }
        Conexao.execute(filial, stPrincipal, sqlCompleto, false);
        try {
            rsAux = stPrincipal.executeQuery(buf.toString());
            if (rsAux.next() && regAux != null) {
                for (int i = 0; i < regAux.getQtdeColunas(); ++i) {
                    boolean isExcecao = false;
                    for (int j = 0; j < excecoes.length; ++j) {
                        if (!excecoes[j].equalsIgnoreCase(regAux.getNomeColuna(i))) continue;
                        isExcecao = true;
                        break;
                    }
                    if (isExcecao) continue;
                    Object valorAnt = regAux.getValor(regAux.getNomeColuna(i));
                    Object valorNovo = rsAux.getObject(regAux.getNomeColuna(i));
                    Object object = valorNovo = valorNovo instanceof Date || valorNovo instanceof Time || valorNovo instanceof Timestamp ? (valorNovo = valorNovo.toString().replace('-', '/')) : valorNovo;
                    if (valorAnt == null && valorNovo == null || !(valorAnt == null && valorNovo != null || valorAnt != null && valorNovo == null) && (valorAnt == null || valorAnt.equals(valorNovo))) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        }
        finally {
            if (rsAux != null) {
                rsAux.close();
            }
        }
        return false;
    }

    @Deprecated
    public static synchronized int executeUpdate(Statement st, StringBuilder sql) throws SQLException {
        return Conexao.executeUpdate(st, sql.toString());
    }

    public static synchronized int executeUpdate(String filial, Statement st, StringBuilder sql) throws SQLException {
        return Conexao.executeUpdate(filial, st, sql.toString());
    }

    @Deprecated
    public static synchronized int executeUpdate(Statement st, String sql) throws SQLException {
        return Conexao.executeUpdate(Variaveis.filialPadrao, st, sql, false);
    }

    public static synchronized int executeUpdate(String filial, Statement st, String sql) throws SQLException {
        return Conexao.executeUpdate(filial, st, sql, false);
    }

    public static int executeUpdatePerformance(String filial, Statement st, String sql) throws SQLException {
        return Conexao.executeUpdatePerformance(filial, st, sql, false);
    }

    @Deprecated
    public static synchronized int executeUpdate(Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        return Conexao.executeUpdate(Variaveis.filialPadrao, st, sql, ignorarIntegracao);
    }

    public static synchronized int executeUpdate(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        int res = 0;
        Savepoint savepoint = null;
        try {
            if (isUtilizarSavepoints) {
                savepoint = st.getConnection().setSavepoint();
                try {
                    if (isExecutarSleepAposSavepoint) {
                        Thread.sleep(tempoSleepAposSavepoint);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            res = st.executeUpdate(sql);
            try {
                if (isUtilizarSavepoints) {
                    st.getConnection().releaseSavepoint(savepoint);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            isExecutandoTransacao = true;
        }
        catch (SQLException e) {
            Conexao.setComandoErro(sql);
            return Conexao.iniciarProcessoReconexaoUpdate(filial, savepoint, e, st, sql, ignorarIntegracao);
        }
        tentouConectar = false;
        if (!ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return res;
    }

    public static int executeUpdatePerformance(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        int retorno = st.executeUpdate(sql);
        if (!ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        return retorno;
    }

    private static void enviarEmailException(String sql, SQLException e) {
        StringBuilder msg = new StringBuilder();
        msg.append("\n").append(e.toString()).append("\n");
        msg.append(sql);
        ErrorLogger.enviaEmailErro(msg.toString(), "<logconexao>");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static PreparedStatement getPreparedStatement(String sql) {
        try {
            if (connection == null) {
                Conexao.conectar();
            }
            return connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            Conexao.setComandoErro(sql);
            return null;
        }
    }

    public static final String getUltimoErro() {
        return comandoErro;
    }

    private static void setComandoErro(String comandoErro) {
        Conexao.comandoErro = comandoErro;
    }

    public static Map<String, HashMap<Object, Object>> getHashMapSessao() {
        return hashMapSessao;
    }

    public static Object getObjetoDeSessao(String nomeClass, Object key) {
        for (String keySet : hashMapSessao.keySet()) {
            if (!keySet.equalsIgnoreCase(nomeClass)) continue;
            HashMap<Object, Object> objetos = hashMapSessao.get(keySet);
            for (Object k : objetos.keySet()) {
                if (!k.toString().equalsIgnoreCase(key.toString())) continue;
                return objetos.get(k);
            }
        }
        return null;
    }

    public static void setSessaoConexao(boolean ativar) {
        sessaoConexao = ativar;
        if (!ativar) {
            hashMapSessao.clear();
        }
    }

    public static boolean getSessaoConexao() {
        return sessaoConexao;
    }

    private static ResultSet iniciarProcessoReconexaoQuery(SQLException e, Savepoint savepoint, ResultSet res, Statement st, String sql, PreparedStatement pst) throws SQLException {
        if (st != null && savepoint != null) {
            try {
                st.getConnection().rollback(savepoint);
            }
            catch (Exception exception) {}
        } else if (pst != null && savepoint != null) {
            try {
                pst.getConnection().rollback(savepoint);
            }
            catch (Exception exception) {}
        } else {
            throw e;
        }
        if (!tentouConectar && e.getMessage().contains("E/S") || !tentouConectar && e.getMessage().contains("I/O")) {
            Conexao.fecharStatement(st);
            tentouConectar = true;
            connection = null;
            isConnected = false;
            if (!Funcoes.textoVazio(sql)) {
                return Conexao.executeQuery(Conexao.getStatementTratandoShutdown(), sql);
            }
            return pst.executeQuery();
        }
        if (!e.getMessage().contains("E/S") && !e.getMessage().contains("I/O")) {
            throw e;
        }
        Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.\nReinicie o computador e abra o Jalis novamente.", 2);
        System.exit(0);
        tentouConectar = false;
        return null;
    }

    private static int iniciarProcessoReconexaoUpdate(String filial, Savepoint savepoint, SQLException e, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        if (st == null || savepoint == null) {
            throw e;
        }
        st.getConnection().rollback(savepoint);
        if (!tentouConectar && e.getMessage().contains("E/S") || !tentouConectar && e.getMessage().contains("I/O")) {
            Statement stmt;
            Conexao.fecharStatement(st);
            tentouConectar = true;
            connection = null;
            isConnected = false;
            if (!Funcoes.textoVazio(sql) && (stmt = Conexao.getStatementTratandoShutdown()) != null) {
                return Conexao.executeUpdate(filial, stmt, sql, ignorarIntegracao);
            }
        } else if (e.getMessage().contains("E/S") || e.getMessage().contains("I/O")) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel conectar no servidor.\nO sistema ser\u00e1 fechado.\nReinicie o computador e abra o Jalis novamente.", 2);
            System.exit(0);
        } else {
            throw e;
        }
        tentouConectar = false;
        return 0;
    }

    public static void fecharResultSet(ResultSet rs) {
        if (null != rs) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                Conexao.setComandoErro(ex.toString());
            }
        }
    }

    static {
        comandoErro = "";
        sessaoConexao = false;
        hashMapSessao = new HashMap<String, HashMap<Object, Object>>();
        isExecutandoTransacao = false;
        isExecutarRollbackQuery = false;
        tentouConectar = false;
        isExecutarSleepAposSavepoint = false;
        tempoSleepAposSavepoint = 100;
        isUtilizarSavepoints = false;
        Conexao.conectar();
    }
}

