/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.model.vo.cadastro.auxiliares.UsuarioVO;
import jalis.model.vo.configuracao.UsuarioSenhasVO;
import jalis.service.configuracao.UsuarioSenhasService;
import jalis.service.configuracao.UsuarioService;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TPasswordField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AlterarSenha
extends JDialog
implements ActionListener {
    private JLabel label = new JLabel();
    private JLabel labelSenhaNova = new JLabel("Nova senha:");
    private JLabel labelConfirmar = new JLabel("Confirmar senha:");
    private JLabel labelSenhaAtual = new JLabel("Senha atual:");
    private JLabel labelSenhaAtualColetador = new JLabel("Senha atual:");
    private TPasswordField textSenhaNova = new TPasswordField(20);
    private TPasswordField textConfirmar = new TPasswordField(20);
    private TPasswordField textSenhaAtual = new TPasswordField(20);
    private TPasswordField textSenhaAtualColetador = new TPasswordField(20);
    private JLabel labelSenhaColetador = new JLabel("Nova Senha:");
    private JLabel labelSenhaColetadorConfirmar = new JLabel("Confirmar senha:");
    private TPasswordField textSenhaNovaColetador = new TPasswordField(10);
    private TPasswordField textConfirmarColetador = new TPasswordField(10);
    private JPanel panelBotoes = new JPanel(new FlowLayout(2));
    private JPanel panelCentro = new JPanel(new GridBagLayout());
    private JPanel panelSenhaColetador = new JPanel(new GridBagLayout());
    private JButton buttonOK = ComponenteFactory.novoJButton("OK", 'O', this);
    private JButton buttonCancelar = ComponenteFactory.novoJButton("Cancelar", 'C', this);
    private String login;
    private boolean temSenhaColetador = false;
    boolean isCancelar = false;
    private ArrayList<String> senhasAnteriores = new ArrayList();

    public AlterarSenha(Dialog owner, String login) {
        super(owner);
        this.login = login;
        try {
            this.temSenhaColetador = new UsuarioService().usuarioTemSenhaColetador(login);
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public AlterarSenha(Frame owner, String login) {
        super(owner);
        this.login = login;
        try {
            this.temSenhaColetador = new UsuarioService().usuarioTemSenhaColetador(login);
            this.jbInit();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    public void jbInit() throws Exception {
        this.setName("AlterarSenha");
        this.setTitle("Alterar senha");
        this.label.setText("<html>Alterando senha de <font color='red'>" + this.login + "</font>.</html>");
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.setSize(new Dimension(400, 150 + (this.temSenhaColetador ? 100 : 8)));
        this.setModal(true);
        this.setLocationRelativeTo(this.getParent());
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelCentro, "Center");
        this.add((Component)this.panelBotoes, "South");
        Funcoes.montaEnter((JComponent)this.panelBotoes);
        Funcoes.montaEnter((JComponent)this.panelCentro);
        this.panelBotoes.add(this.buttonOK);
        this.buttonOK.setName("buttonOK");
        this.panelBotoes.add(this.buttonCancelar);
        this.buttonCancelar.setName("buttonCancelar");
        this.label.setPreferredSize(new Dimension(300, 20));
        this.label.setMinimumSize(new Dimension(300, 20));
        this.textSenhaNova.setPreferredSize(new Dimension(60, 20));
        this.textSenhaNova.setName("textSenhaNova");
        this.textSenhaNova.setMinimumSize(new Dimension(60, 20));
        this.textConfirmar.setPreferredSize(new Dimension(60, 20));
        this.textConfirmar.setName("textConfirmar");
        this.textConfirmar.setMinimumSize(new Dimension(60, 20));
        this.textSenhaAtual.setPreferredSize(new Dimension(60, 20));
        this.textSenhaAtual.setName("textSenhaAtual");
        this.textSenhaAtual.setMinimumSize(new Dimension(60, 20));
        this.textSenhaNovaColetador.setPreferredSize(new Dimension(60, 20));
        this.textSenhaNovaColetador.setName("textSenhaNovaColetador");
        this.textSenhaNovaColetador.setMinimumSize(new Dimension(60, 20));
        this.textConfirmarColetador.setPreferredSize(new Dimension(60, 20));
        this.textConfirmarColetador.setName("textConfirmarColetador");
        this.textConfirmarColetador.setMinimumSize(new Dimension(60, 20));
        this.textSenhaAtualColetador.setPreferredSize(new Dimension(60, 20));
        this.textSenhaAtualColetador.setName("textSenhaAtualColetador");
        this.textSenhaAtualColetador.setMinimumSize(new Dimension(60, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.fill = 0;
        cons.anchor = 17;
        cons.gridwidth = 2;
        cons.insets = new Insets(1, 1, 0, 1);
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        this.panelCentro.add((Component)this.label, cons);
        ++cons.gridy;
        cons.gridwidth = 1;
        this.panelCentro.add((Component)this.labelSenhaAtual, cons);
        ++cons.gridx;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textSenhaAtual.setPreferredSize(new Dimension(100, 20));
        this.textSenhaAtual.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textSenhaAtual, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.fill = 0;
        cons.weightx = 0.0;
        this.panelCentro.add((Component)this.labelSenhaNova, cons);
        ++cons.gridx;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textSenhaNova.setPreferredSize(new Dimension(100, 20));
        this.textSenhaNova.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textSenhaNova, cons);
        ++cons.gridy;
        cons.gridx = 0;
        cons.fill = 0;
        cons.weightx = 0.0;
        this.panelCentro.add((Component)this.labelConfirmar, cons);
        ++cons.gridx;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textConfirmar.setPreferredSize(new Dimension(100, 20));
        this.textConfirmar.setMinimumSize(new Dimension(100, 20));
        this.panelCentro.add((Component)this.textConfirmar, cons);
        if (this.temSenhaColetador) {
            this.panelSenhaColetador.setBorder(new TitledBorder("Senha de coletador"));
            ++cons.gridy;
            cons.gridx = 0;
            cons.gridwidth = 2;
            cons.fill = 2;
            cons.weightx = 0.0;
            this.panelCentro.add((Component)this.panelSenhaColetador, cons);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.fill = 0;
            c.gridx = 0;
            c.gridy = 0;
            c.insets = new Insets(1, 1, 0, 1);
            c.weightx = 0.0;
            c.gridwidth = 1;
            this.panelSenhaColetador.add((Component)this.labelSenhaAtualColetador, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.textSenhaAtualColetador.setPreferredSize(new Dimension(100, 20));
            this.textSenhaAtualColetador.setMinimumSize(new Dimension(100, 20));
            this.panelSenhaColetador.add((Component)this.textSenhaAtualColetador, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.panelSenhaColetador.add((Component)this.labelSenhaColetador, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.textSenhaNova.setPreferredSize(new Dimension(100, 20));
            this.textSenhaNova.setMinimumSize(new Dimension(100, 20));
            this.panelSenhaColetador.add((Component)this.textSenhaNovaColetador, c);
            ++c.gridy;
            c.gridx = 0;
            c.weightx = 0.0;
            this.panelSenhaColetador.add((Component)this.labelSenhaColetadorConfirmar, c);
            ++c.gridx;
            c.fill = 2;
            c.weightx = 1.0;
            this.textConfirmar.setPreferredSize(new Dimension(100, 20));
            this.textConfirmar.setMinimumSize(new Dimension(100, 20));
            this.panelSenhaColetador.add((Component)this.textConfirmarColetador, c);
        }
        cons.fill = 1;
        cons.weighty = 1.0;
        this.panelCentro.add((Component)new JLabel(), cons);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOK) {
            this.setVisible(!this.marcaAlterado());
        } else {
            this.setVisible(false);
            this.isCancelar = true;
        }
    }

    private boolean marcaAlterado() {
        boolean isSenhalValida = this.validaSenhas();
        if (!isSenhalValida) {
            return false;
        }
        Statement st = Conexao.getStatement();
        boolean retorno = false;
        try {
            boolean adicionarInformacoesColetor = this.temSenhaColetador && this.textSenhaNovaColetador.getPassword().length > 0;
            UsuarioService usuarioService = new UsuarioService();
            UsuarioVO usuarioVO = (UsuarioVO)usuarioService.getVO(this.login);
            if (this.textSenhaNova.getPassword().length > 0) {
                usuarioVO.setSenha(String.valueOf(this.textSenhaNova.getPassword()));
            }
            if (adicionarInformacoesColetor) {
                usuarioVO.setCodColetor(String.valueOf(this.textSenhaNovaColetador.getPassword()));
            }
            usuarioService.atualizarUsuario(usuarioVO, Variaveis.filialPadrao);
            UsuarioSenhasVO usuarioSenhasVo = new UsuarioSenhasVO();
            usuarioSenhasVo.setUsrCodigo(usuarioVO.getCodigo());
            usuarioSenhasVo.setUsnSenha(usuarioVO.getSenha());
            UsuarioSenhasService usuarioSenhasService = new UsuarioSenhasService();
            usuarioSenhasService.inserir(usuarioSenhasVo, usuarioVO, Variaveis.filialPadrao);
            Conexao.arquivaSQL();
            Funcoes.mensagem(this, "Senha alterada com sucesso", 2);
            retorno = true;
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Funcoes.mensagem(this, "Ocorreu uma situa\u00e7\u00e3o inesperada ao alterar a senha, mensagem apresentada " + ex.getMessage(), 2);
            retorno = false;
        }
        Conexao.fecharStatement(st);
        return retorno;
    }

    public boolean getCancelar() {
        return this.isCancelar;
    }

    private boolean validaSenhas() {
        boolean isSenhaAtualValida = false;
        boolean retorno = true;
        if (this.textSenhaAtual.getPassword().length == 0 && this.textSenhaAtualColetador.getPassword().length == 0) {
            ScreenUtil.requisitarFoco(this.textSenhaAtual);
            Funcoes.mensagem(this, "Uma das senha deve ser informada.", 1);
            return false;
        }
        if (this.textSenhaAtual.getPassword().length > 0 || !Funcoes.textoVazio(String.valueOf(this.textSenhaAtual.getPassword()))) {
            try {
                isSenhaAtualValida = new UsuarioService().verificaSenhaUsuario(this.login, StringUtil.converteArrayCharString(this.textSenhaAtual.getPassword()));
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "Erro ao verificar a senha atual do usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
            }
            if (!isSenhaAtualValida) {
                Funcoes.mensagem(this, "A senha atual \u00e9 incorreta.", 1);
                this.textSenhaAtual.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaAtual);
                return false;
            }
            if (this.textSenhaNova.getPassword().length == 0 || Funcoes.textoVazio(String.valueOf(this.textSenhaNova.getPassword()))) {
                Funcoes.mensagem(this, "A nova senha n\u00e3o foi informada.", 1);
                this.textSenhaNova.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaNova);
                return false;
            }
            if (!String.valueOf(this.textSenhaNova.getPassword()).equals(String.valueOf(this.textConfirmar.getPassword()))) {
                Funcoes.mensagem(this, "As senhas informadas n\u00e3o conferem, tente novamente.", 1);
                this.textSenhaNova.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaNova);
                return false;
            }
            if (ParametrosGerais.getValidarSenhasRepitidas() > 0) {
                this.senhasAnteriores = this.buscaSenhasAnterioresUsuario(this.login, ParametrosGerais.getValidarSenhasRepitidas());
                if (null != this.senhasAnteriores && !this.senhasAnteriores.isEmpty()) {
                    for (String senhaRepitida : this.senhasAnteriores) {
                        if (!String.valueOf(this.textSenhaNova.getPassword()).equals(senhaRepitida)) continue;
                        Funcoes.mensagem(this, "Senha j\u00e1 utilizada. Digite novamente.", 2);
                        this.textSenhaNova.selectAll();
                        ScreenUtil.requisitarFoco(this.textSenhaNova);
                        return false;
                    }
                }
            } else if (ParametrosGerais.getValidarSenhasRepitidas() <= 0 && String.valueOf(this.textSenhaNova.getPassword()).equals(String.valueOf(this.textSenhaAtual.getPassword()))) {
                Funcoes.mensagem(this, "Senha j\u00e1 utilizada. Digite novamente.", 2);
                this.textSenhaNova.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaNova);
                return false;
            }
            if (ParametrosGerais.getQtdeCaracteresSenha() > 1 && !Funcoes.validaComplexidadeSenha(String.valueOf(this.textSenhaNova.getPassword()))) {
                this.textSenhaNova.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaNova);
                return false;
            }
        } else if (this.textSenhaNova.getPassword().length > 0) {
            Funcoes.mensagem(this, "A senha n\u00e3o foi informada.", 1);
            this.textSenhaAtual.selectAll();
            ScreenUtil.requisitarFoco(this.textSenhaAtual);
            return false;
        }
        if (this.temSenhaColetador) {
            if (this.textSenhaAtualColetador.getPassword().length > 0 || !Funcoes.textoVazio(String.valueOf(this.textSenhaNovaColetador.getPassword()))) {
                try {
                    isSenhaAtualValida = new UsuarioService().verificaSenhaColetadorUsuario(this.login, StringUtil.converteArrayCharString(this.textSenhaAtualColetador.getPassword()));
                }
                catch (Exception e) {
                    ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel verificar a senha de coletador atual do usu\u00e1rio.\n" + e.getMessage(), e.getStackTrace());
                }
                if (!isSenhaAtualValida) {
                    Funcoes.mensagem(this, "A senha de coletador atual \u00e9 incorreta.", 1);
                    this.textSenhaAtualColetador.selectAll();
                    ScreenUtil.requisitarFoco(this.textSenhaAtualColetador);
                    return false;
                }
                if (this.textSenhaNovaColetador.getPassword().length == 0 || Funcoes.textoVazio(String.valueOf(this.textSenhaNovaColetador.getPassword()))) {
                    Funcoes.mensagem(this, "A nova senha de coletador n\u00e3o foi informada.", 1);
                    this.textSenhaNovaColetador.selectAll();
                    ScreenUtil.requisitarFoco(this.textSenhaNovaColetador);
                    return false;
                }
                if (!String.valueOf(this.textSenhaNovaColetador.getPassword()).equals(String.valueOf(this.textConfirmarColetador.getPassword()))) {
                    Funcoes.mensagem(this, "As senhas de coletador informadas n\u00e3o conferem, tente novamente.", 1);
                    this.textSenhaNovaColetador.selectAll();
                    ScreenUtil.requisitarFoco(this.textSenhaNovaColetador);
                    return false;
                }
                if (ParametrosGerais.getValidarSenhasRepitidas() <= 0 && String.valueOf(this.textSenhaNovaColetador.getPassword()).equals(String.valueOf(this.textSenhaAtualColetador.getPassword()))) {
                    Funcoes.mensagem(this, "Senha j\u00e1 utilizada. Digite novamente.", 2);
                    this.textSenhaNova.selectAll();
                    ScreenUtil.requisitarFoco(this.textSenhaNova);
                    return false;
                }
            } else if (this.textSenhaNovaColetador.getPassword().length > 0) {
                Funcoes.mensagem(this, "A senha de coletador n\u00e3o foi informada.", 1);
                this.textSenhaAtualColetador.selectAll();
                ScreenUtil.requisitarFoco(this.textSenhaAtualColetador);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> buscaSenhasAnterioresUsuario(String usuario, int quantidadeSenhas) {
        StringBuilder bui = new StringBuilder();
        bui.append("select usn_senha from usuariosenhas ");
        bui.append(" where usr_codigo = '").append(usuario).append("'");
        bui.append(" order by usn_codigo desc ");
        bui.append(" limit ").append(quantidadeSenhas);
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                this.senhasAnteriores.add(rs.getString("usn_senha"));
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel buscar as senhas do usu\u00e1rio", e.getStackTrace());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.senhasAnteriores;
    }
}

