/*
 * Decompiled with CFR 0.152.
 */
package jalis.comum;

import jalis.comum.Compromisso;
import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.DialogoFiltro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextAreaDocument;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class AgendarCompromisso
extends AbstractDialogoOKCancelar {
    private TTextField textData = new TTextField(10, 4);
    private JButton buttonData = ComponenteFactory.novoJButton(this, true);
    private TTextField textHora = new TTextField(5, 6);
    private TTextField textDuracao = new TTextField(2, 1);
    private TTextField textTitulo = new TTextField(100);
    private JComboBox comboLembrete = new JComboBox<String>(new String[]{"N\u00e3o lembrar", "5 minutos", "10 minutos", "15 minutos", "20 minutos", "30 minutos", "60 minutos"});
    private JTextArea textAssunto = new JTextArea(new TTextAreaDocument(500));
    private TTextField textDestinatario = new TTextField();
    private JLabel labelCriador = new JLabel(Variaveis.login);
    private Compromisso compromisso = null;
    private Date dataNovoCompromisso = new Date();
    private JButton buttonDestinatario = ComponenteFactory.novoJButton("Para:", 'P', this);
    private JPopupMenu menuPara = new JPopupMenu();
    private JMenuItem itemUsuario = ComponenteFactory.novoJMenuItem("Usu\u00e1rio", 'U', (ActionListener)this);
    private JMenuItem itemTipoUsuario = ComponenteFactory.novoJMenuItem("Tipo de usu\u00e1rio", 'i', (ActionListener)this);
    private String codigoCompromissoPai = "";
    private boolean editar = true;
    private List<Compromisso> compromissos;
    private HashMap<String, String> usuarios = new HashMap();

    public static AgendarCompromisso novaInstancia(Object owner, boolean editar, List<Compromisso> compromissos, Compromisso compromisso, boolean isNovo) {
        if (owner instanceof JDialog) {
            return new AgendarCompromisso((JDialog)owner, "Agendar compromisso", editar, compromissos, compromisso, isNovo);
        }
        if (owner instanceof JFrame) {
            return new AgendarCompromisso((JFrame)owner, "Agendar compromisso", editar, compromissos, compromisso, isNovo);
        }
        return null;
    }

    public AgendarCompromisso(JDialog owner, String titulo, boolean editar, List<Compromisso> compromissos, Compromisso compromisso, boolean isNovo) {
        super((Dialog)owner, titulo);
        this.compromissos = compromissos;
        this.compromisso = compromisso;
        this.iniciar(owner, editar, isNovo);
    }

    public AgendarCompromisso(JFrame owner, String titulo, boolean editar, List<Compromisso> compromissos, Compromisso compromisso, boolean isNovo) {
        super((Frame)owner, titulo);
        this.compromissos = compromissos;
        this.compromisso = compromisso;
        this.iniciar(owner, editar, isNovo);
    }

    private void iniciar(Component owner, boolean editar, boolean isNovo) {
        this.setName("AgendarCompromisso");
        this.getBotaoOK().setText("Salvar");
        this.getBotaoOK().setMnemonic('S');
        this.menuPara.add(this.itemUsuario);
        this.itemUsuario.setName("itemUsuario");
        this.menuPara.add(this.itemTipoUsuario);
        this.itemTipoUsuario.setName("itemTipoUsuario");
        this.setSize(new Dimension(300, 450));
        this.setLocationRelativeTo(owner);
        this.textData.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textData.setName("textData");
        this.comboLembrete.setName("comboLembrete");
        if (!isNovo && this.compromisso != null) {
            this.comboLembrete.setSelectedIndex(this.getLembrete(this.compromisso));
        } else {
            this.comboLembrete.setSelectedIndex(1);
        }
        this.textData.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(AgendarCompromisso.this.textData, AgendarCompromisso.this.buttonData, AgendarCompromisso.this.getPanelCentral(), true);
                }
            }
        });
        JPanel panelCentro = this.getPanelCentral();
        panelCentro.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        panelCentro.add((Component)new JLabel("Data:"), c);
        ++c.gridy;
        panelCentro.add((Component)new JLabel("Hora:"), c);
        ++c.gridy;
        panelCentro.add((Component)new JLabel("T\u00edtulo:"), c);
        ++c.gridy;
        panelCentro.add((Component)new JLabel("Dura\u00e7\u00e3o:"), c);
        ++c.gridy;
        panelCentro.add((Component)new JLabel("Lembrete:"), c);
        ++c.gridy;
        this.buttonDestinatario.setPreferredSize(new Dimension(60, 20));
        this.buttonDestinatario.setName("buttonDestinatario");
        panelCentro.add((Component)this.buttonDestinatario, c);
        c.gridy = 0;
        c.gridx = 1;
        this.textData.setMinimumSize(new Dimension(120, 20));
        this.textData.setPreferredSize(new Dimension(120, 20));
        panelCentro.add((Component)this.textData, c);
        c.gridy = 0;
        ++c.gridx;
        c.anchor = 17;
        this.buttonData.setMinimumSize(new Dimension(20, 20));
        this.buttonData.setPreferredSize(new Dimension(20, 20));
        this.buttonData.setName("buttonData");
        panelCentro.add((Component)this.buttonData, c);
        c.gridx = 1;
        ++c.gridy;
        this.textHora.setMinimumSize(new Dimension(60, 20));
        this.textHora.setPreferredSize(new Dimension(60, 20));
        this.textHora.setName("textHora");
        panelCentro.add((Component)this.textHora, c);
        ++c.gridy;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.textTitulo.setPreferredSize(new Dimension(80, 20));
        this.textTitulo.setName("textTitulo");
        panelCentro.add((Component)this.textTitulo, c);
        ++c.gridy;
        this.textDuracao.setPreferredSize(new Dimension(50, 20));
        JPanel p = new JPanel(new FlowLayout(0, 0, 0));
        p.setPreferredSize(new Dimension(20, 20));
        p.add(this.textDuracao);
        this.textDuracao.setName("textDuracao");
        p.add(new JLabel("minutos"));
        panelCentro.add((Component)p, c);
        ++c.gridy;
        c.gridwidth = 2;
        this.comboLembrete.setPreferredSize(new Dimension(80, 20));
        this.comboLembrete.setName("comboLembrete");
        panelCentro.add((Component)this.comboLembrete, c);
        ++c.gridy;
        c.gridwidth = 2;
        this.textDestinatario.setPreferredSize(new Dimension(80, 20));
        this.textDestinatario.setName("textDestinatario");
        panelCentro.add((Component)this.textDestinatario, c);
        ++c.gridy;
        c.gridx = 0;
        ++c.gridy;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.fill = 1;
        panelCentro.add((Component)new JScrollPane(this.textAssunto), c);
        this.getPanelBotoesEsquerda().add(this.labelCriador);
        ScreenUtil.requisitarFoco(this.textData);
        this.textData.setEditable(editar);
        this.textData.setName("textData");
        this.textAssunto.setEditable(editar);
        this.textAssunto.setName("textAssunto");
        this.textDestinatario.setEditable(editar);
        this.textDestinatario.setName("textDestinatario");
        this.textDuracao.setEditable(editar);
        this.textDuracao.setName("textDuracao");
        this.textHora.setEditable(editar);
        this.textHora.setName("textHora");
        this.textTitulo.setEditable(editar);
        this.textTitulo.setName("textTitulo");
        this.buttonDestinatario.setEnabled(editar);
        this.buttonDestinatario.setName("buttonDestinatario");
        this.buttonData.setEnabled(editar);
        this.buttonData.setName("buttonData");
        this.comboLembrete.setEnabled(editar);
        this.comboLembrete.setName("comboLembrete");
        this.buttonOK.setEnabled(editar);
        this.buttonOK.setName("buttonOK");
    }

    private int getLembrete(Compromisso compromisso) {
        int comp = compromisso.getTempoLembrete();
        switch (comp) {
            case 0: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 10: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 20: {
                return 4;
            }
            case 30: {
                return 5;
            }
            case 60: {
                return 6;
            }
        }
        return 0;
    }

    public Date getDataNovoCompromisso() {
        return this.dataNovoCompromisso;
    }

    public void setCompromisso(Compromisso compromisso) {
        if (compromisso == null) {
            return;
        }
        this.compromisso = compromisso;
        this.textData.setText(Funcoes.formataData(compromisso.getDataHora()));
        this.textHora.setText(Funcoes.formataData("HH:mm", compromisso.getDataHora()));
        this.textDuracao.setText(String.valueOf(compromisso.getDuracao()));
        this.textTitulo.setText(compromisso.getTitulo());
        this.textAssunto.setText(compromisso.getAssunto());
        for (int i = 0; i < this.comboLembrete.getItemCount(); ++i) {
            String temp = this.comboLembrete.getItemAt(i).toString().substring(0, this.comboLembrete.getItemAt(i).toString().indexOf(" "));
            if (!Funcoes.isNumeric(temp) || Integer.parseInt(temp) != compromisso.getTempoLembrete()) continue;
            this.comboLembrete.setSelectedIndex(i);
            break;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("select usr_codigo, uco_codigo from usuariocompromisso");
        buf.append(" where uco_codigopai = '").append(compromisso.getCodigoPai()).append("'");
        buf.append(" or uco_codigo = '").append(compromisso.getCodigo()).append("'");
        buf.append(" or uco_codigopai = '").append(compromisso.getCodigo()).append("'");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            String usuario = "";
            while (rs.next()) {
                this.usuarios.put(rs.getString("usr_codigo"), rs.getString("usr_codigo"));
            }
            String usuarioCriador = Funcoes.textoVazio(String.valueOf(compromisso.getCodigoPai())) || compromisso.getCodigoPai() <= 0 ? compromisso.getUsuario() : this.buscarCriador(compromisso.getCodigoPai());
            this.textDestinatario.setText(this.usuarios.keySet().toString().replace("[", "").replace("]", ""));
            this.labelCriador.setText(usuarioCriador);
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        ScreenUtil.posicionaTextoTopo(this.textAssunto);
    }

    private String buscarCriador(int codigoPai) {
        StringBuilder buf = new StringBuilder();
        buf.append("select usr_codigo from usuariocompromisso");
        buf.append(" where uco_codigo = '");
        buf.append(codigoPai);
        buf.append("'");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                return rs.getString("usr_codigo");
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return null;
    }

    @Override
    public boolean acaoOk() {
        boolean compromissoRegistrado = false;
        if (this.validaCampos()) {
            String data = Funcoes.formataData("MM/dd/yyyy", this.textData.getText()) + " " + this.textHora.getText();
            this.dataNovoCompromisso = Funcoes.stringToDate("dd/MM/yyyy", this.textData.getText());
            String lembrete = "0";
            if (Funcoes.isNumeric(this.comboLembrete.getSelectedItem().toString().substring(0, this.comboLembrete.getSelectedItem().toString().indexOf(" ")))) {
                lembrete = this.comboLembrete.getSelectedItem().toString().substring(0, this.comboLembrete.getSelectedItem().toString().indexOf(" "));
            }
            String[] destinos = this.textDestinatario.getText().split(",");
            ArrayList<String> usuarioNaoLocalizado = new ArrayList<String>();
            StringBuilder buf = new StringBuilder();
            buf.append("select usr_codigo from usuario order by usr_codigo");
            Statement st = Conexao.getStatement();
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                ArrayList<String> usuariosBanco = new ArrayList<String>();
                String usuario = "";
                while (rs.next()) {
                    usuariosBanco.add(rs.getString("usr_codigo"));
                }
                this.codigoCompromissoPai = this.retornaCodigoPai(st);
                ArrayList<String> usuariosCompromisso = new ArrayList<String>();
                ArrayList<String> usuariosSelecionados = new ArrayList<String>(Arrays.asList(this.textDestinatario.getText().replaceAll(" ", "").split(",")));
                ArrayList<String> usuariosOcupados = this.permiteAgendar(usuariosSelecionados, data, usuariosCompromisso);
                String listaUsuario = Arrays.asList(this.textDestinatario.getText().replaceAll(" ", "").split(",")).toString();
                listaUsuario = listaUsuario.replace("[", "").replace("]", "");
                if (this.compromisso == null && !usuariosOcupados.isEmpty()) {
                    String mensagemAlerta = "O compromisso n\u00e3o ser\u00e1 marcado para os seguintes usu\u00e1rios: " + listaUsuario + ".";
                    Funcoes.mensagem(this.textAssunto.getTopLevelAncestor(), mensagemAlerta, 2);
                    return compromissoRegistrado;
                }
                compromissoRegistrado = this.registrarCompromisso(Variaveis.login, lembrete, data, false);
                for (String s : destinos) {
                    usuario = this.procuraUsuario(usuariosBanco, s);
                    if (Funcoes.textoVazio(usuario)) {
                        usuarioNaoLocalizado.add(s);
                        continue;
                    }
                    if (usuario.equals(Variaveis.login)) continue;
                    compromissoRegistrado = this.usuarios.containsKey(usuario) ? this.registrarCompromisso(usuario, lembrete, data, false) : this.registrarCompromisso(usuario, lembrete, data, true);
                }
                for (int i = 0; i < usuariosSelecionados.size(); ++i) {
                    for (String u : this.usuarios.keySet()) {
                        if (usuariosSelecionados.contains(u) || u.equals(Variaveis.login)) continue;
                        this.removerUsuarioCompromisso(u, lembrete, data);
                    }
                }
                return compromissoRegistrado;
            }
            catch (SQLException e) {
                Conexao.fecharStatement(st);
            }
        }
        return false;
    }

    private ArrayList<String> permiteAgendar(ArrayList<String> usuarios, String data, ArrayList<String> usuariosCompromisso) {
        ArrayList<String> usuariosBloqueados = new ArrayList<String>();
        ArrayList<Compromisso> usuariosCompromissados = this.buscaCompromissos(data);
        int contador = 0;
        int horaAnterior = 0;
        for (String usuario : usuarios) {
            for (Compromisso compromisso : usuariosCompromissados) {
                if (!compromisso.getUsuario().equals(usuario) || horaAnterior != 0 && Funcoes.retornaHora(compromisso.getDataHora()) != horaAnterior) continue;
                ++contador;
                horaAnterior = Funcoes.retornaHora(compromisso.getDataHora());
                if (usuariosCompromisso.contains(compromisso.getUsuario())) continue;
                usuariosCompromisso.add(compromisso.getUsuario());
            }
            if (contador >= 4) {
                usuariosBloqueados.add(usuario);
            }
            contador = 0;
        }
        return usuariosBloqueados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Compromisso> buscaCompromissos(String data) {
        ArrayList<Compromisso> usuariosCompromissados = new ArrayList<Compromisso>();
        StringBuilder buf = new StringBuilder();
        buf.append("select uco_codigo, uco_datahora, uco_duracao, uco_titulo, uco_tempolembrete, uco_lembrado, uco_encerramento, uco_assunto, usr_codigo, uco_codigopai from usuariocompromisso ");
        buf.append(" where uco_datahora= '").append(data).append("' ");
        buf.append(" order by uco_datahora ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            usuariosCompromissados.clear();
            while (rs.next()) {
                Compromisso compromisso = new Compromisso();
                compromisso.setCodigo(rs.getInt("uco_codigo"));
                compromisso.setDataHora(rs.getTimestamp("uco_datahora"));
                compromisso.setDuracao(rs.getInt("uco_duracao"));
                compromisso.setTitulo(rs.getString("uco_titulo"));
                compromisso.setAssunto(rs.getString("uco_assunto"));
                compromisso.setTempoLembrete(rs.getInt("uco_tempolembrete"));
                compromisso.setLembrado(rs.getBoolean("uco_lembrado"));
                compromisso.setUsuario(rs.getString("usr_codigo"));
                compromisso.setCodigoPai(rs.getInt("uco_codigopai"));
                if (rs.getTimestamp("uco_encerramento") != null) {
                    compromisso.setEncerramento(rs.getTimestamp("uco_encerramento"));
                }
                usuariosCompromissados.add(compromisso);
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "PanelUsuario: 652");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return usuariosCompromissados;
    }

    private String procuraUsuario(ArrayList<String> usuarios, String usuario) {
        String retorno = "";
        for (String s : usuarios) {
            if (!s.equalsIgnoreCase(usuario.trim())) continue;
            retorno = s;
            break;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registrarCompromisso(String usuario, String lembrete, String data, boolean adicionadoNovoDestinatario) {
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        if (this.compromisso == null || adicionadoNovoDestinatario) {
            buf.append("insert into usuariocompromisso(usr_codigo, uco_datahora, uco_duracao, uco_titulo, uco_assunto, uco_tempolembrete, uco_lembrado");
            if (!usuario.equals(Variaveis.login)) {
                buf.append(", uco_codigopai");
            } else {
                buf.append(", uco_codigo");
            }
            buf.append(") values (");
            buf.append("'").append(StringUtil.textoDB(usuario)).append("', ");
            buf.append("'").append(data).append("', ");
            buf.append(this.textDuracao.getText()).append(", ");
            buf.append("'").append(StringUtil.textoDB(this.textTitulo.getText())).append("', ");
            buf.append("'").append(StringUtil.textoDB(this.textAssunto.getText())).append("', ");
            buf.append(lembrete).append(", ");
            buf.append("false").append(",");
            buf.append(this.codigoCompromissoPai).append(")");
        } else {
            buf.append("update usuariocompromisso set ");
            buf.append("uco_datahora = '").append(data).append("', ");
            buf.append("uco_duracao = ").append(this.textDuracao.getText()).append(", ");
            buf.append("uco_titulo = '").append(StringUtil.textoDB(this.textTitulo.getText())).append("', ");
            buf.append("uco_assunto = '").append(StringUtil.textoDB(this.textAssunto.getText())).append("', ");
            buf.append("uco_tempolembrete = '").append(lembrete).append("', ");
            buf.append("uco_lembrado = ");
            String lembrado = "false";
            buf.append(lembrado);
            if (!usuario.equals(Variaveis.login)) {
                buf.append(", uco_codigopai = ").append(this.codigoCompromissoPai);
            }
            buf.append(" where uco_codigo = ").append(this.compromisso.getCodigo());
            buf.append(" or uco_codigopai = ").append(this.compromisso.getCodigo());
        }
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf);
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            boolean bl;
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelUsuario: 956");
                bl = false;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return bl;
        }
        Conexao.fecharStatement(st);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removerUsuarioCompromisso(String usuario, String lembrete, String data) {
        if (this.compromisso == null) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("delete from usuariocompromisso ");
        buf.append(" where usr_codigo = '").append(StringUtil.textoDB(usuario)).append("'");
        Statement st = Conexao.getStatement();
        try {
            Conexao.execute(Variaveis.filialPadrao, st, buf);
            Conexao.arquivaSQL();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AgendarCompromisso.this.revalidate();
                    AgendarCompromisso.this.repaint();
                }
            });
        }
        catch (Exception e) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "PanelUsuario: 956");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String retornaCodigoPai(Statement st) {
        String codigo = "-1";
        try {
            if (this.compromisso == null) {
                ResultSet rs = Conexao.executeQuery(st, "select nextval('usuariocompromisso_uco_codigo_seq')");
                if (rs != null && rs.next()) {
                    codigo = rs.getString(1);
                }
            } else {
                codigo = String.valueOf(this.compromisso.getCodigo());
            }
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        return codigo;
    }

    private boolean validaCampos() {
        if (Funcoes.textoVazio(this.textData.getText())) {
            Funcoes.mensagem(this, "Data n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (!Funcoes.verificaData(this.textData.getText())) {
            Funcoes.mensagem(this, "Data inv\u00e1lida", 1);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (Funcoes.textoVazio(this.textHora.getText())) {
            Funcoes.mensagem(this, "Hora n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textHora);
            return false;
        }
        if (!Funcoes.verificaHora(this.textHora.getText())) {
            Funcoes.mensagem(this, "Hora inv\u00e1lida", 1);
            ScreenUtil.requisitarFoco(this.textHora);
            return false;
        }
        if (Funcoes.stringToDate("dd/MM/yyyy HH:mm", this.textData.getText() + " " + this.textHora.getText()).compareTo(new Date()) < 0 && this.compromisso == null) {
            Funcoes.mensagem(this, "N\u00e3o \u00e9 poss\u00edvel agendar um compromisso para uma data/hora anterior a data/hora atual", 1);
            ScreenUtil.requisitarFoco(this.textData);
            return false;
        }
        if (Funcoes.textoVazio(this.textDuracao.getText())) {
            Funcoes.mensagem(this, "Dura\u00e7\u00e3o do compromisso n\u00e3o informada", 1);
            ScreenUtil.requisitarFoco(this.textDuracao);
            return false;
        }
        if (!Funcoes.isNumeric(this.textDuracao.getText())) {
            Funcoes.mensagem(this, "Dura\u00e7\u00e3o inv\u00e1lida", 1);
            ScreenUtil.requisitarFoco(this.textDuracao);
            return false;
        }
        if (Funcoes.textoVazio(this.textTitulo.getText())) {
            Funcoes.mensagem(this, "T\u00edtulo n\u00e3o informado", 1);
            ScreenUtil.requisitarFoco(this.textTitulo);
            return false;
        }
        return this.comboLembrete.getSelectedIndex() != 0 || Funcoes.mensagem(this, "O compromisso n\u00e3o ser\u00e1 lembrado, deseja continuar assim mesmo?", 4) != 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDestinatario) {
            this.menuPara.show(this.buttonDestinatario, this.buttonDestinatario.getX(), 0 + this.buttonDestinatario.getHeight());
        } else if (e.getSource() == this.buttonData) {
            Funcoes.mostraData(this.textData, this.buttonData, this.getPanelCentral(), true);
        } else if (e.getSource() == this.itemUsuario) {
            this.selecionarUsuario();
        } else if (e.getSource() == this.itemTipoUsuario) {
            this.selecionarTipoUsuario();
        } else {
            super.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selecionarTipoUsuario() {
        DialogoFiltro fil = new DialogoFiltro(this, "Selecionar tipo", true);
        fil.setDados("tipousuario", new String[]{"tpu_codigo", "tpu_descricao"}, new String[]{"C\u00f3digo", "Descri\u00e7\u00e3o"}, new int[]{70, 0}, "");
        fil.setVisible(true);
        String[] selecao = fil.getSelecionados(0);
        if (selecao != null && selecao.length > 0) {
            Statement st = Conexao.getStatement();
            try {
                StringBuilder buf = new StringBuilder();
                buf.append("select usr_codigo from usuario where tpu_codigo in (");
                for (int i = 0; i < selecao.length; ++i) {
                    buf.append(selecao[i]);
                    if (i >= selecao.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(") and (usr_inativo is null or usr_inativo = false) ");
                ResultSet rs = Conexao.executeQuery(st, buf);
                buf.delete(0, buf.length());
                buf.append(this.textDestinatario.getText().trim());
                while (rs.next()) {
                    if (!Funcoes.textoVazio(buf.toString()) && !this.textDestinatario.getText().trim().contains(rs.getString("usr_codigo"))) {
                        buf.append(", ");
                    }
                    if (this.textDestinatario.getText().trim().contains(rs.getString("usr_codigo"))) continue;
                    buf.append(rs.getString("usr_codigo"));
                }
                this.textDestinatario.setText(buf.toString());
            }
            catch (Exception ex) {
                try {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "NovaMensagem (186)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
    }

    private void selecionarUsuario() {
        DialogoFiltro fil = new DialogoFiltro(this, "Selecionar usu\u00e1rio", true);
        HashMap<Integer, String[]> map = new HashMap<Integer, String[]>();
        String destinatarios = this.textDestinatario.getText().trim();
        if (!Funcoes.textoVazio(destinatarios)) {
            map.put(new Integer(0), destinatarios.replaceAll(" ", "").split(","));
        }
        fil.setDados(map, " usuario a left join tipousuario b on a.tpu_codigo = b.tpu_codigo ", new String[]{"usr_codigo", "usr_nome", "tpu_descricao"}, new String[]{"Usu\u00e1rio", "Nome", "Tipo"}, new int[]{90, 0, 120}, " (a.usr_inativo = false or a.usr_inativo is null)");
        fil.setVisible(true);
        String[] selecao = fil.getSelecionados(0);
        StringBuilder buf = new StringBuilder();
        for (String s : selecao) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(s);
        }
        this.textDestinatario.setText(buf.toString());
    }
}

