/*
 * Decompiled with CFR 0.152.
 */
package jalis.atualizacoes;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Scanner;

public class SenhaWeb {
    public static void main(String[] args) {
        int pos = SenhaWeb.achaArgumento("-ip", args);
        if (pos < 0 || args.length < pos + 1) {
            System.out.println("Erro ao executar a atualizacao, o IP do banco nao foi localizado");
        } else if (Funcoes.textoVazio(args[pos + 1]) || !Funcoes.verificaIP(args[pos + 1])) {
            System.out.println("O endereco IP esta incorreto");
        } else {
            Variaveis.ipBanco = args[pos + 1];
            Variaveis.caminhoBanco = "jdbc:postgresql://" + Variaveis.ipBanco + "/jalis";
            Scanner scanner = new Scanner(System.in);
            System.out.println("Opcao de senha:");
            System.out.println("1) Medico");
            System.out.println("2) Convenio");
            System.out.println("3) Requisicao");
            try {
                int opcao = scanner.nextInt();
                if (opcao == 1) {
                    SenhaWeb.atualizaMedico();
                } else if (opcao == 2) {
                    SenhaWeb.atualizaConvenio();
                } else if (opcao == 3) {
                    SenhaWeb.atualizaRequisicao();
                }
                System.out.println("\nFinalizado");
            }
            catch (Exception e) {
                System.exit(0);
            }
        }
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void atualizaMedico() {
        System.out.println("Conectando no ip " + Variaveis.ipBanco);
        System.out.println("Buscando medicos... ");
        StringBuilder buf = new StringBuilder("select med_conselho, med_crm, med_uf, fil_codigo, med_senhaweb from medico");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                StringBuilder b = new StringBuilder("update medico set med_senhaweb = ? where ");
                b.append("fil_codigo = ? and ");
                b.append("med_conselho = ?  and ");
                b.append("med_crm = ?  and ");
                b.append("med_uf = ? ");
                PreparedStatement pst = Conexao.getPreparedStatement(b.toString());
                long qtde = DBUtil.qtdeRegistros(rs);
                int contador = 1;
                System.out.println("Localizado " + qtde + " registro(s)");
                while (rs.next()) {
                    int fil_codigo = rs.getInt("fil_codigo");
                    String med_conselho = rs.getString("med_conselho");
                    String med_crm = rs.getString("med_crm");
                    String med_uf = rs.getString("med_uf");
                    String senha = Funcoes.gerarSenhaWeb();
                    pst.setString(1, senha);
                    pst.setInt(2, fil_codigo);
                    pst.setString(3, med_conselho);
                    pst.setString(4, med_crm);
                    pst.setString(5, med_uf);
                    if (Funcoes.textoVazio(rs.getString("med_senhaweb"))) {
                        pst.execute();
                    }
                    System.out.print("Atualizando " + contador++ + "/" + qtde + "      \r");
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void atualizaConvenio() {
        System.out.println("Conectando no ip " + Variaveis.ipBanco);
        System.out.println("Buscando convenios... ");
        StringBuilder buf = new StringBuilder("select con_codigo, fil_codigo, con_senhaweb from convenios");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                StringBuilder b = new StringBuilder("update convenios set con_senhaweb = ? where ");
                b.append("fil_codigo = ? and ");
                b.append("con_codigo = ?");
                PreparedStatement pst = Conexao.getPreparedStatement(b.toString());
                long qtde = DBUtil.qtdeRegistros(rs);
                long media = 0L;
                int contador = 1;
                System.out.println("Localizado " + qtde + " registro(s)");
                while (rs.next()) {
                    int fil_codigo = rs.getInt("fil_codigo");
                    int con_codigo = rs.getInt("con_codigo");
                    String senha = Funcoes.gerarSenhaWeb();
                    pst.setString(1, senha);
                    pst.setInt(2, fil_codigo);
                    pst.setInt(3, con_codigo);
                    if (Funcoes.textoVazio(rs.getString("con_senhaweb"))) {
                        pst.execute();
                    }
                    System.out.print("Atualizando " + contador++ + "/" + qtde + "      \r");
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void atualizaRequisicao() {
        System.out.println("Conectando no ip " + Variaveis.ipBanco);
        System.out.println("Buscando requisicoes... ");
        StringBuilder buf = new StringBuilder("select req_codigo, fil_codigo, req_senhaweb from requisicao where req_excluida = false");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                StringBuilder b = new StringBuilder("update requisicao set req_senhaweb = ? where ");
                b.append("fil_codigo = ? and ");
                b.append("req_codigo = ?");
                PreparedStatement pst = Conexao.getPreparedStatement(b.toString());
                long qtde = DBUtil.qtdeRegistros(rs);
                long media = 0L;
                int contador = 1;
                System.out.println("Localizado " + qtde + " registro(s)");
                while (rs.next()) {
                    int fil_codigo = rs.getInt("fil_codigo");
                    int req_codigo = rs.getInt("req_codigo");
                    String senha = Funcoes.gerarSenhaWeb();
                    pst.setString(1, senha);
                    pst.setInt(2, fil_codigo);
                    pst.setInt(3, req_codigo);
                    if (Funcoes.textoVazio(rs.getString("req_senhaweb"))) {
                        pst.execute();
                    }
                    System.out.print("Atualizando " + contador++ + "/" + qtde + "      \r");
                }
            }
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
    }
}

