/*
 * Decompiled with CFR 0.152.
 */
package jalis.atualizacoes;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;

public class Banco29_10_2008 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int pos = Banco29_10_2008.achaArgumento("-ip", args);
        if (pos < 0 || args.length < pos + 1) {
            System.out.println("Erro ao executar a atualizacao, o IP do banco nao foi localizado");
            return;
        }
        if (Funcoes.textoVazio(args[pos + 1]) || !Funcoes.verificaIP(args[pos + 1])) {
            System.out.println("O endereco IP esta incorreto");
            return;
        }
        Variaveis.ipBanco = args[pos + 1];
        Variaveis.caminhoBanco = "jdbc:postgresql://" + Variaveis.ipBanco + "/jalis";
        System.out.println("Conectando no ip " + Variaveis.ipBanco);
        System.out.println("Buscando registros... ");
        StringBuilder buf = new StringBuilder("select * from examerequisicaorecipiente where ere_tipo is null or ere_tipo = '' order by fil_codigo, req_codigo limit 50000");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder atualizando = new StringBuilder("");
        try {
            ResultSet rs = st.executeQuery(buf.toString());
            StringBuilder b = new StringBuilder("update examerequisicaorecipiente set ere_tipo = 'C' where ");
            b.append("fil_codigo = ? and ");
            b.append("exa_codigo = ?  and ");
            b.append("mco_codigo = ?  and ");
            b.append("req_codigo = ?  and ");
            b.append("rec_codigo = ?");
            PreparedStatement pst = Conexao.getPreparedStatement(b.toString());
            boolean executar = true;
            while (executar) {
                long qtde = DBUtil.qtdeRegistros(rs);
                long media = 0L;
                int contador = 1;
                System.out.println("Localizado " + qtde + " registro(s)");
                String tempo = "";
                Date d1 = new Date();
                Date d2 = new Date();
                Date corrido = new Date();
                while (rs.next()) {
                    int fil_codigo = rs.getInt("fil_codigo");
                    String exa_codigo = rs.getString("exa_codigo");
                    int mco_codigo = rs.getInt("mco_codigo");
                    long req_codigo = rs.getLong("req_codigo");
                    int rec_codigo = rs.getInt("rec_codigo");
                    atualizando.setLength(0);
                    atualizando.append("Atualizando requisicao ");
                    atualizando.append(req_codigo).append(" - ").append(exa_codigo);
                    pst.setInt(1, fil_codigo);
                    pst.setString(2, exa_codigo);
                    pst.setInt(3, mco_codigo);
                    pst.setLong(4, req_codigo);
                    pst.setInt(5, rec_codigo);
                    d1 = new Date();
                    pst.execute();
                    d2 = new Date();
                    if (contador <= 20) {
                        media += d2.getTime() - d1.getTime();
                        ++contador;
                    }
                    if (contador <= 20) continue;
                    if (Funcoes.textoVazio(tempo)) {
                        tempo = Funcoes.formataData("m:s", new Date(media / 21L * (qtde - (long)contador)));
                        System.out.println("Tempo estimado de " + tempo + " minutos");
                    }
                    String t = Funcoes.formataData("m:s", new Date(d2.getTime() - corrido.getTime()));
                    System.out.print("Atualizando " + contador++ + "/" + qtde + "(" + t + ")      \r");
                }
                Conexao.arquivaSQL();
                System.out.println("\nExecutando nova consulta...");
                rs = st.executeQuery(buf.toString());
                executar = rs.next();
            }
            System.out.println("\nFinalizado");
        }
        catch (Exception e) {
            try {
                System.out.println(atualizando);
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
            return;
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return;
    }

    private static long diferenca(Date d1, Date d2) {
        return (d2.getTime() - d1.getTime()) * 24L * 60L * 60L * 1000L;
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }
}

