/*
 * Decompiled with CFR 0.152.
 */
package jalis.atualizacoes;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Scanner;

public class Banco19_11_2008 {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        int pos = Banco19_11_2008.achaArgumento("-ip", args);
        if (pos < 0 || args.length < pos + 1) {
            System.out.println("Erro ao executar a atualizacao, o IP do banco nao foi localizado");
            return;
        }
        if (Funcoes.textoVazio(args[pos + 1]) || !Funcoes.verificaIP(args[pos + 1])) {
            System.out.println("O endereco IP esta incorreto");
            return;
        }
        Variaveis.ipBanco = args[pos + 1];
        Variaveis.caminhoBanco = "jdbc:postgresql://" + Variaveis.ipBanco + "/jalis";
        System.out.println("Conectando no ip " + Variaveis.ipBanco);
        System.out.println("Buscando registros... ");
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        try {
            Scanner scanner = new Scanner(System.in);
            System.out.print("\nDeseja executar a atualizacao no campo usr_codrecoletatemp?[S/n]");
            String x = scanner.next();
            if (x.equalsIgnoreCase("S")) {
                Banco19_11_2008.atualizar(st, st2, "usr_codrecoleta", "usr_codrecoletatemp");
            }
            System.out.print("\nDeseja remover o campo usr_codrecoleta?[S/n]");
            x = scanner.next();
            if (x.equalsIgnoreCase("S")) {
                System.out.println("\nRemovendo o campo antigo...");
                st.execute("alter table examerequisicao drop usr_codrecoleta, add usr_codrecoleta varchar(20)");
            }
            System.out.print("\nDeseja executar a atualizacao no campo usr_codrecoleta?[S/n]");
            x = scanner.next();
            if (x.equalsIgnoreCase("S")) {
                Banco19_11_2008.atualizar(st, st2, "usr_codrecoletatemp", "usr_codrecoleta");
            }
            System.out.print("\nDeseja remover o campo usr_codrecoletatemp?[S/n]");
            x = scanner.next();
            if (x.equalsIgnoreCase("S")) {
                System.out.println("\nRemovendo o campo temporario...");
                st.execute("alter table examerequisicao drop usr_codrecoletatemp");
            }
            Conexao.arquivaSQL();
            System.out.println("\nFinalizado");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                Conexao.fecharStatement(st2);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            Conexao.fecharStatement(st2);
            return;
        }
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return;
    }

    private static void atualizar(Statement st, Statement st2, String campoorigem, String campodestino) throws SQLException {
        StringBuilder buf = new StringBuilder("select fil_codigo, req_codigo, exa_codigo, mco_codigo from examerequisicao order by fil_codigo, req_codigo limit 100");
        ResultSet rs = st.executeQuery(buf.toString());
        StringBuilder b = new StringBuilder("update examerequisicao set ");
        b.append(campodestino).append(" = ").append(campoorigem).append(" where ");
        b.append("fil_codigo = ? and ");
        b.append("exa_codigo = ?  and ");
        b.append("mco_codigo = ?  and ");
        b.append("req_codigo = ?  ");
        PreparedStatement pst = Conexao.getPreparedStatement(b.toString());
        long qtde = DBUtil.qtdeRegistros(rs);
        long media = 0L;
        int contador = 1;
        System.out.println("Localizado " + qtde + " registro(s)");
        String tempo = "";
        Date d1 = new Date();
        Date d2 = new Date();
        Date corrido = new Date();
        while (rs.next()) {
            int fil_codigo = rs.getInt("fil_codigo");
            String exa_codigo = rs.getString("exa_codigo");
            int mco_codigo = rs.getInt("mco_codigo");
            long req_codigo = rs.getLong("req_codigo");
            pst.setInt(1, fil_codigo);
            pst.setString(2, exa_codigo);
            pst.setInt(3, mco_codigo);
            pst.setLong(4, req_codigo);
            d1 = new Date();
            pst.execute();
            d2 = new Date();
            if (contador <= 20) {
                media += d2.getTime() - d1.getTime();
                ++contador;
            }
            if (contador <= 20) continue;
            if (Funcoes.textoVazio(tempo)) {
                tempo = Funcoes.formataData("m:s", new Date(media / 21L * (qtde - (long)contador)));
                System.out.println("Tempo estimado de " + tempo + " minutos");
            }
            String t = Funcoes.formataData("m:s", new Date(d2.getTime() - corrido.getTime()));
            System.out.print("Atualizando " + contador++ + "/" + qtde + "(" + t + ")      \r");
        }
    }

    private static long diferenca(Date d1, Date d2) {
        return (d2.getTime() - d1.getTime()) * 24L * 60L * 60L * 1000L;
    }

    private static int achaArgumento(String argumento, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(argumento)) continue;
            return i;
        }
        return -1;
    }
}

