/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.util;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.exportacao.thread.ExportaWeb2;
import jalis.laboratorio.resultados.ImpressaoResultados;
import jalis.laboratorio.resultados.RetornoImpressaoResultados;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ArraysUtil;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;

public class Util {
    public static final int BANCO_PGSQL = 1;
    public static final int BANCO_HSQLDB = 2;
    public static final int BANCO_FIREBIRD = 2;
    public static final int LOG_CONVENIO = 1;
    public static final int LOG_PACIENTE = 2;
    public static final String MM_DD_YYYY = "MM/dd/yyyy";
    public static final String DD_MM_YYYY = "dd/MM/yyyy";
    public static final String YYYY_MM_DD = "yyyy/MM/dd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";

    public static String criaXML(String root, ResultSet rs) throws SQLException {
        StringBuilder bui = new StringBuilder();
        while (rs.next()) {
            bui.append("<").append(root).append(">");
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                String coluna = rs.getMetaData().getColumnName(i).toLowerCase();
                bui.append("<campo><nome>");
                bui.append(coluna);
                bui.append("</nome><tipo>");
                bui.append(rs.getMetaData().getColumnType(i));
                bui.append("</tipo><valor>");
                bui.append(rs.getString(coluna));
                bui.append("</valor><chave>");
                bui.append("1");
                bui.append("</campo>");
                bui.append(StringUtil.getTag(coluna, Util.testaTipo(rs.getObject(coluna), rs.getMetaData().getColumnType(i))));
            }
            bui.append("</").append(root).append(">");
        }
        return bui.toString();
    }

    private static String testaTipo(Object valor, int tipo) {
        String retorno;
        if (valor == null || valor instanceof String && (Funcoes.textoVazio(valor.toString()) || valor.toString().equalsIgnoreCase("null"))) {
            return "null";
        }
        switch (tipo) {
            case -7: 
            case 16: {
                if (Boolean.valueOf(valor.toString()).booleanValue()) {
                    retorno = "true";
                    break;
                }
                retorno = "false";
                break;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (Funcoes.isNumeric(valor.toString())) {
                    retorno = Funcoes.limpaDecimal(valor.toString());
                    break;
                }
                retorno = "null";
                break;
            }
            case 91: {
                String temp = Funcoes.formataData((Date)valor);
                if (Funcoes.verificaData(YYYY_MM_DD, temp)) {
                    retorno = Funcoes.formataData(DD_MM_YYYY, temp);
                    break;
                }
                retorno = "null";
                break;
            }
            case 92: {
                String temp = Funcoes.formataHora((Time)valor, false);
                if (Funcoes.verificaHora(temp)) {
                    retorno = Funcoes.formataHora((Time)valor, true);
                    break;
                }
                retorno = "null";
                break;
            }
            case 93: {
                if (valor instanceof Timestamp) {
                    retorno = Funcoes.formataData(YYYY_MM_DD_HH_MM_SS, (Timestamp)valor);
                    break;
                }
                retorno = "null";
                break;
            }
            default: {
                retorno = valor.toString();
            }
        }
        return retorno;
    }

    public static String geraInsert(String tabela, String xml, int banco) {
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela)) {
            return "";
        }
        String[] valores = StringUtil.getValores(xml, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            bufC.append(campo);
            bufV.append(Util.checkTipo(valor, tipo, banco));
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        return bufC.append(bufV.toString()).append(")").toString();
    }

    public static String[] geraInsertPaciente(String xml, String filial, String codigoConvenio) throws Exception {
        Statement st = Conexao.getStatement();
        String[] insert = Util.geraInsertPaciente(xml, filial, codigoConvenio, st);
        Conexao.fecharStatement(st);
        return insert;
    }

    public static String[] geraInsertPaciente(String xml, String filial, String codigoConvenio, Statement st) throws Exception {
        String campos;
        String codigo;
        String codigoOriginal = codigo = Util.getCodigoXML(xml, "ple_codigo");
        String tabela = "paciente";
        if (Funcoes.textoVazio(codigo) || DBUtil.campoNull(codigo)) {
            codigoOriginal = codigo = DBUtil.getSequencia(st, "paciente", filial);
            codigo = DBUtil.formatarValorParaIntegracao(filial, codigo, !ParametrosGerais.getTipoIntegracao().equals("N"), 7);
        }
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return new String[]{"", ""};
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("pac_codigo")) {
                valor = xml.toUpperCase().indexOf("PAC_CODIGOAPOIADO") > 0 ? Util.getCodigoXML(xml, "pac_codigoapoiado") : codigo;
            } else if (campo.equalsIgnoreCase("ple_codigo")) {
                campo = "pac_codigoapoiado";
                valor = Util.getCodigoXML(xml, "pac_codigo");
            } else {
                if (campo.equalsIgnoreCase("pac_codigoapoiado")) continue;
                if (campo.equalsIgnoreCase("pac_fumante") || campo.equalsIgnoreCase("pac_diabetico")) {
                    tipo = 0;
                    valor = valor.equalsIgnoreCase("T") || valor.equalsIgnoreCase("S") || valor.equalsIgnoreCase("true") ? "S" : "N";
                }
            }
            bufC.append(campo);
            bufV.append(Util.checkTipo(valor, tipo, 1));
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        if (!Funcoes.textoVazio(filial)) {
            bufC.append(", fil_codigo");
            bufV.append(", ");
            bufV.append(filial);
            bufC.append(", usr_codigo");
            bufV.append(", '");
            bufV.append(ParametrosLocais.getParametro("usuarioPadraoRMI"));
            bufV.append("'");
            bufC.append(", pac_senhaweb");
            bufV.append(", '");
            bufV.append(Funcoes.gerarSenhaWeb());
            bufV.append("'");
        }
        bufC.append(", con_codigo, usr_codalteracao, pac_datahoraalteracao");
        bufV.append(", ").append(codigoConvenio);
        bufV.append(", '").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("'");
        bufV.append(", current_timestamp");
        return new String[]{bufC.append(bufV.toString()).append(")").toString(), codigo, codigoOriginal};
    }

    public static String getCodigoXML(String xml, String chave) {
        String[] campos;
        for (String s : campos = StringUtil.getValores(xml, "campo")) {
            String campo = StringUtil.getValor(s, "nome");
            if (!campo.equalsIgnoreCase(chave)) continue;
            return StringUtil.getValor(s, "valor");
        }
        return "";
    }

    public static String geraUpdate(String tabela, String xml, int banco, HashMap<String, String> novosValores, boolean removerResposta) {
        StringBuilder bufU = new StringBuilder("update ").append(tabela).append(" set ");
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela)) {
            return "";
        }
        String[] temp = StringUtil.getValores(xml, "campo");
        String[] chaves = new String[1];
        String[] valores = new String[1];
        for (String s : temp) {
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            if (pk) {
                if (Funcoes.textoVazio(chaves[0])) {
                    chaves[0] = s;
                    continue;
                }
                chaves = ArraysUtil.concatenar(chaves, new String[]{s});
                continue;
            }
            if (Funcoes.textoVazio(valores[0])) {
                valores[0] = s;
                continue;
            }
            valores = ArraysUtil.concatenar(valores, new String[]{s});
        }
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (novosValores != null && novosValores.containsKey(campo)) {
                valor = novosValores.get(campo);
            }
            if (removerResposta && campo.equalsIgnoreCase("exr_resposta")) continue;
            bufU.append(campo);
            bufU.append(" = ");
            bufU.append(Util.checkTipo(valor, tipo, banco));
            if (i >= valores.length - 1) continue;
            bufU.append(", ");
        }
        String s = bufU.toString();
        if (s.endsWith(", ")) {
            bufU.setLength(0);
            bufU.append(s.substring(0, s.length() - 2));
        }
        for (int i = 0; i < chaves.length; ++i) {
            s = chaves[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (novosValores != null && novosValores.containsKey(campo)) {
                valor = novosValores.get(campo);
            }
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            bufW.append(Util.checkTipo(valor, tipo, banco));
        }
        return bufU.append(bufW.toString()).toString();
    }

    public static String geraUpdate(String tabela, String xml, int banco, boolean removerResposta) {
        return Util.geraUpdate(tabela, xml, banco, null, removerResposta);
    }

    public static String geraUpdate(String tabela, String xml, int banco) {
        return Util.geraUpdate(tabela, xml, banco, false);
    }

    public static String geraUpdatePaciente(String xml, String filial, String codigoConvenio) {
        Statement st = Conexao.getStatement();
        String update = Util.geraUpdatePaciente(xml, filial, codigoConvenio, st);
        Conexao.fecharStatement(st);
        return update;
    }

    public static String geraUpdatePaciente(String xml, String filial, String codigoConvenio, Statement st) {
        int i;
        String campos;
        String tabela = "paciente";
        StringBuilder bufU = new StringBuilder("update ").append(tabela).append(" set ");
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return "";
        }
        String[] temp = StringUtil.getValores(campos, "campo");
        String[] chaves = new String[1];
        String[] valores = new String[1];
        for (String s : temp) {
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            if (pk) {
                if (Funcoes.textoVazio(chaves[0])) {
                    chaves[0] = s;
                    continue;
                }
                chaves = ArraysUtil.concatenar(chaves, new String[]{s});
                continue;
            }
            if (Funcoes.textoVazio(valores[0])) {
                valores[0] = s;
                continue;
            }
            valores = ArraysUtil.concatenar(valores, new String[]{s});
        }
        for (i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("ple_codigo") || campo.equalsIgnoreCase("pac_codigoapoiado")) continue;
            if (campo.equalsIgnoreCase("pac_fumante") || campo.equalsIgnoreCase("pac_diabetico")) {
                tipo = 0;
                valor = valor.equalsIgnoreCase("T") || valor.equalsIgnoreCase("S") || valor.equalsIgnoreCase("true") ? "S" : "N";
            }
            bufU.append(campo);
            bufU.append(" = ");
            if (campo.equalsIgnoreCase("pac_codigo")) {
                bufU.append(Util.checkTipo(Util.getCodigoXML(xml, "ple_codigo"), tipo, 2));
            } else {
                bufU.append(Util.checkTipo(valor, tipo, 1));
            }
            if (i >= valores.length - 1) continue;
            bufU.append(", ");
        }
        for (i = 0; i < chaves.length; ++i) {
            String s = chaves[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("ple_codigo") || campo.equalsIgnoreCase("pac_codigoapoiado")) continue;
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            if (campo.equalsIgnoreCase("pac_codigo")) {
                if (xml.toUpperCase().indexOf("PAC_CODIGOAPOIADO") > 0) {
                    bufW.append(Util.checkTipo(Util.getCodigoXML(xml, "pac_codigoapoiado"), tipo, 2));
                    continue;
                }
                bufW.append(Util.checkTipo(Util.getCodigoXML(xml, "ple_codigo"), tipo, 1));
                continue;
            }
            bufW.append(Util.checkTipo(valor, tipo, 1));
        }
        if (!Funcoes.textoVazio(filial)) {
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(" fil_codigo = ");
            bufW.append(filial);
        }
        if (codigoConvenio != null && !codigoConvenio.isEmpty()) {
            bufW.append(bufW.indexOf("where") > 0 ? " and " : " where ");
            bufW.append(" con_codigo = ").append(codigoConvenio);
        }
        return bufU.append(bufW.toString()).toString();
    }

    public static String geraSelect(String tabela, String xml) {
        StringBuilder buf = new StringBuilder("select ");
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela)) {
            return "";
        }
        String[] temp = StringUtil.getValores(xml, "campo");
        String[] chaves = new String[1];
        for (String s : temp) {
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            if (!pk) continue;
            if (Funcoes.textoVazio(chaves[0])) {
                chaves[0] = s;
                continue;
            }
            chaves = ArraysUtil.concatenar(chaves, new String[]{s});
        }
        for (int i = 0; i < chaves.length; ++i) {
            String s = chaves[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            buf.append(campo);
            if (i < chaves.length - 1) {
                buf.append(", ");
            }
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            bufW.append(Util.checkTipo(valor, tipo, 1));
        }
        return buf.append(" from ").append(tabela).append(bufW.toString()).toString();
    }

    public static String geraDelete(String tabela, String xml) {
        StringBuilder bufD = new StringBuilder("delete from ").append(tabela);
        StringBuilder bufW = new StringBuilder(" ");
        if (Funcoes.textoVazio(tabela)) {
            return "";
        }
        String[] valores = StringUtil.getValores(xml, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            boolean pk = StringUtil.getValor(s, "chave").equalsIgnoreCase("1");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equals("fil_codcopia") || campo.equals("req_codcopia") || !pk) continue;
            if (bufW.indexOf("where") > 0) {
                bufW.append(" and ");
            } else {
                bufW.append(" where ");
            }
            bufW.append(campo);
            bufW.append(" = ");
            bufW.append(Util.checkTipo(valor, tipo, 1));
        }
        return bufD.append(bufW.toString()).toString();
    }

    private static String checkTipo(String valor, int tipo, int banco) {
        if (valor == null || Funcoes.textoVazio(valor) || valor.equalsIgnoreCase("null")) {
            return "null";
        }
        String retorno = "";
        switch (tipo) {
            case 4: {
                if (valor.equalsIgnoreCase("t") || valor.equalsIgnoreCase("true")) {
                    retorno = "true";
                    break;
                }
                retorno = "false";
                break;
            }
            case 2: {
                if (Funcoes.isNumeric(valor)) {
                    retorno = valor.replaceAll(",", ".");
                    break;
                }
                retorno = "null";
                break;
            }
            case 1: {
                if (Funcoes.verificaData("yyyy-MM-dd", valor)) {
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 3: {
                if (Funcoes.verificaHora(valor)) {
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            case 5: {
                if (Funcoes.verificaTimestamp(YYYY_MM_DD_HH_MM_SS, valor)) {
                    if (banco == 2) {
                        retorno = "'" + Funcoes.formataData(YYYY_MM_DD_HH_MM_SS, Funcoes.stringToDate(YYYY_MM_DD_HH_MM_SS, valor)) + "'";
                        break;
                    }
                    retorno = "'" + valor + "'";
                    break;
                }
                retorno = "null";
                break;
            }
            default: {
                valor = StringUtil.xmlToTexto(valor);
                retorno = "'" + (banco == 1 ? StringUtil.textoDB(valor) : StringUtil.textoHSQLDB(valor)) + "'";
            }
        }
        return StringUtil.xmlToTexto(retorno);
    }

    public static String[] geraInsertRequisicao(String xml, String filial, String codigoConvenio) throws Exception {
        return Util.geraInsertRequisicao(xml, filial, codigoConvenio, "");
    }

    public static String[] geraInsertRequisicao(String xml, String filial, String codigoConvenio, String codigoRequisicao) throws Exception {
        String campos;
        String codigo;
        Statement st = Conexao.getStatement();
        if (!Funcoes.textoVazio(codigoRequisicao)) {
            codigo = codigoRequisicao;
        } else {
            codigo = Util.getCodigoXML(xml, "rle_codigo");
            if (!Funcoes.textoVazio(codigo) && !codigo.equalsIgnoreCase("null")) {
                StringBuilder b = new StringBuilder();
                b.append("select req_codigo from requisicao where fil_codigo = ").append(filial);
                b.append(" and req_codigo = ").append(codigo);
                b.append(" and con_codigo = ").append(codigoConvenio);
                b.append(" and req_excluida = false ");
                ResultSet rs = Conexao.executeQuery(st, b);
                if (rs.next()) {
                    Conexao.fecharStatement(st);
                    return new String[]{"", codigo};
                }
            }
        }
        String tabela = "requisicao";
        if (Funcoes.textoVazio(codigo) || DBUtil.campoNull(codigo)) {
            codigo = DBUtil.getSequencia(st, "requisicao", filial);
        }
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return new String[]{"", ""};
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        boolean semMedico = !Util.procuraCampoMedico(valores);
        for (int i = 0; i < valores.length; ++i) {
            int tipo;
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int n = tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            if (semMedico && (campo.equalsIgnoreCase("med_crm") || campo.equalsIgnoreCase("med_conselho") || campo.equalsIgnoreCase("med_uf")) || campo.equalsIgnoreCase("req_dtfatura") || campo.equalsIgnoreCase("req_horafatura")) continue;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("req_codigo")) {
                valor = codigo;
            } else if (campo.equalsIgnoreCase("rle_codigo")) {
                campo = "req_codigoapoiado";
                valor = Util.getCodigoXML(xml, "req_codigo");
            }
            bufC.append(campo);
            bufV.append(Util.checkTipo(valor, tipo, 1));
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        if (!Funcoes.textoVazio(filial)) {
            if (!bufC.toString().endsWith(", ")) {
                bufC.append(", ");
                bufV.append(", ");
            }
            bufC.append("fil_codigo");
            bufV.append(filial);
            bufC.append(", usr_codigo");
            bufV.append(", '");
            bufV.append(ParametrosLocais.getParametro("usuarioPadraoRMI"));
            bufV.append("'");
            bufC.append(", usr_codabertura");
            bufV.append(", '");
            bufV.append(ParametrosLocais.getParametro("usuarioPadraoRMI"));
            bufV.append("'");
            bufC.append(", est_codigo");
            bufV.append(", ");
            bufV.append(ParametrosLocais.getParametro("estacaoPadraoRMI"));
            bufC.append(", req_senhaweb");
            bufV.append(", '");
            bufV.append(Funcoes.gerarSenhaWeb());
            bufV.append("'");
            bufC.append(", req_deveguia");
            bufV.append(", false");
            bufC.append(", req_excluida");
            bufV.append(", false");
            bufC.append(", req_dtfatura");
            bufV.append(", current_date");
            bufC.append(", req_horafatura");
            bufV.append(", '").append(Funcoes.formataData("HH:mm:ss", new java.util.Date())).append("'");
            String medicoConselhoPadrao = ParametrosLocais.getParametro("medicoConselhoPadraoRMI");
            String medicoCrmPadrao = ParametrosLocais.getParametro("medicoCrmPadraoRMI");
            String medicoUFPadrao = ParametrosLocais.getParametro("medicoUFPadraoRMI");
            if (semMedico) {
                bufC.append(", med_conselho");
                bufV.append(", '");
                bufV.append(StringUtil.textoDB(medicoConselhoPadrao));
                bufV.append("'");
                bufC.append(", med_crm");
                bufV.append(", '");
                bufV.append(StringUtil.textoDB(medicoCrmPadrao));
                bufV.append("'");
                bufC.append(", med_uf");
                bufV.append(", '");
                bufV.append(StringUtil.textoDB(medicoUFPadrao));
                bufV.append("'");
            }
        }
        if (!Funcoes.textoVazio(codigoConvenio)) {
            DadosConvenios convenio = ConvenioUtil.getDadosConvenios("1", Integer.parseInt(codigoConvenio));
            bufC.append(", col_codigo, des_codigo, con_codigo");
            bufV.append(", '");
            bufV.append(convenio.getCodigoColeta());
            bufV.append("', '");
            bufV.append(convenio.getCodigoDestino());
            bufV.append("', ");
            bufV.append(codigoConvenio);
        }
        String sql = bufC.append(bufV.toString()).append(")").toString();
        return new String[]{sql, codigo};
    }

    private static boolean procuraCampoMedico(String[] campos) {
        for (String s : campos) {
            String campo = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            if (!campo.equalsIgnoreCase("med_crm") || Funcoes.textoVazio(valor)) continue;
            return true;
        }
        return false;
    }

    public static String geraUpdateRequisicao(String xml, String filial, String codigoConvenio) throws Exception {
        return Util.geraUpdate("requisicao", xml, 1);
    }

    public static String geraInsertExameRequisicao(String xml, String filial, String codigoConvenio, String codigoRequisicao) throws Exception {
        return Util.geraInsertExameRequisicao(xml, filial, codigoConvenio, codigoRequisicao, 1);
    }

    public static String geraInsertExameRequisicao(String xml, String filial, String codigoConvenio, String codigoRequisicao, int tipoBanco) throws Exception {
        String tabela = "examerequisicao";
        if (Funcoes.textoVazio(codigoRequisicao) || DBUtil.campoNull(codigoRequisicao)) {
            return "1";
        }
        String campos = "";
        boolean semMetodo = Util.getCodigoXML(xml, "met_codigo") == null || Funcoes.textoVazio(Util.getCodigoXML(xml, "met_codigo"));
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, tabela))) {
            return "2";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("req_codigo")) {
                valor = codigoRequisicao;
            } else if (campo.equalsIgnoreCase("exr_situacao") && !Funcoes.textoVazio(filial)) {
                valor = "F";
            }
            bufC.append(campo);
            bufV.append(Util.checkTipo(valor, tipo, tipoBanco));
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        if (!Funcoes.textoVazio(filial)) {
            bufC.append(", fil_codigo");
            bufV.append(", ");
            bufV.append(filial);
        }
        bufC.append(", usr_codigo");
        bufV.append(", '");
        bufV.append(ParametrosLocais.getParametro("usuarioPadraoRMI"));
        bufV.append("'");
        bufC.append(", exr_excluido");
        bufV.append(", false ");
        bufC.append(", exr_urgente");
        bufV.append(", false ");
        String codExame = Util.pegaCodigoExame(xml);
        String codMaterial = Util.pegaCodigoMaterial(xml);
        if (!Funcoes.textoVazio(filial) && !Funcoes.textoVazio(codExame) && !Funcoes.textoVazio(codMaterial) && Funcoes.isNumeric(codMaterial)) {
            DadosMaterial material = ExameUtil.getDadosMaterial(filial, Integer.parseInt(codMaterial));
            DadosExames exame = ExameUtil.getDadosExame(filial, codExame, material);
            DadosConvenios convenio = ConvenioUtil.getDadosConvenios(filial, Integer.parseInt(codigoConvenio));
            ExameUtil.calculaPrecoExame(filial, exame, material, convenio, false, false, false, Integer.parseInt(codigoRequisicao), null, Integer.parseInt(exame.getCodMetodo()));
            bufC.append(", exr_vlrexame, exr_vlrchexame, exr_vlrch, exr_vlrmaterial, exr_vlrbalcaoconvenio, exr_matexterno");
            bufV.append(", ");
            bufV.append(Funcoes.limpaDecimal(String.valueOf(exame.getValorExame())));
            bufV.append(", ");
            bufV.append(Funcoes.limpaDecimal(String.valueOf(exame.getValorCH())));
            bufV.append(", ");
            bufV.append(Funcoes.limpaDecimal(String.valueOf(convenio.getCH())));
            bufV.append(", ");
            bufV.append(Funcoes.limpaDecimal(String.valueOf(exame.getValorMaterial())));
            bufV.append(", ");
            bufV.append(Funcoes.limpaDecimal(String.valueOf(convenio.getPercentualBalcao())));
            bufV.append(", true");
            if (Funcoes.textoVazio(Util.getCodigoXML(xml, "exr_codexameorigem"))) {
                bufC.append(", exr_codexameorigem, exr_codmatorigem");
                bufV.append(",'").append(codExame).append("'");
                bufV.append(",").append(codMaterial);
            }
            if (semMetodo) {
                bufC.append(", met_codigo");
                bufV.append(",").append(exame.getCodMetodo());
            }
        }
        bufC.append(", exr_custosimples");
        bufV.append(",").append(new RequisicaoService().valorExameCustoSimples(codExame, codMaterial, filial));
        return bufC.append(bufV.toString()).append(")").toString();
    }

    private static String pegaCodigoExame(String xml) {
        return Util.getCodigoXML(xml, "exa_codigo");
    }

    private static String pegaCodigoMaterial(String xml) {
        return Util.getCodigoXML(xml, "mco_codigo");
    }

    public static String geraInsertRequisicaoMedicamento(String xml, String filial, String codigoRequisicao) {
        String tabela = "requisicaomedicamento";
        if (Funcoes.textoVazio(codigoRequisicao) || DBUtil.campoNull(codigoRequisicao)) {
            return "1";
        }
        String campos = "";
        StringBuilder bufC = new StringBuilder("insert into ").append(tabela).append(" (");
        StringBuilder bufV = new StringBuilder(") values (");
        if (Funcoes.textoVazio(tabela) || Funcoes.textoVazio(campos = StringUtil.getValor(xml, "medicamento"))) {
            return "2";
        }
        String[] valores = StringUtil.getValores(campos, "campo");
        for (int i = 0; i < valores.length; ++i) {
            String s = valores[i];
            String campo = StringUtil.getValor(s, "nome");
            int tipo = Funcoes.isNumeric(StringUtil.getValor(s, "tipo")) ? Integer.parseInt(StringUtil.getValor(s, "tipo")) : 0;
            String valor = StringUtil.getValor(s, "valor");
            if (campo.equalsIgnoreCase("req_codigo")) {
                valor = codigoRequisicao;
            }
            bufC.append(campo);
            bufV.append(Util.checkTipo(valor, tipo, 1));
            if (i >= valores.length - 1) continue;
            bufC.append(", ");
            bufV.append(", ");
        }
        bufC.append(", fil_codigo");
        bufV.append(", ");
        bufV.append(filial);
        return bufC.append(bufV.toString()).append(")").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoCidade(Statement st, String cidade) throws Exception {
        String xml = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select cid_codigo, cid_nome, cid_uf from cidades where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and cid_codigo = ");
        buf.append(cidade);
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("cidade", new Registro(rs), new String[]{"cid_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "cidades", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "cidades", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoBairro(Statement st, String bairro) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select bai_codigo, bai_descricao from bairro where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and bai_codigo = '");
        bui.append(StringUtil.textoDB(bairro));
        bui.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("bairro", new Registro(rs), new String[]{"bai_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "bairro", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "bairro", s, 2), true);
        }
    }

    public static void gravaAlteracaoExame(Statement st, String exame) throws Exception {
        StringBuilder bui = new StringBuilder();
        ArrayList<String> convenios = Util.getConvenios();
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : convenios) {
            bui.delete(0, bui.length());
            bui.append("<exame><codigo>");
            bui.append(exame);
            bui.append("</codigo></exame>");
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "exames", s, 1), true);
        }
        for (String s : pacientes) {
            bui.delete(0, bui.length());
            bui.append("<exame><codigo>");
            bui.append(exame);
            bui.append("</codigo></exame>");
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "exames", s, 2), true);
        }
    }

    public static void gravaExclusaoExame(Statement st, String exame, String codigoMaterial) throws Exception {
        StringBuilder bui = new StringBuilder();
        ArrayList<String> convenios = Util.getConvenios();
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : convenios) {
            bui.delete(0, bui.length());
            bui.append("<exame><codigo>");
            bui.append(exame);
            bui.append("</codigo>");
            if (!Funcoes.textoVazio(codigoMaterial)) {
                bui.append("<material>");
                bui.append(codigoMaterial);
                bui.append("</material>");
            }
            bui.append("<operacao>D</operacao></exame>");
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "exames", s, 1), true);
        }
        for (String s : pacientes) {
            bui.delete(0, bui.length());
            bui.append("<exame><codigo>");
            bui.append(exame);
            bui.append("</codigo>");
            if (!Funcoes.textoVazio(codigoMaterial)) {
                bui.append("<material>");
                bui.append(codigoMaterial);
                bui.append("</material>");
            }
            bui.append("<operacao>D</operacao></exame>");
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "exames", s, 2), true);
        }
    }

    public static void gravaExclusaoExame(Statement st, String exame) throws Exception {
        Util.gravaExclusaoExame(st, exame, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoMedicamento(Statement st, String medicamento) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select mto_codigo, mto_descricao, mto_fabricante, mto_indicacao, mto_interacao ");
        bui.append("from medicamentos where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and mto_codigo = ");
        bui.append(medicamento);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("medicamento", new Registro(rs), new String[]{"mto_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "medicamentos", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "medicamentos", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoFeriado(Statement st, String dia) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select fer_dia, fer_motivo, fer_fixo ");
        bui.append("from feriados where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and fer_dia = '");
        bui.append(Funcoes.formataData(MM_DD_YYYY, dia));
        bui.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("feriado", new Registro(rs), new String[]{"fer_dia"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "feriados", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "feriados", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoMaterialColeta(Statement st, String material) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select mco_codigo, mco_descricao, mco_abreviatura, mco_solicitarmat ");
        bui.append("from materialcoleta where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and mco_codigo = ");
        bui.append(material);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("materialcoleta", new Registro(rs), new String[]{"mco_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "materialcoleta", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "materialcoleta", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoMetodologia(Statement st, String metodo) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select met_codigo, met_descricao ");
        bui.append("from metodologia where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and met_codigo = ");
        bui.append(metodo);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("metodologia", new Registro(rs), new String[]{"met_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "metodologia", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "metodologia", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoPrazoEntrega(Statement st, String prazo) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select prz_codigo, prz_descricao, prz_prazo, prz_dias, prz_horaentrada, prz_horasaida ");
        bui.append("from prazoentrega where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and prz_codigo = ");
        bui.append(prazo);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("prazoentrega", new Registro(rs), new String[]{"prz_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "prazoentrega", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "prazoentrega", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoSetor(Statement st, String setor) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select set_codigo, set_descricao, set_responsavel, set_cor, set_sigla ");
        bui.append("from setores where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and set_codigo = ");
        bui.append(setor);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("setor", new Registro(rs), new String[]{"set_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "setores", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "setores", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoRecipiente(Statement st, String recipiente) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select rec_codigo, rec_descricao, rec_tipo, rec_capacidade, unm_codigo ");
        bui.append("from recipientes where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and rec_codigo = ");
        bui.append(recipiente);
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("recipiente", new Registro(rs), new String[]{"rec_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "recipientes", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "recipientes", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoMedico(Statement st, String conselho, String crm, String uf) throws Exception {
        String xml = "";
        StringBuilder bui = new StringBuilder();
        bui.append("select med_nome, med_conselho, med_crm, med_uf ");
        bui.append("from medico where fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and med_conselho = '").append(StringUtil.textoDB(conselho)).append("' ");
        bui.append(" and med_crm = '");
        bui.append(StringUtil.textoDB(crm));
        bui.append("' and med_uf = '");
        bui.append(StringUtil.textoDB(uf));
        bui.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("medico", new Registro(rs), new String[]{"med_conselho", "med_crm", "med_uf"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "medico", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "medico", s, 2), true);
        }
    }

    private static String geraLog(String filial, String xml, String tabela, String codigo, int tipoLog) {
        String codigoFilial = Funcoes.isNumeric(filial) ? String.valueOf(Integer.parseInt(filial)) : filial;
        StringBuilder buf = new StringBuilder();
        buf.append("insert into exportaapoio(fil_codigo, epa_codigo, epa_datahora, ");
        buf.append(" epa_exportado, epa_operacao, ");
        buf.append(tipoLog == 1 ? "con_codigo" : "pac_codigo");
        buf.append(", epa_tabela) values (");
        buf.append(filial);
        buf.append(", nextval('exportaapoio_");
        buf.append(codigoFilial);
        buf.append("_sequence'), current_timestamp, false, '");
        buf.append(StringUtil.textoDB(xml));
        buf.append("', ");
        buf.append(codigo);
        buf.append(",'");
        buf.append(tabela);
        buf.append("')");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getConvenios() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select con_codigo from convenios where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and con_labapoio = true ");
        Statement st = Conexao.getStatement();
        ArrayList<String> convenios = new ArrayList<String>();
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                convenios.add(rs.getString(1));
            }
        }
        Conexao.fecharStatement(st);
        return convenios;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<String> getPacientes() throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.delete(0, buf.length());
        buf.append("select pac_codigo from paciente where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and pac_conectalabapoio = true ");
        Statement st = Conexao.getStatement();
        ArrayList<String> pacientes = new ArrayList<String>();
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            while (rs.next()) {
                pacientes.add(rs.getString(1));
            }
        }
        Conexao.fecharStatement(st);
        return pacientes;
    }

    public static void gravaAlteracaoRequisicao(Statement st, String requisicao) throws Exception {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.con_codigo, a.pac_codigo, b.con_labapoio, p.pac_conectalabapoio ");
        bui.append("from requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        bui.append("left join paciente p on a.fil_codigo = p.fil_codigo and a.pac_codigo = p.pac_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and a.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            bui.delete(0, bui.length());
            bui.append("<requisicao><codigo>");
            bui.append(requisicao);
            bui.append("</codigo></requisicao>");
            boolean convenioApoiado = rs.getBoolean("con_labapoio");
            boolean pacienteApoiado = rs.getBoolean("pac_conectalabapoio");
            if (pacienteApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "requisicao", rs.getString("pac_codigo"), 2), true);
            } else if (convenioApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "requisicao", rs.getString("con_codigo"), 1), true);
            }
        }
    }

    public static void gravaAlteracaoExameRequisicao(Statement st, String requisicao, String exame, String material) throws Exception {
        Util.gravaAlteracaoExameRequisicao(st, Variaveis.filialPadrao, requisicao, exame, material);
    }

    public static void gravaAlteracaoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material) throws Exception {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.con_codigo, a.pac_codigo, (b.con_labapoio or f.con_labapoio) as con_labapoio , p.pac_conectalabapoio ");
        bui.append("from requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        bui.append("left join paciente p on a.fil_codigo = p.fil_codigo and a.pac_codigo = p.pac_codigo ");
        bui.append("left join loteapoiorequisicao c on a.fil_codigo = c.fil_codigo and a.req_codigo = c.req_codigo ");
        bui.append("left join loteapoio d on c.fil_codigo = d.fil_codigo and c.lot_id = d.lot_id ");
        bui.append("left join convenioapoiado e on d.fil_codigo = e.fil_codigo and a.con_codigo = e.cap_convenioapoio and d.con_codigo = e.con_codigo ");
        bui.append("left join convenios f on e.fil_codigo = f.fil_codigo and e.con_codigo = f.con_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(filial);
        bui.append(" and a.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQueryPerformance(st, bui.toString());
        if (rs.next()) {
            bui.delete(0, bui.length());
            bui.append("<examerequisicao><codigo>");
            bui.append(requisicao);
            bui.append("</codigo><exame>");
            bui.append(exame);
            bui.append("</exame><material>");
            bui.append(material);
            bui.append("</material></examerequisicao>");
            boolean convenioApoiado = rs.getBoolean("con_labapoio");
            boolean pacienteApoiado = rs.getBoolean("pac_conectalabapoio");
            if (pacienteApoiado) {
                Conexao.executePerformance(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "examerequisicao", rs.getString("pac_codigo"), 2), true);
            } else if (convenioApoiado) {
                Conexao.executePerformance(filial, st, Util.geraLog(filial, bui.toString(), "examerequisicao", rs.getString("con_codigo"), 1), ParametrosGerais.getTipoIntegracao().equalsIgnoreCase("F"));
            }
        }
    }

    public static void gravaExclusaoExameRequisicao(Statement st, String filial, String requisicao, String exame, String material) throws Exception {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.con_codigo, a.pac_codigo, b.con_labapoio, p.pac_conectalabapoio ");
        bui.append("from requisicao a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        bui.append("left join paciente p on a.fil_codigo = p.fil_codigo and a.pac_codigo = p.pac_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(filial);
        bui.append(" and a.req_codigo = ");
        bui.append(requisicao);
        bui.append(" and a.req_excluida = false ");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            bui.delete(0, bui.length());
            bui.append("<examerequisicao><codigo>");
            bui.append(requisicao);
            bui.append("</codigo><exame>");
            bui.append(exame);
            bui.append("</exame><material>");
            bui.append(material);
            bui.append("</material><operacao>D</operacao></examerequisicao>");
            boolean convenioApoiado = rs.getBoolean("con_labapoio");
            boolean pacienteApoiado = rs.getBoolean("pac_conectalabapoio");
            if (pacienteApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "examerequisicao", rs.getString("pac_codigo"), 2), true);
            } else if (convenioApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(filial, bui.toString(), "examerequisicao", rs.getString("con_codigo"), 1), true);
            }
        }
    }

    public static void gravaAlteracaoPaciente(Statement st, String paciente) throws Exception {
        StringBuilder bui = new StringBuilder();
        bui.append("select a.con_codigo, a.pac_codigo, a.pac_codigo, b.con_labapoio, a.pac_conectalabapoio  ");
        bui.append("from paciente a ");
        bui.append("left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
        bui.append("where a.fil_codigo = ");
        bui.append(Variaveis.filialPadrao);
        bui.append(" and a.pac_codigo = ");
        bui.append(paciente);
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            bui.delete(0, bui.length());
            bui.append("<paciente><codigo>");
            bui.append(paciente);
            bui.append("</codigo></paciente>");
            boolean convenioApoiado = rs.getBoolean("con_labapoio");
            boolean pacienteApoiado = rs.getBoolean("pac_conectalabapoio");
            if (pacienteApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "paciente", rs.getString("pac_codigo"), 2), true);
            } else if (convenioApoiado) {
                Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, bui.toString(), "paciente", rs.getString("con_codigo"), 1), true);
            }
        }
    }

    public static void exportaWebRequisicao(String filial, String requisicao, boolean zerarPaginaOrdemExames) throws Exception {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        Util.exportaWebRequisicao(filial, requisicao, st, st2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportaWebRequisicao(String filial, String requisicao, Statement st, Statement st2, boolean zerarPaginaOrdemExames) throws Exception {
        String codigoBase = null;
        String requisicaoFormatada = "";
        FilialService filialService = new FilialService();
        StringBuilder buf = new StringBuilder();
        if (Funcoes.isExportaWeb(st, filial)) {
            FilialVOAux filialVO = filialService.getDadosExportaBaseWeb(st, filial);
            codigoBase = filialVO.getTipoBase();
        }
        requisicaoFormatada = Util.formataCodigoRequisicao(filial, requisicao, st2);
        boolean enviarWeb = true;
        buf.setLength(0);
        buf.append("select a.req_data, a.req_hora, b.des_descricao, c.col_descricao, a.des_codigo, ");
        buf.append("a.con_codigo, a.req_idade, a.req_anomes, d.pac_datanasc, a.req_senhaweb, a.ent_codigo, ");
        buf.append("a.pac_codigo, a.req_totpago,  a.req_total, a.med_conselho, a.med_crm, a.med_uf, b.des_enviarweb ");
        buf.append("from requisicao a ");
        buf.append("left join destino b on a.fil_codigo = b.fil_codigo and a.des_codigo = b.des_codigo ");
        buf.append("left join coletas c on a.fil_codigo = c.fil_codigo and a.col_codigo = c.col_codigo ");
        buf.append("left join paciente d on a.fil_codigo = d.fil_codigo and a.pac_codigo = d.pac_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and a.req_codigo = ");
        buf.append(requisicao);
        buf.append(" and a.req_excluida = false ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                enviarWeb = rs.getBoolean("des_enviarweb");
                String[] comandoRequisicao = new String[38];
                comandoRequisicao[0] = "codigoBase";
                comandoRequisicao[1] = codigoBase;
                comandoRequisicao[2] = "codigoRequisicao";
                comandoRequisicao[3] = requisicaoFormatada;
                comandoRequisicao[4] = "dataRequisicao";
                comandoRequisicao[5] = Funcoes.formataData(rs.getDate("req_data"));
                comandoRequisicao[6] = "horaRequisicao";
                comandoRequisicao[7] = rs.getString("req_hora");
                comandoRequisicao[8] = "destinoRequisicao";
                comandoRequisicao[9] = rs.getString("des_descricao");
                comandoRequisicao[10] = "coletaRequisicao";
                comandoRequisicao[11] = rs.getString("col_descricao");
                comandoRequisicao[12] = "codigoConvenioRequisicao";
                comandoRequisicao[13] = rs.getString("con_codigo");
                comandoRequisicao[14] = "idadeRequisicao";
                comandoRequisicao[15] = rs.getString("req_idade") + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                comandoRequisicao[16] = "dataNascimentoRequisicao";
                comandoRequisicao[17] = !DBUtil.campoNull(rs.getString("pac_datanasc")) ? Funcoes.formataData(rs.getDate("pac_datanasc")) : "";
                comandoRequisicao[18] = "senhaRequisicao";
                comandoRequisicao[19] = rs.getString("req_senhaweb");
                comandoRequisicao[20] = "conselhoMedicoRequisicao";
                comandoRequisicao[21] = rs.getString("med_conselho");
                comandoRequisicao[22] = "crmMedicoRequisicao";
                comandoRequisicao[23] = rs.getString("med_crm");
                comandoRequisicao[24] = "ufMedicoRequisicao";
                comandoRequisicao[25] = rs.getString("med_uf");
                comandoRequisicao[26] = "valorPagoRequisicao";
                comandoRequisicao[27] = Funcoes.limpaDecimal(rs.getString("req_totpago"));
                comandoRequisicao[28] = "valorRequisicao";
                comandoRequisicao[29] = Funcoes.limpaDecimal(rs.getString("req_total"));
                comandoRequisicao[30] = "codigoPacienteRequisicao";
                comandoRequisicao[31] = rs.getString("pac_codigo");
                comandoRequisicao[32] = "codigoDestinoRequisicao";
                comandoRequisicao[33] = rs.getString("des_codigo");
                comandoRequisicao[34] = "entidadeRequisicao";
                comandoRequisicao[35] = DBUtil.campoNull(rs.getString("ent_codigo")) ? "null" : rs.getString("ent_codigo");
                comandoRequisicao[36] = "resultadoPdfRequisicao";
                String tmp = "";
                if (ExportaWeb.isGerarPdfResultado(st2, filial)) {
                    RetornoImpressaoResultados retorno = ImpressaoResultados.imprimirExamesPdfWeb(filial, requisicao, false);
                    tmp = retorno.getResultadoPdfWeb() != null ? new Base64().encodeAsString(retorno.getResultadoPdfWeb()) : "";
                }
                comandoRequisicao[37] = tmp;
                if (enviarWeb) {
                    DBUtil.insereExportaWeb(filial, st2, "requisicao", "I", comandoRequisicao);
                }
            }
        }
        if (enviarWeb) {
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st2, filial);
            buf.delete(0, buf.length());
            buf.append("select a.exa_codigo, a.mco_codigo, b.mco_descricao, a.exr_situacao, a.exr_dataassina, a.usr_codassina, ");
            buf.append("c.usr_nome, a.exr_datamaterial ");
            buf.append("from examerequisicao a ");
            buf.append("left join materialcoleta b on a.fil_codigo = b.fil_codigo and a.mco_codigo = b.mco_codigo ");
            buf.append("left join usuario c on a.usr_codassina = c.usr_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ");
            buf.append(requisicao);
            buf.append(" and a.exr_excluido = false ");
            try {
                rs = st.executeQuery(buf.toString());
                while (rs.next()) {
                    String exame = rs.getString("exa_codigo");
                    String material = rs.getString("mco_codigo");
                    String[] comandoExameRequisicao = new String[zerarPaginaOrdemExames ? 28 : 24];
                    comandoExameRequisicao[0] = "codigoBase";
                    comandoExameRequisicao[1] = codigoBase;
                    comandoExameRequisicao[2] = "codigoRequisicao";
                    comandoExameRequisicao[3] = requisicaoFormatada;
                    comandoExameRequisicao[4] = "codigoExameRequisicao";
                    comandoExameRequisicao[5] = exame;
                    comandoExameRequisicao[6] = "materialExameRequisicao";
                    comandoExameRequisicao[7] = material;
                    comandoExameRequisicao[8] = "descricaoMaterialExameRequisicao";
                    comandoExameRequisicao[9] = rs.getString("mco_descricao");
                    comandoExameRequisicao[10] = "dataColetaExameRequisicao";
                    comandoExameRequisicao[11] = !DBUtil.campoNull(rs.getString("exr_datamaterial")) ? Funcoes.formataData(DD_MM_YYYY, rs.getDate("exr_datamaterial")) : "";
                    comandoExameRequisicao[12] = "horaColetaExameRequisicao";
                    comandoExameRequisicao[13] = !DBUtil.campoNull(rs.getString("exr_datamaterial")) ? Funcoes.formataHora(rs.getDate("exr_datamaterial"), false) : "";
                    comandoExameRequisicao[14] = "situacaoExameRequisicao";
                    comandoExameRequisicao[15] = rs.getString("exr_situacao");
                    comandoExameRequisicao[16] = "assinaturaExameRequisicao";
                    comandoExameRequisicao[17] = !DBUtil.campoNull(rs.getString("exr_dataassina")) ? rs.getString("usr_codassina") : "";
                    comandoExameRequisicao[18] = "nomeAssinaturaExameRequisicao";
                    comandoExameRequisicao[19] = !DBUtil.campoNull(rs.getString("exr_dataassina")) ? rs.getString("usr_nome") : "";
                    comandoExameRequisicao[20] = "dataEnvioExameRequisicao";
                    comandoExameRequisicao[21] = "current_timestamp";
                    if (zerarPaginaOrdemExames) {
                        comandoExameRequisicao[24] = "paginaExameRequisicao";
                        comandoExameRequisicao[25] = "null";
                        comandoExameRequisicao[26] = "ordemExameRequisicao";
                        comandoExameRequisicao[27] = "null";
                    }
                    DBUtil.insereExportaWeb(filial, st2, "requisicaoexame", "I", true, comandoExameRequisicao);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private static boolean isWebStandAlone(FilialVOAux filial) {
        return filial != null && filial.isWebStandAlone() != false;
    }

    public static void exportaWebPaciente(String codigoFilial, String codigoPaciente, boolean inserindo) throws Exception {
        Util.exportaWebPaciente(codigoFilial, codigoPaciente, inserindo, Conexao.getStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportaWebPaciente(String codigoFilial, String codigoPaciente, boolean inserindo, Statement st) throws Exception {
        String[] codigos = new String[]{codigoFilial};
        String codigoBase = Variaveis.codigoBaseWeb;
        for (String filial : codigos) {
            codigoBase = ExportaWeb2.getCodigoBaseWeb(st, filial);
            if (Funcoes.textoVazio(codigoBase) || Funcoes.textoVazio(codigoBase)) continue;
            StringBuilder bui = new StringBuilder("select pac_codigo, pac_nome, pac_senhaweb, pac_cpf, pac_sif from paciente where fil_codigo = ");
            bui.append(filial);
            bui.append(" and pac_codigo = ");
            bui.append(codigoPaciente);
            try (ResultSet rs = null;){
                rs = st.executeQuery(bui.toString());
                if (!rs.next()) continue;
                String[] comando = new String[]{"codigoBase", codigoBase, "codigoPaciente", codigoPaciente, "nomePaciente", StringUtil.textoDB(rs.getString("pac_nome")), "senhaPaciente", StringUtil.textoDB(rs.getString("pac_senhaweb")), "cpfPaciente", StringUtil.textoDB(rs.getString("pac_cpf")), "sifPaciente", StringUtil.textoDB(rs.getString("pac_sif"))};
                DBUtil.insereExportaWeb(filial, st, "paciente", inserindo ? "I" : "A", comando);
            }
        }
    }

    public static void gravaAutoCopiaPaciente(String filial, String paciente, String codigoOriginalSemFormatacao, boolean inserindo) throws Exception {
        Util.gravaAutoCopiaPaciente(filial, paciente, codigoOriginalSemFormatacao, inserindo, Conexao.getStatement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAutoCopiaPaciente(String filial, String paciente, String codigoOriginalSemFormatacao, boolean inserindo, Statement statement) throws Exception {
        StringBuilder buf = new StringBuilder("select * from paciente where fil_codigo = ");
        buf.append(filial);
        buf.append(" and pac_codigo = ");
        buf.append(paciente);
        try (ResultSet rs = null;){
            rs = statement.executeQuery(buf.toString());
            if (rs.next()) {
                SalvaDados salvar = new SalvaDados("paciente", inserindo ? 0 : 2);
                salvar.adicionaCampo("fil_codigo", 2, false, true, filial);
                salvar.adicionaCampo("pac_codigo", 2, false, true, paciente);
                salvar.adicionaCampo("pac_nome", 0, true, false, StringUtil.textoDB(rs.getString("pac_nome")));
                salvar.adicionaCampo("pac_sexo", 0, true, false, rs.getString("pac_sexo"));
                salvar.adicionaCampo("pac_datanasc", 1, true, false, rs.getString("pac_datanasc"));
                salvar.adicionaCampo("pac_vip", 4, true, false, rs.getBoolean("pac_vip"));
                salvar.adicionaCampo("pac_grpsangue", 0, true, false, rs.getString("pac_grpsangue"));
                salvar.adicionaCampo("pac_fatorrh", 0, true, false, rs.getString("pac_fatorrh"));
                salvar.adicionaCampo("pac_fatordu", 0, true, false, rs.getString("pac_fatordu"));
                salvar.adicionaCampo("pac_cor", 0, true, false, rs.getString("pac_cor"));
                salvar.adicionaCampo("pac_observ", 0, true, false, StringUtil.textoDB(rs.getString("pac_observ")));
                salvar.adicionaCampo("pac_senhaweb", 0, true, false, StringUtil.textoDB(rs.getString("pac_senhaweb")));
                salvar.adicionaCampo("pac_dadoclinico", 0, true, false, StringUtil.textoDB(rs.getString("pac_dadoclinico")));
                salvar.adicionaCampo("pac_peso", 2, true, false, rs.getString("pac_peso"));
                salvar.adicionaCampo("pac_altura", 2, true, false, rs.getString("pac_altura"));
                salvar.adicionaCampo("pac_matricconv", 0, true, false, StringUtil.textoDB(rs.getString("pac_matricconv")));
                salvar.adicionaCampo("pac_titularconv", 0, true, false, StringUtil.textoDB(rs.getString("pac_titularconv")));
                salvar.adicionaCampo("pac_profissao", 0, true, false, StringUtil.textoDB(rs.getString("pac_profissao")));
                salvar.adicionaCampo("pac_fumante", 0, true, false, rs.getString("pac_fumante"));
                salvar.adicionaCampo("pac_diabetico", 0, true, false, rs.getString("pac_diabetico"));
                salvar.adicionaCampo("pac_maladireta", 4, true, false, rs.getBoolean("pac_maladireta"));
                salvar.adicionaCampo("pac_rg", 0, true, false, StringUtil.textoDB(rs.getString("pac_rg")));
                salvar.adicionaCampo("pac_cpf", 0, true, false, StringUtil.textoDB(rs.getString("pac_cpf")));
                salvar.adicionaCampo("pac_pai", 0, true, false, StringUtil.textoDB(rs.getString("pac_pai")));
                salvar.adicionaCampo("pac_mae", 0, true, false, StringUtil.textoDB(rs.getString("pac_mae")));
                salvar.adicionaCampo("pac_estcivil", 0, true, false, rs.getString("pac_estcivil"));
                salvar.adicionaCampo("pac_numfilho", 2, true, false, rs.getString("pac_numfilho"));
                if (inserindo) {
                    salvar.adicionaCampo("pac_datahora", 5, true, false, 0);
                    salvar.adicionaCampo("usr_codigo", 0, true, false, rs.getString("usr_codigo"));
                }
                salvar.adicionaCampo("pac_datahoraalteracao", 5, true, false, 0);
                salvar.adicionaCampo("usr_codalteracao", 0, true, false, rs.getString("usr_codalteracao"));
                salvar.adicionaCampo("pac_dum", 1, true, false, rs.getString("pac_dum"));
                salvar.adicionaCampo("pac_fax", 0, true, false, StringUtil.textoDB(rs.getString("pac_fax")));
                salvar.adicionaCampo("pac_celular", 0, true, false, StringUtil.textoDB(rs.getString("pac_celular")));
                salvar.adicionaCampo("pac_fonecomercial", 0, true, false, StringUtil.textoDB(rs.getString("pac_fonecomercial")));
                salvar.adicionaCampo("pac_fone", 0, true, false, StringUtil.textoDB(rs.getString("pac_fone")));
                salvar.adicionaCampo("pac_complemento", 0, true, false, StringUtil.textoDB(rs.getString("pac_complemento")));
                salvar.adicionaCampo("pac_endereco", 0, true, false, StringUtil.textoDB(rs.getString("pac_endereco")));
                salvar.adicionaCampo("pac_numeroendereco", 0, true, false, StringUtil.textoDB(rs.getString("pac_numeroendereco")));
                salvar.adicionaCampo("pac_tipologradouroendereco", 0, true, false, StringUtil.textoDB(rs.getString("pac_tipologradouroendereco")));
                salvar.adicionaCampo("pac_email", 0, true, false, StringUtil.textoDB(rs.getString("pac_email")));
                salvar.adicionaCampo("pac_anomes", 0, true, false, rs.getString("pac_anomes"));
                salvar.adicionaCampo("pac_idade", 2, true, false, rs.getString("pac_idade"));
                salvar.adicionaCampo("pac_foto", 0, true, false, rs.getString("pac_foto"));
                salvar.adicionaCampo("pac_cep", 0, true, false, StringUtil.textoDB(rs.getString("pac_cep")));
                salvar.adicionaCampo("pac_nomecontato", 0, true, false, StringUtil.textoDB(rs.getString("pac_nomecontato")));
                salvar.adicionaCampo("pac_fonecontato", 0, true, false, StringUtil.textoDB(rs.getString("pac_fonecontato")));
                salvar.adicionaCampo("bai_codigo", 0, true, false, Funcoes.textoVazio(rs.getString("bai_codigo")) ? null : rs.getString("bai_codigo"));
                salvar.adicionaCampo("cid_codigo", 2, true, false, rs.getString("cid_codigo"));
                salvar.adicionaCampo("con_codigo", 2, true, false, rs.getString("con_codigo"));
                salvar.adicionaCampo("med_conselho", 0, true, false, Funcoes.textoVazio(rs.getString("med_conselho")) ? null : rs.getString("med_conselho"));
                salvar.adicionaCampo("med_crm", 0, true, false, Funcoes.textoVazio(rs.getString("med_crm")) ? null : rs.getString("med_crm"));
                salvar.adicionaCampo("med_uf", 0, true, false, Funcoes.textoVazio(rs.getString("med_uf")) ? null : rs.getString("med_uf"));
                DBUtil.gravaAutoCopia(filial, statement, salvar, "fil_codigo", ParametrosGerais.getCopiaPaciente(), "paciente", Integer.parseInt(paciente), true, Long.parseLong(codigoOriginalSemFormatacao), null);
            }
        }
        Conexao.fecharStatement(statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoUnidadeMedida(Statement st, String unidade) throws Exception {
        String xml = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select unm_codigo, unm_descricao from unidademedida where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and unm_codigo = '");
        buf.append(StringUtil.textoDB(unidade));
        buf.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("unidademedida", new Registro(rs), new String[]{"unm_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "unidademedida", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "unidademedida", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoEmbalagem(Statement st, String embalagem) throws Exception {
        String xml = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select emb_codigo, emb_descricao from embalagemproduto where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and emb_codigo = ");
        buf.append(embalagem);
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("embalagemproduto", new Registro(rs), new String[]{"emb_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "embalagemproduto", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "embalagemproduto", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoColeta(Statement st, String coleta) throws Exception {
        String xml = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select col_descricao, cid_codigo, col_cep, col_endereco, col_cep, ");
        buf.append(" col_complemento, col_fone, bai_codigo from coletas where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and col_codigo = '");
        buf.append(StringUtil.textoDB(coleta));
        buf.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("coletas", new Registro(rs), new String[]{"col_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "coletas", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "coletas", s, 2), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void gravaAlteracaoDestino(Statement st, String destino) throws Exception {
        String xml = "";
        StringBuilder buf = new StringBuilder();
        buf.append("select des_descricao, cid_codigo, des_cep, des_endereco, des_cep, ");
        buf.append(" des_complemento, des_fone, bai_codigo, des_impressora, ");
        buf.append(" des_naoimprimir, des_enviarweb, des_protocolo, des_conectarweb, des_senhaweb, des_solicitarprp ");
        buf.append(" des_bloquearsmsexamepronto, des_bloquearsmsrecoleta, des_bloquearemailexamepronto, des_bloquearemailrecoleta ");
        buf.append(" from destino where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and des_codigo = '");
        buf.append(StringUtil.textoDB(destino));
        buf.append("'");
        try (ResultSet rs = null;){
            rs = st.executeQuery(buf.toString());
            if (rs.next()) {
                xml = XMLUtil.criaXML("destino", new Registro(rs), new String[]{"des_codigo"});
            }
        }
        ArrayList<String> convenios = Util.getConvenios();
        for (String s : convenios) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "destino", s, 1), true);
        }
        ArrayList<String> pacientes = Util.getPacientes();
        for (String s : pacientes) {
            Conexao.execute(Variaveis.filialPadrao, st, Util.geraLog(Variaveis.filialPadrao, xml, "destino", s, 2), true);
        }
    }

    protected static String formataCodigoRequisicao(String filial, String codigo, Statement st) {
        String retorno = codigo;
        try {
            if (ExportaWeb.isBaseWebAgrupada(st, filial) && Funcoes.isNumeric(filial) && Funcoes.isNumeric(codigo)) {
                retorno = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codigo, ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "IntegracaoUtil (271)");
        }
        return retorno;
    }
}

