/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws.parametroset;

import com.sun.org.apache.xml.internal.serialize.OutputFormat;
import com.sun.org.apache.xml.internal.serialize.XMLSerializer;
import jalis.apoio.servidorws.parametroset.Parametro;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.apoio.servidorws.parametroset.ParametroTipos;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParametroSetParser {
    private static final String TAG_NOME = "n";
    private static final String TAG_PARAMETRO = "p";
    private static final String TAG_PARAMETROS = "ps";
    private static final String TAG_TIPO = "t";
    private static final String TAG_VALOR = "v";
    private static final String TAG_ITEM = "i";
    private static final String TAG_ITENS = "is";
    private DocumentBuilderFactory dbf;
    private DocumentBuilder docBuilder;

    public ParametroSetParser() {
        try {
            this.dbf = DocumentBuilderFactory.newInstance();
            this.docBuilder = this.dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Node parametrosToXml(ParametroSet parametros, Document doc) {
        Element tagParametros = doc.createElement(TAG_PARAMETROS);
        for (Map.Entry<String, Parametro> entryParam : parametros.getParametros().entrySet()) {
            ParametroSet parametrosInterno;
            Element tagItem;
            List list;
            Element tagItens;
            Parametro parametro = entryParam.getValue();
            Element tagParametro = doc.createElement(TAG_PARAMETRO);
            Element tagNome = doc.createElement(TAG_NOME);
            Element tagTipo = doc.createElement(TAG_TIPO);
            Element tagValor = doc.createElement(TAG_VALOR);
            tagNome.setTextContent(entryParam.getKey());
            tagTipo.setTextContent(parametro.getTipo().getId());
            if (parametro.getTipo() == ParametroTipos.STRING || parametro.getTipo() == ParametroTipos.INTEGER || parametro.getTipo() == ParametroTipos.FLOAT || parametro.getTipo() == ParametroTipos.BIGINT || parametro.getTipo() == ParametroTipos.LONG || parametro.getTipo() == ParametroTipos.DOUBLE || parametro.getTipo() == ParametroTipos.BOOLEAN) {
                tagValor.setTextContent(String.valueOf(parametro.getValor()));
            } else if (parametro.getTipo() == ParametroTipos.DATE) {
                tagValor.setTextContent(String.valueOf(((Date)parametro.getValor()).getTime()));
            } else if (parametro.getTipo() == ParametroTipos.LIST) {
                tagItens = doc.createElement(TAG_ITENS);
                list = (List)parametro.getValor();
                for (String valorList : list) {
                    tagItem = doc.createElement(TAG_ITEM);
                    tagItem.setTextContent(valorList);
                    tagItens.appendChild(tagItem);
                }
                tagValor.appendChild(tagItens);
            } else if (parametro.getTipo() == ParametroTipos.SET) {
                tagItens = doc.createElement(TAG_ITENS);
                Set set = (Set)parametro.getValor();
                for (String valorSet : set) {
                    tagItem = doc.createElement(TAG_ITEM);
                    tagItem.setTextContent(valorSet);
                    tagItens.appendChild(tagItem);
                }
                tagValor.appendChild(tagItens);
            } else if (parametro.getTipo() == ParametroTipos.MAP) {
                Map map = (Map)parametro.getValor();
                tagValor.appendChild(this.mapToNode(doc, map));
            } else if (parametro.getTipo() == ParametroTipos.LISTPARAM) {
                tagItens = doc.createElement(TAG_ITENS);
                list = (List)parametro.getValor();
                for (ParametroSet parans : list) {
                    tagItem = doc.createElement(TAG_ITEM);
                    tagItem.appendChild(this.parametrosToXml(parans, doc));
                    tagItens.appendChild(tagItem);
                }
                tagValor.appendChild(tagItens);
            } else if (parametro.getTipo() == ParametroTipos.PARAMETROS && (parametrosInterno = (ParametroSet)parametro.getValor()) != null) {
                tagValor.appendChild(this.parametrosToXml(parametrosInterno, doc));
            }
            tagParametro.appendChild(tagNome);
            tagParametro.appendChild(tagTipo);
            tagParametro.appendChild(tagValor);
            tagParametros.appendChild(tagParametro);
        }
        doc.appendChild(tagParametros);
        return tagParametros;
    }

    private ParametroSet xmlToParametros(Node nodeParametros) {
        if (nodeParametros == null) {
            return null;
        }
        NodeList nodeListParams = nodeParametros.getChildNodes();
        ParametroSet parametros = new ParametroSet();
        for (int i = 0; i < nodeListParams.getLength(); ++i) {
            Node nodeItemList;
            int ii;
            NodeList nodeListItensList;
            ArrayList<ParametroSet> valor;
            Element elParam = (Element)nodeListParams.item(i);
            String nome = elParam.getElementsByTagName(TAG_NOME).item(0).getTextContent();
            String tipoId = elParam.getElementsByTagName(TAG_TIPO).item(0).getTextContent();
            Node nodeValor = elParam.getElementsByTagName(TAG_VALOR).item(0);
            if (tipoId.equals(ParametroTipos.STRING.getId())) {
                parametros.setString(nome, nodeValor.getTextContent());
                continue;
            }
            if (tipoId.equals(ParametroTipos.INTEGER.getId())) {
                valor = Integer.valueOf(nodeValor.getTextContent());
                parametros.setInt(nome, (Integer)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.BIGINT.getId())) {
                valor = new BigInteger(nodeValor.getTextContent());
                parametros.setBigInt(nome, (BigInteger)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.LONG.getId())) {
                valor = Long.valueOf(nodeValor.getTextContent());
                parametros.setLong(nome, (Long)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.FLOAT.getId())) {
                valor = Float.valueOf(nodeValor.getTextContent());
                parametros.setFloat(nome, (Float)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.DOUBLE.getId())) {
                valor = Double.valueOf(nodeValor.getTextContent());
                parametros.setDouble(nome, (Double)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.BOOLEAN.getId())) {
                valor = Boolean.valueOf(nodeValor.getTextContent());
                parametros.setBoolean(nome, (Boolean)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.DATE.getId())) {
                valor = new Date(Long.valueOf(nodeValor.getTextContent()));
                parametros.setDate(nome, (Date)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.LIST.getId())) {
                valor = new ArrayList();
                nodeListItensList = nodeValor.getFirstChild().getChildNodes();
                for (ii = 0; ii < nodeListItensList.getLength(); ++ii) {
                    nodeItemList = nodeListItensList.item(ii);
                    valor.add((ParametroSet)((Object)nodeItemList.getTextContent()));
                }
                parametros.setList(nome, (List<String>)valor);
                continue;
            }
            if (tipoId.equals(ParametroTipos.SET.getId())) {
                valor = new HashSet();
                nodeListItensList = nodeValor.getFirstChild().getChildNodes();
                for (ii = 0; ii < nodeListItensList.getLength(); ++ii) {
                    nodeItemList = nodeListItensList.item(ii);
                    valor.add((ParametroSet)((Object)nodeItemList.getTextContent()));
                }
                parametros.setSet(nome, (Set<String>)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.MAP.getId())) {
                valor = this.nodeToMap(nodeValor.getFirstChild());
                parametros.setMap(nome, (Map<String, String>)((Object)valor));
                continue;
            }
            if (tipoId.equals(ParametroTipos.LISTPARAM.getId())) {
                valor = new ArrayList<ParametroSet>();
                nodeListItensList = nodeValor.getFirstChild().getChildNodes();
                for (ii = 0; ii < nodeListItensList.getLength(); ++ii) {
                    nodeItemList = nodeListItensList.item(ii);
                    valor.add(this.xmlToParametros(nodeItemList.getFirstChild()));
                }
                parametros.setListParam(nome, valor);
                continue;
            }
            if (!tipoId.equals(ParametroTipos.PARAMETROS.getId())) continue;
            Node nodeParamInterno = nodeValor.getFirstChild();
            parametros.setParametroSet(nome, this.xmlToParametros(nodeParamInterno));
        }
        return parametros;
    }

    private Node mapToNode(Document doc, Map<String, String> map) {
        Element tagItens = doc.createElement(TAG_ITENS);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Element tagItem = doc.createElement(TAG_ITEM);
            Element tagMapNome = doc.createElement(TAG_NOME);
            Element tagMapValor = doc.createElement(TAG_VALOR);
            tagMapNome.setTextContent(entry.getKey());
            tagMapValor.setTextContent(entry.getValue());
            tagItem.appendChild(tagMapNome);
            tagItem.appendChild(tagMapValor);
            tagItens.appendChild(tagItem);
        }
        return tagItens;
    }

    private Map<String, String> nodeToMap(Node node) {
        HashMap<String, String> map = new HashMap<String, String>();
        NodeList nodeListItensMap = node.getFirstChild().getChildNodes();
        for (int i = 0; i < nodeListItensMap.getLength(); ++i) {
            Element elItemMap = (Element)nodeListItensMap.item(i);
            String chaveMap = elItemMap.getElementsByTagName(TAG_NOME).item(0).getTextContent();
            String valorMap = elItemMap.getElementsByTagName(TAG_VALOR).item(0).getTextContent();
            map.put(chaveMap, valorMap);
        }
        return map;
    }

    public void serializar(ParametroSet parametros, OutputStream out) throws IOException {
        Document doc = this.docBuilder.newDocument();
        Node nodeParametros = this.parametrosToXml(parametros, doc);
        XMLSerializer xmlSerializer = new XMLSerializer(out, new OutputFormat(doc, "ISO-8859-1", false));
        xmlSerializer.serialize(nodeParametros);
    }

    public ParametroSet desserializar(InputStream inputStream) throws SAXException, IOException {
        Document doc = this.docBuilder.parse(inputStream);
        return this.xmlToParametros(doc.getFirstChild());
    }
}

