/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.laboratorio.configurador.componente.Componente;
import jalis.laboratorio.configurador.componente.Digitavel;
import jalis.laboratorio.configurador.componente.Rotulo;
import jalis.laboratorio.configurador.pagina.Pagina;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.File;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSUtil {
    private WSUtil() {
    }

    public static void carregaParametrosLocais(String nomeArquivo, String caminhoBancoInicial, Logger logger) {
        File f = new File(nomeArquivo);
        if (f.exists()) {
            logger.log(Level.INFO, "Carregando par\u00e2metros de " + nomeArquivo);
            ParametrosLocais.carregaParametros(nomeArquivo);
        } else {
            logger.log(Level.INFO, "Criando novo arquivo de par\u00e2metros em " + nomeArquivo);
            ParametrosLocais.setParametro("caminhoBanco", caminhoBancoInicial);
            ParametrosLocais.setParametro("usuarioPadraoRMI", "admin");
            ParametrosLocais.setParametro("estacaoPadraoRMI", "1");
            ParametrosLocais.setParametro("medicoCrmPadraoRMI", "1");
            ParametrosLocais.setParametro("medicoUFPadraoRMI", "PR");
            ParametrosLocais.setParametro("medicoConselhoPadraoRMI", "CRM");
            ParametrosLocais.setParametro("enviaExameParcial", "false");
            ParametrosLocais.setParametro("filialPadrao", "1");
            ParametrosLocais.setParametro("marcaMaterialApoioComoExterno", "false");
            ParametrosLocais.setParametro("codigoConveniosIgnorarExterno", null);
            ParametrosLocais.salvaParametros(nomeArquivo);
        }
        Variaveis.caminhoBanco = ParametrosLocais.getParametro("caminhoBanco");
        Variaveis.login = ParametrosLocais.getParametro("usuarioPadraoRMI");
        Variaveis.codigoEstacao = ParametrosLocais.getParametro("estacaoPadraoRMI");
    }

    public static void carregaParametrosGerais(Conexao conexao) {
        Statement st = conexao.getStatement();
        ParametrosGerais.carregaParametros(st);
        conexao.fecharStatement(st);
    }

    public static String getFormatoParaExportacao(String formato) {
        Pagina pagina = new Pagina();
        if (formato != null) {
            String exame = StringUtil.getValor(formato, "exame");
            String versaoXml = StringUtil.getValor(exame, "versao");
            String versao = StringUtil.getValor(exame, "versaoExame");
            if (Funcoes.textoVazio(versao) || !Funcoes.isNumeric(versao)) {
                versao = "0";
            }
            exame = StringUtil.getValor(exame, "pagina");
            String tmp = StringUtil.getValor(exame, "propriedades");
            pagina.setMargem(StringUtil.getValor(tmp, "margemEsquerda"), 0);
            pagina.setMargem(StringUtil.getValor(tmp, "margemDireita"), 1);
            pagina.setMargem(StringUtil.getInt(tmp, "margemSuperior") + StringUtil.getInt(tmp, "alturaCabecalho"), 2);
            pagina.setMargem(StringUtil.getInt(tmp, "margemInferior") + StringUtil.getInt(tmp, "alturaRodape") + (StringUtil.getBoolean(tmp, "exibirSumario") ? StringUtil.getInt(tmp, "alturaSumario") : 0), 3);
            pagina.setTamanho(StringUtil.getValor(tmp, "largura"), StringUtil.getValor(tmp, "altura"));
            pagina.limpar();
            pagina.setTipoConfiguracao(0);
            pagina.setAtributos(exame, StringUtil.getValor(exame, "versao"));
            List<Componente> componentes = pagina.getComponentes();
            StringBuilder xml = new StringBuilder();
            if (!componentes.isEmpty()) {
                xml.append("<exame>");
                xml.append("<versaoXML>").append(versaoXml).append("</versaoXML>");
                xml.append("<versaoExame>").append(versao).append("</versaoExame>");
                xml.append("<componentes>");
                for (Componente comp : componentes) {
                    xml.append("<componente>");
                    xml.append("<nome>").append(comp.getNome()).append("</nome>");
                    xml.append("<tipo>").append(comp instanceof Digitavel ? "CAMPO" : "TEXTO").append("</tipo>");
                    xml.append("<altura>").append(comp.getAltura()).append("</altura>");
                    xml.append("<largura>").append(comp.getLargura()).append("</largura>");
                    xml.append("<esquerda>").append(comp.getEsquerda()).append("</esquerda>");
                    xml.append("<topo>").append(comp.getTopo()).append("</topo>");
                    xml.append("<alinhamentoHorizontal>").append(comp.getAlinhamentoHorizontal()).append("</alinhamentoHorizontal>");
                    xml.append("<alinhamentoVertical>").append(comp.getAlinhamentoVertical()).append("</alinhamentoVertical>");
                    xml.append("<nomeFonte>").append(comp.getFonte().getFamily()).append("</nomeFonte>");
                    xml.append("<tipoFonte>").append(comp.getFonte().getStyle()).append("</tipoFonte>");
                    xml.append("<tamanhoFonte>").append(comp.getFonte().getSize()).append("</tamanhoFonte>");
                    xml.append("<texto>");
                    xml.append("<![CDATA[");
                    xml.append(comp instanceof Rotulo ? ((Rotulo)comp).getTexto() : comp.getValorPadrao());
                    xml.append("]]>");
                    xml.append("</texto>");
                    xml.append("</componente>");
                }
                xml.append("</componentes>");
                xml.append("</exame>");
            }
            return xml.toString();
        }
        return "";
    }

    public static enum Resultados {
        SUCESSO,
        ERRO;

    }

    public static enum Chaves {
        ACAO,
        PARAMETROS,
        RESULTADO,
        MENSAGEM;

    }
}

