/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.Acoes;
import jalis.apoio.servidorws.Conexao;
import jalis.apoio.servidorws.WSUtil;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WSServidor {
    private Logger logger = Logger.getLogger("jalis.apoio.servidorws");
    private String imagemSuporte;
    private boolean gerarInterface;

    public WSServidor(String ipBancoInicial, String imagemSuporte, String gerarInterface) {
        this.gerarInterface = Funcoes.textoVazio(gerarInterface) ? false : Boolean.parseBoolean(gerarInterface);
        this.logger.log(Level.INFO, "Iniciando Servidor Webservice Jalis Apoio");
        this.imagemSuporte = imagemSuporte;
        String caminhoBancoInicial = "jdbc:postgresql://" + ipBancoInicial + "/jalis";
        String nomeArquivoProperties = System.getProperty("user.home") + "/.jalisServidorWS.properties";
        this.logger.log(Level.INFO, "Carregando par\u00e2metros locais");
        WSUtil.carregaParametrosLocais(nomeArquivoProperties, caminhoBancoInicial, this.logger);
        this.logger.log(Level.INFO, "Conectando ao banco " + Variaveis.caminhoBanco);
        Conexao conexao = new Conexao(Variaveis.caminhoBanco);
        this.logger.log(Level.INFO, "Carregando par\u00e2metros gerais");
        WSUtil.carregaParametrosGerais(conexao);
        this.logger.log(Level.INFO, "Servidor Webservice Jalis Apoio iniciado");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet executaAcao(ParametroSet paramCliente) {
        try {
            ParametroSet paramRetorno = new ParametroSet();
            String nomeAcao = paramCliente.getString(WSUtil.Chaves.ACAO.name());
            Conexao conexao = new Conexao(Variaveis.caminhoBanco);
            this.logger.log(Level.FINE, "Executando a a\u00e7\u00e3o " + nomeAcao);
            try {
                Acoes acoes = new Acoes(this.logger, conexao, this.imagemSuporte, this.gerarInterface);
                ParametroSet param = paramCliente.getParametroSet(WSUtil.Chaves.PARAMETROS.name());
                Object retorno = null;
                if (param != null) {
                    Method metodo = acoes.getClass().getMethod(nomeAcao, ParametroSet.class);
                    metodo.setAccessible(true);
                    retorno = metodo.invoke((Object)acoes, param);
                } else {
                    Method metodo = acoes.getClass().getMethod(nomeAcao, new Class[0]);
                    metodo.setAccessible(true);
                    retorno = metodo.invoke((Object)acoes, new Object[0]);
                }
                paramRetorno.setString(WSUtil.Chaves.RESULTADO.name(), WSUtil.Resultados.SUCESSO.name());
                if (retorno instanceof ParametroSet) {
                    paramRetorno.setParametroSet(WSUtil.Chaves.PARAMETROS.name(), (ParametroSet)retorno);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                paramRetorno.setString(WSUtil.Chaves.RESULTADO.name(), WSUtil.Resultados.ERRO.name());
                paramRetorno.setString(WSUtil.Chaves.MENSAGEM.name(), "A a\u00e7\u00e3o " + nomeAcao + " n\u00e3o foi encontrada");
            }
            catch (InvocationTargetException invocationTargetEx) {
                conexao.anulaSQL();
                Throwable causa = invocationTargetEx.getCause();
                paramRetorno.setString(WSUtil.Chaves.RESULTADO.name(), WSUtil.Resultados.ERRO.name());
                paramRetorno.setString(WSUtil.Chaves.MENSAGEM.name(), causa.getMessage());
                causa.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                conexao.shutdown();
            }
            return paramRetorno;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executaAcao(InputStream in) {
        String retorno = null;
        try {
            Conexao conexao = new Conexao(Variaveis.caminhoBanco);
            this.logger.log(Level.INFO, "Recebendo requisi\u00e7\u00f5es externas ");
            try {
                Acoes acoes = new Acoes(this.logger, conexao, this.imagemSuporte, this.gerarInterface);
                retorno = acoes.enviarArquivoImportacao(in);
                if (retorno == null) return null;
                String string = retorno;
                return string;
            }
            finally {
                conexao.shutdown();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

