/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.WSUtil;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.apoio.servidorws.parametroset.ParametroSetParser;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import org.xml.sax.SAXException;

public class WSCliente {
    public static final String CONTEXT_ROOT = "jalis_servidor_ws";
    public static String NOME_SERVLET = "exec";
    private ParametroSetParser parametrosParser;
    private String serverHost;
    private int porta;

    public WSCliente(String serverHost, int porta) throws MalformedURLException {
        this.serverHost = serverHost;
        this.porta = porta;
        this.parametrosParser = new ParametroSetParser();
    }

    public ParametroSet executaAcao(String acao) throws RemoteException {
        return this.executaAcao(acao, null);
    }

    public ParametroSet executaAcao(String acao, ParametroSet parametros) throws RemoteException {
        ParametroSet paramEnvio = new ParametroSet();
        paramEnvio.setString(WSUtil.Chaves.ACAO.name(), acao);
        if (parametros != null) {
            paramEnvio.setParametroSet(WSUtil.Chaves.PARAMETROS.name(), parametros);
        }
        try {
            ParametroSet paramRetorno = this.executaAcaoNoServidor(paramEnvio);
            WSUtil.Resultados resultado = WSUtil.Resultados.valueOf(paramRetorno.getString(WSUtil.Chaves.RESULTADO.name()));
            if (resultado == WSUtil.Resultados.ERRO) {
                throw new Exception(paramRetorno.getString(WSUtil.Chaves.MENSAGEM.name()));
            }
            return paramRetorno.getParametroSet(WSUtil.Chaves.PARAMETROS.name());
        }
        catch (SAXException e) {
            throw new RemoteException("Falha na decodifica\u00e7\u00e3o da resposta do servidor para a a\u00e7\u00e3o " + acao, e);
        }
        catch (IOException e) {
            throw new RemoteException("Falha na comunica\u00e7\u00e3o com o servidor para a a\u00e7\u00e3o " + acao, e);
        }
        catch (Exception e) {
            throw new RemoteException("Erro no servidor webservice para a a\u00e7\u00e3o " + acao, e);
        }
    }

    public boolean isServidorOk() {
        boolean servidorOk = false;
        try {
            ParametroSet paramRetorno = this.executaAcao("testarServidor");
            servidorOk = paramRetorno.getBoolean("ok");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return servidorOk;
    }

    private ParametroSet executaAcaoNoServidor(ParametroSet parametros) throws IOException, SAXException {
        URL urlServidor = new URL("http", this.serverHost, this.porta, "/jalis_servidor_ws/" + NOME_SERVLET);
        URLConnection conn = urlServidor.openConnection();
        conn.setDoInput(true);
        conn.setDoOutput(true);
        ByteArrayOutputStream out = (ByteArrayOutputStream)conn.getOutputStream();
        this.parametrosParser.serializar(parametros, out);
        out.flush();
        try {
            StringUtil.escreverArquivoTexto(System.getProperty("user.home") + "//ws.log", new String(out.toByteArray(), StandardCharsets.ISO_8859_1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        out.close();
        InputStream in = conn.getInputStream();
        ParametroSet paramRetorno = this.parametrosParser.desserializar(in);
        in.close();
        return paramRetorno;
    }

    private String readXmlInput(InputStream input) throws IOException {
        InputStreamReader i = new InputStreamReader(input);
        BufferedReader str = new BufferedReader(i);
        StringBuilder xml = new StringBuilder();
        String msg = "";
        while (!Funcoes.textoVazio(msg = str.readLine())) {
            xml.append(msg).append("\n");
        }
        return xml.toString();
    }
}

