/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.Conexao;
import jalis.apoio.servidorws.IServidorWS;
import jalis.apoio.util.Util;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.Variaveis;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.configurador.DialogoConfigurador;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.relatorios.apoio.RelatorioConferenciaEnviados;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import jalis.util.xml.XMLUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;

public class ServidorWSMilenia
implements IServidorWS {
    public static final String HH_MM_SS = "HH:mm:ss";
    public static final String MM_DD_YYYY = "MM/dd/yyyy";
    public static final String HH_MM = "HH:MM";
    public static final String FALSE = "false";
    public static final String PARAMETRO = "parametro";
    public static final String PARAMETROS = "parametros";
    public static final String TRUE = "true";
    public static final String BOOLEAN = "boolean";
    public static final String TEXTO = "texto";
    public static final String NUMERO = "numero";
    public static final String NOME = "nome";
    public static final String TIPO = "tipo";
    public static final String HH_MM1 = "HH:mm";
    BufferedWriter log = null;
    Conexao conexao = null;
    private RequisicaoService requisicaoService = new RequisicaoService();
    private long codigoCliente;
    private boolean upperCase;
    private boolean buscaCPF;
    private boolean ordenarSetor;
    private boolean needConferencia;
    private String mascaraFone;
    private int layCodigo;
    private boolean obrigaDosagem;
    private String imagemSuporte = "";

    public ServidorWSMilenia(String caminhoBanco, String imagemSuporte) {
        try {
            this.log = new BufferedWriter(new FileWriter("/var/log/ServidorApoioJalisMilenia.log"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.conexao = new Conexao(caminhoBanco);
        this.carregaParametros();
        Statement st = this.conexao.getStatement();
        ParametrosGerais.carregaParametros(st);
        File f = new File(System.getProperty("user.home") + "/.jalis.properties");
        if (f.exists()) {
            ParametrosLocais.carregaParametros();
        } else {
            ParametrosLocais.setParametro("caminhoBanco", caminhoBanco);
            ParametrosLocais.setParametro("usuarioPadraoRMI", "thread");
            ParametrosLocais.setParametro("estacaoPadraoRMI", "1");
            ParametrosLocais.setParametro("medicoCrmPadraoRMI", "1");
            ParametrosLocais.setParametro("medicoUFPadraoRMI", "PR");
            ParametrosLocais.setParametro("medicoConselhoPadraoRMI", "CRM");
            ParametrosLocais.setParametro("enviaExameParcial", FALSE);
            ParametrosLocais.salvaParametros();
        }
        if (Funcoes.textoVazio(ParametrosLocais.getParametro("enviaExameParcial"))) {
            ParametrosLocais.setParametro("enviaExameParcial", FALSE);
        }
        Variaveis.login = ParametrosLocais.getParametro("usuarioPadraoRMI");
        Variaveis.codigoEstacao = ParametrosLocais.getParametro("estacaoPadraoRMI");
        this.imagemSuporte = imagemSuporte;
        this.escreverLog("Abriu");
    }

    private void carregaParametros() {
        Statement st = this.conexao.getStatement();
        try (ResultSet rs = null;){
            rs = st.executeQuery("select lay_codigo, par_uppercase, par_buscacpf, par_needconferencia, par_ordenarsetor, par_obrigadosagem, par_cliente, par_mascarafone from parametros");
            if (rs.next()) {
                this.layCodigo = rs.getInt("lay_codigo");
                this.upperCase = rs.getBoolean("par_uppercase");
                this.buscaCPF = rs.getBoolean("par_buscacpf");
                this.needConferencia = rs.getBoolean("par_needconferencia");
                this.ordenarSetor = rs.getBoolean("par_ordenarsetor");
                this.obrigaDosagem = rs.getBoolean("par_obrigadosagem");
                this.codigoCliente = DBUtil.campoNull(rs.getString("par_cliente")) || rs.getString("par_cliente").length() != 100 ? -1L : StringUtil.desencriptar(rs.getString("par_cliente"));
                this.mascaraFone = DBUtil.campoNull(rs.getString("par_mascarafone")) ? "" : rs.getString("par_mascarafone");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.escreverLog("Carregou os parametros");
    }

    private void escreverLog(String mensagem) {
        if (this.log != null) {
            try {
                this.log.write(mensagem + "\n");
                this.log.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getCodigoCliente(String xmlRecebimento) {
        String versao = StringUtil.getValor(xmlRecebimento, "versao");
        String retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar o c\u00f3digo do cliente</erro>";
        this.escreverLog("Obtendo codigo do cliente para nova conexao");
        if (versao.equalsIgnoreCase("1.0")) {
            try {
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "codigoCliente");
                xml.escrever(TIPO, TEXTO);
                xml.escrever("valor", StringUtil.encriptar(this.codigoCliente));
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
                retorno = this.montaXmlRetorno(versao, "getCodigoCliente", xml.getXML());
            }
            catch (XMLStringBuilderException e) {
                retorno = "<erro>Erro ao recuperar o c\u00f3digo do cliente.</erro><mensagem>" + e.getMessage() + "</mensagem>";
            }
        } else {
            retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar o c\u00f3digo do cliente, vers\u00e3o incorreta do XML.</erro>";
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFiliais(String xmlRecebimento) {
        String retorno;
        block10: {
            String versao = StringUtil.getValor(xmlRecebimento, "versao");
            retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar as filiais</erro>";
            this.escreverLog("Obtendo filiais para configura\u00e7\u00e3o de cliente");
            if (versao.equalsIgnoreCase("1.0")) {
                String[] parametros;
                for (String s : parametros = StringUtil.getValores(StringUtil.getValor(xmlRecebimento, PARAMETROS), PARAMETRO)) {
                    String nome = StringUtil.getValor(s, NOME);
                    if (!nome.equalsIgnoreCase("codigoCliente")) continue;
                    String cliente = StringUtil.getValor(s, "valor");
                    if (Funcoes.textoVazio(cliente)) {
                        return "<erro>Dados imcompletos</erro>";
                    }
                    if ((cliente = String.valueOf(StringUtil.desencriptar(cliente))).equalsIgnoreCase(String.valueOf(this.codigoCliente))) continue;
                    return "<erro>Codigo do Cliente inv\u00e1lido</erro>";
                }
                Statement st = this.conexao.getStatement();
                try {
                    ResultSet rs = this.conexao.executeQuery(st, "select fil_codigo, fil_descricao from filiais_postocoleta where fil_apoio = true ");
                    if (rs != null && rs.next()) {
                        rs.beforeFirst();
                        XMLStringBuilder xml = new XMLStringBuilder();
                        xml.abrir(PARAMETROS);
                        xml.abrir(PARAMETRO);
                        xml.escrever(NOME, "filiais");
                        xml.escrever(TIPO, "lista");
                        xml.abrir("valor");
                        while (rs.next()) {
                            xml.abrir("filial");
                            xml.escrever("codigo", rs.getString("fil_codigo"));
                            xml.escrever("descricao", rs.getString("fil_descricao"));
                            xml.fechar("filial");
                        }
                        xml.fechar("valor");
                        xml.fechar(PARAMETRO);
                        xml.fechar(PARAMETROS);
                        retorno = this.montaXmlRetorno(versao, "getFiliais", xml.getXML());
                        break block10;
                    }
                    String string = "<erro>Erro ao recuperar filiais</erro>";
                    return string;
                }
                catch (Exception e) {
                    String string = retorno = "<erro>Erro ao recuperar as filiais.</erro><mensagem>" + e.getMessage() + "</mensagem>";
                    return string;
                }
                finally {
                    this.conexao.fecharStatement(st);
                }
            }
            retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar as filiais, vers\u00e3o incorreta do XML.</erro>";
        }
        return retorno;
    }

    private String validaConvenio(String xmlRecebimento) {
        String versao = StringUtil.getValor(xmlRecebimento, "versao");
        String filial = "";
        String cliente = "";
        String convenio = "";
        String retorno = "";
        XMLStringBuilder xml = new XMLStringBuilder();
        if (versao.equalsIgnoreCase("1.0")) {
            String[] parametros;
            for (String s : parametros = StringUtil.getValores(StringUtil.getValor(xmlRecebimento, PARAMETROS), PARAMETRO)) {
                String nome = StringUtil.getValor(s, NOME);
                if (nome.equalsIgnoreCase("codigoFilial")) {
                    filial = StringUtil.getValor(s, "valor");
                    continue;
                }
                if (nome.equalsIgnoreCase("codigoCliente")) {
                    cliente = StringUtil.getValor(s, "valor");
                    continue;
                }
                if (!nome.equalsIgnoreCase("codigoConvenio")) continue;
                convenio = StringUtil.getValor(s, "valor");
            }
        } else {
            return "<erro>N\u00e3o foi poss\u00edvel validar o conv\u00eanio, vers\u00e3o incorreta do XML.</erro>";
        }
        if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(cliente) || Funcoes.textoVazio(convenio)) {
            return "<erro>Dados imcompletos</erro>";
        }
        if (!(cliente = String.valueOf(StringUtil.desencriptar(cliente))).equalsIgnoreCase(String.valueOf(this.codigoCliente))) {
            return "<erro>Codigo do Cliente inv\u00e1lido</erro>";
        }
        try {
            Statement st = this.conexao.getStatement();
            StringBuilder bui = new StringBuilder("");
            bui.append("select a.con_codigo, b.fil_descricao, a.con_razao, a.con_apoiodias from convenios a ");
            bui.append(" join filiais_postocoleta b on a.fil_codigo = b.fil_codigo ");
            bui.append(" where a.fil_codigo = ");
            bui.append(filial);
            bui.append(" and a.con_codigo = ");
            bui.append(convenio);
            bui.append(" and a.con_labapoio = true and b.fil_apoio = true");
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (!rs.next()) {
                this.conexao.fecharStatement(st);
                return "<erro>Erro ao validar conv\u00eanio</erro>";
            }
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "convenioValidado");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", TRUE);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "filialRazao");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", rs.getString("fil_descricao"));
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "convenioDescricao");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", rs.getString("con_razao"));
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "dias");
            xml.escrever(TIPO, NUMERO);
            xml.escrever("valor", rs.getString("con_apoiodias"));
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "chave");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", this.gerarChave(filial, convenio));
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            retorno = this.montaXmlRetorno(versao, "validaConvenio", xml.getXML());
            this.conexao.fecharStatement(st);
        }
        catch (Exception e) {
            StringBuilder tmp = new StringBuilder();
            for (StackTraceElement s : e.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            return "<erro>Erro ao recuperar dados do conv\u00eanio</erro>";
        }
        this.escreverLog("Convenio " + convenio + " validado na filial " + filial);
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMaiorLoteConvenio(String chave) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo maior lote para o convenio " + convenio + " na filial " + filial);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "lote");
            xml.escrever(TIPO, NUMERO);
            StringBuilder bui = new StringBuilder();
            bui.append("select max(lot_codigo) as maximo from loteapoio where fil_codigo = ");
            bui.append(filial);
            bui.append(" and con_codigo = ");
            bui.append(convenio);
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                xml.escrever("valor", Integer.toString(rs.getInt("maximo")));
            } else {
                xml.escrever("valor", "0");
            }
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return this.montaXmlRetorno("1.0", "getMaiorLoteConvenio", xml.getXML());
    }

    private String getMetodos(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo metodos para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        if (primeiraConexao) {
            try {
                Statement st = this.conexao.getStatement();
                StringBuilder bui = new StringBuilder();
                bui.append("select met_codigo, met_descricao ");
                bui.append("from metodologia where fil_codigo = ");
                bui.append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "metodos");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("metodo");
                    xml.escrever("codigo", rs.getString("met_codigo"));
                    xml.escrever("descricao", rs.getString("met_descricao"));
                    xml.fechar("metodo");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
                this.conexao.fecharStatement(st);
            }
            catch (SQLException e) {
                return "<erro>" + e.getMessage() + "</erro>";
            }
            catch (XMLStringBuilderException e) {
                return "<erro>" + e.getMessage() + "</erro>";
            }
        } else {
            return this.montaXmlRetorno("1.0", "getMetodos", "");
        }
        return this.montaXmlRetorno("1.0", "getMetodos", xml.getXML());
    }

    private String getMaterialColeta(String chave, String versao, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo materiais de coleta para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        if (primeiraConexao) {
            try {
                Statement st = this.conexao.getStatement();
                StringBuilder bui = new StringBuilder();
                bui.append("select mco_codigo, mco_descricao, mco_abreviatura, mco_solicitarmat ");
                bui.append("from materialcoleta where fil_codigo = ");
                bui.append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "materiais");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("materialColeta");
                    xml.escrever("codigo", rs.getString("mco_codigo"));
                    xml.escrever("descricao", rs.getString("mco_descricao"));
                    if (versao.equalsIgnoreCase("1.1")) {
                        xml.escrever("abreviatura", rs.getString("mco_abreviatura"));
                        xml.escrever("solicitarMaterial", rs.getString("mco_solicitarmat"));
                    }
                    xml.fechar("materialColeta");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
                this.conexao.fecharStatement(st);
            }
            catch (SQLException e) {
                return "<erro>" + e.getMessage() + "</erro>";
            }
            catch (XMLStringBuilderException e) {
                return "<erro>" + e.getMessage() + "</erro>";
            }
        } else {
            return this.montaXmlRetorno(versao, "getMaterialColeta", "");
        }
        return this.montaXmlRetorno(versao, "getMaterialColeta", xml.getXML());
    }

    private String getListagemExames(String chave, boolean primeiraConexao) {
        ArrayList<String> paraExcluir;
        ArrayList<String> exames;
        Statement st2;
        Statement st;
        block20: {
            String convenio = this.pegaConvenioChave(chave);
            String filial = this.pegaFilialChave(chave);
            st = this.conexao.getStatement();
            st2 = this.conexao.getStatement();
            this.escreverLog("Obtendo listagem de exames para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
            StringBuilder buf = new StringBuilder();
            exames = new ArrayList<String>();
            paraExcluir = new ArrayList<String>();
            try {
                if (primeiraConexao) {
                    buf.append("select a.exa_codigo, count(c.exa_codigo) as total ");
                    buf.append("from exames a ");
                    buf.append("left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
                    buf.append("where a.fil_codigo = ");
                    buf.append(filial);
                    buf.append(" group by a.exa_codigo ");
                    ResultSet rs = this.conexao.executeQuery(st, buf.toString());
                    while (rs.next()) {
                        buf.setLength(0);
                        buf.append("select a.exa_codigo, count(b.exa_codigo) as proibidos ");
                        buf.append("from exames a ");
                        buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.emc_proibidoapoio = true ");
                        buf.append("where a.fil_codigo = ");
                        buf.append(filial);
                        buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("' ");
                        buf.append(" group by a.exa_codigo ");
                        ResultSet rs2 = this.conexao.executeQuery(st2, buf);
                        int proibidos = 0;
                        if (rs2.next()) {
                            proibidos = rs2.getInt("proibidos");
                        }
                        rs2.close();
                        if (proibidos == rs.getInt("total")) {
                            paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), ""));
                            continue;
                        }
                        if (proibidos == rs.getInt("total")) continue;
                        if (proibidos > 0) {
                            buf.delete(0, buf.length());
                            buf.append("select exa_codigo, mco_codigo from examematcoleta where fil_codigo = ");
                            buf.append(filial);
                            buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("'");
                            buf.append(" and emc_proibidoapoio = true ");
                            ResultSet rsTemp = this.conexao.executeQuery(st2, buf);
                            while (rsTemp.next()) {
                                paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), rsTemp.getString("mco_codigo")));
                            }
                        }
                        exames.add(rs.getString("exa_codigo"));
                    }
                    break block20;
                }
                try {
                    buf.append(this.getOperacao(st, st2, filial, convenio, "exames"));
                    String[] lista = StringUtil.getValores(buf.toString(), "exame");
                    for (String s : lista) {
                        buf.delete(0, buf.length());
                        String temp = StringUtil.getValor(s, "codigo");
                        String operacao = StringUtil.getValor(s, "operacao");
                        String material = StringUtil.getValor(s, "material");
                        if (Funcoes.textoVazio(temp)) continue;
                        if (!Funcoes.textoVazio(operacao)) {
                            paraExcluir.add(this.geraTagExclusao(temp, material));
                            continue;
                        }
                        exames.add(temp);
                    }
                    this.conexao.arquivaSQL();
                }
                catch (Exception ex) {
                    try {
                        this.conexao.anulaSQL();
                    }
                    catch (Exception rs2) {
                        // empty catch block
                    }
                    ex.printStackTrace();
                    exames.clear();
                }
            }
            catch (SQLException e) {
                return "<erro>" + e.getMessage() + "</erro>";
            }
        }
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "exames");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            for (String s : exames) {
                xml.escrever("codigo", s);
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "examesexcluir");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            if (!paraExcluir.isEmpty()) {
                for (String s : paraExcluir) {
                    xml.abrir("exame");
                    s = StringUtil.getValor(s, "excluir");
                    xml.escrever("codigo", StringUtil.getValor(s, "codigo"));
                    s = StringUtil.getValor(s, "material");
                    if (!Funcoes.textoVazio(s)) {
                        xml.escrever("material", s);
                    }
                    xml.fechar("exame");
                }
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (XMLStringBuilderException e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        this.conexao.fecharStatement(st);
        this.conexao.fecharStatement(st2);
        return this.montaXmlRetorno("1.0", "getListagemExames", xml.getXML());
    }

    private String getExame(String chave, String versao, String[] parametros) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        String exame = "";
        String material = "";
        for (String s : parametros) {
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("codigoExame")) {
                exame = StringUtil.getValor(s, "valor");
                continue;
            }
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("codigoMaterial")) continue;
            material = StringUtil.getValor(s, "valor");
        }
        String xml = "";
        if (versao.equalsIgnoreCase("1.0")) {
            xml = this.xmlExameVersao1_0(filial, convenio, exame, material).getXML();
        } else if (versao.equalsIgnoreCase("1.1")) {
            xml = this.xmlExameVersao1_1(filial, convenio, exame, material).getXML();
        }
        return this.montaXmlRetorno(versao, "getExame", xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String enviarPaciente(String chave, String versao, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        String codigoApoio = "";
        String codigo = "";
        String nome = "";
        String numeroEndereco = "";
        String dataNascimento = "";
        String idade = "";
        String sexo = "";
        String tipoIdade = "";
        String bairro = "";
        String vip = "";
        String grupoSangue = "";
        String fatorRH = "";
        String fatorDU = "";
        String cor = "";
        String observacao = "";
        String dadosClinicos = "";
        String peso = "";
        String matriculaConvenio = "";
        String titularConvenio = "";
        String profissao = "";
        String fumante = "";
        String diabetico = "";
        String rg = "";
        String cpf = "";
        String estadoCivil = "";
        String numeroFilhos = "";
        String dataHora = "";
        String dum = "";
        String cidade = "";
        String fax = "";
        String celular = "";
        String fone = "";
        String cep = "";
        String complemento = "";
        String endereco = "";
        String email = "";
        String medicoConselho = "";
        String medicoCrm = "";
        String medicoUf = "";
        String foneContato = "";
        String nomeContato = "";
        String mae = "";
        String pai = "";
        String malaDireta = "";
        String altura = "";
        String foneComercial = "";
        long codigoOrigemPaciente = -1L;
        StringBuilder buf = new StringBuilder();
        this.escreverLog("Recebendo paciente para o convenio " + convenio + " na filial " + filial);
        Statement st = this.conexao.getStatement();
        Statement st1 = this.conexao.getStatement();
        try {
            void string;
            String[] stringArray = parametros;
            int n = stringArray.length;
            boolean bl = false;
            while (string < n) {
                String s = stringArray[string];
                if (StringUtil.getValor(s, NOME).equalsIgnoreCase("codigo")) {
                    codigoApoio = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase(NOME)) {
                    nome = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("sexo")) {
                    sexo = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("dataNascimento")) {
                    dataNascimento = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("idade")) {
                    idade = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("tipoIdade")) {
                    tipoIdade = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("bairro")) {
                    bairro = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("vip")) {
                    vip = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("grupoSangue")) {
                    grupoSangue = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("fatorRH")) {
                    fatorRH = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("fatorDU")) {
                    fatorDU = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("cor")) {
                    cor = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("observacao")) {
                    observacao = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("dadosClinicos")) {
                    dadosClinicos = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("peso")) {
                    peso = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("matriculaConvenio")) {
                    matriculaConvenio = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("titularConvenio")) {
                    titularConvenio = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("profissao")) {
                    profissao = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("fumante")) {
                    fumante = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("diabetico")) {
                    diabetico = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("rg")) {
                    rg = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("cpf")) {
                    cpf = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("estadoCivil")) {
                    estadoCivil = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("numeroFilhos")) {
                    numeroFilhos = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("dataHora")) {
                    dataHora = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("dum")) {
                    dum = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("cidade")) {
                    cidade = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("fax")) {
                    fax = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("celular")) {
                    celular = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("fone")) {
                    fone = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("cep")) {
                    cep = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("complemento")) {
                    complemento = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("endereco")) {
                    endereco = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("numeroEndereco")) {
                    numeroEndereco = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("email")) {
                    email = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("medicoConselho")) {
                    medicoConselho = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("medicoCrm")) {
                    medicoCrm = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("medicoUf")) {
                    medicoUf = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("foneContato")) {
                    foneContato = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("nomeContato")) {
                    nomeContato = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("mae")) {
                    mae = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("pai")) {
                    pai = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("malaDireta")) {
                    malaDireta = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("altura")) {
                    altura = StringUtil.getValor(s, "valor");
                } else if (StringUtil.getValor(s, NOME).equalsIgnoreCase("foneComercial")) {
                    foneComercial = StringUtil.getValor(s, "valor");
                }
                ++string;
            }
            buf.append("select pac_codigo from paciente where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(convenio);
            buf.append(" and pac_codigoapoiado = '").append(StringUtil.textoDB(codigoApoio)).append("'");
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    codigo = rs.getString("pac_codigo");
                }
            }
            if (Funcoes.textoVazio(codigo)) {
                buf.setLength(0);
                codigoOrigemPaciente = Long.parseLong(DBUtil.getSequencia(st, "paciente", filial));
                codigo = DBUtil.formatarValorParaIntegracao(filial, String.valueOf(codigoOrigemPaciente), !ParametrosGerais.getTipoIntegracao().equals("N"), 7);
                if (versao.equalsIgnoreCase("1.0")) {
                    buf.append("insert into paciente (fil_codigo, pac_codigo, con_codigo, pac_nome, pac_sexo, pac_estcivil, pac_datanasc, pac_idade, pac_anomes,");
                    buf.append(" usr_codigo, pac_senhaweb, pac_codigoapoiado, pac_datahora, usr_codalteracao, pac_datahoraalteracao) values (");
                    buf.append(filial).append(",");
                    buf.append(codigo).append(", ");
                    buf.append(convenio).append(", ");
                    buf.append("'").append(nome).append("', ");
                    buf.append("'").append(sexo).append("', ");
                    buf.append("'I', ");
                    buf.append("'").append(dataNascimento).append("', ");
                    buf.append(idade).append(", ");
                    buf.append("'").append(tipoIdade).append("',");
                    buf.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    buf.append("'").append(Funcoes.gerarSenhaWeb()).append("', '");
                    buf.append(StringUtil.textoDB(codigoApoio)).append("',");
                    buf.append("current_timestamp,");
                    buf.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    buf.append("current_timestamp");
                    buf.append(")");
                } else if (versao.equalsIgnoreCase("1.1")) {
                    buf.append("insert into paciente (fil_codigo, pac_codigo, bai_codigo, pac_nome, pac_sexo, ");
                    buf.append("pac_datanasc, pac_vip, pac_grpsangue, pac_fatorrh, pac_fatordu, ");
                    buf.append("pac_cor, pac_observ, pac_dadoclinico, pac_peso, pac_altura, ");
                    buf.append("pac_matricconv, pac_titularconv, pac_profissao, pac_fumante, ");
                    buf.append("pac_diabetico, pac_rg, pac_cpf, pac_estcivil, pac_numfilho, ");
                    buf.append("pac_datahora, pac_dum, cid_codigo, pac_fax, pac_celular, ");
                    buf.append("pac_fonecomercial, pac_fone, pac_cep, pac_complemento, ");
                    buf.append("pac_endereco, pac_numeroendereco, pac_email, pac_anomes, pac_idade, con_codigo, ");
                    buf.append("med_conselho, med_crm, med_uf, pac_fonecontato, pac_nomecontato, ");
                    buf.append("pac_mae, pac_pai, pac_maladireta, pac_codigoapoiado, usr_codigo, pac_senhaweb,");
                    buf.append("usr_codalteracao, pac_datahoraalteracao) values (");
                    buf.append(filial).append(",");
                    buf.append(codigo).append(", ");
                    buf.append("'").append(bairro).append("', ");
                    buf.append("'").append(nome).append("', ");
                    buf.append("'").append(sexo).append("', ");
                    buf.append(Funcoes.textoVazio(dataNascimento) ? "null" : "'" + dataNascimento + "'").append(", ");
                    buf.append(vip).append(", ");
                    buf.append("'").append(grupoSangue).append("', ");
                    buf.append("'").append(fatorRH).append("', ");
                    buf.append("'").append(fatorDU).append("', ");
                    buf.append("'").append(cor).append("', ");
                    buf.append("'").append(observacao).append("', ");
                    buf.append("'").append(dadosClinicos).append("', ");
                    buf.append(Funcoes.textoVazio(peso) ? "null" : peso).append(", ");
                    buf.append(Funcoes.textoVazio(altura) ? "null" : altura).append(", ");
                    buf.append("'").append(matriculaConvenio).append("', ");
                    buf.append("'").append(titularConvenio).append("', ");
                    buf.append("'").append(profissao).append("', ");
                    buf.append("'").append(fumante != null && fumante.equalsIgnoreCase("T") ? "S" : "N").append("', ");
                    buf.append("'").append(diabetico != null && diabetico.equalsIgnoreCase("T") ? "S" : "N").append("', ");
                    buf.append("'").append(rg).append("', ");
                    buf.append("'").append(cpf).append("', ");
                    buf.append("'").append(estadoCivil).append("', ");
                    buf.append(Funcoes.textoVazio(numeroFilhos) ? "null" : numeroFilhos).append(", ");
                    buf.append("'").append(dataHora).append("', ");
                    buf.append(Funcoes.textoVazio(dum) ? "null" : "'" + dum + "'").append(", ");
                    buf.append(Funcoes.textoVazio(cidade) ? "null" : numeroFilhos).append(", ");
                    buf.append("'").append(fax).append("', ");
                    buf.append("'").append(celular).append("', ");
                    buf.append("'").append(foneComercial).append("', ");
                    buf.append("'").append(fone).append("', ");
                    buf.append("'").append(cep).append("', ");
                    buf.append("'").append(complemento).append("', ");
                    buf.append("'").append(endereco).append("', ");
                    buf.append("'").append(numeroEndereco).append("', ");
                    buf.append("'").append(email).append("', ");
                    buf.append("'").append(tipoIdade).append("', ");
                    buf.append(idade).append(", ");
                    buf.append(convenio).append(", ");
                    buf.append("'").append(medicoConselho).append("', ");
                    buf.append("'").append(medicoCrm).append("', ");
                    buf.append("'").append(medicoUf).append("', ");
                    buf.append("'").append(foneContato).append("', ");
                    buf.append("'").append(nomeContato).append("', ");
                    buf.append("'").append(mae).append("', ");
                    buf.append("'").append(pai).append("', ");
                    buf.append(malaDireta).append(", '");
                    buf.append(StringUtil.textoDB(codigoApoio)).append("', ");
                    buf.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    buf.append("'").append(Funcoes.gerarSenhaWeb()).append("',");
                    buf.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    buf.append("current_timestamp");
                    buf.append(")");
                }
            } else if (versao.equalsIgnoreCase("1.1")) {
                buf.append("update paciente set ");
                buf.append("bai_codigo = ").append(bairro).append(", ");
                buf.append("pac_nome = ").append("'").append(nome).append("', ");
                buf.append("pac_sexo = ").append("'").append(sexo).append("', ");
                buf.append("pac_datanasc = ").append("'").append(dataNascimento).append("', ");
                buf.append("pac_vip = ").append(vip).append(", ");
                buf.append("pac_grpsangue = ").append("'").append(grupoSangue).append("', ");
                buf.append("pac_fatorrh = ").append("'").append(fatorRH).append("', ");
                buf.append("pac_fatordu = ").append("'").append(fatorDU).append("', ");
                buf.append("pac_cor = ").append("'").append(cor).append("', ");
                buf.append("pac_observ = ").append("'").append(observacao).append("', ");
                buf.append("pac_dadoclinico = ").append("'").append(dadosClinicos).append("', ");
                buf.append("pac_peso = ").append(peso).append(", ");
                buf.append("pac_altura = ").append(altura).append(", ");
                buf.append("pac_matricconv = ").append("'").append(matriculaConvenio).append("', ");
                buf.append("pac_titularconv = ").append("'").append(titularConvenio).append("', ");
                buf.append("pac_profissao = ").append("'").append(profissao).append("', ");
                buf.append("pac_fumante = '").append(fumante != null && fumante.equalsIgnoreCase("T") ? "S" : "N").append("', ");
                buf.append("pac_diabetico = '").append(diabetico != null && diabetico.equalsIgnoreCase("T") ? "S" : "N").append("', ");
                buf.append("pac_rg = ").append("'").append(rg).append("', ");
                buf.append("pac_cpf = ").append("'").append(cpf).append("', ");
                buf.append("pac_estcivil = ").append("'").append(estadoCivil).append("', ");
                buf.append("pac_numfilho = ").append(numeroFilhos).append(", ");
                buf.append("pac_datahoraalteracao = ").append("'").append(dataHora).append("', ");
                buf.append("usr_codalteracao = '").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                buf.append("pac_dum = ").append("'").append(dum).append("', ");
                buf.append("cid_codigo = ").append(cidade).append(", ");
                buf.append("pac_fax = ").append("'").append(fax).append("', ");
                buf.append("pac_celular = ").append("'").append(celular).append("', ");
                buf.append("pac_fonecomercial = ").append("'").append(foneComercial).append("', ");
                buf.append("pac_fone = ").append("'").append(fone).append("', ");
                buf.append("pac_cep = ").append("'").append(cep).append("', ");
                buf.append("pac_complemento = ").append("'").append(complemento).append("', ");
                buf.append("pac_endereco = ").append("'").append(endereco).append("', ");
                buf.append("pac_numeroendereco = ").append("'").append(numeroEndereco).append("', ");
                buf.append("pac_email = ").append("'").append(email).append("', ");
                buf.append("pac_anomes = ").append("'").append(tipoIdade).append("', ");
                buf.append("pac_idade = ").append(idade).append(", ");
                buf.append("con_codigo = ").append(convenio).append(", ");
                buf.append("med_conselho = ").append("'").append(medicoConselho).append("', ");
                buf.append("med_crm = ").append("'").append(medicoCrm).append("', ");
                buf.append("med_uf = ").append("'").append(medicoUf).append("', ");
                buf.append("pac_fonecontato = ").append("'").append(foneContato).append("', ");
                buf.append("pac_nomecontato = ").append("'").append(nomeContato).append("', ");
                buf.append("pac_mae = ").append("'").append(mae).append("', ");
                buf.append("pac_pai = ").append("'").append(pai).append("', ");
                buf.append("pac_maladireta = ").append(malaDireta);
                buf.append(" where fil_codigo = ").append(filial);
                buf.append(" and pac_codigo = ").append(codigo);
            }
            this.escreverLog(buf.toString());
            st.executeUpdate(buf.toString());
            Util.gravaAutoCopiaPaciente(filial, codigo, String.valueOf(codigoOrigemPaciente), true, st);
            Util.exportaWebPaciente(filial, codigo, true, st1);
            this.escreverLog(codigo);
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "sucesso");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", TRUE);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "codigoJalis");
            xml.escrever(TIPO, NUMERO);
            xml.escrever("valor", codigo);
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
            String object = this.montaXmlRetorno(versao, "enviarPaciente", xml.getXML());
            return object;
        }
        catch (SQLException e) {
            try {
                this.conexao.anulaSQL();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(e.getMessage()).append("\n");
            for (StackTraceElement s : e.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            tmp.append(buf.toString());
            String string = "<erro> Erro ao receber lote do conv\u00eanio</erro><messagem>" + tmp.toString() + "</mensagem>";
            return string;
        }
        catch (Exception e) {
            try {
                this.conexao.anulaSQL();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(e.getMessage()).append("\n");
            for (StackTraceElement s : e.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            String string = "<erro> Erro ao receber lote do conv\u00eanio</erro><messagem>" + tmp.toString() + "</mensagem>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st1);
        }
    }

    private String criarLoteVersao1_0(String chave, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        boolean semEtiquetas = false;
        String codigoLote = "";
        String dataLote = "";
        String[] requisicoes = new String[]{};
        String destino = "";
        String coleta = "";
        XMLStringBuilder xml = new XMLStringBuilder();
        for (String s : parametros) {
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("lote")) {
                codigoLote = StringUtil.getValor(s, "valor");
                continue;
            }
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("data")) {
                dataLote = StringUtil.getValor(s, "valor");
                continue;
            }
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("requisicoes")) continue;
            requisicoes = StringUtil.getValores(StringUtil.getValor(s, "valor"), "requisicao", true);
        }
        if (requisicoes.length == 0) {
            this.escreverLog("Erro ao receber lote do convenio " + convenio + " na filial " + filial + " - Nenhuma requisicao localizada");
            return "<erro> Erro ao receber lote do conv\u00eanio</erro>";
        }
        String hora = Funcoes.formataData(HH_MM_SS, new Date());
        this.escreverLog("Recebendo " + requisicoes.length + " requisicoes do convenio " + convenio + " na filial " + filial + " no lote " + codigoLote);
        Statement st = this.conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select con_apoiosemetiqueta, des_codigo, col_codigo from convenios where fil_codigo = ");
            buf.append(filial);
            buf.append(" and con_codigo = ");
            buf.append(convenio);
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                semEtiquetas = rs.getBoolean("con_apoiosemetiqueta");
                destino = rs.getString("des_codigo");
                coleta = rs.getString("col_codigo");
            }
            boolean criarLote = true;
            String loteId = "";
            if (!Funcoes.textoVazio(codigoLote)) {
                buf.delete(0, buf.length());
                buf.append("select lot_codigo, lot_id from loteapoio where fil_codigo = ");
                buf.append(filial);
                buf.append(" and con_codigo = ");
                buf.append(convenio);
                buf.append(" and lot_codigo = ");
                buf.append(codigoLote);
                rs = this.conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    criarLote = false;
                    loteId = rs.getString("lot_id");
                } else {
                    criarLote = true;
                    loteId = DBUtil.getSequencia(st, "loteapoio", filial);
                }
            }
            if (criarLote) {
                buf.delete(0, buf.length());
                buf.append("insert into loteapoio(fil_codigo, lot_id, con_codigo, lot_codigo, lot_datahora) values (");
                buf.append(filial);
                buf.append(", ");
                buf.append(loteId);
                buf.append(", ");
                buf.append(convenio);
                buf.append(", ");
                buf.append(codigoLote);
                buf.append(", '");
                buf.append(dataLote + " " + hora);
                buf.append("')");
                this.escreverLog(buf.toString());
                this.conexao.executeUpdate(filial, st, buf.toString(), true);
                this.escreverLog("Lote criado com sucesso");
            }
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "sucesso");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", TRUE);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicoes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder bui = new StringBuilder();
            Calendar c = Calendar.getInstance();
            for (String r : requisicoes) {
                String codigoRequisicao = DBUtil.getSequencia(st, "requisicao", filial);
                String dataRequisicao = StringUtil.getValor(r, "data");
                String codigoRequisicaoApoio = StringUtil.getValor(r, "codigo");
                String[] exames = StringUtil.getValores(StringUtil.getValor(r, "exames"), "examerequisicao", true);
                Date dataMaxPrevisao = c.getTime();
                double totalRequisicao = 0.0;
                int cont = 0;
                ArrayList<String> insertExames = new ArrayList<String>();
                for (String string : exames) {
                    Statement st1 = this.conexao.getStatement();
                    Statement st3 = this.conexao.getStatement();
                    String codigoExame = StringUtil.getValor(string, "codigo");
                    String codigoMaterial = StringUtil.getValor(string, "material");
                    DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(filial, Integer.parseInt(convenio), st1);
                    if (dadosConvenio == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do conv\u00eanio " + convenio + " </erro>";
                    }
                    DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(filial, Integer.parseInt(codigoMaterial), st1);
                    if (dadosMaterial == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do material " + codigoMaterial + " </erro>";
                    }
                    DadosExames dadosExame = ExameUtil.getDadosExame(filial, codigoExame, dadosMaterial, st1);
                    if (dadosExame == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do exame " + codigoExame + " com o material " + codigoMaterial + " </erro>";
                    }
                    ExameUtil.calculaPrecoExame(filial, dadosExame, dadosMaterial, dadosConvenio, false, false, false, Integer.parseInt(codigoRequisicao), null, Integer.parseInt(dadosExame.getCodMetodo()));
                    Date dataPrevisao = ExameUtil.calculaDataEntrega(filial, dadosExame.getCodPrazo(), codigoExame, codigoMaterial, convenio, st3);
                    if (dataPrevisao != null && dataPrevisao.after(dataMaxPrevisao)) {
                        dataMaxPrevisao = dataPrevisao;
                    }
                    totalRequisicao += dadosExame.getValorExame().doubleValue();
                    bui.setLength(0);
                    bui.append("insert into examerequisicao (fil_codigo, req_codigo, exr_situacao, exr_vlrexame, exr_vlrchexame, exr_dataentregaprev, ");
                    bui.append("exr_vlrch, met_codigo, exa_codigo, mco_codigo, usr_codigo, exr_vlrmaterial, exr_data, exr_autorizar, exr_naofaturar, exr_ordem, ");
                    bui.append("exr_valorcusto, exr_valoruco, exr_valorporte, exr_porte, exr_excluido, exr_urgente, exr_custosimples) values (");
                    bui.append(filial).append(", ");
                    bui.append(codigoRequisicao).append(", ");
                    bui.append("'").append("F").append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorExame()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH()))).append(", ");
                    bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, dataPrevisao)).append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH()))).append(", ");
                    bui.append(dadosExame.getCodMetodo()).append(", ");
                    bui.append("'").append(codigoExame).append("', ");
                    bui.append(codigoMaterial).append(", ");
                    bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorMaterial()))).append(", ");
                    bui.append("'").append(dataRequisicao).append("', ");
                    bui.append("false, ");
                    bui.append("false, ");
                    bui.append(cont).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getCusto()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getUco()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorPorte()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getPorte())));
                    bui.append(", false, false,");
                    bui.append(this.requisicaoService.valorExameCustoSimples(codigoExame, codigoMaterial, filial));
                    bui.append(")");
                    insertExames.add(bui.toString());
                    bui.setLength(0);
                    bui.append("insert into examerequisicaosituacoes(fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo, ers_situacao, ers_datahora) values (");
                    bui.append(filial).append(", ");
                    bui.append(codigoRequisicao).append(", ");
                    bui.append("'").append(StringUtil.textoDB(codigoExame)).append("', ");
                    bui.append(codigoMaterial).append(", ");
                    bui.append("'").append(StringUtil.textoDB(ParametrosLocais.getParametro("usuarioPadraoRMI"))).append("', ");
                    bui.append("'").append("F").append("', ");
                    bui.append("'").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("')");
                    insertExames.add(bui.toString());
                    ++cont;
                }
                bui.setLength(0);
                bui.append("insert into requisicao (fil_codigo, req_codigo, col_codigo, des_codigo, con_codigo, med_uf, med_conselho, med_crm, ");
                bui.append("pac_codigo, req_data, req_dtfatura, req_dataentregaprev, req_total, req_totpago, req_horaentregaprev, req_horafatura, req_hora, ");
                bui.append("req_anomes, req_idade, req_senhaweb, usr_codigo, est_codigo, req_vlracrescimo, req_acrescimo, req_vlrdesconto, req_desconto, ");
                bui.append("req_telacoleta, req_datarequisicao, req_vlrmateriais, req_vlrexames, usr_codabertura, req_codigoapoiado, req_excluida) values (");
                bui.append(filial).append(",");
                bui.append(codigoRequisicao).append(",");
                bui.append("'").append(coleta).append("',");
                bui.append("'").append(destino).append("',");
                bui.append(convenio).append(",");
                bui.append("'").append(ParametrosLocais.getParametro("medicoUFPadraoRMI")).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("medicoConselhoPadraoRMI")).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("medicoCrmPadraoRMI")).append("', ");
                bui.append(StringUtil.getValor(r, "paciente")).append(", ");
                bui.append("'").append(dataRequisicao).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, dataMaxPrevisao)).append("', ");
                bui.append(Funcoes.limpaDecimal(String.valueOf(totalRequisicao))).append(", ");
                bui.append("0, ");
                bui.append("'").append(Funcoes.formataData(HH_MM_SS, dataMaxPrevisao)).append("', ");
                bui.append("'").append(Funcoes.formataData(HH_MM_SS, c.getTime())).append("', ");
                bui.append("'").append(StringUtil.getValor(r, "hora")).append("', ");
                bui.append("'").append(StringUtil.getValor(r, "tipoIdade")).append("', ");
                bui.append(StringUtil.getValor(r, "idade")).append(", ");
                bui.append("'").append(Funcoes.gerarSenhaWeb()).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append(ParametrosLocais.getParametro("estacaoPadraoRMI")).append(", ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("false, ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append("'").append(StringUtil.textoDB(codigoRequisicaoApoio)).append("'");
                bui.append(", false)");
                this.escreverLog(bui.toString());
                this.conexao.executeUpdate(filial, st, bui.toString(), true);
                bui.setLength(0);
                bui.append("insert into loteapoiorequisicao(fil_codigo, lot_id, req_codigo) values (");
                bui.append(filial);
                bui.append(", ");
                bui.append(loteId);
                bui.append(", ");
                bui.append(codigoRequisicao);
                bui.append(")");
                this.escreverLog(bui.toString());
                this.conexao.executeUpdate(filial, st, bui.toString(), true);
                for (String s : insertExames) {
                    this.escreverLog(s);
                    this.conexao.executeUpdate(filial, st, s, true);
                }
                for (String string : exames) {
                    String codigoExame = Util.getCodigoXML(string, "codigo");
                    String codigoMaterial = Util.getCodigoXML(string, "material");
                    if (Funcoes.textoVazio(codigoExame) || !Funcoes.isNumeric(codigoMaterial)) continue;
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(filial), Long.parseLong(codigoRequisicao), codigoExame, Integer.parseInt(codigoMaterial), "I", "I");
                }
                Util.exportaWebRequisicao(filial, codigoRequisicao, this.conexao.getStatement(), this.conexao.getStatement(), true);
                xml.abrir("requisicao");
                xml.escrever("codigo", codigoRequisicaoApoio);
                xml.escrever("codigoJalis", codigoRequisicao);
                String etiquetas = Impressao.getEtiquetaColetaApoio(filial, codigoRequisicao, this.conexao.getStatement(), this.conexao.getStatement(), this.conexao.getStatement(), true);
                if (!semEtiquetas) {
                    xml.escrever("etiqueta", StringUtil.textoXML(etiquetas));
                }
                xml.fechar("requisicao");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception rs) {
                // empty catch block
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(ex.getMessage()).append("\n");
            for (StackTraceElement s : ex.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            return tmp.toString();
        }
        return this.montaXmlRetorno("1.0", "criarLote", xml.getXML());
    }

    private String criarLoteVersao1_1(String chave, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        boolean semEtiquetas = false;
        String codigoLote = "";
        String dataLote = "";
        String[] requisicoes = new String[]{};
        String destino = "";
        String coleta = "";
        XMLStringBuilder xml = new XMLStringBuilder();
        for (String s : parametros) {
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("lote")) {
                codigoLote = StringUtil.getValor(s, "valor");
                continue;
            }
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("data")) {
                dataLote = StringUtil.getValor(s, "valor");
                continue;
            }
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("requisicoes")) continue;
            requisicoes = StringUtil.getValores(StringUtil.getValor(s, "valor"), "requisicao", true);
        }
        if (requisicoes.length == 0) {
            this.escreverLog("Erro ao receber lote do convenio " + convenio + " na filial " + filial + " - Nenhuma requisicao localizada");
            return "<erro> Erro ao receber lote do conv\u00eanio</erro>";
        }
        String hora = Funcoes.formataData(HH_MM_SS, new Date());
        this.escreverLog("Recebendo " + requisicoes.length + " requisicoes do convenio " + convenio + " na filial " + filial + " no lote " + codigoLote);
        Statement st = this.conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select con_apoiosemetiqueta, des_codigo, col_codigo from convenios where fil_codigo = ");
            buf.append(filial);
            buf.append(" and con_codigo = ");
            buf.append(convenio);
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                semEtiquetas = rs.getBoolean("con_apoiosemetiqueta");
                destino = rs.getString("des_codigo");
                coleta = rs.getString("col_codigo");
            }
            boolean criarLote = true;
            String loteId = "";
            if (!Funcoes.textoVazio(codigoLote)) {
                buf.delete(0, buf.length());
                buf.append("select lot_codigo, lot_id from loteapoio where fil_codigo = ");
                buf.append(filial);
                buf.append(" and con_codigo = ");
                buf.append(convenio);
                buf.append(" and lot_codigo = ");
                buf.append(codigoLote);
                rs = this.conexao.executeQuery(st, buf.toString());
                if (rs.next()) {
                    criarLote = false;
                    loteId = rs.getString("lot_id");
                } else {
                    criarLote = true;
                    loteId = DBUtil.getSequencia(st, "loteapoio", filial);
                }
            }
            if (criarLote) {
                buf.delete(0, buf.length());
                buf.append("insert into loteapoio(fil_codigo, lot_id, con_codigo, lot_codigo, lot_datahora) values (");
                buf.append(filial);
                buf.append(", ");
                buf.append(loteId);
                buf.append(", ");
                buf.append(convenio);
                buf.append(", ");
                buf.append(codigoLote);
                buf.append(", '");
                buf.append(dataLote + " " + hora);
                buf.append("')");
                this.escreverLog(buf.toString());
                this.conexao.executeUpdate(filial, st, buf.toString(), true);
                this.escreverLog("Lote criado com sucesso");
            }
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "sucesso");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", TRUE);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicoes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder bui = new StringBuilder();
            Calendar c = Calendar.getInstance();
            for (String r : requisicoes) {
                String codigoRequisicao = DBUtil.getSequencia(st, "requisicao", filial);
                String dataRequisicao = StringUtil.getValor(r, "data");
                String codigoRequisicaoApoio = StringUtil.getValor(r, "codigo");
                String[] exames = StringUtil.getValores(StringUtil.getValor(r, "exames"), "exame", true);
                Date dataMaxPrevisao = c.getTime();
                double totalRequisicao = 0.0;
                int cont = 0;
                ArrayList<String> insertExames = new ArrayList<String>();
                for (String string : exames) {
                    Statement st1 = this.conexao.getStatement();
                    Statement st3 = this.conexao.getStatement();
                    String codigoExame = StringUtil.getValor(string, "codigoExame");
                    String codigoMaterial = StringUtil.getValor(string, "codigoMaterial");
                    String descricaoMaterial = StringUtil.getValor(string, "descricaoMaterial");
                    DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(filial, Integer.parseInt(convenio), st1);
                    if (dadosConvenio == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do conv\u00eanio " + convenio + " </erro>";
                    }
                    DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(filial, Integer.parseInt(codigoMaterial), st1);
                    if (dadosMaterial == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do material " + codigoMaterial + " </erro>";
                    }
                    DadosExames dadosExame = ExameUtil.getDadosExame(filial, codigoExame, dadosMaterial, st1);
                    if (dadosExame == null) {
                        return "<erro>N\u00e3o foi poss\u00edvel recuperar dados do exame " + codigoExame + " com o material " + codigoMaterial + " </erro>";
                    }
                    ExameUtil.calculaPrecoExame(filial, dadosExame, dadosMaterial, dadosConvenio, false, false, false, Integer.parseInt(codigoRequisicao), null, Integer.parseInt(dadosExame.getCodMetodo()));
                    Date dataPrevisao = ExameUtil.calculaDataEntrega(filial, dadosExame.getCodPrazo(), codigoExame, codigoMaterial, convenio, st3);
                    if (dataPrevisao != null && dataPrevisao.after(dataMaxPrevisao)) {
                        dataMaxPrevisao = dataPrevisao;
                    }
                    totalRequisicao += dadosExame.getValorExame().doubleValue();
                    bui.setLength(0);
                    bui.append("insert into examerequisicao (fil_codigo, req_codigo, exr_situacao, exr_vlrexame, exr_vlrchexame, exr_dataentregaprev, ");
                    bui.append("exr_vlrch, met_codigo, exa_codigo, mco_codigo, usr_codigo, exr_vlrmaterial, exr_data, exr_autorizar, exr_naofaturar, exr_ordem, ");
                    bui.append("exr_valorcusto, exr_valoruco, exr_valorporte, exr_porte, exr_descricaomaterial, exr_excluido, exr_custosimples) values (");
                    bui.append(filial).append(", ");
                    bui.append(codigoRequisicao).append(", ");
                    bui.append("'").append("F").append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorExame()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH()))).append(", ");
                    bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, dataPrevisao)).append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH()))).append(", ");
                    bui.append(dadosExame.getCodMetodo()).append(", ");
                    bui.append("'").append(codigoExame).append("', ");
                    bui.append(codigoMaterial).append(", ");
                    bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorMaterial()))).append(", ");
                    bui.append("'").append(dataRequisicao).append("', ");
                    bui.append("false, ");
                    bui.append("false, ");
                    bui.append(cont).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getCusto()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getUco()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorPorte()))).append(", ");
                    bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getPorte()))).append(", ");
                    bui.append(Funcoes.textoVazio(descricaoMaterial) ? "null" : "'" + descricaoMaterial + "'");
                    bui.append(", false,");
                    bui.append(this.requisicaoService.valorExameCustoSimples(codigoExame, codigoMaterial, filial));
                    bui.append(")");
                    insertExames.add(bui.toString());
                    bui.setLength(0);
                    bui.append("insert into examerequisicaosituacoes(fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo, ers_situacao, ers_datahora) values (");
                    bui.append(filial).append(", ");
                    bui.append(codigoRequisicao).append(", ");
                    bui.append("'").append(StringUtil.textoDB(codigoExame)).append("', ");
                    bui.append(codigoMaterial).append(", ");
                    bui.append("'").append(StringUtil.textoDB(ParametrosLocais.getParametro("usuarioPadraoRMI"))).append("', ");
                    bui.append("'").append("F").append("', ");
                    bui.append("'").append(Funcoes.formataData("MM/dd/yyyy HH:mm", new Date())).append("')");
                    insertExames.add(bui.toString());
                    ++cont;
                }
                bui.setLength(0);
                bui.append("insert into requisicao (fil_codigo, req_codigo, col_codigo, des_codigo, con_codigo, med_uf, med_conselho, med_crm, ");
                bui.append("pac_codigo, req_data, req_dtfatura, req_dataentregaprev, req_total, req_totpago, req_horaentregaprev, req_horafatura, req_hora, ");
                bui.append("req_anomes, req_idade, req_senhaweb, usr_codigo, est_codigo, req_vlracrescimo, req_acrescimo, req_vlrdesconto, req_desconto, ");
                bui.append("req_telacoleta, req_datarequisicao, req_vlrmateriais, req_vlrexames, usr_codabertura, req_codigoapoiado, req_excluida) values (");
                bui.append(filial).append(",");
                bui.append(codigoRequisicao).append(",");
                bui.append("'").append(coleta).append("',");
                bui.append("'").append(destino).append("',");
                bui.append(convenio).append(",");
                bui.append("'").append(ParametrosLocais.getParametro("medicoUFPadraoRMI")).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("medicoConselhoPadraoRMI")).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("medicoCrmPadraoRMI")).append("', ");
                bui.append(StringUtil.getValor(r, "paciente")).append(", ");
                bui.append("'").append(dataRequisicao).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, dataMaxPrevisao)).append("', ");
                bui.append(Funcoes.limpaDecimal(String.valueOf(totalRequisicao))).append(", ");
                bui.append("0, ");
                bui.append("'").append(Funcoes.formataData(HH_MM_SS, dataMaxPrevisao)).append("', ");
                bui.append("'").append(Funcoes.formataData(HH_MM_SS, c.getTime())).append("', ");
                bui.append("'").append(StringUtil.getValor(r, "hora")).append("', ");
                bui.append("'").append(StringUtil.getValor(r, "tipoIdade")).append("', ");
                bui.append(StringUtil.getValor(r, "idade")).append(", ");
                bui.append("'").append(Funcoes.gerarSenhaWeb()).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append(ParametrosLocais.getParametro("estacaoPadraoRMI")).append(", ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("false, ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append("'").append(StringUtil.textoDB(codigoRequisicaoApoio)).append("'");
                bui.append(", false)");
                this.escreverLog(bui.toString());
                this.conexao.executeUpdate(filial, st, bui.toString(), true);
                bui.setLength(0);
                bui.append("insert into loteapoiorequisicao(fil_codigo, lot_id, req_codigo) values (");
                bui.append(filial);
                bui.append(", ");
                bui.append(loteId);
                bui.append(", ");
                bui.append(codigoRequisicao);
                bui.append(")");
                this.escreverLog(bui.toString());
                this.conexao.executeUpdate(filial, st, bui.toString(), true);
                for (String s : insertExames) {
                    this.escreverLog(s);
                    this.conexao.executeUpdate(filial, st, s, true);
                }
                for (String string : exames) {
                    String codigoExame = Util.getCodigoXML(string, "codigo");
                    String codigoMaterial = Util.getCodigoXML(string, "material");
                    if (Funcoes.textoVazio(codigoExame) || !Funcoes.isNumeric(codigoMaterial)) continue;
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(filial), Long.parseLong(codigoRequisicao), codigoExame, Integer.parseInt(codigoMaterial), "I", "I");
                }
                Util.exportaWebRequisicao(filial, codigoRequisicao, this.conexao.getStatement(), this.conexao.getStatement(), true);
                xml.abrir("requisicao");
                xml.escrever("codigo", codigoRequisicaoApoio);
                xml.escrever("codigoJalis", codigoRequisicao);
                String etiquetas = Impressao.getEtiquetaColetaApoio(filial, codigoRequisicao, this.conexao.getStatement(), this.conexao.getStatement(), this.conexao.getStatement(), true);
                if (!semEtiquetas) {
                    xml.escrever("etiqueta", StringUtil.textoXML(etiquetas));
                }
                xml.fechar("requisicao");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception rs) {
                // empty catch block
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(ex.getMessage()).append("\n");
            for (StackTraceElement s : ex.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            return tmp.toString();
        }
        return this.montaXmlRetorno("1.1", "criarLote", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRequisicao(String chave, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        String requisicao = "";
        Statement st = this.conexao.getStatement();
        for (String s : parametros) {
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("requisicao")) continue;
            requisicao = StringUtil.getValor(s, "valor");
        }
        this.escreverLog("Obtendo informacoes de requisicao para o convenio " + convenio + " na filial " + filial);
        StringBuilder buf = new StringBuilder();
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            buf.append("select exa_codigo, mco_codigo, exr_situacao from examerequisicao where ");
            buf.append("fil_codigo = ").append(filial).append(" and ");
            buf.append("req_codigo = ").append(requisicao).append(" and (");
            buf.append("exr_situacao = '").append("C").append("' or ");
            buf.append("exr_situacao = '").append("I").append("' or ");
            buf.append("exr_situacao = '").append("E").append("'");
            if (!ParametrosGerais.getConferencia()) {
                buf.append(" or exr_situacao = '").append("L").append("'");
            }
            buf.append(")");
            buf.append(" and exr_excluido = false ");
            this.escreverLog(buf.toString());
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                xml.abrir(PARAMETROS);
                xml.escrever(NOME, "exames");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("examerequisicao");
                    xml.escrever("codigo", rs.getString("exa_codigo"));
                    xml.escrever("material", rs.getString("mco_codigo"));
                    xml.fechar("examerequisicao");
                }
            }
            xml.fechar("valor");
            xml.fechar(PARAMETROS);
            this.conexao.fecharStatement(st);
        }
        catch (SQLException e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        catch (XMLStringBuilderException e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        return this.montaXmlRetorno("1.0", "getRequisicao", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRequisicoes(String chave) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        this.escreverLog("Obtendo informacoes de requisicao para o convenio " + convenio + " na filial " + filial);
        StringBuilder buf = new StringBuilder();
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, filial, convenio, "requisicao"));
            String[] requisicoes = StringUtil.getValores(buf.toString(), "requisicao");
            buf.delete(0, buf.length());
            buf.append("select a.req_codigoapoiado, a.req_codigo, a.sit_codigo, a.med_conselho, a.med_crm, ");
            buf.append("a.req_data, ");
            buf.append("a.req_dtfatura, a.req_urgente, a.req_dataentregaprev, a.req_dclinicos, a.req_obs, ");
            buf.append("a.req_totpago, a.req_total, a.med_uf, a.req_horaentregaprev, a.req_horafatura, a.req_hora, ");
            buf.append("a.req_gestante, a.req_dum, a.req_anomes, a.req_idade, a.req_avisarpaciente, ");
            buf.append("a.req_titular, a.req_altura, a.req_peso, ");
            buf.append("a.req_datarequisicao, a.req_neonato ");
            buf.append("from requisicao a ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ?");
            buf.append(" and a.req_excluida = false ");
            PreparedStatement pst = this.conexao.getPreparedStatement(buf.toString());
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicoes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            for (String r : requisicoes) {
                String codigo = StringUtil.getValor(r, "codigo");
                if (!Funcoes.isNumeric(codigo)) continue;
                pst.setInt(1, Integer.parseInt(codigo));
                ResultSet rs = this.conexao.executeQuery(pst);
                xml.abrir("requisicao");
                if (rs.next()) {
                    xml.escrever("codigoApoio", rs.getString("req_codigoapoiado"));
                    xml.escrever("codigoJalis", rs.getString("req_codigo"));
                    xml.escrever("situacao", rs.getString("sit_codigo"));
                    xml.escrever("medicoConselho", rs.getString("med_conselho"));
                    xml.escrever("medicoCrm", rs.getString("med_crm"));
                    xml.escrever("medicoUf", rs.getString("med_uf"));
                    xml.escrever("data", Funcoes.formataData(MM_DD_YYYY, rs.getDate("req_data")));
                    xml.escrever("dataFatura", Funcoes.formataData(MM_DD_YYYY, rs.getDate("req_dtfatura")));
                    xml.escrever("urgente", rs.getString("req_urgente").equalsIgnoreCase("T") ? TRUE : FALSE);
                    xml.escrever("dataEntregaPrevista", Funcoes.formataData(MM_DD_YYYY, rs.getDate("req_dtfatura")));
                    xml.escrever("dadosClinicos", rs.getString("req_dclinicos"));
                    xml.escrever("observacao", rs.getString("req_obs"));
                    xml.escrever("totalPago", rs.getString("req_totpago"));
                    xml.escrever("total", rs.getString("req_total"));
                    xml.escrever("horaEntregaPrevista", Funcoes.formataData(HH_MM, rs.getDate("req_horaentregaprev")));
                    xml.escrever("horaFatura", Funcoes.formataData(HH_MM, rs.getDate("req_horafatura")));
                    xml.escrever("hora", Funcoes.formataData(HH_MM, rs.getDate("req_hora")));
                    xml.escrever("gestante", rs.getString("req_gestante").equalsIgnoreCase("T") ? TRUE : FALSE);
                    xml.escrever("dum", Funcoes.formataData(MM_DD_YYYY, rs.getDate("req_dum")));
                    xml.escrever("tipoIdade", rs.getString("req_anomes"));
                    xml.escrever("idade", rs.getString("req_idade"));
                    xml.escrever("avisarPaciente", rs.getString("req_avisarpaciente").equalsIgnoreCase("T") ? TRUE : FALSE);
                    xml.escrever("titular", rs.getString("req_titular"));
                    xml.escrever("altura", rs.getString("req_altura"));
                    xml.escrever("peso", rs.getString("req_peso"));
                    xml.escrever("dataRequisicao", Funcoes.formataData(MM_DD_YYYY, rs.getDate("req_datarequisicao")));
                    xml.escrever("neoNatal", rs.getString("req_avisarpaciente").equalsIgnoreCase("T") ? TRUE : FALSE);
                }
                xml.fechar("requisicao");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
            String string = this.montaXmlRetorno("1.0", "getRequisicoes", xml.getXML());
            return string;
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = "<erro>Erro ao recuperar requisicoes.</erro><mensagem>" + ex.getMessage() + "</mensagem>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getExameRequisicao(String chave, String versao, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        String requisicao = "";
        String exame = "";
        String material = "";
        Statement st = this.conexao.getStatement();
        for (String s : parametros) {
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("requisicao")) {
                requisicao = StringUtil.getValor(s, "valor");
                continue;
            }
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("exame")) {
                exame = StringUtil.getValor(s, "valor");
                continue;
            }
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("material")) continue;
            material = StringUtil.getValor(s, "valor");
        }
        this.escreverLog("Obtendo informacoes do exame " + exame + " na requisicao " + requisicao + " para o convenio " + convenio + " na filial " + filial);
        StringBuilder buf = new StringBuilder();
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            buf.append(" select pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, ");
            buf.append(" a.exr_datadigita, a.met_codigo, b.met_descricao, a.exr_situacao from examerequisicao a ");
            buf.append(" left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo ");
            buf.append(" where ");
            buf.append(" a.fil_codigo = ").append(filial).append(" and ");
            buf.append(" a.req_codigo = ").append(requisicao).append(" and ");
            buf.append(" a.exa_codigo = '").append(exame).append("' and ");
            buf.append(" a.mco_codigo = ").append(material);
            buf.append(" and a.exr_excluido = false ");
            String xmlResultado = "";
            String dataResultado = "";
            String metodoResultado = "";
            String metodoDescricao = "";
            String situacaoExame = "";
            this.escreverLog(buf.toString());
            try (ResultSet rs = null;){
                rs = st.executeQuery(buf.toString());
                if (rs.next()) {
                    if (versao.equalsIgnoreCase("1.0")) {
                        xmlResultado = Resultado.getResultadoExportacao(rs.getString("exr_resultado"), true);
                    } else if (versao.equalsIgnoreCase("1.1")) {
                        xmlResultado = StringUtil.compactar(rs.getString("exr_resultado"));
                    }
                    dataResultado = Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_datadigita"));
                    metodoResultado = rs.getString("met_codigo");
                    metodoDescricao = rs.getString("met_descricao");
                    situacaoExame = rs.getString("exr_situacao");
                }
            }
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicao");
            xml.escrever(TIPO, NUMERO);
            xml.escrever("valor", requisicao);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "exame");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", exame);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "material");
            xml.escrever(TIPO, NUMERO);
            xml.escrever("valor", material);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "dataResultado");
            xml.escrever(TIPO, "Data");
            xml.escrever("valor", dataResultado);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "codigoMetodo");
            xml.escrever(TIPO, NUMERO);
            xml.escrever("valor", metodoResultado);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "descricaoMetodo");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", metodoDescricao);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            if (situacaoExame.equalsIgnoreCase("P") && (Funcoes.textoVazio(ParametrosLocais.getParametro("enviaExameParcial")) || ParametrosLocais.getParametro("enviaExameParcial").equalsIgnoreCase(FALSE))) {
                xml.escrever(NOME, "resultado");
                xml.escrever(TIPO, "xml");
                xml.escrever("valor", "");
                xml.fechar(PARAMETRO);
            } else {
                xml.escrever(NOME, "resultado");
                xml.escrever(TIPO, "xml");
                xml.escrever("valor", xmlResultado);
                xml.fechar(PARAMETRO);
            }
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "situacao");
            xml.escrever(TIPO, TEXTO);
            xml.escrever("valor", situacaoExame);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "considerarparcial");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", ParametrosLocais.getParametro("enviaExameParcial").equalsIgnoreCase(TRUE) ? TRUE : FALSE);
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.fecharStatement(st);
        }
        catch (Exception e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        return this.montaXmlRetorno(versao, "getRequisicao", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExamesRequisicao(String chave) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        this.escreverLog("Obtendo situacao/resultados de exames para o convenio " + convenio + " na filial " + filial);
        StringBuilder buf = new StringBuilder();
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, filial, convenio, "examerequisicao"));
            String[] exames = StringUtil.getValores(buf.toString(), "examerequisicao");
            buf.delete(0, buf.length());
            buf.append("select a.req_codigo, b.req_codigoapoiado, a.exr_situacao,  ");
            buf.append("a.exr_datamaterial, a.exr_datadigita, a.exr_dataassina, ");
            buf.append("a.exr_dataentregaprev, ");
            buf.append("a.exr_resposta, a.met_codigo, a.usr_codassina, ");
            buf.append("a.exa_codigo, a.mco_codigo, ");
            buf.append("a.exr_descricaomaterial, ");
            buf.append("a.exr_obs, a.exr_datacortesia, a.usr_codcortesia, ");
            buf.append("a.exr_data, a.exr_intervalojejum, ");
            buf.append("a.exr_codexameorigem, a.exr_codmatorigem ");
            buf.append("from examerequisicao a ");
            buf.append("left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.req_codigo = ?");
            buf.append(" and a.exa_codigo = ?");
            buf.append(" and a.mco_codigo = ?");
            buf.append(" and a.exr_excluido = false ");
            buf.append(" and b.req_excluida = false ");
            PreparedStatement pst = this.conexao.getPreparedStatement(buf.toString());
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicoes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            for (String s : exames) {
                String codigo = StringUtil.getValor(s, "codigo");
                String exame = StringUtil.getValor(s, "exame");
                String material = StringUtil.getValor(s, "material");
                String operacao = StringUtil.getValor(s, "operacao");
                if (!Funcoes.isNumeric(codigo) || !Funcoes.isNumeric(material)) continue;
                pst.setInt(1, Integer.parseInt(codigo));
                pst.setString(2, exame);
                pst.setInt(3, Integer.parseInt(material));
                ResultSet rs = this.conexao.executeQuery(pst);
                if (!Funcoes.textoVazio(operacao) && operacao.equalsIgnoreCase("D")) {
                    StringBuilder bui = new StringBuilder();
                    bui.append("select req_codigoapoiado from requisicao where fil_codigo = ");
                    bui.append(filial);
                    bui.append(" and req_codigo = ");
                    bui.append(codigo);
                    ResultSet rDelete = this.conexao.executeQuery(st2, bui.toString());
                    if (!rDelete.next()) continue;
                    xml.abrir("requisicao_excluir");
                    xml.escrever("codigoApoio", rDelete.getString("req_codigoapoiado"));
                    xml.escrever("exame", exame);
                    xml.escrever("material", material);
                    xml.fechar("requisicao_excluir");
                    continue;
                }
                if (!rs.next()) continue;
                xml.abrir("requisicao");
                xml.escrever("codigoApoio", rs.getString("req_codigoapoiado"));
                xml.escrever("codigoJalis", rs.getString("req_codigo"));
                xml.escrever("exame", exame);
                xml.escrever("material", material);
                xml.escrever("situacao", rs.getString("exr_situacao"));
                xml.escrever("dataMaterial", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_datamaterial")));
                xml.escrever("dataDigitacao", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_datadigita")));
                xml.escrever("dataAssinatura", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_dataassina")));
                xml.escrever("dataEntregaPrevista", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_dataentregaprev")));
                xml.escrever("resposta", rs.getString("exr_resposta"));
                xml.escrever("metodo", rs.getString("met_codigo"));
                xml.escrever("usuarioAssinatura", rs.getString("usr_codassina"));
                xml.escrever("materialDescricao", rs.getString("exr_descricaomaterial"));
                xml.escrever("observacao", rs.getString("exr_obs"));
                xml.escrever("dataCortesia", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_datacortesia")));
                xml.escrever("usuarioCortesia", rs.getString("usr_codcortesia"));
                xml.escrever("data", Funcoes.formataData(MM_DD_YYYY, rs.getDate("exr_data")));
                xml.escrever("tempoJejum", Funcoes.formataData(HH_MM1, rs.getDate("exr_intervalojejum")));
                xml.escrever("exameOrigem", rs.getString("exr_codexameorigem"));
                xml.escrever("materialOrigem", rs.getString("exr_codmatorigem"));
                xml.fechar("requisicao");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception pst) {
                // empty catch block
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(e.getMessage()).append("\n");
            for (StackTraceElement s : e.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            String string = "<erro>" + tmp.toString() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getExameRequisicao", xml.getXML());
    }

    private String geraTagExclusao(String exame, String material) {
        StringBuilder buf = new StringBuilder();
        buf.append("<excluir>");
        buf.append("<codigo>").append(exame).append("</codigo>");
        if (!Funcoes.textoVazio(material)) {
            buf.append("<material>").append(material).append("</material>");
        }
        buf.append("</excluir>");
        return buf.toString();
    }

    private String getOperacao(Statement st, Statement st2, String filial, String convenio, String tabela) throws SQLException {
        this.escreverLog("Buscando novas atualizacoes para o convenio " + convenio + " na filial " + filial + " na tabela " + tabela);
        StringBuilder bui = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        bui.append("select epa_codigo, epa_operacao from exportaapoio where fil_codigo = ");
        bui.append(filial);
        bui.append(" and con_codigo = ");
        bui.append(convenio);
        bui.append(" and epa_tabela = '");
        bui.append(tabela);
        bui.append("' and (epa_exportado = false or epa_exportado is null) order by epa_codigo ");
        ResultSet rs = this.conexao.executeQuery(st, bui.toString());
        bui.delete(0, bui.length());
        while (rs.next()) {
            buf.delete(0, buf.length());
            buf.append("update exportaapoio set epa_exportado = true where fil_codigo = ");
            buf.append(filial);
            buf.append(" and epa_codigo = ");
            buf.append(rs.getString("epa_codigo"));
            this.escreverLog(buf.toString());
            this.conexao.executeUpdate(filial, st2, buf.toString(), true);
            buf.delete(0, buf.length());
            buf.append("delete from exportaapoio where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(convenio);
            buf.append(" and epa_datahora < current_date - 60 and epa_exportado = true ");
            this.conexao.executeUpdate(filial, st2, buf.toString(), true);
            bui.append(rs.getString("epa_operacao"));
        }
        return bui.toString();
    }

    private XMLStringBuilder xmlExameVersao1_0(String filial, String codigoConvenio, String exame, String material) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            Statement st3 = this.conexao.getStatement();
            String layCodigo = "";
            this.escreverLog("Obtendo xml do exame " + exame + " para o convenio " + codigoConvenio + " na filial " + filial);
            StringBuilder buf = new StringBuilder();
            buf.append("select lay_codigoapoio from convenios where fil_codigo = ");
            buf.append(filial).append(" and con_codigo = ").append(codigoConvenio);
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                layCodigo = Integer.toString(rs.getInt("lay_codigoapoio"));
            }
            buf.setLength(0);
            buf.append("select a.exa_codigo, a.exa_descricao, a.exa_diagnostico, a.exa_interferencia ");
            buf.append("from exames a ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and exa_codigo = '");
            buf.append(exame);
            buf.append("'");
            rs = this.conexao.executeQuery(st, buf.toString());
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "exame");
            xml.escrever(TIPO, "xml");
            xml.abrir("valor");
            if (rs.next()) {
                xml.abrir("exame");
                xml.escrever("codigo", rs.getString("exa_codigo"));
                xml.escrever("descricao", StringUtil.tratarEntidadesHTML(rs.getString("exa_descricao")));
                xml.escrever("diagnostico", StringUtil.tratarEntidadesHTML(rs.getString("exa_diagnostico")).replaceAll("<br>", "\n"));
                xml.abrir("materiais");
                buf.setLength(0);
                buf.append("select a.exa_codigo, a.mco_codigo, a.emc_default, a.emc_pergunta, a.emc_preparo, a.emc_instrcoleta, a.");
                buf.append("emc_prepamostra, a.emc_inadequada, a.prz_codigo, a.met_codigo, a.emc_ordem, a.emc_pagina, a.");
                buf.append("emc_conservacao, a.emc_diasconserva, a.emc_temperaturainicial, a.emc_temperaturafinal, a.");
                buf.append("emc_referencia, a.emc_solicitarjejum, a.emc_obrigamedicamento, a.");
                buf.append("emc_marcarexterno, a.emc_obrigadum, a.emc_obrigapeso, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_obrigatempodiurese, ");
                buf.append("b.prz_descricao, c.met_descricao, d.mco_descricao ");
                buf.append("from examematcoleta a ");
                buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
                buf.append("left join metodologia c on a.fil_codigo = c.fil_codigo and a.met_codigo = c.met_codigo ");
                buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.exa_codigo = '");
                buf.append(rs.getString("exa_codigo"));
                buf.append("'");
                if (!Funcoes.textoVazio(material)) {
                    buf.append(" and a.mco_codigo = ").append(material);
                }
                buf.append(" and a.emc_proibidoapoio = false ");
                ResultSet rs2 = this.conexao.executeQuery(st2, buf.toString());
                while (rs2.next()) {
                    xml.abrir("material");
                    xml.escrever("codigo", rs2.getString("mco_codigo"));
                    xml.escrever("prazoEntrega", StringUtil.tratarEntidadesHTML(rs2.getString("prz_descricao")));
                    xml.abrir("modelos");
                    buf.setLength(0);
                    buf.append("select a.*, b.met_descricao from examelayoutmetodo a ");
                    buf.append(" left join metodologia b on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo");
                    buf.append(" where a.fil_codigo = ").append(filial).append(" and ");
                    buf.append(" a.exa_codigo = '").append(rs2.getString("exa_codigo")).append("' and ");
                    buf.append(" a.mco_codigo = ").append(rs2.getString("mco_codigo")).append(" and ");
                    buf.append(" a.lay_codigo = ").append(layCodigo);
                    ResultSet rs3 = this.conexao.executeQuery(st3, buf.toString());
                    while (rs3.next()) {
                        xml.abrir("modelo");
                        xml.abrir("metodo");
                        xml.escrever("codigo", rs3.getString("met_codigo"));
                        xml.escrever("descricao", StringUtil.tratarEntidadesHTML(rs3.getString("met_descricao")));
                        xml.fechar("metodo");
                        xml.abrir("idade");
                        xml.escrever("idadeInicio", rs3.getString("ela_idadeini"));
                        xml.escrever("tipoIdadeInicio", rs3.getString("ela_idadeinitipo"));
                        xml.escrever("idadeFim", rs3.getString("ela_idadefim"));
                        xml.escrever("tipoIdadeFim", rs3.getString("ela_idadefimtipo"));
                        xml.fechar("idade");
                        xml.escrever("formato", DialogoConfigurador.getAtributosParaExportacao(rs3.getString("elm_formato"), true));
                        xml.fechar("modelo");
                    }
                    xml.fechar("modelos");
                    xml.fechar("material");
                }
                xml.fechar("materiais");
                xml.fechar("exame");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.fecharStatement(st3);
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st);
        }
        catch (SQLException e) {
            xml = new XMLStringBuilder();
            xml.escrever("erro", e.getMessage());
        }
        catch (XMLStringBuilderException e) {
            xml = new XMLStringBuilder();
            xml.escrever("erro", e.getMessage());
        }
        return xml;
    }

    private XMLStringBuilder xmlExameVersao1_1(String filial, String codigoConvenio, String exame, String material) {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            Statement st3 = this.conexao.getStatement();
            this.escreverLog("Obtendo xml do exame " + exame + " para o convenio " + codigoConvenio + " na filial " + filial);
            StringBuilder buf = new StringBuilder();
            buf.setLength(0);
            buf.append("select a.exa_codigo, a.exa_descricao, a.exa_sexo, a.exa_horaentrada, ");
            buf.append("a.exa_horasaida, a.exa_filtro, a.exa_diagnostico, a.exa_interferencia, a.exa_sinonimo, ");
            buf.append("a.exa_idademax, a.exa_idademin, a.exa_idademaxtipo, a.exa_idademintipo, ");
            buf.append("a.exa_qtdeamostras, a.exa_autorizacao, a.exa_proibido ");
            buf.append("from exames a ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and exa_codigo = '");
            buf.append(exame);
            buf.append("'");
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "exame");
            xml.escrever(TIPO, "xml");
            xml.abrir("valor");
            if (rs.next()) {
                xml.abrir("exame");
                xml.escrever("codigo", rs.getString("exa_codigo"));
                xml.escrever("descricao", StringUtil.textoDB(rs.getString("exa_descricao")));
                xml.escrever("sexo", StringUtil.textoDB(rs.getString("exa_sexo")));
                xml.escrever("horaEntrada", StringUtil.textoDB(rs.getString("exa_horaentrada")));
                xml.escrever("horaSaida", StringUtil.textoDB(rs.getString("exa_horasaida")));
                xml.escrever("filtro", StringUtil.textoDB(rs.getString("exa_filtro")));
                xml.escrever("diagnostico", StringUtil.textoDB(rs.getString("exa_diagnostico")));
                xml.escrever("interferencia", StringUtil.textoDB(rs.getString("exa_interferencia")));
                xml.escrever("sinonimo", StringUtil.textoDB(rs.getString("exa_sinonimo")));
                xml.escrever("idadeMaxima", StringUtil.textoDB(rs.getString("exa_idademax")));
                xml.escrever("idadeMinima", StringUtil.textoDB(rs.getString("exa_idademin")));
                xml.escrever("idadeMaximaTipo", StringUtil.textoDB(rs.getString("exa_idademaxtipo")));
                xml.escrever("idadeMinimaTipo", StringUtil.textoDB(rs.getString("exa_idademintipo")));
                xml.escrever("qtdeAmostras", StringUtil.textoDB(rs.getString("exa_qtdeamostras")));
                xml.escrever("autorizacao", StringUtil.textoDB(rs.getString("exa_autorizacao")));
                xml.escrever("proibido", rs.getBoolean("exa_proibido") ? TRUE : FALSE);
                xml.abrir("setores");
                buf.setLength(0);
                buf.append("select exa_codigo, set_codigo, ese_default from examesetor where fil_codigo = ");
                buf.append(filial);
                buf.append(" and exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                ResultSet rs2 = this.conexao.executeQuery(st2, buf.toString());
                while (rs2.next()) {
                    xml.abrir("setor");
                    xml.escrever("codigoExame", rs2.getString("exa_codigo"));
                    xml.escrever("codigoSetor", rs2.getString("set_codigo"));
                    xml.escrever("default", rs2.getBoolean("ese_default") ? TRUE : FALSE);
                    xml.fechar("setor");
                }
                xml.fechar("setores");
                xml.abrir("materiais");
                buf.setLength(0);
                buf.append("select a.exa_codigo, a.mco_codigo, a.emc_default, a.emc_pergunta, a.emc_preparo, a.emc_instrcoleta, a.");
                buf.append("emc_prepamostra, a.emc_inadequada, a.prz_codigo, a.met_codigo, a.emc_ordem, a.emc_pagina, a.");
                buf.append("emc_conservacao, a.emc_diasconserva, a.emc_temperaturainicial, a.emc_temperaturafinal, a.");
                buf.append("emc_referencia, a.emc_solicitarjejum, a.emc_obrigamedicamento, a.");
                buf.append("emc_marcarexterno, a.emc_obrigadum, a.emc_obrigapeso, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_obrigatempodiurese, ");
                buf.append("b.prz_descricao, c.met_descricao, d.mco_descricao ");
                buf.append("from examematcoleta a ");
                buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
                buf.append("left join metodologia c on a.fil_codigo = c.fil_codigo and a.met_codigo = c.met_codigo ");
                buf.append("left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
                buf.append("where a.fil_codigo = ");
                buf.append(filial);
                buf.append(" and a.exa_codigo = '");
                buf.append(rs.getString("exa_codigo"));
                buf.append("'");
                if (!Funcoes.textoVazio(material)) {
                    buf.append(" and a.mco_codigo = ").append(material);
                }
                buf.append(" and a.emc_proibidoapoio = false ");
                rs2 = this.conexao.executeQuery(st2, buf.toString());
                while (rs2.next()) {
                    xml.abrir("material");
                    xml.escrever("codigoExame", rs2.getString("exa_codigo"));
                    xml.escrever("codigo", rs2.getString("mco_codigo"));
                    xml.escrever("default", rs2.getBoolean("emc_default") ? TRUE : FALSE);
                    xml.escrever("pergunta", StringUtil.textoDB(rs2.getString("emc_pergunta")));
                    xml.escrever("preparo", StringUtil.textoDB(rs2.getString("emc_preparo")));
                    xml.escrever("instrucaoColeta", StringUtil.textoDB(rs2.getString("emc_instrcoleta")));
                    xml.escrever("preparoAmostra", StringUtil.textoDB(rs2.getString("emc_prepamostra")));
                    xml.escrever("inadequada", StringUtil.textoDB(rs2.getString("emc_inadequada")));
                    xml.escrever("prazo", this.pegaPrazoEntregaConvenio(filial, rs2.getString("prz_codigo"), rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), codigoConvenio));
                    xml.escrever("metodo", rs2.getString("met_codigo"));
                    xml.escrever("ordem", rs2.getString("emc_ordem"));
                    xml.escrever("pagina", rs2.getString("emc_pagina"));
                    xml.escrever("conservacao", StringUtil.textoDB(rs2.getString("emc_conservacao")));
                    xml.escrever("diasConserva", rs2.getString("emc_diasconserva"));
                    xml.escrever("temperaturaInicial", StringUtil.textoDB(rs2.getString("emc_temperaturainicial")));
                    xml.escrever("temperaturaFinal", StringUtil.textoDB(rs2.getString("emc_temperaturafinal")));
                    xml.escrever("referencia", StringUtil.textoDB(rs2.getString("emc_referencia")));
                    xml.escrever("solicitarJejum", rs2.getBoolean("emc_solicitarjejum") ? TRUE : FALSE);
                    xml.escrever("obrigaMedicamento", rs2.getBoolean("emc_obrigamedicamento") ? TRUE : FALSE);
                    xml.escrever("marcarExterno", rs2.getBoolean("emc_marcarexterno") ? TRUE : FALSE);
                    xml.escrever("obrigaDum", rs2.getBoolean("emc_obrigadum") ? TRUE : FALSE);
                    xml.escrever("obrigaPeso", rs2.getBoolean("emc_obrigapeso") ? TRUE : FALSE);
                    xml.escrever("obrigaAltura", rs2.getBoolean("emc_obrigaaltura") ? TRUE : FALSE);
                    xml.escrever("obrigaVolume", rs2.getBoolean("emc_obrigavolume") ? TRUE : FALSE);
                    xml.escrever("obrigaTempoDiurese", rs2.getBoolean("emc_obrigatempodiurese") ? TRUE : FALSE);
                    xml.escrever("prazoDescricao", StringUtil.textoDB(this.pegaPrazoDescricao(filial, rs2.getString("prz_codigo"))));
                    xml.escrever("metodoDescricao", StringUtil.textoDB(rs2.getString("met_descricao")));
                    xml.escrever("materialDescricao", StringUtil.textoDB(rs2.getString("mco_descricao")));
                    xml.abrir("principios");
                    buf.setLength(0);
                    buf.append("select exa_codigo, mco_codigo, prc_codigo, exp_mensagem ");
                    buf.append("from examesprincipios ");
                    buf.append("where fil_codigo = ");
                    buf.append(filial);
                    buf.append(" and exa_codigo = '").append(rs2.getString("exa_codigo"));
                    buf.append("' and mco_codigo = ").append(rs2.getString("mco_codigo"));
                    ResultSet rs3 = this.conexao.executeQuery(st3, buf.toString());
                    while (rs3.next()) {
                        xml.abrir("principio");
                        xml.escrever("codigoExame", rs3.getString("exa_codigo"));
                        xml.escrever("codigoMaterial", rs3.getString("mco_codigo"));
                        xml.escrever("codigoPrincipio", rs3.getString("prc_codigo"));
                        xml.escrever("mensagem", rs3.getString("exp_mensagem"));
                        xml.fechar("principio");
                    }
                    xml.fechar("principios");
                    xml.fechar("material");
                }
                xml.fechar("materiais");
                xml.fechar("exame");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.fecharStatement(st3);
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st);
        }
        catch (SQLException e) {
            xml = new XMLStringBuilder();
            xml.escrever("erro", e.getMessage());
        }
        catch (XMLStringBuilderException e) {
            xml = new XMLStringBuilder();
            xml.escrever("erro", e.getMessage());
        }
        return xml;
    }

    private String pegaPrazoEntregaConvenio(String codigoFilial, String prazoOriginal, String exame, String material, String convenio) throws SQLException {
        String retorno = prazoOriginal;
        this.escreverLog("Obtendo prazo de entrega para o convenio " + convenio + " na filial " + codigoFilial + " para o exame " + exame + " e o prazo original " + prazoOriginal);
        Statement st = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select prz_codigo from examematconvenioprazo where fil_codigo = ").append(codigoFilial);
        buf.append(" and exa_codigo = '").append(exame).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        buf.append(" and con_codigo = ").append(convenio);
        ResultSet rs = this.conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getString("prz_codigo");
        }
        this.conexao.fecharStatement(st);
        return retorno;
    }

    private String pegaPrazoDescricao(String codigoFilial, String prazo) throws SQLException {
        String retorno = "";
        this.escreverLog("Obtendo descri\u00e7\u00e3o do prazo de entrega na filial " + codigoFilial + " para o o prazo " + prazo);
        Statement st = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select prz_descricao from prazoentrega where fil_codigo = ").append(codigoFilial);
        buf.append(" and prz_codigo = ").append(prazo);
        ResultSet rs = this.conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getString("prz_descricao");
        }
        this.conexao.fecharStatement(st);
        return retorno;
    }

    private String getParametrosGerais(String xmlRecebimento) {
        String versao = StringUtil.getValor(xmlRecebimento, "versao");
        String retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar os par\u00e2metros do sistema</erro>";
        this.escreverLog("Obtendo os par\u00e2metros do sistema");
        if (versao.equalsIgnoreCase("1.0")) {
            try {
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "upperCase");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", this.upperCase ? TRUE : FALSE);
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "ordenarSetor");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", this.ordenarSetor ? TRUE : FALSE);
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "conferencia");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", this.needConferencia ? TRUE : FALSE);
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "mascara");
                xml.escrever(TIPO, TEXTO);
                xml.escrever("valor", this.mascaraFone);
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "layout");
                xml.escrever(TIPO, NUMERO);
                xml.escrever("valor", Integer.toString(this.layCodigo));
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "obrigaDosagem");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", this.obrigaDosagem ? TRUE : FALSE);
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "buscaCPF");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", this.buscaCPF ? TRUE : FALSE);
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
                retorno = this.montaXmlRetorno(versao, "getParametrosGerais", xml.getXML());
            }
            catch (XMLStringBuilderException e) {
                retorno = "<erro>Erro ao recuperar oo par\u00e2metros gerais.</erro><mensagem>" + e.getMessage() + "</mensagem>";
            }
        } else {
            retorno = "<erro>N\u00e3o foi poss\u00edvel recuperar os par\u00e2metros gerais, vers\u00e3o incorreta do XML.</erro>";
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMaiorCodigoRequisicaoConvenio(String chave) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo maior requisicao para o convenio " + convenio + " na filial " + filial);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicao");
            xml.escrever(TIPO, NUMERO);
            StringBuilder bui = new StringBuilder();
            bui.append("select max(req_codigoapoiado) as maximo from requisicao where fil_codigo = ");
            bui.append(filial);
            bui.append(" and con_codigo = ");
            bui.append(convenio);
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next() && Funcoes.isNumeric(rs.getString("maximo"))) {
                xml.escrever("valor", rs.getString("maximo"));
            } else {
                xml.escrever("valor", "0");
            }
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return this.montaXmlRetorno("1.0", "getMaiorCodigoRequisicao", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getModeloRelatorio() {
        StringBuilder bui = new StringBuilder("select rel_xml from relatoriosistema where rel_codigo = ");
        bui.append(RelatorioConferenciaEnviados.getModuloAcesso());
        this.escreverLog("Obtendo modelo do relatorio");
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "relatorio");
            xml.escrever(TIPO, "xml");
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                xml.escrever("valor", rs.getString("rel_xml"));
            } else {
                xml.escrever("valor", "");
            }
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return this.montaXmlRetorno("1.0", "getModeloRelatorio", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMensagens(String chave) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo mensagens para o convenio " + convenio + " na filial " + filial);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "mensagens");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder bui = new StringBuilder("select cme_codigo, cme_data, ");
            bui.append("cme_mensagem, cme_titulo from conveniomensagem where fil_codigo = ");
            bui.append(filial);
            bui.append(" and con_codigo = ");
            bui.append(convenio);
            bui.append(" and cme_exportado = false order by cme_codigo");
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            while (rs.next()) {
                xml.abrir("mensagem");
                xml.escrever("data", Funcoes.formataData("yyyy-MM-dd HH:mm:ss", rs.getTimestamp("cme_data")));
                xml.escrever("titulo", rs.getString("cme_titulo"));
                xml.escrever(TEXTO, rs.getString("cme_mensagem"));
                xml.fechar("mensagem");
                bui.setLength(0);
                bui.append("update conveniomensagem set cme_exportado = true where fil_codigo = ");
                bui.append(filial);
                bui.append(" and cme_codigo = ");
                bui.append(rs.getString("cme_codigo"));
                bui.append(" and con_codigo = ");
                bui.append(convenio);
                this.conexao.executeUpdate(filial, st2, bui.toString(), true);
            }
            this.conexao.arquivaSQL();
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (SQLException e) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.escreverLog(e.getMessage());
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st);
        }
        return this.montaXmlRetorno("1.0", "getMensagens", xml.getXML());
    }

    private String getImagemSuporte() {
        this.escreverLog("Obtendo imagem do suporte:" + this.imagemSuporte);
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "imagem");
            xml.escrever(TIPO, TEXTO);
            if (Funcoes.textoVazio(this.imagemSuporte)) {
                xml.escrever("valor", "");
            } else {
                File f = new File(this.imagemSuporte);
                if (!f.exists()) {
                    xml.escrever("valor", "");
                } else {
                    ImageIcon ib = new ImageIcon(ImageIO.read(f));
                    xml.escrever("valor", new Base64().encodeAsString(ImagemUtils.imageToByte(ib.getImage())));
                }
            }
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
        }
        catch (XMLStringBuilderException e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        catch (IOException e) {
            return "<erro>" + e.getMessage() + "</erro>";
        }
        return this.montaXmlRetorno("1.0", "getImagemSuporte", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCidades(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo cidades para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select cid_codigo, cid_nome, cid_uf from cidades where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "cidades");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("cidade");
                    xml.escrever("codigo", rs.getString("cid_codigo"));
                    xml.escrever(NOME, rs.getString("cid_nome"));
                    xml.escrever("estado", rs.getString("cid_uf"));
                    xml.fechar("cidade");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "cidades");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "cidades"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "cidade")) {
                String[] campos;
                String codigo = "";
                String nome = "";
                String estado = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("cid_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("cid_nome")) {
                        nome = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("cid_uf")) continue;
                    estado = StringUtil.getValor(c, "valor");
                }
                xml.abrir("cidade");
                xml.escrever("codigo", codigo);
                xml.escrever(NOME, nome);
                xml.escrever("estado", estado);
                xml.fechar("cidade");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getCidades", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getBairros(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo bairros para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select bai_codigo, bai_descricao from bairro where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "bairros");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("bairro");
                    xml.escrever("codigo", rs.getString("bai_codigo"));
                    xml.escrever("descricao", rs.getString("bai_descricao"));
                    xml.fechar("bairro");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "bairros");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "bairro"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "bairro")) {
                String[] campos;
                String codigo = "";
                String descricao = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("bai_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("bai_descricao")) continue;
                    descricao = StringUtil.getValor(c, "valor");
                }
                xml.abrir("bairro");
                xml.escrever("codigo", codigo);
                xml.escrever("descricao", descricao);
                xml.fechar("bairro");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getBairros", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMedicamentos(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo medicamentos para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select mto_codigo, mto_descricao, mto_fabricante, mto_indicacao, mto_interacao from medicamentos where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "medicamentos");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("medicamento");
                    xml.escrever("codigo", rs.getString("mto_codigo"));
                    xml.escrever("descricao", rs.getString("mto_descricao"));
                    xml.escrever("fabricante", rs.getString("mto_fabricante"));
                    xml.escrever("indicacao", rs.getString("mto_indicacao"));
                    xml.escrever("interacao", rs.getString("mto_interacao"));
                    xml.fechar("medicamento");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "medicamentos");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "medicamentos"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "medicamento")) {
                String[] campos;
                String codigo = "";
                String descricao = "";
                String fabricante = "";
                String indicacao = "";
                String interacao = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("mto_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("mto_descricao")) {
                        descricao = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("mto_fabricante")) {
                        fabricante = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("mto_indicacao")) {
                        indicacao = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("mto_interacao")) continue;
                    interacao = StringUtil.getValor(c, "valor");
                }
                xml.abrir("medicamento");
                xml.escrever("codigo", codigo);
                xml.escrever("descricao", descricao);
                xml.escrever("fabricante", fabricante);
                xml.escrever("indicacao", indicacao);
                xml.escrever("interacao", interacao);
                xml.fechar("medicamento");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getMedicamentos", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFeriados(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo feriados para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select fer_dia, fer_motivo, fer_fixo from feriados where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "feriados");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("feriado");
                    xml.escrever("dia", rs.getString("fer_dia"));
                    xml.escrever("motivo", rs.getString("fer_motivo"));
                    xml.escrever("fixo", rs.getBoolean("fer_fixo") ? TRUE : FALSE);
                    xml.fechar("feriado");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "feriados");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "feriados"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "feriado")) {
                String[] campos;
                String dia = "";
                String motivo = "";
                String fixo = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("fer_dia")) {
                        dia = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("fer_motivo")) {
                        motivo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("fer_fixo")) continue;
                    fixo = StringUtil.getValor(c, "valor");
                }
                xml.abrir("feriado");
                xml.escrever("dia", dia);
                xml.escrever("motivo", motivo);
                xml.escrever("fixo", fixo);
                xml.fechar("feriado");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getFeriados", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLayout(String chave) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo modelos para o convenio " + convenio + " na filial " + filial);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select a.lay_codigo, b.lay_cabec, a.lay_codigoapoio, c.lay_cabec as lay_cabecapoio, a.con_apoiomudamodelo from convenios a ");
        bui.append("left join layout b on a.fil_codigo = b.fil_codigo and a.lay_codigo = b.lay_codigo ");
        bui.append("left join layout c on a.fil_codigo = c.fil_codigo and a.lay_codigoapoio = c.lay_codigo ");
        bui.append(" where a.fil_codigo = ");
        bui.append(filial);
        bui.append(" and a.con_codigo = ");
        bui.append(convenio);
        try {
            xml.abrir(PARAMETROS);
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "codigo");
                xml.escrever(TIPO, NUMERO);
                xml.escrever("valor", !DBUtil.campoNull(rs.getString("lay_codigoapoio")) ? rs.getString("lay_codigoapoio") : rs.getString("lay_codigo"));
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "layout");
                xml.escrever(TIPO, "xml");
                xml.escrever("valor", StringUtil.compactar(!DBUtil.campoNull(rs.getString("lay_codigoapoio")) ? rs.getString("lay_cabecapoio") : rs.getString("lay_cabec")));
                xml.fechar(PARAMETRO);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "permissao");
                xml.escrever(TIPO, BOOLEAN);
                xml.escrever("valor", rs.getString("con_apoiomudamodelo"));
                xml.fechar(PARAMETRO);
            }
            xml.fechar(PARAMETROS);
        }
        catch (Exception e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return this.montaXmlRetorno("1.0", "getLayout", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMedicos(String chave, boolean primeiraConexao, String[] parametros) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        boolean primeiraConexaoMedico = false;
        for (String s : parametros) {
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("primeiraConexaoMedico")) continue;
            primeiraConexaoMedico = StringUtil.getValor(s, "valor").equalsIgnoreCase(TRUE);
        }
        this.escreverLog("Obtendo m\u00e9dicos para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexaoMedico) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select med_nome, med_conselho, med_crm, med_uf from medico where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "medicos");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("medico");
                    xml.escrever(NOME, rs.getString("med_nome"));
                    xml.escrever("conselho", rs.getString("med_conselho"));
                    xml.escrever("crm", rs.getString("med_crm"));
                    xml.escrever("uf", rs.getString("med_uf"));
                    xml.fechar("medico");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "medicos");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "medico"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "medico")) {
                String[] campos;
                String nome = "";
                String conselho = "";
                String crm = "";
                String uf = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("med_nome")) {
                        nome = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("med_conselho")) {
                        conselho = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("med_crm")) {
                        crm = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("med_uf")) continue;
                    uf = StringUtil.getValor(c, "valor");
                }
                xml.abrir("medico");
                xml.escrever(NOME, nome);
                xml.escrever("conselho", conselho);
                xml.escrever("crm", crm);
                xml.escrever("uf", uf);
                xml.fechar("medico");
            }
            StringBuilder bui = new StringBuilder();
            bui.append("select med_nome, med_conselho, med_crm, med_uf from medico where fil_codigo = ").append(filial);
            bui.append(" and med_crm = '").append(ParametrosLocais.getParametro("medicoCrmPadraoRMI"));
            bui.append("' and med_uf = '").append(ParametrosLocais.getParametro("medicoUFPadraoRMI"));
            bui.append("' and med_conselho = '").append(ParametrosLocais.getParametro("medicoConselhoPadraoRMI")).append("'");
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                xml.abrir("medico");
                xml.escrever(NOME, rs.getString("med_nome"));
                xml.escrever("conselho", rs.getString("med_conselho"));
                xml.escrever("crm", rs.getString("med_crm"));
                xml.escrever("uf", rs.getString("med_uf"));
                xml.fechar("medico");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getMedicos", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrazoEntrega(String chave, String versao, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo prazos entrega para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : "") + " - V: " + versao);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select prz_codigo, prz_descricao ");
                if (versao.equalsIgnoreCase("1.1")) {
                    bui.append(", prz_prazo, prz_dias, prz_horaentrada, prz_horasaida, prz_horasaidasabado ");
                }
                bui.append(" from prazoentrega where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "prazos");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("prazo");
                    xml.escrever("codigo", rs.getString("prz_codigo"));
                    xml.escrever("descricao", rs.getString("prz_descricao"));
                    if (versao.equalsIgnoreCase("1.1")) {
                        xml.escrever("prazoPrazo", rs.getString("prz_prazo"));
                        xml.escrever("dias", rs.getString("prz_dias"));
                        xml.escrever("horaEntrada", Funcoes.formataData(HH_MM1, rs.getDate("prz_horaentrada")));
                        xml.escrever("horaSaida", Funcoes.formataData(HH_MM1, rs.getDate("prz_horasaida")));
                        xml.escrever("horaSaidaSabado", Funcoes.formataData(HH_MM1, rs.getDate("prz_horasaidasabado")));
                    }
                    xml.fechar("prazo");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "prazos");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "prazoentrega"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "prazoentrega")) {
                String[] campos;
                String codigo = "";
                String descricao = "";
                String prazo = "";
                String dias = "";
                String horaEntrada = "";
                String horaSaida = "";
                String horaSaidaSabado = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_descricao")) {
                        descricao = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_prazo")) {
                        prazo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_horaentrada")) {
                        horaEntrada = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_horasaida")) {
                        horaSaida = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("prz_horasaidasabado")) continue;
                    horaSaidaSabado = StringUtil.getValor(c, "valor");
                }
                xml.abrir("prazo");
                xml.escrever("codigo", codigo);
                xml.escrever("descricao", descricao);
                if (versao.equalsIgnoreCase("1.1")) {
                    xml.escrever("prazoPrazo", prazo);
                    xml.escrever("dias", dias);
                    xml.escrever("horaEntrada", Funcoes.textoVazio(horaEntrada) || horaEntrada.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM1, Funcoes.stringToDate(HH_MM1, horaEntrada)));
                    xml.escrever("horaSaida", Funcoes.textoVazio(horaSaida) || horaSaida.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM1, Funcoes.stringToDate(HH_MM1, horaSaida)));
                    xml.escrever("horaSaidaSabado", Funcoes.textoVazio(horaSaidaSabado) || horaSaidaSabado.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM1, Funcoes.stringToDate(HH_MM1, horaSaidaSabado)));
                }
                xml.fechar("prazo");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        this.escreverLog("13");
        return this.montaXmlRetorno(versao, "getPrazoEntrega", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSetores(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo setores para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select set_codigo, set_descricao, set_responsavel, set_cor, set_sigla from setores where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "setores");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("setor");
                    xml.escrever("codigo", rs.getString("set_codigo"));
                    xml.escrever("descricao", rs.getString("set_descricao"));
                    xml.escrever("responsavel", rs.getString("set_responsavel"));
                    xml.escrever("cor", rs.getString("set_cor"));
                    xml.escrever("sigla", rs.getString("set_sigla"));
                    xml.fechar("setor");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "prazos");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "setores"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "setor")) {
                String[] campos;
                String codigo = "";
                String descricao = "";
                String responsavel = "";
                String cor = "";
                String sigla = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("set_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("set_descricao")) {
                        descricao = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("set_responsavel")) {
                        responsavel = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("set_cor")) {
                        cor = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("set_sigla")) continue;
                    sigla = StringUtil.getValor(c, "valor");
                }
                xml.abrir("setor");
                xml.escrever("codigo", codigo);
                xml.escrever("descricao", descricao);
                xml.escrever("responsavel", responsavel);
                xml.escrever("cor", cor);
                xml.escrever("sigla", sigla);
                xml.fechar("setor");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getSetores", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRecipientes(String chave, boolean primeiraConexao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo setores para o convenio " + convenio + " na filial " + filial + (primeiraConexao ? " - Primeira conexao" : ""));
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        if (primeiraConexao) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("select rec_codigo, rec_descricao, rec_tipo, rec_capacidade, unm_codigo from recipientes where fil_codigo = ").append(filial);
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                xml.abrir(PARAMETROS);
                xml.abrir(PARAMETRO);
                xml.escrever(NOME, "recipientes");
                xml.escrever(TIPO, "lista");
                xml.abrir("valor");
                while (rs.next()) {
                    xml.abrir("recipiente");
                    xml.escrever("codigo", rs.getString("rec_codigo"));
                    xml.escrever("descricao", rs.getString("rec_descricao"));
                    xml.escrever(TIPO, rs.getString("rec_tipo"));
                    xml.escrever("capacidade", rs.getString("rec_capacidade"));
                    xml.escrever("unidadeMedida", rs.getString("unm_codigo"));
                    xml.fechar("recipiente");
                }
                xml.fechar("valor");
                xml.fechar(PARAMETRO);
                xml.fechar(PARAMETROS);
            }
            catch (SQLException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            catch (XMLStringBuilderException e) {
                String rs = "<erro>" + e.getMessage() + "</erro>";
                return rs;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        try {
            String[] lista;
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "prazos");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            StringBuilder buf = new StringBuilder();
            buf.append(this.getOperacao(st, st2, filial, convenio, "setores"));
            for (String s : lista = StringUtil.getValores(buf.toString(), "setor")) {
                String[] campos;
                String codigo = "";
                String descricao = "";
                String tipo = "";
                String capacidade = "";
                String unidadeMedida = "";
                for (String c : campos = StringUtil.getValores(s, "campo")) {
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("rec_codigo")) {
                        codigo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("rec_descricao")) {
                        descricao = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("rec_tipo")) {
                        tipo = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (StringUtil.getValor(c, NOME).equalsIgnoreCase("rec_capacidade")) {
                        capacidade = StringUtil.getValor(c, "valor");
                        continue;
                    }
                    if (!StringUtil.getValor(c, NOME).equalsIgnoreCase("unm_codigo")) continue;
                    unidadeMedida = StringUtil.getValor(c, "valor");
                }
                xml.abrir("recipiente");
                xml.escrever("codigo", codigo);
                xml.escrever("descricao", descricao);
                xml.escrever(TIPO, tipo);
                xml.escrever("capacidade", capacidade);
                xml.escrever("unidadeMedida", unidadeMedida);
                xml.fechar("recipiente");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
        }
        catch (SQLException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        catch (XMLStringBuilderException e) {
            String string = "<erro>" + e.getMessage() + "</erro>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return this.montaXmlRetorno("1.0", "getRecipientes", xml.getXML());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUsuarios(String versao) {
        Statement st = this.conexao.getStatement();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "usuarios");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            ResultSet rs = this.conexao.executeQuery(st, "select usr_codigo, usr_nome, usr_assinatura from usuario where usr_assinatura <> ''");
            while (rs.next()) {
                xml.abrir("usuario");
                xml.escrever("codigo", rs.getString("usr_codigo"));
                xml.escrever(NOME, rs.getString("usr_nome"));
                xml.escrever("assinatura", StringUtil.compactar(rs.getString("usr_assinatura")));
                xml.fechar("usuario");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            String string = this.montaXmlRetorno(versao, "getUsuarios", xml.getXML());
            return string;
        }
        catch (Exception e) {
            String string = "<erro>Erro ao recuperar os usu\u00e1rios.</erro><mensagem>" + e.getMessage() + "</mensagem>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPacientes(String chave, String versao) {
        String convenio = this.pegaConvenioChave(chave);
        String filial = this.pegaFilialChave(chave);
        this.escreverLog("Obtendo pacientes para o convenio " + convenio + " na filial " + filial);
        XMLStringBuilder xml = new XMLStringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        try {
            buf.append(this.getOperacao(st, st2, filial, convenio, "paciente"));
            String[] pacientes = StringUtil.getValores(buf.toString(), "paciente");
            buf.delete(0, buf.length());
            buf.append("select pac_codigo, bai_codigo, pac_nome, pac_sexo, ");
            buf.append("pac_datanasc, pac_vip, pac_grpsangue, pac_fatorrh, pac_fatordu, ");
            buf.append("pac_cor, pac_observ, pac_dadoclinico, pac_peso, pac_altura, ");
            buf.append("pac_matricconv, pac_titularconv, pac_profissao, pac_fumante, ");
            buf.append("pac_diabetico, pac_rg, pac_cpf, pac_estcivil, pac_numfilho, ");
            buf.append("pac_dum, cid_codigo, pac_fax, pac_celular, ");
            buf.append("pac_fonecomercial, pac_fone, pac_cep, pac_complemento, ");
            buf.append("pac_endereco, pac_numeroendereco, pac_email, pac_anomes, pac_idade, con_codigo, ");
            buf.append("med_conselho, med_crm, med_uf, pac_fonecontato, pac_nomecontato, ");
            buf.append("pac_mae, pac_pai, pac_maladireta, pac_senhaweb, pac_codigoapoiado ");
            buf.append("from paciente ");
            buf.append("where fil_codigo = ");
            buf.append(filial);
            buf.append(" and pac_codigoapoiado is not null and pac_codigo = ?");
            PreparedStatement pst = this.conexao.getPreparedStatement(buf.toString());
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "pacientes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            for (String s : pacientes) {
                String codigo = StringUtil.getValor(s, "codigo");
                if (!Funcoes.isNumeric(codigo)) continue;
                pst.setLong(1, Long.parseLong(codigo));
                ResultSet rs = this.conexao.executeQuery(pst);
                if (versao.equalsIgnoreCase("1.0")) {
                    if (!rs.next()) continue;
                    xml.abrir("paciente");
                    xml.escrever("xml", XMLUtil.criaXML("paciente", new Registro(rs), new String[]{"pac_codigo"}));
                    xml.fechar("paciente");
                    continue;
                }
                xml.abrir("paciente");
                if (rs.next()) {
                    xml.escrever("codigoJalis", rs.getString("pac_codigo"));
                    xml.escrever("bairro", rs.getString("bai_codigo"));
                    xml.escrever(NOME, rs.getString("pac_nome"));
                    xml.escrever("sexo", rs.getString("pac_sexo"));
                    xml.escrever("dataNascimento", Funcoes.formataData(MM_DD_YYYY, rs.getDate("pac_datanasc")));
                    xml.escrever("vip", rs.getString("pac_vip").equalsIgnoreCase("T") ? TRUE : FALSE);
                    xml.escrever("grupoSangue", rs.getString("pac_grpsangue"));
                    xml.escrever("fatorRH", rs.getString("pac_fatorrh"));
                    xml.escrever("fatorDU", rs.getString("pac_fatordu"));
                    xml.escrever("cor", rs.getString("pac_cor"));
                    xml.escrever("observacao", rs.getString("pac_observ"));
                    xml.escrever("dadosClinicos", rs.getString("pac_dadoclinico"));
                    xml.escrever("peso", rs.getString("pac_peso"));
                    xml.escrever("altura", rs.getString("pac_altura"));
                    xml.escrever("matriculaConvenio", rs.getString("pac_matricconv"));
                    xml.escrever("titularConvenio", rs.getString("pac_titularconv"));
                    xml.escrever("profissao", rs.getString("pac_profissao"));
                    xml.escrever("fumante", rs.getString("pac_fumante").equalsIgnoreCase("S") ? TRUE : FALSE);
                    xml.escrever("diabetico", rs.getString("pac_diabetico").equalsIgnoreCase("S") ? TRUE : FALSE);
                    xml.escrever("rg", rs.getString("pac_rg"));
                    xml.escrever("cpf", rs.getString("pac_cpf"));
                    xml.escrever("estadoCivil", rs.getString("pac_estcivil"));
                    xml.escrever("numeroFilhos", rs.getString("pac_numfilho"));
                    xml.escrever("dum", Funcoes.formataData(MM_DD_YYYY, rs.getDate("pac_dum")));
                    xml.escrever("cidade", rs.getString("cid_codigo"));
                    xml.escrever("fax", rs.getString("pac_fax"));
                    xml.escrever("celular", rs.getString("pac_celular"));
                    xml.escrever("foneComercial", rs.getString("pac_fonecomercial"));
                    xml.escrever("fone", rs.getString("pac_fone"));
                    xml.escrever("cep", rs.getString("pac_cep"));
                    xml.escrever("complemento", rs.getString("pac_complemento"));
                    xml.escrever("endereco", rs.getString("pac_endereco"));
                    xml.escrever("numeroEndereco", rs.getString("pac_numeroendereco"));
                    xml.escrever("email", rs.getString("pac_email"));
                    xml.escrever("tipoIdade", rs.getString("pac_anomes"));
                    xml.escrever("idade", rs.getString("pac_idade"));
                    xml.escrever("convenio", rs.getString("con_codigo"));
                    xml.escrever("medicoConselho", rs.getString("med_conselho"));
                    xml.escrever("medicoCrm", rs.getString("med_crm"));
                    xml.escrever("medicoUf", rs.getString("med_uf"));
                    xml.escrever("foneContato", rs.getString("pac_fonecontato"));
                    xml.escrever("nomeContato", rs.getString("pac_nomecontato"));
                    xml.escrever("mae", rs.getString("pac_mae"));
                    xml.escrever("pai", rs.getString("pac_pai"));
                    xml.escrever("malaDireta", rs.getString("pac_maladireta").equalsIgnoreCase("T") ? TRUE : FALSE);
                    xml.escrever("codigoApoio", rs.getString("pac_codigoapoiado"));
                }
                xml.fechar("paciente");
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
            String string = this.montaXmlRetorno(versao, "getPacientes", xml.getXML());
            return string;
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string = "<erro>Erro ao recuperar pacientes.</erro><mensagem>" + ex.getMessage() + "</mensagem>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String getEtiquetas(String chave, String[] parametros) {
        void object;
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        String lote = "";
        Statement st = this.conexao.getStatement();
        Statement st1 = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        Statement st3 = this.conexao.getStatement();
        String[] stringArray = parametros;
        int n = stringArray.length;
        boolean bl = false;
        while (object < n) {
            String s = stringArray[object];
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("lote")) {
                lote = StringUtil.getValor(s, "valor");
            }
            ++object;
        }
        this.escreverLog("Obtendo etiquetas para o convenio " + convenio + " na filial " + filial + " para o lote " + lote);
        try {
            StringBuilder bui = new StringBuilder("select con_apoiosemetiqueta from convenios where fil_codigo = ");
            bui.append(filial).append(" and con_codigo = ").append(convenio);
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            boolean bl2 = rs.next() && rs.getBoolean("con_apoiosemetiqueta");
            bui.setLength(0);
            bui.append("select a.req_codigo from loteapoiorequisicao a ");
            bui.append("left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id ");
            bui.append("where a.fil_codigo = ");
            bui.append(filial);
            bui.append(" and b.con_codigo = ");
            bui.append(convenio);
            bui.append(" and b.lot_codigo = ");
            bui.append(lote);
            rs = this.conexao.executeQuery(st, bui.toString());
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir(PARAMETROS);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "sucesso");
            xml.escrever(TIPO, BOOLEAN);
            xml.escrever("valor", TRUE);
            xml.fechar(PARAMETRO);
            xml.abrir(PARAMETRO);
            xml.escrever(NOME, "requisicoes");
            xml.escrever(TIPO, "lista");
            xml.abrir("valor");
            while (rs.next()) {
                if (!bl2) {
                    xml.abrir("requisicao");
                    xml.escrever("codigoJalis", rs.getString("req_codigo"));
                    xml.escrever("etiqueta", StringUtil.textoXML(Impressao.getEtiquetaColetaApoio(filial, rs.getString("req_codigo"), st1, st2, st3, true)));
                    xml.fechar("requisicao");
                    continue;
                }
                Impressao.getEtiquetaColetaApoio(filial, rs.getString("req_codigo"));
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            this.conexao.arquivaSQL();
            String string = this.montaXmlRetorno("1.0", "getEtiquetas", xml.getXML());
            return string;
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception rs) {
                // empty catch block
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(ex.getMessage()).append("\n");
            for (StackTraceElement s : ex.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            String string = "<erro>Erro ao recuperar etiquetas.</erro><mensagem>" + tmp.toString() + "</mensagem>";
            return string;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st1);
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String validarExamesLote(String chave, String[] parametros) {
        String filial = this.pegaFilialChave(chave);
        String convenio = this.pegaConvenioChave(chave);
        String[] exames = null;
        for (String string : parametros) {
            if (!StringUtil.getValor(string, NOME).equalsIgnoreCase("exames")) continue;
            exames = StringUtil.getValores(StringUtil.getValor(string, "valor"), "exame");
        }
        this.escreverLog("Validando exames para o convenio " + convenio + " na filial " + filial);
        String sql = "select count(*) as count from examematcoleta where fil_codigo = ? and exa_codigo = ? and mco_codigo = ?";
        PreparedStatement ps = this.conexao.getPreparedStatement(sql);
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir(PARAMETROS);
        xml.abrir(PARAMETRO);
        xml.escrever(NOME, "exames");
        xml.escrever(TIPO, "lista");
        xml.abrir("valor");
        try {
            for (String s : exames) {
                String exame = StringUtil.getValor(s, "codigoExame");
                String material = StringUtil.getValor(s, "codigoMaterial");
                ps.clearParameters();
                ps.setInt(1, Integer.parseInt(filial));
                ps.setString(2, exame);
                ps.setInt(3, Integer.parseInt(material));
                xml.abrir("exame");
                xml.escrever("codigoExame", exame);
                xml.escrever("codigoMaterial", material);
                try (ResultSet rs = null;){
                    rs = ps.executeQuery();
                    if (rs.next() && rs.getInt("count") > 0) {
                        xml.escrever("validado", TRUE);
                    } else {
                        xml.escrever("validado", FALSE);
                    }
                    xml.fechar("exame");
                }
            }
            xml.fechar("valor");
            xml.fechar(PARAMETRO);
            xml.fechar(PARAMETROS);
            return this.montaXmlRetorno("1.0", "validarExames", xml.getXML());
        }
        catch (Exception exception) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            StringBuilder tmp = new StringBuilder();
            tmp.append(exception.getMessage()).append("\n");
            for (StackTraceElement s : exception.getStackTrace()) {
                tmp.append(s.toString()).append("\n");
            }
            return "<erro>Erro ao Validar Exames.</erro><mensagem>" + tmp.toString() + "</mensagem>";
        }
    }

    @Override
    public String executaComando(String chave, String xml) {
        String operacao = StringUtil.getValor(xml, "operacao");
        String hash = StringUtil.getValor(xml, "hash");
        String retorno = "";
        String nomeOperacao = StringUtil.getValor(operacao, NOME);
        String chaveParametro = "";
        String versao = StringUtil.getValor(operacao, "versao");
        if (!this.validaHash(hash, "<operacao>" + operacao + "</operacao>")) {
            this.conexao.shutdown();
            return "<erro>Hash incorreto</erro>";
        }
        if (!(nomeOperacao.equalsIgnoreCase("getCodigoCliente") || nomeOperacao.equalsIgnoreCase("validaConvenio") || nomeOperacao.equalsIgnoreCase("getModeloRelatorio") || nomeOperacao.equalsIgnoreCase("getImagemSuporte") || this.validaChave(chave))) {
            this.conexao.shutdown();
            return "<erro>Chave incorreta</erro>";
        }
        String[] parametros = StringUtil.getValores(StringUtil.getValor(xml, PARAMETROS), PARAMETRO);
        boolean primeiraConexao = false;
        for (String s : parametros) {
            if (StringUtil.getValor(s, NOME).equalsIgnoreCase("primeiraConexao")) {
                primeiraConexao = StringUtil.getValor(s, "valor").equalsIgnoreCase(TRUE);
                continue;
            }
            if (!StringUtil.getValor(s, NOME).equalsIgnoreCase("chave")) continue;
            chaveParametro = StringUtil.getValor(s, "valor");
        }
        if (!Funcoes.textoVazio(chaveParametro) && !chaveParametro.equalsIgnoreCase(chave)) {
            this.conexao.shutdown();
            return "<erro>Chaves incompat\u00edveis</erro>";
        }
        if (nomeOperacao.equalsIgnoreCase("getCodigoCliente")) {
            retorno = this.getCodigoCliente(operacao);
        } else if (nomeOperacao.equalsIgnoreCase("getFiliais")) {
            retorno = this.getFiliais(operacao);
        } else if (nomeOperacao.equalsIgnoreCase("validaConvenio")) {
            retorno = this.validaConvenio(operacao);
        } else if (nomeOperacao.equalsIgnoreCase("getMaiorLoteConvenio")) {
            retorno = this.getMaiorLoteConvenio(chave);
        } else if (nomeOperacao.equalsIgnoreCase("getMetodos")) {
            retorno = this.getMetodos(chave, primeiraConexao);
        } else if (nomeOperacao.equalsIgnoreCase("getMaterialColeta")) {
            retorno = this.getMaterialColeta(chave, versao, primeiraConexao);
        } else if (nomeOperacao.equalsIgnoreCase("getListagemExames")) {
            retorno = this.getListagemExames(chave, primeiraConexao);
        } else if (nomeOperacao.equalsIgnoreCase("getExame")) {
            retorno = this.getExame(chave, versao, parametros);
        } else if (nomeOperacao.equalsIgnoreCase("enviarPaciente")) {
            retorno = this.enviarPaciente(chave, versao, parametros);
        } else if (nomeOperacao.equalsIgnoreCase("criarLote")) {
            if (versao.equalsIgnoreCase("1.0")) {
                retorno = this.criarLoteVersao1_0(chave, parametros);
            } else if (versao.equalsIgnoreCase("1.1")) {
                retorno = this.criarLoteVersao1_1(chave, parametros);
            }
        } else {
            retorno = nomeOperacao.equalsIgnoreCase("getRequisicao") ? this.getRequisicao(chave, parametros) : (nomeOperacao.equalsIgnoreCase("getExameRequisicao") ? this.getExameRequisicao(chave, versao, parametros) : (nomeOperacao.equalsIgnoreCase("getParametrosGerais") ? this.getParametrosGerais(operacao) : (nomeOperacao.equalsIgnoreCase("getMaiorCodigoRequisicaoConvenio") ? this.getMaiorCodigoRequisicaoConvenio(chave) : (nomeOperacao.equalsIgnoreCase("getModeloRelatorio") ? this.getModeloRelatorio() : (nomeOperacao.equalsIgnoreCase("getMensagens") ? this.getMensagens(chave) : (nomeOperacao.equalsIgnoreCase("getImagemSuporte") ? this.getImagemSuporte() : (nomeOperacao.equalsIgnoreCase("getCidades") ? this.getCidades(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getBairros") ? this.getBairros(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getLayout") ? this.getLayout(chave) : (nomeOperacao.equalsIgnoreCase("getMedicos") ? this.getMedicos(chave, primeiraConexao, parametros) : (nomeOperacao.equalsIgnoreCase("getMedicamentos") ? this.getMedicamentos(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getFeriados") ? this.getFeriados(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getPrazoEntrega") ? this.getPrazoEntrega(chave, versao, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getSetores") ? this.getSetores(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getRecipientes") ? this.getRecipientes(chave, primeiraConexao) : (nomeOperacao.equalsIgnoreCase("getUsuarios") ? this.getUsuarios(versao) : (nomeOperacao.equalsIgnoreCase("getPacientes") ? this.getPacientes(chave, versao) : (nomeOperacao.equalsIgnoreCase("getRequisicoes") ? this.getRequisicoes(chave) : (nomeOperacao.equalsIgnoreCase("getExamesRequisicao") ? this.getExamesRequisicao(chave) : (nomeOperacao.equalsIgnoreCase("getEtiquetas") ? this.getEtiquetas(chave, parametros) : (nomeOperacao.equalsIgnoreCase("validarExamesLote") ? this.validarExamesLote(chave, parametros) : "<erro>Comando n\u00e3o encontrado</erro>")))))))))))))))))))));
        }
        this.conexao.shutdown();
        return retorno;
    }

    private String gerarChave(String filial, String convenio) {
        String s = Funcoes.preencheZero(filial, 3);
        s = s + Funcoes.preencheZero(convenio, 5);
        s = StringUtil.encriptar(Long.parseLong(s));
        return s;
    }

    private boolean validaChave(String chave) {
        try {
            String s = Long.toString(StringUtil.desencriptar(chave));
            s = Funcoes.preencheVazio(s, "0", 8, 1);
            return s.length() == 8;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean validaHash(String hash, String operacao) {
        try {
            String h = StringUtil.calcularCodigoHash(operacao);
            return h.equals(hash);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
    }

    private String gerarHash(String xml) {
        String hash = "";
        try {
            hash = StringUtil.calcularCodigoHash(xml);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hash;
    }

    private String montaXmlRetorno(String versao, String operacao, String parametros) {
        StringBuilder xml = new StringBuilder();
        xml.append("<operacao>\n");
        xml.append("  <nome>").append(operacao).append("</nome>\n");
        xml.append("  <versao>").append(versao).append("</versao>\n");
        xml.append("  <retorno>\n").append(parametros).append("</retorno>\n");
        xml.append("</operacao>\n");
        String hash = this.gerarHash(xml.toString());
        xml.append("<hash>").append(hash).append("</hash>");
        return xml.toString();
    }

    private String pegaConvenioChave(String chave) {
        String s = Long.toString(StringUtil.desencriptar(chave));
        s = Funcoes.preencheVazio(s, "0", 8, 1);
        s = s.substring(3);
        return Integer.toString(Integer.parseInt(s));
    }

    private String pegaFilialChave(String chave) {
        String s = Long.toString(StringUtil.desencriptar(chave));
        s = Funcoes.preencheVazio(s, "0", 8, 1);
        s = s.substring(0, 3);
        return Integer.toString(Integer.parseInt(s));
    }
}

