/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.Conexao;
import jalis.apoio.servidorws.DadoParsers;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Variaveis;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ParserImportacaoJalis {
    private static final String TAG_REQ_CODIGO = "req_codigo";
    private static final String TAG_CODIGO_EXAME = "codigoExame";
    private static final String TAG_DATA_MATERIAL = "dataMaterial";
    private static final String TAG_VOLUME_DIURESE = "volumeDiurese";
    private static final String TAG_CODIGO_AUTORIZACAO = "codigoAutorizacao";
    private static final String TAG_DATA_VALIDADE_AUTORIZACAO = "dataValidadeAutorizacao";
    private static final String TAG_DATA_AUTORIZACAO = "dataAutorizacao";
    private static final String TAG_TEMPO_DIURESE = "tempoDiurese";
    private static final String TAG_TEMPO_JEJUM = "tempoJejum";
    private static final String TAG_DESCRICAO_MATERIAL = "descricaoMaterial";
    private static final String TAG_DATA_COLETA = "dataColeta";
    private static final String TAG_CODIGO_MATERIAL = "codigoMaterial";
    private static final String TAG_MEDICO_UF = "medicoUf";
    private static final String TAG_MEDICO_CONSELHO = "medicoConselho";
    private static final String TAG_MEDICO_CRM = "medicoCrm";
    private static final String TAG_MEDICO_NOME = "medicoNome";
    private static final String TAG_OBS = "obs";
    private static final String TAG_CODIGO = "codigo";
    private static final String TAG_EXAME = "exame";
    private static final String TAG_MAE = "mae";
    private static final String TAG_PAI = "pai";
    private static final String TAG_RG = "rg";
    private static final String TAG_CPF = "cpf";
    private static final String TAG_DIABETICO = "diabetico";
    private static final String TAG_FUMANTE = "fumante";
    private static final String TAG_PROFISSAO = "profissao";
    private static final String TAG_NUMERO_FILHOS = "numeroFilhos";
    private static final String TAG_NR_FILHOS = "nrFilhos";
    private static final String TAG_ESTADO_CIVIL = "estadoCivil";
    private static final String TAG_ADICIONAIS = "adicionais";
    private static final String TAG_CODIGO_AMB_SOLUS = "codigoAmbSolus";
    private static final String TAG_CODIGO_MATERIAL_SOLUS = "codigoMaterialSolus";
    private static final String TAG_QTDE_AMOSTRA_SOLUS = "qtdeAmostraSolus";
    private static final String TAG_COD_EXAME_ORIGEM = "codexameorigem";
    private static final String TAG_COD_MAT_ORIGEM = "codmatorigem";
    private static final String TAG_DADOS_CLINICOS = "dadosClinicos";
    private static final String TAG_CLINICO = "clinico";
    private static final String TAG_OBSERVACAO = "obs";
    private static final String TAG_FATOR_DU = "fatorDU";
    private static final String TAG_FATOR_RH = "fatorRH";
    private static final String TAG_GRUPO_SANGUE = "grupoSangue";
    private static final String TAG_SANGUE = "sangue";
    private static final String TAG_DUM = "dum";
    private static final String TAG_COR = "cor";
    private static final String TAG_NASCIMENTO = "nascimento";
    private static final String TAG_SEXO = "sexo";
    private static final String TAG_NOME = "nome";
    private static final String TAG_GUIA = "guia";
    private static final String TAG_MATRICULA = "matricula";
    private static final String TAG_DEVE_GUIA = "deveGuia";
    private static final String TAG_DATA_GUIA = "dataGuia";
    private static final String TAG_VALIDADE_GUIA = "validadeGuia";
    private static final String TAG_ALTURA = "altura";
    private static final String TAG_PESO = "peso";
    private static final String TAG_TIPO_IDADE = "tipoIdade";
    private static final String TAG_IDADE = "idade";
    private static final String TAG_EXAMES = "exames";
    private static final String TAG_NEONATO = "neoNatal";
    private static final String TAG_GESTANTE = "gestante";
    private static final String TAG_PACIENTE = "paciente";
    private static final String TAG_CODIGO_EXTERNO = "codigoExterno";

    private ParserImportacaoJalis() {
    }

    public static List<Registro> parseRequisicoes(Node nodeRequisicoes, Logger logger, Map<String, String[]> rejeitados) throws ParseException {
        Conexao conexao = new Conexao(Variaveis.caminhoBanco);
        ArrayList<Registro> requisicoes = new ArrayList<Registro>();
        NodeList nodeListRequisicoes = nodeRequisicoes.getChildNodes();
        for (int i = 0; i < nodeListRequisicoes.getLength(); ++i) {
            Registro requisicao;
            if (!nodeListRequisicoes.item(i).getNodeName().equalsIgnoreCase("requisicao") || (requisicao = ParserImportacaoJalis.parseRequisicao(nodeListRequisicoes.item(i), logger, conexao, rejeitados)) == null) continue;
            requisicoes.add(requisicao);
        }
        return requisicoes;
    }

    private static Registro parseRequisicao(Node nodeRequisicao, Logger logger, Conexao conexao, Map<String, String[]> rejeitados) throws ParseException {
        Registro requisicao = new Registro();
        NodeList nodeListRequisicao = nodeRequisicao.getChildNodes();
        requisicao.setValor(TAG_DEVE_GUIA, false);
        for (int i = 0; i < nodeListRequisicao.getLength(); ++i) {
            Node nodeItemRequisicao = nodeListRequisicao.item(i);
            String nodeName = nodeItemRequisicao.getNodeName();
            if (nodeName.equalsIgnoreCase(TAG_CODIGO_EXTERNO)) {
                requisicao.setValor(TAG_CODIGO_EXTERNO, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_PACIENTE)) {
                requisicao.setValor(TAG_PACIENTE, ParserImportacaoJalis.parsePaciente(nodeItemRequisicao, logger));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_GESTANTE)) {
                requisicao.setValor(TAG_GESTANTE, DadoParsers.BOOLEANO.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_NEONATO)) {
                requisicao.setValor(TAG_NEONATO, DadoParsers.BOOLEANO.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_EXAMES)) {
                requisicao.setValor(TAG_EXAMES, new ArrayList());
                for (Registro exame : ParserImportacaoJalis.parseExames(nodeItemRequisicao, conexao, logger, rejeitados)) {
                    requisicao.getValor(TAG_EXAMES, List.class).add(exame);
                }
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_IDADE)) {
                if (!nodeItemRequisicao.getTextContent().isEmpty() && Funcoes.isNumeric(nodeItemRequisicao.getTextContent())) {
                    requisicao.setValor(TAG_IDADE, Integer.parseInt(nodeItemRequisicao.getTextContent()));
                    continue;
                }
                if (requisicao.getValor(TAG_PACIENTE) == null || ((Registro)requisicao.getValor(TAG_PACIENTE)).getValor(TAG_IDADE) == null) continue;
                int idade = ((Registro)requisicao.getValor(TAG_PACIENTE)).getInt(TAG_IDADE);
                requisicao.setValor(TAG_IDADE, idade);
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_TIPO_IDADE)) {
                if (nodeItemRequisicao.getTextContent() != null && !nodeItemRequisicao.getTextContent().isEmpty()) {
                    requisicao.setValor(TAG_TIPO_IDADE, nodeItemRequisicao.getTextContent());
                    continue;
                }
                if (requisicao.getValor(TAG_PACIENTE) == null || ((Registro)requisicao.getValor(TAG_PACIENTE)).getValor(TAG_TIPO_IDADE) == null) continue;
                String tipoIdade = ((Registro)requisicao.getValor(TAG_PACIENTE)).getString(TAG_TIPO_IDADE);
                requisicao.setValor(TAG_TIPO_IDADE, tipoIdade);
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_PESO)) {
                requisicao.setValor(TAG_PESO, DadoParsers.DECIMAL.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_ALTURA)) {
                requisicao.setValor(TAG_ALTURA, DadoParsers.DECIMAL.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_VALIDADE_GUIA) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent()) && Funcoes.verificaData(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_VALIDADE_GUIA, DadoParsers.DATA.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DATA_GUIA) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent()) && Funcoes.verificaData(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_DATA_GUIA, DadoParsers.DATA.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DEVE_GUIA) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_DEVE_GUIA, DadoParsers.BOOLEANO.stringToDado(nodeItemRequisicao.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_MATRICULA) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_MATRICULA, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_GUIA) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_GUIA, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase("obs") && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor("obs", nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase("obs") && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor("obs", nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_MEDICO_CONSELHO) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_MEDICO_CONSELHO, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_MEDICO_UF) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_MEDICO_UF, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_MEDICO_CRM) && !Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) {
                requisicao.setValor(TAG_MEDICO_CRM, nodeItemRequisicao.getTextContent());
                continue;
            }
            if (!nodeName.equalsIgnoreCase(TAG_MEDICO_NOME) || Funcoes.textoVazio(nodeItemRequisicao.getTextContent())) continue;
            requisicao.setValor(TAG_MEDICO_NOME, nodeItemRequisicao.getTextContent());
        }
        return requisicao;
    }

    private static Registro parsePaciente(Node nodePaciente, Logger logger) throws ParseException {
        Registro paciente = new Registro();
        NodeList nodeListPaciente = nodePaciente.getChildNodes();
        for (int i = 0; i < nodeListPaciente.getLength(); ++i) {
            Node nodeItemPaciente = nodeListPaciente.item(i);
            String nodeName = nodeItemPaciente.getNodeName();
            if (nodeName.equals(TAG_CODIGO_EXTERNO)) {
                paciente.setValor(TAG_CODIGO_EXTERNO, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_NOME)) {
                paciente.setValor(TAG_NOME, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_SEXO)) {
                paciente.setValor(TAG_SEXO, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_NASCIMENTO)) {
                paciente.setValor(TAG_NASCIMENTO, DadoParsers.DATA.stringToDado(nodeItemPaciente.getTextContent()));
                paciente.setValor(TAG_IDADE, Funcoes.yearsBetween(paciente.getDate(TAG_NASCIMENTO)));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_PESO)) {
                paciente.setValor(TAG_PESO, DadoParsers.DECIMAL.stringToDado(nodeItemPaciente.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_ALTURA)) {
                paciente.setValor(TAG_ALTURA, DadoParsers.DECIMAL.stringToDado(nodeItemPaciente.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_COR)) {
                paciente.setValor(TAG_COR, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DUM)) {
                paciente.setValor(TAG_DUM, DadoParsers.DATA.stringToDado(nodeItemPaciente.getTextContent()));
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_SANGUE)) {
                paciente.setValor(TAG_GRUPO_SANGUE, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_FATOR_RH)) {
                paciente.setValor(TAG_FATOR_RH, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_FATOR_DU)) {
                paciente.setValor(TAG_FATOR_DU, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase("obs")) {
                paciente.setValor("obs", nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_CLINICO)) {
                paciente.setValor(TAG_DADOS_CLINICOS, nodeItemPaciente.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_ADICIONAIS)) {
                NodeList nodeListAdicionais = nodeItemPaciente.getChildNodes();
                for (int j = 0; j < nodeListAdicionais.getLength(); ++j) {
                    Node nodeItemAdicionais = nodeListAdicionais.item(j);
                    String nodeNameAdicionais = nodeItemAdicionais.getNodeName();
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_ESTADO_CIVIL)) {
                        paciente.setValor(TAG_ESTADO_CIVIL, nodeItemAdicionais.getTextContent());
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_NR_FILHOS)) {
                        paciente.setValor(TAG_NUMERO_FILHOS, DadoParsers.INTEIRO.stringToDado(nodeItemAdicionais.getTextContent()));
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_PROFISSAO)) {
                        paciente.setValor(TAG_PROFISSAO, nodeItemAdicionais.getTextContent());
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_FUMANTE)) {
                        paciente.setValor(TAG_FUMANTE, DadoParsers.BOOLEANO.stringToDado(nodeItemAdicionais.getTextContent()));
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_DIABETICO)) {
                        paciente.setValor(TAG_DIABETICO, DadoParsers.BOOLEANO.stringToDado(nodeItemAdicionais.getTextContent()));
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_CPF)) {
                        paciente.setValor(TAG_CPF, nodeItemAdicionais.getTextContent());
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_RG)) {
                        paciente.setValor(TAG_RG, nodeItemAdicionais.getTextContent());
                        continue;
                    }
                    if (nodeNameAdicionais.equalsIgnoreCase(TAG_PAI)) {
                        paciente.setValor(TAG_PAI, nodeItemAdicionais.getTextContent());
                        continue;
                    }
                    if (!nodeNameAdicionais.equalsIgnoreCase(TAG_MAE)) continue;
                    paciente.setValor(TAG_MAE, nodeItemAdicionais.getTextContent());
                }
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_IDADE)) {
                if (nodeItemPaciente.getTextContent().isEmpty() || !Funcoes.isNumeric(nodeItemPaciente.getTextContent())) continue;
                paciente.setValor(TAG_IDADE, Integer.parseInt(nodeItemPaciente.getTextContent()));
                continue;
            }
            if (!nodeName.equalsIgnoreCase(TAG_TIPO_IDADE)) continue;
            paciente.setValor(TAG_TIPO_IDADE, nodeItemPaciente.getTextContent());
        }
        if (paciente.getValor(TAG_IDADE) != null && paciente.getInt(TAG_IDADE) == 0 && paciente.getValor(TAG_NASCIMENTO) != null) {
            String idade = Funcoes.calculaIdade(Funcoes.formataData(paciente.getDate(TAG_NASCIMENTO)), false);
            paciente.setValor(TAG_IDADE, Integer.parseInt(idade));
        }
        if ((paciente.getValor(TAG_TIPO_IDADE) == null || paciente.getString(TAG_TIPO_IDADE).isEmpty()) && paciente.getValor(TAG_NASCIMENTO) != null) {
            String tipoIdade = Funcoes.calculaAnoMes(Funcoes.formataData(paciente.getDate(TAG_NASCIMENTO)));
            paciente.setValor(TAG_TIPO_IDADE, tipoIdade);
        }
        return paciente;
    }

    private static List<Registro> parseExames(Node nodeExames, Conexao conexao, Logger logger, Map<String, String[]> rejeitados) {
        ArrayList<Registro> listExames = new ArrayList<Registro>();
        NodeList nodeListExame = nodeExames.getChildNodes();
        for (int i = 0; i < nodeListExame.getLength(); ++i) {
            List<Registro> exames;
            if (!nodeListExame.item(i).getNodeName().equalsIgnoreCase(TAG_EXAME) || (exames = ParserImportacaoJalis.parseExame(nodeListExame.item(i), conexao, logger, rejeitados)) == null) continue;
            System.out.println(exames.size());
            listExames.addAll(exames);
            System.out.println(listExames.size());
        }
        return listExames;
    }

    private static List<Registro> parseExame(Node nodeExame, Conexao conexao, Logger logger, Map<String, String[]> rejeitados) {
        NodeList nodeListExame = nodeExame.getChildNodes();
        String codigo = null;
        int codigoMaterial = 0;
        String codigoExterno = null;
        Date dataColeta = null;
        String descricaoMaterial = null;
        String tempoJejum = null;
        String tempoDiurese = null;
        Object volumeDiurese = null;
        String guia = null;
        boolean deveGuia = false;
        Date dataGuia = null;
        Date validadeGuia = null;
        Date dataAutorizacao = null;
        Date dataValidadeAutorizacao = null;
        String codigoAutorizacao = null;
        String codigoAmbSolus = null;
        int codigoMaterialSolus = 0;
        int qtdeAmostraSolus = 0;
        for (int i = 0; i < nodeListExame.getLength(); ++i) {
            Node nodeItemExame = nodeListExame.item(i);
            String nodeName = nodeItemExame.getNodeName();
            if (nodeName.equalsIgnoreCase(TAG_CODIGO)) {
                codigo = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_CODIGO_MATERIAL)) {
                codigoMaterial = DadoParsers.INTEIRO.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_CODIGO_AMB_SOLUS)) {
                codigoAmbSolus = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_CODIGO_MATERIAL_SOLUS)) {
                codigoMaterialSolus = DadoParsers.INTEIRO.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_QTDE_AMOSTRA_SOLUS)) {
                qtdeAmostraSolus = DadoParsers.INTEIRO.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equals(TAG_CODIGO_EXTERNO)) {
                codigoExterno = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DATA_COLETA)) {
                try {
                    dataColeta = DadoParsers.DATA_HORA.stringToDado(nodeItemExame.getTextContent());
                }
                catch (Exception e) {
                    dataColeta = new Date();
                }
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DESCRICAO_MATERIAL)) {
                descricaoMaterial = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_TEMPO_JEJUM)) {
                tempoJejum = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_TEMPO_DIURESE)) {
                tempoDiurese = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_GUIA)) {
                guia = nodeItemExame.getTextContent();
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DEVE_GUIA) && !Funcoes.textoVazio(nodeItemExame.getTextContent())) {
                deveGuia = DadoParsers.BOOLEANO.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DATA_GUIA) && !Funcoes.textoVazio(nodeItemExame.getTextContent())) {
                dataGuia = DadoParsers.DATA.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_VALIDADE_GUIA) && !Funcoes.textoVazio(nodeItemExame.getTextContent())) {
                validadeGuia = DadoParsers.DATA.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DATA_AUTORIZACAO) && !Funcoes.textoVazio(nodeItemExame.getTextContent())) {
                dataAutorizacao = DadoParsers.DATA.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (nodeName.equalsIgnoreCase(TAG_DATA_VALIDADE_AUTORIZACAO) && !Funcoes.textoVazio(nodeItemExame.getTextContent())) {
                dataValidadeAutorizacao = DadoParsers.DATA.stringToDado(nodeItemExame.getTextContent());
                continue;
            }
            if (!nodeName.equalsIgnoreCase(TAG_CODIGO_AUTORIZACAO) || Funcoes.textoVazio(nodeItemExame.getTextContent())) continue;
            codigoAutorizacao = nodeItemExame.getTextContent();
        }
        if (!Funcoes.textoVazio(codigoAmbSolus) && codigoMaterialSolus > 0) {
            List<Registro> exames = ParserImportacaoJalis.localizaExameJalis(codigoAmbSolus, codigoMaterialSolus, qtdeAmostraSolus, conexao, logger);
            if (exames == null || exames.isEmpty()) {
                rejeitados.put(codigoAmbSolus + codigoMaterialSolus + qtdeAmostraSolus, new String[]{codigoAmbSolus, String.valueOf(codigoMaterialSolus), String.valueOf(qtdeAmostraSolus)});
                return null;
            }
            for (Registro exame : exames) {
                codigo = exame.getString(TAG_CODIGO_EXAME);
                codigoMaterial = exame.getInt(TAG_CODIGO_MATERIAL);
                exame.setValor(TAG_CODIGO_EXAME, codigo);
                exame.setValor(TAG_CODIGO_MATERIAL, codigoMaterial);
                exame.setValor(TAG_DEVE_GUIA, false);
                exame.setValor(TAG_CODIGO_EXTERNO, codigoExterno);
                exame.setValor(TAG_DATA_MATERIAL, dataColeta);
                exame.setValor(TAG_TEMPO_JEJUM, tempoJejum);
                exame.setValor(TAG_TEMPO_DIURESE, tempoDiurese);
                exame.setValor(TAG_VOLUME_DIURESE, volumeDiurese);
                exame.setValor(TAG_DESCRICAO_MATERIAL, descricaoMaterial);
                exame.setValor(TAG_COD_EXAME_ORIGEM, codigoAmbSolus);
                exame.setValor(TAG_COD_MAT_ORIGEM, codigoMaterialSolus);
                if (!deveGuia) {
                    exame.setValor(TAG_GUIA, guia);
                    exame.setValor(TAG_DATA_GUIA, dataGuia);
                    exame.setValor(TAG_VALIDADE_GUIA, validadeGuia);
                } else {
                    exame.setValor(TAG_DEVE_GUIA, deveGuia);
                }
                exame.setValor(TAG_DATA_AUTORIZACAO, dataAutorizacao);
                exame.setValor(TAG_DATA_VALIDADE_AUTORIZACAO, dataValidadeAutorizacao);
                exame.setValor(TAG_CODIGO_AUTORIZACAO, codigoAutorizacao);
            }
            return exames;
        }
        return null;
    }

    private static List<Registro> localizaExameJalis(String codigoAmbSolus, int codigoMaterialSolus, int qtdeAmostraSolus, Conexao conexao, Logger logger) {
        ArrayList<Registro> exames = new ArrayList<Registro>();
        Statement st = conexao.getStatement();
        PreparedStatement pst = conexao.getPreparedStatement(" update relacionamentosolus set sol_qtderecebida = ? where sol_amb = ? and sol_material = ? and sol_qtdeamostra = ?");
        try {
            StringBuilder sb = new StringBuilder();
            sb.append("select exa_codigo, mco_codigo, coalesce(sol_qtderecebida, 0) as sol_qtderecebida from relacionamentosolus ");
            sb.append(" where sol_amb  = '").append(codigoAmbSolus).append("'");
            sb.append(" and sol_material = ").append(codigoMaterialSolus);
            sb.append(" and sol_qtdeamostra = ").append(qtdeAmostraSolus);
            ResultSet rs = conexao.executeQuery(st, sb);
            if (rs.next()) {
                do {
                    Registro exame = new Registro();
                    exame.setValor(TAG_CODIGO_EXAME, rs.getString("exa_codigo"));
                    exame.setValor(TAG_CODIGO_MATERIAL, rs.getInt("mco_codigo"));
                    int qtdeRecebida = rs.getInt("sol_qtderecebida") + 1;
                    pst.setInt(1, qtdeRecebida);
                    pst.setString(2, codigoAmbSolus);
                    pst.setInt(3, codigoMaterialSolus);
                    pst.setInt(4, qtdeAmostraSolus);
                    pst.executeUpdate();
                    exames.add(exame);
                } while (rs.next());
                pst.close();
                conexao.fecharStatement(st);
                conexao.arquivaSQL();
                return exames;
            }
            logger.log(Level.INFO, String.format("Exame n\u00e3o localizado na tabela relacionamentosolus Exame %s - %s - %s", codigoAmbSolus, codigoMaterialSolus, qtdeAmostraSolus));
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, String.format("Erro ao tentar localizar exame do Jalis Exame %s %s %s", codigoAmbSolus, codigoMaterialSolus, qtdeAmostraSolus));
            logger.log(Level.WARNING, "Erro: " + e.getMessage());
            conexao.fecharStatement(st);
            try {
                conexao.anulaSQL();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    public static boolean salvaRequisicoes(List<Registro> requisicoes, Conexao conexao, Logger logger, Apoiado apoiado) {
        return true;
    }

    public static ParametroSet loteToParam(List<Registro> requisicoes, Apoiado apoiado, List<ParametroSet> listParamPac, Conexao conexao) throws ParseException, SQLException {
        ParametroSet paramLote = new ParametroSet();
        Statement st = conexao.getStatement();
        StringBuilder sb = new StringBuilder();
        sb.append("select max(lot_codigo) from loteapoio ");
        sb.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
        sb.append(" and con_codigo = ").append(apoiado.getCodigo());
        int lote = 1;
        ResultSet rs = conexao.executeQuery(st, sb);
        if (rs.next()) {
            lote = rs.getInt(1) + 1;
        }
        conexao.fecharStatement(st);
        paramLote.setInt(TAG_CODIGO, lote);
        paramLote.setDate("data", Calendar.getInstance().getTime());
        paramLote.setString("caixa", null);
        ArrayList<ParametroSet> paramRequisicoes = new ArrayList<ParametroSet>();
        for (Registro req : requisicoes) {
            ParametroSet paramReq = new ParametroSet();
            paramReq.setLong("codigoRequisicao", Long.parseLong(req.getString(TAG_CODIGO_EXTERNO)));
            paramReq.setDate("data", Calendar.getInstance().getTime());
            paramReq.setString("hora", Funcoes.formataData("HH:mm", Calendar.getInstance().getTime()));
            for (ParametroSet p : listParamPac) {
                if (!req.getValor(TAG_PACIENTE, Registro.class).getString(TAG_CODIGO_EXTERNO).equals(p.getParametroSet(TAG_PACIENTE).getString(TAG_CODIGO_EXTERNO))) continue;
                paramReq.setLong("codigoPacienteServidor", p.getLong("codigoApoio"));
            }
            paramReq.setInt(TAG_IDADE, req.getValor(TAG_IDADE) != null ? req.getInt(TAG_IDADE) : req.getValor(TAG_PACIENTE, Registro.class).getInt(TAG_IDADE));
            paramReq.setString(TAG_TIPO_IDADE, !Funcoes.textoVazio(req.getString(TAG_TIPO_IDADE)) ? req.getString(TAG_TIPO_IDADE) : req.getValor(TAG_PACIENTE, Registro.class).getString(TAG_TIPO_IDADE));
            paramReq.setDouble(TAG_PESO, req.getDouble(TAG_PESO));
            paramReq.setDouble(TAG_ALTURA, req.getDouble(TAG_ALTURA));
            paramReq.setString("obs", req.getString("obs"));
            if (req.getValor("medico") != null) {
                paramReq.setString(TAG_MEDICO_CONSELHO, req.getValor("medico", Registro.class).getString("conselho"));
                paramReq.setString(TAG_MEDICO_CRM, req.getValor("medico", Registro.class).getString("crm"));
                paramReq.setString(TAG_MEDICO_UF, req.getValor("medico", Registro.class).getString("uf"));
            } else if (req.getString(TAG_MEDICO_CONSELHO) != null) {
                paramReq.setString(TAG_MEDICO_CONSELHO, req.getString(TAG_MEDICO_CONSELHO));
                paramReq.setString(TAG_MEDICO_CRM, !Funcoes.textoVazio(req.getString(TAG_MEDICO_CRM)) ? req.getString(TAG_MEDICO_CRM) : "CRM");
                paramReq.setString(TAG_MEDICO_UF, req.getString(TAG_MEDICO_UF));
                paramReq.setString(TAG_MEDICO_NOME, req.getString(TAG_MEDICO_NOME));
            }
            paramReq.setString(TAG_TIPO_IDADE, req.getString(TAG_TIPO_IDADE));
            paramReq.setString(TAG_DADOS_CLINICOS, req.getString(TAG_DADOS_CLINICOS));
            paramReq.setBoolean(TAG_GESTANTE, req.getBoolean(TAG_GESTANTE));
            paramReq.setDate(TAG_DUM, req.getDate(TAG_DUM));
            paramReq.setBoolean("dumNaoInformado", req.getValor(TAG_DUM) == null);
            paramReq.setBoolean(TAG_NEONATO, req.getBoolean(TAG_NEONATO));
            paramReq.setDouble(TAG_ALTURA, req.getDouble(TAG_ALTURA));
            paramReq.setDouble(TAG_PESO, req.getDouble(TAG_PESO));
            paramReq.setString(TAG_GUIA, req.getString(TAG_GUIA));
            paramReq.setBoolean(TAG_DEVE_GUIA, req.getBoolean(TAG_DEVE_GUIA));
            paramReq.setString(TAG_MATRICULA, req.getString(TAG_MATRICULA));
            paramReq.setDate(TAG_VALIDADE_GUIA, req.getDate(TAG_VALIDADE_GUIA));
            paramReq.setInt("situacao", null);
            ArrayList<ParametroSet> paramExames = new ArrayList<ParametroSet>();
            List exames = req.getValor(TAG_EXAMES, List.class);
            for (Registro ex : exames) {
                ParametroSet paramEx = new ParametroSet();
                paramEx.setString(TAG_CODIGO_EXAME, ex.getString(TAG_CODIGO_EXAME));
                paramEx.setInt(TAG_CODIGO_MATERIAL, ex.getInt(TAG_CODIGO_MATERIAL));
                paramEx.setString(TAG_DESCRICAO_MATERIAL, ex.getString(TAG_DESCRICAO_MATERIAL));
                paramEx.setString("resposta", null);
                paramEx.setInt("metodo", null);
                paramEx.setDouble(TAG_VOLUME_DIURESE, ex.getDouble(TAG_VOLUME_DIURESE));
                paramEx.setString(TAG_TEMPO_DIURESE, ex.getString(TAG_TEMPO_DIURESE));
                paramEx.setString("obs", ex.getString("obs"));
                paramEx.setDate("data", Calendar.getInstance().getTime());
                paramEx.setString(TAG_TEMPO_JEJUM, ex.getString(TAG_TEMPO_JEJUM));
                paramEx.setString(TAG_GUIA, ex.getString(TAG_GUIA));
                paramEx.setBoolean(TAG_DEVE_GUIA, ex.getBoolean(TAG_DEVE_GUIA));
                paramEx.setDate(TAG_DATA_GUIA, ex.getDate(TAG_DATA_GUIA));
                paramEx.setDate(TAG_VALIDADE_GUIA, ex.getDate(TAG_VALIDADE_GUIA));
                paramEx.setDate(TAG_DATA_AUTORIZACAO, ex.getDate(TAG_DATA_AUTORIZACAO));
                paramEx.setDate(TAG_DATA_VALIDADE_AUTORIZACAO, ex.getDate(TAG_DATA_VALIDADE_AUTORIZACAO));
                paramEx.setString(TAG_CODIGO_AUTORIZACAO, ex.getString(TAG_CODIGO_AUTORIZACAO));
                paramExames.add(paramEx);
            }
            paramReq.setListParam(TAG_EXAMES, paramExames);
            paramRequisicoes.add(paramReq);
        }
        paramLote.setListParam("requisicoes", paramRequisicoes);
        ParametroSet param = new ParametroSet();
        param.setString("chave", apoiado.getChave());
        param.setParametroSet("lote", paramLote);
        param.setBoolean("apoio", true);
        return param;
    }

    public static List<ParametroSet> getParamPacientes(List<Registro> requisicoes, Conexao conexao, String chave) throws ParseException {
        ArrayList<ParametroSet> listParam = new ArrayList<ParametroSet>();
        for (Registro r : requisicoes) {
            Registro p = r.getValor(TAG_PACIENTE, Registro.class);
            if (p == null) continue;
            ParametroSet pac = new ParametroSet();
            pac.setLong(TAG_CODIGO, Long.parseLong(p.getString(TAG_CODIGO_EXTERNO)));
            pac.setString(TAG_CODIGO_EXTERNO, p.getString(TAG_CODIGO_EXTERNO));
            pac.setString(TAG_NOME, p.getString(TAG_NOME));
            pac.setString("bairro", null);
            pac.setString(TAG_SEXO, p.getString(TAG_SEXO));
            pac.setDate(TAG_NASCIMENTO, p.getDate(TAG_NASCIMENTO));
            pac.setBoolean("vip", false);
            pac.setString(TAG_GRUPO_SANGUE, p.getString(TAG_GRUPO_SANGUE));
            pac.setString(TAG_FATOR_RH, p.getString(TAG_FATOR_RH));
            pac.setString(TAG_FATOR_DU, p.getString(TAG_FATOR_DU));
            pac.setString(TAG_COR, p.getString(TAG_COR));
            pac.setString("observacao", p.getString("obs"));
            pac.setString(TAG_DADOS_CLINICOS, p.getString(TAG_DADOS_CLINICOS));
            pac.setDouble(TAG_PESO, p.getDouble(TAG_PESO));
            pac.setDouble(TAG_ALTURA, p.getDouble(TAG_ALTURA));
            pac.setString("matriculaConvenio", null);
            pac.setString("titularConvenio", null);
            pac.setString(TAG_PROFISSAO, p.getString(TAG_PROFISSAO));
            if (p.getValor(TAG_FUMANTE) != null) {
                pac.setBoolean(TAG_FUMANTE, p.getBoolean(TAG_FUMANTE));
            }
            if (p.getValor(TAG_DIABETICO) != null) {
                pac.setBoolean(TAG_DIABETICO, p.getBoolean(TAG_DIABETICO));
            }
            pac.setString(TAG_RG, p.getString(TAG_RG));
            pac.setString(TAG_CPF, p.getString(TAG_CPF));
            pac.setString(TAG_ESTADO_CIVIL, p.getString(TAG_ESTADO_CIVIL));
            pac.setInt(TAG_NUMERO_FILHOS, p.getInt(TAG_NUMERO_FILHOS));
            pac.setDate(TAG_DUM, p.getDate(TAG_DUM));
            pac.setInt("cidade", null);
            pac.setString("fax", null);
            pac.setString("celular", null);
            pac.setString("foneComercial", null);
            pac.setString("fone", null);
            pac.setString("cep", null);
            pac.setString("complemento", null);
            pac.setString("endereco", null);
            pac.setString("email", null);
            pac.setString(TAG_TIPO_IDADE, p.getString(TAG_TIPO_IDADE));
            pac.setInt(TAG_IDADE, p.getInt(TAG_IDADE));
            if (p.getValor("medico") != null) {
                pac.setString(TAG_MEDICO_CONSELHO, p.getValor("medico", Registro.class).getString("conselho"));
                pac.setString(TAG_MEDICO_CRM, p.getValor("medico", Registro.class).getString("crm"));
                pac.setString(TAG_MEDICO_UF, p.getValor("medico", Registro.class).getString("uf"));
            }
            pac.setString("foneContato", null);
            pac.setString("nomeContato", null);
            pac.setString(TAG_MAE, p.getString(TAG_MAE));
            pac.setString(TAG_PAI, p.getString(TAG_PAI));
            pac.setBoolean("malaDireta", false);
            ParametroSet param = new ParametroSet();
            param.setParametroSet(TAG_PACIENTE, pac);
            param.setString("chave", chave);
            listParam.add(param);
        }
        return listParam;
    }

    public static String paramToXml(List<ParametroSet> pacientes, ParametroSet lote, Map<String, String[]> rejeitados) throws XMLStringBuilderException {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.abrir("lote");
        xml.escrever(TAG_CODIGO, String.valueOf(lote.getInt("lote")));
        xml.abrir("pacientes");
        for (ParametroSet parametroSet : pacientes) {
            ParametroSet parametroSet2 = parametroSet.getParametroSet(TAG_PACIENTE);
            xml.abrir(TAG_PACIENTE);
            xml.escrever(TAG_CODIGO, String.valueOf(parametroSet2.getLong(TAG_CODIGO)));
            xml.escrever("codigoApoio", String.valueOf(parametroSet.getLong("codigoApoio")));
            xml.escrever(TAG_NOME, parametroSet2.getString(TAG_NOME));
            xml.fechar(TAG_PACIENTE);
        }
        xml.fechar("pacientes");
        List<ParametroSet> requisicoes = lote.getListParam("requisicoes");
        xml.abrir("requisicoes");
        for (ParametroSet parametroSet : requisicoes) {
            xml.abrir("requisicao");
            xml.escrever(TAG_CODIGO, String.valueOf(parametroSet.getLong(TAG_CODIGO)));
            xml.escrever("codigoApoio", String.valueOf(parametroSet.getLong("codigoServidor")));
            xml.fechar("requisicao");
        }
        xml.fechar("requisicoes");
        xml.abrir("rejeitados");
        if (!rejeitados.isEmpty()) {
            for (Map.Entry entry : rejeitados.entrySet()) {
                if (entry.getValue() == null || ((String[])entry.getValue()).length != 3) continue;
                xml.abrir("exameSolus");
                xml.escrever(TAG_CODIGO_AMB_SOLUS, ((String[])entry.getValue())[0]);
                xml.escrever(TAG_CODIGO_MATERIAL_SOLUS, ((String[])entry.getValue())[1]);
                xml.escrever(TAG_QTDE_AMOSTRA_SOLUS, ((String[])entry.getValue())[2]);
                xml.fechar("exameSolus");
            }
        }
        xml.fechar("rejeitados");
        xml.fechar("lote");
        return xml.getXML();
    }
}

