/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Conexao {
    private boolean isConnected = false;
    private Connection connection;

    public Conexao(String caminhoBanco) {
        try {
            this.connection = DriverManager.getConnection(caminhoBanco, "thread", "murphy123");
            this.connection.setAutoCommit(false);
            this.connection.setTransactionIsolation(2);
            this.isConnected = true;
        }
        catch (SQLException sqlex) {
            this.isConnected = false;
            sqlex.printStackTrace();
        }
    }

    public boolean getConnected() {
        return this.isConnected;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean shutdown() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.connection = null;
                return true;
            }
            catch (SQLException ex) {
                return false;
            }
        }
        return true;
    }

    public Statement getStatement() {
        try {
            return this.connection.createStatement(1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public void arquivaSQL() throws SQLException {
        this.connection.commit();
    }

    public void anulaSQL() throws SQLException {
        this.connection.rollback();
    }

    public void fecharStatement(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public ResultSet executeQuery(Statement st, StringBuilder sql) throws SQLException {
        return this.executeQuery(st, sql.toString());
    }

    public ResultSet executeQuery(Statement st, String sql) throws SQLException {
        return st.executeQuery(sql);
    }

    public ResultSet executeQuery(PreparedStatement pst) throws SQLException {
        return pst.executeQuery();
    }

    public boolean execute(String codigoFilial, Statement st, StringBuilder sql) throws SQLException {
        return this.execute(codigoFilial, st, sql.toString());
    }

    public boolean execute(int codigoFilial, Statement st, StringBuilder sql) throws SQLException {
        return this.execute(codigoFilial, st, sql.toString());
    }

    public boolean execute(String codigoFilial, Statement st, String sql) throws SQLException {
        return this.execute(codigoFilial, st, sql, false);
    }

    public boolean execute(int codigoFilial, Statement st, String sql) throws SQLException {
        return this.execute(String.valueOf(codigoFilial), st, sql, false);
    }

    public boolean execute(String codigoFilial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        boolean res = st.execute(sql);
        if (!ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, codigoFilial)) {
            IntegracaoUtil.insereComandoLog(st, codigoFilial, codigoFilial, sql);
        }
        return res;
    }

    public int executeUpdate(String filial, Statement st, StringBuilder sql) throws SQLException {
        return this.executeUpdate(filial, st, sql.toString());
    }

    public int executeUpdate(String filial, Statement st, String sql) throws SQLException {
        return this.executeUpdate(filial, st, sql, false);
    }

    public int executeUpdate(String filial, Statement st, String sql, boolean ignorarIntegracao) throws SQLException {
        int res = st.executeUpdate(sql);
        if (res > 0 && !ignorarIntegracao && IntegracaoUtil.isFilialParaIntegrar(st, filial)) {
            IntegracaoUtil.insereComandoLog(st, filial, filial, sql);
        }
        return res;
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            return this.connection.prepareStatement(sql, 1004, 1007);
        }
        catch (SQLException ex) {
            return null;
        }
    }
}

