/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class Apoiado {
    private int codigoFilial;
    private String tipoFilial;
    private int codigo;
    private int diasPrazo;
    private int ultimoLote;
    private String nome;
    private boolean validado;
    private int qtMaximaExames;
    private boolean bloquearLaudo;
    private boolean solicitarCaixa;
    private boolean loteExiste;
    private static List<String> tiposFiliais = new ArrayList<String>();

    public Apoiado(int codigoFilial, String tipoFilial, int codigo) {
        this.codigoFilial = codigoFilial;
        this.tipoFilial = tipoFilial;
        this.codigo = codigo;
    }

    public Apoiado(String chave) {
        this.setChave(chave);
    }

    private void setChave(String chave) {
        String s = String.valueOf(StringUtil.desencriptar(chave));
        s = Funcoes.preencheVazio(s, "0", 15, 1);
        this.codigoFilial = Integer.valueOf(s.substring(0, 3));
        this.codigo = Integer.valueOf(s.substring(3, 13));
        this.tipoFilial = tiposFiliais.get(Integer.valueOf(s.substring(13)));
    }

    public String getChave() {
        String s = Funcoes.preencheZero(this.codigoFilial, 3) + Funcoes.preencheZero(this.codigo, 10) + Funcoes.preencheZero(tiposFiliais.indexOf(this.tipoFilial), 2);
        return StringUtil.encriptar(Long.parseLong(s));
    }

    public int getCodigoFilial() {
        return this.codigoFilial;
    }

    public String getTipoFilial() {
        return this.tipoFilial;
    }

    public int getCodigo() {
        return this.codigo;
    }

    public int getDiasPrazo() {
        return this.diasPrazo;
    }

    public void setDiasPrazo(int diasPrazo) {
        this.diasPrazo = diasPrazo;
    }

    public int getUltimoLote() {
        return this.ultimoLote;
    }

    public void setUltimoLote(int ultimoLote) {
        this.ultimoLote = ultimoLote;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public boolean isValidado() {
        return this.validado;
    }

    public void setValidado(boolean validado) {
        this.validado = validado;
    }

    public int getQtMaximaExames() {
        return this.qtMaximaExames;
    }

    public void setQtMaximaExames(int qtMaximaExames) {
        this.qtMaximaExames = qtMaximaExames;
    }

    public boolean isBloquearLaudo() {
        return this.bloquearLaudo;
    }

    public void setBloquearLaudo(boolean bloquearLaudo) {
        this.bloquearLaudo = bloquearLaudo;
    }

    public boolean isSolicitarCaixa() {
        return this.solicitarCaixa;
    }

    public void setSolicitarCaixa(boolean solicitarCaixa) {
        this.solicitarCaixa = solicitarCaixa;
    }

    public boolean isLoteExiste() {
        return this.loteExiste;
    }

    public void setLoteExiste(boolean loteExiste) {
        this.loteExiste = loteExiste;
    }

    static {
        tiposFiliais.add("C");
        tiposFiliais.add("A");
        tiposFiliais.add("V");
    }
}

