/*
 * Decompiled with CFR 0.152.
 */
package jalis.apoio.servidorws;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.Conexao;
import jalis.apoio.servidorws.ParserImportacaoJalis;
import jalis.apoio.servidorws.WSUtil;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.apoio.util.Util;
import jalis.comum.ParametrosGerais;
import jalis.comum.ParametrosLocais;
import jalis.comum.dados.DadosConvenios;
import jalis.comum.dados.DadosExames;
import jalis.comum.dados.DadosMaterial;
import jalis.laboratorio.relatorios.apoio.RelatorioConferenciaEnviados;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.impressao.DadosImpressao;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.service.recepcao.RequisicaoService;
import jalis.util.ConvenioUtil;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.io.File;
import java.io.InputStream;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Acoes {
    public static final String LISTA_MATERIAIS = "listaMateriais";
    public static final String LISTA_EXAMES = "listaExames";
    public static final String CODIGO_MATERIAL = "codigoMaterial";
    public static final String CODIGO_APOIADO = "codigoApoiado";
    public static final String CODIGO_EXAME = "codigoExame";
    public static final String HH_MM = "HH:mm";
    public static final String HH_MM1 = "HH:MM";
    public static final String MM_DD_YYYY = "MM/dd/yyyy";
    public static final String S = "S";
    public static final String N = "N";
    public static final String FALSE = "false";
    public static final String TRUE = "true";
    private Conexao conexao;
    private String imagemSuporte;
    private Logger logger;
    private boolean gerarInterface = false;
    private RequisicaoService requisicaoService = new RequisicaoService();

    public Acoes(Logger logger, Conexao conexao, String imagemSuporte, Boolean gerarInterface) {
        this.conexao = conexao;
        this.imagemSuporte = imagemSuporte;
        this.logger = logger;
        this.gerarInterface = gerarInterface;
    }

    public ParametroSet testarServidor() {
        ParametroSet paramRetorno = new ParametroSet();
        paramRetorno.setBoolean("ok", true);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOperacao(Statement st, Statement st2, Apoiado apoiado, String tabela, boolean resultado) throws Exception {
        StringBuilder operacao = new StringBuilder();
        StringBuilder bui = new StringBuilder();
        bui.append("select a.epa_codigo, a.epa_operacao");
        if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
            bui.append(" from exportaapoio a");
            bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
            bui.append(" and a.pac_codigo = ").append(apoiado.getCodigo());
        } else if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            bui.append(" ,b.cap_convenioapoio from exportaapoio a");
            bui.append(" left join convenioapoiado b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.cap_convenioapoio and b.con_codigo = ").append(apoiado.getCodigo());
            bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
            bui.append(" and (a.con_codigo = ").append(apoiado.getCodigo()).append(" or b.con_codigo = ").append(apoiado.getCodigo()).append(")");
        }
        bui.append(" and a.epa_tabela = '").append(tabela).append("'");
        bui.append(" and (a.epa_exportado = false or a.epa_exportado is null) order by a.epa_codigo ");
        try (ResultSet rs = null;){
            rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                bui.setLength(0);
                if (!resultado) {
                    this.marcaExportado(st2, apoiado, rs.getString("epa_codigo"));
                }
                bui.setLength(0);
                bui.append("delete from exportaapoio where fil_codigo = ").append(apoiado.getCodigoFilial());
                if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    bui.append(" and pac_codigo = ").append(apoiado.getCodigo());
                } else if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(" and (con_codigo = ").append(apoiado.getCodigo());
                    if (rs.findColumn("cap_convenioapoio") > 0 && !Funcoes.textoVazio(rs.getString("cap_convenioapoio"))) {
                        bui.append(" or con_codigo =").append(rs.getString("cap_convenioapoio"));
                    }
                    bui.append(")");
                }
                bui.append(" and epa_datahora < current_date - 60 and epa_exportado = true ");
                this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st2, bui.toString(), true);
                String op = rs.getString("epa_operacao");
                int p = op.indexOf("</examerequisicao");
                if (p > 0) {
                    operacao.append(op.substring(0, p));
                    operacao.append("<epa_codigo>").append(rs.getString("epa_codigo")).append("</epa_codigo>");
                    operacao.append(op.substring(p));
                    continue;
                }
                operacao.append(rs.getString("epa_operacao"));
            }
        }
        return StringUtil.xmlToTexto(operacao.toString());
    }

    private boolean marcaExportado(Statement st2, Apoiado apoiado, String epa_codigo) throws SQLException {
        StringBuilder bui = new StringBuilder();
        bui.append("update exportaapoio set epa_exportado = true");
        bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
        bui.append(" and epa_codigo = ").append(epa_codigo);
        return this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st2, bui.toString(), true) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCodigoCliente(Statement st) throws SQLException {
        String sql = "select par_cliente from parametros";
        try (ResultSet rs = null;){
            rs = st.executeQuery(sql);
            if (rs.next() && !Funcoes.textoVazio(rs.getString("par_cliente")) && rs.getString("par_cliente").length() == 100) {
                long l = StringUtil.desencriptar(rs.getString("par_cliente"));
                return l;
            }
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getListagemExames(ParametroSet param) throws Exception {
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        HashSet<String> exames = new HashSet<String>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select exa_codigo from exames where fil_codigo = " + apoiado.getCodigoFilial() + " group by exa_codigo";
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    exames.add(rs.getString("exa_codigo"));
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "exames", false);
                for (String s : StringUtil.getValores(op, "exame")) {
                    exames.add(StringUtil.getValor(s, "codigo"));
                }
                this.conexao.arquivaSQL();
            }
            paramRetorno.setList("exames", new ArrayList<String>(exames));
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getExames(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        List<String> codigoExames = param.getList("exames");
        boolean enviaLayout = param.getBoolean("enviaLayout");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> exames = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        Statement st3 = this.conexao.getStatement();
        try {
            StringBuilder bui = new StringBuilder();
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                bui.append("select a.lay_codigo, a.lay_codigoapoio from convenios a");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.con_codigo = ").append(apoiado.getCodigo());
            } else {
                bui.append("select b.lay_codigo, a.lay_codigoapoio from paciente a");
                bui.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.pac_codigo = ").append(apoiado.getCodigo());
            }
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            rs.next();
            int layCodigo = rs.getObject("lay_codigoapoio") != null ? rs.getInt("lay_codigoapoio") : rs.getInt("lay_codigo");
            for (String codigoExame : codigoExames) {
                bui.setLength(0);
                bui.append("select a.exa_codigo, a.exa_descricao, a.exa_sexo, a.exa_horaentrada, ");
                bui.append("a.exa_horasaida, a.exa_filtro, a.exa_diagnostico, a.exa_interferencia, a.exa_sinonimo, ");
                bui.append("a.exa_idademax, a.exa_idademin, a.exa_idademaxtipo, a.exa_idademintipo, ");
                bui.append("a.exa_qtdeamostras, a.exa_autorizacao, a.exa_proibido ");
                bui.append("from exames a ");
                bui.append("where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and exa_codigo = '").append(codigoExame).append("'");
                rs = this.conexao.executeQuery(st, bui.toString());
                if (!rs.next()) continue;
                ParametroSet exame = new ParametroSet();
                exame.setString("codigo", rs.getString("exa_codigo"));
                exame.setString("descricao", rs.getString("exa_descricao"));
                exame.setString("sexo", rs.getString("exa_sexo"));
                exame.setString("horaEntrada", rs.getString("exa_horaentrada"));
                exame.setString("horaSaida", rs.getString("exa_horasaida"));
                exame.setString("filtro", rs.getString("exa_filtro"));
                exame.setString("diagnostico", rs.getString("exa_diagnostico"));
                exame.setString("interferencia", rs.getString("exa_interferencia"));
                exame.setString("sinonimo", rs.getString("exa_sinonimo"));
                exame.setInt("idadeMaxima", rs.getInt("exa_idademax"));
                exame.setInt("idadeMinima", rs.getInt("exa_idademin"));
                exame.setString("idadeMaximaTipo", rs.getString("exa_idademaxtipo"));
                exame.setString("idadeMinimaTipo", rs.getString("exa_idademintipo"));
                exame.setInt("qtdeAmostras", rs.getInt("exa_qtdeamostras"));
                exame.setString("autorizacao", rs.getString("exa_autorizacao"));
                exame.setBoolean("proibido", rs.getBoolean("exa_proibido"));
                ArrayList<ParametroSet> setores = new ArrayList<ParametroSet>();
                bui.setLength(0);
                bui.append("select exa_codigo, set_codigo, ese_default from examesetor");
                bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                ResultSet rs2 = this.conexao.executeQuery(st2, bui.toString());
                while (rs2.next()) {
                    ParametroSet setor = new ParametroSet();
                    setor.setString(CODIGO_EXAME, rs2.getString("exa_codigo"));
                    setor.setInt("codigoSetor", rs2.getInt("set_codigo"));
                    setor.setBoolean("default", rs2.getBoolean("ese_default"));
                    setores.add(setor);
                }
                exame.setListParam("setores", setores);
                ArrayList<ParametroSet> materiais = new ArrayList<ParametroSet>();
                bui.setLength(0);
                bui.append("select a.exa_codigo, a.mco_codigo, a.emc_default, a.emc_pergunta, a.emc_preparo, a.emc_instrcoleta");
                bui.append(", a.emc_prepamostra, a.emc_inadequada, a.prz_codigo, a.met_codigo, a.emc_ordem, a.emc_pagina");
                bui.append(", a.emc_conservacao, a.emc_diasconserva, a.emc_temperaturainicial, a.emc_temperaturafinal");
                bui.append(", a.emc_referencia, a.emc_solicitarjejum, a.emc_obrigamedicamento, a.emc_marcarexterno");
                bui.append(", a.emc_obrigadum, a.emc_obrigapeso, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_obrigatempodiurese");
                bui.append(", b.prz_descricao, c.met_descricao, d.mco_descricao, a.emc_proibidoapoio");
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(", e.prz_codigo as prazoEntregaConv");
                }
                bui.append(" from examematcoleta a ");
                bui.append(" left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
                bui.append(" left join metodologia c on a.fil_codigo = c.fil_codigo and a.met_codigo = c.met_codigo ");
                bui.append(" left join materialcoleta d on a.fil_codigo = d.fil_codigo and a.mco_codigo = d.mco_codigo ");
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(" left join examematconvenioprazo e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo");
                    bui.append(" and a.mco_codigo = e.mco_codigo and e.con_codigo = ").append(apoiado.getCodigo());
                }
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.exa_codigo = '").append(rs.getString("exa_codigo")).append("'");
                rs2 = this.conexao.executeQuery(st2, bui.toString());
                while (rs2.next()) {
                    ParametroSet material = new ParametroSet();
                    material.setString(CODIGO_EXAME, rs2.getString("exa_codigo"));
                    material.setInt("codigo", rs2.getInt("mco_codigo"));
                    material.setBoolean("default", rs2.getBoolean("emc_default"));
                    material.setString("pergunta", rs2.getString("emc_pergunta"));
                    material.setString("preparo", rs2.getString("emc_preparo"));
                    material.setString("instrucaoColeta", rs2.getString("emc_instrcoleta"));
                    material.setString("preparoAmostra", rs2.getString("emc_prepamostra"));
                    material.setString("inadequada", rs2.getString("emc_inadequada"));
                    if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                        material.setInt("prazo", rs2.getObject("prazoEntregaConv") != null ? rs2.getInt("prazoEntregaConv") : rs2.getInt("prz_codigo"));
                    } else {
                        material.setInt("prazo", rs2.getInt("prz_codigo"));
                    }
                    material.setInt("metodo", rs2.getInt("met_codigo"));
                    material.setInt("ordem", rs2.getInt("emc_ordem"));
                    material.setInt("pagina", rs2.getInt("emc_pagina"));
                    material.setString("conservacao", rs2.getString("emc_conservacao"));
                    material.setInt("diasConserva", rs2.getInt("emc_diasconserva"));
                    material.setString("temperaturaInicial", rs2.getString("emc_temperaturainicial"));
                    material.setString("temperaturaFinal", rs2.getString("emc_temperaturafinal"));
                    material.setString("referencia", rs2.getString("emc_referencia"));
                    material.setBoolean("solicitarJejum", rs2.getBoolean("emc_solicitarjejum"));
                    material.setBoolean("obrigaMedicamento", rs2.getBoolean("emc_obrigamedicamento"));
                    material.setBoolean("marcarExterno", rs2.getBoolean("emc_marcarexterno"));
                    material.setBoolean("obrigaDum", rs2.getBoolean("emc_obrigadum"));
                    material.setBoolean("obrigaPeso", rs2.getBoolean("emc_obrigapeso"));
                    material.setBoolean("obrigaAltura", rs2.getBoolean("emc_obrigaaltura"));
                    material.setBoolean("obrigaVolume", rs2.getBoolean("emc_obrigavolume"));
                    material.setBoolean("obrigaTempoDiurese", rs2.getBoolean("emc_obrigatempodiurese"));
                    material.setString("prazoDescricao", rs2.getString("prz_descricao"));
                    material.setBoolean("proibidoApoio", rs2.getBoolean("emc_proibidoapoio"));
                    material.setString("metodoDescricao", rs2.getString("met_descricao"));
                    material.setString("materialDescricao", rs2.getString("mco_descricao"));
                    ArrayList<ParametroSet> principios = new ArrayList<ParametroSet>();
                    bui.setLength(0);
                    bui.append("select exa_codigo, mco_codigo, prc_codigo, exp_mensagem");
                    bui.append(" from examesprincipios ");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    bui.append(" and exa_codigo = '").append(rs2.getString("exa_codigo")).append("'");
                    bui.append(" and mco_codigo = ").append(rs2.getString("mco_codigo"));
                    ResultSet rs3 = this.conexao.executeQuery(st3, bui.toString());
                    while (rs3.next()) {
                        ParametroSet principio = new ParametroSet();
                        principio.setString(CODIGO_EXAME, rs3.getString("exa_codigo"));
                        principio.setInt(CODIGO_MATERIAL, rs3.getInt("mco_codigo"));
                        principio.setInt("codigoPrincipio", rs3.getInt("prc_codigo"));
                        principio.setString("mensagem", rs3.getString("exp_mensagem"));
                        principios.add(principio);
                    }
                    material.setListParam("principios", principios);
                    if (enviaLayout) {
                        ParametroSet modelo;
                        ArrayList<ParametroSet> modelos = new ArrayList<ParametroSet>();
                        bui.setLength(0);
                        bui.append("select count(lay_codigo) as qtdeLay ");
                        bui.append(" from examelayoutmetodo ");
                        bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                        bui.append(" and exa_codigo = '").append(rs2.getString("exa_codigo")).append("'");
                        bui.append(" and mco_codigo = ").append(rs2.getString("mco_codigo"));
                        bui.append(" and lay_codigo = ").append(layCodigo);
                        rs3 = this.conexao.executeQuery(st3, bui.toString());
                        int qtdeLay = 0;
                        if (rs3.next()) {
                            qtdeLay = rs3.getInt("qtdeLay");
                        }
                        bui.setLength(0);
                        if (qtdeLay > 1) {
                            bui.append("select b.met_codigo, b.ela_idadeini, b.ela_idadefim");
                            bui.append(", b.ela_idadeinitipo, b.ela_idadefimtipo, b.elm_formato, a.ela_padrao");
                            bui.append(" from examelayout a ");
                            bui.append("left join examelayoutmetodo b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo");
                            bui.append("                             and a.lay_codigo = b.lay_codigo and a.ela_idadeini = b.ela_idadeini  and  a.ela_idadefim = b.ela_idadefim");
                            bui.append("                             and a.ela_idadeinitipo = b.ela_idadeinitipo and a.ela_idadefimtipo = b.ela_idadefimtipo");
                            bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                            bui.append(" and a.exa_codigo = '").append(rs2.getString("exa_codigo")).append("'");
                            bui.append(" and a.mco_codigo = ").append(rs2.getString("mco_codigo"));
                            bui.append(" and a.lay_codigo = ").append(layCodigo);
                            bui.append(" and a.ela_padrao ");
                        } else {
                            bui.append("select met_codigo, ela_idadeini, ela_idadefim");
                            bui.append(", ela_idadeinitipo, ela_idadefimtipo, elm_formato");
                            bui.append(" from examelayoutmetodo ");
                            bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                            bui.append(" and exa_codigo = '").append(rs2.getString("exa_codigo")).append("'");
                            bui.append(" and mco_codigo = ").append(rs2.getString("mco_codigo"));
                            bui.append(" and lay_codigo = ").append(layCodigo);
                        }
                        rs3 = this.conexao.executeQuery(st3, bui.toString());
                        if (rs3.next()) {
                            do {
                                modelo = new ParametroSet();
                                modelo.setString(CODIGO_EXAME, rs2.getString("exa_codigo"));
                                modelo.setInt(CODIGO_MATERIAL, rs2.getInt("mco_codigo"));
                                modelo.setInt("codigoLayout", layCodigo);
                                modelo.setInt("codigoMetodologia", rs3.getInt("met_codigo"));
                                modelo.setInt("idadeInicio", rs3.getInt("ela_idadeini"));
                                modelo.setInt("idadeFim", rs3.getInt("ela_idadefim"));
                                modelo.setString("tipoIdadeInicio", rs3.getString("ela_idadeinitipo"));
                                modelo.setString("tipoIdadeFim", rs3.getString("ela_idadefimtipo"));
                                modelo.setString("formato", WSUtil.getFormatoParaExportacao(rs3.getString("elm_formato")));
                                modelos.add(modelo);
                            } while (rs3.next());
                        } else {
                            bui.setLength(0);
                            bui.append("select b.met_codigo, b.ela_idadeini, b.ela_idadefim");
                            bui.append(", b.ela_idadeinitipo, b.ela_idadefimtipo, b.elm_formato");
                            bui.append(" from examelayout a ");
                            bui.append(" left join examelayoutmetodo b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo and a.lay_codigo = b.lay_codigo ");
                            bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                            bui.append(" and a.exa_codigo = '").append(rs2.getString("exa_codigo")).append("'");
                            bui.append(" and a.mco_codigo = ").append(rs2.getString("mco_codigo"));
                            bui.append(" and a.ela_padrao ");
                            rs3 = this.conexao.executeQuery(st3, bui.toString());
                            while (rs3.next()) {
                                modelo = new ParametroSet();
                                modelo.setInt("codigoLayout", layCodigo);
                                modelo.setInt("codigoMetodologia", rs3.getInt("met_codigo"));
                                modelo.setInt("idadeInicio", rs3.getInt("ela_idadeini"));
                                modelo.setInt("idadeFim", rs3.getInt("ela_idadefim"));
                                modelo.setString("tipoIdadeInicio", rs3.getString("ela_idadeinitipo"));
                                modelo.setString("tipoIdadeFim", rs3.getString("ela_idadefimtipo"));
                                modelo.setString("formato", WSUtil.getFormatoParaExportacao(rs3.getString("elm_formato")));
                                modelos.add(modelo);
                            }
                        }
                        material.setListParam("modelos", modelos);
                    }
                    materiais.add(material);
                }
                exame.setListParam("materiais", materiais);
                exames.add(exame);
            }
        }
        finally {
            this.conexao.fecharStatement(st3);
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st);
        }
        paramRetorno.setListParam("exames", exames);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getBairros(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> bairros = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select bai_codigo, bai_descricao from bairro where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet bairro = new ParametroSet();
                    bairro.setString("codigo", rs.getString("bai_codigo"));
                    bairro.setString("descricao", rs.getString("bai_descricao"));
                    bairros.add(bairro);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "bairro", false);
                for (String s : StringUtil.getValores(op, "bairro")) {
                    ParametroSet bairro = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("bai_codigo")) {
                            bairro.setString("codigo", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("bai_descricao")) continue;
                        bairro.setString("descricao", valor);
                    }
                    bairros.add(bairro);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("bairros", bairros);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getCidades(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> cidades = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select cid_codigo, cid_nome, cid_uf from cidades where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet cidade = new ParametroSet();
                    cidade.setInt("codigo", rs.getInt("cid_codigo"));
                    cidade.setString("nome", rs.getString("cid_nome"));
                    cidade.setString("uf", rs.getString("cid_uf"));
                    cidades.add(cidade);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "cidades", false);
                for (String s : StringUtil.getValores(op, "cidade")) {
                    ParametroSet cidade = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("cid_codigo")) {
                            cidade.setInt("codigo", Integer.valueOf(valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("cid_nome")) {
                            cidade.setString("nome", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("cid_uf")) continue;
                        cidade.setString("uf", valor);
                    }
                    cidades.add(cidade);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("cidades", cidades);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getUnidadesMedida(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> unidades = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select unm_codigo, unm_descricao from unidademedida where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet unidade = new ParametroSet();
                    unidade.setString("codigo", rs.getString("unm_codigo"));
                    unidade.setString("descricao", rs.getString("unm_descricao"));
                    unidades.add(unidade);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "unidademedida", false);
                for (String s : StringUtil.getValores(op, "unidademedida")) {
                    ParametroSet unidade = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("unm_codigo")) {
                            unidade.setString("codigo", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("unm_descricao")) continue;
                        unidade.setString("descricao", valor);
                    }
                    unidades.add(unidade);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("unidades", unidades);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getResponsaveis(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
            ArrayList<ParametroSet> responsaveis = new ArrayList<ParametroSet>();
            StringBuilder bui = new StringBuilder();
            Statement st = this.conexao.getStatement();
            try {
                bui.setLength(0);
                bui.append("select a.ent_codigo, b.ent_razaosocial from pacienteentidade a");
                bui.append(" left join entidade b on a.fil_codigo = b.fil_codigo and a.ent_codigo = b.ent_codigo");
                bui.append(" where a.pac_codigo = ").append(apoiado.getCodigo());
                bui.append(" and a.pen_responsavel = true and a.fil_codigo = ").append(apoiado.getCodigoFilial());
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                while (rs.next()) {
                    ParametroSet resp = new ParametroSet();
                    resp.setInt("codigo", rs.getInt("ent_codigo"));
                    resp.setString("nome", rs.getString("ent_razaosocial"));
                    responsaveis.add(resp);
                }
            }
            finally {
                this.conexao.fecharStatement(st);
            }
            paramRetorno.setListParam("responsaveis", responsaveis);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getEmbalagens(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
            ArrayList<ParametroSet> embalagens = new ArrayList<ParametroSet>();
            StringBuilder bui = new StringBuilder();
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                if (primeiraConexao) {
                    bui.setLength(0);
                    bui.append("select emb_codigo, emb_descricao from embalagemproduto");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                    while (rs.next()) {
                        ParametroSet emb = new ParametroSet();
                        emb.setInt("codigo", rs.getInt("emb_codigo"));
                        emb.setString("descricao", rs.getString("emb_descricao"));
                        embalagens.add(emb);
                    }
                } else {
                    String op = this.getOperacao(st, st2, apoiado, "embalagemproduto", false);
                    for (String s : StringUtil.getValores(op, "embalagemproduto")) {
                        ParametroSet emb = new ParametroSet();
                        for (String c : StringUtil.getValores(s, "campo")) {
                            String campo = StringUtil.getValor(c, "nome");
                            String valor = StringUtil.getValor(c, "valor");
                            if (campo.equalsIgnoreCase("emb_codigo")) {
                                emb.setInt("codigo", Integer.valueOf(valor));
                                continue;
                            }
                            if (!campo.equalsIgnoreCase("emb_descricao")) continue;
                            emb.setString("descricao", valor);
                        }
                        embalagens.add(emb);
                    }
                    this.conexao.arquivaSQL();
                }
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
            paramRetorno.setListParam("embalagens", embalagens);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getColetas(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
            ArrayList<ParametroSet> coletas = new ArrayList<ParametroSet>();
            StringBuilder bui = new StringBuilder();
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                if (primeiraConexao) {
                    bui.setLength(0);
                    bui.append("select col_codigo, col_descricao from coletas");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                    while (rs.next()) {
                        ParametroSet coleta = new ParametroSet();
                        coleta.setString("codigo", rs.getString("col_codigo"));
                        coleta.setString("descricao", rs.getString("col_descricao"));
                        coletas.add(coleta);
                    }
                } else {
                    String op = this.getOperacao(st, st2, apoiado, "coletas", false);
                    for (String s : StringUtil.getValores(op, "coletas")) {
                        ParametroSet coleta = new ParametroSet();
                        for (String c : StringUtil.getValores(s, "campo")) {
                            String campo = StringUtil.getValor(c, "nome");
                            String valor = StringUtil.getValor(c, "valor");
                            if (campo.equalsIgnoreCase("col_codigo")) {
                                coleta.setString("codigo", valor);
                                continue;
                            }
                            if (!campo.equalsIgnoreCase("col_descricao")) continue;
                            coleta.setString("descricao", valor);
                        }
                        coletas.add(coleta);
                    }
                    this.conexao.arquivaSQL();
                }
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
            paramRetorno.setListParam("coletas", coletas);
        }
        return paramRetorno;
    }

    public ParametroSet getEntidades(ParametroSet param) {
        return new ParametroSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getDestinos(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
            ArrayList<ParametroSet> destinos = new ArrayList<ParametroSet>();
            StringBuilder bui = new StringBuilder();
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                if (primeiraConexao) {
                    bui.setLength(0);
                    bui.append("select des_codigo, des_descricao, des_solicitarprp from destino");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                    while (rs.next()) {
                        ParametroSet destino = new ParametroSet();
                        destino.setString("codigo", rs.getString("des_codigo"));
                        destino.setString("descricao", rs.getString("des_descricao"));
                        destino.setBoolean("solicitaPrp", rs.getBoolean("des_solicitarprp"));
                        destinos.add(destino);
                    }
                } else {
                    String op = this.getOperacao(st, st2, apoiado, "destinos", false);
                    for (String s : StringUtil.getValores(op, "destinos")) {
                        ParametroSet destino = new ParametroSet();
                        for (String c : StringUtil.getValores(s, "campo")) {
                            String campo = StringUtil.getValor(c, "nome");
                            String valor = StringUtil.getValor(c, "valor");
                            if (campo.equalsIgnoreCase("emb_codigo")) {
                                destino.setInt("codigo", Integer.valueOf(valor));
                                continue;
                            }
                            if (campo.equalsIgnoreCase("emb_descricao")) {
                                destino.setString("descricao", valor);
                                continue;
                            }
                            if (!campo.equalsIgnoreCase("des_solicitarprp")) continue;
                            destino.setBoolean("solicitaPrp", Boolean.valueOf(valor));
                        }
                        destinos.add(destino);
                    }
                    this.conexao.arquivaSQL();
                }
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
            paramRetorno.setListParam("destinos", destinos);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getCodigoCliente() throws Exception {
        ParametroSet retorno = new ParametroSet();
        Statement st = this.conexao.getStatement();
        try {
            long codigoCliente = this.getCodigoCliente(st);
            retorno.setString("codigoCliente", StringUtil.encriptar(codigoCliente));
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getFeriados(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> feriados = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select fer_dia, fer_motivo, fer_fixo from feriados where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet feriado = new ParametroSet();
                    feriado.setDate("data", rs.getDate("fer_dia"));
                    feriado.setString("descricao", rs.getString("fer_motivo"));
                    feriado.setBoolean("fixo", rs.getBoolean("fer_fixo"));
                    feriados.add(feriado);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "feriados", false);
                for (String s : StringUtil.getValores(op, "feriado")) {
                    ParametroSet feriado = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("fer_dia")) {
                            feriado.setDate("data", Funcoes.stringToDate("yyyy-MM-dd", valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("fer_motivo")) {
                            feriado.setString("descricao", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("fer_fixo")) continue;
                        feriado.setBoolean("fixo", valor.equals(TRUE));
                    }
                    feriados.add(feriado);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("feriados", feriados);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getFiliais(ParametroSet parametros) throws Exception {
        ParametroSet retorno;
        Statement st = this.conexao.getStatement();
        try {
            long codigoCliente = this.getCodigoCliente(st);
            long codigoClienteNoApoio = StringUtil.desencriptar(parametros.getString("codigoCliente"));
            if (codigoClienteNoApoio != codigoCliente) {
                throw new Exception("Codigo do Cliente inv\u00e1lido");
            }
            retorno = new ParametroSet();
            ArrayList<ParametroSet> filiais = new ArrayList<ParametroSet>();
            String sql = "select fil_codigo, fil_descricao, fil_tipobase from filiais_postocoleta where fil_apoio = true";
            ResultSet rs = this.conexao.executeQuery(st, sql);
            while (rs.next()) {
                ParametroSet filial = new ParametroSet();
                filial.setInt("codigo", rs.getInt("fil_codigo"));
                filial.setString("descricao", rs.getString("fil_descricao"));
                filial.setString("tipobase", rs.getString("fil_tipobase"));
                filiais.add(filial);
            }
            retorno.setListParam("filiais", filiais);
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return retorno;
    }

    public ParametroSet getImagemSuporte(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        File file = null;
        if (!Funcoes.textoVazio(this.imagemSuporte)) {
            file = new File(this.imagemSuporte);
        }
        if (file != null && file.exists()) {
            if (param.getBoolean("semImagem").booleanValue() || !file.getName().equals(param.getString("nome")) || file.lastModified() != param.getLong("modificacao").longValue()) {
                ImageIcon ib = new ImageIcon(ImageIO.read(file));
                paramRetorno.setString("imagem", new Base64().encodeAsString(ImagemUtils.imageToByte(ib.getImage())));
                paramRetorno.setString("nome", file.getName());
                paramRetorno.setLong("modificacao", file.lastModified());
            }
        } else {
            paramRetorno.setBoolean("inexistente", true);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getLayout(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        Statement st = this.conexao.getStatement();
        try {
            StringBuilder bui = new StringBuilder();
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                bui.append("select a.lay_codigo, b.lay_cabec, a.lay_codigoapoio, c.lay_cabec as lay_cabecapoio");
                bui.append(", a.con_apoiomudamodelo as mudaModelo");
                bui.append(" from convenios a ");
                bui.append(" left join layout b on a.fil_codigo = b.fil_codigo and a.lay_codigo = b.lay_codigo");
                bui.append(" left join layout c on a.fil_codigo = c.fil_codigo and a.lay_codigoapoio = c.lay_codigo");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.con_codigo = ").append(apoiado.getCodigo());
            } else {
                bui.append("select b.lay_codigo, c.lay_cabec, a.lay_codigoapoio, c.lay_cabec as lay_cabecapoio");
                bui.append(", a.pac_apoiomudamodelo as mudaModelo");
                bui.append(" from paciente a");
                bui.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo");
                bui.append(" left join layout c on a.fil_codigo = c.fil_codigo and b.lay_codigo = c.lay_codigo");
                bui.append(" left join layout d on a.fil_codigo = d.fil_codigo and b.lay_codigoapoio = d.lay_codigo");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.pac_codigo = ").append(apoiado.getCodigo());
            }
            ResultSet rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                int codigo = rs.getObject("lay_codigoapoio") != null ? rs.getInt("lay_codigoapoio") : rs.getInt("lay_codigo");
                String layout = rs.getObject("lay_codigoapoio") != null ? rs.getString("lay_cabecapoio") : rs.getString("lay_cabec");
                String permissao = rs.getString("mudaModelo");
                paramRetorno.setInt("codigo", codigo);
                paramRetorno.setString("layout", layout);
                paramRetorno.setString("permissao", permissao);
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMaiorCodigoRequisicao(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        Statement st = this.conexao.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append("select max(cast(req_codigoapoiado as integer)) from requisicao ");
            sql.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                sql.append(" and con_codigo = ").append(apoiado.getCodigo());
            } else {
                sql.append(" and pac_codigo = ").append(apoiado.getCodigo());
            }
            sql.append(" and req_codigoapoiado <> '' and req_codigoapoiado is not null ");
            ResultSet rs = this.conexao.executeQuery(st, sql);
            paramRetorno.setInt("requisicao", rs.next() && Funcoes.isNumeric(rs.getString(1)) ? Integer.parseInt(rs.getString(1)) : -1);
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMaiorCodigoPaciente(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            Statement st = this.conexao.getStatement();
            try {
                StringBuilder sql = new StringBuilder();
                sql.append("select max(cast(pac_codigoapoiado as integer)) from paciente");
                sql.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                sql.append(" and con_codigo = ").append(apoiado.getCodigo());
                sql.append(" and pac_codigoapoiado  <> '' and pac_codigoapoiado  is not null");
                ResultSet rs = this.conexao.executeQuery(st, sql);
                paramRetorno.setString("paciente", rs.next() && Funcoes.isNumeric(rs.getString(1)) ? rs.getString(1) : "0");
            }
            finally {
                this.conexao.fecharStatement(st);
            }
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMaterialColeta(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> materiais = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select mco_codigo, mco_descricao, mco_abreviatura, mco_solicitarmat, mco_solicitararea from materialcoleta where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet mat = new ParametroSet();
                    mat.setInt("codigo", rs.getInt("mco_codigo"));
                    mat.setString("descricao", rs.getString("mco_descricao"));
                    mat.setString("abreviatura", rs.getString("mco_abreviatura"));
                    mat.setBoolean("solicitarMaterial", rs.getBoolean("mco_solicitarmat"));
                    mat.setBoolean("solicitarArea", rs.getBoolean("mco_solicitararea"));
                    materiais.add(mat);
                }
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        paramRetorno.setListParam("materiais", materiais);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMedicamentos(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> medicamentos = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select mto_codigo, mto_descricao, mto_fabricante, mto_indicacao, mto_interacao from medicamentos where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet medicamento = new ParametroSet();
                    medicamento.setInt("codigo", rs.getInt("mto_codigo"));
                    medicamento.setString("descricao", rs.getString("mto_descricao"));
                    medicamento.setString("fabricante", rs.getString("mto_fabricante"));
                    medicamento.setString("indicacao", StringUtil.tratarEntidadesHTML(rs.getString("mto_indicacao")));
                    medicamento.setString("interacao", StringUtil.tratarEntidadesHTML(rs.getString("mto_interacao")));
                    medicamentos.add(medicamento);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "medicamentos", false);
                for (String s : StringUtil.getValores(op, "medicamento")) {
                    ParametroSet medicamento = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("mto_codigo")) {
                            medicamento.setInt("codigo", Integer.valueOf(valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("mto_descricao")) {
                            medicamento.setString("descricao", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("mto_fabricante")) {
                            medicamento.setString("fabricante", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("mto_indicacao")) {
                            medicamento.setString("indicacao", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("mto_interacao")) continue;
                        medicamento.setString("interacao", valor);
                    }
                    medicamentos.add(medicamento);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("medicamentos", medicamentos);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMedicos(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        boolean importarTodos = param.getBoolean("importarTodos");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> medicos = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                StringBuilder bui = new StringBuilder();
                if (importarTodos) {
                    bui.append("select med_nome, med_conselho, med_crm, med_uf from medico");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                } else {
                    bui.append("select b.med_conselho,  b.med_crm, b.med_uf, b.med_nome");
                    bui.append(" from requisicao a");
                    bui.append(" left join medico b on a.fil_codigo = b.fil_codigo");
                    bui.append(" and a.med_conselho = b.med_conselho");
                    bui.append(" and a.med_crm = b.med_crm");
                    bui.append(" and a.med_uf = b.med_uf");
                    bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                    if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                        bui.append(" and a.pac_codigo = ").append(apoiado.getCodigo());
                    } else {
                        bui.append(" and a.con_codigo = ").append(apoiado.getCodigo());
                    }
                    bui.append(" group by b.med_conselho,  b.med_crm, b.med_uf, b.med_nome");
                }
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                while (rs.next()) {
                    ParametroSet med = new ParametroSet();
                    med.setString("nome", rs.getString("med_nome"));
                    med.setString("conselho", rs.getString("med_conselho"));
                    med.setString("crm", rs.getString("med_crm"));
                    med.setString("uf", rs.getString("med_uf"));
                    medicos.add(med);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "medico", false);
                for (String s : StringUtil.getValores(op, "medico")) {
                    ParametroSet med = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("med_nome")) {
                            med.setString("nome", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("med_conselho")) {
                            med.setString("conselho", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("med_crm")) {
                            med.setString("crm", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("med_uf")) continue;
                        med.setString("uf", valor);
                    }
                    medicos.add(med);
                }
                String sql = "select med_nome, med_conselho, med_crm, med_uf from medico where fil_codigo = " + apoiado.getCodigoFilial() + " and med_crm = '" + ParametrosLocais.getParametro("medicoCrmPadraoRMI") + "' and med_uf = '" + ParametrosLocais.getParametro("medicoUFPadraoRMI") + "' and med_conselho = '" + ParametrosLocais.getParametro("medicoConselhoPadraoRMI") + "'";
                ResultSet rs = this.conexao.executeQuery(st, sql);
                if (rs.next()) {
                    ParametroSet med = new ParametroSet();
                    med.setString("nome", rs.getString("med_nome"));
                    med.setString("conselho", rs.getString("med_conselho"));
                    med.setString("crm", rs.getString("med_crm"));
                    med.setString("uf", rs.getString("med_uf"));
                    medicos.add(med);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("medicos", medicos);
        return paramRetorno;
    }

    public ParametroSet getMensagens(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                ArrayList<ParametroSet> mensagens = new ArrayList<ParametroSet>();
                String sql = "select cme_codigo, cme_data, cme_mensagem, cme_titulo from conveniomensagem where fil_codigo = " + apoiado.getCodigoFilial() + " and con_codigo = " + apoiado.getCodigo() + " and cme_exportado = false order by cme_codigo";
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet paramMensagem = new ParametroSet();
                    paramMensagem.setDate("data", new java.util.Date(rs.getTimestamp("cme_data").getTime()));
                    paramMensagem.setString("titulo", rs.getString("cme_titulo"));
                    paramMensagem.setString("texto", rs.getString("cme_mensagem"));
                    mensagens.add(paramMensagem);
                    sql = "update conveniomensagem set cme_exportado = true where fil_codigo = " + apoiado.getCodigoFilial() + " and cme_codigo = " + rs.getString("cme_codigo") + " and con_codigo = " + apoiado.getCodigo();
                    this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st2, sql, true);
                }
                this.conexao.arquivaSQL();
                paramRetorno.setListParam("mensagens", mensagens);
            }
            catch (Exception exception) {
                try {
                    this.conexao.anulaSQL();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            finally {
                this.conexao.fecharStatement(st2);
                this.conexao.fecharStatement(st);
            }
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getMetodos(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> metodos = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select met_codigo, met_descricao from metodologia where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet met = new ParametroSet();
                    met.setInt("codigo", rs.getInt("met_codigo"));
                    met.setString("descricao", rs.getString("met_descricao"));
                    metodos.add(met);
                }
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        paramRetorno.setListParam("metodos", metodos);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getModeloRelatorio() throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Statement st = this.conexao.getStatement();
        try {
            String sql = "select rel_xml from relatoriosistema where rel_codigo = " + RelatorioConferenciaEnviados.getModuloAcesso();
            ResultSet rs = this.conexao.executeQuery(st, sql);
            rs.next();
            paramRetorno.setString("relatorio", rs.getString("rel_xml"));
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getParametrosGerais() throws SQLException {
        ParametroSet paramRetorno = new ParametroSet();
        Statement st = this.conexao.getStatement();
        try {
            String sql = "select lay_codigo, par_uppercase, par_buscacpf, par_needconferencia, par_ordenarsetor, par_obrigadosagem, par_mascarafone from parametros";
            try (ResultSet rs = null;){
                rs = st.executeQuery(sql);
                if (rs.next()) {
                    paramRetorno.setInt("layout", rs.getInt("lay_codigo"));
                    paramRetorno.setBoolean("upperCase", rs.getBoolean("par_uppercase"));
                    paramRetorno.setBoolean("buscaCPF", rs.getBoolean("par_buscacpf"));
                    paramRetorno.setBoolean("conferencia", rs.getBoolean("par_needconferencia"));
                    paramRetorno.setBoolean("ordenarSetor", rs.getBoolean("par_ordenarsetor"));
                    paramRetorno.setBoolean("obrigaDosagem", rs.getBoolean("par_obrigadosagem"));
                    paramRetorno.setString("mascara", DBUtil.campoNull(rs.getString("par_mascarafone")) ? "" : rs.getString("par_mascarafone"));
                }
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getPrazoEntrega(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> prazos = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select prz_codigo, prz_descricao, prz_prazo, prz_dias, prz_horaentrada, prz_horasaida, prz_horasaidasabado  from prazoentrega where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet prazo = new ParametroSet();
                    prazo.setInt("codigo", rs.getInt("prz_codigo"));
                    prazo.setString("descricao", rs.getString("prz_descricao"));
                    prazo.setString("prazo", rs.getString("prz_prazo"));
                    prazo.setInt("dias", rs.getInt("prz_dias"));
                    prazo.setString("horaEntrada", Funcoes.formataData(HH_MM, rs.getTimestamp("prz_horaentrada")));
                    prazo.setString("horaSaida", Funcoes.formataData(HH_MM, rs.getTimestamp("prz_horasaida")));
                    prazo.setString("horaSaidaSabado", Funcoes.formataData(HH_MM, rs.getTimestamp("prz_horasaidasabado")));
                    prazos.add(prazo);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "prazoentrega", false);
                for (String s : StringUtil.getValores(op, "prazoentrega")) {
                    ParametroSet prazo = new ParametroSet();
                    String prazoPrazo = "";
                    int dias = 0;
                    String horaEntrada = "";
                    String horaSaida = "";
                    String horaSaidaSabado = "";
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("prz_codigo")) {
                            prazo.setInt("codigo", Integer.valueOf(valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("prz_descricao")) {
                            prazo.setString("descricao", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("prz_prazo")) {
                            prazoPrazo = valor;
                            continue;
                        }
                        if (campo.equalsIgnoreCase("prz_dias") && !Funcoes.textoVazio(valor) && !valor.equals("null")) {
                            dias = Integer.valueOf(valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("prz_horaentrada")) {
                            horaEntrada = valor;
                            continue;
                        }
                        if (campo.equalsIgnoreCase("prz_horasaida")) {
                            horaSaida = valor;
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("prz_horasaidasabado")) continue;
                        horaSaidaSabado = valor;
                    }
                    prazo.setString("prazo", prazoPrazo);
                    prazo.setInt("dias", dias);
                    prazo.setString("horaEntrada", Funcoes.textoVazio(horaEntrada) || horaEntrada.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM, Funcoes.stringToDate(HH_MM, horaEntrada)));
                    prazo.setString("horaSaida", Funcoes.textoVazio(horaSaida) || horaSaida.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM, Funcoes.stringToDate(HH_MM, horaSaida)));
                    prazo.setString("horaSaidaSabado", Funcoes.textoVazio(horaSaidaSabado) || horaSaidaSabado.equalsIgnoreCase("null") ? "" : Funcoes.formataData(HH_MM, Funcoes.stringToDate(HH_MM, horaSaidaSabado)));
                    prazos.add(prazo);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("prazos", prazos);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getRecipientes(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> recipientes = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select rec_codigo, rec_descricao, rec_tipo, rec_capacidade, unm_codigo from recipientes where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet rec = new ParametroSet();
                    rec.setInt("codigo", rs.getInt("rec_codigo"));
                    rec.setString("descricao", rs.getString("rec_descricao"));
                    rec.setString("tipo", rs.getString("rec_tipo"));
                    rec.setFloat("capacidade", Float.valueOf(rs.getFloat("rec_capacidade")));
                    rec.setString("unidade", rs.getString("unm_codigo"));
                    recipientes.add(rec);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "recipientes", false);
                for (String s : StringUtil.getValores(op, "recipiente")) {
                    ParametroSet rec = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("rec_codigo")) {
                            rec.setInt("codigo", Integer.valueOf(valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("rec_descricao")) {
                            rec.setString("descricao", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("rec_tipo")) {
                            rec.setString("tipo", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("rec_capacidade") && !Funcoes.textoVazio(valor) && !valor.equals("null")) {
                            rec.setFloat("capacidade", Float.valueOf(valor));
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("unm_codigo")) continue;
                        rec.setString("unidade", valor);
                    }
                    recipientes.add(rec);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("recipientes", recipientes);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getSetores(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> setores = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            if (primeiraConexao) {
                String sql = "select set_codigo, set_descricao, set_responsavel, set_cor, set_sigla from setores where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet setor = new ParametroSet();
                    setor.setInt("codigo", rs.getInt("set_codigo"));
                    setor.setString("descricao", rs.getString("set_descricao"));
                    setor.setString("responsavel", rs.getString("set_responsavel"));
                    setor.setString("cor", rs.getString("set_cor"));
                    setor.setString("sigla", rs.getString("set_sigla"));
                    setores.add(setor);
                }
            } else {
                String op = this.getOperacao(st, st2, apoiado, "setores", false);
                for (String s : StringUtil.getValores(op, "setor")) {
                    ParametroSet setor = new ParametroSet();
                    for (String c : StringUtil.getValores(s, "campo")) {
                        String campo = StringUtil.getValor(c, "nome");
                        String valor = StringUtil.getValor(c, "valor");
                        if (campo.equalsIgnoreCase("set_codigo")) {
                            setor.setInt("codigo", Integer.valueOf(valor));
                            continue;
                        }
                        if (campo.equalsIgnoreCase("set_descricao")) {
                            setor.setString("descricao", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("set_responsavel")) {
                            setor.setString("responsavel", valor);
                            continue;
                        }
                        if (campo.equalsIgnoreCase("set_cor")) {
                            setor.setString("cor", valor);
                            continue;
                        }
                        if (!campo.equalsIgnoreCase("set_sigla")) continue;
                        setor.setString("sigla", valor);
                    }
                    setores.add(setor);
                }
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        paramRetorno.setListParam("setores", setores);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getApoiado(ParametroSet param) throws Exception {
        ParametroSet paramResposta = new ParametroSet();
        int filial = param.getInt("codigoFilial");
        int codigo = param.getInt("codigo");
        int codigoLote = -1;
        if (param.getInt("codigoLote") != null) {
            codigoLote = param.getInt("codigoLote");
        }
        Statement st = this.conexao.getStatement();
        try {
            long codigoCliente = this.getCodigoCliente(st);
            long codigoClienteNoApoio = StringUtil.desencriptar(param.getString("codigoCliente"));
            if (codigoClienteNoApoio == codigoCliente) {
                StringBuilder bui = new StringBuilder();
                bui.append("select fil_descricao, fil_tipobase from filiais_postocoleta");
                bui.append(" where fil_codigo = ").append(filial).append(" and fil_apoio = true");
                ResultSet rs = this.conexao.executeQuery(st, bui.toString());
                if (rs.next()) {
                    ParametroSet paramApoiado = new ParametroSet();
                    String tipoFilial = rs.getString("fil_tipobase");
                    paramApoiado.setString("tipoFilial", tipoFilial);
                    if (tipoFilial.equalsIgnoreCase("C") || tipoFilial.equalsIgnoreCase("V")) {
                        bui.setLength(0);
                        bui.append("select con_razao, con_apoiodias, con_nrexames, con_bloquearlaudoapoio, con_solicitarcaixaapoio");
                        bui.append(" from convenios");
                        bui.append(" where fil_codigo = ").append(filial);
                        bui.append(" and con_codigo = ").append(codigo);
                        bui.append(" and con_labapoio = true");
                        rs = this.conexao.executeQuery(st, bui.toString());
                        if (rs.next()) {
                            paramApoiado.setBoolean("validado", true);
                            paramApoiado.setString("nome", rs.getString("con_razao"));
                            paramApoiado.setInt("dias", rs.getInt("con_apoiodias"));
                            paramApoiado.setInt("qtMaximaExames", rs.getInt("con_nrexames"));
                            paramApoiado.setBoolean("bloquearLaudo", rs.getBoolean("con_bloquearlaudoapoio"));
                            paramApoiado.setBoolean("solicitarCaixa", rs.getBoolean("con_solicitarcaixaapoio"));
                            bui.setLength(0);
                            bui.append("select max(lot_codigo) as ultimoLote from loteapoio");
                            bui.append(" where fil_codigo = ").append(filial);
                            bui.append(" and con_codigo = ").append(codigo);
                            rs = this.conexao.executeQuery(st, bui.toString());
                            paramApoiado.setInt("ultimoLote", rs.next() ? rs.getInt("ultimoLote") : 0);
                            if (codigoLote > 0) {
                                bui.setLength(0);
                                bui.append("select 1 as lote from loteapoio ");
                                bui.append(" where fil_codigo = ").append(filial);
                                bui.append("   and con_codigo = ").append(codigo);
                                bui.append("   and lot_codigo = ").append(codigoLote);
                                rs = this.conexao.executeQuery(st, bui.toString());
                                this.logger.log(Level.INFO, "===================>>>>>> Consultando lote existente: " + codigoLote + "\n" + bui.toString());
                                paramApoiado.setBoolean("loteexiste", rs.next() ? Boolean.TRUE : Boolean.FALSE);
                                this.logger.log(Level.INFO, "===================>>>>>> Resultado da consulta do lote: " + paramApoiado.getBoolean("loteexiste"));
                            }
                            paramResposta.setParametroSet("apoiado", paramApoiado);
                        }
                    } else if (tipoFilial.equalsIgnoreCase("A")) {
                        bui.setLength(0);
                        bui.append("select a.pac_nome, a.pac_diasapoio, b.con_nrexames, b.con_bloquearlaudoapoio, b.con_solicitarcaixaapoio");
                        bui.append(" from paciente a");
                        bui.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo");
                        bui.append(" where a.fil_codigo = ").append(filial);
                        bui.append(" and a.pac_codigo = ").append(codigo);
                        bui.append(" and a.pac_labapoio = true and a.pac_conectalabapoio = true");
                        rs = this.conexao.executeQuery(st, bui.toString());
                        if (rs.next()) {
                            paramApoiado.setBoolean("validado", true);
                            paramApoiado.setString("nome", rs.getString("pac_nome"));
                            paramApoiado.setInt("dias", rs.getInt("pac_diasapoio"));
                            paramApoiado.setInt("qtMaximaExames", rs.getInt("con_nrexames"));
                            paramApoiado.setBoolean("bloquearLaudo", rs.getBoolean("con_bloquearlaudoapoio"));
                            paramApoiado.setBoolean("solicitarCaixa", rs.getBoolean("con_solicitarcaixaapoio"));
                            bui.setLength(0);
                            bui.append("select max(lot_codigo) as ultimoLote from loteapoio");
                            bui.append(" where fil_codigo = ").append(filial);
                            bui.append(" and pac_codigo = ").append(codigo);
                            rs = this.conexao.executeQuery(st, bui.toString());
                            paramApoiado.setInt("ultimoLote", rs.next() ? rs.getInt("ultimoLote") : 0);
                            if (codigoLote > 0) {
                                bui.setLength(0);
                                bui.append("select 1 as lote from loteapoio ");
                                bui.append(" where fil_codigo = ").append(filial);
                                bui.append("   and con_codigo = ").append(codigo);
                                bui.append("   and lot_codigo = ").append(codigoLote);
                                rs = this.conexao.executeQuery(st, bui.toString());
                                paramApoiado.setBoolean("loteexiste", rs.next() ? Boolean.TRUE : Boolean.FALSE);
                            }
                            paramResposta.setParametroSet("apoiado", paramApoiado);
                        }
                    }
                }
                rs.close();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramResposta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getUsuarios(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> users = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        try {
            String sql = "select usr_codigo, usr_nome, usr_assinatura from usuario where usr_assinatura <> ''";
            ResultSet rs = this.conexao.executeQuery(st, sql);
            while (rs.next()) {
                ParametroSet user = new ParametroSet();
                user.setString("codigo", rs.getString("usr_codigo"));
                user.setString("nome", rs.getString("usr_nome"));
                user.setString("assinatura", StringUtil.compactar(rs.getString("usr_assinatura")));
                users.add(user);
            }
            paramRetorno.setListParam("usuarios", users);
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    public ParametroSet getPacientes(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> pacientes = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            ArrayList<Integer> codigosPacParaEnviar = new ArrayList<Integer>();
            if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                codigosPacParaEnviar.add(apoiado.getCodigo());
            } else {
                String op = this.getOperacao(st, st2, apoiado, "paciente", false);
                for (String s : StringUtil.getValores(op, "paciente")) {
                    codigosPacParaEnviar.add(Integer.valueOf(StringUtil.getValor(s, "codigo")));
                }
            }
            StringBuilder buf = new StringBuilder();
            buf.append("select a.pac_codigo, a.bai_codigo, a.pac_nome, a.pac_sexo, ");
            buf.append("a.pac_datanasc, a.pac_vip, a.pac_grpsangue, a.pac_fatorrh, a.pac_fatordu, ");
            buf.append("a.pac_cor, a.pac_observ, a.pac_dadoclinico, a.pac_peso, a.pac_altura, ");
            buf.append("a.pac_matricconv, a.pac_titularconv, a.pac_profissao, a.pac_fumante, ");
            buf.append("a.pac_diabetico, a.pac_rg, a.pac_cpf, a.pac_estcivil, a.pac_numfilho, ");
            buf.append("a.pac_dum, a.cid_codigo, a.pac_fax, a.pac_celular, ");
            buf.append("a.pac_fonecomercial, a.pac_fone, a.pac_cep, a.pac_complemento, ");
            buf.append("a.pac_tipologradouroendereco, a.pac_endereco, a.pac_numeroendereco, a.pac_email, a.pac_anomes, a.pac_idade, a.con_codigo, ");
            buf.append("a.med_conselho, a.med_crm, a.med_uf, a.pac_fonecontato, a.pac_nomecontato, ");
            buf.append("a.pac_mae, a.pac_pai, a.pac_maladireta, a.pac_senhaweb, a.pac_codigoapoiado, ");
            buf.append("a.pac_razaosocial, a.pac_cnpj, a.pac_sif, b.con_codigo, b.con_cnpjcpf, b.con_fantasia, ");
            buf.append("a.pac_proprietario, a.pac_pelagem, a.epc_codigo, a.rac_codigo ");
            buf.append("from paciente a ");
            buf.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo ");
            buf.append("where a.fil_codigo = ? and a.pac_codigo = ?");
            if (!apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                buf.append(" and a.pac_codigoapoiado is not null");
            }
            PreparedStatement pst = this.conexao.getPreparedStatement(buf.toString());
            for (Integer codigo : codigosPacParaEnviar) {
                pst.setInt(1, apoiado.getCodigoFilial());
                pst.setInt(2, codigo);
                ResultSet rs = this.conexao.executeQuery(pst);
                if (!rs.next()) continue;
                ParametroSet pac = new ParametroSet();
                pac.setString("codigo", rs.getString("pac_codigoapoiado"));
                pac.setLong("codigoServidor", rs.getLong("pac_codigo"));
                pac.setString("nome", rs.getString("pac_nome"));
                pac.setString("bairro", rs.getString("bai_codigo"));
                pac.setString("sexo", rs.getString("pac_sexo"));
                pac.setDate("nascimento", rs.getDate("pac_datanasc"));
                pac.setBoolean("vip", rs.getBoolean("pac_vip"));
                pac.setString("grupoSangue", rs.getString("pac_grpsangue"));
                pac.setString("fatorRH", rs.getString("pac_fatorrh"));
                pac.setString("fatorDU", rs.getString("pac_fatordu"));
                pac.setString("cor", rs.getString("pac_cor"));
                pac.setString("observacao", rs.getString("pac_observ"));
                pac.setString("dadosClinicos", rs.getString("pac_dadoclinico"));
                pac.setFloat("peso", Float.valueOf(rs.getFloat("pac_peso")));
                pac.setFloat("altura", Float.valueOf(rs.getFloat("pac_altura")));
                pac.setString("matriculaConvenio", rs.getString("pac_matricconv"));
                pac.setString("titularConvenio", rs.getString("pac_titularconv"));
                pac.setString("profissao", rs.getString("pac_profissao"));
                pac.setBoolean("fumante", rs.getString("pac_fumante") != null && rs.getString("pac_fumante").equalsIgnoreCase(S));
                pac.setBoolean("diabetico", rs.getString("pac_diabetico") != null && rs.getString("pac_diabetico").equalsIgnoreCase(S));
                pac.setString("rg", rs.getString("pac_rg"));
                pac.setString("cpf", rs.getString("pac_cpf"));
                pac.setString("estadoCivil", rs.getString("pac_estcivil"));
                pac.setInt("numeroFilhos", rs.getInt("pac_numfilho"));
                pac.setDate("dum", rs.getDate("pac_dum"));
                pac.setInt("cidade", rs.getInt("cid_codigo"));
                pac.setString("fax", rs.getString("pac_fax"));
                pac.setString("celular", rs.getString("pac_celular"));
                pac.setString("foneComercial", rs.getString("pac_fonecomercial"));
                pac.setString("fone", rs.getString("pac_fone"));
                pac.setString("cep", rs.getString("pac_cep"));
                pac.setString("complemento", rs.getString("pac_complemento"));
                pac.setString("tipoLogradouro", rs.getString("pac_tipologradouroendereco"));
                pac.setString("endereco", rs.getString("pac_endereco"));
                pac.setString("numeroEndereco", rs.getString("pac_numeroendereco"));
                pac.setString("email", rs.getString("pac_email"));
                pac.setString("tipoIdade", rs.getString("pac_anomes"));
                pac.setInt("idade", rs.getInt("pac_idade"));
                pac.setInt("convenio", rs.getInt("con_codigo"));
                pac.setString("medicoConselho", rs.getString("med_conselho"));
                pac.setString("medicoCrm", rs.getString("med_crm"));
                pac.setString("medicoUf", rs.getString("med_uf"));
                pac.setString("foneContato", rs.getString("pac_fonecontato"));
                pac.setString("nomeContato", rs.getString("pac_nomecontato"));
                pac.setString("mae", rs.getString("pac_mae"));
                pac.setString("pai", rs.getString("pac_pai"));
                pac.setBoolean("malaDireta", rs.getBoolean("pac_maladireta"));
                pac.setString("razao", rs.getString("pac_razaosocial"));
                pac.setString("cnpj", rs.getString("pac_cnpj"));
                pac.setString("sif", rs.getString("pac_sif"));
                pac.setString("proprietario", rs.getString("pac_proprietario"));
                pac.setString("pelagem", rs.getString("pac_pelagem"));
                pac.setInt("especie", rs.getInt("epc_codigo"));
                pac.setInt("raca", rs.getInt("rac_codigo"));
                if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    ParametroSet conv = new ParametroSet();
                    conv.setInt("codigo", rs.getInt("con_codigo"));
                    conv.setString("fantasia", rs.getString("con_fantasia"));
                    conv.setString("cnpjCpf", rs.getString("con_cnpjcpf"));
                    pac.setParametroSet("convenio", conv);
                    buf.setLength(0);
                    buf.append("select a.ent_codigo, b.ent_razaosocial from pacienteentidade a");
                    buf.append(" left join entidade b on a.fil_codigo = b.fil_codigo and a.ent_codigo = b.ent_codigo");
                    buf.append(" where a.pac_codigo = ").append(rs.getLong("pac_codigo"));
                    buf.append(" and a.pen_responsavel = true and a.fil_codigo = ").append(apoiado.getCodigoFilial());
                    rs = this.conexao.executeQuery(st, buf.toString());
                    ArrayList<ParametroSet> responsaveis = new ArrayList<ParametroSet>();
                    while (rs.next()) {
                        ParametroSet resp = new ParametroSet();
                        resp.setInt("codigo", rs.getInt("ent_codigo"));
                        resp.setString("nome", rs.getString("ent_razaosocial"));
                        responsaveis.add(resp);
                    }
                    pac.setListParam("responsaveis", responsaveis);
                }
                pacientes.add(pac);
            }
            paramRetorno.setListParam("pacientes", pacientes);
            this.conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet enviarPaciente(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            ParametroSet pac = param.getParametroSet("paciente");
            String filialString = String.valueOf(apoiado.getCodigoFilial());
            Long codigo = null;
            String codigoApoio = pac.getString("codigo");
            boolean codigoApoioStr = true;
            if (codigoApoio == null) {
                codigoApoioStr = false;
                codigoApoio = String.valueOf(pac.getLong("codigo"));
            }
            Statement st = this.conexao.getStatement();
            Statement st1 = this.conexao.getStatement();
            try {
                String sql = "select pac_codigo from paciente where fil_codigo = " + apoiado.getCodigoFilial() + " and con_codigo = " + apoiado.getCodigo() + " and pac_codigoapoiado = '" + StringUtil.textoDB(codigoApoio) + "'";
                try (ResultSet rs = null;){
                    rs = st.executeQuery(sql);
                    if (rs.next()) {
                        codigo = rs.getLong("pac_codigo");
                    }
                }
                if (codigo == null) {
                    long codigoOrigemPaciente = Long.parseLong(DBUtil.getSequencia(st, "paciente", filialString));
                    codigo = Long.parseLong(DBUtil.formatarValorParaIntegracao(filialString, String.valueOf(codigoOrigemPaciente), !ParametrosGerais.getTipoIntegracao().equals(N), 7));
                    StringBuilder buf = new StringBuilder();
                    buf.append("insert into paciente (fil_codigo, pac_codigo, bai_codigo, pac_nome, pac_sexo, ");
                    buf.append("pac_datanasc, pac_vip, pac_grpsangue, pac_fatorrh, pac_fatordu, ");
                    buf.append("pac_cor, pac_observ, pac_dadoclinico, pac_peso, pac_altura, ");
                    buf.append("pac_matricconv, pac_titularconv, pac_profissao, pac_fumante, ");
                    buf.append("pac_diabetico, pac_rg, pac_cpf, pac_estcivil, pac_numfilho, ");
                    buf.append("pac_dum, cid_codigo, pac_fax, pac_celular, ");
                    buf.append("pac_fonecomercial, pac_fone, pac_cep, pac_complemento, ");
                    buf.append("pac_endereco, pac_tipologradouroendereco, pac_numeroendereco, pac_email, pac_anomes, pac_idade, con_codigo, ");
                    buf.append("med_conselho, med_crm, med_uf, pac_fonecontato, pac_nomecontato, ");
                    buf.append("pac_mae, pac_pai, pac_maladireta, pac_codigoapoiado, usr_codigo, pac_senhaweb, ");
                    buf.append("usr_codalteracao, pac_datahoraalteracao, pac_datahora, pac_proprietario, pac_pelagem, ");
                    buf.append("epc_codigo, rac_codigo, pac_origemapoio) ");
                    buf.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,");
                    buf.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?, current_timestamp, current_timestamp, ?,?,?,?, true)");
                    PreparedStatement prst = this.conexao.getPreparedStatement(buf.toString());
                    int i = 1;
                    prst.setInt(i++, apoiado.getCodigoFilial());
                    prst.setLong(i++, codigo);
                    prst.setString(i++, pac.getString("bairro"));
                    prst.setString(i++, pac.getString("nome"));
                    prst.setString(i++, pac.getString("sexo"));
                    prst.setDate(i++, pac.getDate("nascimento") != null ? new Date(pac.getDate("nascimento").getTime()) : null);
                    prst.setBoolean(i++, pac.getBoolean("vip"));
                    prst.setString(i++, pac.getString("grupoSangue"));
                    prst.setString(i++, pac.getString("fatorRH"));
                    prst.setString(i++, pac.getString("fatorDU"));
                    prst.setString(i++, pac.getString("cor"));
                    prst.setString(i++, StringUtil.converteHtmlParaAcentos(pac.getString("observacao"), true));
                    prst.setString(i++, StringUtil.converteHtmlParaAcentos(pac.getString("dadosClinicos"), true));
                    if (pac.isNull("peso")) {
                        prst.setNull(i++, 6);
                    } else {
                        prst.setFloat(i++, pac.getFloat("peso").floatValue());
                    }
                    if (pac.isNull("altura")) {
                        prst.setNull(i++, 6);
                    } else {
                        prst.setFloat(i++, pac.getFloat("altura").floatValue());
                    }
                    prst.setString(i++, pac.getString("matriculaConvenio"));
                    prst.setString(i++, pac.getString("titularConvenio"));
                    prst.setString(i++, pac.getString("profissao"));
                    if (!pac.isNull("fumante")) {
                        prst.setString(i++, pac.getBoolean("fumante") != false ? S : N);
                    } else {
                        prst.setNull(i++, 16);
                    }
                    if (!pac.isNull("diabetico")) {
                        prst.setString(i++, pac.getBoolean("diabetico") != false ? S : N);
                    } else {
                        prst.setNull(i++, 16);
                    }
                    prst.setString(i++, pac.getString("rg"));
                    prst.setString(i++, pac.getString("cpf"));
                    prst.setString(i++, pac.getString("estadoCivil"));
                    prst.setInt(i++, pac.getInt("numeroFilhos"));
                    prst.setDate(i++, pac.getDate("dum") != null ? new Date(pac.getDate("dum").getTime()) : null);
                    if (pac.getInt("cidade") != 0) {
                        prst.setInt(i++, pac.getInt("cidade"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    prst.setString(i++, pac.getString("fax"));
                    prst.setString(i++, pac.getString("celular"));
                    prst.setString(i++, pac.getString("foneComercial"));
                    prst.setString(i++, pac.getString("fone"));
                    prst.setString(i++, pac.getString("cep"));
                    prst.setString(i++, pac.getString("complemento"));
                    prst.setString(i++, pac.getString("endereco"));
                    prst.setString(i++, pac.getString("tipoLogradouro"));
                    prst.setString(i++, pac.getString("numeroEndereco"));
                    prst.setString(i++, pac.getString("email"));
                    prst.setString(i++, pac.getString("tipoIdade"));
                    prst.setInt(i++, pac.getInt("idade"));
                    prst.setInt(i++, apoiado.getCodigo());
                    prst.setString(i++, pac.getString("medicoConselho"));
                    prst.setString(i++, pac.getString("medicoCrm"));
                    prst.setString(i++, pac.getString("medicoUf"));
                    prst.setString(i++, pac.getString("foneContato"));
                    prst.setString(i++, pac.getString("nomeContato"));
                    prst.setString(i++, pac.getString("mae"));
                    prst.setString(i++, pac.getString("pai"));
                    prst.setBoolean(i++, pac.getBoolean("malaDireta"));
                    if (codigoApoioStr) {
                        prst.setString(i++, codigoApoio);
                    } else {
                        prst.setLong(i++, Long.parseLong(codigoApoio));
                    }
                    prst.setString(i++, ParametrosLocais.getParametro("usuarioPadraoRMI"));
                    prst.setString(i++, Funcoes.gerarSenhaWeb());
                    prst.setString(i++, ParametrosLocais.getParametro("usuarioPadraoRMI"));
                    prst.setString(i++, pac.getString("proprietario"));
                    prst.setString(i++, pac.getString("pelagem"));
                    if (pac.getInt("especie") != 0) {
                        prst.setInt(i++, pac.getInt("especie"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    if (pac.getInt("raca") != 0) {
                        prst.setInt(i++, pac.getInt("raca"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    prst.execute();
                    prst.close();
                    Util.gravaAutoCopiaPaciente(filialString, String.valueOf(codigo), String.valueOf(codigoOrigemPaciente), true, st);
                    Util.exportaWebPaciente(filialString, String.valueOf(codigo), true, st1);
                } else {
                    StringBuilder buf = new StringBuilder();
                    buf.append("update paciente set ");
                    buf.append("bai_codigo = ?, pac_nome = ?, pac_sexo = ?, pac_datanasc = ?, pac_vip = ?, pac_grpsangue = ?");
                    buf.append(", pac_fatorrh = ?, pac_fatordu = ?, pac_cor = ?, pac_observ = ?, pac_dadoclinico = ?");
                    buf.append(", pac_peso = ?, pac_altura = ?, pac_matricconv = ?, pac_titularconv = ?, pac_profissao = ?");
                    buf.append(", pac_fumante = ?, pac_diabetico = ?, pac_rg = ?, pac_cpf = ?, pac_estcivil = ?, pac_numfilho = ?");
                    buf.append(", pac_dum = ?, cid_codigo = ?, pac_fax = ?, pac_celular = ?, pac_fonecomercial = ?");
                    buf.append(", pac_fone = ?, pac_cep = ?, pac_complemento = ?, pac_tipologradouroendereco = ?,  pac_endereco = ?, pac_numeroendereco = ?, pac_email = ?, pac_anomes = ?");
                    buf.append(", pac_idade = ?, med_conselho = ?, med_crm = ?, med_uf = ?, pac_fonecontato = ?");
                    buf.append(", pac_nomecontato = ?, pac_mae = ?, pac_pai = ?, pac_maladireta = ?");
                    buf.append(", usr_codalteracao = ?, pac_datahoraalteracao = current_timestamp");
                    buf.append(", pac_proprietario = ?, pac_pelagem = ?, epc_codigo = ?, rac_codigo = ?, pac_origemapoio = true");
                    buf.append(" where fil_codigo = ? and pac_codigo = ? ");
                    PreparedStatement prst = this.conexao.getPreparedStatement(buf.toString());
                    int i = 1;
                    prst.setString(i++, pac.getString("bairro"));
                    prst.setString(i++, pac.getString("nome"));
                    prst.setString(i++, pac.getString("sexo"));
                    prst.setDate(i++, pac.getDate("nascimento") != null ? new Date(pac.getDate("nascimento").getTime()) : null);
                    prst.setBoolean(i++, pac.getBoolean("vip"));
                    prst.setString(i++, pac.getString("grupoSangue"));
                    prst.setString(i++, pac.getString("fatorRH"));
                    prst.setString(i++, pac.getString("fatorDU"));
                    prst.setString(i++, pac.getString("cor"));
                    prst.setString(i++, pac.getString("observacao"));
                    prst.setString(i++, pac.getString("dadosClinicos"));
                    if (pac.isNull("peso")) {
                        prst.setNull(i++, 6);
                    } else {
                        prst.setFloat(i++, pac.getFloat("peso").floatValue());
                    }
                    if (pac.isNull("altura")) {
                        prst.setNull(i++, 6);
                    } else {
                        prst.setFloat(i++, pac.getFloat("altura").floatValue());
                    }
                    prst.setString(i++, pac.getString("matriculaConvenio"));
                    prst.setString(i++, pac.getString("titularConvenio"));
                    prst.setString(i++, pac.getString("profissao"));
                    if (!pac.isNull("fumante")) {
                        prst.setString(i++, pac.getBoolean("fumante") != false ? S : N);
                    } else {
                        prst.setNull(i++, 16);
                    }
                    if (!pac.isNull("diabetico")) {
                        prst.setString(i++, pac.getBoolean("diabetico") != false ? S : N);
                    } else {
                        prst.setNull(i++, 16);
                    }
                    prst.setString(i++, pac.getString("rg"));
                    prst.setString(i++, pac.getString("cpf"));
                    prst.setString(i++, pac.getString("estadoCivil"));
                    prst.setInt(i++, pac.getInt("numeroFilhos"));
                    prst.setDate(i++, pac.getDate("dum") != null ? new Date(pac.getDate("dum").getTime()) : null);
                    if (pac.getInt("cidade") != 0) {
                        prst.setInt(i++, pac.getInt("cidade"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    prst.setString(i++, pac.getString("fax"));
                    prst.setString(i++, pac.getString("celular"));
                    prst.setString(i++, pac.getString("foneComercial"));
                    prst.setString(i++, pac.getString("fone"));
                    prst.setString(i++, pac.getString("cep"));
                    prst.setString(i++, pac.getString("complemento"));
                    prst.setString(i++, pac.getString("tipoLogradouro"));
                    prst.setString(i++, pac.getString("endereco"));
                    prst.setString(i++, pac.getString("numeroEndereco"));
                    prst.setString(i++, pac.getString("email"));
                    prst.setString(i++, pac.getString("tipoIdade"));
                    prst.setInt(i++, pac.getInt("idade"));
                    prst.setString(i++, pac.getString("medicoConselho"));
                    prst.setString(i++, pac.getString("medicoCrm"));
                    prst.setString(i++, pac.getString("medicoUf"));
                    prst.setString(i++, pac.getString("foneContato"));
                    prst.setString(i++, pac.getString("nomeContato"));
                    prst.setString(i++, pac.getString("mae"));
                    prst.setString(i++, pac.getString("pai"));
                    prst.setBoolean(i++, pac.getBoolean("malaDireta"));
                    prst.setString(i++, ParametrosLocais.getParametro("usuarioPadraoRMI"));
                    prst.setString(i++, pac.getString("proprietario"));
                    prst.setString(i++, pac.getString("pelagem"));
                    if (pac.getInt("especie") != 0) {
                        prst.setInt(i++, pac.getInt("especie"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    if (pac.getInt("raca") != 0) {
                        prst.setInt(i++, pac.getInt("raca"));
                    } else {
                        prst.setNull(i++, 4);
                    }
                    prst.setInt(i++, apoiado.getCodigoFilial());
                    prst.setLong(i++, codigo);
                    prst.execute();
                    prst.close();
                    Util.gravaAutoCopiaPaciente(filialString, String.valueOf(codigo), String.valueOf(codigo), false, st);
                    Util.exportaWebPaciente(filialString, String.valueOf(codigo), false, st1);
                }
                paramRetorno.setLong("codigo", codigo);
                this.conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    this.conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw ex;
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st1);
            }
        }
        return paramRetorno;
    }

    public ParametroSet getRequisicoes(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> requisicoes = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select a.req_codigoapoiado, a.req_codigo, a.sit_codigo, a.med_conselho, a.med_crm, ");
            buf.append("a.req_data, a.req_dtfatura, a.req_urgente, a.req_dataentregaprev, a.req_dclinicos, a.req_obs, ");
            buf.append("a.req_totpago, a.req_total, a.med_uf, a.req_horaentregaprev, a.req_horafatura, a.req_hora, ");
            buf.append("a.req_gestante, a.req_dum, a.req_anomes, a.req_idade, a.req_avisarpaciente, ");
            buf.append("a.req_titular, a.req_altura, a.req_peso, ");
            buf.append("a.req_datarequisicao, a.req_neonato ");
            buf.append("from requisicao a ");
            buf.append("where a.fil_codigo = ? and a.req_codigo = ? and a.req_excluida = false");
            PreparedStatement prst = this.conexao.getPreparedStatement(buf.toString());
            String op = this.getOperacao(st, st2, apoiado, "requisicao", false);
            for (String r : StringUtil.getValores(op, "requisicao")) {
                long codigo = Long.valueOf(StringUtil.getValor(r, "codigo"));
                prst.setInt(1, apoiado.getCodigoFilial());
                prst.setLong(2, codigo);
                ResultSet rs = this.conexao.executeQuery(prst);
                if (!rs.next()) continue;
                ParametroSet req = new ParametroSet();
                req.setLong("codigoServidor", rs.getLong("req_codigo"));
                req.setString("codigo", rs.getString("req_codigoapoiado"));
                req.setInt("situacao", rs.getInt("sit_codigo"));
                req.setString("medicoConselho", rs.getString("med_conselho"));
                req.setString("medicoCrm", rs.getString("med_crm"));
                req.setString("medicoUf", rs.getString("med_uf"));
                req.setDate("data", rs.getDate("req_data"));
                req.setDate("dataFatura", rs.getDate("req_dtfatura"));
                req.setBoolean("urgente", rs.getBoolean("req_urgente"));
                req.setDate("dataEntregaPrevista", rs.getDate("req_dtfatura"));
                req.setString("dadosClinicos", rs.getString("req_dclinicos"));
                req.setString("observacao", rs.getString("req_obs"));
                req.setFloat("totalPago", Float.valueOf(rs.getFloat("req_totpago")));
                req.setFloat("total", Float.valueOf(rs.getFloat("req_total")));
                req.setString("horaEntregaPrevista", Funcoes.formataData(HH_MM1, rs.getTime("req_horaentregaprev")));
                req.setString("horaFatura", Funcoes.formataData(HH_MM1, rs.getTime("req_horafatura")));
                req.setString("hora", Funcoes.formataData(HH_MM1, rs.getTime("req_hora")));
                req.setBoolean("gestante", rs.getBoolean("req_gestante"));
                req.setDate("dum", rs.getDate("req_dum"));
                req.setString("tipoIdade", rs.getString("req_anomes"));
                req.setInt("idade", rs.getInt("req_idade"));
                req.setBoolean("avisarPaciente", rs.getBoolean("req_avisarpaciente"));
                req.setString("titular", rs.getString("req_titular"));
                req.setFloat("altura", Float.valueOf(rs.getFloat("req_altura")));
                req.setFloat("peso", Float.valueOf(rs.getFloat("req_peso")));
                req.setDate("dataRequisicao", rs.getDate("req_datarequisicao"));
                req.setBoolean("neoNatal", rs.getBoolean("req_neonato"));
                requisicoes.add(req);
            }
            paramRetorno.setListParam("requisicoes", requisicoes);
            this.conexao.arquivaSQL();
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getResultadoExame(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        long requisicao = param.getLong("requisicao");
        String exame = param.getString("exame");
        int material = param.getInt("material");
        ParametroSet paramRetorno = new ParametroSet();
        Statement st = this.conexao.getStatement();
        try {
            String sql = "select pegaResultadoExame(fil_codigo, req_codigo, exa_codigo, mco_codigo) as exr_resultado, exr_situacao, exr_datadigita, exr_dataassina from examerequisicao where fil_codigo = " + apoiado.getCodigoFilial() + " and req_codigo = " + requisicao + " and exa_codigo = '" + exame + "' and mco_codigo = " + material;
            try (ResultSet rs = null;){
                rs = st.executeQuery(sql);
                if (rs.next()) {
                    boolean enviaParcial = ParametrosLocais.getParametro("enviaExameParcial").equalsIgnoreCase(TRUE);
                    if (!(rs.getTime("exr_dataassina") != null || rs.getTime("exr_datadigita") != null && enviaParcial)) {
                        ParametroSet parametroSet = null;
                        return parametroSet;
                    }
                    paramRetorno.setString("resultado", rs.getString("exr_resultado"));
                    this.logger.log(Level.INFO, "Enviando Resultado Req.".concat(String.valueOf(requisicao)).concat(" EXA: ").concat(exame).concat(" MAT.:").concat(String.valueOf(material)));
                    paramRetorno.setBoolean("considerarParcial", enviaParcial);
                    paramRetorno.setString("situacao", rs.getString("exr_situacao"));
                }
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getHashResultadoExame(ParametroSet param) throws Exception {
        ArrayList<ParametroSet> list = new ArrayList<ParametroSet>();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        long requisicao = param.getLong("requisicao");
        String exame = param.getString("exame");
        int material = param.getInt("material");
        int codigoHash = param.getInt("codigoHash");
        Statement st = this.conexao.getStatement();
        try {
            StringBuilder sql = new StringBuilder();
            sql.append(" select * from EXAMEREQUISICAOHASH where req_codigo = ").append(requisicao);
            sql.append(" and fil_codigo = ").append(apoiado.getCodigoFilial());
            sql.append(" and exa_codigo = '").append(exame).append("' ");
            sql.append(" and mco_codigo = ").append(material).append(" ");
            if (codigoHash > 0) {
                sql.append(" and exh_codigo > ").append(codigoHash).append(" ");
            }
            sql.append(" order by  exh_datahora desc ");
            try (ResultSet rs = null;){
                rs = st.executeQuery(sql.toString());
                if (rs.next()) {
                    do {
                        ParametroSet paramRetorno = new ParametroSet();
                        paramRetorno.setInt("exh_codigo", rs.getInt("exh_codigo"));
                        paramRetorno.setString("exa_codigo", rs.getString("exa_codigo"));
                        paramRetorno.setInt("mco_codigo", rs.getInt("mco_codigo"));
                        paramRetorno.setString("req_codigo", rs.getString("req_codigo"));
                        paramRetorno.setString("exh_resultado", rs.getString("exh_resultado"));
                        paramRetorno.setString("exh_textohash", rs.getString("exh_textohash"));
                        paramRetorno.setString("exh_hash", rs.getString("exh_hash"));
                        paramRetorno.setDate("exh_datahora", rs.getTimestamp("exh_datahora"));
                        paramRetorno.setString("usr_codigo", rs.getString("usr_codigo"));
                        list.add(paramRetorno);
                    } while (rs.next());
                }
            }
        }
        finally {
            this.conexao.fecharStatement(st);
        }
        ParametroSet reSet = new ParametroSet();
        reSet.setListParam("listaHash", list);
        return reSet;
    }

    public ParametroSet setResultadoImportado(ParametroSet param) throws SQLException {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRet = new ParametroSet();
        String epa_codigo = param.getString("epa_codigo");
        Statement st = this.conexao.getStatement();
        if (!Funcoes.textoVazio(epa_codigo)) {
            paramRet.setBoolean("OK", this.marcaExportado(st, apoiado, epa_codigo));
        } else {
            paramRet.setBoolean("OK", false);
        }
        this.conexao.arquivaSQL();
        this.conexao.fecharStatement(st);
        return paramRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getEtiquetas(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        int lote = param.getInt("lote");
        String listaExames = param.getString(LISTA_EXAMES);
        String listaMateriais = param.getString(LISTA_MATERIAIS);
        ParametroSet paramRetorno = new ParametroSet();
        Statement st = this.conexao.getStatement();
        Statement st1 = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        Statement st3 = this.conexao.getStatement();
        try {
            boolean semEtiqueta;
            ResultSet rs;
            StringBuilder bui = new StringBuilder();
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                bui.append("select con_apoiosemetiqueta from convenios");
                bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and con_codigo = ").append(apoiado.getCodigo());
                rs = null;
                try {
                    rs = this.conexao.executeQuery(st, bui.toString());
                    semEtiqueta = rs.next() ? rs.getBoolean("con_apoiosemetiqueta") : false;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            bui.append("select pac_apoiosemetiqueta from paciente");
            bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
            bui.append(" and pac_codigo = ").append(apoiado.getCodigo());
            rs = null;
            try {
                rs = this.conexao.executeQuery(st, bui.toString());
                semEtiqueta = rs.next() ? rs.getBoolean("pac_apoiosemetiqueta") : false;
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            if (!semEtiqueta) {
                bui.setLength(0);
                bui.append("select a.req_codigo from loteapoiorequisicao a");
                bui.append(" left join loteapoio b on a.fil_codigo = b.fil_codigo and a.lot_id = b.lot_id");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and b.lot_codigo = ").append(lote);
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(" and b.con_codigo = ").append(apoiado.getCodigo());
                } else {
                    bui.append(" and b.pac_codigo = ").append(apoiado.getCodigo());
                }
                rs = this.conexao.executeQuery(st, bui.toString());
                ArrayList<String> etiquetas = new ArrayList<String>();
                int[] matArray = null;
                String[] exames = null;
                if (listaExames != null && !listaExames.isEmpty()) {
                    exames = listaExames.split(",");
                    String[] materiais = listaMateriais.split(",");
                    matArray = new int[materiais.length];
                    for (int i = 0; i < materiais.length; ++i) {
                        matArray[i] = Integer.parseInt(materiais[i]);
                    }
                }
                while (rs.next()) {
                    String etiqueta = "";
                    etiqueta = exames != null && matArray != null && exames.length > 0 && matArray.length > 0 ? Impressao.getEtiquetaColetaApoio(String.valueOf(apoiado.getCodigoFilial()), rs.getString("req_codigo"), exames, matArray, st1, st2, st3, !semEtiqueta) : Impressao.getEtiquetaColetaApoio(String.valueOf(apoiado.getCodigoFilial()), rs.getString("req_codigo"), st1, st2, st3, !semEtiqueta);
                    this.logger.log(Level.INFO, "etiquetas para enviar: " + etiqueta);
                    String etiqueta2 = StringUtil.parseEtiqueta(etiqueta);
                    this.logger.log(Level.INFO, "etiquetas para enviadas: " + etiqueta.equalsIgnoreCase(etiqueta2) + " - " + etiqueta2);
                    etiquetas.add(etiqueta2);
                }
                paramRetorno.setList("etiquetas", etiquetas);
                this.conexao.arquivaSQL();
            }
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st1);
            this.conexao.fecharStatement(st2);
            this.conexao.fecharStatement(st3);
        }
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet validaExamesLote(ParametroSet param) throws Exception {
        ParametroSet paramRetorno;
        block7: {
            Apoiado apoiado = new Apoiado(param.getString("chave"));
            paramRetorno = new ParametroSet();
            ArrayList<ParametroSet> examesRetorno = new ArrayList<ParametroSet>();
            String sql = "select count(*) as count from examematcoleta where fil_codigo = ? and exa_codigo = ? and mco_codigo = ?";
            try (PreparedStatement prst = this.conexao.getPreparedStatement(sql);){
                if (param.getListParam("exames") == null) break block7;
                for (ParametroSet ex : param.getListParam("exames")) {
                    prst.clearParameters();
                    prst.setInt(1, apoiado.getCodigoFilial());
                    prst.setString(2, ex.getString(CODIGO_EXAME));
                    prst.setInt(3, ex.getInt("material"));
                    ResultSet rs = null;
                    try {
                        rs = prst.executeQuery();
                        rs.next();
                        ParametroSet exRetorno = new ParametroSet();
                        exRetorno.setString(CODIGO_EXAME, ex.getString(CODIGO_EXAME));
                        exRetorno.setInt("material", ex.getInt("material"));
                        exRetorno.setBoolean("valido", rs.getInt("count") > 0);
                        examesRetorno.add(exRetorno);
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                paramRetorno.setListParam("exames", examesRetorno);
            }
        }
        return paramRetorno;
    }

    public ParametroSet getExamesRequisicao(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        boolean resultado = param.getBoolean("resultado");
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> examesExcluir = new ArrayList<ParametroSet>();
        ArrayList<ParametroSet> exames = new ArrayList<ParametroSet>();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        try {
            String[] listaExames;
            String sql = "select a.req_codigo, b.req_codigoapoiado, a.exr_situacao, a.exr_datamaterial, a.exr_datadigita, a.exr_dataassina, a.exr_dataentregaprev, a.exr_resposta, a.met_codigo, a.usr_codassina, a.exa_codigo, a.mco_codigo, a.exr_descricaomaterial, a.exr_obs, a.exr_datacortesia, a.usr_codcortesia, a.exr_data, CASE WHEN a.exr_intervaloJejum is null then TO_CHAR(a.exr_tempoJejum,'HH24:MI:SS') else TO_CHAR(a.exr_intervaloJejum,'HH24:MI:SS') end as exr_intervaloJejum, a.exr_codexameorigem, a.exr_codmatorigem, a.exr_excluido  from examerequisicao a  left join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo where a.fil_codigo = ? and a.req_codigo = ? and a.exa_codigo = ? and a.mco_codigo = ?and b.req_excluida = false";
            String op = this.getOperacao(st, st2, apoiado, "examerequisicao", resultado);
            for (String s : listaExames = StringUtil.getValores(op, "examerequisicao")) {
                ParametroSet ex;
                String epa_codigo = StringUtil.getValor(s, "epa_codigo");
                long codigoRequisicao = Long.parseLong(StringUtil.getValor(s, "codigo"));
                String codigoExame = StringUtil.getValor(s, "exame");
                int codigoMaterial = Integer.parseInt(StringUtil.getValor(s, "material"));
                String operacao = StringUtil.getValor(s, "operacao");
                if (!Funcoes.textoVazio(operacao) && operacao.equalsIgnoreCase("D")) {
                    String sql2 = "select req_codigoapoiado from requisicao where fil_codigo = " + apoiado.getCodigoFilial() + " and req_codigo = " + codigoRequisicao;
                    ResultSet r2 = this.conexao.executeQuery(st2, sql2);
                    if (!r2.next()) continue;
                    ex = new ParametroSet();
                    ex.setLong("requisicao", r2.getLong("req_codigoapoiado"));
                    ex.setString("exame", codigoExame);
                    ex.setInt("material", codigoMaterial);
                    ex.setString("epa_codigo", epa_codigo);
                    examesExcluir.add(ex);
                    continue;
                }
                this.logger.log(Level.INFO, "Resultado Req.".concat(String.valueOf(codigoRequisicao)).concat(" EXA: ").concat(codigoExame).concat(" MAT.:").concat(String.valueOf(codigoMaterial)));
                PreparedStatement prst = this.conexao.getPreparedStatement(sql);
                prst.setInt(1, apoiado.getCodigoFilial());
                prst.setLong(2, codigoRequisicao);
                prst.setString(3, codigoExame);
                prst.setInt(4, codigoMaterial);
                ResultSet rs = this.conexao.executeQuery(prst);
                if (rs.next()) {
                    this.logger.log(Level.INFO, "C\u00d3DIGO APOIADO = " + rs.getString("req_codigoapoiado"));
                    if (Funcoes.textoVazio(rs.getString("req_codigoapoiado"))) {
                        this.marcaExportado(st2, apoiado, epa_codigo);
                    } else {
                        ex = new ParametroSet();
                        ex.setString("requisicao", rs.getString("req_codigoapoiado"));
                        ex.setLong("requisicaoServidor", rs.getLong("req_codigo"));
                        ex.setString("exame", codigoExame);
                        ex.setInt("material", codigoMaterial);
                        ex.setString("situacao", rs.getString("exr_situacao"));
                        ex.setDate("dataMaterial", rs.getTimestamp("exr_datamaterial"));
                        ex.setDate("dataDigitacao", rs.getTimestamp("exr_datadigita"));
                        ex.setDate("dataAssinatura", rs.getTimestamp("exr_dataassina"));
                        ex.setDate("dataEntregaPrevista", rs.getTimestamp("exr_dataentregaprev"));
                        ex.setString("resposta", rs.getString("exr_resposta"));
                        ex.setInt("metodo", rs.getInt("met_codigo"));
                        ex.setString("usuarioAssinatura", rs.getString("usr_codassina"));
                        ex.setString("materialDescricao", rs.getString("exr_descricaomaterial"));
                        ex.setString("observacao", rs.getString("exr_obs"));
                        ex.setDate("dataCortesia", rs.getDate("exr_datacortesia"));
                        ex.setString("usuarioCortesia", rs.getString("usr_codcortesia"));
                        ex.setDate("data", rs.getTimestamp("exr_data"));
                        ex.setString("tempoJejum", Funcoes.formataData(HH_MM, rs.getTimestamp("exr_intervalojejum")));
                        ex.setString("exameOrigem", rs.getString("exr_codexameorigem"));
                        ex.setInt("materialOrigem", rs.getInt("exr_codmatorigem"));
                        ex.setInt("materialOrigem", rs.getInt("exr_codmatorigem"));
                        ex.setString("epa_codigo", epa_codigo);
                        ex.setBoolean("excluido", rs.getBoolean("exr_excluido"));
                        exames.add(ex);
                    }
                } else {
                    this.marcaExportado(st2, apoiado, epa_codigo);
                }
                prst.close();
            }
            paramRetorno.setListParam("exames", exames);
            paramRetorno.setListParam("examesExcluir", examesExcluir);
            this.conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        finally {
            this.conexao.fecharStatement(st);
            this.conexao.fecharStatement(st2);
        }
        return paramRetorno;
    }

    public String enviarArquivoImportacao(InputStream in) throws Exception {
        List<Registro> requisicoes = null;
        String xmlRetorno = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(in);
            NodeList nodeListRaiz = document.getChildNodes();
            Apoiado apoiado = null;
            HashMap<String, String[]> rejeitados = new HashMap<String, String[]>();
            for (int i = 0; i < nodeListRaiz.getLength(); ++i) {
                Object atributoChave;
                if (!nodeListRaiz.item(i).getNodeName().equals("requisicoes") || !nodeListRaiz.item(i).hasAttributes() || (atributoChave = nodeListRaiz.item(i).getAttributes().getNamedItem("chave")) == null) continue;
                apoiado = new Apoiado(atributoChave.getNodeValue());
                requisicoes = ParserImportacaoJalis.parseRequisicoes(nodeListRaiz.item(i), this.logger, rejeitados);
            }
            if (apoiado != null) {
                List<ParametroSet> listParamPac = ParserImportacaoJalis.getParamPacientes(requisicoes, this.conexao, apoiado.getChave());
                for (ParametroSet paciente : listParamPac) {
                    paciente.setLong("codigoApoio", this.enviarPaciente(paciente).getLong("codigo"));
                }
                ParametroSet paramRequisicoes = this.enviarLote(ParserImportacaoJalis.loteToParam(requisicoes, apoiado, listParamPac, this.conexao), true);
                xmlRetorno = ParserImportacaoJalis.paramToXml(listParamPac, paramRequisicoes, rejeitados);
            } else {
                XMLStringBuilder xml = new XMLStringBuilder();
                xml.escrever("erro", "Chave inv\u00e1lida ou inexistente no arquivo do lote");
                xmlRetorno = xml.getXML();
            }
        }
        catch (SQLException e) {
            String msg = String.format("Erro ao receber arquivo.(SQLException)\n%s\n%s", e.getMessage(), e.getLocalizedMessage(), e.getStackTrace());
            this.logger.log(Level.INFO, msg);
            throw new Exception(msg);
        }
        catch (ParseException e) {
            String msg = String.format("Erro ao receber arquivo.(ParseException)\n%s\n%s", e.getMessage(), e.getLocalizedMessage(), e.getStackTrace());
            this.logger.log(Level.INFO, msg);
            throw new Exception(msg);
        }
        return xmlRetorno;
    }

    public ParametroSet enviarLote(ParametroSet param) throws Exception {
        return this.enviarLote(param, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ParametroSet enviarLote(ParametroSet param, boolean excluida) throws Exception {
        HashMap<String, ArrayList<String>> mapMultiguias = new HashMap<String, ArrayList<String>>();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        String filialString = String.valueOf(apoiado.getCodigoFilial());
        boolean isEnviarEtiquetaApoio = !param.isNull("enviarEtiquetaApoio") ? param.getBoolean("enviarEtiquetaApoio") : false;
        ParametroSet paramRetorno = new ParametroSet();
        ParametroSet paramLote = param.getParametroSet("lote");
        Boolean apoio = param.getBoolean("apoio");
        if (apoio == null) {
            apoio = true;
        }
        Integer codigoLote = paramLote.getInt("codigo");
        java.util.Date dataLote = paramLote.getDate("data");
        String caixa = paramLote.getString("caixa");
        Statement st = this.conexao.getStatement();
        boolean importaMedico = false;
        boolean importaConvApoio = false;
        String destino = "";
        String coleta = "";
        int codigoConvenioApoio = 0;
        this.logger.log(Level.INFO, "iniciando importa\u00e7\u00e3o do lote");
        StringBuilder bui = new StringBuilder();
        try {
            int loteId;
            int codigoConvenio;
            boolean semEtiquetas;
            ResultSet rs;
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                bui.setLength(0);
                bui.append("select con_apoiosemetiqueta, des_codigo, col_codigo, ");
                bui.append("coalesce(con_incluirmedicoapoiado, false) as con_incluirmedicoapoiado,  ");
                bui.append("con_importarconvenioapoio ");
                bui.append("from convenios where fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and con_codigo = ").append(apoiado.getCodigo());
                rs = this.conexao.executeQuery(st, bui.toString());
                if (!rs.next()) throw new Exception("Conv\u00eanio n\u00e3o encontrado");
                semEtiquetas = rs.getBoolean("con_apoiosemetiqueta");
                importaMedico = rs.getBoolean("con_incluirmedicoapoiado");
                importaConvApoio = rs.getBoolean("con_importarconvenioapoio");
                destino = rs.getString("des_codigo");
                coleta = rs.getString("col_codigo");
                codigoConvenio = apoiado.getCodigo();
            } else {
                bui.setLength(0);
                bui.append("select a.con_codigo, a.pac_apoiosemetiqueta, b.des_codigo, b.col_codigo");
                bui.append(" from paciente a");
                bui.append(" left join convenios b on a.fil_codigo = b.fil_codigo and a.con_codigo = b.con_codigo");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.pac_codigo = ").append(apoiado.getCodigo());
                rs = this.conexao.executeQuery(st, bui.toString());
                if (!rs.next()) throw new Exception("Conv\u00eanio n\u00e3o encontrado");
                semEtiquetas = rs.getBoolean("pac_apoiosemetiqueta");
                codigoConvenio = rs.getInt("con_codigo");
            }
            bui.setLength(0);
            bui.append("select lot_id from loteapoio");
            bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
            bui.append(" and lot_codigo = ").append(codigoLote);
            if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                bui.append(" and con_codigo = ").append(apoiado.getCodigo());
            } else {
                bui.append(" and pac_codigo = ").append(apoiado.getCodigo());
            }
            rs = this.conexao.executeQuery(st, bui.toString());
            if (rs.next()) {
                loteId = rs.getInt("lot_id");
            } else {
                loteId = Integer.valueOf(DBUtil.getSequencia(st, "loteapoio", filialString));
                bui.setLength(0);
                bui.append("insert into loteapoio(fil_codigo, lot_id");
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(", con_codigo");
                } else {
                    bui.append(", pac_codigo");
                }
                bui.append(", lot_codigo, lot_datahora").append(caixa != null ? ", lot_caixaapoio)" : ")").append(" values (");
                bui.append(apoiado.getCodigoFilial());
                bui.append(", ").append(loteId);
                bui.append(", ").append(apoiado.getCodigo()).append(", ").append(codigoLote);
                bui.append(", '").append(Funcoes.formataData("yyyy/MM/dd HH:mm:ss", dataLote)).append("'");
                if (caixa != null) {
                    bui.append(", '").append(caixa).append("'");
                }
                bui.append(")");
                this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, bui.toString(), true);
            }
            Calendar c = Calendar.getInstance();
            ArrayList<ParametroSet> paramRetornoRequisicoes = new ArrayList<ParametroSet>();
            for (ParametroSet paramReq : paramLote.getListParam("requisicoes")) {
                int codigoMaterial;
                String codigoExame;
                Long codigoRequisicao = Long.parseLong("0");
                String codigoRequisicaoApoio = paramReq.getString("codigoRequisicao");
                if (codigoRequisicaoApoio == null) {
                    codigoRequisicaoApoio = String.valueOf(paramReq.getLong("codigoRequisicao"));
                }
                String codigoMaeMultiguia = paramReq.getString("codigoMaeMultiguia");
                boolean novaRequisicao = true;
                if (!apoio.booleanValue() && codigoRequisicaoApoio != null) {
                    bui.setLength(0);
                    bui.append("select req_codigo from requisicao where req_codigoapoiado = '").append(codigoRequisicaoApoio).append("' ");
                    bui.append(" and fil_codigo = ").append(filialString);
                    codigoConvenioApoio = 0;
                    if (importaConvApoio && !paramReq.isNull("convenioApoiado")) {
                        codigoConvenioApoio = this.getConvenioApoio(apoiado.getCodigoFilial(), codigoConvenio, paramReq.getInt("convenioApoiado"));
                        bui.append(" and con_codigo = ").append(codigoConvenioApoio);
                    } else {
                        bui.append(" and con_codigo = ").append(codigoConvenio);
                    }
                    bui.append(" and req_excluida = false ");
                    rs = this.conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        codigoRequisicao = rs.getLong("req_codigo");
                        novaRequisicao = false;
                    }
                }
                if (novaRequisicao) {
                    codigoRequisicao = Long.parseLong(DBUtil.getSequencia(st, "requisicao", filialString));
                }
                java.util.Date dataMaxPrevisao = c.getTime();
                double totalRequisicao = 0.0;
                if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    coleta = paramReq.getString("codigoColeta");
                    destino = paramReq.getString("codigoDestino");
                }
                int cont = 0;
                ArrayList<String> insertExames = new ArrayList<String>();
                bui.setLength(0);
                Statement stOrdem = this.conexao.getStatement();
                bui.append("select exr_ordem from examerequisicao a");
                bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                bui.append(" and a.req_codigo = ").append(codigoRequisicao).append(" order by exr_ordem desc limit 1");
                ResultSet rsOrdem = this.conexao.executeQuery(stOrdem, bui.toString());
                if (rsOrdem.next()) {
                    cont = rsOrdem.getInt("exr_ordem") + 1;
                }
                this.conexao.fecharStatement(stOrdem);
                for (ParametroSet paramEx : paramReq.getListParam("exames")) {
                    Statement st1 = this.conexao.getStatement();
                    Statement st2 = this.conexao.getStatement();
                    Statement st3 = this.conexao.getStatement();
                    Statement st4 = this.conexao.getStatement();
                    codigoExame = paramEx.getString(CODIGO_EXAME);
                    codigoMaterial = paramEx.getInt(CODIGO_MATERIAL);
                    String descricaoMaterial = paramEx.getString("descricaoMaterial");
                    DadosConvenios dadosConvenio = ConvenioUtil.getDadosConvenios(filialString, importaConvApoio && codigoConvenioApoio != 0 ? codigoConvenioApoio : codigoConvenio, st1);
                    if (dadosConvenio == null) {
                        throw new Exception("N\u00e3o foi poss\u00edvel recuperar dados do conv\u00eanio " + (importaConvApoio && codigoConvenioApoio != 0 ? codigoConvenioApoio : codigoConvenio));
                    }
                    DadosMaterial dadosMaterial = ExameUtil.getDadosMaterial(filialString, codigoMaterial, st1);
                    if (dadosMaterial == null) {
                        throw new Exception("N\u00e3o foi poss\u00edvel recuperar dados do material " + codigoMaterial);
                    }
                    DadosExames dadosExame = ExameUtil.getDadosExame(filialString, codigoExame, dadosMaterial, st1);
                    if (dadosExame == null) {
                        String msg = "N\u00e3o foi poss\u00edvel recuperar dados do exame " + codigoExame + " com o material " + codigoMaterial;
                        throw new Exception(msg);
                    }
                    ExameUtil.calculaPrecoExame(filialString, dadosExame, dadosMaterial, dadosConvenio, false, false, false, codigoRequisicao.intValue(), null, Integer.parseInt(dadosExame.getCodMetodo()));
                    java.util.Date dataPrevisao = ExameUtil.calculaDataEntrega(filialString, dadosExame.getCodPrazo(), codigoExame, String.valueOf(codigoMaterial), String.valueOf(importaConvApoio && codigoConvenioApoio != 0 ? codigoConvenioApoio : codigoConvenio), st3);
                    if (dataPrevisao != null && dataPrevisao.after(dataMaxPrevisao)) {
                        dataMaxPrevisao = dataPrevisao;
                    }
                    totalRequisicao += dadosExame.getValorExame().doubleValue();
                    bui.setLength(0);
                    bui.append("select b.req_codigoapoiado from examerequisicao a");
                    bui.append(" join requisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
                    bui.append(" where a.fil_codigo = ").append(apoiado.getCodigoFilial());
                    bui.append(" and a.req_codigo = ").append(codigoRequisicao);
                    bui.append(" and a.exa_codigo = '").append(codigoExame).append("' ");
                    bui.append(" and a.mco_codigo = ").append(codigoMaterial);
                    ResultSet rsEx = this.conexao.executeQuery(st4, bui.toString());
                    if (rsEx.next()) {
                        bui.setLength(0);
                        bui.append("Exame j\u00e1 inclu\u00eddo na requisi\u00e7\u00e3o: Fil.").append(apoiado.getCodigoFilial()).append(" Req. ").append(codigoRequisicao);
                        bui.append(" Req. apoiado ").append(codigoRequisicaoApoio).append(" Exa.").append(codigoExame).append(" Mat. ").append(codigoMaterial);
                        this.logger.log(Level.INFO, bui.toString());
                    } else {
                        bui.setLength(0);
                        bui.append("insert into examerequisicao (fil_codigo, req_codigo, exr_situacao, exr_vlrexame, exr_vlrchexame, ");
                        bui.append("exr_dataentregaprev, exr_vlrch, met_codigo, exa_codigo, mco_codigo, usr_codigo, exr_vlrmaterial, ");
                        bui.append("exr_data, exr_autorizar, exr_naofaturar, exr_ordem, ");
                        bui.append("exr_descricaomaterial, exr_excluido, exr_matexterno, ");
                        bui.append("exr_resposta, exr_volumediurese, exr_tempodiurese, exr_obs, exr_intervalojejum, exr_urgente, ");
                        bui.append("exr_codexameorigem, exr_codmatorigem, ");
                        bui.append("exr_guia, exr_deveguia, exr_dataguia, exr_validadeguia, exr_dataautorizacao, exr_datavalidadeautorizacao, exr_codAutorizacao, ");
                        bui.append("exr_custosimples ");
                        boolean exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
                        if (exr_codigoapoiado) {
                            bui.append(", exr_codigoapoiado");
                        }
                        bui.append(" ) values (");
                        bui.append(apoiado.getCodigoFilial()).append(", ");
                        bui.append(codigoRequisicao).append(", ");
                        bui.append("'").append("F").append("', ");
                        bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorExame()))).append(", ");
                        bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorCH()))).append(", ");
                        if (dataPrevisao != null) {
                            bui.append("'").append(Funcoes.formataData("yyyy-MM-dd HH:mm:ss", dataPrevisao)).append("', ");
                        } else {
                            bui.append("null, ");
                        }
                        bui.append(Funcoes.limpaDecimal(String.valueOf(dadosConvenio.getCH()))).append(", ");
                        bui.append(dadosExame.getCodMetodo()).append(", ");
                        bui.append("'").append(codigoExame).append("', ");
                        bui.append(codigoMaterial).append(", ");
                        bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                        bui.append(Funcoes.limpaDecimal(String.valueOf(dadosExame.getValorMaterial()))).append(", ");
                        bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, paramReq.getDate("data"))).append(" ").append(paramReq.getString("hora")).append("', ");
                        bui.append("false, ");
                        bui.append("false, ");
                        bui.append(cont).append(", ");
                        bui.append(Funcoes.textoVazio(descricaoMaterial) ? "null" : "'" + descricaoMaterial + "'");
                        bui.append(", ").append(excluida);
                        bui.append(", ").append(Boolean.parseBoolean(ParametrosLocais.getParametro("marcaMaterialApoioComoExterno")) && this.getConvenioUtilizaMaterialApoioComoExterno(codigoConvenio));
                        bui.append(", '").append(paramEx.getString("resposta")).append("'");
                        bui.append(", ").append(paramEx.getFloat("volumeDiurese"));
                        if (Funcoes.textoVazio(paramEx.getString("tempoDiurese"))) {
                            bui.append(", null");
                        } else {
                            bui.append(", '").append(paramEx.getString("tempoDiurese")).append("'");
                        }
                        if (Funcoes.textoVazio(paramEx.getString("obs"))) {
                            bui.append(", null");
                        } else {
                            bui.append(", '").append(StringUtil.textoDB(paramEx.getString("obs"))).append("'");
                        }
                        if (Funcoes.textoVazio(paramEx.getString("tempoJejum"))) {
                            bui.append(", null");
                        } else {
                            bui.append(", '").append(paramEx.getString("tempoJejum")).append("'");
                        }
                        bui.append(",false");
                        if (Funcoes.textoVazio(paramEx.getString("codexameorigem"))) {
                            bui.append(", null");
                        } else {
                            bui.append(", '").append(paramEx.getString("codexameorigem")).append("'");
                        }
                        if (paramEx.getInt("codmatorigem") == null) {
                            bui.append(", null ");
                        } else {
                            bui.append(", ").append(paramEx.getInt("codmatorigem"));
                        }
                        if (paramEx.getString("guia") != null) {
                            bui.append(", '").append(paramEx.getString("guia")).append("' ");
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getBoolean("deveGuia") != null) {
                            bui.append(", ").append(paramEx.getBoolean("deveGuia"));
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getDate("dataGuia") != null) {
                            bui.append(", '").append(Funcoes.formataData(MM_DD_YYYY, paramEx.getDate("dataGuia"))).append("'");
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getDate("validadeGuia") != null) {
                            bui.append(", '").append(Funcoes.formataData(MM_DD_YYYY, paramEx.getDate("validadeGuia"))).append("'");
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getDate("dataAutorizacao") != null) {
                            bui.append(", '").append(Funcoes.formataData(MM_DD_YYYY, paramEx.getDate("dataAutorizacao"))).append("'");
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getDate("dataValidadeAutorizacao") != null) {
                            bui.append(", '").append(Funcoes.formataData(MM_DD_YYYY, paramEx.getDate("dataValidadeAutorizacao"))).append("'");
                        } else {
                            bui.append(", null");
                        }
                        if (paramEx.getString("codigoAutorizacao") != null) {
                            bui.append(", '").append(paramEx.getString("codigoAutorizacao")).append("' ");
                        } else {
                            bui.append(", null");
                        }
                        bui.append(",").append(this.requisicaoService.valorExameCustoSimples(codigoExame, codigoMaterial, apoiado.getCodigoFilial()));
                        if (paramEx.getString(CODIGO_APOIADO) != null && exr_codigoapoiado) {
                            bui.append(", '").append(paramEx.getString(CODIGO_APOIADO)).append("' ");
                        } else if (exr_codigoapoiado) {
                            bui.append(", null");
                        }
                        bui.append(")");
                        insertExames.add(bui.toString());
                        bui.setLength(0);
                        bui.append("insert into examerequisicaosituacoes (fil_codigo, req_codigo, exa_codigo, mco_codigo, usr_codigo");
                        bui.append(", ers_situacao, ers_datahora) values (");
                        bui.append(apoiado.getCodigoFilial());
                        bui.append(", ").append(codigoRequisicao);
                        bui.append(", '").append(codigoExame).append("'");
                        bui.append(", ").append(codigoMaterial);
                        bui.append(", '").append(StringUtil.textoDB(ParametrosLocais.getParametro("usuarioPadraoRMI"))).append("'");
                        bui.append(", '").append("F").append("'");
                        bui.append(", '").append(Funcoes.formataData("MM/dd/yyyy HH:mm:ss", new java.util.Date())).append("'");
                        bui.append(")");
                        insertExames.add(bui.toString());
                    }
                    ++cont;
                    this.conexao.fecharStatement(st1);
                    this.conexao.fecharStatement(st2);
                    this.conexao.fecharStatement(st3);
                    this.conexao.fecharStatement(st4);
                }
                bui.setLength(0);
                bui.append("insert into requisicao (fil_codigo, req_codigo, col_codigo, des_codigo, con_codigo, med_uf, med_conselho, ");
                bui.append("med_crm, pac_codigo, req_data, req_dtfatura, req_dataentregaprev, req_total, req_totpago, ");
                bui.append("req_horaentregaprev, req_horafatura, req_hora, req_anomes, req_idade, req_senhaweb, usr_codigo, ");
                bui.append("est_codigo, req_vlracrescimo, req_acrescimo, req_vlrdesconto, req_desconto,  req_telacoleta, ");
                bui.append("req_datarequisicao, req_vlrmateriais, req_vlrexames, usr_codabertura, req_codigoapoiado, req_excluida, ");
                bui.append("req_dclinicos, req_obs");
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(", req_gestante, req_dum, req_dumnaoinformado, req_neonato, req_altura, req_peso, ");
                    bui.append("req_guia, req_deveguia, req_matricula, req_validadeguia, sit_codigo");
                } else if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    bui.append(", req_urgente, ent_codigo, req_descricaoproduto, req_numeroregistroproduto");
                    bui.append(", req_numeroloteproduto, req_marcaproduto, req_lacreproduto, req_lacreprodutocontra");
                    bui.append(", req_lacreprodutocontraempresa, req_doctoreferenciaproduto, req_sanitariasproduto");
                    bui.append(", req_condicoesambproduto, req_procedimentocoletaproduto, req_tiporecebimentoproduto");
                    bui.append(", req_qtdeamostraproduto, req_qtdeunidadeproduto, unm_codigo, req_partidaproduto");
                    bui.append(", req_localcoletaproduto, req_nrsolicitacaoproduto, req_datavalidade, req_anoprpproduto");
                    bui.append(", req_cicloprpproduto, req_amostraprpproduto, req_amostrasupprpproduto");
                    bui.append(", req_horainicioturnoprpproduto, req_turnoprpproduto, req_linhaprpproduto");
                    bui.append(", req_volumeabateprpproduto, req_areaproduto, emb_codigo, req_datafabricacao");
                    bui.append(", req_temperaturacoletaproduto, req_temperaturarecebimento, req_horarecebimentoproduto");
                    bui.append(", req_horacoletaproduto, req_datacoletaproduto, req_datarecebimentoproduto");
                }
                bui.append(") values (");
                bui.append(apoiado.getCodigoFilial()).append(",");
                bui.append(codigoRequisicao).append(",");
                bui.append("'").append(coleta).append("',");
                bui.append("'").append(destino).append("',");
                if (importaConvApoio && codigoConvenioApoio != 0) {
                    bui.append(this.getConvenioApoio(apoiado.getCodigoFilial(), codigoConvenio, paramReq.getInt("convenioApoiado"))).append(",");
                } else {
                    bui.append(codigoConvenio).append(",");
                }
                StringBuilder obsMed = null;
                if (importaMedico && this.verificaMedico(apoiado.getCodigoFilial(), paramReq.getString("medicoConselho"), paramReq.getString("medicoCrm"), paramReq.getString("medicoUf"))) {
                    bui.append("'").append(paramReq.getString("medicoUf")).append("', ");
                    bui.append("'").append(paramReq.getString("medicoConselho")).append("', ");
                    bui.append("'").append(paramReq.getString("medicoCrm")).append("', ");
                } else {
                    if (!(!importaMedico || paramReq.isNull("medicoConselho") || paramReq.isNull("medicoCrm") || paramReq.isNull("medicoUf") || paramReq.isNull("medicoNome"))) {
                        obsMed = new StringBuilder("Dados do M\u00e9dico: ");
                        obsMed.append(paramReq.getString("medicoConselho")).append(" - ");
                        obsMed.append(paramReq.getString("medicoCrm")).append(" - ");
                        obsMed.append(paramReq.getString("medicoUf")).append(" - ");
                        obsMed.append(paramReq.getString("medicoNome"));
                    }
                    bui.append("'").append(ParametrosLocais.getParametro("medicoUFPadraoRMI")).append("', ");
                    bui.append("'").append(ParametrosLocais.getParametro("medicoConselhoPadraoRMI")).append("', ");
                    bui.append("'").append(ParametrosLocais.getParametro("medicoCrmPadraoRMI")).append("', ");
                }
                if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    bui.append(apoiado.getCodigo()).append(", ");
                } else {
                    bui.append(paramReq.getLong("codigoPacienteServidor")).append(", ");
                }
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, paramReq.getDate("data"))).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, dataMaxPrevisao)).append("', ");
                bui.append(Funcoes.limpaDecimal(String.valueOf(totalRequisicao))).append(", ");
                bui.append("0, ");
                bui.append("'").append(Funcoes.formataData("HH:mm:ss", dataMaxPrevisao)).append("', ");
                bui.append("'").append(Funcoes.formataData("HH:mm:ss", c.getTime())).append("', ");
                bui.append("'").append(paramReq.getString("hora")).append("', ");
                if (paramReq.getString("tipoIdade") != null) {
                    bui.append("'").append(paramReq.getString("tipoIdade")).append("', ");
                } else {
                    bui.append("'A', ");
                }
                bui.append(paramReq.getInt("idade")).append(", ");
                bui.append("'").append(Funcoes.gerarSenhaWeb()).append("', ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append(ParametrosLocais.getParametro("estacaoPadraoRMI")).append(", ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append(excluida ? "false," : "true, ");
                bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, c.getTime())).append("', ");
                bui.append("0, ");
                bui.append("0, ");
                bui.append("'").append(ParametrosLocais.getParametro("usuarioPadraoRMI")).append("', ");
                bui.append("'").append(StringUtil.textoDB(codigoRequisicaoApoio)).append("',");
                bui.append(excluida).append(", ");
                if (!paramReq.isNull("dadosClinicos")) {
                    bui.append("'").append(StringUtil.textoDB(StringUtil.converteHtmlParaAcentos(paramReq.getString("dadosClinicos"), true))).append("', ");
                } else {
                    bui.append("null, ");
                }
                if (!paramReq.isNull("obs") || obsMed != null) {
                    if (obsMed == null) {
                        obsMed = new StringBuilder(StringUtil.converteHtmlParaAcentos(paramReq.getString("obs"), true));
                    } else if (!paramReq.isNull("obs")) {
                        obsMed.append("\n").append(StringUtil.converteHtmlParaAcentos(paramReq.getString("obs"), true));
                    }
                    bui.append("'").append(StringUtil.textoDB(obsMed.toString())).append("', ");
                } else {
                    bui.append("null, ");
                }
                if (apoiado.getTipoFilial().equalsIgnoreCase("C") || apoiado.getTipoFilial().equalsIgnoreCase("V")) {
                    bui.append(paramReq.getBoolean("gestante")).append(", ");
                    if (paramReq.getDate("dum") != null) {
                        bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, paramReq.getDate("dum"))).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    bui.append(paramReq.getBoolean("dumNaoInformado") != false ? TRUE : FALSE).append(", ");
                    bui.append(paramReq.getBoolean("neonato")).append(", ");
                    if (paramReq.isNull("altura")) {
                        bui.append("null, ");
                    } else {
                        bui.append(paramReq.getFloat("altura")).append(", ");
                    }
                    if (paramReq.isNull("peso")) {
                        bui.append("null").append(", ");
                    } else {
                        bui.append(paramReq.getFloat("peso")).append(", ");
                    }
                    (paramReq.isNull("guia") ? bui.append("null") : bui.append("'").append(paramReq.getString("guia")).append("'")).append(", ");
                    bui.append(paramReq.isNull("deveGuia") ? "null" : paramReq.getBoolean("deveGuia")).append(", ");
                    (paramReq.isNull("matricula") ? bui.append("null") : bui.append("'").append(paramReq.getString("matricula")).append("'")).append(", ");
                    bui.append(paramReq.isNull("validade") ? "null" : paramReq.getDate("validade")).append(", ");
                    bui.append(paramReq.isNull("situacao") || Funcoes.textoVazio(paramReq.getString("situacao")) || paramReq.getInt("situacao") == 0 ? "null" : paramReq.getInt("situacao")).append(" ");
                } else if (apoiado.getTipoFilial().equalsIgnoreCase("A")) {
                    bui.append(paramReq.getBoolean("urgente") != false ? TRUE : FALSE).append(", ");
                    bui.append(paramReq.getInt("codigoResponsavel")).append(", ");
                    ParametroSet paramPrd = paramReq.getParametroSet("produto");
                    bui.append("'").append(paramPrd.getString("descricao")).append("', ");
                    bui.append("'").append(paramPrd.getString("registro")).append("', ");
                    bui.append("'").append(paramPrd.getString("lote")).append("', ");
                    bui.append("'").append(paramPrd.getString("marca")).append("', ");
                    bui.append("'").append(paramPrd.getString("lacre")).append("', ");
                    bui.append("'").append(paramPrd.getString("lacreContraprova")).append("', ");
                    bui.append("'").append(paramPrd.getString("lacreContraprovaEmpresa")).append("', ");
                    bui.append("'").append(paramPrd.getString("documento")).append("', ");
                    bui.append("'").append(paramPrd.getString("sanitarias")).append("', ");
                    bui.append("'").append(paramPrd.getString("condicoes")).append("', ");
                    bui.append("'").append(paramPrd.getString("procedimento")).append("', ");
                    bui.append("'").append(paramPrd.getString("tipoRecebimento")).append("', ");
                    bui.append(paramPrd.getInt("qtAmostras")).append(", ");
                    bui.append(paramPrd.getDouble("qtUnidade")).append(", ");
                    if (!Funcoes.textoVazio(paramPrd.getString("codigoUnidade"))) {
                        bui.append("'").append(paramPrd.getString("codigoUnidade")).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    bui.append("'").append(paramPrd.getString("partida")).append("', ");
                    bui.append("'").append(paramPrd.getString("localColeta")).append("', ");
                    bui.append("'").append(paramPrd.getString("solicitacao")).append("', ");
                    bui.append("'").append(paramPrd.getString("dataValidade")).append("', ");
                    if (paramPrd.getInt("anoPRP") > 0) {
                        bui.append(paramPrd.getInt("anoPRP")).append(", ");
                    } else {
                        bui.append("null, ");
                    }
                    bui.append("'").append(paramPrd.getString("cicloPRP")).append("', ");
                    bui.append("'").append(paramPrd.getString("amostraPRP")).append("', ");
                    bui.append("'").append(paramPrd.getString("amostraSupervisaoPRP")).append("', ");
                    if (!Funcoes.textoVazio(paramPrd.getString("horaTurnoPRP"))) {
                        bui.append("'").append(paramPrd.getString("horaTurnoPRP")).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    bui.append("'").append(paramPrd.getString("turnoPRP")).append("', ");
                    bui.append("'").append(paramPrd.getString("linhaPRP")).append("', ");
                    bui.append("'").append(paramPrd.getString("volumeAbatePRP")).append("', ");
                    bui.append("'").append(paramPrd.getString("area")).append("', ");
                    if (paramPrd.getInt("codigoEmbalagem") > 0) {
                        bui.append(paramPrd.getInt("codigoEmbalagem")).append(", ");
                    } else {
                        bui.append("null, ");
                    }
                    bui.append("'").append(paramPrd.getString("dataFabricacao")).append("', ");
                    bui.append("'").append(paramPrd.getString("temperaturaColeta")).append("', ");
                    bui.append("'").append(paramPrd.getString("temperaturaRecebimento")).append("', ");
                    if (!Funcoes.textoVazio(paramPrd.getString("horaRecebimento"))) {
                        bui.append("'").append(paramPrd.getString("horaRecebimento")).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    if (!Funcoes.textoVazio(paramPrd.getString("horaColeta"))) {
                        bui.append("'").append(paramPrd.getString("horaColeta")).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    if (paramPrd.getDate("dataColeta") != null) {
                        bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, paramPrd.getDate("dataColeta"))).append("', ");
                    } else {
                        bui.append("null, ");
                    }
                    if (paramPrd.getDate("dataRecebimento") != null) {
                        bui.append("'").append(Funcoes.formataData(MM_DD_YYYY, paramPrd.getDate("dataRecebimento"))).append("'");
                    } else {
                        bui.append("null");
                    }
                }
                bui.append(")");
                if (apoio.booleanValue() || novaRequisicao) {
                    this.logger.log(Level.INFO, bui.toString());
                    this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, bui.toString(), true);
                    if (!Funcoes.textoVazio(codigoMaeMultiguia)) {
                        if (mapMultiguias.containsKey(codigoMaeMultiguia)) {
                            if (!mapMultiguias.get(codigoMaeMultiguia).contains(String.valueOf(codigoRequisicao))) {
                                mapMultiguias.get(codigoMaeMultiguia).add(String.valueOf(codigoRequisicao));
                            }
                        } else {
                            ArrayList<String> req = new ArrayList<String>();
                            req.add(String.valueOf(codigoRequisicao));
                            mapMultiguias.put(codigoMaeMultiguia, req);
                        }
                    }
                }
                bui.setLength(0);
                bui.append("insert into loteapoiorequisicao(fil_codigo, lot_id, req_codigo");
                bui.append(") values (");
                bui.append(apoiado.getCodigoFilial());
                bui.append(", ").append(loteId);
                bui.append(", ").append(codigoRequisicao);
                bui.append(")");
                this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, bui.toString(), true);
                for (String s : insertExames) {
                    this.logger.log(Level.INFO, s);
                    this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, s, true);
                }
                if (!novaRequisicao) {
                    bui.delete(0, bui.length());
                    bui.append("select sum(exr_vlrexame) as soma from examerequisicao ");
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    bui.append(" and req_codigo = ").append(codigoRequisicao);
                    this.logger.log(Level.INFO, bui.toString());
                    rs = this.conexao.executeQuery(st, bui.toString());
                    double valor = 0.0;
                    if (rs.next()) {
                        valor = rs.getDouble("soma");
                    }
                    rs.close();
                    bui.delete(0, bui.length());
                    bui.append("update requisicao set req_total = ").append(Funcoes.limpaDecimal(String.valueOf(valor)));
                    bui.append(" where fil_codigo = ").append(apoiado.getCodigoFilial());
                    bui.append(" and req_codigo = ").append(codigoRequisicao);
                    this.logger.log(Level.INFO, bui.toString());
                    this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, bui.toString(), true);
                }
                Statement stRemedios = this.conexao.getStatement();
                ArrayList<String> listaExamesEtiqueta = new ArrayList<String>();
                int[] materiaisArray = new int[paramReq.getListParam("exames").size()];
                for (ParametroSet paramEx : paramReq.getListParam("exames")) {
                    codigoExame = paramEx.getString(CODIGO_EXAME);
                    codigoMaterial = paramEx.getInt(CODIGO_MATERIAL);
                    ExportaFiliais.gravaRequisicao(apoiado.getCodigoFilial(), codigoRequisicao, codigoExame, codigoMaterial, "I", "I", st, stRemedios);
                    listaExamesEtiqueta.add(codigoExame);
                    materiaisArray[listaExamesEtiqueta.size() - 1] = codigoMaterial;
                }
                stRemedios.close();
                Statement st1 = this.conexao.getStatement();
                Statement st2 = this.conexao.getStatement();
                Statement st3 = this.conexao.getStatement();
                if (paramReq.getListParam("medicamentos") != null) {
                    for (ParametroSet paramMed : paramReq.getListParam("medicamentos")) {
                        bui.setLength(0);
                        bui.append("insert into requisicaomedicamento(");
                        bui.append("fil_codigo, req_codigo, mto_codigo, rem_dosagem, rem_datadose, rem_horadose");
                        bui.append(") values (");
                        bui.append(apoiado.getCodigoFilial());
                        bui.append(", ").append(codigoRequisicao);
                        bui.append(", ").append(paramMed.getInt("codigoMedicamento"));
                        bui.append(", '").append(paramMed.getString("dosagem")).append("'");
                        if (paramMed.getDate("dataDosagem") != null) {
                            bui.append(", '").append(Funcoes.formataData(MM_DD_YYYY, paramMed.getDate("dataDosagem"))).append("'");
                        } else {
                            bui.append(", null");
                        }
                        if (Funcoes.verificaHora(paramMed.getString("horaDosagem"))) {
                            bui.append(", '").append(paramMed.getString("horaDosagem")).append("'");
                        } else {
                            bui.append(", null");
                        }
                        bui.append(")");
                        this.conexao.executeUpdate(String.valueOf(apoiado.getCodigoFilial()), st, bui.toString(), true);
                    }
                }
                this.logger.log(Level.INFO, "Exportando Web");
                Util.exportaWebRequisicao(filialString, String.valueOf(codigoRequisicao), st1, st2, true);
                ParametroSet paramRetornoReq = new ParametroSet();
                paramRetornoReq.setLong("codigo", Long.parseLong(codigoRequisicaoApoio));
                paramRetornoReq.setLong("codigoServidor", codigoRequisicao);
                this.logger.log(Level.INFO, "Obtendo etiquetas");
                String[] examesArray = !listaExamesEtiqueta.isEmpty() ? StringUtil.implode(listaExamesEtiqueta, ",").split(",") : null;
                DadosImpressao dados = new DadosImpressao();
                dados.setFilial(filialString);
                dados.setRequisicao(String.valueOf(codigoRequisicao));
                dados.setExames(examesArray);
                dados.setMateriais(materiaisArray);
                dados.setStatament1(st1);
                dados.setStatament2(st2);
                dados.setStatament3(st3);
                dados.setAtualizarCodigoApoiado(!semEtiquetas);
                dados.setListExames(paramReq.getListParam("exames"));
                dados.setEnviarEtiquetaCodigoApoio(isEnviarEtiquetaApoio);
                dados.setGerarInterface(this.gerarInterface);
                String etiquetas = Impressao.getEtiquetaColetaApoio(dados);
                if (!semEtiquetas) {
                    etiquetas = StringUtil.parseEtiqueta(etiquetas);
                    paramRetornoReq.setString("etiqueta", etiquetas);
                }
                this.logger.log(Level.INFO, "semEtiquetas = " + semEtiquetas);
                paramRetornoRequisicoes.add(paramRetornoReq);
                this.conexao.fecharStatement(st1);
                this.conexao.fecharStatement(st2);
                this.conexao.fecharStatement(st3);
            }
            this.relacionaMultiguia(this.conexao.getStatement(), mapMultiguias, filialString);
            this.logger.log(Level.INFO, "importado lote:" + loteId);
            paramRetorno.setListParam("requisicoes", paramRetornoRequisicoes);
            paramRetorno.setInt("lote", loteId);
            this.conexao.arquivaSQL();
            return paramRetorno;
        }
        catch (Exception ex) {
            try {
                this.conexao.anulaSQL();
                this.logger.log(Level.INFO, "Sql Anulado", ex);
                throw ex;
            }
            catch (Exception e) {
                this.logger.log(Level.INFO, "Erro ao anular Sql.");
            }
            throw ex;
        }
        finally {
            this.conexao.fecharStatement(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void relacionaMultiguia(Statement st, Map<String, ArrayList<String>> mapMultiguias, String filial) throws SQLException {
        StringBuilder buf = new StringBuilder();
        if (mapMultiguias != null && !mapMultiguias.isEmpty()) {
            for (String key : mapMultiguias.keySet()) {
                ArrayList<String> filhas = mapMultiguias.get(key);
                if (filhas != null) {
                    Collections.sort(filhas);
                }
                if (filhas == null || filhas.isEmpty()) continue;
                String reqMae = null;
                String reqFilha = null;
                for (int i = 0; i < filhas.size(); ++i) {
                    if (i == 0) {
                        reqMae = filhas.get(i);
                    } else {
                        reqFilha = filhas.get(i);
                    }
                    if (Funcoes.textoVazio(reqFilha) || reqMae.equalsIgnoreCase(reqFilha)) continue;
                    buf.delete(0, buf.length());
                    buf.append("select req_codigo from requisicaorequisicao where fil_codigo = ").append(filial);
                    buf.append(" and req_codigo = ").append(reqMae);
                    buf.append(" and req_kodigo = ").append(reqFilha);
                    try (ResultSet rs = null;){
                        rs = st.executeQuery(buf.toString());
                        if (rs.next()) continue;
                        buf.delete(0, buf.length());
                        buf.append("insert into requisicaorequisicao (fil_codigo, req_codigo, req_kodigo) values (").append(filial);
                        buf.append(",");
                        buf.append(reqMae);
                        buf.append(",");
                        buf.append(reqFilha);
                        buf.append(")");
                        st.execute(buf.toString());
                        continue;
                    }
                }
            }
        }
    }

    private boolean getConvenioUtilizaMaterialApoioComoExterno(int codigoConvenio) {
        String conveniosIgnorar = ParametrosLocais.getParametro("codigoConveniosIgnorarExterno");
        if (conveniosIgnorar != null) {
            String[] convenios;
            for (String s : convenios = conveniosIgnorar.split(",")) {
                if (!Funcoes.isNumeric(s.trim()) || Integer.parseInt(s.trim()) != codigoConvenio) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getEspecies(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> especies = new ArrayList<ParametroSet>();
        if (apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                String sql = "select epc_codigo, epc_descricao, epc_cientifico from especie  where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet especie = new ParametroSet();
                    especie.setInt("codigo", rs.getInt("epc_codigo"));
                    especie.setString("descricao", rs.getString("epc_descricao"));
                    especie.setString("cientifico", rs.getString("epc_cientifico"));
                    especies.add(especie);
                }
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        paramRetorno.setListParam("especies", especies);
        return paramRetorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParametroSet getRacas(ParametroSet param) throws Exception {
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        ParametroSet paramRetorno = new ParametroSet();
        ArrayList<ParametroSet> racas = new ArrayList<ParametroSet>();
        if (apoiado.getTipoFilial().equalsIgnoreCase("V")) {
            Statement st = this.conexao.getStatement();
            Statement st2 = this.conexao.getStatement();
            try {
                String sql = "select epc_codigo, rac_codigo, rac_descricao, rac_cientifico from raca  where fil_codigo = " + apoiado.getCodigoFilial();
                ResultSet rs = this.conexao.executeQuery(st, sql);
                while (rs.next()) {
                    ParametroSet raca = new ParametroSet();
                    raca.setInt("especie", rs.getInt("epc_codigo"));
                    raca.setInt("codigo", rs.getInt("rac_codigo"));
                    raca.setString("descricao", rs.getString("rac_descricao"));
                    raca.setString("cientifico", rs.getString("rac_cientifico"));
                    racas.add(raca);
                }
            }
            finally {
                this.conexao.fecharStatement(st);
                this.conexao.fecharStatement(st2);
            }
        }
        paramRetorno.setListParam("racas", racas);
        return paramRetorno;
    }

    public ParametroSet validaCliente(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        String codigoFilial = param.getString("codigoFilial");
        String codigoCliente = param.getString("codigoCliente");
        if (Funcoes.textoVazio(codigoFilial)) {
            paramRetorno.setBoolean("ok", false);
            return paramRetorno;
        }
        if (!Funcoes.isNumeric(codigoCliente) || Long.parseLong(codigoCliente) != ParametrosGerais.getCodigoCliente()) {
            paramRetorno.setBoolean("ok", false);
            return paramRetorno;
        }
        Statement st = this.conexao.getStatement();
        StringBuilder bui = new StringBuilder("select fil_codigo from filiais_postocoleta where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and fil_apoio = true");
        ResultSet rs = this.conexao.executeQuery(st, bui.toString());
        paramRetorno.setBoolean("ok", rs.next() && !DBUtil.campoNull(rs.getString("fil_codigo")));
        this.conexao.fecharStatement(st);
        return paramRetorno;
    }

    public ParametroSet validaConvenio(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        String codigoFilial = param.getString("codigoFilial");
        String codigoConvenio = param.getString("codigoConvenio");
        if (codigoFilial == null || codigoConvenio == null) {
            paramRetorno.setBoolean("ok", false);
            return paramRetorno;
        }
        Statement st = this.conexao.getStatement();
        StringBuilder bui = new StringBuilder("select con_codigo from convenios where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        bui.append(" and con_labapoio = true ");
        ResultSet rs = this.conexao.executeQuery(st, bui.toString());
        paramRetorno.setBoolean("ok", rs.next());
        this.conexao.fecharStatement(st);
        return paramRetorno;
    }

    public ParametroSet getListaExamesImportar(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        Apoiado apoiado = new Apoiado(param.getString("chave"));
        int codigoFilial = apoiado.getCodigoFilial();
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        StringBuilder retorno = new StringBuilder("<listagemexames>");
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> exames = new ArrayList<String>();
        ArrayList<String> paraExcluir = new ArrayList<String>();
        if (primeiraConexao) {
            buf.append("select a.exa_codigo, count(c.exa_codigo) as total ");
            buf.append("from exames a ");
            buf.append("left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            buf.append(" group by a.exa_codigo ");
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                buf.setLength(0);
                buf.append("select a.exa_codigo, count(b.exa_codigo) as proibidos ");
                buf.append("from exames a ");
                buf.append("left join examematcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and b.emc_proibidoapoio = true ");
                buf.append("where a.fil_codigo = ");
                buf.append(codigoFilial);
                buf.append(" and a.exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("' ");
                buf.append(" group by a.exa_codigo ");
                ResultSet rs2 = this.conexao.executeQuery(st2, buf);
                int proibidos = 0;
                if (rs2.next()) {
                    proibidos = rs2.getInt("proibidos");
                }
                rs2.close();
                if (proibidos == rs.getInt("total")) {
                    paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), ""));
                    continue;
                }
                if (proibidos == rs.getInt("total")) continue;
                if (proibidos > 0) {
                    buf.delete(0, buf.length());
                    buf.append("select exa_codigo, mco_codigo from examematcoleta where fil_codigo = ");
                    buf.append(codigoFilial);
                    buf.append(" and exa_codigo = '").append(StringUtil.textoDB(rs.getString("exa_codigo"))).append("'");
                    buf.append(" and emc_proibidoapoio = true ");
                    ResultSet rsTemp = this.conexao.executeQuery(st2, buf);
                    while (rsTemp.next()) {
                        paraExcluir.add(this.geraTagExclusao(rs.getString("exa_codigo"), rsTemp.getString("mco_codigo")));
                    }
                }
                exames.add(rs.getString("exa_codigo"));
            }
        } else {
            try {
                buf.append(this.getOperacao(st, st2, apoiado, "exames", false));
                String[] lista = StringUtil.getValores(buf.toString(), "exame");
                for (String s : lista) {
                    buf.delete(0, buf.length());
                    String temp = StringUtil.getValor(s, "codigo");
                    String operacao = StringUtil.getValor(s, "operacao");
                    String material = StringUtil.getValor(s, "material");
                    if (Funcoes.textoVazio(temp)) continue;
                    if (!Funcoes.textoVazio(operacao)) {
                        paraExcluir.add(this.geraTagExclusao(temp, material));
                        continue;
                    }
                    exames.add(temp);
                }
                this.conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    this.conexao.anulaSQL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ex.printStackTrace();
                exames.clear();
            }
        }
        for (String s : exames) {
            retorno.append(StringUtil.getTag("exame", s));
        }
        if (!paraExcluir.isEmpty()) {
            retorno.append("<examesexcluir>");
            for (String s : paraExcluir) {
                retorno.append(s);
            }
            retorno.append("</examesexcluir>");
        }
        this.conexao.fecharStatement(st);
        this.conexao.fecharStatement(st2);
        retorno.append("</listagemexames>");
        paramRetorno.setString("listaExamesImportar", retorno.toString());
        return paramRetorno;
    }

    private String geraTagExclusao(String exame, String material) {
        StringBuilder buf = new StringBuilder();
        buf.append("<excluir>");
        buf.append("<codigo>").append(exame).append("</codigo>");
        if (!Funcoes.textoVazio(material)) {
            buf.append("<material>").append(material).append("</material>");
        }
        buf.append("</excluir>");
        return buf.toString();
    }

    public ParametroSet getMaiorCodigoLote(ParametroSet param) throws Exception {
        ParametroSet paramRetorno = new ParametroSet();
        String codigoFilial = param.getString("codigoFilial");
        String codigoConvenio = param.getString("codigoConvenio");
        Statement st = this.conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select max(lot_codigo) as maximo from loteapoio where fil_codigo = ");
        bui.append(codigoFilial);
        bui.append(" and con_codigo = ");
        bui.append(codigoConvenio);
        ResultSet rs = this.conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            paramRetorno.setInt("maiorcodigo", rs.getInt("maximo"));
        } else {
            paramRetorno.setInt("maiorcodigo", 0);
        }
        this.conexao.fecharStatement(st);
        return paramRetorno;
    }

    public ParametroSet getExamesJalis(ParametroSet param) throws SQLException {
        StringBuilder retorno = new StringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        String codigoFilial = param.getString("codigoFilial");
        String codigoConvenio = param.getString("codigoConvenio");
        boolean primeiraConexao = param.getBoolean("primeiraConexao");
        String codigoExame = "";
        if (!param.isNull(CODIGO_EXAME)) {
            codigoExame = param.getString(CODIGO_EXAME);
        }
        ParametroSet paramRetorno = new ParametroSet();
        StringBuilder buf = new StringBuilder();
        ArrayList<String> exames = new ArrayList<String>();
        if (primeiraConexao) {
            buf.append("select a.exa_codigo from exames a ");
            buf.append("where a.fil_codigo = ");
            buf.append(codigoFilial);
            if (!Funcoes.textoVazio(codigoExame)) {
                buf.append(" and a.exa_codigo = '").append(codigoExame).append("'");
            }
            ResultSet rs = this.conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                exames.add(rs.getString("exa_codigo"));
            }
        } else {
            try {
                String[] lista;
                buf.append(this.getOperacao(st, st2, codigoFilial, codigoConvenio, "exames"));
                for (String s : lista = StringUtil.getValores(buf.toString(), "exame")) {
                    String temp = StringUtil.getValor(s, "codigo");
                    if (Funcoes.textoVazio(temp)) continue;
                    exames.add(temp);
                }
                this.conexao.arquivaSQL();
            }
            catch (Exception ex) {
                try {
                    this.conexao.anulaSQL();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                exames.clear();
            }
        }
        if (!exames.isEmpty()) {
            retorno.append(this.getExames(codigoFilial, codigoConvenio, exames.toArray(new String[exames.size()])));
        } else {
            retorno.append("<exames></exames>");
        }
        this.conexao.fecharStatement(st);
        this.conexao.fecharStatement(st2);
        paramRetorno.setString("exames", retorno.toString());
        return paramRetorno;
    }

    private String getExames(String codigoFilial, String codigoConvenio, String[] exames) throws SQLException {
        StringBuilder retorno = new StringBuilder("<exames>");
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        for (String s : exames) {
            retorno.append(this.xmlExame(codigoFilial, codigoConvenio, s));
        }
        this.conexao.fecharStatement(st);
        this.conexao.fecharStatement(st2);
        return retorno.append("</exames>").toString();
    }

    private String xmlExame(String filial, String codigoConvenio, String exame) throws SQLException {
        StringBuilder retorno = new StringBuilder();
        Statement st = this.conexao.getStatement();
        Statement st2 = this.conexao.getStatement();
        Statement st3 = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select a.exa_codigo, a.exa_descricao, a.exa_sexo, a.exa_horaentrada, ");
        buf.append("a.exa_horasaida, a.exa_filtro, a.exa_diagnostico, a.exa_interferencia, a.exa_sinonimo, ");
        buf.append("a.exa_idademax, a.exa_idademin, a.exa_idademaxtipo, a.exa_idademintipo, ");
        buf.append("a.exa_qtdeamostras, a.exa_autorizacao, a.exa_proibido ");
        buf.append("from exames a ");
        buf.append("where a.fil_codigo = ");
        buf.append(filial);
        buf.append(" and exa_codigo = '");
        buf.append(exame);
        buf.append("'");
        ResultSet rs = this.conexao.executeQuery(st, buf.toString());
        while (rs.next()) {
            retorno.append("<exame><codigoexame>");
            retorno.append(rs.getString("exa_codigo"));
            retorno.append("</codigoexame><descricao>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_descricao")));
            retorno.append("</descricao><sexo>");
            retorno.append(rs.getString("exa_sexo"));
            retorno.append("</sexo><horaentrada>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_horaentrada")) ? "null" : rs.getString("exa_horaentrada"));
            retorno.append("</horaentrada><horasaida>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_horasaida")) ? "null" : rs.getString("exa_horasaida"));
            retorno.append("</horasaida><filtro>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_filtro")));
            retorno.append("</filtro><diagnostico>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_diagnostico")));
            retorno.append("</diagnostico><interferencia>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_interferencia")));
            retorno.append("</interferencia><sinonimo>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_sinonimo")));
            retorno.append("</sinonimo><idademax>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_idademax")) ? "null" : rs.getString("exa_idademax"));
            retorno.append("</idademax><idademin>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_idademin")) ? "null" : rs.getString("exa_idademin"));
            retorno.append("</idademin><idademaxtipo>");
            retorno.append(rs.getString("exa_idademaxtipo"));
            retorno.append("</idademaxtipo><idademintipo>");
            retorno.append(rs.getString("exa_idademintipo"));
            retorno.append("</idademintipo><qtdeamostras>");
            retorno.append(DBUtil.campoNull(rs.getString("exa_qtdeamostras")) ? "null" : rs.getString("exa_qtdeamostras"));
            retorno.append("</qtdeamostras><autorizacao>");
            retorno.append(StringUtil.textoXML(rs.getString("exa_autorizacao")));
            retorno.append("</autorizacao><proibido>");
            retorno.append(rs.getBoolean("exa_proibido") ? TRUE : FALSE);
            retorno.append("</proibido><setores>");
            buf.delete(0, buf.length());
            buf.append("select exa_codigo, set_codigo, ese_default from examesetor where fil_codigo = ");
            buf.append(filial);
            buf.append(" and exa_codigo = '");
            buf.append(rs.getString("exa_codigo"));
            buf.append("'");
            ResultSet rs2 = this.conexao.executeQuery(st2, buf.toString());
            while (rs2.next()) {
                retorno.append("<setor><codigoexame>");
                retorno.append(rs2.getString("exa_codigo"));
                retorno.append("</codigoexame><codigosetor>");
                retorno.append(rs2.getString("set_codigo"));
                retorno.append("</codigosetor><default>");
                retorno.append(rs2.getBoolean("ese_default") ? TRUE : FALSE);
                retorno.append("</default></setor>");
            }
            retorno.append(Util.criaXML("setor", rs2));
            retorno.append("</setores>");
            retorno.append("<materiais>");
            buf.delete(0, buf.length());
            buf.append("select a.exa_codigo, a.mco_codigo, a.emc_default, a.emc_pergunta, a.emc_preparo, a.emc_instrcoleta, a.");
            buf.append("emc_prepamostra, a.emc_inadequada, a.prz_codigo, a.met_codigo, a.emc_ordem, a.emc_pagina, a.");
            buf.append("emc_conservacao, a.emc_diasconserva, a.emc_temperaturainicial, a.emc_temperaturafinal, a.");
            buf.append("emc_referencia, a.emc_solicitarjejum, a.emc_obrigamedicamento, a.");
            buf.append("emc_marcarexterno, a.emc_obrigadum, a.emc_obrigapeso, a.emc_obrigaaltura, a.emc_obrigavolume, a.emc_obrigatempodiurese, ");
            buf.append("b.prz_descricao, c.met_descricao, d.mco_descricao ");
            buf.append("from examematcoleta a ");
            buf.append("left join prazoentrega b on a.fil_codigo = b.fil_codigo and a.prz_codigo = b.prz_codigo ");
            buf.append("left join metodologia c on a.fil_codigo = c.fil_codigo and a.met_codigo = c.met_codigo ");
            buf.append("left join materialcoleta d on a.fil_codigo = c.fil_codigo and a.mco_codigo = d.mco_codigo ");
            buf.append("where a.fil_codigo = ");
            buf.append(filial);
            buf.append(" and a.exa_codigo = '");
            buf.append(rs.getString("exa_codigo"));
            buf.append("'");
            buf.append(" and (a.emc_proibidoapoio is null OR a.emc_proibidoapoio = false) ");
            rs2 = this.conexao.executeQuery(st2, buf.toString());
            while (rs2.next()) {
                retorno.append("<material><codigoexame>");
                retorno.append(rs2.getString("exa_codigo"));
                retorno.append("</codigoexame><codigomaterial>");
                retorno.append(rs2.getString("mco_codigo"));
                retorno.append("</codigomaterial><descricaomaterial>");
                retorno.append(rs2.getString("mco_descricao"));
                retorno.append("</descricaomaterial><default>");
                retorno.append(rs2.getBoolean("emc_default") ? TRUE : FALSE);
                retorno.append("</default><pergunta>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_pergunta")));
                retorno.append("</pergunta><preparo>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_preparo")));
                retorno.append("</preparo><prepamostra>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_prepamostra")));
                retorno.append("</prepamostra><instrcoleta>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_instrcoleta")));
                retorno.append("</instrcoleta><inadequada>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_inadequada")));
                retorno.append("</inadequada><codigoprazo>");
                retorno.append(this.pegaPrazoEntregaConvenio(filial, rs2.getString("prz_codigo"), rs2.getString("exa_codigo"), rs2.getString("mco_codigo"), codigoConvenio));
                retorno.append("</codigoprazo><codigometodo>");
                retorno.append(rs2.getString("met_codigo"));
                retorno.append("</codigometodo><ordem>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_ordem")) ? "null" : rs2.getString("emc_ordem"));
                retorno.append("</ordem><pagina>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_pagina")) ? "null" : rs2.getString("emc_pagina"));
                retorno.append("</pagina><conservacao>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_conservacao")));
                retorno.append("</conservacao><diasconserva>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_diasconserva")) ? "null" : rs2.getString("emc_diasconserva"));
                retorno.append("</diasconserva><temperaturainicial>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_temperaturainicial")) ? "null" : rs2.getString("emc_temperaturainicial"));
                retorno.append("</temperaturainicial><temperaturafinal>");
                retorno.append(DBUtil.campoNull(rs2.getString("emc_temperaturafinal")) ? "null" : rs2.getString("emc_temperaturafinal"));
                retorno.append("</temperaturafinal><referencia>");
                retorno.append(StringUtil.textoXML(rs2.getString("emc_referencia")));
                retorno.append("</referencia><solicitarjejum>");
                retorno.append(rs2.getBoolean("emc_solicitarjejum") ? TRUE : FALSE);
                retorno.append("</solicitarjejum><obrigamedicamento>");
                retorno.append(rs2.getBoolean("emc_obrigamedicamento") ? TRUE : FALSE);
                retorno.append("</obrigamedicamento><marcarexterno>");
                retorno.append(rs2.getBoolean("emc_marcarexterno") ? TRUE : FALSE);
                retorno.append("</marcarexterno><obrigadum>");
                retorno.append(rs2.getBoolean("emc_obrigadum") ? TRUE : FALSE);
                retorno.append("</obrigadum><obrigapeso>");
                retorno.append(rs2.getBoolean("emc_obrigapeso") ? TRUE : FALSE);
                retorno.append("</obrigapeso><obrigaaltura>");
                retorno.append(rs2.getBoolean("emc_obrigaaltura") ? TRUE : FALSE);
                retorno.append("</obrigaaltura><obrigavolume>");
                retorno.append(rs2.getBoolean("emc_obrigavolume") ? TRUE : FALSE);
                retorno.append("</obrigavolume><obrigatempodiurese>");
                retorno.append(rs2.getBoolean("emc_obrigatempodiurese") ? TRUE : FALSE);
                retorno.append("</obrigatempodiurese><descricaoprazo>");
                retorno.append(rs2.getString("prz_descricao"));
                retorno.append("</descricaoprazo><descricaometodo>");
                retorno.append(rs2.getString("met_descricao"));
                retorno.append("</descricaometodo>");
                buf.delete(0, buf.length());
                buf.append("select exa_codigo, mco_codigo, prc_codigo, exp_mensagem ");
                buf.append("from examesprincipios ");
                buf.append("where fil_codigo = ");
                buf.append(filial);
                buf.append(" and exa_codigo = '");
                buf.append(rs2.getString("exa_codigo"));
                buf.append("' and mco_codigo = ");
                buf.append(rs2.getString("mco_codigo"));
                ResultSet rs3 = this.conexao.executeQuery(st3, buf.toString());
                if (rs3.next()) {
                    retorno.append("<principios>");
                    do {
                        retorno.append("<principio><codigoexame>");
                        retorno.append(rs3.getString("exa_codigo"));
                        retorno.append("</codigoexame><codigomaterial>");
                        retorno.append(rs3.getString("mco_codigo"));
                        retorno.append("</codigomaterial><codigoprincipio>");
                        retorno.append(rs3.getString("prc_codigo"));
                        retorno.append("</codigoprincipio><mensagem>");
                        retorno.append(rs3.getString("exp_mensagem"));
                        retorno.append("</mensagem></principio>");
                    } while (rs3.next());
                    retorno.append("</principios>");
                }
                retorno.append("</material>");
            }
            retorno.append("</materiais>");
            retorno.append("</exame>");
        }
        this.conexao.fecharStatement(st3);
        this.conexao.fecharStatement(st2);
        this.conexao.fecharStatement(st);
        return retorno.toString();
    }

    private String pegaPrazoEntregaConvenio(String codigoFilial, String prazoOriginal, String exame, String material, String convenio) throws SQLException {
        String retorno = prazoOriginal;
        Statement st = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select prz_codigo from examematconvenioprazo where fil_codigo = ").append(codigoFilial);
        buf.append(" and exa_codigo = '").append(exame).append("' ");
        buf.append(" and mco_codigo = ").append(material);
        buf.append(" and con_codigo = ").append(convenio);
        ResultSet rs = this.conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            retorno = rs.getString("prz_codigo");
        }
        this.conexao.fecharStatement(st);
        return retorno;
    }

    private String getOperacao(Statement st, Statement st2, String filial, String convenio, String tabela) throws SQLException {
        StringBuilder bui = new StringBuilder();
        StringBuilder buf = new StringBuilder();
        bui.append("select epa_codigo, epa_operacao from exportaapoio where fil_codigo = ");
        bui.append(filial);
        bui.append(" and con_codigo = ");
        bui.append(convenio);
        bui.append(" and epa_tabela = '");
        bui.append(tabela);
        bui.append("' and (epa_exportado = false or epa_exportado is null) order by epa_codigo ");
        ResultSet rs = this.conexao.executeQuery(st, bui.toString());
        bui.delete(0, bui.length());
        while (rs.next()) {
            buf.delete(0, buf.length());
            buf.append("update exportaapoio set epa_exportado = true where fil_codigo = ");
            buf.append(filial);
            buf.append(" and epa_codigo = ");
            buf.append(rs.getString("epa_codigo"));
            this.conexao.executeUpdate(filial, st2, buf.toString(), true);
            buf.delete(0, buf.length());
            buf.append("delete from exportaapoio where fil_codigo = ").append(filial);
            buf.append(" and con_codigo = ").append(convenio);
            buf.append(" and epa_datahora < current_date - 60 and epa_exportado = true ");
            this.conexao.executeUpdate(filial, st2, buf.toString(), true);
            bui.append(rs.getString("epa_operacao"));
        }
        return bui.toString();
    }

    private boolean verificaMedico(int filial, String conselho, String crm, String uf) throws SQLException {
        Statement st = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select med_nome from medico where fil_codigo = ").append(filial).append(" and ");
        buf.append("med_conselho = '").append(conselho).append("' and ");
        buf.append("med_crm = '").append(crm).append("' and ");
        buf.append("med_uf = '").append(uf).append("' ");
        boolean retorno = this.conexao.executeQuery(st, buf.toString()).next();
        this.conexao.fecharStatement(st);
        return retorno;
    }

    private int getConvenioApoio(int filial, int codigoConvenio, int codigoConvenioApoiado) throws SQLException {
        Statement st = this.conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select cap_convenioapoio from convenioapoiado where fil_codigo = ").append(filial);
        buf.append("and con_codigo = ").append(codigoConvenio);
        buf.append("and cap_convenioapoiado = ").append(codigoConvenioApoiado);
        ResultSet rs = this.conexao.executeQuery(st, buf.toString());
        if (rs.next()) {
            return rs.getInt("cap_convenioapoio");
        }
        this.conexao.fecharStatement(st);
        return codigoConvenio;
    }
}

